package machinelearningservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/machinelearningservices/mgmt/2021-04-01/machinelearningservices"

// ACIServiceCreateRequest ...
type ACIServiceCreateRequest struct {
	// ContainerResourceRequirements - The container resource requirements.
	ContainerResourceRequirements *ContainerResourceRequirements `json:"containerResourceRequirements,omitempty"`
	// AuthEnabled - Whether or not authentication is enabled on the service.
	AuthEnabled *bool `json:"authEnabled,omitempty"`
	// SslEnabled - Whether or not SSL is enabled.
	SslEnabled *bool `json:"sslEnabled,omitempty"`
	// AppInsightsEnabled - Whether or not Application Insights is enabled.
	AppInsightsEnabled *bool `json:"appInsightsEnabled,omitempty"`
	// DataCollection - Details of the data collection options specified.
	DataCollection *ACIServiceCreateRequestDataCollection `json:"dataCollection,omitempty"`
	// SslCertificate - The public SSL certificate in PEM format to use if SSL is enabled.
	SslCertificate *string `json:"sslCertificate,omitempty"`
	// SslKey - The public SSL key in PEM format for the certificate.
	SslKey *string `json:"sslKey,omitempty"`
	// Cname - The CName for the service.
	Cname *string `json:"cname,omitempty"`
	// DNSNameLabel - The Dns label for the service.
	DNSNameLabel *string `json:"dnsNameLabel,omitempty"`
	// VnetConfiguration - The virtual network configuration.
	VnetConfiguration *ACIServiceCreateRequestVnetConfiguration `json:"vnetConfiguration,omitempty"`
	// EncryptionProperties - The encryption properties.
	EncryptionProperties *ACIServiceCreateRequestEncryptionProperties `json:"encryptionProperties,omitempty"`
	// Description - The description of the service.
	Description *string `json:"description,omitempty"`
	// KvTags - The service tag dictionary. Tags are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The service properties dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// Keys - The authentication keys.
	Keys *CreateServiceRequestKeys `json:"keys,omitempty"`
	// EnvironmentImageRequest - The Environment, models and assets needed for inferencing.
	EnvironmentImageRequest *CreateServiceRequestEnvironmentImageRequest `json:"environmentImageRequest,omitempty"`
	// Location - The name of the Azure location/region.
	Location *string `json:"location,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicCreateServiceRequestComputeTypeCreateServiceRequest', 'ComputeTypeBasicCreateServiceRequestComputeTypeACI', 'ComputeTypeBasicCreateServiceRequestComputeTypeAKS', 'ComputeTypeBasicCreateServiceRequestComputeTypeCustom'
	ComputeType ComputeTypeBasicCreateServiceRequest `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for ACIServiceCreateRequest.
func (ascr ACIServiceCreateRequest) MarshalJSON() ([]byte, error) {
	ascr.ComputeType = ComputeTypeBasicCreateServiceRequestComputeTypeACI
	objectMap := make(map[string]interface{})
	if ascr.ContainerResourceRequirements != nil {
		objectMap["containerResourceRequirements"] = ascr.ContainerResourceRequirements
	}
	if ascr.AuthEnabled != nil {
		objectMap["authEnabled"] = ascr.AuthEnabled
	}
	if ascr.SslEnabled != nil {
		objectMap["sslEnabled"] = ascr.SslEnabled
	}
	if ascr.AppInsightsEnabled != nil {
		objectMap["appInsightsEnabled"] = ascr.AppInsightsEnabled
	}
	if ascr.DataCollection != nil {
		objectMap["dataCollection"] = ascr.DataCollection
	}
	if ascr.SslCertificate != nil {
		objectMap["sslCertificate"] = ascr.SslCertificate
	}
	if ascr.SslKey != nil {
		objectMap["sslKey"] = ascr.SslKey
	}
	if ascr.Cname != nil {
		objectMap["cname"] = ascr.Cname
	}
	if ascr.DNSNameLabel != nil {
		objectMap["dnsNameLabel"] = ascr.DNSNameLabel
	}
	if ascr.VnetConfiguration != nil {
		objectMap["vnetConfiguration"] = ascr.VnetConfiguration
	}
	if ascr.EncryptionProperties != nil {
		objectMap["encryptionProperties"] = ascr.EncryptionProperties
	}
	if ascr.Description != nil {
		objectMap["description"] = ascr.Description
	}
	if ascr.KvTags != nil {
		objectMap["kvTags"] = ascr.KvTags
	}
	if ascr.Properties != nil {
		objectMap["properties"] = ascr.Properties
	}
	if ascr.Keys != nil {
		objectMap["keys"] = ascr.Keys
	}
	if ascr.EnvironmentImageRequest != nil {
		objectMap["environmentImageRequest"] = ascr.EnvironmentImageRequest
	}
	if ascr.Location != nil {
		objectMap["location"] = ascr.Location
	}
	if ascr.ComputeType != "" {
		objectMap["computeType"] = ascr.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsACIServiceCreateRequest is the BasicCreateServiceRequest implementation for ACIServiceCreateRequest.
func (ascr ACIServiceCreateRequest) AsACIServiceCreateRequest() (*ACIServiceCreateRequest, bool) {
	return &ascr, true
}

// AsAKSServiceCreateRequest is the BasicCreateServiceRequest implementation for ACIServiceCreateRequest.
func (ascr ACIServiceCreateRequest) AsAKSServiceCreateRequest() (*AKSServiceCreateRequest, bool) {
	return nil, false
}

// AsCreateEndpointVariantRequest is the BasicCreateServiceRequest implementation for ACIServiceCreateRequest.
func (ascr ACIServiceCreateRequest) AsCreateEndpointVariantRequest() (*CreateEndpointVariantRequest, bool) {
	return nil, false
}

// AsBasicCreateEndpointVariantRequest is the BasicCreateServiceRequest implementation for ACIServiceCreateRequest.
func (ascr ACIServiceCreateRequest) AsBasicCreateEndpointVariantRequest() (BasicCreateEndpointVariantRequest, bool) {
	return nil, false
}

// AsCreateServiceRequest is the BasicCreateServiceRequest implementation for ACIServiceCreateRequest.
func (ascr ACIServiceCreateRequest) AsCreateServiceRequest() (*CreateServiceRequest, bool) {
	return nil, false
}

// AsBasicCreateServiceRequest is the BasicCreateServiceRequest implementation for ACIServiceCreateRequest.
func (ascr ACIServiceCreateRequest) AsBasicCreateServiceRequest() (BasicCreateServiceRequest, bool) {
	return &ascr, true
}

// ACIServiceCreateRequestDataCollection details of the data collection options specified.
type ACIServiceCreateRequestDataCollection struct {
	// EventHubEnabled - Option for enabling/disabling Event Hub.
	EventHubEnabled *bool `json:"eventHubEnabled,omitempty"`
	// StorageEnabled - Option for enabling/disabling storage.
	StorageEnabled *bool `json:"storageEnabled,omitempty"`
}

// ACIServiceCreateRequestEncryptionProperties the encryption properties.
type ACIServiceCreateRequestEncryptionProperties struct {
	// VaultBaseURL - vault base Url
	VaultBaseURL *string `json:"vaultBaseUrl,omitempty"`
	// KeyName - Encryption Key name
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - Encryption Key Version
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// ACIServiceCreateRequestVnetConfiguration the virtual network configuration.
type ACIServiceCreateRequestVnetConfiguration struct {
	// VnetName - The name of the virtual network.
	VnetName *string `json:"vnetName,omitempty"`
	// SubnetName - The name of the virtual network subnet.
	SubnetName *string `json:"subnetName,omitempty"`
}

// ACIServiceResponse the response for an ACI service.
type ACIServiceResponse struct {
	// ContainerResourceRequirements - The container resource requirements.
	ContainerResourceRequirements *ContainerResourceRequirements `json:"containerResourceRequirements,omitempty"`
	// ScoringURI - READ-ONLY; The Uri for sending scoring requests.
	ScoringURI *string `json:"scoringUri,omitempty"`
	// Location - The name of the Azure location/region.
	Location *string `json:"location,omitempty"`
	// AuthEnabled - Whether or not authentication is enabled on the service.
	AuthEnabled *bool `json:"authEnabled,omitempty"`
	// SslEnabled - Whether or not SSL is enabled.
	SslEnabled *bool `json:"sslEnabled,omitempty"`
	// AppInsightsEnabled - Whether or not Application Insights is enabled.
	AppInsightsEnabled *bool `json:"appInsightsEnabled,omitempty"`
	// DataCollection - Details of the data collection options specified.
	DataCollection *ACIServiceResponseDataCollection `json:"dataCollection,omitempty"`
	// SslCertificate - The public SSL certificate in PEM format to use if SSL is enabled.
	SslCertificate *string `json:"sslCertificate,omitempty"`
	// SslKey - The public SSL key in PEM format for the certificate.
	SslKey *string `json:"sslKey,omitempty"`
	// Cname - The CName for the service.
	Cname *string `json:"cname,omitempty"`
	// PublicIP - The public IP address for the service.
	PublicIP *string `json:"publicIp,omitempty"`
	// PublicFqdn - The public Fqdn for the service.
	PublicFqdn *string `json:"publicFqdn,omitempty"`
	// SwaggerURI - READ-ONLY; The Uri for sending swagger requests.
	SwaggerURI *string `json:"swaggerUri,omitempty"`
	// ModelConfigMap - READ-ONLY; Details on the models and configurations.
	ModelConfigMap map[string]interface{} `json:"modelConfigMap"`
	// ModelsProperty - The list of models.
	ModelsProperty *[]Model `json:"models,omitempty"`
	// EnvironmentImageRequest - The Environment, models and assets used for inferencing.
	EnvironmentImageRequest *ACIServiceResponseEnvironmentImageRequest `json:"environmentImageRequest,omitempty"`
	// VnetConfiguration - The virtual network configuration.
	VnetConfiguration *ACIServiceResponseVnetConfiguration `json:"vnetConfiguration,omitempty"`
	// EncryptionProperties - The encryption properties.
	EncryptionProperties *ACIServiceResponseEncryptionProperties `json:"encryptionProperties,omitempty"`
	// Description - The service description.
	Description *string `json:"description,omitempty"`
	// KvTags - The service tag dictionary. Tags are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The service property dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// State - READ-ONLY; The current state of the service. Possible values include: 'WebServiceStateTransitioning', 'WebServiceStateHealthy', 'WebServiceStateUnhealthy', 'WebServiceStateFailed', 'WebServiceStateUnschedulable'
	State WebServiceState `json:"state,omitempty"`
	// Error - READ-ONLY; The error details.
	Error *ServiceResponseBaseError `json:"error,omitempty"`
	// DeploymentType - The deployment type for the service. Possible values include: 'DeploymentTypeGRPCRealtimeEndpoint', 'DeploymentTypeHTTPRealtimeEndpoint', 'DeploymentTypeBatch'
	DeploymentType DeploymentType `json:"deploymentType,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicServiceResponseBaseComputeTypeServiceResponseBase', 'ComputeTypeBasicServiceResponseBaseComputeTypeACI', 'ComputeTypeBasicServiceResponseBaseComputeTypeCustom', 'ComputeTypeBasicServiceResponseBaseComputeTypeAKS'
	ComputeType ComputeTypeBasicServiceResponseBase `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for ACIServiceResponse.
func (asr ACIServiceResponse) MarshalJSON() ([]byte, error) {
	asr.ComputeType = ComputeTypeBasicServiceResponseBaseComputeTypeACI
	objectMap := make(map[string]interface{})
	if asr.ContainerResourceRequirements != nil {
		objectMap["containerResourceRequirements"] = asr.ContainerResourceRequirements
	}
	if asr.Location != nil {
		objectMap["location"] = asr.Location
	}
	if asr.AuthEnabled != nil {
		objectMap["authEnabled"] = asr.AuthEnabled
	}
	if asr.SslEnabled != nil {
		objectMap["sslEnabled"] = asr.SslEnabled
	}
	if asr.AppInsightsEnabled != nil {
		objectMap["appInsightsEnabled"] = asr.AppInsightsEnabled
	}
	if asr.DataCollection != nil {
		objectMap["dataCollection"] = asr.DataCollection
	}
	if asr.SslCertificate != nil {
		objectMap["sslCertificate"] = asr.SslCertificate
	}
	if asr.SslKey != nil {
		objectMap["sslKey"] = asr.SslKey
	}
	if asr.Cname != nil {
		objectMap["cname"] = asr.Cname
	}
	if asr.PublicIP != nil {
		objectMap["publicIp"] = asr.PublicIP
	}
	if asr.PublicFqdn != nil {
		objectMap["publicFqdn"] = asr.PublicFqdn
	}
	if asr.ModelsProperty != nil {
		objectMap["models"] = asr.ModelsProperty
	}
	if asr.EnvironmentImageRequest != nil {
		objectMap["environmentImageRequest"] = asr.EnvironmentImageRequest
	}
	if asr.VnetConfiguration != nil {
		objectMap["vnetConfiguration"] = asr.VnetConfiguration
	}
	if asr.EncryptionProperties != nil {
		objectMap["encryptionProperties"] = asr.EncryptionProperties
	}
	if asr.Description != nil {
		objectMap["description"] = asr.Description
	}
	if asr.KvTags != nil {
		objectMap["kvTags"] = asr.KvTags
	}
	if asr.Properties != nil {
		objectMap["properties"] = asr.Properties
	}
	if asr.DeploymentType != "" {
		objectMap["deploymentType"] = asr.DeploymentType
	}
	if asr.ComputeType != "" {
		objectMap["computeType"] = asr.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsACIServiceResponse is the BasicServiceResponseBase implementation for ACIServiceResponse.
func (asr ACIServiceResponse) AsACIServiceResponse() (*ACIServiceResponse, bool) {
	return &asr, true
}

// AsAKSVariantResponse is the BasicServiceResponseBase implementation for ACIServiceResponse.
func (asr ACIServiceResponse) AsAKSVariantResponse() (*AKSVariantResponse, bool) {
	return nil, false
}

// AsBasicAKSVariantResponse is the BasicServiceResponseBase implementation for ACIServiceResponse.
func (asr ACIServiceResponse) AsBasicAKSVariantResponse() (BasicAKSVariantResponse, bool) {
	return nil, false
}

// AsAKSServiceResponse is the BasicServiceResponseBase implementation for ACIServiceResponse.
func (asr ACIServiceResponse) AsAKSServiceResponse() (*AKSServiceResponse, bool) {
	return nil, false
}

// AsServiceResponseBase is the BasicServiceResponseBase implementation for ACIServiceResponse.
func (asr ACIServiceResponse) AsServiceResponseBase() (*ServiceResponseBase, bool) {
	return nil, false
}

// AsBasicServiceResponseBase is the BasicServiceResponseBase implementation for ACIServiceResponse.
func (asr ACIServiceResponse) AsBasicServiceResponseBase() (BasicServiceResponseBase, bool) {
	return &asr, true
}

// ACIServiceResponseDataCollection details of the data collection options specified.
type ACIServiceResponseDataCollection struct {
	// EventHubEnabled - Option for enabling/disabling Event Hub.
	EventHubEnabled *bool `json:"eventHubEnabled,omitempty"`
	// StorageEnabled - Option for enabling/disabling storage.
	StorageEnabled *bool `json:"storageEnabled,omitempty"`
}

// ACIServiceResponseEncryptionProperties the encryption properties.
type ACIServiceResponseEncryptionProperties struct {
	// VaultBaseURL - vault base Url
	VaultBaseURL *string `json:"vaultBaseUrl,omitempty"`
	// KeyName - Encryption Key name
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - Encryption Key Version
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// ACIServiceResponseEnvironmentImageRequest the Environment, models and assets used for inferencing.
type ACIServiceResponseEnvironmentImageRequest struct {
	// DriverProgram - The name of the driver file.
	DriverProgram *string `json:"driverProgram,omitempty"`
	// Assets - The list of assets.
	Assets *[]ImageAsset `json:"assets,omitempty"`
	// ModelIds - The list of model Ids.
	ModelIds *[]string `json:"modelIds,omitempty"`
	// ModelsProperty - The list of models.
	ModelsProperty *[]Model `json:"models,omitempty"`
	// Environment - The details of the AZURE ML environment.
	Environment *EnvironmentImageResponseEnvironment `json:"environment,omitempty"`
	// EnvironmentReference - The unique identifying details of the AZURE ML environment.
	EnvironmentReference *EnvironmentImageResponseEnvironmentReference `json:"environmentReference,omitempty"`
}

// ACIServiceResponseVnetConfiguration the virtual network configuration.
type ACIServiceResponseVnetConfiguration struct {
	// VnetName - The name of the virtual network.
	VnetName *string `json:"vnetName,omitempty"`
	// SubnetName - The name of the virtual network subnet.
	SubnetName *string `json:"subnetName,omitempty"`
}

// AKS a Machine Learning compute based on AKS.
type AKS struct {
	// Properties - AKS properties
	Properties *AKSProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AKS.
func (a AKS) MarshalJSON() ([]byte, error) {
	a.ComputeType = ComputeTypeBasicComputeComputeTypeAKS
	objectMap := make(map[string]interface{})
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	if a.ComputeLocation != nil {
		objectMap["computeLocation"] = a.ComputeLocation
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.ResourceID != nil {
		objectMap["resourceId"] = a.ResourceID
	}
	if a.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = a.DisableLocalAuth
	}
	if a.ComputeType != "" {
		objectMap["computeType"] = a.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for AKS.
func (a AKS) AsAKS() (*AKS, bool) {
	return &a, true
}

// AsAmlCompute is the BasicCompute implementation for AKS.
func (a AKS) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for AKS.
func (a AKS) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for AKS.
func (a AKS) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for AKS.
func (a AKS) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for AKS.
func (a AKS) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for AKS.
func (a AKS) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for AKS.
func (a AKS) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for AKS.
func (a AKS) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for AKS.
func (a AKS) AsBasicCompute() (BasicCompute, bool) {
	return &a, true
}

// AksComputeSecrets secrets related to a Machine Learning compute based on AKS.
type AksComputeSecrets struct {
	// UserKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string `json:"userKubeConfig,omitempty"`
	// AdminKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string `json:"adminKubeConfig,omitempty"`
	// ImagePullSecretName - Image registry pull secret.
	ImagePullSecretName *string `json:"imagePullSecretName,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine', 'ComputeTypeBasicComputeSecretsComputeTypeDatabricks'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AksComputeSecrets.
func (acs AksComputeSecrets) MarshalJSON() ([]byte, error) {
	acs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeAKS
	objectMap := make(map[string]interface{})
	if acs.UserKubeConfig != nil {
		objectMap["userKubeConfig"] = acs.UserKubeConfig
	}
	if acs.AdminKubeConfig != nil {
		objectMap["adminKubeConfig"] = acs.AdminKubeConfig
	}
	if acs.ImagePullSecretName != nil {
		objectMap["imagePullSecretName"] = acs.ImagePullSecretName
	}
	if acs.ComputeType != "" {
		objectMap["computeType"] = acs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return &acs, true
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsDatabricksComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &acs, true
}

// AksNetworkingConfiguration advance configuration for AKS networking
type AksNetworkingConfiguration struct {
	// SubnetID - Virtual network subnet resource ID the compute nodes belong to
	SubnetID *string `json:"subnetId,omitempty"`
	// ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
	// DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`
	// DockerBridgeCidr - A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`
}

// AKSProperties AKS properties
type AKSProperties struct {
	// ClusterFqdn - Cluster full qualified domain name
	ClusterFqdn *string `json:"clusterFqdn,omitempty"`
	// SystemServices - READ-ONLY; System services
	SystemServices *[]SystemService `json:"systemServices,omitempty"`
	// AgentCount - Number of agents
	AgentCount *int32 `json:"agentCount,omitempty"`
	// AgentVMSize - Agent virtual machine size
	AgentVMSize *string `json:"agentVmSize,omitempty"`
	// ClusterPurpose - Intended usage of the cluster. Possible values include: 'ClusterPurposeFastProd', 'ClusterPurposeDenseProd', 'ClusterPurposeDevTest'
	ClusterPurpose ClusterPurpose `json:"clusterPurpose,omitempty"`
	// SslConfiguration - SSL configuration
	SslConfiguration *SslConfiguration `json:"sslConfiguration,omitempty"`
	// AksNetworkingConfiguration - AKS networking configuration for vnet
	AksNetworkingConfiguration *AksNetworkingConfiguration `json:"aksNetworkingConfiguration,omitempty"`
	// LoadBalancerType - Load Balancer Type. Possible values include: 'LoadBalancerTypePublicIP', 'LoadBalancerTypeInternalLoadBalancer'
	LoadBalancerType LoadBalancerType `json:"loadBalancerType,omitempty"`
	// LoadBalancerSubnet - Load Balancer Subnet
	LoadBalancerSubnet *string `json:"loadBalancerSubnet,omitempty"`
}

// MarshalJSON is the custom marshaler for AKSProperties.
func (a AKSProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ClusterFqdn != nil {
		objectMap["clusterFqdn"] = a.ClusterFqdn
	}
	if a.AgentCount != nil {
		objectMap["agentCount"] = a.AgentCount
	}
	if a.AgentVMSize != nil {
		objectMap["agentVmSize"] = a.AgentVMSize
	}
	if a.ClusterPurpose != "" {
		objectMap["clusterPurpose"] = a.ClusterPurpose
	}
	if a.SslConfiguration != nil {
		objectMap["sslConfiguration"] = a.SslConfiguration
	}
	if a.AksNetworkingConfiguration != nil {
		objectMap["aksNetworkingConfiguration"] = a.AksNetworkingConfiguration
	}
	if a.LoadBalancerType != "" {
		objectMap["loadBalancerType"] = a.LoadBalancerType
	}
	if a.LoadBalancerSubnet != nil {
		objectMap["loadBalancerSubnet"] = a.LoadBalancerSubnet
	}
	return json.Marshal(objectMap)
}

// AKSReplicaStatus ...
type AKSReplicaStatus struct {
	// DesiredReplicas - The desired number of replicas.
	DesiredReplicas *int32 `json:"desiredReplicas,omitempty"`
	// UpdatedReplicas - The number of updated replicas.
	UpdatedReplicas *int32 `json:"updatedReplicas,omitempty"`
	// AvailableReplicas - The number of available replicas.
	AvailableReplicas *int32 `json:"availableReplicas,omitempty"`
	// Error - The error details.
	Error *AKSReplicaStatusError `json:"error,omitempty"`
}

// AKSReplicaStatusError the error details.
type AKSReplicaStatusError struct {
	// Error - READ-ONLY; The error response.
	Error *ErrorResponse `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for AKSReplicaStatusError.
func (ars AKSReplicaStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AKSServiceCreateRequest the request to create an AKS service.
type AKSServiceCreateRequest struct {
	// NumReplicas - The number of replicas on the cluster.
	NumReplicas *int32 `json:"numReplicas,omitempty"`
	// DataCollection - Details of the data collection options specified.
	DataCollection *AKSServiceCreateRequestDataCollection `json:"dataCollection,omitempty"`
	// ComputeName - The name of the compute resource.
	ComputeName *string `json:"computeName,omitempty"`
	// AppInsightsEnabled - Whether or not Application Insights is enabled.
	AppInsightsEnabled *bool `json:"appInsightsEnabled,omitempty"`
	// AutoScaler - The auto scaler properties.
	AutoScaler *AKSServiceCreateRequestAutoScaler `json:"autoScaler,omitempty"`
	// ContainerResourceRequirements - The container resource requirements.
	ContainerResourceRequirements *ContainerResourceRequirements `json:"containerResourceRequirements,omitempty"`
	// MaxConcurrentRequestsPerContainer - The maximum number of concurrent requests per container.
	MaxConcurrentRequestsPerContainer *int32 `json:"maxConcurrentRequestsPerContainer,omitempty"`
	// MaxQueueWaitMs - Maximum time a request will wait in the queue (in milliseconds). After this time, the service will return 503 (Service Unavailable)
	MaxQueueWaitMs *int32 `json:"maxQueueWaitMs,omitempty"`
	// Namespace - Kubernetes namespace for the service.
	Namespace *string `json:"namespace,omitempty"`
	// ScoringTimeoutMs - The scoring timeout in milliseconds.
	ScoringTimeoutMs *int32 `json:"scoringTimeoutMs,omitempty"`
	// AuthEnabled - Whether or not authentication is enabled.
	AuthEnabled *bool `json:"authEnabled,omitempty"`
	// LivenessProbeRequirements - The liveness probe requirements.
	LivenessProbeRequirements *AKSServiceCreateRequestLivenessProbeRequirements `json:"livenessProbeRequirements,omitempty"`
	// AadAuthEnabled - Whether or not AAD authentication is enabled.
	AadAuthEnabled *bool `json:"aadAuthEnabled,omitempty"`
	// IsDefault - Is this the default variant.
	IsDefault *bool `json:"isDefault,omitempty"`
	// TrafficPercentile - The amount of traffic variant receives.
	TrafficPercentile *float64 `json:"trafficPercentile,omitempty"`
	// Type - The type of the variant. Possible values include: 'VariantTypeControl', 'VariantTypeTreatment'
	Type VariantType `json:"type,omitempty"`
	// Description - The description of the service.
	Description *string `json:"description,omitempty"`
	// KvTags - The service tag dictionary. Tags are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The service properties dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// Keys - The authentication keys.
	Keys *CreateServiceRequestKeys `json:"keys,omitempty"`
	// EnvironmentImageRequest - The Environment, models and assets needed for inferencing.
	EnvironmentImageRequest *CreateServiceRequestEnvironmentImageRequest `json:"environmentImageRequest,omitempty"`
	// Location - The name of the Azure location/region.
	Location *string `json:"location,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicCreateServiceRequestComputeTypeCreateServiceRequest', 'ComputeTypeBasicCreateServiceRequestComputeTypeACI', 'ComputeTypeBasicCreateServiceRequestComputeTypeAKS', 'ComputeTypeBasicCreateServiceRequestComputeTypeCustom'
	ComputeType ComputeTypeBasicCreateServiceRequest `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AKSServiceCreateRequest.
func (ascr AKSServiceCreateRequest) MarshalJSON() ([]byte, error) {
	ascr.ComputeType = ComputeTypeBasicCreateServiceRequestComputeTypeAKS
	objectMap := make(map[string]interface{})
	if ascr.NumReplicas != nil {
		objectMap["numReplicas"] = ascr.NumReplicas
	}
	if ascr.DataCollection != nil {
		objectMap["dataCollection"] = ascr.DataCollection
	}
	if ascr.ComputeName != nil {
		objectMap["computeName"] = ascr.ComputeName
	}
	if ascr.AppInsightsEnabled != nil {
		objectMap["appInsightsEnabled"] = ascr.AppInsightsEnabled
	}
	if ascr.AutoScaler != nil {
		objectMap["autoScaler"] = ascr.AutoScaler
	}
	if ascr.ContainerResourceRequirements != nil {
		objectMap["containerResourceRequirements"] = ascr.ContainerResourceRequirements
	}
	if ascr.MaxConcurrentRequestsPerContainer != nil {
		objectMap["maxConcurrentRequestsPerContainer"] = ascr.MaxConcurrentRequestsPerContainer
	}
	if ascr.MaxQueueWaitMs != nil {
		objectMap["maxQueueWaitMs"] = ascr.MaxQueueWaitMs
	}
	if ascr.Namespace != nil {
		objectMap["namespace"] = ascr.Namespace
	}
	if ascr.ScoringTimeoutMs != nil {
		objectMap["scoringTimeoutMs"] = ascr.ScoringTimeoutMs
	}
	if ascr.AuthEnabled != nil {
		objectMap["authEnabled"] = ascr.AuthEnabled
	}
	if ascr.LivenessProbeRequirements != nil {
		objectMap["livenessProbeRequirements"] = ascr.LivenessProbeRequirements
	}
	if ascr.AadAuthEnabled != nil {
		objectMap["aadAuthEnabled"] = ascr.AadAuthEnabled
	}
	if ascr.IsDefault != nil {
		objectMap["isDefault"] = ascr.IsDefault
	}
	if ascr.TrafficPercentile != nil {
		objectMap["trafficPercentile"] = ascr.TrafficPercentile
	}
	if ascr.Type != "" {
		objectMap["type"] = ascr.Type
	}
	if ascr.Description != nil {
		objectMap["description"] = ascr.Description
	}
	if ascr.KvTags != nil {
		objectMap["kvTags"] = ascr.KvTags
	}
	if ascr.Properties != nil {
		objectMap["properties"] = ascr.Properties
	}
	if ascr.Keys != nil {
		objectMap["keys"] = ascr.Keys
	}
	if ascr.EnvironmentImageRequest != nil {
		objectMap["environmentImageRequest"] = ascr.EnvironmentImageRequest
	}
	if ascr.Location != nil {
		objectMap["location"] = ascr.Location
	}
	if ascr.ComputeType != "" {
		objectMap["computeType"] = ascr.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsACIServiceCreateRequest is the BasicCreateServiceRequest implementation for AKSServiceCreateRequest.
func (ascr AKSServiceCreateRequest) AsACIServiceCreateRequest() (*ACIServiceCreateRequest, bool) {
	return nil, false
}

// AsAKSServiceCreateRequest is the BasicCreateServiceRequest implementation for AKSServiceCreateRequest.
func (ascr AKSServiceCreateRequest) AsAKSServiceCreateRequest() (*AKSServiceCreateRequest, bool) {
	return &ascr, true
}

// AsCreateEndpointVariantRequest is the BasicCreateServiceRequest implementation for AKSServiceCreateRequest.
func (ascr AKSServiceCreateRequest) AsCreateEndpointVariantRequest() (*CreateEndpointVariantRequest, bool) {
	return nil, false
}

// AsBasicCreateEndpointVariantRequest is the BasicCreateServiceRequest implementation for AKSServiceCreateRequest.
func (ascr AKSServiceCreateRequest) AsBasicCreateEndpointVariantRequest() (BasicCreateEndpointVariantRequest, bool) {
	return &ascr, true
}

// AsCreateServiceRequest is the BasicCreateServiceRequest implementation for AKSServiceCreateRequest.
func (ascr AKSServiceCreateRequest) AsCreateServiceRequest() (*CreateServiceRequest, bool) {
	return nil, false
}

// AsBasicCreateServiceRequest is the BasicCreateServiceRequest implementation for AKSServiceCreateRequest.
func (ascr AKSServiceCreateRequest) AsBasicCreateServiceRequest() (BasicCreateServiceRequest, bool) {
	return &ascr, true
}

// AKSServiceCreateRequestAutoScaler the auto scaler properties.
type AKSServiceCreateRequestAutoScaler struct {
	// AutoscaleEnabled - Option to enable/disable auto scaling.
	AutoscaleEnabled *bool `json:"autoscaleEnabled,omitempty"`
	// MinReplicas - The minimum number of replicas to scale down to.
	MinReplicas *int32 `json:"minReplicas,omitempty"`
	// MaxReplicas - The maximum number of replicas in the cluster.
	MaxReplicas *int32 `json:"maxReplicas,omitempty"`
	// TargetUtilization - The target utilization percentage to use for determining whether to scale the cluster.
	TargetUtilization *int32 `json:"targetUtilization,omitempty"`
	// RefreshPeriodInSeconds - The amount of seconds to wait between auto scale updates.
	RefreshPeriodInSeconds *int32 `json:"refreshPeriodInSeconds,omitempty"`
}

// AKSServiceCreateRequestDataCollection details of the data collection options specified.
type AKSServiceCreateRequestDataCollection struct {
	// EventHubEnabled - Option for enabling/disabling Event Hub.
	EventHubEnabled *bool `json:"eventHubEnabled,omitempty"`
	// StorageEnabled - Option for enabling/disabling storage.
	StorageEnabled *bool `json:"storageEnabled,omitempty"`
}

// AKSServiceCreateRequestLivenessProbeRequirements the liveness probe requirements.
type AKSServiceCreateRequestLivenessProbeRequirements struct {
	// FailureThreshold - The number of failures to allow before returning an unhealthy status.
	FailureThreshold *int32 `json:"failureThreshold,omitempty"`
	// SuccessThreshold - The number of successful probes before returning a healthy status.
	SuccessThreshold *int32 `json:"successThreshold,omitempty"`
	// TimeoutSeconds - The probe timeout in seconds.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
	// PeriodSeconds - The length of time between probes in seconds.
	PeriodSeconds *int32 `json:"periodSeconds,omitempty"`
	// InitialDelaySeconds - The delay before the first probe in seconds.
	InitialDelaySeconds *int32 `json:"initialDelaySeconds,omitempty"`
}

// AKSServiceResponse the response for an AKS service.
type AKSServiceResponse struct {
	// ModelsProperty - The list of models.
	ModelsProperty *[]Model `json:"models,omitempty"`
	// ContainerResourceRequirements - The container resource requirements.
	ContainerResourceRequirements *ContainerResourceRequirements `json:"containerResourceRequirements,omitempty"`
	// MaxConcurrentRequestsPerContainer - The maximum number of concurrent requests per container.
	MaxConcurrentRequestsPerContainer *int32 `json:"maxConcurrentRequestsPerContainer,omitempty"`
	// MaxQueueWaitMs - Maximum time a request will wait in the queue (in milliseconds). After this time, the service will return 503 (Service Unavailable)
	MaxQueueWaitMs *int32 `json:"maxQueueWaitMs,omitempty"`
	// ComputeName - The name of the compute resource.
	ComputeName *string `json:"computeName,omitempty"`
	// Namespace - The Kubernetes namespace of the deployment.
	Namespace *string `json:"namespace,omitempty"`
	// NumReplicas - The number of replicas on the cluster.
	NumReplicas *int32 `json:"numReplicas,omitempty"`
	// DataCollection - Details of the data collection options specified.
	DataCollection *AKSServiceResponseDataCollection `json:"dataCollection,omitempty"`
	// AppInsightsEnabled - Whether or not Application Insights is enabled.
	AppInsightsEnabled *bool `json:"appInsightsEnabled,omitempty"`
	// AutoScaler - The auto scaler properties.
	AutoScaler *AKSServiceResponseAutoScaler `json:"autoScaler,omitempty"`
	// ScoringURI - READ-ONLY; The Uri for sending scoring requests.
	ScoringURI *string `json:"scoringUri,omitempty"`
	// DeploymentStatus - READ-ONLY; The deployment status.
	DeploymentStatus *AKSServiceResponseDeploymentStatus `json:"deploymentStatus,omitempty"`
	// ScoringTimeoutMs - The scoring timeout in milliseconds.
	ScoringTimeoutMs *int32 `json:"scoringTimeoutMs,omitempty"`
	// LivenessProbeRequirements - The liveness probe requirements.
	LivenessProbeRequirements *AKSServiceResponseLivenessProbeRequirements `json:"livenessProbeRequirements,omitempty"`
	// AuthEnabled - Whether or not authentication is enabled.
	AuthEnabled *bool `json:"authEnabled,omitempty"`
	// AadAuthEnabled - Whether or not AAD authentication is enabled.
	AadAuthEnabled *bool `json:"aadAuthEnabled,omitempty"`
	// SwaggerURI - READ-ONLY; The Uri for sending swagger requests.
	SwaggerURI *string `json:"swaggerUri,omitempty"`
	// ModelConfigMap - READ-ONLY; Details on the models and configurations.
	ModelConfigMap map[string]interface{} `json:"modelConfigMap"`
	// EnvironmentImageRequest - The Environment, models and assets used for inferencing.
	EnvironmentImageRequest *AKSServiceResponseEnvironmentImageRequest `json:"environmentImageRequest,omitempty"`
	// IsDefault - Is this the default variant.
	IsDefault *bool `json:"isDefault,omitempty"`
	// TrafficPercentile - The amount of traffic variant receives.
	TrafficPercentile *float64 `json:"trafficPercentile,omitempty"`
	// Type - The type of the variant. Possible values include: 'VariantTypeControl', 'VariantTypeTreatment'
	Type VariantType `json:"type,omitempty"`
	// Description - The service description.
	Description *string `json:"description,omitempty"`
	// KvTags - The service tag dictionary. Tags are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The service property dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// State - READ-ONLY; The current state of the service. Possible values include: 'WebServiceStateTransitioning', 'WebServiceStateHealthy', 'WebServiceStateUnhealthy', 'WebServiceStateFailed', 'WebServiceStateUnschedulable'
	State WebServiceState `json:"state,omitempty"`
	// Error - READ-ONLY; The error details.
	Error *ServiceResponseBaseError `json:"error,omitempty"`
	// DeploymentType - The deployment type for the service. Possible values include: 'DeploymentTypeGRPCRealtimeEndpoint', 'DeploymentTypeHTTPRealtimeEndpoint', 'DeploymentTypeBatch'
	DeploymentType DeploymentType `json:"deploymentType,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicServiceResponseBaseComputeTypeServiceResponseBase', 'ComputeTypeBasicServiceResponseBaseComputeTypeACI', 'ComputeTypeBasicServiceResponseBaseComputeTypeCustom', 'ComputeTypeBasicServiceResponseBaseComputeTypeAKS'
	ComputeType ComputeTypeBasicServiceResponseBase `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AKSServiceResponse.
func (asr AKSServiceResponse) MarshalJSON() ([]byte, error) {
	asr.ComputeType = ComputeTypeBasicServiceResponseBaseComputeTypeAKS
	objectMap := make(map[string]interface{})
	if asr.ModelsProperty != nil {
		objectMap["models"] = asr.ModelsProperty
	}
	if asr.ContainerResourceRequirements != nil {
		objectMap["containerResourceRequirements"] = asr.ContainerResourceRequirements
	}
	if asr.MaxConcurrentRequestsPerContainer != nil {
		objectMap["maxConcurrentRequestsPerContainer"] = asr.MaxConcurrentRequestsPerContainer
	}
	if asr.MaxQueueWaitMs != nil {
		objectMap["maxQueueWaitMs"] = asr.MaxQueueWaitMs
	}
	if asr.ComputeName != nil {
		objectMap["computeName"] = asr.ComputeName
	}
	if asr.Namespace != nil {
		objectMap["namespace"] = asr.Namespace
	}
	if asr.NumReplicas != nil {
		objectMap["numReplicas"] = asr.NumReplicas
	}
	if asr.DataCollection != nil {
		objectMap["dataCollection"] = asr.DataCollection
	}
	if asr.AppInsightsEnabled != nil {
		objectMap["appInsightsEnabled"] = asr.AppInsightsEnabled
	}
	if asr.AutoScaler != nil {
		objectMap["autoScaler"] = asr.AutoScaler
	}
	if asr.ScoringTimeoutMs != nil {
		objectMap["scoringTimeoutMs"] = asr.ScoringTimeoutMs
	}
	if asr.LivenessProbeRequirements != nil {
		objectMap["livenessProbeRequirements"] = asr.LivenessProbeRequirements
	}
	if asr.AuthEnabled != nil {
		objectMap["authEnabled"] = asr.AuthEnabled
	}
	if asr.AadAuthEnabled != nil {
		objectMap["aadAuthEnabled"] = asr.AadAuthEnabled
	}
	if asr.EnvironmentImageRequest != nil {
		objectMap["environmentImageRequest"] = asr.EnvironmentImageRequest
	}
	if asr.IsDefault != nil {
		objectMap["isDefault"] = asr.IsDefault
	}
	if asr.TrafficPercentile != nil {
		objectMap["trafficPercentile"] = asr.TrafficPercentile
	}
	if asr.Type != "" {
		objectMap["type"] = asr.Type
	}
	if asr.Description != nil {
		objectMap["description"] = asr.Description
	}
	if asr.KvTags != nil {
		objectMap["kvTags"] = asr.KvTags
	}
	if asr.Properties != nil {
		objectMap["properties"] = asr.Properties
	}
	if asr.DeploymentType != "" {
		objectMap["deploymentType"] = asr.DeploymentType
	}
	if asr.ComputeType != "" {
		objectMap["computeType"] = asr.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsACIServiceResponse is the BasicServiceResponseBase implementation for AKSServiceResponse.
func (asr AKSServiceResponse) AsACIServiceResponse() (*ACIServiceResponse, bool) {
	return nil, false
}

// AsAKSVariantResponse is the BasicServiceResponseBase implementation for AKSServiceResponse.
func (asr AKSServiceResponse) AsAKSVariantResponse() (*AKSVariantResponse, bool) {
	return nil, false
}

// AsBasicAKSVariantResponse is the BasicServiceResponseBase implementation for AKSServiceResponse.
func (asr AKSServiceResponse) AsBasicAKSVariantResponse() (BasicAKSVariantResponse, bool) {
	return &asr, true
}

// AsAKSServiceResponse is the BasicServiceResponseBase implementation for AKSServiceResponse.
func (asr AKSServiceResponse) AsAKSServiceResponse() (*AKSServiceResponse, bool) {
	return &asr, true
}

// AsServiceResponseBase is the BasicServiceResponseBase implementation for AKSServiceResponse.
func (asr AKSServiceResponse) AsServiceResponseBase() (*ServiceResponseBase, bool) {
	return nil, false
}

// AsBasicServiceResponseBase is the BasicServiceResponseBase implementation for AKSServiceResponse.
func (asr AKSServiceResponse) AsBasicServiceResponseBase() (BasicServiceResponseBase, bool) {
	return &asr, true
}

// AKSServiceResponseAutoScaler the auto scaler properties.
type AKSServiceResponseAutoScaler struct {
	// AutoscaleEnabled - Option to enable/disable auto scaling.
	AutoscaleEnabled *bool `json:"autoscaleEnabled,omitempty"`
	// MinReplicas - The minimum number of replicas to scale down to.
	MinReplicas *int32 `json:"minReplicas,omitempty"`
	// MaxReplicas - The maximum number of replicas in the cluster.
	MaxReplicas *int32 `json:"maxReplicas,omitempty"`
	// TargetUtilization - The target utilization percentage to use for determining whether to scale the cluster.
	TargetUtilization *int32 `json:"targetUtilization,omitempty"`
	// RefreshPeriodInSeconds - The amount of seconds to wait between auto scale updates.
	RefreshPeriodInSeconds *int32 `json:"refreshPeriodInSeconds,omitempty"`
}

// AKSServiceResponseDataCollection details of the data collection options specified.
type AKSServiceResponseDataCollection struct {
	// EventHubEnabled - Option for enabling/disabling Event Hub.
	EventHubEnabled *bool `json:"eventHubEnabled,omitempty"`
	// StorageEnabled - Option for enabling/disabling storage.
	StorageEnabled *bool `json:"storageEnabled,omitempty"`
}

// AKSServiceResponseDeploymentStatus the deployment status.
type AKSServiceResponseDeploymentStatus struct {
	// DesiredReplicas - The desired number of replicas.
	DesiredReplicas *int32 `json:"desiredReplicas,omitempty"`
	// UpdatedReplicas - The number of updated replicas.
	UpdatedReplicas *int32 `json:"updatedReplicas,omitempty"`
	// AvailableReplicas - The number of available replicas.
	AvailableReplicas *int32 `json:"availableReplicas,omitempty"`
	// Error - The error details.
	Error *AKSReplicaStatusError `json:"error,omitempty"`
}

// AKSServiceResponseEnvironmentImageRequest the Environment, models and assets used for inferencing.
type AKSServiceResponseEnvironmentImageRequest struct {
	// DriverProgram - The name of the driver file.
	DriverProgram *string `json:"driverProgram,omitempty"`
	// Assets - The list of assets.
	Assets *[]ImageAsset `json:"assets,omitempty"`
	// ModelIds - The list of model Ids.
	ModelIds *[]string `json:"modelIds,omitempty"`
	// ModelsProperty - The list of models.
	ModelsProperty *[]Model `json:"models,omitempty"`
	// Environment - The details of the AZURE ML environment.
	Environment *EnvironmentImageResponseEnvironment `json:"environment,omitempty"`
	// EnvironmentReference - The unique identifying details of the AZURE ML environment.
	EnvironmentReference *EnvironmentImageResponseEnvironmentReference `json:"environmentReference,omitempty"`
}

// AKSServiceResponseLivenessProbeRequirements the liveness probe requirements.
type AKSServiceResponseLivenessProbeRequirements struct {
	// FailureThreshold - The number of failures to allow before returning an unhealthy status.
	FailureThreshold *int32 `json:"failureThreshold,omitempty"`
	// SuccessThreshold - The number of successful probes before returning a healthy status.
	SuccessThreshold *int32 `json:"successThreshold,omitempty"`
	// TimeoutSeconds - The probe timeout in seconds.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
	// PeriodSeconds - The length of time between probes in seconds.
	PeriodSeconds *int32 `json:"periodSeconds,omitempty"`
	// InitialDelaySeconds - The delay before the first probe in seconds.
	InitialDelaySeconds *int32 `json:"initialDelaySeconds,omitempty"`
}

// BasicAKSVariantResponse the response for an AKS variant.
type BasicAKSVariantResponse interface {
	AsAKSServiceResponse() (*AKSServiceResponse, bool)
	AsAKSVariantResponse() (*AKSVariantResponse, bool)
}

// AKSVariantResponse the response for an AKS variant.
type AKSVariantResponse struct {
	// IsDefault - Is this the default variant.
	IsDefault *bool `json:"isDefault,omitempty"`
	// TrafficPercentile - The amount of traffic variant receives.
	TrafficPercentile *float64 `json:"trafficPercentile,omitempty"`
	// Type - The type of the variant. Possible values include: 'VariantTypeControl', 'VariantTypeTreatment'
	Type VariantType `json:"type,omitempty"`
	// Description - The service description.
	Description *string `json:"description,omitempty"`
	// KvTags - The service tag dictionary. Tags are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The service property dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// State - READ-ONLY; The current state of the service. Possible values include: 'WebServiceStateTransitioning', 'WebServiceStateHealthy', 'WebServiceStateUnhealthy', 'WebServiceStateFailed', 'WebServiceStateUnschedulable'
	State WebServiceState `json:"state,omitempty"`
	// Error - READ-ONLY; The error details.
	Error *ServiceResponseBaseError `json:"error,omitempty"`
	// DeploymentType - The deployment type for the service. Possible values include: 'DeploymentTypeGRPCRealtimeEndpoint', 'DeploymentTypeHTTPRealtimeEndpoint', 'DeploymentTypeBatch'
	DeploymentType DeploymentType `json:"deploymentType,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicServiceResponseBaseComputeTypeServiceResponseBase', 'ComputeTypeBasicServiceResponseBaseComputeTypeACI', 'ComputeTypeBasicServiceResponseBaseComputeTypeCustom', 'ComputeTypeBasicServiceResponseBaseComputeTypeAKS'
	ComputeType ComputeTypeBasicServiceResponseBase `json:"computeType,omitempty"`
}

func unmarshalBasicAKSVariantResponse(body []byte) (BasicAKSVariantResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicServiceResponseBaseComputeTypeAKS):
		var asr AKSServiceResponse
		err := json.Unmarshal(body, &asr)
		return asr, err
	default:
		var avr AKSVariantResponse
		err := json.Unmarshal(body, &avr)
		return avr, err
	}
}
func unmarshalBasicAKSVariantResponseArray(body []byte) ([]BasicAKSVariantResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	avrArray := make([]BasicAKSVariantResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		avr, err := unmarshalBasicAKSVariantResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		avrArray[index] = avr
	}
	return avrArray, nil
}

// MarshalJSON is the custom marshaler for AKSVariantResponse.
func (avr AKSVariantResponse) MarshalJSON() ([]byte, error) {
	avr.ComputeType = ComputeTypeBasicServiceResponseBaseComputeTypeCustom
	objectMap := make(map[string]interface{})
	if avr.IsDefault != nil {
		objectMap["isDefault"] = avr.IsDefault
	}
	if avr.TrafficPercentile != nil {
		objectMap["trafficPercentile"] = avr.TrafficPercentile
	}
	if avr.Type != "" {
		objectMap["type"] = avr.Type
	}
	if avr.Description != nil {
		objectMap["description"] = avr.Description
	}
	if avr.KvTags != nil {
		objectMap["kvTags"] = avr.KvTags
	}
	if avr.Properties != nil {
		objectMap["properties"] = avr.Properties
	}
	if avr.DeploymentType != "" {
		objectMap["deploymentType"] = avr.DeploymentType
	}
	if avr.ComputeType != "" {
		objectMap["computeType"] = avr.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsACIServiceResponse is the BasicServiceResponseBase implementation for AKSVariantResponse.
func (avr AKSVariantResponse) AsACIServiceResponse() (*ACIServiceResponse, bool) {
	return nil, false
}

// AsAKSVariantResponse is the BasicServiceResponseBase implementation for AKSVariantResponse.
func (avr AKSVariantResponse) AsAKSVariantResponse() (*AKSVariantResponse, bool) {
	return &avr, true
}

// AsBasicAKSVariantResponse is the BasicServiceResponseBase implementation for AKSVariantResponse.
func (avr AKSVariantResponse) AsBasicAKSVariantResponse() (BasicAKSVariantResponse, bool) {
	return &avr, true
}

// AsAKSServiceResponse is the BasicServiceResponseBase implementation for AKSVariantResponse.
func (avr AKSVariantResponse) AsAKSServiceResponse() (*AKSServiceResponse, bool) {
	return nil, false
}

// AsServiceResponseBase is the BasicServiceResponseBase implementation for AKSVariantResponse.
func (avr AKSVariantResponse) AsServiceResponseBase() (*ServiceResponseBase, bool) {
	return nil, false
}

// AsBasicServiceResponseBase is the BasicServiceResponseBase implementation for AKSVariantResponse.
func (avr AKSVariantResponse) AsBasicServiceResponseBase() (BasicServiceResponseBase, bool) {
	return &avr, true
}

// AmlCompute an Azure Machine Learning compute.
type AmlCompute struct {
	// Properties - AML Compute properties
	Properties *AmlComputeProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlCompute.
func (ac AmlCompute) MarshalJSON() ([]byte, error) {
	ac.ComputeType = ComputeTypeBasicComputeComputeTypeAmlCompute
	objectMap := make(map[string]interface{})
	if ac.Properties != nil {
		objectMap["properties"] = ac.Properties
	}
	if ac.ComputeLocation != nil {
		objectMap["computeLocation"] = ac.ComputeLocation
	}
	if ac.Description != nil {
		objectMap["description"] = ac.Description
	}
	if ac.ResourceID != nil {
		objectMap["resourceId"] = ac.ResourceID
	}
	if ac.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = ac.DisableLocalAuth
	}
	if ac.ComputeType != "" {
		objectMap["computeType"] = ac.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsAmlCompute() (*AmlCompute, bool) {
	return &ac, true
}

// AsComputeInstance is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for AmlCompute.
func (ac AmlCompute) AsBasicCompute() (BasicCompute, bool) {
	return &ac, true
}

// AmlComputeNodeInformation compute node information related to a AmlCompute.
type AmlComputeNodeInformation struct {
	// NodeID - READ-ONLY; ID of the compute node.
	NodeID *string `json:"nodeId,omitempty"`
	// PrivateIPAddress - READ-ONLY; Private IP address of the compute node.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// PublicIPAddress - READ-ONLY; Public IP address of the compute node.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// Port - READ-ONLY; SSH port number of the node.
	Port *float64 `json:"port,omitempty"`
	// NodeState - READ-ONLY; State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted. Possible values include: 'NodeStateIdle', 'NodeStateRunning', 'NodeStatePreparing', 'NodeStateUnusable', 'NodeStateLeaving', 'NodeStatePreempted'
	NodeState NodeState `json:"nodeState,omitempty"`
	// RunID - READ-ONLY; ID of the Experiment running on the node, if any else null.
	RunID *string `json:"runId,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlComputeNodeInformation.
func (acni AmlComputeNodeInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AmlComputeNodesInformation compute node information related to a AmlCompute.
type AmlComputeNodesInformation struct {
	autorest.Response `json:"-"`
	// Nodes - READ-ONLY; The collection of returned AmlCompute nodes details.
	Nodes *[]AmlComputeNodeInformation `json:"nodes,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation', 'ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute'
	ComputeType ComputeTypeBasicComputeNodesInformation `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) MarshalJSON() ([]byte, error) {
	acni.ComputeType = ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute
	objectMap := make(map[string]interface{})
	if acni.ComputeType != "" {
		objectMap["computeType"] = acni.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAmlComputeNodesInformation is the BasicComputeNodesInformation implementation for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) AsAmlComputeNodesInformation() (*AmlComputeNodesInformation, bool) {
	return &acni, true
}

// AsComputeNodesInformation is the BasicComputeNodesInformation implementation for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) AsComputeNodesInformation() (*ComputeNodesInformation, bool) {
	return nil, false
}

// AsBasicComputeNodesInformation is the BasicComputeNodesInformation implementation for AmlComputeNodesInformation.
func (acni AmlComputeNodesInformation) AsBasicComputeNodesInformation() (BasicComputeNodesInformation, bool) {
	return &acni, true
}

// AmlComputeNodesInformationIterator provides access to a complete listing of AmlComputeNodeInformation
// values.
type AmlComputeNodesInformationIterator struct {
	i    int
	page AmlComputeNodesInformationPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AmlComputeNodesInformationIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AmlComputeNodesInformationIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AmlComputeNodesInformationIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AmlComputeNodesInformationIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AmlComputeNodesInformationIterator) Response() AmlComputeNodesInformation {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AmlComputeNodesInformationIterator) Value() AmlComputeNodeInformation {
	if !iter.page.NotDone() {
		return AmlComputeNodeInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AmlComputeNodesInformationIterator type.
func NewAmlComputeNodesInformationIterator(page AmlComputeNodesInformationPage) AmlComputeNodesInformationIterator {
	return AmlComputeNodesInformationIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (acni AmlComputeNodesInformation) IsEmpty() bool {
	return acni.Nodes == nil || len(*acni.Nodes) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (acni AmlComputeNodesInformation) hasNextLink() bool {
	return acni.NextLink != nil && len(*acni.NextLink) != 0
}

// amlComputeNodesInformationPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (acni AmlComputeNodesInformation) amlComputeNodesInformationPreparer(ctx context.Context) (*http.Request, error) {
	if !acni.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(acni.NextLink)))
}

// AmlComputeNodesInformationPage contains a page of AmlComputeNodeInformation values.
type AmlComputeNodesInformationPage struct {
	fn   func(context.Context, AmlComputeNodesInformation) (AmlComputeNodesInformation, error)
	acni AmlComputeNodesInformation
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AmlComputeNodesInformationPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AmlComputeNodesInformationPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.acni)
		if err != nil {
			return err
		}
		page.acni = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AmlComputeNodesInformationPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AmlComputeNodesInformationPage) NotDone() bool {
	return !page.acni.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AmlComputeNodesInformationPage) Response() AmlComputeNodesInformation {
	return page.acni
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AmlComputeNodesInformationPage) Values() []AmlComputeNodeInformation {
	if page.acni.IsEmpty() {
		return nil
	}
	return *page.acni.Nodes
}

// Creates a new instance of the AmlComputeNodesInformationPage type.
func NewAmlComputeNodesInformationPage(cur AmlComputeNodesInformation, getNextPage func(context.Context, AmlComputeNodesInformation) (AmlComputeNodesInformation, error)) AmlComputeNodesInformationPage {
	return AmlComputeNodesInformationPage{
		fn:   getNextPage,
		acni: cur,
	}
}

// AmlComputeProperties AML Compute properties
type AmlComputeProperties struct {
	// OsType - Compute OS Type. Possible values include: 'OsTypeLinux', 'OsTypeWindows'
	OsType OsType `json:"osType,omitempty"`
	// VMSize - Virtual Machine Size
	VMSize *string `json:"vmSize,omitempty"`
	// VMPriority - Virtual Machine priority. Possible values include: 'VMPriorityDedicated', 'VMPriorityLowPriority'
	VMPriority VMPriority `json:"vmPriority,omitempty"`
	// VirtualMachineImage - Virtual Machine image for AML Compute - windows only
	VirtualMachineImage *VirtualMachineImage `json:"virtualMachineImage,omitempty"`
	// IsolatedNetwork - Network is isolated or not
	IsolatedNetwork *bool `json:"isolatedNetwork,omitempty"`
	// ScaleSettings - Scale settings for AML Compute
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
	// UserAccountCredentials - Credentials for an administrator user account that will be created on each compute node.
	UserAccountCredentials *UserAccountCredentials `json:"userAccountCredentials,omitempty"`
	// Subnet - Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID `json:"subnet,omitempty"`
	// RemoteLoginPortPublicAccess - State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled. Possible values include: 'RemoteLoginPortPublicAccessEnabled', 'RemoteLoginPortPublicAccessDisabled', 'RemoteLoginPortPublicAccessNotSpecified'
	RemoteLoginPortPublicAccess RemoteLoginPortPublicAccess `json:"remoteLoginPortPublicAccess,omitempty"`
	// AllocationState - READ-ONLY; Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute. Possible values include: 'AllocationStateSteady', 'AllocationStateResizing'
	AllocationState AllocationState `json:"allocationState,omitempty"`
	// AllocationStateTransitionTime - READ-ONLY; The time at which the compute entered its current allocation state.
	AllocationStateTransitionTime *date.Time `json:"allocationStateTransitionTime,omitempty"`
	// Errors - READ-ONLY; Collection of errors encountered by various compute nodes during node setup.
	Errors *[]Error `json:"errors,omitempty"`
	// CurrentNodeCount - READ-ONLY; The number of compute nodes currently assigned to the compute.
	CurrentNodeCount *int32 `json:"currentNodeCount,omitempty"`
	// TargetNodeCount - READ-ONLY; The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
	TargetNodeCount *int32 `json:"targetNodeCount,omitempty"`
	// NodeStateCounts - READ-ONLY; Counts of various node states on the compute.
	NodeStateCounts *NodeStateCounts `json:"nodeStateCounts,omitempty"`
	// EnableNodePublicIP - Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
	EnableNodePublicIP *bool `json:"enableNodePublicIp,omitempty"`
}

// MarshalJSON is the custom marshaler for AmlComputeProperties.
func (ac AmlComputeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.OsType != "" {
		objectMap["osType"] = ac.OsType
	}
	if ac.VMSize != nil {
		objectMap["vmSize"] = ac.VMSize
	}
	if ac.VMPriority != "" {
		objectMap["vmPriority"] = ac.VMPriority
	}
	if ac.VirtualMachineImage != nil {
		objectMap["virtualMachineImage"] = ac.VirtualMachineImage
	}
	if ac.IsolatedNetwork != nil {
		objectMap["isolatedNetwork"] = ac.IsolatedNetwork
	}
	if ac.ScaleSettings != nil {
		objectMap["scaleSettings"] = ac.ScaleSettings
	}
	if ac.UserAccountCredentials != nil {
		objectMap["userAccountCredentials"] = ac.UserAccountCredentials
	}
	if ac.Subnet != nil {
		objectMap["subnet"] = ac.Subnet
	}
	if ac.RemoteLoginPortPublicAccess != "" {
		objectMap["remoteLoginPortPublicAccess"] = ac.RemoteLoginPortPublicAccess
	}
	if ac.EnableNodePublicIP != nil {
		objectMap["enableNodePublicIp"] = ac.EnableNodePublicIP
	}
	return json.Marshal(objectMap)
}

// AmlUserFeature features enabled for a workspace
type AmlUserFeature struct {
	// ID - Specifies the feature ID
	ID *string `json:"id,omitempty"`
	// DisplayName - Specifies the feature name
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Describes the feature for user experience
	Description *string `json:"description,omitempty"`
}

// AssignedUser a user that can be assigned to a compute instance.
type AssignedUser struct {
	// ObjectID - User’s AAD Object Id.
	ObjectID *string `json:"objectId,omitempty"`
	// TenantID - User’s AAD Tenant Id.
	TenantID *string `json:"tenantId,omitempty"`
}

// AuthKeys ...
type AuthKeys struct {
	// PrimaryKey - The primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// AutoPauseProperties auto pause properties
type AutoPauseProperties struct {
	DelayInMinutes *int32 `json:"delayInMinutes,omitempty"`
	Enabled        *bool  `json:"enabled,omitempty"`
}

// AutoScaleProperties auto scale properties
type AutoScaleProperties struct {
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
	Enabled      *bool  `json:"enabled,omitempty"`
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
}

// AutoScaler the Auto Scaler properties.
type AutoScaler struct {
	// AutoscaleEnabled - Option to enable/disable auto scaling.
	AutoscaleEnabled *bool `json:"autoscaleEnabled,omitempty"`
	// MinReplicas - The minimum number of replicas to scale down to.
	MinReplicas *int32 `json:"minReplicas,omitempty"`
	// MaxReplicas - The maximum number of replicas in the cluster.
	MaxReplicas *int32 `json:"maxReplicas,omitempty"`
	// TargetUtilization - The target utilization percentage to use for determining whether to scale the cluster.
	TargetUtilization *int32 `json:"targetUtilization,omitempty"`
	// RefreshPeriodInSeconds - The amount of seconds to wait between auto scale updates.
	RefreshPeriodInSeconds *int32 `json:"refreshPeriodInSeconds,omitempty"`
}

// ClusterUpdateParameters amlCompute update parameters.
type ClusterUpdateParameters struct {
	// ClusterUpdateProperties - The properties of the amlCompute.
	*ClusterUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdateParameters.
func (cup ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.ClusterUpdateProperties != nil {
		objectMap["properties"] = cup.ClusterUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdateParameters struct.
func (cup *ClusterUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterUpdateProperties ClusterUpdateProperties
				err = json.Unmarshal(*v, &clusterUpdateProperties)
				if err != nil {
					return err
				}
				cup.ClusterUpdateProperties = &clusterUpdateProperties
			}
		}
	}

	return nil
}

// ClusterUpdateProperties the properties of a amlCompute that need to be updated.
type ClusterUpdateProperties struct {
	// ScaleSettings - Desired scale settings for the amlCompute.
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
}

// BasicCompute machine Learning compute object.
type BasicCompute interface {
	AsAKS() (*AKS, bool)
	AsAmlCompute() (*AmlCompute, bool)
	AsComputeInstance() (*ComputeInstance, bool)
	AsVirtualMachine() (*VirtualMachine, bool)
	AsHDInsight() (*HDInsight, bool)
	AsDataFactory() (*DataFactory, bool)
	AsDatabricks() (*Databricks, bool)
	AsDataLakeAnalytics() (*DataLakeAnalytics, bool)
	AsCompute() (*Compute, bool)
}

// Compute machine Learning compute object.
type Compute struct {
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

func unmarshalBasicCompute(body []byte) (BasicCompute, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicComputeComputeTypeAKS):
		var a AKS
		err := json.Unmarshal(body, &a)
		return a, err
	case string(ComputeTypeBasicComputeComputeTypeAmlCompute):
		var ac AmlCompute
		err := json.Unmarshal(body, &ac)
		return ac, err
	case string(ComputeTypeBasicComputeComputeTypeComputeInstance):
		var ci ComputeInstance
		err := json.Unmarshal(body, &ci)
		return ci, err
	case string(ComputeTypeBasicComputeComputeTypeVirtualMachine):
		var VM VirtualMachine
		err := json.Unmarshal(body, &VM)
		return VM, err
	case string(ComputeTypeBasicComputeComputeTypeHDInsight):
		var hi HDInsight
		err := json.Unmarshal(body, &hi)
		return hi, err
	case string(ComputeTypeBasicComputeComputeTypeDataFactory):
		var df DataFactory
		err := json.Unmarshal(body, &df)
		return df, err
	case string(ComputeTypeBasicComputeComputeTypeDatabricks):
		var d Databricks
		err := json.Unmarshal(body, &d)
		return d, err
	case string(ComputeTypeBasicComputeComputeTypeDataLakeAnalytics):
		var dla DataLakeAnalytics
		err := json.Unmarshal(body, &dla)
		return dla, err
	default:
		var c Compute
		err := json.Unmarshal(body, &c)
		return c, err
	}
}
func unmarshalBasicComputeArray(body []byte) ([]BasicCompute, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cArray := make([]BasicCompute, len(rawMessages))

	for index, rawMessage := range rawMessages {
		c, err := unmarshalBasicCompute(*rawMessage)
		if err != nil {
			return nil, err
		}
		cArray[index] = c
	}
	return cArray, nil
}

// MarshalJSON is the custom marshaler for Compute.
func (c Compute) MarshalJSON() ([]byte, error) {
	c.ComputeType = ComputeTypeBasicComputeComputeTypeCompute
	objectMap := make(map[string]interface{})
	if c.ComputeLocation != nil {
		objectMap["computeLocation"] = c.ComputeLocation
	}
	if c.Description != nil {
		objectMap["description"] = c.Description
	}
	if c.ResourceID != nil {
		objectMap["resourceId"] = c.ResourceID
	}
	if c.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = c.DisableLocalAuth
	}
	if c.ComputeType != "" {
		objectMap["computeType"] = c.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for Compute.
func (c Compute) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for Compute.
func (c Compute) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for Compute.
func (c Compute) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for Compute.
func (c Compute) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for Compute.
func (c Compute) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for Compute.
func (c Compute) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for Compute.
func (c Compute) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for Compute.
func (c Compute) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for Compute.
func (c Compute) AsCompute() (*Compute, bool) {
	return &c, true
}

// AsBasicCompute is the BasicCompute implementation for Compute.
func (c Compute) AsBasicCompute() (BasicCompute, bool) {
	return &c, true
}

// ComputeInstance an Azure Machine Learning compute instance.
type ComputeInstance struct {
	// Properties - Compute Instance properties
	Properties *ComputeInstanceProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstance.
func (ci ComputeInstance) MarshalJSON() ([]byte, error) {
	ci.ComputeType = ComputeTypeBasicComputeComputeTypeComputeInstance
	objectMap := make(map[string]interface{})
	if ci.Properties != nil {
		objectMap["properties"] = ci.Properties
	}
	if ci.ComputeLocation != nil {
		objectMap["computeLocation"] = ci.ComputeLocation
	}
	if ci.Description != nil {
		objectMap["description"] = ci.Description
	}
	if ci.ResourceID != nil {
		objectMap["resourceId"] = ci.ResourceID
	}
	if ci.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = ci.DisableLocalAuth
	}
	if ci.ComputeType != "" {
		objectMap["computeType"] = ci.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsComputeInstance() (*ComputeInstance, bool) {
	return &ci, true
}

// AsVirtualMachine is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for ComputeInstance.
func (ci ComputeInstance) AsBasicCompute() (BasicCompute, bool) {
	return &ci, true
}

// ComputeInstanceApplication defines an Aml Instance application and its connectivity endpoint URI.
type ComputeInstanceApplication struct {
	// DisplayName - Name of the ComputeInstance application.
	DisplayName *string `json:"displayName,omitempty"`
	// EndpointURI - Application' endpoint URI.
	EndpointURI *string `json:"endpointUri,omitempty"`
}

// ComputeInstanceConnectivityEndpoints defines all connectivity endpoints and properties for an
// ComputeInstance.
type ComputeInstanceConnectivityEndpoints struct {
	// PublicIPAddress - READ-ONLY; Public IP Address of this ComputeInstance.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// PrivateIPAddress - READ-ONLY; Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstanceConnectivityEndpoints.
func (cice ComputeInstanceConnectivityEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ComputeInstanceCreatedBy describes information on user who created this ComputeInstance.
type ComputeInstanceCreatedBy struct {
	// UserName - READ-ONLY; Name of the user.
	UserName *string `json:"userName,omitempty"`
	// UserOrgID - READ-ONLY; Uniquely identifies user' Azure Active Directory organization.
	UserOrgID *string `json:"userOrgId,omitempty"`
	// UserID - READ-ONLY; Uniquely identifies the user within his/her organization.
	UserID *string `json:"userId,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstanceCreatedBy.
func (cicb ComputeInstanceCreatedBy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ComputeInstanceLastOperation the last operation on ComputeInstance.
type ComputeInstanceLastOperation struct {
	// OperationName - Name of the last operation. Possible values include: 'OperationNameCreate', 'OperationNameStart', 'OperationNameStop', 'OperationNameRestart', 'OperationNameReimage', 'OperationNameDelete'
	OperationName OperationName `json:"operationName,omitempty"`
	// OperationTime - Time of the last operation.
	OperationTime *date.Time `json:"operationTime,omitempty"`
	// OperationStatus - Operation status. Possible values include: 'OperationStatusInProgress', 'OperationStatusSucceeded', 'OperationStatusCreateFailed', 'OperationStatusStartFailed', 'OperationStatusStopFailed', 'OperationStatusRestartFailed', 'OperationStatusReimageFailed', 'OperationStatusDeleteFailed'
	OperationStatus OperationStatus `json:"operationStatus,omitempty"`
}

// ComputeInstanceProperties compute Instance properties
type ComputeInstanceProperties struct {
	// VMSize - Virtual Machine Size
	VMSize *string `json:"vmSize,omitempty"`
	// Subnet - Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID `json:"subnet,omitempty"`
	// ApplicationSharingPolicy - Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role. Possible values include: 'ApplicationSharingPolicyPersonal', 'ApplicationSharingPolicyShared'
	ApplicationSharingPolicy ApplicationSharingPolicy `json:"applicationSharingPolicy,omitempty"`
	// SSHSettings - Specifies policy and settings for SSH access.
	SSHSettings *ComputeInstanceSSHSettings `json:"sshSettings,omitempty"`
	// ConnectivityEndpoints - READ-ONLY; Describes all connectivity endpoints available for this ComputeInstance.
	ConnectivityEndpoints *ComputeInstanceConnectivityEndpoints `json:"connectivityEndpoints,omitempty"`
	// Applications - READ-ONLY; Describes available applications and their endpoints on this ComputeInstance.
	Applications *[]ComputeInstanceApplication `json:"applications,omitempty"`
	// CreatedBy - READ-ONLY; Describes information on user who created this ComputeInstance.
	CreatedBy *ComputeInstanceCreatedBy `json:"createdBy,omitempty"`
	// Errors - READ-ONLY; Collection of errors encountered on this ComputeInstance.
	Errors *[]Error `json:"errors,omitempty"`
	// State - READ-ONLY; The current state of this ComputeInstance. Possible values include: 'ComputeInstanceStateCreating', 'ComputeInstanceStateCreateFailed', 'ComputeInstanceStateDeleting', 'ComputeInstanceStateRunning', 'ComputeInstanceStateRestarting', 'ComputeInstanceStateJobRunning', 'ComputeInstanceStateSettingUp', 'ComputeInstanceStateSetupFailed', 'ComputeInstanceStateStarting', 'ComputeInstanceStateStopped', 'ComputeInstanceStateStopping', 'ComputeInstanceStateUserSettingUp', 'ComputeInstanceStateUserSetupFailed', 'ComputeInstanceStateUnknown', 'ComputeInstanceStateUnusable'
	State ComputeInstanceState `json:"state,omitempty"`
	// ComputeInstanceAuthorizationType - The Compute Instance Authorization type. Available values are personal (default). Possible values include: 'ComputeInstanceAuthorizationTypePersonal'
	ComputeInstanceAuthorizationType ComputeInstanceAuthorizationType `json:"computeInstanceAuthorizationType,omitempty"`
	// PersonalComputeInstanceSettings - Settings for a personal compute instance.
	PersonalComputeInstanceSettings *PersonalComputeInstanceSettings `json:"personalComputeInstanceSettings,omitempty"`
	// SetupScripts - Details of customized scripts to execute for setting up the cluster.
	SetupScripts *SetupScripts `json:"setupScripts,omitempty"`
	// LastOperation - READ-ONLY; The last operation on ComputeInstance.
	LastOperation *ComputeInstanceLastOperation `json:"lastOperation,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstanceProperties.
func (ci ComputeInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.VMSize != nil {
		objectMap["vmSize"] = ci.VMSize
	}
	if ci.Subnet != nil {
		objectMap["subnet"] = ci.Subnet
	}
	if ci.ApplicationSharingPolicy != "" {
		objectMap["applicationSharingPolicy"] = ci.ApplicationSharingPolicy
	}
	if ci.SSHSettings != nil {
		objectMap["sshSettings"] = ci.SSHSettings
	}
	if ci.ComputeInstanceAuthorizationType != "" {
		objectMap["computeInstanceAuthorizationType"] = ci.ComputeInstanceAuthorizationType
	}
	if ci.PersonalComputeInstanceSettings != nil {
		objectMap["personalComputeInstanceSettings"] = ci.PersonalComputeInstanceSettings
	}
	if ci.SetupScripts != nil {
		objectMap["setupScripts"] = ci.SetupScripts
	}
	return json.Marshal(objectMap)
}

// ComputeInstanceSSHSettings specifies policy and settings for SSH access.
type ComputeInstanceSSHSettings struct {
	// SSHPublicAccess - State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable. Possible values include: 'SSHPublicAccessEnabled', 'SSHPublicAccessDisabled'
	SSHPublicAccess SSHPublicAccess `json:"sshPublicAccess,omitempty"`
	// AdminUserName - READ-ONLY; Describes the admin user name.
	AdminUserName *string `json:"adminUserName,omitempty"`
	// SSHPort - READ-ONLY; Describes the port for connecting through SSH.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// AdminPublicKey - Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
	AdminPublicKey *string `json:"adminPublicKey,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeInstanceSSHSettings.
func (ciss ComputeInstanceSSHSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ciss.SSHPublicAccess != "" {
		objectMap["sshPublicAccess"] = ciss.SSHPublicAccess
	}
	if ciss.AdminPublicKey != nil {
		objectMap["adminPublicKey"] = ciss.AdminPublicKey
	}
	return json.Marshal(objectMap)
}

// BasicComputeNodesInformation compute nodes information related to a Machine Learning compute. Might differ for every
// type of compute.
type BasicComputeNodesInformation interface {
	AsAmlComputeNodesInformation() (*AmlComputeNodesInformation, bool)
	AsComputeNodesInformation() (*ComputeNodesInformation, bool)
}

// ComputeNodesInformation compute nodes information related to a Machine Learning compute. Might differ for
// every type of compute.
type ComputeNodesInformation struct {
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation', 'ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute'
	ComputeType ComputeTypeBasicComputeNodesInformation `json:"computeType,omitempty"`
}

func unmarshalBasicComputeNodesInformation(body []byte) (BasicComputeNodesInformation, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicComputeNodesInformationComputeTypeAmlCompute):
		var acni AmlComputeNodesInformation
		err := json.Unmarshal(body, &acni)
		return acni, err
	default:
		var cni ComputeNodesInformation
		err := json.Unmarshal(body, &cni)
		return cni, err
	}
}
func unmarshalBasicComputeNodesInformationArray(body []byte) ([]BasicComputeNodesInformation, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cniArray := make([]BasicComputeNodesInformation, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cni, err := unmarshalBasicComputeNodesInformation(*rawMessage)
		if err != nil {
			return nil, err
		}
		cniArray[index] = cni
	}
	return cniArray, nil
}

// MarshalJSON is the custom marshaler for ComputeNodesInformation.
func (cni ComputeNodesInformation) MarshalJSON() ([]byte, error) {
	cni.ComputeType = ComputeTypeBasicComputeNodesInformationComputeTypeComputeNodesInformation
	objectMap := make(map[string]interface{})
	if cni.ComputeType != "" {
		objectMap["computeType"] = cni.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAmlComputeNodesInformation is the BasicComputeNodesInformation implementation for ComputeNodesInformation.
func (cni ComputeNodesInformation) AsAmlComputeNodesInformation() (*AmlComputeNodesInformation, bool) {
	return nil, false
}

// AsComputeNodesInformation is the BasicComputeNodesInformation implementation for ComputeNodesInformation.
func (cni ComputeNodesInformation) AsComputeNodesInformation() (*ComputeNodesInformation, bool) {
	return &cni, true
}

// AsBasicComputeNodesInformation is the BasicComputeNodesInformation implementation for ComputeNodesInformation.
func (cni ComputeNodesInformation) AsBasicComputeNodesInformation() (BasicComputeNodesInformation, bool) {
	return &cni, true
}

// ComputeResource machine Learning compute object wrapped into ARM resource envelope.
type ComputeResource struct {
	autorest.Response `json:"-"`
	// Properties - Compute properties
	Properties BasicCompute `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ComputeResource.
func (cr ComputeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = cr.Properties
	if cr.Identity != nil {
		objectMap["identity"] = cr.Identity
	}
	if cr.Location != nil {
		objectMap["location"] = cr.Location
	}
	if cr.Tags != nil {
		objectMap["tags"] = cr.Tags
	}
	if cr.Sku != nil {
		objectMap["sku"] = cr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComputeResource struct.
func (cr *ComputeResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicCompute(*v)
				if err != nil {
					return err
				}
				cr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cr.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cr.SystemData = &systemData
			}
		}
	}

	return nil
}

// BasicComputeSecrets secrets related to a Machine Learning compute. Might differ for every type of compute.
type BasicComputeSecrets interface {
	AsAksComputeSecrets() (*AksComputeSecrets, bool)
	AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool)
	AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool)
	AsComputeSecrets() (*ComputeSecrets, bool)
}

// ComputeSecrets secrets related to a Machine Learning compute. Might differ for every type of compute.
type ComputeSecrets struct {
	autorest.Response `json:"-"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine', 'ComputeTypeBasicComputeSecretsComputeTypeDatabricks'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

func unmarshalBasicComputeSecrets(body []byte) (BasicComputeSecrets, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicComputeSecretsComputeTypeAKS):
		var acs AksComputeSecrets
		err := json.Unmarshal(body, &acs)
		return acs, err
	case string(ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine):
		var vms VirtualMachineSecrets
		err := json.Unmarshal(body, &vms)
		return vms, err
	case string(ComputeTypeBasicComputeSecretsComputeTypeDatabricks):
		var dcs DatabricksComputeSecrets
		err := json.Unmarshal(body, &dcs)
		return dcs, err
	default:
		var cs ComputeSecrets
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicComputeSecretsArray(body []byte) ([]BasicComputeSecrets, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicComputeSecrets, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicComputeSecrets(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for ComputeSecrets.
func (cs ComputeSecrets) MarshalJSON() ([]byte, error) {
	cs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets
	objectMap := make(map[string]interface{})
	if cs.ComputeType != "" {
		objectMap["computeType"] = cs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return nil, false
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsDatabricksComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return &cs, true
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &cs, true
}

// ComputeSecretsModel ...
type ComputeSecretsModel struct {
	autorest.Response `json:"-"`
	Value             BasicComputeSecrets `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ComputeSecretsModel struct.
func (csm *ComputeSecretsModel) UnmarshalJSON(body []byte) error {
	cs, err := unmarshalBasicComputeSecrets(body)
	if err != nil {
		return err
	}
	csm.Value = cs

	return nil
}

// ContainerRegistry ...
type ContainerRegistry struct {
	Address  *string `json:"address,omitempty"`
	Username *string `json:"username,omitempty"`
	Password *string `json:"password,omitempty"`
}

// ContainerRegistryResponse ...
type ContainerRegistryResponse struct {
	Address *string `json:"address,omitempty"`
}

// ContainerResourceRequirements the resource requirements for the container (cpu and memory).
type ContainerResourceRequirements struct {
	// CPU - The minimum amount of CPU cores to be used by the container. More info:
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	CPU *float64 `json:"cpu,omitempty"`
	// CPULimit - The maximum amount of CPU cores allowed to be used by the container. More info:
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	CPULimit *float64 `json:"cpuLimit,omitempty"`
	// MemoryInGB - The minimum amount of memory (in GB) to be used by the container. More info:
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	// MemoryInGBLimit - The maximum amount of memory (in GB) allowed to be used by the container. More info:
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	MemoryInGBLimit *float64 `json:"memoryInGBLimit,omitempty"`
	// Gpu - The number of GPU cores in the container.
	Gpu *int32 `json:"gpu,omitempty"`
	// Fpga - The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
	Fpga *int32 `json:"fpga,omitempty"`
}

// CosmosDbSettings ...
type CosmosDbSettings struct {
	// CollectionsThroughput - The throughput of the collections in cosmosdb database
	CollectionsThroughput *int32 `json:"collectionsThroughput,omitempty"`
}

// BasicCreateEndpointVariantRequest the Variant properties.
type BasicCreateEndpointVariantRequest interface {
	AsAKSServiceCreateRequest() (*AKSServiceCreateRequest, bool)
	AsCreateEndpointVariantRequest() (*CreateEndpointVariantRequest, bool)
}

// CreateEndpointVariantRequest the Variant properties.
type CreateEndpointVariantRequest struct {
	// IsDefault - Is this the default variant.
	IsDefault *bool `json:"isDefault,omitempty"`
	// TrafficPercentile - The amount of traffic variant receives.
	TrafficPercentile *float64 `json:"trafficPercentile,omitempty"`
	// Type - The type of the variant. Possible values include: 'VariantTypeControl', 'VariantTypeTreatment'
	Type VariantType `json:"type,omitempty"`
	// Description - The description of the service.
	Description *string `json:"description,omitempty"`
	// KvTags - The service tag dictionary. Tags are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The service properties dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// Keys - The authentication keys.
	Keys *CreateServiceRequestKeys `json:"keys,omitempty"`
	// EnvironmentImageRequest - The Environment, models and assets needed for inferencing.
	EnvironmentImageRequest *CreateServiceRequestEnvironmentImageRequest `json:"environmentImageRequest,omitempty"`
	// Location - The name of the Azure location/region.
	Location *string `json:"location,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicCreateServiceRequestComputeTypeCreateServiceRequest', 'ComputeTypeBasicCreateServiceRequestComputeTypeACI', 'ComputeTypeBasicCreateServiceRequestComputeTypeAKS', 'ComputeTypeBasicCreateServiceRequestComputeTypeCustom'
	ComputeType ComputeTypeBasicCreateServiceRequest `json:"computeType,omitempty"`
}

func unmarshalBasicCreateEndpointVariantRequest(body []byte) (BasicCreateEndpointVariantRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicCreateServiceRequestComputeTypeAKS):
		var ascr AKSServiceCreateRequest
		err := json.Unmarshal(body, &ascr)
		return ascr, err
	default:
		var cevr CreateEndpointVariantRequest
		err := json.Unmarshal(body, &cevr)
		return cevr, err
	}
}
func unmarshalBasicCreateEndpointVariantRequestArray(body []byte) ([]BasicCreateEndpointVariantRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cevrArray := make([]BasicCreateEndpointVariantRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cevr, err := unmarshalBasicCreateEndpointVariantRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		cevrArray[index] = cevr
	}
	return cevrArray, nil
}

// MarshalJSON is the custom marshaler for CreateEndpointVariantRequest.
func (cevr CreateEndpointVariantRequest) MarshalJSON() ([]byte, error) {
	cevr.ComputeType = ComputeTypeBasicCreateServiceRequestComputeTypeCustom
	objectMap := make(map[string]interface{})
	if cevr.IsDefault != nil {
		objectMap["isDefault"] = cevr.IsDefault
	}
	if cevr.TrafficPercentile != nil {
		objectMap["trafficPercentile"] = cevr.TrafficPercentile
	}
	if cevr.Type != "" {
		objectMap["type"] = cevr.Type
	}
	if cevr.Description != nil {
		objectMap["description"] = cevr.Description
	}
	if cevr.KvTags != nil {
		objectMap["kvTags"] = cevr.KvTags
	}
	if cevr.Properties != nil {
		objectMap["properties"] = cevr.Properties
	}
	if cevr.Keys != nil {
		objectMap["keys"] = cevr.Keys
	}
	if cevr.EnvironmentImageRequest != nil {
		objectMap["environmentImageRequest"] = cevr.EnvironmentImageRequest
	}
	if cevr.Location != nil {
		objectMap["location"] = cevr.Location
	}
	if cevr.ComputeType != "" {
		objectMap["computeType"] = cevr.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsACIServiceCreateRequest is the BasicCreateServiceRequest implementation for CreateEndpointVariantRequest.
func (cevr CreateEndpointVariantRequest) AsACIServiceCreateRequest() (*ACIServiceCreateRequest, bool) {
	return nil, false
}

// AsAKSServiceCreateRequest is the BasicCreateServiceRequest implementation for CreateEndpointVariantRequest.
func (cevr CreateEndpointVariantRequest) AsAKSServiceCreateRequest() (*AKSServiceCreateRequest, bool) {
	return nil, false
}

// AsCreateEndpointVariantRequest is the BasicCreateServiceRequest implementation for CreateEndpointVariantRequest.
func (cevr CreateEndpointVariantRequest) AsCreateEndpointVariantRequest() (*CreateEndpointVariantRequest, bool) {
	return &cevr, true
}

// AsBasicCreateEndpointVariantRequest is the BasicCreateServiceRequest implementation for CreateEndpointVariantRequest.
func (cevr CreateEndpointVariantRequest) AsBasicCreateEndpointVariantRequest() (BasicCreateEndpointVariantRequest, bool) {
	return &cevr, true
}

// AsCreateServiceRequest is the BasicCreateServiceRequest implementation for CreateEndpointVariantRequest.
func (cevr CreateEndpointVariantRequest) AsCreateServiceRequest() (*CreateServiceRequest, bool) {
	return nil, false
}

// AsBasicCreateServiceRequest is the BasicCreateServiceRequest implementation for CreateEndpointVariantRequest.
func (cevr CreateEndpointVariantRequest) AsBasicCreateServiceRequest() (BasicCreateServiceRequest, bool) {
	return &cevr, true
}

// BasicCreateServiceRequest the base class for creating a service.
type BasicCreateServiceRequest interface {
	AsACIServiceCreateRequest() (*ACIServiceCreateRequest, bool)
	AsAKSServiceCreateRequest() (*AKSServiceCreateRequest, bool)
	AsCreateEndpointVariantRequest() (*CreateEndpointVariantRequest, bool)
	AsBasicCreateEndpointVariantRequest() (BasicCreateEndpointVariantRequest, bool)
	AsCreateServiceRequest() (*CreateServiceRequest, bool)
}

// CreateServiceRequest the base class for creating a service.
type CreateServiceRequest struct {
	// Description - The description of the service.
	Description *string `json:"description,omitempty"`
	// KvTags - The service tag dictionary. Tags are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The service properties dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// Keys - The authentication keys.
	Keys *CreateServiceRequestKeys `json:"keys,omitempty"`
	// EnvironmentImageRequest - The Environment, models and assets needed for inferencing.
	EnvironmentImageRequest *CreateServiceRequestEnvironmentImageRequest `json:"environmentImageRequest,omitempty"`
	// Location - The name of the Azure location/region.
	Location *string `json:"location,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicCreateServiceRequestComputeTypeCreateServiceRequest', 'ComputeTypeBasicCreateServiceRequestComputeTypeACI', 'ComputeTypeBasicCreateServiceRequestComputeTypeAKS', 'ComputeTypeBasicCreateServiceRequestComputeTypeCustom'
	ComputeType ComputeTypeBasicCreateServiceRequest `json:"computeType,omitempty"`
}

func unmarshalBasicCreateServiceRequest(body []byte) (BasicCreateServiceRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicCreateServiceRequestComputeTypeACI):
		var ascr ACIServiceCreateRequest
		err := json.Unmarshal(body, &ascr)
		return ascr, err
	case string(ComputeTypeBasicCreateServiceRequestComputeTypeAKS):
		var ascr AKSServiceCreateRequest
		err := json.Unmarshal(body, &ascr)
		return ascr, err
	case string(ComputeTypeBasicCreateServiceRequestComputeTypeCustom):
		var cevr CreateEndpointVariantRequest
		err := json.Unmarshal(body, &cevr)
		return cevr, err
	default:
		var csr CreateServiceRequest
		err := json.Unmarshal(body, &csr)
		return csr, err
	}
}
func unmarshalBasicCreateServiceRequestArray(body []byte) ([]BasicCreateServiceRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csrArray := make([]BasicCreateServiceRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		csr, err := unmarshalBasicCreateServiceRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		csrArray[index] = csr
	}
	return csrArray, nil
}

// MarshalJSON is the custom marshaler for CreateServiceRequest.
func (csr CreateServiceRequest) MarshalJSON() ([]byte, error) {
	csr.ComputeType = ComputeTypeBasicCreateServiceRequestComputeTypeCreateServiceRequest
	objectMap := make(map[string]interface{})
	if csr.Description != nil {
		objectMap["description"] = csr.Description
	}
	if csr.KvTags != nil {
		objectMap["kvTags"] = csr.KvTags
	}
	if csr.Properties != nil {
		objectMap["properties"] = csr.Properties
	}
	if csr.Keys != nil {
		objectMap["keys"] = csr.Keys
	}
	if csr.EnvironmentImageRequest != nil {
		objectMap["environmentImageRequest"] = csr.EnvironmentImageRequest
	}
	if csr.Location != nil {
		objectMap["location"] = csr.Location
	}
	if csr.ComputeType != "" {
		objectMap["computeType"] = csr.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsACIServiceCreateRequest is the BasicCreateServiceRequest implementation for CreateServiceRequest.
func (csr CreateServiceRequest) AsACIServiceCreateRequest() (*ACIServiceCreateRequest, bool) {
	return nil, false
}

// AsAKSServiceCreateRequest is the BasicCreateServiceRequest implementation for CreateServiceRequest.
func (csr CreateServiceRequest) AsAKSServiceCreateRequest() (*AKSServiceCreateRequest, bool) {
	return nil, false
}

// AsCreateEndpointVariantRequest is the BasicCreateServiceRequest implementation for CreateServiceRequest.
func (csr CreateServiceRequest) AsCreateEndpointVariantRequest() (*CreateEndpointVariantRequest, bool) {
	return nil, false
}

// AsBasicCreateEndpointVariantRequest is the BasicCreateServiceRequest implementation for CreateServiceRequest.
func (csr CreateServiceRequest) AsBasicCreateEndpointVariantRequest() (BasicCreateEndpointVariantRequest, bool) {
	return nil, false
}

// AsCreateServiceRequest is the BasicCreateServiceRequest implementation for CreateServiceRequest.
func (csr CreateServiceRequest) AsCreateServiceRequest() (*CreateServiceRequest, bool) {
	return &csr, true
}

// AsBasicCreateServiceRequest is the BasicCreateServiceRequest implementation for CreateServiceRequest.
func (csr CreateServiceRequest) AsBasicCreateServiceRequest() (BasicCreateServiceRequest, bool) {
	return &csr, true
}

// CreateServiceRequestEnvironmentImageRequest the Environment, models and assets needed for inferencing.
type CreateServiceRequestEnvironmentImageRequest struct {
	// DriverProgram - The name of the driver file.
	DriverProgram *string `json:"driverProgram,omitempty"`
	// Assets - The list of assets.
	Assets *[]ImageAsset `json:"assets,omitempty"`
	// ModelIds - The list of model Ids.
	ModelIds *[]string `json:"modelIds,omitempty"`
	// ModelsProperty - The list of models.
	ModelsProperty *[]Model `json:"models,omitempty"`
	// Environment - The details of the AZURE ML environment.
	Environment *EnvironmentImageRequestEnvironment `json:"environment,omitempty"`
	// EnvironmentReference - The unique identifying details of the AZURE ML environment.
	EnvironmentReference *EnvironmentImageRequestEnvironmentReference `json:"environmentReference,omitempty"`
}

// CreateServiceRequestKeys the authentication keys.
type CreateServiceRequestKeys struct {
	// PrimaryKey - The primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// Databricks a DataFactory compute.
type Databricks struct {
	Properties *DatabricksProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for Databricks.
func (d Databricks) MarshalJSON() ([]byte, error) {
	d.ComputeType = ComputeTypeBasicComputeComputeTypeDatabricks
	objectMap := make(map[string]interface{})
	if d.Properties != nil {
		objectMap["properties"] = d.Properties
	}
	if d.ComputeLocation != nil {
		objectMap["computeLocation"] = d.ComputeLocation
	}
	if d.Description != nil {
		objectMap["description"] = d.Description
	}
	if d.ResourceID != nil {
		objectMap["resourceId"] = d.ResourceID
	}
	if d.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = d.DisableLocalAuth
	}
	if d.ComputeType != "" {
		objectMap["computeType"] = d.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for Databricks.
func (d Databricks) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for Databricks.
func (d Databricks) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for Databricks.
func (d Databricks) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for Databricks.
func (d Databricks) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for Databricks.
func (d Databricks) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for Databricks.
func (d Databricks) AsDatabricks() (*Databricks, bool) {
	return &d, true
}

// AsDataLakeAnalytics is the BasicCompute implementation for Databricks.
func (d Databricks) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for Databricks.
func (d Databricks) AsBasicCompute() (BasicCompute, bool) {
	return &d, true
}

// DatabricksComputeSecrets secrets related to a Machine Learning compute based on Databricks.
type DatabricksComputeSecrets struct {
	// DatabricksAccessToken - access token for databricks account.
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine', 'ComputeTypeBasicComputeSecretsComputeTypeDatabricks'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) MarshalJSON() ([]byte, error) {
	dcs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeDatabricks
	objectMap := make(map[string]interface{})
	if dcs.DatabricksAccessToken != nil {
		objectMap["databricksAccessToken"] = dcs.DatabricksAccessToken
	}
	if dcs.ComputeType != "" {
		objectMap["computeType"] = dcs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return nil, false
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsDatabricksComputeSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool) {
	return &dcs, true
}

// AsComputeSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for DatabricksComputeSecrets.
func (dcs DatabricksComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &dcs, true
}

// DatabricksProperties ...
type DatabricksProperties struct {
	// DatabricksAccessToken - Databricks access token
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
	// WorkspaceURL - Workspace Url
	WorkspaceURL *string `json:"workspaceUrl,omitempty"`
}

// DataFactory a DataFactory compute.
type DataFactory struct {
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataFactory.
func (df DataFactory) MarshalJSON() ([]byte, error) {
	df.ComputeType = ComputeTypeBasicComputeComputeTypeDataFactory
	objectMap := make(map[string]interface{})
	if df.ComputeLocation != nil {
		objectMap["computeLocation"] = df.ComputeLocation
	}
	if df.Description != nil {
		objectMap["description"] = df.Description
	}
	if df.ResourceID != nil {
		objectMap["resourceId"] = df.ResourceID
	}
	if df.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = df.DisableLocalAuth
	}
	if df.ComputeType != "" {
		objectMap["computeType"] = df.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDataFactory() (*DataFactory, bool) {
	return &df, true
}

// AsDatabricks is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsBasicCompute() (BasicCompute, bool) {
	return &df, true
}

// DataLakeAnalytics a DataLakeAnalytics compute.
type DataLakeAnalytics struct {
	Properties *DataLakeAnalyticsProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataLakeAnalytics.
func (dla DataLakeAnalytics) MarshalJSON() ([]byte, error) {
	dla.ComputeType = ComputeTypeBasicComputeComputeTypeDataLakeAnalytics
	objectMap := make(map[string]interface{})
	if dla.Properties != nil {
		objectMap["properties"] = dla.Properties
	}
	if dla.ComputeLocation != nil {
		objectMap["computeLocation"] = dla.ComputeLocation
	}
	if dla.Description != nil {
		objectMap["description"] = dla.Description
	}
	if dla.ResourceID != nil {
		objectMap["resourceId"] = dla.ResourceID
	}
	if dla.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = dla.DisableLocalAuth
	}
	if dla.ComputeType != "" {
		objectMap["computeType"] = dla.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return &dla, true
}

// AsCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for DataLakeAnalytics.
func (dla DataLakeAnalytics) AsBasicCompute() (BasicCompute, bool) {
	return &dla, true
}

// DataLakeAnalyticsProperties ...
type DataLakeAnalyticsProperties struct {
	// DataLakeStoreAccountName - DataLake Store Account Name
	DataLakeStoreAccountName *string `json:"dataLakeStoreAccountName,omitempty"`
}

// DatasetReference the dataset reference object.
type DatasetReference struct {
	// Name - The name of the dataset reference.
	Name *string `json:"name,omitempty"`
	// ID - The id of the dataset reference.
	ID *string `json:"id,omitempty"`
}

// EncryptionProperties ...
type EncryptionProperties struct {
	// VaultBaseURL - vault base Url
	VaultBaseURL *string `json:"vaultBaseUrl,omitempty"`
	// KeyName - Encryption Key name
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - Encryption Key Version
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// EncryptionProperty ...
type EncryptionProperty struct {
	// Status - Indicates whether or not the encryption is enabled for the workspace. Possible values include: 'EncryptionStatusEnabled', 'EncryptionStatusDisabled'
	Status EncryptionStatus `json:"status,omitempty"`
	// Identity - The identity that will be used to access the key vault for encryption at rest.
	Identity *IdentityForCmk `json:"identity,omitempty"`
	// KeyVaultProperties - Customer Key vault properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// EnvironmentImageRequest request to create a Docker image based on Environment.
type EnvironmentImageRequest struct {
	// DriverProgram - The name of the driver file.
	DriverProgram *string `json:"driverProgram,omitempty"`
	// Assets - The list of assets.
	Assets *[]ImageAsset `json:"assets,omitempty"`
	// ModelIds - The list of model Ids.
	ModelIds *[]string `json:"modelIds,omitempty"`
	// ModelsProperty - The list of models.
	ModelsProperty *[]Model `json:"models,omitempty"`
	// Environment - The details of the AZURE ML environment.
	Environment *EnvironmentImageRequestEnvironment `json:"environment,omitempty"`
	// EnvironmentReference - The unique identifying details of the AZURE ML environment.
	EnvironmentReference *EnvironmentImageRequestEnvironmentReference `json:"environmentReference,omitempty"`
}

// EnvironmentImageRequestEnvironment the details of the AZURE ML environment.
type EnvironmentImageRequestEnvironment struct {
	// Name - The name of the environment.
	Name *string `json:"name,omitempty"`
	// Version - The environment version.
	Version *string `json:"version,omitempty"`
	// Python - Settings for a Python environment.
	Python *ModelEnvironmentDefinitionPython `json:"python,omitempty"`
	// EnvironmentVariables - Definition of environment variables to be defined in the environment.
	EnvironmentVariables map[string]*string `json:"environmentVariables"`
	// Docker - The definition of a Docker container.
	Docker *ModelEnvironmentDefinitionDocker `json:"docker,omitempty"`
	// Spark - The configuration for a Spark environment.
	Spark *ModelEnvironmentDefinitionSpark `json:"spark,omitempty"`
	// R - Settings for a R environment.
	R *ModelEnvironmentDefinitionR `json:"r,omitempty"`
	// InferencingStackVersion - The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: "latest".
	InferencingStackVersion *string `json:"inferencingStackVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentImageRequestEnvironment.
func (eir EnvironmentImageRequestEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eir.Name != nil {
		objectMap["name"] = eir.Name
	}
	if eir.Version != nil {
		objectMap["version"] = eir.Version
	}
	if eir.Python != nil {
		objectMap["python"] = eir.Python
	}
	if eir.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = eir.EnvironmentVariables
	}
	if eir.Docker != nil {
		objectMap["docker"] = eir.Docker
	}
	if eir.Spark != nil {
		objectMap["spark"] = eir.Spark
	}
	if eir.R != nil {
		objectMap["r"] = eir.R
	}
	if eir.InferencingStackVersion != nil {
		objectMap["inferencingStackVersion"] = eir.InferencingStackVersion
	}
	return json.Marshal(objectMap)
}

// EnvironmentImageRequestEnvironmentReference the unique identifying details of the AZURE ML environment.
type EnvironmentImageRequestEnvironmentReference struct {
	// Name - Name of the environment.
	Name *string `json:"name,omitempty"`
	// Version - Version of the environment.
	Version *string `json:"version,omitempty"`
}

// EnvironmentImageResponse request to create a Docker image based on Environment.
type EnvironmentImageResponse struct {
	// DriverProgram - The name of the driver file.
	DriverProgram *string `json:"driverProgram,omitempty"`
	// Assets - The list of assets.
	Assets *[]ImageAsset `json:"assets,omitempty"`
	// ModelIds - The list of model Ids.
	ModelIds *[]string `json:"modelIds,omitempty"`
	// ModelsProperty - The list of models.
	ModelsProperty *[]Model `json:"models,omitempty"`
	// Environment - The details of the AZURE ML environment.
	Environment *EnvironmentImageResponseEnvironment `json:"environment,omitempty"`
	// EnvironmentReference - The unique identifying details of the AZURE ML environment.
	EnvironmentReference *EnvironmentImageResponseEnvironmentReference `json:"environmentReference,omitempty"`
}

// EnvironmentImageResponseEnvironment the details of the AZURE ML environment.
type EnvironmentImageResponseEnvironment struct {
	// Name - The name of the environment.
	Name *string `json:"name,omitempty"`
	// Version - The environment version.
	Version *string `json:"version,omitempty"`
	// Python - Settings for a Python environment.
	Python *ModelEnvironmentDefinitionResponsePython `json:"python,omitempty"`
	// EnvironmentVariables - Definition of environment variables to be defined in the environment.
	EnvironmentVariables map[string]*string `json:"environmentVariables"`
	// Docker - The definition of a Docker container.
	Docker *ModelEnvironmentDefinitionResponseDocker `json:"docker,omitempty"`
	// Spark - The configuration for a Spark environment.
	Spark *ModelEnvironmentDefinitionResponseSpark `json:"spark,omitempty"`
	// R - Settings for a R environment.
	R *ModelEnvironmentDefinitionResponseR `json:"r,omitempty"`
	// InferencingStackVersion - The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: "latest".
	InferencingStackVersion *string `json:"inferencingStackVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentImageResponseEnvironment.
func (eir EnvironmentImageResponseEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eir.Name != nil {
		objectMap["name"] = eir.Name
	}
	if eir.Version != nil {
		objectMap["version"] = eir.Version
	}
	if eir.Python != nil {
		objectMap["python"] = eir.Python
	}
	if eir.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = eir.EnvironmentVariables
	}
	if eir.Docker != nil {
		objectMap["docker"] = eir.Docker
	}
	if eir.Spark != nil {
		objectMap["spark"] = eir.Spark
	}
	if eir.R != nil {
		objectMap["r"] = eir.R
	}
	if eir.InferencingStackVersion != nil {
		objectMap["inferencingStackVersion"] = eir.InferencingStackVersion
	}
	return json.Marshal(objectMap)
}

// EnvironmentImageResponseEnvironmentReference the unique identifying details of the AZURE ML environment.
type EnvironmentImageResponseEnvironmentReference struct {
	// Name - Name of the environment.
	Name *string `json:"name,omitempty"`
	// Version - Version of the environment.
	Version *string `json:"version,omitempty"`
}

// EnvironmentReference ...
type EnvironmentReference struct {
	// Name - Name of the environment.
	Name *string `json:"name,omitempty"`
	// Version - Version of the environment.
	Version *string `json:"version,omitempty"`
}

// Error wrapper for error response to follow ARM guidelines.
type Error struct {
	// Error - READ-ONLY; The error response.
	Error *ErrorResponse `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail error detail information.
type ErrorDetail struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error response information.
type ErrorResponse struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The target of the particular error
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; An array of error detail objects.
	Details *[]ErrorDetail `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EstimatedVMPrice the estimated price info for using a VM of a particular OS type, tier, etc.
type EstimatedVMPrice struct {
	// RetailPrice - The price charged for using the VM.
	RetailPrice *float64 `json:"retailPrice,omitempty"`
	// OsType - Operating system type used by the VM. Possible values include: 'VMPriceOSTypeLinux', 'VMPriceOSTypeWindows'
	OsType VMPriceOSType `json:"osType,omitempty"`
	// VMTier - The type of the VM. Possible values include: 'VMTierStandard', 'VMTierLowPriority', 'VMTierSpot'
	VMTier VMTier `json:"vmTier,omitempty"`
}

// EstimatedVMPrices the estimated price info for using a VM.
type EstimatedVMPrices struct {
	// BillingCurrency - Three lettered code specifying the currency of the VM price. Example: USD
	BillingCurrency *string `json:"billingCurrency,omitempty"`
	// UnitOfMeasure - The unit of time measurement for the specified VM price. Example: OneHour
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// Values - The list of estimated prices for using a VM of a particular OS type, tier, etc.
	Values *[]EstimatedVMPrice `json:"values,omitempty"`
}

// HDInsight a HDInsight compute.
type HDInsight struct {
	Properties *HDInsightProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for HDInsight.
func (hi HDInsight) MarshalJSON() ([]byte, error) {
	hi.ComputeType = ComputeTypeBasicComputeComputeTypeHDInsight
	objectMap := make(map[string]interface{})
	if hi.Properties != nil {
		objectMap["properties"] = hi.Properties
	}
	if hi.ComputeLocation != nil {
		objectMap["computeLocation"] = hi.ComputeLocation
	}
	if hi.Description != nil {
		objectMap["description"] = hi.Description
	}
	if hi.ResourceID != nil {
		objectMap["resourceId"] = hi.ResourceID
	}
	if hi.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = hi.DisableLocalAuth
	}
	if hi.ComputeType != "" {
		objectMap["computeType"] = hi.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsHDInsight() (*HDInsight, bool) {
	return &hi, true
}

// AsDataFactory is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsBasicCompute() (BasicCompute, bool) {
	return &hi, true
}

// HDInsightProperties ...
type HDInsightProperties struct {
	// SSHPort - Port open for ssh connections on the master node of the cluster.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// Address - Public IP address of the master node of the cluster.
	Address *string `json:"address,omitempty"`
	// AdministratorAccount - Admin credentials for master node of the cluster
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The user assigned identities associated with the resource.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// IdentityForCmk identity that will be used to access key vault for encryption at rest
type IdentityForCmk struct {
	// UserAssignedIdentity - The ArmId of the user assigned identity that will be used to access the customer managed key vault
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// ImageAsset an Image asset.
type ImageAsset struct {
	// ID - The Asset Id.
	ID *string `json:"id,omitempty"`
	// MimeType - The mime type.
	MimeType *string `json:"mimeType,omitempty"`
	// URL - The Url of the Asset.
	URL *string `json:"url,omitempty"`
	// Unpack - Whether the Asset is unpacked.
	Unpack *bool `json:"unpack,omitempty"`
}

// KeyVaultProperties ...
type KeyVaultProperties struct {
	// KeyVaultArmID - The ArmId of the keyVault where the customer owned encryption key is present.
	KeyVaultArmID *string `json:"keyVaultArmId,omitempty"`
	// KeyIdentifier - Key vault uri to access the encryption key.
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// IdentityClientID - For future use - The client id of the identity which will be used to access key vault.
	IdentityClientID *string `json:"identityClientId,omitempty"`
}

// ListAmlUserFeatureResult the List Aml user feature operation response.
type ListAmlUserFeatureResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of AML user facing features.
	Value *[]AmlUserFeature `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of AML user features information. Call ListNext() with this to fetch the next page of AML user features information.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListAmlUserFeatureResult.
func (laufr ListAmlUserFeatureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListAmlUserFeatureResultIterator provides access to a complete listing of AmlUserFeature values.
type ListAmlUserFeatureResultIterator struct {
	i    int
	page ListAmlUserFeatureResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListAmlUserFeatureResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListAmlUserFeatureResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListAmlUserFeatureResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListAmlUserFeatureResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListAmlUserFeatureResultIterator) Response() ListAmlUserFeatureResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListAmlUserFeatureResultIterator) Value() AmlUserFeature {
	if !iter.page.NotDone() {
		return AmlUserFeature{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListAmlUserFeatureResultIterator type.
func NewListAmlUserFeatureResultIterator(page ListAmlUserFeatureResultPage) ListAmlUserFeatureResultIterator {
	return ListAmlUserFeatureResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (laufr ListAmlUserFeatureResult) IsEmpty() bool {
	return laufr.Value == nil || len(*laufr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (laufr ListAmlUserFeatureResult) hasNextLink() bool {
	return laufr.NextLink != nil && len(*laufr.NextLink) != 0
}

// listAmlUserFeatureResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (laufr ListAmlUserFeatureResult) listAmlUserFeatureResultPreparer(ctx context.Context) (*http.Request, error) {
	if !laufr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(laufr.NextLink)))
}

// ListAmlUserFeatureResultPage contains a page of AmlUserFeature values.
type ListAmlUserFeatureResultPage struct {
	fn    func(context.Context, ListAmlUserFeatureResult) (ListAmlUserFeatureResult, error)
	laufr ListAmlUserFeatureResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListAmlUserFeatureResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListAmlUserFeatureResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.laufr)
		if err != nil {
			return err
		}
		page.laufr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListAmlUserFeatureResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListAmlUserFeatureResultPage) NotDone() bool {
	return !page.laufr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListAmlUserFeatureResultPage) Response() ListAmlUserFeatureResult {
	return page.laufr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListAmlUserFeatureResultPage) Values() []AmlUserFeature {
	if page.laufr.IsEmpty() {
		return nil
	}
	return *page.laufr.Value
}

// Creates a new instance of the ListAmlUserFeatureResultPage type.
func NewListAmlUserFeatureResultPage(cur ListAmlUserFeatureResult, getNextPage func(context.Context, ListAmlUserFeatureResult) (ListAmlUserFeatureResult, error)) ListAmlUserFeatureResultPage {
	return ListAmlUserFeatureResultPage{
		fn:    getNextPage,
		laufr: cur,
	}
}

// ListNotebookKeysResult ...
type ListNotebookKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryAccessKey - READ-ONLY
	PrimaryAccessKey *string `json:"primaryAccessKey,omitempty"`
	// SecondaryAccessKey - READ-ONLY
	SecondaryAccessKey *string `json:"secondaryAccessKey,omitempty"`
}

// MarshalJSON is the custom marshaler for ListNotebookKeysResult.
func (lnkr ListNotebookKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListStorageAccountKeysResult ...
type ListStorageAccountKeysResult struct {
	autorest.Response `json:"-"`
	// UserStorageKey - READ-ONLY
	UserStorageKey *string `json:"userStorageKey,omitempty"`
}

// MarshalJSON is the custom marshaler for ListStorageAccountKeysResult.
func (lsakr ListStorageAccountKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListUsagesResult the List Usages operation response.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of AML resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of AML resource usage information. Call ListNext() with this to fetch the next page of AML resource usage information.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListUsagesResult.
func (lur ListUsagesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListUsagesResultIterator provides access to a complete listing of Usage values.
type ListUsagesResultIterator struct {
	i    int
	page ListUsagesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListUsagesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListUsagesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListUsagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListUsagesResultIterator) Response() ListUsagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListUsagesResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListUsagesResultIterator type.
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return ListUsagesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lur ListUsagesResult) IsEmpty() bool {
	return lur.Value == nil || len(*lur.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lur ListUsagesResult) hasNextLink() bool {
	return lur.NextLink != nil && len(*lur.NextLink) != 0
}

// listUsagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lur ListUsagesResult) listUsagesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lur.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lur.NextLink)))
}

// ListUsagesResultPage contains a page of Usage values.
type ListUsagesResultPage struct {
	fn  func(context.Context, ListUsagesResult) (ListUsagesResult, error)
	lur ListUsagesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListUsagesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lur)
		if err != nil {
			return err
		}
		page.lur = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListUsagesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListUsagesResultPage) NotDone() bool {
	return !page.lur.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListUsagesResultPage) Response() ListUsagesResult {
	return page.lur
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListUsagesResultPage) Values() []Usage {
	if page.lur.IsEmpty() {
		return nil
	}
	return *page.lur.Value
}

// Creates a new instance of the ListUsagesResultPage type.
func NewListUsagesResultPage(cur ListUsagesResult, getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return ListUsagesResultPage{
		fn:  getNextPage,
		lur: cur,
	}
}

// ListWorkspaceKeysResult ...
type ListWorkspaceKeysResult struct {
	autorest.Response `json:"-"`
	// UserStorageKey - READ-ONLY
	UserStorageKey *string `json:"userStorageKey,omitempty"`
	// UserStorageResourceID - READ-ONLY
	UserStorageResourceID *string `json:"userStorageResourceId,omitempty"`
	// AppInsightsInstrumentationKey - READ-ONLY
	AppInsightsInstrumentationKey *string `json:"appInsightsInstrumentationKey,omitempty"`
	// ContainerRegistryCredentials - READ-ONLY
	ContainerRegistryCredentials *RegistryListCredentialsResult `json:"containerRegistryCredentials,omitempty"`
	// NotebookAccessKeys - READ-ONLY
	NotebookAccessKeys *ListNotebookKeysResult `json:"notebookAccessKeys,omitempty"`
}

// MarshalJSON is the custom marshaler for ListWorkspaceKeysResult.
func (lwkr ListWorkspaceKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListWorkspaceQuotas the List WorkspaceQuotasByVMFamily operation response.
type ListWorkspaceQuotas struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of Workspace Quotas by VM Family
	Value *[]ResourceQuota `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of workspace quota information by VM Family. Call ListNext() with this to fetch the next page of Workspace Quota information.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListWorkspaceQuotas.
func (lwq ListWorkspaceQuotas) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListWorkspaceQuotasIterator provides access to a complete listing of ResourceQuota values.
type ListWorkspaceQuotasIterator struct {
	i    int
	page ListWorkspaceQuotasPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListWorkspaceQuotasIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListWorkspaceQuotasIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListWorkspaceQuotasIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListWorkspaceQuotasIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListWorkspaceQuotasIterator) Response() ListWorkspaceQuotas {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListWorkspaceQuotasIterator) Value() ResourceQuota {
	if !iter.page.NotDone() {
		return ResourceQuota{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListWorkspaceQuotasIterator type.
func NewListWorkspaceQuotasIterator(page ListWorkspaceQuotasPage) ListWorkspaceQuotasIterator {
	return ListWorkspaceQuotasIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lwq ListWorkspaceQuotas) IsEmpty() bool {
	return lwq.Value == nil || len(*lwq.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lwq ListWorkspaceQuotas) hasNextLink() bool {
	return lwq.NextLink != nil && len(*lwq.NextLink) != 0
}

// listWorkspaceQuotasPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lwq ListWorkspaceQuotas) listWorkspaceQuotasPreparer(ctx context.Context) (*http.Request, error) {
	if !lwq.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lwq.NextLink)))
}

// ListWorkspaceQuotasPage contains a page of ResourceQuota values.
type ListWorkspaceQuotasPage struct {
	fn  func(context.Context, ListWorkspaceQuotas) (ListWorkspaceQuotas, error)
	lwq ListWorkspaceQuotas
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListWorkspaceQuotasPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListWorkspaceQuotasPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lwq)
		if err != nil {
			return err
		}
		page.lwq = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListWorkspaceQuotasPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListWorkspaceQuotasPage) NotDone() bool {
	return !page.lwq.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListWorkspaceQuotasPage) Response() ListWorkspaceQuotas {
	return page.lwq
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListWorkspaceQuotasPage) Values() []ResourceQuota {
	if page.lwq.IsEmpty() {
		return nil
	}
	return *page.lwq.Value
}

// Creates a new instance of the ListWorkspaceQuotasPage type.
func NewListWorkspaceQuotasPage(cur ListWorkspaceQuotas, getNextPage func(context.Context, ListWorkspaceQuotas) (ListWorkspaceQuotas, error)) ListWorkspaceQuotasPage {
	return ListWorkspaceQuotasPage{
		fn:  getNextPage,
		lwq: cur,
	}
}

// LivenessProbeRequirements the liveness probe requirements.
type LivenessProbeRequirements struct {
	// FailureThreshold - The number of failures to allow before returning an unhealthy status.
	FailureThreshold *int32 `json:"failureThreshold,omitempty"`
	// SuccessThreshold - The number of successful probes before returning a healthy status.
	SuccessThreshold *int32 `json:"successThreshold,omitempty"`
	// TimeoutSeconds - The probe timeout in seconds.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
	// PeriodSeconds - The length of time between probes in seconds.
	PeriodSeconds *int32 `json:"periodSeconds,omitempty"`
	// InitialDelaySeconds - The delay before the first probe in seconds.
	InitialDelaySeconds *int32 `json:"initialDelaySeconds,omitempty"`
}

// MachineLearningComputeCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MachineLearningComputeClient) (ComputeResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MachineLearningComputeCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MachineLearningComputeCreateOrUpdateFuture.Result.
func (future *MachineLearningComputeCreateOrUpdateFuture) result(client MachineLearningComputeClient) (cr ComputeResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.CreateOrUpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeCreateOrUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MachineLearningComputeDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MachineLearningComputeClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MachineLearningComputeDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MachineLearningComputeDeleteFuture.Result.
func (future *MachineLearningComputeDeleteFuture) result(client MachineLearningComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MachineLearningComputeStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MachineLearningComputeClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MachineLearningComputeStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MachineLearningComputeStartFuture.Result.
func (future *MachineLearningComputeStartFuture) result(client MachineLearningComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MachineLearningComputeStopFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MachineLearningComputeClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MachineLearningComputeStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MachineLearningComputeStopFuture.Result.
func (future *MachineLearningComputeStopFuture) result(client MachineLearningComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MachineLearningComputeUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MachineLearningComputeClient) (ComputeResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MachineLearningComputeUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MachineLearningComputeUpdateFuture.Result.
func (future *MachineLearningComputeUpdateFuture) result(client MachineLearningComputeClient) (cr ComputeResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.UpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MachineLearningServiceCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningServiceCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (ServiceResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MachineLearningServiceCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MachineLearningServiceCreateOrUpdateFuture.Result.
func (future *MachineLearningServiceCreateOrUpdateFuture) result(client Client) (sr ServiceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningServiceCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningServiceCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateOrUpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningServiceCreateOrUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Model an Azure Machine Learning Model.
type Model struct {
	// ID - The Model Id.
	ID *string `json:"id,omitempty"`
	// Name - The Model name.
	Name *string `json:"name,omitempty"`
	// Framework - The Model framework.
	Framework *string `json:"framework,omitempty"`
	// FrameworkVersion - The Model framework version.
	FrameworkVersion *string `json:"frameworkVersion,omitempty"`
	// Version - The Model version assigned by Model Management Service.
	Version *int64 `json:"version,omitempty"`
	// Datasets - The list of datasets associated with the model.
	Datasets *[]DatasetReference `json:"datasets,omitempty"`
	// URL - The URL of the Model. Usually a SAS URL.
	URL *string `json:"url,omitempty"`
	// MimeType - The MIME type of Model content. For more details about MIME type, please open https://www.iana.org/assignments/media-types/media-types.xhtml
	MimeType *string `json:"mimeType,omitempty"`
	// Description - The Model description text.
	Description *string `json:"description,omitempty"`
	// CreatedTime - The Model creation time (UTC).
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ModifiedTime - The Model last modified time (UTC).
	ModifiedTime *date.Time `json:"modifiedTime,omitempty"`
	// Unpack - Indicates whether we need to unpack the Model during docker Image creation.
	Unpack *bool `json:"unpack,omitempty"`
	// ParentModelID - The Parent Model Id.
	ParentModelID *string `json:"parentModelId,omitempty"`
	// RunID - The RunId that created this model.
	RunID *string `json:"runId,omitempty"`
	// ExperimentName - The name of the experiment where this model was created.
	ExperimentName *string `json:"experimentName,omitempty"`
	// KvTags - The Model tag dictionary. Items are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The Model property dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// DerivedModelIds - Models derived from this model
	DerivedModelIds *[]string `json:"derivedModelIds,omitempty"`
	// SampleInputData - Sample Input Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
	SampleInputData *string `json:"sampleInputData,omitempty"`
	// SampleOutputData - Sample Output Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
	SampleOutputData *string `json:"sampleOutputData,omitempty"`
	// ResourceRequirements - Resource requirements for the model
	ResourceRequirements *ContainerResourceRequirements `json:"resourceRequirements,omitempty"`
}

// MarshalJSON is the custom marshaler for Model.
func (mVar Model) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.ID != nil {
		objectMap["id"] = mVar.ID
	}
	if mVar.Name != nil {
		objectMap["name"] = mVar.Name
	}
	if mVar.Framework != nil {
		objectMap["framework"] = mVar.Framework
	}
	if mVar.FrameworkVersion != nil {
		objectMap["frameworkVersion"] = mVar.FrameworkVersion
	}
	if mVar.Version != nil {
		objectMap["version"] = mVar.Version
	}
	if mVar.Datasets != nil {
		objectMap["datasets"] = mVar.Datasets
	}
	if mVar.URL != nil {
		objectMap["url"] = mVar.URL
	}
	if mVar.MimeType != nil {
		objectMap["mimeType"] = mVar.MimeType
	}
	if mVar.Description != nil {
		objectMap["description"] = mVar.Description
	}
	if mVar.CreatedTime != nil {
		objectMap["createdTime"] = mVar.CreatedTime
	}
	if mVar.ModifiedTime != nil {
		objectMap["modifiedTime"] = mVar.ModifiedTime
	}
	if mVar.Unpack != nil {
		objectMap["unpack"] = mVar.Unpack
	}
	if mVar.ParentModelID != nil {
		objectMap["parentModelId"] = mVar.ParentModelID
	}
	if mVar.RunID != nil {
		objectMap["runId"] = mVar.RunID
	}
	if mVar.ExperimentName != nil {
		objectMap["experimentName"] = mVar.ExperimentName
	}
	if mVar.KvTags != nil {
		objectMap["kvTags"] = mVar.KvTags
	}
	if mVar.Properties != nil {
		objectMap["properties"] = mVar.Properties
	}
	if mVar.DerivedModelIds != nil {
		objectMap["derivedModelIds"] = mVar.DerivedModelIds
	}
	if mVar.SampleInputData != nil {
		objectMap["sampleInputData"] = mVar.SampleInputData
	}
	if mVar.SampleOutputData != nil {
		objectMap["sampleOutputData"] = mVar.SampleOutputData
	}
	if mVar.ResourceRequirements != nil {
		objectMap["resourceRequirements"] = mVar.ResourceRequirements
	}
	return json.Marshal(objectMap)
}

// ModelDataCollection the Model data collection properties.
type ModelDataCollection struct {
	// EventHubEnabled - Option for enabling/disabling Event Hub.
	EventHubEnabled *bool `json:"eventHubEnabled,omitempty"`
	// StorageEnabled - Option for enabling/disabling storage.
	StorageEnabled *bool `json:"storageEnabled,omitempty"`
}

// ModelDockerSection ...
type ModelDockerSection struct {
	// BaseImage - Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile.
	BaseImage *string `json:"baseImage,omitempty"`
	// BaseDockerfile - Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage.
	BaseDockerfile *string `json:"baseDockerfile,omitempty"`
	// BaseImageRegistry - Image registry that contains the base image.
	BaseImageRegistry *ModelDockerSectionBaseImageRegistry `json:"baseImageRegistry,omitempty"`
}

// ModelDockerSectionBaseImageRegistry image registry that contains the base image.
type ModelDockerSectionBaseImageRegistry struct {
	Address  *string `json:"address,omitempty"`
	Username *string `json:"username,omitempty"`
	Password *string `json:"password,omitempty"`
}

// ModelDockerSectionResponse ...
type ModelDockerSectionResponse struct {
	// BaseImage - Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile.
	BaseImage *string `json:"baseImage,omitempty"`
	// BaseDockerfile - Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage.
	BaseDockerfile *string `json:"baseDockerfile,omitempty"`
	// BaseImageRegistry - Image registry that contains the base image.
	BaseImageRegistry *ModelDockerSectionResponseBaseImageRegistry `json:"baseImageRegistry,omitempty"`
}

// ModelDockerSectionResponseBaseImageRegistry image registry that contains the base image.
type ModelDockerSectionResponseBaseImageRegistry struct {
	Address *string `json:"address,omitempty"`
}

// ModelEnvironmentDefinition ...
type ModelEnvironmentDefinition struct {
	// Name - The name of the environment.
	Name *string `json:"name,omitempty"`
	// Version - The environment version.
	Version *string `json:"version,omitempty"`
	// Python - Settings for a Python environment.
	Python *ModelEnvironmentDefinitionPython `json:"python,omitempty"`
	// EnvironmentVariables - Definition of environment variables to be defined in the environment.
	EnvironmentVariables map[string]*string `json:"environmentVariables"`
	// Docker - The definition of a Docker container.
	Docker *ModelEnvironmentDefinitionDocker `json:"docker,omitempty"`
	// Spark - The configuration for a Spark environment.
	Spark *ModelEnvironmentDefinitionSpark `json:"spark,omitempty"`
	// R - Settings for a R environment.
	R *ModelEnvironmentDefinitionR `json:"r,omitempty"`
	// InferencingStackVersion - The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: "latest".
	InferencingStackVersion *string `json:"inferencingStackVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ModelEnvironmentDefinition.
func (med ModelEnvironmentDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if med.Name != nil {
		objectMap["name"] = med.Name
	}
	if med.Version != nil {
		objectMap["version"] = med.Version
	}
	if med.Python != nil {
		objectMap["python"] = med.Python
	}
	if med.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = med.EnvironmentVariables
	}
	if med.Docker != nil {
		objectMap["docker"] = med.Docker
	}
	if med.Spark != nil {
		objectMap["spark"] = med.Spark
	}
	if med.R != nil {
		objectMap["r"] = med.R
	}
	if med.InferencingStackVersion != nil {
		objectMap["inferencingStackVersion"] = med.InferencingStackVersion
	}
	return json.Marshal(objectMap)
}

// ModelEnvironmentDefinitionDocker the definition of a Docker container.
type ModelEnvironmentDefinitionDocker struct {
	// BaseImage - Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile.
	BaseImage *string `json:"baseImage,omitempty"`
	// BaseDockerfile - Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage.
	BaseDockerfile *string `json:"baseDockerfile,omitempty"`
	// BaseImageRegistry - Image registry that contains the base image.
	BaseImageRegistry *ModelDockerSectionBaseImageRegistry `json:"baseImageRegistry,omitempty"`
}

// ModelEnvironmentDefinitionPython settings for a Python environment.
type ModelEnvironmentDefinitionPython struct {
	// InterpreterPath - The python interpreter path to use if an environment build is not required. The path specified gets used to call the user script.
	InterpreterPath *string `json:"interpreterPath,omitempty"`
	// UserManagedDependencies - True means that AzureML reuses an existing python environment; False means that AzureML will create a python environment based on the Conda dependencies specification.
	UserManagedDependencies *bool `json:"userManagedDependencies,omitempty"`
	// CondaDependencies - A JObject containing Conda dependencies.
	CondaDependencies    interface{} `json:"condaDependencies,omitempty"`
	BaseCondaEnvironment *string     `json:"baseCondaEnvironment,omitempty"`
}

// ModelEnvironmentDefinitionR settings for a R environment.
type ModelEnvironmentDefinitionR struct {
	// RVersion - The version of R to be installed
	RVersion *string `json:"rVersion,omitempty"`
	// UserManaged - Indicates whether the environment is managed by user or by AzureML.
	UserManaged *bool `json:"userManaged,omitempty"`
	// RscriptPath - The Rscript path to use if an environment build is not required.
	// The path specified gets used to call the user script.
	RscriptPath *string `json:"rscriptPath,omitempty"`
	// SnapshotDate - Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. "2019-04-17"
	SnapshotDate *string `json:"snapshotDate,omitempty"`
	// CranPackages - The CRAN packages to use.
	CranPackages *[]RCranPackage `json:"cranPackages,omitempty"`
	// GitHubPackages - The packages directly from GitHub.
	GitHubPackages *[]RGitHubPackage `json:"gitHubPackages,omitempty"`
	// CustomURLPackages - The packages from custom urls.
	CustomURLPackages *[]string `json:"customUrlPackages,omitempty"`
	// BioConductorPackages - The packages from Bioconductor.
	BioConductorPackages *[]string `json:"bioConductorPackages,omitempty"`
}

// ModelEnvironmentDefinitionResponse ...
type ModelEnvironmentDefinitionResponse struct {
	// Name - The name of the environment.
	Name *string `json:"name,omitempty"`
	// Version - The environment version.
	Version *string `json:"version,omitempty"`
	// Python - Settings for a Python environment.
	Python *ModelEnvironmentDefinitionResponsePython `json:"python,omitempty"`
	// EnvironmentVariables - Definition of environment variables to be defined in the environment.
	EnvironmentVariables map[string]*string `json:"environmentVariables"`
	// Docker - The definition of a Docker container.
	Docker *ModelEnvironmentDefinitionResponseDocker `json:"docker,omitempty"`
	// Spark - The configuration for a Spark environment.
	Spark *ModelEnvironmentDefinitionResponseSpark `json:"spark,omitempty"`
	// R - Settings for a R environment.
	R *ModelEnvironmentDefinitionResponseR `json:"r,omitempty"`
	// InferencingStackVersion - The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: "latest".
	InferencingStackVersion *string `json:"inferencingStackVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ModelEnvironmentDefinitionResponse.
func (medr ModelEnvironmentDefinitionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if medr.Name != nil {
		objectMap["name"] = medr.Name
	}
	if medr.Version != nil {
		objectMap["version"] = medr.Version
	}
	if medr.Python != nil {
		objectMap["python"] = medr.Python
	}
	if medr.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = medr.EnvironmentVariables
	}
	if medr.Docker != nil {
		objectMap["docker"] = medr.Docker
	}
	if medr.Spark != nil {
		objectMap["spark"] = medr.Spark
	}
	if medr.R != nil {
		objectMap["r"] = medr.R
	}
	if medr.InferencingStackVersion != nil {
		objectMap["inferencingStackVersion"] = medr.InferencingStackVersion
	}
	return json.Marshal(objectMap)
}

// ModelEnvironmentDefinitionResponseDocker the definition of a Docker container.
type ModelEnvironmentDefinitionResponseDocker struct {
	// BaseImage - Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile.
	BaseImage *string `json:"baseImage,omitempty"`
	// BaseDockerfile - Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage.
	BaseDockerfile *string `json:"baseDockerfile,omitempty"`
	// BaseImageRegistry - Image registry that contains the base image.
	BaseImageRegistry *ModelDockerSectionResponseBaseImageRegistry `json:"baseImageRegistry,omitempty"`
}

// ModelEnvironmentDefinitionResponsePython settings for a Python environment.
type ModelEnvironmentDefinitionResponsePython struct {
	// InterpreterPath - The python interpreter path to use if an environment build is not required. The path specified gets used to call the user script.
	InterpreterPath *string `json:"interpreterPath,omitempty"`
	// UserManagedDependencies - True means that AzureML reuses an existing python environment; False means that AzureML will create a python environment based on the Conda dependencies specification.
	UserManagedDependencies *bool `json:"userManagedDependencies,omitempty"`
	// CondaDependencies - A JObject containing Conda dependencies.
	CondaDependencies    interface{} `json:"condaDependencies,omitempty"`
	BaseCondaEnvironment *string     `json:"baseCondaEnvironment,omitempty"`
}

// ModelEnvironmentDefinitionResponseR settings for a R environment.
type ModelEnvironmentDefinitionResponseR struct {
	// RVersion - The version of R to be installed
	RVersion *string `json:"rVersion,omitempty"`
	// UserManaged - Indicates whether the environment is managed by user or by AzureML.
	UserManaged *bool `json:"userManaged,omitempty"`
	// RscriptPath - The Rscript path to use if an environment build is not required.
	// The path specified gets used to call the user script.
	RscriptPath *string `json:"rscriptPath,omitempty"`
	// SnapshotDate - Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. "2019-04-17"
	SnapshotDate *string `json:"snapshotDate,omitempty"`
	// CranPackages - The CRAN packages to use.
	CranPackages *[]RCranPackage `json:"cranPackages,omitempty"`
	// GitHubPackages - The packages directly from GitHub.
	GitHubPackages *[]RGitHubPackageResponse `json:"gitHubPackages,omitempty"`
	// CustomURLPackages - The packages from custom urls.
	CustomURLPackages *[]string `json:"customUrlPackages,omitempty"`
	// BioConductorPackages - The packages from Bioconductor.
	BioConductorPackages *[]string `json:"bioConductorPackages,omitempty"`
}

// ModelEnvironmentDefinitionResponseSpark the configuration for a Spark environment.
type ModelEnvironmentDefinitionResponseSpark struct {
	// Repositories - The list of spark repositories.
	Repositories *[]string `json:"repositories,omitempty"`
	// Packages - The Spark packages to use.
	Packages *[]SparkMavenPackage `json:"packages,omitempty"`
	// PrecachePackages - Whether to precache the packages.
	PrecachePackages *bool `json:"precachePackages,omitempty"`
}

// ModelEnvironmentDefinitionSpark the configuration for a Spark environment.
type ModelEnvironmentDefinitionSpark struct {
	// Repositories - The list of spark repositories.
	Repositories *[]string `json:"repositories,omitempty"`
	// Packages - The Spark packages to use.
	Packages *[]SparkMavenPackage `json:"packages,omitempty"`
	// PrecachePackages - Whether to precache the packages.
	PrecachePackages *bool `json:"precachePackages,omitempty"`
}

// ModelPythonSection ...
type ModelPythonSection struct {
	// InterpreterPath - The python interpreter path to use if an environment build is not required. The path specified gets used to call the user script.
	InterpreterPath *string `json:"interpreterPath,omitempty"`
	// UserManagedDependencies - True means that AzureML reuses an existing python environment; False means that AzureML will create a python environment based on the Conda dependencies specification.
	UserManagedDependencies *bool `json:"userManagedDependencies,omitempty"`
	// CondaDependencies - A JObject containing Conda dependencies.
	CondaDependencies    interface{} `json:"condaDependencies,omitempty"`
	BaseCondaEnvironment *string     `json:"baseCondaEnvironment,omitempty"`
}

// ModelSparkSection ...
type ModelSparkSection struct {
	// Repositories - The list of spark repositories.
	Repositories *[]string `json:"repositories,omitempty"`
	// Packages - The Spark packages to use.
	Packages *[]SparkMavenPackage `json:"packages,omitempty"`
	// PrecachePackages - Whether to precache the packages.
	PrecachePackages *bool `json:"precachePackages,omitempty"`
}

// NodeStateCounts counts of various compute node states on the amlCompute.
type NodeStateCounts struct {
	// IdleNodeCount - READ-ONLY; Number of compute nodes in idle state.
	IdleNodeCount *int32 `json:"idleNodeCount,omitempty"`
	// RunningNodeCount - READ-ONLY; Number of compute nodes which are running jobs.
	RunningNodeCount *int32 `json:"runningNodeCount,omitempty"`
	// PreparingNodeCount - READ-ONLY; Number of compute nodes which are being prepared.
	PreparingNodeCount *int32 `json:"preparingNodeCount,omitempty"`
	// UnusableNodeCount - READ-ONLY; Number of compute nodes which are in unusable state.
	UnusableNodeCount *int32 `json:"unusableNodeCount,omitempty"`
	// LeavingNodeCount - READ-ONLY; Number of compute nodes which are leaving the amlCompute.
	LeavingNodeCount *int32 `json:"leavingNodeCount,omitempty"`
	// PreemptedNodeCount - READ-ONLY; Number of compute nodes which are in preempted state.
	PreemptedNodeCount *int32 `json:"preemptedNodeCount,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeStateCounts.
func (nsc NodeStateCounts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// NotebookAccessTokenResult ...
type NotebookAccessTokenResult struct {
	autorest.Response `json:"-"`
	// NotebookResourceID - READ-ONLY
	NotebookResourceID *string `json:"notebookResourceId,omitempty"`
	// HostName - READ-ONLY
	HostName *string `json:"hostName,omitempty"`
	// PublicDNS - READ-ONLY
	PublicDNS *string `json:"publicDns,omitempty"`
	// AccessToken - READ-ONLY
	AccessToken *string `json:"accessToken,omitempty"`
	// TokenType - READ-ONLY
	TokenType *string `json:"tokenType,omitempty"`
	// ExpiresIn - READ-ONLY
	ExpiresIn *int32 `json:"expiresIn,omitempty"`
	// RefreshToken - READ-ONLY
	RefreshToken *string `json:"refreshToken,omitempty"`
	// Scope - READ-ONLY
	Scope *string `json:"scope,omitempty"`
}

// MarshalJSON is the custom marshaler for NotebookAccessTokenResult.
func (natr NotebookAccessTokenResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// NotebookPreparationError ...
type NotebookPreparationError struct {
	ErrorMessage *string `json:"errorMessage,omitempty"`
	StatusCode   *int32  `json:"statusCode,omitempty"`
}

// NotebookResourceInfo ...
type NotebookResourceInfo struct {
	autorest.Response `json:"-"`
	Fqdn              *string `json:"fqdn,omitempty"`
	// ResourceID - the data plane resourceId that used to initialize notebook component
	ResourceID *string `json:"resourceId,omitempty"`
	// NotebookPreparationError - The error that occurs when preparing notebook.
	NotebookPreparationError *NotebookPreparationError `json:"notebookPreparationError,omitempty"`
}

// NotebooksPrepareFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NotebooksPrepareFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebooksClient) (NotebookResourceInfo, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebooksPrepareFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebooksPrepareFuture.Result.
func (future *NotebooksPrepareFuture) result(client NotebooksClient) (nri NotebookResourceInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.NotebooksPrepareFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		nri.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.NotebooksPrepareFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nri.Response.Response, err = future.GetResult(sender); err == nil && nri.Response.Response.StatusCode != http.StatusNoContent {
		nri, err = client.PrepareResponder(nri.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.NotebooksPrepareFuture", "Result", nri.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Operation azure Machine Learning workspace REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display name of operation
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display name of operation
type OperationDisplay struct {
	// Provider - The resource provider name: Microsoft.MachineLearningExperimentation
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult an array of operations supported by the resource provider.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of AML workspace operations supported by the AML workspace resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// PaginatedComputeResourcesList paginated list of Machine Learning compute objects wrapped in ARM resource
// envelope.
type PaginatedComputeResourcesList struct {
	autorest.Response `json:"-"`
	// Value - An array of Machine Learning compute objects wrapped in ARM resource envelope.
	Value *[]ComputeResource `json:"value,omitempty"`
	// NextLink - A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// PaginatedComputeResourcesListIterator provides access to a complete listing of ComputeResource values.
type PaginatedComputeResourcesListIterator struct {
	i    int
	page PaginatedComputeResourcesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PaginatedComputeResourcesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedComputeResourcesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PaginatedComputeResourcesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PaginatedComputeResourcesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PaginatedComputeResourcesListIterator) Response() PaginatedComputeResourcesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PaginatedComputeResourcesListIterator) Value() ComputeResource {
	if !iter.page.NotDone() {
		return ComputeResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PaginatedComputeResourcesListIterator type.
func NewPaginatedComputeResourcesListIterator(page PaginatedComputeResourcesListPage) PaginatedComputeResourcesListIterator {
	return PaginatedComputeResourcesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcrl PaginatedComputeResourcesList) IsEmpty() bool {
	return pcrl.Value == nil || len(*pcrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcrl PaginatedComputeResourcesList) hasNextLink() bool {
	return pcrl.NextLink != nil && len(*pcrl.NextLink) != 0
}

// paginatedComputeResourcesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcrl PaginatedComputeResourcesList) paginatedComputeResourcesListPreparer(ctx context.Context) (*http.Request, error) {
	if !pcrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcrl.NextLink)))
}

// PaginatedComputeResourcesListPage contains a page of ComputeResource values.
type PaginatedComputeResourcesListPage struct {
	fn   func(context.Context, PaginatedComputeResourcesList) (PaginatedComputeResourcesList, error)
	pcrl PaginatedComputeResourcesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PaginatedComputeResourcesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedComputeResourcesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcrl)
		if err != nil {
			return err
		}
		page.pcrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PaginatedComputeResourcesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PaginatedComputeResourcesListPage) NotDone() bool {
	return !page.pcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PaginatedComputeResourcesListPage) Response() PaginatedComputeResourcesList {
	return page.pcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PaginatedComputeResourcesListPage) Values() []ComputeResource {
	if page.pcrl.IsEmpty() {
		return nil
	}
	return *page.pcrl.Value
}

// Creates a new instance of the PaginatedComputeResourcesListPage type.
func NewPaginatedComputeResourcesListPage(cur PaginatedComputeResourcesList, getNextPage func(context.Context, PaginatedComputeResourcesList) (PaginatedComputeResourcesList, error)) PaginatedComputeResourcesListPage {
	return PaginatedComputeResourcesListPage{
		fn:   getNextPage,
		pcrl: cur,
	}
}

// PaginatedServiceList paginated list of Machine Learning service objects wrapped in ARM resource
// envelope.
type PaginatedServiceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; An array of Machine Learning compute objects wrapped in ARM resource envelope.
	Value *[]ServiceResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PaginatedServiceList.
func (psl PaginatedServiceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PaginatedServiceListIterator provides access to a complete listing of ServiceResource values.
type PaginatedServiceListIterator struct {
	i    int
	page PaginatedServiceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PaginatedServiceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedServiceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PaginatedServiceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PaginatedServiceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PaginatedServiceListIterator) Response() PaginatedServiceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PaginatedServiceListIterator) Value() ServiceResource {
	if !iter.page.NotDone() {
		return ServiceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PaginatedServiceListIterator type.
func NewPaginatedServiceListIterator(page PaginatedServiceListPage) PaginatedServiceListIterator {
	return PaginatedServiceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (psl PaginatedServiceList) IsEmpty() bool {
	return psl.Value == nil || len(*psl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (psl PaginatedServiceList) hasNextLink() bool {
	return psl.NextLink != nil && len(*psl.NextLink) != 0
}

// paginatedServiceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (psl PaginatedServiceList) paginatedServiceListPreparer(ctx context.Context) (*http.Request, error) {
	if !psl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(psl.NextLink)))
}

// PaginatedServiceListPage contains a page of ServiceResource values.
type PaginatedServiceListPage struct {
	fn  func(context.Context, PaginatedServiceList) (PaginatedServiceList, error)
	psl PaginatedServiceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PaginatedServiceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedServiceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.psl)
		if err != nil {
			return err
		}
		page.psl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PaginatedServiceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PaginatedServiceListPage) NotDone() bool {
	return !page.psl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PaginatedServiceListPage) Response() PaginatedServiceList {
	return page.psl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PaginatedServiceListPage) Values() []ServiceResource {
	if page.psl.IsEmpty() {
		return nil
	}
	return *page.psl.Value
}

// Creates a new instance of the PaginatedServiceListPage type.
func NewPaginatedServiceListPage(cur PaginatedServiceList, getNextPage func(context.Context, PaginatedServiceList) (PaginatedServiceList, error)) PaginatedServiceListPage {
	return PaginatedServiceListPage{
		fn:  getNextPage,
		psl: cur,
	}
}

// PaginatedWorkspaceConnectionsList paginated list of Workspace connection objects.
type PaginatedWorkspaceConnectionsList struct {
	autorest.Response `json:"-"`
	// Value - An array of Workspace connection objects.
	Value *[]WorkspaceConnection `json:"value,omitempty"`
	// NextLink - A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// Password ...
type Password struct {
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Password.
func (p Password) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PersonalComputeInstanceSettings settings for a personal compute instance.
type PersonalComputeInstanceSettings struct {
	// AssignedUser - A user explicitly assigned to a personal compute instance.
	AssignedUser *AssignedUser `json:"assignedUser,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
	// SubnetArmID - READ-ONLY; The ARM identifier for Subnet resource that private endpoint links to
	SubnetArmID *string `json:"subnetArmId,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	if pec.Identity != nil {
		objectMap["identity"] = pec.Identity
	}
	if pec.Location != nil {
		objectMap["location"] = pec.Location
	}
	if pec.Tags != nil {
		objectMap["tags"] = pec.Tags
	}
	if pec.Sku != nil {
		objectMap["sku"] = pec.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				pec.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pec.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pec.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pec.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pec.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	if plr.Identity != nil {
		objectMap["identity"] = plr.Identity
	}
	if plr.Location != nil {
		objectMap["location"] = plr.Location
	}
	if plr.Tags != nil {
		objectMap["tags"] = plr.Tags
	}
	if plr.Sku != nil {
		objectMap["sku"] = plr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				plr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				plr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				plr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				plr.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				plr.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected', 'PrivateEndpointServiceConnectionStatusDisconnected', 'PrivateEndpointServiceConnectionStatusTimeout'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// QuotaBaseProperties the properties for Quota update or retrieval.
type QuotaBaseProperties struct {
	// ID - Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Type - Specifies the resource type.
	Type *string `json:"type,omitempty"`
	// Limit - The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Unit - An enum describing the unit of quota measurement. Possible values include: 'QuotaUnitCount'
	Unit QuotaUnit `json:"unit,omitempty"`
}

// QuotaUpdateParameters quota update parameters.
type QuotaUpdateParameters struct {
	// Value - The list for update quota.
	Value *[]QuotaBaseProperties `json:"value,omitempty"`
	// Location - Region of workspace quota to be updated.
	Location *string `json:"location,omitempty"`
}

// RCranPackage ...
type RCranPackage struct {
	// Name - The package name.
	Name *string `json:"name,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
}

// RegistryListCredentialsResult ...
type RegistryListCredentialsResult struct {
	// Location - READ-ONLY
	Location *string `json:"location,omitempty"`
	// Username - READ-ONLY
	Username  *string     `json:"username,omitempty"`
	Passwords *[]Password `json:"passwords,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryListCredentialsResult.
func (rlcr RegistryListCredentialsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rlcr.Passwords != nil {
		objectMap["passwords"] = rlcr.Passwords
	}
	return json.Marshal(objectMap)
}

// Resource azure Resource Manager resource envelope.
type Resource struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Identity != nil {
		objectMap["identity"] = r.Identity
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// ResourceID represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
type ResourceID struct {
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
}

// ResourceName the Resource Name.
type ResourceName struct {
	// Value - READ-ONLY; The name of the resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceName.
func (rn ResourceName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceQuota the quota assigned to a resource.
type ResourceQuota struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// AmlWorkspaceLocation - READ-ONLY; Region of the AML workspace in the id.
	AmlWorkspaceLocation *string `json:"amlWorkspaceLocation,omitempty"`
	// Type - READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Name of the resource.
	Name *ResourceName `json:"name,omitempty"`
	// Limit - READ-ONLY; The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; An enum describing the unit of quota measurement. Possible values include: 'QuotaUnitCount'
	Unit QuotaUnit `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceQuota.
func (rq ResourceQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuLocationInfo ...
type ResourceSkuLocationInfo struct {
	// Location - READ-ONLY; Location of the SKU
	Location *string `json:"location,omitempty"`
	// Zones - READ-ONLY; List of availability zones where the SKU is supported.
	Zones *[]string `json:"zones,omitempty"`
	// ZoneDetails - READ-ONLY; Details of capabilities available to a SKU in specific zones.
	ZoneDetails *[]ResourceSkuZoneDetails `json:"zoneDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuLocationInfo.
func (rsli ResourceSkuLocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuZoneDetails describes The zonal capabilities of a SKU.
type ResourceSkuZoneDetails struct {
	// Name - READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name *[]string `json:"name,omitempty"`
	// Capabilities - READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities *[]SKUCapability `json:"capabilities,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuZoneDetails.
func (rszd ResourceSkuZoneDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Restriction the restriction because of which SKU cannot be used.
type Restriction struct {
	// Type - READ-ONLY; The type of restrictions. As of now only possible value for this is location.
	Type *string `json:"type,omitempty"`
	// Values - READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - The reason for the restriction. Possible values include: 'ReasonCodeNotSpecified', 'ReasonCodeNotAvailableForRegion', 'ReasonCodeNotAvailableForSubscription'
	ReasonCode ReasonCode `json:"reasonCode,omitempty"`
}

// MarshalJSON is the custom marshaler for Restriction.
func (r Restriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReasonCode != "" {
		objectMap["reasonCode"] = r.ReasonCode
	}
	return json.Marshal(objectMap)
}

// RGitHubPackage ...
type RGitHubPackage struct {
	// Repository - Repository address in the format username/repo[/subdir][@ref|#pull].
	Repository *string `json:"repository,omitempty"`
	// AuthToken - Personal access token to install from a private repo
	AuthToken *string `json:"authToken,omitempty"`
}

// RGitHubPackageResponse ...
type RGitHubPackageResponse struct {
	// Repository - Repository address in the format username/repo[/subdir][@ref|#pull].
	Repository *string `json:"repository,omitempty"`
}

// RSection ...
type RSection struct {
	// RVersion - The version of R to be installed
	RVersion *string `json:"rVersion,omitempty"`
	// UserManaged - Indicates whether the environment is managed by user or by AzureML.
	UserManaged *bool `json:"userManaged,omitempty"`
	// RscriptPath - The Rscript path to use if an environment build is not required.
	// The path specified gets used to call the user script.
	RscriptPath *string `json:"rscriptPath,omitempty"`
	// SnapshotDate - Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. "2019-04-17"
	SnapshotDate *string `json:"snapshotDate,omitempty"`
	// CranPackages - The CRAN packages to use.
	CranPackages *[]RCranPackage `json:"cranPackages,omitempty"`
	// GitHubPackages - The packages directly from GitHub.
	GitHubPackages *[]RGitHubPackage `json:"gitHubPackages,omitempty"`
	// CustomURLPackages - The packages from custom urls.
	CustomURLPackages *[]string `json:"customUrlPackages,omitempty"`
	// BioConductorPackages - The packages from Bioconductor.
	BioConductorPackages *[]string `json:"bioConductorPackages,omitempty"`
}

// RSectionResponse ...
type RSectionResponse struct {
	// RVersion - The version of R to be installed
	RVersion *string `json:"rVersion,omitempty"`
	// UserManaged - Indicates whether the environment is managed by user or by AzureML.
	UserManaged *bool `json:"userManaged,omitempty"`
	// RscriptPath - The Rscript path to use if an environment build is not required.
	// The path specified gets used to call the user script.
	RscriptPath *string `json:"rscriptPath,omitempty"`
	// SnapshotDate - Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. "2019-04-17"
	SnapshotDate *string `json:"snapshotDate,omitempty"`
	// CranPackages - The CRAN packages to use.
	CranPackages *[]RCranPackage `json:"cranPackages,omitempty"`
	// GitHubPackages - The packages directly from GitHub.
	GitHubPackages *[]RGitHubPackageResponse `json:"gitHubPackages,omitempty"`
	// CustomURLPackages - The packages from custom urls.
	CustomURLPackages *[]string `json:"customUrlPackages,omitempty"`
	// BioConductorPackages - The packages from Bioconductor.
	BioConductorPackages *[]string `json:"bioConductorPackages,omitempty"`
}

// ScaleSettings scale settings for AML Compute
type ScaleSettings struct {
	// MaxNodeCount - Max number of nodes to use
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
	// MinNodeCount - Min number of nodes to use
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
	// NodeIdleTimeBeforeScaleDown - Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
	NodeIdleTimeBeforeScaleDown *string `json:"nodeIdleTimeBeforeScaleDown,omitempty"`
}

// ScriptReference script reference
type ScriptReference struct {
	// ScriptSource - The storage source of the script: inline, workspace.
	ScriptSource *string `json:"scriptSource,omitempty"`
	// ScriptData - The location of scripts in the mounted volume.
	ScriptData *string `json:"scriptData,omitempty"`
	// ScriptArguments - Optional command line arguments passed to the script to run.
	ScriptArguments *string `json:"scriptArguments,omitempty"`
	// Timeout - Optional time period passed to timeout command.
	Timeout *string `json:"timeout,omitempty"`
}

// ScriptsToExecute customized setup scripts
type ScriptsToExecute struct {
	// StartupScript - Script that's run every time the machine starts.
	StartupScript *ScriptReference `json:"startupScript,omitempty"`
	// CreationScript - Script that's run only once during provision of the compute.
	CreationScript *ScriptReference `json:"creationScript,omitempty"`
}

// ServiceManagedResourcesSettings ...
type ServiceManagedResourcesSettings struct {
	// CosmosDb - The settings for the service managed cosmosdb account.
	CosmosDb *CosmosDbSettings `json:"cosmosDb,omitempty"`
}

// ServicePrincipalCredentials service principal credentials.
type ServicePrincipalCredentials struct {
	// ClientID - Client Id
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// ServiceResource machine Learning service object wrapped into ARM resource envelope.
type ServiceResource struct {
	autorest.Response `json:"-"`
	// Properties - Service properties
	Properties BasicServiceResponseBase `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = sr.Properties
	if sr.Identity != nil {
		objectMap["identity"] = sr.Identity
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	if sr.Sku != nil {
		objectMap["sku"] = sr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResource struct.
func (sr *ServiceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicServiceResponseBase(*v)
				if err != nil {
					return err
				}
				sr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sr.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sr.SystemData = &systemData
			}
		}
	}

	return nil
}

// BasicServiceResponseBase the base service response. The correct inherited response based on computeType will be
// returned (ex. ACIServiceResponse)
type BasicServiceResponseBase interface {
	AsACIServiceResponse() (*ACIServiceResponse, bool)
	AsAKSVariantResponse() (*AKSVariantResponse, bool)
	AsBasicAKSVariantResponse() (BasicAKSVariantResponse, bool)
	AsAKSServiceResponse() (*AKSServiceResponse, bool)
	AsServiceResponseBase() (*ServiceResponseBase, bool)
}

// ServiceResponseBase the base service response. The correct inherited response based on computeType will be
// returned (ex. ACIServiceResponse)
type ServiceResponseBase struct {
	// Description - The service description.
	Description *string `json:"description,omitempty"`
	// KvTags - The service tag dictionary. Tags are mutable.
	KvTags map[string]*string `json:"kvTags"`
	// Properties - The service property dictionary. Properties are immutable.
	Properties map[string]*string `json:"properties"`
	// State - READ-ONLY; The current state of the service. Possible values include: 'WebServiceStateTransitioning', 'WebServiceStateHealthy', 'WebServiceStateUnhealthy', 'WebServiceStateFailed', 'WebServiceStateUnschedulable'
	State WebServiceState `json:"state,omitempty"`
	// Error - READ-ONLY; The error details.
	Error *ServiceResponseBaseError `json:"error,omitempty"`
	// DeploymentType - The deployment type for the service. Possible values include: 'DeploymentTypeGRPCRealtimeEndpoint', 'DeploymentTypeHTTPRealtimeEndpoint', 'DeploymentTypeBatch'
	DeploymentType DeploymentType `json:"deploymentType,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicServiceResponseBaseComputeTypeServiceResponseBase', 'ComputeTypeBasicServiceResponseBaseComputeTypeACI', 'ComputeTypeBasicServiceResponseBaseComputeTypeCustom', 'ComputeTypeBasicServiceResponseBaseComputeTypeAKS'
	ComputeType ComputeTypeBasicServiceResponseBase `json:"computeType,omitempty"`
}

func unmarshalBasicServiceResponseBase(body []byte) (BasicServiceResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicServiceResponseBaseComputeTypeACI):
		var asr ACIServiceResponse
		err := json.Unmarshal(body, &asr)
		return asr, err
	case string(ComputeTypeBasicServiceResponseBaseComputeTypeCustom):
		var avr AKSVariantResponse
		err := json.Unmarshal(body, &avr)
		return avr, err
	case string(ComputeTypeBasicServiceResponseBaseComputeTypeAKS):
		var asr AKSServiceResponse
		err := json.Unmarshal(body, &asr)
		return asr, err
	default:
		var srb ServiceResponseBase
		err := json.Unmarshal(body, &srb)
		return srb, err
	}
}
func unmarshalBasicServiceResponseBaseArray(body []byte) ([]BasicServiceResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	srbArray := make([]BasicServiceResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		srb, err := unmarshalBasicServiceResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		srbArray[index] = srb
	}
	return srbArray, nil
}

// MarshalJSON is the custom marshaler for ServiceResponseBase.
func (srb ServiceResponseBase) MarshalJSON() ([]byte, error) {
	srb.ComputeType = ComputeTypeBasicServiceResponseBaseComputeTypeServiceResponseBase
	objectMap := make(map[string]interface{})
	if srb.Description != nil {
		objectMap["description"] = srb.Description
	}
	if srb.KvTags != nil {
		objectMap["kvTags"] = srb.KvTags
	}
	if srb.Properties != nil {
		objectMap["properties"] = srb.Properties
	}
	if srb.DeploymentType != "" {
		objectMap["deploymentType"] = srb.DeploymentType
	}
	if srb.ComputeType != "" {
		objectMap["computeType"] = srb.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsACIServiceResponse is the BasicServiceResponseBase implementation for ServiceResponseBase.
func (srb ServiceResponseBase) AsACIServiceResponse() (*ACIServiceResponse, bool) {
	return nil, false
}

// AsAKSVariantResponse is the BasicServiceResponseBase implementation for ServiceResponseBase.
func (srb ServiceResponseBase) AsAKSVariantResponse() (*AKSVariantResponse, bool) {
	return nil, false
}

// AsBasicAKSVariantResponse is the BasicServiceResponseBase implementation for ServiceResponseBase.
func (srb ServiceResponseBase) AsBasicAKSVariantResponse() (BasicAKSVariantResponse, bool) {
	return nil, false
}

// AsAKSServiceResponse is the BasicServiceResponseBase implementation for ServiceResponseBase.
func (srb ServiceResponseBase) AsAKSServiceResponse() (*AKSServiceResponse, bool) {
	return nil, false
}

// AsServiceResponseBase is the BasicServiceResponseBase implementation for ServiceResponseBase.
func (srb ServiceResponseBase) AsServiceResponseBase() (*ServiceResponseBase, bool) {
	return &srb, true
}

// AsBasicServiceResponseBase is the BasicServiceResponseBase implementation for ServiceResponseBase.
func (srb ServiceResponseBase) AsBasicServiceResponseBase() (BasicServiceResponseBase, bool) {
	return &srb, true
}

// ServiceResponseBaseError the error details.
type ServiceResponseBaseError struct {
	// Error - READ-ONLY; The error response.
	Error *ErrorResponse `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResponseBaseError.
func (srb ServiceResponseBaseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SetupScripts details of customized scripts to execute for setting up the cluster.
type SetupScripts struct {
	// Scripts - Customized setup scripts
	Scripts *ScriptsToExecute `json:"scripts,omitempty"`
}

// SharedPrivateLinkResource ...
type SharedPrivateLinkResource struct {
	// Name - Unique name of the private link.
	Name *string `json:"name,omitempty"`
	// SharedPrivateLinkResourceProperty - Resource properties.
	*SharedPrivateLinkResourceProperty `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedPrivateLinkResource.
func (splr SharedPrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if splr.Name != nil {
		objectMap["name"] = splr.Name
	}
	if splr.SharedPrivateLinkResourceProperty != nil {
		objectMap["properties"] = splr.SharedPrivateLinkResourceProperty
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedPrivateLinkResource struct.
func (splr *SharedPrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				splr.Name = &name
			}
		case "properties":
			if v != nil {
				var sharedPrivateLinkResourceProperty SharedPrivateLinkResourceProperty
				err = json.Unmarshal(*v, &sharedPrivateLinkResourceProperty)
				if err != nil {
					return err
				}
				splr.SharedPrivateLinkResourceProperty = &sharedPrivateLinkResourceProperty
			}
		}
	}

	return nil
}

// SharedPrivateLinkResourceProperty properties of a shared private link resource.
type SharedPrivateLinkResourceProperty struct {
	// PrivateLinkResourceID - The resource id that private link links to.
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`
	// GroupID - The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequestMessage - Request message.
	RequestMessage *string `json:"requestMessage,omitempty"`
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected', 'PrivateEndpointServiceConnectionStatusDisconnected', 'PrivateEndpointServiceConnectionStatusTimeout'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// Sku sku of the resource
type Sku struct {
	// Name - Name of the sku
	Name *string `json:"name,omitempty"`
	// Tier - Tier of the sku like Basic or Enterprise
	Tier *string `json:"tier,omitempty"`
}

// SKUCapability features/user capabilities associated with the sku
type SKUCapability struct {
	// Name - Capability/Feature ID
	Name *string `json:"name,omitempty"`
	// Value - Details about the feature/capability
	Value *string `json:"value,omitempty"`
}

// SkuListResult list of skus with features
type SkuListResult struct {
	autorest.Response `json:"-"`
	Value             *[]WorkspaceSku `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of Workspace Skus. Call ListNext() with this URI to fetch the next page of Workspace Skus
	NextLink *string `json:"nextLink,omitempty"`
}

// SkuListResultIterator provides access to a complete listing of WorkspaceSku values.
type SkuListResultIterator struct {
	i    int
	page SkuListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SkuListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SkuListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SkuListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SkuListResultIterator) Response() SkuListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SkuListResultIterator) Value() WorkspaceSku {
	if !iter.page.NotDone() {
		return WorkspaceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SkuListResultIterator type.
func NewSkuListResultIterator(page SkuListResultPage) SkuListResultIterator {
	return SkuListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SkuListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SkuListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// skuListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SkuListResult) skuListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SkuListResultPage contains a page of WorkspaceSku values.
type SkuListResultPage struct {
	fn  func(context.Context, SkuListResult) (SkuListResult, error)
	slr SkuListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SkuListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SkuListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SkuListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SkuListResultPage) Response() SkuListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SkuListResultPage) Values() []WorkspaceSku {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SkuListResultPage type.
func NewSkuListResultPage(cur SkuListResult, getNextPage func(context.Context, SkuListResult) (SkuListResult, error)) SkuListResultPage {
	return SkuListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// SparkMavenPackage ...
type SparkMavenPackage struct {
	Group    *string `json:"group,omitempty"`
	Artifact *string `json:"artifact,omitempty"`
	Version  *string `json:"version,omitempty"`
}

// SslConfiguration the ssl configuration for scoring
type SslConfiguration struct {
	// Status - Enable or disable ssl for scoring. Possible values include: 'Status1Disabled', 'Status1Enabled', 'Status1Auto'
	Status Status1 `json:"status,omitempty"`
	// Cert - Cert data
	Cert *string `json:"cert,omitempty"`
	// Key - Key data
	Key *string `json:"key,omitempty"`
	// Cname - CNAME of the cert
	Cname *string `json:"cname,omitempty"`
	// LeafDomainLabel - Leaf domain label of public endpoint
	LeafDomainLabel *string `json:"leafDomainLabel,omitempty"`
	// OverwriteExistingDomain - Indicates whether to overwrite existing domain label.
	OverwriteExistingDomain *bool `json:"overwriteExistingDomain,omitempty"`
}

// SynapseSpark a SynapseSpark compute.
type SynapseSpark struct {
	// ComputeType - The type of compute. Possible values include: 'ComputeTypeAKS', 'ComputeTypeAmlCompute', 'ComputeTypeComputeInstance', 'ComputeTypeDataFactory', 'ComputeTypeVirtualMachine', 'ComputeTypeHDInsight', 'ComputeTypeDatabricks', 'ComputeTypeDataLakeAnalytics', 'ComputeTypeSynapseSpark'
	ComputeType ComputeType `json:"computeType,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// Properties - AKS properties
	Properties *SynapseSparkProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SynapseSpark.
func (ss SynapseSpark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.ComputeType != "" {
		objectMap["computeType"] = ss.ComputeType
	}
	if ss.ComputeLocation != nil {
		objectMap["computeLocation"] = ss.ComputeLocation
	}
	if ss.Description != nil {
		objectMap["description"] = ss.Description
	}
	if ss.ResourceID != nil {
		objectMap["resourceId"] = ss.ResourceID
	}
	if ss.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = ss.DisableLocalAuth
	}
	if ss.Properties != nil {
		objectMap["properties"] = ss.Properties
	}
	return json.Marshal(objectMap)
}

// SynapseSparkPoolProperties properties specific to Synapse Spark pools.
type SynapseSparkPoolProperties struct {
	// Properties - AKS properties
	Properties *SynapseSparkProperties `json:"properties,omitempty"`
}

// SynapseSparkProperties AKS properties
type SynapseSparkProperties struct {
	// AutoScaleProperties - Auto scale properties.
	AutoScaleProperties *AutoScaleProperties `json:"autoScaleProperties,omitempty"`
	// AutoPauseProperties - Auto pause properties.
	AutoPauseProperties *AutoPauseProperties `json:"autoPauseProperties,omitempty"`
	// SparkVersion - Spark version.
	SparkVersion *string `json:"sparkVersion,omitempty"`
	// NodeCount - The number of compute nodes currently assigned to the compute.
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// NodeSize - Node size.
	NodeSize *string `json:"nodeSize,omitempty"`
	// NodeSizeFamily - Node size family.
	NodeSizeFamily *string `json:"nodeSizeFamily,omitempty"`
	// SubscriptionID - Azure subscription identifier.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - Name of the resource group in which workspace is located.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// WorkspaceName - Name of Azure Machine Learning workspace.
	WorkspaceName *string `json:"workspaceName,omitempty"`
	// PoolName - Pool name.
	PoolName *string `json:"poolName,omitempty"`
}

// SystemData read only system data
type SystemData struct {
	// CreatedBy - An identifier for the identity that created the resource
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	CreatedByType IdentityType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC)
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - An identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	LastModifiedByType IdentityType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// SystemService a system service running on a compute.
type SystemService struct {
	// SystemServiceType - READ-ONLY; The type of this system service.
	SystemServiceType *string `json:"systemServiceType,omitempty"`
	// PublicIPAddress - READ-ONLY; Public IP address
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// Version - READ-ONLY; The version for this type.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for SystemService.
func (ss SystemService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UpdateWorkspaceQuotas the properties for update Quota response.
type UpdateWorkspaceQuotas struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty"`
	// Limit - The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; An enum describing the unit of quota measurement. Possible values include: 'QuotaUnitCount'
	Unit QuotaUnit `json:"unit,omitempty"`
	// Status - Status of update workspace quota. Possible values include: 'StatusUndefined', 'StatusSuccess', 'StatusFailure', 'StatusInvalidQuotaBelowClusterMinimum', 'StatusInvalidQuotaExceedsSubscriptionLimit', 'StatusInvalidVMFamilyName', 'StatusOperationNotSupportedForSku', 'StatusOperationNotEnabledForRegion'
	Status Status `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateWorkspaceQuotas.
func (uwq UpdateWorkspaceQuotas) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uwq.Limit != nil {
		objectMap["limit"] = uwq.Limit
	}
	if uwq.Status != "" {
		objectMap["status"] = uwq.Status
	}
	return json.Marshal(objectMap)
}

// UpdateWorkspaceQuotasResult the result of update workspace quota.
type UpdateWorkspaceQuotasResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of workspace quota update result.
	Value *[]UpdateWorkspaceQuotas `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of workspace quota update result. Call ListNext() with this to fetch the next page of Workspace Quota update result.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateWorkspaceQuotasResult.
func (uwqr UpdateWorkspaceQuotasResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Usage describes AML Resource Usage.
type Usage struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// AmlWorkspaceLocation - READ-ONLY; Region of the AML workspace in the id.
	AmlWorkspaceLocation *string `json:"amlWorkspaceLocation,omitempty"`
	// Type - READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty"`
	// Unit - READ-ONLY; An enum describing the unit of usage measurement. Possible values include: 'UsageUnitCount'
	Unit UsageUnit `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; The current usage of the resource.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The maximum permitted usage of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Name - READ-ONLY; The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UsageName the Usage Names.
type UsageName struct {
	// Value - READ-ONLY; The name of the resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageName.
func (un UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UserAccountCredentials settings for user account that gets created on each on the nodes of a compute.
type UserAccountCredentials struct {
	// AdminUserName - Name of the administrator user account which can be used to SSH to nodes.
	AdminUserName *string `json:"adminUserName,omitempty"`
	// AdminUserSSHPublicKey - SSH public key of the administrator user account.
	AdminUserSSHPublicKey *string `json:"adminUserSshPublicKey,omitempty"`
	// AdminUserPassword - Password of the administrator user account.
	AdminUserPassword *string `json:"adminUserPassword,omitempty"`
}

// UserAssignedIdentity user Assigned Identity
type UserAssignedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the user assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// ClientID - READ-ONLY; The clientId(aka appId) of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentity.
func (uai UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VirtualMachine a Machine Learning compute based on Azure Virtual Machines.
type VirtualMachine struct {
	Properties *VirtualMachineProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The time at which the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// IsAttachedCompute - READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty"`
	// DisableLocalAuth - Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeComputeTypeCompute', 'ComputeTypeBasicComputeComputeTypeAKS', 'ComputeTypeBasicComputeComputeTypeAmlCompute', 'ComputeTypeBasicComputeComputeTypeComputeInstance', 'ComputeTypeBasicComputeComputeTypeVirtualMachine', 'ComputeTypeBasicComputeComputeTypeHDInsight', 'ComputeTypeBasicComputeComputeTypeDataFactory', 'ComputeTypeBasicComputeComputeTypeDatabricks', 'ComputeTypeBasicComputeComputeTypeDataLakeAnalytics'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachine.
func (VM VirtualMachine) MarshalJSON() ([]byte, error) {
	VM.ComputeType = ComputeTypeBasicComputeComputeTypeVirtualMachine
	objectMap := make(map[string]interface{})
	if VM.Properties != nil {
		objectMap["properties"] = VM.Properties
	}
	if VM.ComputeLocation != nil {
		objectMap["computeLocation"] = VM.ComputeLocation
	}
	if VM.Description != nil {
		objectMap["description"] = VM.Description
	}
	if VM.ResourceID != nil {
		objectMap["resourceId"] = VM.ResourceID
	}
	if VM.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = VM.DisableLocalAuth
	}
	if VM.ComputeType != "" {
		objectMap["computeType"] = VM.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsAmlCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsAmlCompute() (*AmlCompute, bool) {
	return nil, false
}

// AsComputeInstance is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsComputeInstance() (*ComputeInstance, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsVirtualMachine() (*VirtualMachine, bool) {
	return &VM, true
}

// AsHDInsight is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsDatabricks is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDatabricks() (*Databricks, bool) {
	return nil, false
}

// AsDataLakeAnalytics is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDataLakeAnalytics() (*DataLakeAnalytics, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsBasicCompute() (BasicCompute, bool) {
	return &VM, true
}

// VirtualMachineImage virtual Machine image for Windows AML Compute
type VirtualMachineImage struct {
	// ID - Virtual Machine image path
	ID *string `json:"id,omitempty"`
}

// VirtualMachineProperties ...
type VirtualMachineProperties struct {
	// VirtualMachineSize - Virtual Machine size
	VirtualMachineSize *string `json:"virtualMachineSize,omitempty"`
	// SSHPort - Port open for ssh connections.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// Address - Public IP address of the virtual machine.
	Address *string `json:"address,omitempty"`
	// AdministratorAccount - Admin credentials for virtual machine
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
	// IsNotebookInstanceCompute - Indicates whether this compute will be used for running notebooks.
	IsNotebookInstanceCompute *bool `json:"isNotebookInstanceCompute,omitempty"`
}

// VirtualMachineSecrets secrets related to a Machine Learning compute based on AKS.
type VirtualMachineSecrets struct {
	// AdministratorAccount - Admin credentials for virtual machine.
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine', 'ComputeTypeBasicComputeSecretsComputeTypeDatabricks'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) MarshalJSON() ([]byte, error) {
	vms.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine
	objectMap := make(map[string]interface{})
	if vms.AdministratorAccount != nil {
		objectMap["administratorAccount"] = vms.AdministratorAccount
	}
	if vms.ComputeType != "" {
		objectMap["computeType"] = vms.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return nil, false
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return &vms, true
}

// AsDatabricksComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsDatabricksComputeSecrets() (*DatabricksComputeSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &vms, true
}

// VirtualMachineSize describes the properties of a VM size.
type VirtualMachineSize struct {
	// Name - READ-ONLY; The name of the virtual machine size.
	Name *string `json:"name,omitempty"`
	// Family - READ-ONLY; The family name of the virtual machine size.
	Family *string `json:"family,omitempty"`
	// VCPUs - READ-ONLY; The number of vCPUs supported by the virtual machine size.
	VCPUs *int32 `json:"vCPUs,omitempty"`
	// Gpus - READ-ONLY; The number of gPUs supported by the virtual machine size.
	Gpus *int32 `json:"gpus,omitempty"`
	// OsVhdSizeMB - READ-ONLY; The OS VHD disk size, in MB, allowed by the virtual machine size.
	OsVhdSizeMB *int32 `json:"osVhdSizeMB,omitempty"`
	// MaxResourceVolumeMB - READ-ONLY; The resource volume size, in MB, allowed by the virtual machine size.
	MaxResourceVolumeMB *int32 `json:"maxResourceVolumeMB,omitempty"`
	// MemoryGB - READ-ONLY; The amount of memory, in GB, supported by the virtual machine size.
	MemoryGB *float64 `json:"memoryGB,omitempty"`
	// LowPriorityCapable - READ-ONLY; Specifies if the virtual machine size supports low priority VMs.
	LowPriorityCapable *bool `json:"lowPriorityCapable,omitempty"`
	// PremiumIO - READ-ONLY; Specifies if the virtual machine size supports premium IO.
	PremiumIO *bool `json:"premiumIO,omitempty"`
	// EstimatedVMPrices - The estimated price information for using a VM.
	EstimatedVMPrices *EstimatedVMPrices `json:"estimatedVMPrices,omitempty"`
	// SupportedComputeTypes - Specifies the compute types supported by the virtual machine size.
	SupportedComputeTypes *[]string `json:"supportedComputeTypes,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineSize.
func (vms VirtualMachineSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vms.EstimatedVMPrices != nil {
		objectMap["estimatedVMPrices"] = vms.EstimatedVMPrices
	}
	if vms.SupportedComputeTypes != nil {
		objectMap["supportedComputeTypes"] = vms.SupportedComputeTypes
	}
	return json.Marshal(objectMap)
}

// VirtualMachineSizeListResult the List Virtual Machine size operation response.
type VirtualMachineSizeListResult struct {
	autorest.Response `json:"-"`
	// AmlCompute - The list of virtual machine sizes supported by AmlCompute.
	AmlCompute *[]VirtualMachineSize `json:"amlCompute,omitempty"`
}

// VirtualMachineSSHCredentials admin credentials for virtual machine
type VirtualMachineSSHCredentials struct {
	// Username - Username of admin account
	Username *string `json:"username,omitempty"`
	// Password - Password of admin account
	Password *string `json:"password,omitempty"`
	// PublicKeyData - Public key data
	PublicKeyData *string `json:"publicKeyData,omitempty"`
	// PrivateKeyData - Private key data
	PrivateKeyData *string `json:"privateKeyData,omitempty"`
}

// VnetConfiguration ...
type VnetConfiguration struct {
	// VnetName - The name of the virtual network.
	VnetName *string `json:"vnetName,omitempty"`
	// SubnetName - The name of the virtual network subnet.
	SubnetName *string `json:"subnetName,omitempty"`
}

// Workspace an object that represents a machine learning workspace.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - The properties of the machine learning workspace.
	*WorkspaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Sku != nil {
		objectMap["sku"] = w.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				w.Sku = &sku
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				w.SystemData = &systemData
			}
		}
	}

	return nil
}

// WorkspaceConnection workspace connection.
type WorkspaceConnection struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ResourceId of the workspace connection.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Friendly name of the workspace connection.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of workspace connection.
	Type *string `json:"type,omitempty"`
	// WorkspaceConnectionProps - Properties of workspace connection.
	*WorkspaceConnectionProps `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceConnection.
func (wc WorkspaceConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wc.WorkspaceConnectionProps != nil {
		objectMap["properties"] = wc.WorkspaceConnectionProps
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceConnection struct.
func (wc *WorkspaceConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wc.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var workspaceConnectionProps WorkspaceConnectionProps
				err = json.Unmarshal(*v, &workspaceConnectionProps)
				if err != nil {
					return err
				}
				wc.WorkspaceConnectionProps = &workspaceConnectionProps
			}
		}
	}

	return nil
}

// WorkspaceConnectionDto object used for creating workspace connection.
type WorkspaceConnectionDto struct {
	// Name - Friendly name of the workspace connection
	Name *string `json:"name,omitempty"`
	// WorkspaceConnectionProps - Properties of workspace connection.
	*WorkspaceConnectionProps `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceConnectionDto.
func (wcd WorkspaceConnectionDto) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcd.Name != nil {
		objectMap["name"] = wcd.Name
	}
	if wcd.WorkspaceConnectionProps != nil {
		objectMap["properties"] = wcd.WorkspaceConnectionProps
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceConnectionDto struct.
func (wcd *WorkspaceConnectionDto) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wcd.Name = &name
			}
		case "properties":
			if v != nil {
				var workspaceConnectionProps WorkspaceConnectionProps
				err = json.Unmarshal(*v, &workspaceConnectionProps)
				if err != nil {
					return err
				}
				wcd.WorkspaceConnectionProps = &workspaceConnectionProps
			}
		}
	}

	return nil
}

// WorkspaceConnectionProps workspace Connection specific properties.
type WorkspaceConnectionProps struct {
	// Category - Category of the workspace connection.
	Category *string `json:"category,omitempty"`
	// Target - Target of the workspace connection.
	Target *string `json:"target,omitempty"`
	// AuthType - Authorization type of the workspace connection.
	AuthType *string `json:"authType,omitempty"`
	// Value - Value details of the workspace connection.
	Value *string `json:"value,omitempty"`
	// ValueFormat - format for the workspace connection value. Possible values include: 'ValueFormatJSON'
	ValueFormat ValueFormat `json:"valueFormat,omitempty"`
}

// WorkspaceListResult the result of a request to list machine learning workspaces.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request the next list of machine learning workspaces.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of machine learning workspaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceListResultIterator struct {
	i    int
	page WorkspaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListResultIterator) Response() WorkspaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListResultIterator type.
func NewWorkspaceListResultIterator(page WorkspaceListResultPage) WorkspaceListResultIterator {
	return WorkspaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkspaceListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WorkspaceListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// workspaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkspaceListResult) workspaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkspaceListResultPage contains a page of Workspace values.
type WorkspaceListResultPage struct {
	fn  func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)
	wlr WorkspaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListResultPage) Response() WorkspaceListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListResultPage) Values() []Workspace {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WorkspaceListResultPage type.
func NewWorkspaceListResultPage(cur WorkspaceListResult, getNextPage func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)) WorkspaceListResultPage {
	return WorkspaceListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WorkspaceProperties the properties of a machine learning workspace.
type WorkspaceProperties struct {
	// WorkspaceID - READ-ONLY; The immutable id associated with this workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Description - The description of this workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - The friendly name for this workspace. This name in mutable
	FriendlyName *string `json:"friendlyName,omitempty"`
	// KeyVault - ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
	KeyVault *string `json:"keyVault,omitempty"`
	// ApplicationInsights - ARM id of the application insights associated with this workspace. This cannot be changed once the workspace has been created
	ApplicationInsights *string `json:"applicationInsights,omitempty"`
	// ContainerRegistry - ARM id of the container registry associated with this workspace. This cannot be changed once the workspace has been created
	ContainerRegistry *string `json:"containerRegistry,omitempty"`
	// StorageAccount - ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
	StorageAccount *string `json:"storageAccount,omitempty"`
	// DiscoveryURL - Url for the discovery service to identify regional endpoints for machine learning experimentation services
	DiscoveryURL *string `json:"discoveryUrl,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateUpdating', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Encryption - The encryption settings of Azure ML workspace.
	Encryption *EncryptionProperty `json:"encryption,omitempty"`
	// HbiWorkspace - The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
	HbiWorkspace *bool `json:"hbiWorkspace,omitempty"`
	// ServiceProvisionedResourceGroup - READ-ONLY; The name of the managed resource group created by workspace RP in customer subscription if the workspace is CMK workspace
	ServiceProvisionedResourceGroup *string `json:"serviceProvisionedResourceGroup,omitempty"`
	// PrivateLinkCount - READ-ONLY; Count of private connections in the workspace
	PrivateLinkCount *int32 `json:"privateLinkCount,omitempty"`
	// ImageBuildCompute - The compute name for image build
	ImageBuildCompute *string `json:"imageBuildCompute,omitempty"`
	// AllowPublicAccessWhenBehindVnet - The flag to indicate whether to allow public access when behind VNet.
	AllowPublicAccessWhenBehindVnet *bool `json:"allowPublicAccessWhenBehindVnet,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; The list of private endpoint connections in the workspace.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// SharedPrivateLinkResources - The list of shared private link resources in this workspace.
	SharedPrivateLinkResources *[]SharedPrivateLinkResource `json:"sharedPrivateLinkResources,omitempty"`
	// NotebookInfo - READ-ONLY; The notebook info of Azure ML workspace.
	NotebookInfo *NotebookResourceInfo `json:"notebookInfo,omitempty"`
	// ServiceManagedResourcesSettings - The service managed resource settings.
	ServiceManagedResourcesSettings *ServiceManagedResourcesSettings `json:"serviceManagedResourcesSettings,omitempty"`
	// PrimaryUserAssignedIdentity - The user assigned identity resource id that represents the workspace identity.
	PrimaryUserAssignedIdentity *string `json:"primaryUserAssignedIdentity,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with this workspace.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (wp WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Description != nil {
		objectMap["description"] = wp.Description
	}
	if wp.FriendlyName != nil {
		objectMap["friendlyName"] = wp.FriendlyName
	}
	if wp.KeyVault != nil {
		objectMap["keyVault"] = wp.KeyVault
	}
	if wp.ApplicationInsights != nil {
		objectMap["applicationInsights"] = wp.ApplicationInsights
	}
	if wp.ContainerRegistry != nil {
		objectMap["containerRegistry"] = wp.ContainerRegistry
	}
	if wp.StorageAccount != nil {
		objectMap["storageAccount"] = wp.StorageAccount
	}
	if wp.DiscoveryURL != nil {
		objectMap["discoveryUrl"] = wp.DiscoveryURL
	}
	if wp.Encryption != nil {
		objectMap["encryption"] = wp.Encryption
	}
	if wp.HbiWorkspace != nil {
		objectMap["hbiWorkspace"] = wp.HbiWorkspace
	}
	if wp.ImageBuildCompute != nil {
		objectMap["imageBuildCompute"] = wp.ImageBuildCompute
	}
	if wp.AllowPublicAccessWhenBehindVnet != nil {
		objectMap["allowPublicAccessWhenBehindVnet"] = wp.AllowPublicAccessWhenBehindVnet
	}
	if wp.SharedPrivateLinkResources != nil {
		objectMap["sharedPrivateLinkResources"] = wp.SharedPrivateLinkResources
	}
	if wp.ServiceManagedResourcesSettings != nil {
		objectMap["serviceManagedResourcesSettings"] = wp.ServiceManagedResourcesSettings
	}
	if wp.PrimaryUserAssignedIdentity != nil {
		objectMap["primaryUserAssignedIdentity"] = wp.PrimaryUserAssignedIdentity
	}
	return json.Marshal(objectMap)
}

// WorkspacePropertiesUpdateParameters the parameters for updating the properties of a machine learning
// workspace.
type WorkspacePropertiesUpdateParameters struct {
	// Description - The description of this workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - The friendly name for this workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ImageBuildCompute - The compute name for image build
	ImageBuildCompute *string `json:"imageBuildCompute,omitempty"`
	// ServiceManagedResourcesSettings - The service managed resource settings.
	ServiceManagedResourcesSettings *ServiceManagedResourcesSettings `json:"serviceManagedResourcesSettings,omitempty"`
	// PrimaryUserAssignedIdentity - The user assigned identity resource id that represents the workspace identity.
	PrimaryUserAssignedIdentity *string `json:"primaryUserAssignedIdentity,omitempty"`
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesCreateOrUpdateFuture.Result.
func (future *WorkspacesCreateOrUpdateFuture) result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateOrUpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesCreateOrUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesDeleteFuture.Result.
func (future *WorkspacesDeleteFuture) result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspaceSku describes Workspace Sku details and features
type WorkspaceSku struct {
	// Locations - READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
	Locations *[]string `json:"locations,omitempty"`
	// LocationInfo - READ-ONLY; A list of locations and availability zones in those locations where the SKU is available.
	LocationInfo *[]ResourceSkuLocationInfo `json:"locationInfo,omitempty"`
	// Tier - READ-ONLY; Sku Tier like Basic or Enterprise
	Tier *string `json:"tier,omitempty"`
	// ResourceType - READ-ONLY
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Capabilities - READ-ONLY; List of features/user capabilities associated with the sku
	Capabilities *[]SKUCapability `json:"capabilities,omitempty"`
	// Restrictions - The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]Restriction `json:"restrictions,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceSku.
func (ws WorkspaceSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ws.Restrictions != nil {
		objectMap["restrictions"] = ws.Restrictions
	}
	return json.Marshal(objectMap)
}

// WorkspacesResyncKeysFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesResyncKeysFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesResyncKeysFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesResyncKeysFuture.Result.
func (future *WorkspacesResyncKeysFuture) result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesResyncKeysFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesResyncKeysFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspaceUpdateParameters the parameters for updating a machine learning workspace.
type WorkspaceUpdateParameters struct {
	// Tags - The resource tags for the machine learning workspace.
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// WorkspacePropertiesUpdateParameters - The properties that the machine learning workspace will be updated with.
	*WorkspacePropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceUpdateParameters.
func (wup WorkspaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.Sku != nil {
		objectMap["sku"] = wup.Sku
	}
	if wup.Identity != nil {
		objectMap["identity"] = wup.Identity
	}
	if wup.WorkspacePropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WorkspacePropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceUpdateParameters struct.
func (wup *WorkspaceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				wup.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				wup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var workspacePropertiesUpdateParameters WorkspacePropertiesUpdateParameters
				err = json.Unmarshal(*v, &workspacePropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WorkspacePropertiesUpdateParameters = &workspacePropertiesUpdateParameters
			}
		}
	}

	return nil
}
