/*
 * Copyright (c) 2009-2016, Albertas Vyšniauskas
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *     * Neither the name of the software author nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef GPICK_DRAG_DROP_H_
#define GPICK_DRAG_DROP_H_
#include "Converters.h"
#include <gtk/gtk.h>
struct GlobalState;
struct ColorObject;
enum DragDropFlags {
	DRAGDROP_SOURCE = 1 << 1,
	DRAGDROP_DESTINATION = 1 << 2,
};
struct DragDrop {
	GtkWidget *widget;
	void *userdata;
	ColorObject *(*get_color_object)(DragDrop *dd);
	int (*set_color_object_at)(DragDrop *dd, ColorObject *colorobject, int x, int y, bool move, bool sameWidget);
	ColorObject **(*get_color_object_list)(DragDrop *dd, size_t *colorobject_n);
	int (*set_color_object_list_at)(DragDrop *dd, ColorObject **colorobject, size_t colorobject_n, int x, int y, bool move, bool sameWidget);
	bool (*test_at)(DragDrop *dd, int x, int y);
	bool (*data_delete)(DragDrop *dd, GtkWidget *widget, GdkDragContext *context);
	bool (*drag_end)(DragDrop *dd, GtkWidget *widget, GdkDragContext *context);
	enum DataType {
		DATA_TYPE_NONE,
		DATA_TYPE_COLOR_OBJECT,
		DATA_TYPE_COLOR_OBJECTS,
	};
	DataType data_type;
	Converters::Type converterType;
	union {
		struct {
			ColorObject *colorObject;
		} colorObject;
		struct {
			ColorObject **colorObjects;
			size_t colorObjectCount;
		} colorObjects;
	} data;
	GtkWidget *dragwidget;
	GlobalState *gs;
	void *userdata2;
};
int dragdrop_init(DragDrop *dd, GlobalState *gs);
int dragdrop_widget_attach(GtkWidget *widget, DragDropFlags flags, DragDrop *dd);
#endif /* GPICK_DRAG_DROP_H_ */
