/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

/*
 * text.C functions for the text widgets on the main window
 */

#include <gtk/gtk.h>
#include "text.h"
#include "globals.h"
#include <stdio.h>
#include <string.h>

/*
 *  This functions adds an character to the rx window
 */


void put_rx_window (const gchar *text, gint txstate)
{
	GtkTextBuffer *buffer;
	GtkTextIter end;
	GtkTextMark *mark;
	GError *err = NULL;
	const gchar *from="UTF-8";
	const gchar *to="ISO-8859-1";
	gchar *ch = g_strdup (".");


	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (main_screen.rxwindow));
	gtk_text_buffer_get_end_iter (buffer, &end);
	gtk_text_buffer_place_cursor (buffer, &end);

	gchar *buf = g_convert_with_fallback
		(text, -1, from, to, ch, NULL, NULL, &err);
	if (!buf || err) return;

	if (txstate == 1)
	{
		gtk_text_buffer_insert_with_tags_by_name
	    (buffer, &end, buf, -1, highlight.rxtx, NULL);
	}
	else
	{
		gtk_text_buffer_insert_with_tags_by_name
	    (buffer, &end, buf, -1, highlight.rxrx, NULL);
	}
	mark = gtk_text_buffer_get_mark (buffer, "insert");
	gtk_text_view_scroll_to_mark
		(GTK_TEXT_VIEW(main_screen.rxwindow), mark, 0.0, FALSE, 0.0, 1.0);
}

/*
 *   Put a char in the tx window
 */

void put_tx_window (const gchar *text)
{
	GtkTextBuffer *buffer;
	GtkTextIter iter, end;
	GtkTextMark *mark;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (main_screen.txwindow));
	gtk_text_buffer_get_end_iter (buffer, &end);
	gtk_text_buffer_get_end_iter (buffer, &iter);
	gtk_text_iter_backward_chars (&iter, 1);
	gtk_text_buffer_delete (buffer, &iter, &end);
	gtk_text_buffer_insert_with_tags_by_name
	    (buffer, &iter, text, -1, "tx_window_color", NULL);
	mark = gtk_text_buffer_get_mark (buffer, "insert");
	gtk_text_view_scroll_to_mark
		(GTK_TEXT_VIEW(main_screen.txwindow), mark, 0.0, FALSE, 0.0, 1.0);
}
