/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright 2019- The GROMACS Authors
 * and the project initiators Erik Lindahl, Berk Hess and David van der Spoel.
 * Consult the AUTHORS/COPYING files and https://www.gromacs.org for details.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * https://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at https://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out https://www.gromacs.org.
 */

/*! \internal \file
 * \brief
 * This file defines a box with 81 SPC/E water molecules, 243 atoms, for use in tests
 *
 * The 81 water molecules are taken from the 216 SPC liquid system. This results
 * in a more inhomogeneous system and also one that makes the tests smaller.
 *
 * \author Berk Hess <hess@kth.se>
 * \ingroup module_nbnxm
 */

#include <vector>

#include "gromacs/math/vec.h"

//! A cubic simulation box matching spc81Coordinates defined below
static const matrix spc81Box = { { 1.86206, 0.0, 0.0 }, { 0.0, 1.86206, 0.0 }, { 0.0, 0.0, 1.86206 } };

//! Coordinates of 81 SPC molecules taken from the standard 216 SPC system
static const std::vector<gmx::RVec> spc81Coordinates = {
    { 0.005, 0.600, 0.244 }, { -0.017, 0.690, 0.270 }, { 0.051, 0.610, 0.161 },
    { 0.155, 0.341, 0.735 }, { 0.140, 0.284, 0.660 },  { 0.081, 0.402, 0.734 },
    { 1.853, 0.500, 0.554 }, { 1.788, 0.505, 0.484 },  { 1.809, 0.533, 0.632 },
    { 0.732, 1.356, 1.314 }, { 0.724, 1.291, 1.245 },  { 0.767, 1.434, 1.270 },
    { 1.746, 1.593, 0.575 }, { 1.735, 1.666, 0.637 },  { 1.708, 1.518, 0.621 },
    { 1.759, 0.582, 0.800 }, { 1.673, 0.542, 0.815 },  { 1.787, 0.608, 0.888 },
    { 0.965, 0.529, 0.941 }, { 0.912, 0.531, 1.020 },  { 0.902, 0.533, 0.869 },
    { 0.091, 0.598, 1.836 }, { 0.091, 0.507, 1.806 },  { 0.174, 0.634, 1.804 },
    { 0.796, 1.279, 0.780 }, { 0.731, 1.331, 0.734 },  { 0.799, 1.196, 0.733 },
    { 0.737, 0.813, 0.145 }, { 0.765, 0.723, 0.130 },  { 0.771, 0.835, 0.231 },
    { 0.547, 1.092, 0.477 }, { 0.529, 1.089, 0.571 },  { 0.463, 1.072, 0.436 },
    { 0.729, 1.093, 1.672 }, { 0.781, 1.129, 1.744 },  { 0.762, 1.004, 1.660 },
    { 0.570, 1.373, 1.080 }, { 0.625, 1.297, 1.099 },  { 0.544, 1.361, 0.988 },
    { 1.431, 1.407, 1.448 }, { 1.471, 1.367, 1.526 },  { 1.398, 1.332, 1.397 },
    { 0.544, 0.321, 1.628 }, { 0.458, 0.278, 1.627 },  { 0.579, 0.307, 1.540 },
    { 1.482, 0.418, 0.684 }, { 1.396, 0.411, 0.641 },  { 1.490, 0.336, 0.734 },
    { 0.383, 1.854, 0.680 }, { 0.421, 1.821, 0.599 },  { 0.458, 1.885, 0.731 },
    { 1.132, 1.589, 1.714 }, { 1.043, 1.553, 1.717 },  { 1.155, 1.588, 1.621 },
    { 0.395, 1.440, 0.467 }, { 0.368, 1.353, 0.437 },  { 0.315, 1.491, 0.468 },
    { 0.305, 1.125, 0.948 }, { 0.295, 1.202, 0.892 },  { 0.271, 1.153, 1.033 },
    { 0.724, 1.826, 1.501 }, { 0.768, 1.794, 1.579 },  { 0.660, 1.759, 1.479 },
    { 0.514, 0.998, 0.125 }, { 0.597, 0.957, 0.101 },  { 0.482, 1.036, 0.043 },
    { 1.315, 0.291, 1.516 }, { 1.404, 0.271, 1.488 },  { 1.300, 0.382, 1.490 },
    { 0.062, 0.829, 0.562 }, { 0.100, 0.870, 0.484 },  { -0.009, 0.888, 0.588 },
    { 0.236, 1.600, 0.680 }, { 0.202, 1.585, 0.592 },  { 0.267, 1.691, 0.679 },
    { 0.071, 1.691, 0.164 }, { 0.075, 1.759, 0.097 },  { 0.089, 1.609, 0.116 },
    { 1.692, 0.825, 0.708 }, { 1.604, 0.794, 0.687 },  { 1.733, 0.751, 0.752 },
    { 1.579, 1.053, 0.254 }, { 1.484, 1.038, 0.253 },  { 1.612, 0.993, 0.321 },
    { 0.255, 0.444, 1.549 }, { 0.315, 0.457, 1.623 },  { 0.201, 0.370, 1.575 },
    { 0.517, 1.454, 0.771 }, { 0.540, 1.448, 0.678 },  { 0.432, 1.499, 0.771 },
    { 1.290, 1.247, 1.248 }, { 1.225, 1.308, 1.284 },  { 1.238, 1.177, 1.208 },
    { 1.161, 0.046, 0.549 }, { 1.234, 0.006, 0.596 },  { 1.172, 0.017, 0.459 },
    { 0.200, 0.931, 1.248 }, { 0.256, 0.920, 1.171 },  { 0.213, 0.850, 1.299 },
    { 1.653, 0.813, 0.403 }, { 1.632, 0.721, 0.384 },  { 1.697, 0.810, 0.488 },
    { 1.138, 1.632, 1.408 }, { 1.106, 1.554, 1.363 },  { 1.080, 1.702, 1.379 },
    { 0.309, 0.377, 1.834 }, { 0.270, 0.293, 1.810 },  { 0.356, 0.359, 1.915 },
    { 1.437, 1.245, 1.000 }, { 1.416, 1.156, 0.973 },  { 1.405, 1.252, 1.090 },
    { 1.424, 1.753, 0.580 }, { 1.415, 1.709, 0.496 },  { 1.382, 1.694, 0.643 },
    { 0.842, 0.793, 0.396 }, { 0.827, 0.699, 0.405 },  { 0.773, 0.834, 0.448 },
    { 1.184, 0.226, 0.775 }, { 1.151, 0.212, 0.686 },  { 1.273, 0.191, 0.774 },
    { 1.645, 1.631, 0.294 }, { 1.700, 1.553, 0.302 },  { 1.633, 1.661, 0.384 },
    { 0.990, 0.346, 1.386 }, { 1.000, 0.372, 1.477 },  { 1.076, 0.311, 1.362 },
    { 1.202, 0.168, 0.212 }, { 1.264, 0.196, 0.145 },  { 1.128, 0.131, 0.163 },
    { 1.107, 1.012, 1.474 }, { 1.103, 1.064, 1.393 },  { 1.098, 1.077, 1.544 },
    { 1.100, 1.061, 1.152 }, { 1.055, 1.105, 1.080 },  { 1.038, 0.995, 1.183 },
    { 1.136, 0.703, 0.486 }, { 1.042, 0.696, 0.470 },  { 1.176, 0.703, 0.399 },
    { 0.205, 0.758, 0.832 }, { 0.160, 0.782, 0.751 },  { 0.153, 0.798, 0.901 },
    { 0.014, 1.547, 1.653 }, { -0.068, 1.593, 1.633 }, { -0.011, 1.455, 1.659 },
    { 0.937, 0.550, 0.310 }, { 0.940, 0.460, 0.342 },  { 1.018, 0.561, 0.260 },
    { 1.594, 0.494, 1.709 }, { 1.526, 0.554, 1.740 },  { 1.597, 0.508, 1.614 },
    { 1.317, 0.968, 0.261 }, { 1.326, 0.873, 0.258 },  { 1.237, 0.982, 0.311 },
    { 0.818, 0.220, 0.930 }, { 0.896, 0.264, 0.962 },  { 0.843, 0.128, 0.924 },
    { 1.063, 1.375, 0.602 }, { 1.080, 1.291, 0.646 },  { 1.144, 1.425, 0.613 },
    { 0.402, 0.050, 1.093 }, { 0.419, -0.043, 1.079 }, { 0.426, 0.092, 1.010 },
    { 1.638, 1.025, 0.883 }, { 1.604, 1.095, 0.826 },  { 1.670, 0.959, 0.822 },
    { 1.398, 1.680, 1.499 }, { 1.380, 1.610, 1.437 },  { 1.312, 1.714, 1.522 },
    { 0.233, 0.934, 0.223 }, { 0.220, 0.964, 0.133 },  { 0.299, 0.865, 0.215 },
    { 1.441, 0.685, 0.696 }, { 1.354, 0.700, 0.734 },  { 1.463, 0.595, 0.721 },
    { 0.337, 1.268, 0.247 }, { 0.344, 1.178, 0.215 },  { 0.250, 1.273, 0.286 },
    { 0.898, 0.118, 0.200 }, { 0.911, 0.132, 0.106 },  { 0.829, 0.180, 0.223 },
    { 1.836, 1.848, 1.626 }, { 1.827, 1.886, 1.713 },  { 1.760, 1.789, 1.619 },
    { 1.709, 1.339, 0.320 }, { 1.682, 1.260, 0.274 },  { 1.803, 1.329, 0.333 },
    { 0.565, 0.045, 0.300 }, { 0.507, 0.057, 0.225 },  { 0.526, -0.026, 0.350 },
    { 1.628, 0.075, 0.522 }, { 1.564, 0.147, 0.528 },  { 1.585, 0.001, 0.564 },
    { 0.217, 0.088, 1.291 }, { 0.299, 0.084, 1.242 },  { 0.231, 0.028, 1.365 },
    { 1.107, 1.599, 0.835 }, { 1.035, 1.596, 0.772 },  { 1.184, 1.575, 0.784 },
    { 0.526, 0.552, 0.449 }, { 0.434, 0.575, 0.446 },  { 0.527, 0.459, 0.471 },
    { 1.370, 0.230, 1.838 }, { 1.436, 0.291, 1.805 },  { 1.357, 0.168, 1.766 },
    { 0.265, 0.145, 0.335 }, { 0.205, 0.108, 0.401 },  { 0.215, 0.142, 0.254 },
    { 0.640, 0.255, 0.072 }, { 0.592, 0.297, 0.143 },  { 0.603, 0.167, 0.066 },
    { 1.053, 1.444, 1.188 }, { 1.050, 1.387, 1.111 },  { 1.105, 1.519, 1.161 },
    { 1.220, 0.833, 1.310 }, { 1.162, 0.770, 1.266 },  { 1.167, 0.868, 1.382 },
    { 0.826, 1.515, 0.927 }, { 0.920, 1.501, 0.924 },  { 0.788, 1.433, 0.895 },
    { 0.947, 0.419, 0.683 }, { 0.950, 0.388, 0.592 },  { 0.861, 0.392, 0.715 },
    { 0.532, 1.697, 0.437 }, { 0.627, 1.686, 0.437 },  { 0.498, 1.614, 0.471 },
    { 1.398, 1.337, 0.222 }, { 1.405, 1.361, 0.314 },  { 1.433, 1.412, 0.175 },
    { 0.212, 1.702, 1.770 }, { 0.262, 1.670, 1.695 },  { 0.127, 1.724, 1.734 },
    { 0.699, 0.270, 0.386 }, { 0.669, 0.287, 0.475 },  { 0.636, 0.206, 0.352 },
    { 1.364, 0.635, 1.746 }, { 1.350, 0.721, 1.707 },  { 1.276, 0.603, 1.766 },
    { 1.316, 1.494, 0.695 }, { 1.355, 1.490, 0.782 },  { 1.366, 1.430, 0.644 },
    { 0.532, 0.838, 0.958 }, { 0.442, 0.838, 0.927 },  { 0.526, 0.856, 1.052 },
};
