/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class TableCollectionTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testClear__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testClear();
}

public void testContainsKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testGetNull();
}

public void testHashCode__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testSize();
}

public void testValues__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValues();
}

public void testValuesClear__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__UnmodifiableTreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testClear();
}

public void testContainsKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testGetNull();
}

public void testHashCode__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testSize();
}

public void testValues__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValues();
}

public void testValuesClear__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__UnmodifiableHashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testClear();
}

public void testContainsKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testGetNull();
}

public void testHashCode__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testSize();
}

public void testValues__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValues();
}

public void testValuesClear__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TransformValueColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testClear();
}

public void testContainsKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testGetNull();
}

public void testHashCode__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testSize();
}

public void testValues__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValues();
}

public void testValuesClear__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TreeColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testClear();
}

public void testContainsKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testGetNull();
}

public void testHashCode__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testSize();
}

public void testValues__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValues();
}

public void testValuesClear__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__HashColumnMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnMapTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testClear();
}

public void testContainsKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testGetNull();
}

public void testHashCode__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testSize();
}

public void testValues__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValues();
}

public void testValuesClear__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__UnmodifiableTreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testClear();
}

public void testContainsKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testGetNull();
}

public void testHashCode__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testSize();
}

public void testValues__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValues();
}

public void testValuesClear__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__UnmodifiableHashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testClear();
}

public void testContainsKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testGetNull();
}

public void testHashCode__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testSize();
}

public void testValues__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValues();
}

public void testValuesClear__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TransformValueRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testClear();
}

public void testContainsKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testGetNull();
}

public void testHashCode__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testSize();
}

public void testValues__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValues();
}

public void testValuesClear__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TreeRowMapSubMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapSubMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testClear();
}

public void testContainsKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testGetNull();
}

public void testHashCode__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testSize();
}

public void testValues__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValues();
}

public void testValuesClear__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TreeRowMapTailMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTailMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testClear();
}

public void testContainsKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testGetNull();
}

public void testHashCode__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testSize();
}

public void testValues__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValues();
}

public void testValuesClear__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TreeRowMapHeadMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapHeadMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testClear();
}

public void testContainsKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testGetNull();
}

public void testHashCode__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testSize();
}

public void testValues__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValues();
}

public void testValuesClear__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TreeRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowMapTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testClear();
}

public void testContainsKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testGetNull();
}

public void testHashCode__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testSize();
}

public void testValues__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValues();
}

public void testValuesClear__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__HashRowMapTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowMapTests testCase = new com.google.common.collect.TableCollectionTest.HashRowMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testClear();
}

public void testContainsKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testContainsKey();
}

public void testContainsValue__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testContainsValue();
}

public void testEntrySet__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testGet();
}

public void testGetForEmptyMap__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testGetNull();
}

public void testHashCode__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testRemoveMissingKey();
}

public void testSize__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testSize();
}

public void testValues__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValues();
}

public void testValuesClear__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__UnmodifiableTreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeColumnTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testClear();
}

public void testContainsKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testContainsKey();
}

public void testContainsValue__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testContainsValue();
}

public void testEntrySet__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testGet();
}

public void testGetForEmptyMap__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testGetNull();
}

public void testHashCode__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testRemoveMissingKey();
}

public void testSize__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testSize();
}

public void testValues__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValues();
}

public void testValuesClear__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__UnmodifiableHashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashColumnTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testClear();
}

public void testContainsKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testContainsKey();
}

public void testContainsValue__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testContainsValue();
}

public void testEntrySet__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testGetNull();
}

public void testHashCode__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testSize();
}

public void testValues__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValues();
}

public void testValuesClear__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TransformValueColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueColumnTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testClear();
}

public void testContainsKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testContainsKey();
}

public void testContainsValue__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testContainsValue();
}

public void testEntrySet__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testGetNull();
}

public void testHashCode__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testSize();
}

public void testValues__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValues();
}

public void testValuesClear__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TransposeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TransposeColumnTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testClear();
}

public void testContainsKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testContainsKey();
}

public void testContainsValue__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testContainsValue();
}

public void testEntrySet__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testGetNull();
}

public void testHashCode__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testSize();
}

public void testValues__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValues();
}

public void testValuesClear__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TreeColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeColumnTests testCase = new com.google.common.collect.TableCollectionTest.TreeColumnTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testClear();
}

public void testContainsKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testContainsKey();
}

public void testContainsValue__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testContainsValue();
}

public void testEntrySet__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testGet();
}

public void testGetForEmptyMap__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testGetNull();
}

public void testHashCode__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testRemoveMissingKey();
}

public void testSize__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testSize();
}

public void testValues__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValues();
}

public void testValuesClear__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__HashColumnTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashColumnTests testCase = new com.google.common.collect.TableCollectionTest.HashColumnTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testClear();
}

public void testContainsKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testContainsKey();
}

public void testContainsValue__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testContainsValue();
}

public void testEntrySet__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testGet();
}

public void testGetForEmptyMap__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testGetNull();
}

public void testHashCode__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testRemoveMissingKey();
}

public void testSize__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testSize();
}

public void testValues__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValues();
}

public void testValuesClear__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__UnmodifiableTreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableTreeRowTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testClear();
}

public void testContainsKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testContainsKey();
}

public void testContainsValue__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testContainsValue();
}

public void testEntrySet__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testGet();
}

public void testGetForEmptyMap__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testGetNull();
}

public void testHashCode__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testRemoveMissingKey();
}

public void testSize__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testSize();
}

public void testValues__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValues();
}

public void testValuesClear__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__UnmodifiableHashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests testCase = new com.google.common.collect.TableCollectionTest.UnmodifiableHashRowTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testClear();
}

public void testContainsKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testContainsKey();
}

public void testContainsValue__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testContainsValue();
}

public void testEntrySet__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testGetNull();
}

public void testHashCode__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testSize();
}

public void testValues__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValues();
}

public void testValuesClear__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TransformValueRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransformValueRowTests testCase = new com.google.common.collect.TableCollectionTest.TransformValueRowTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testClear();
}

public void testContainsKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testContainsKey();
}

public void testContainsValue__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testContainsValue();
}

public void testEntrySet__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testGetNull();
}

public void testHashCode__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testSize();
}

public void testValues__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValues();
}

public void testValuesClear__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TransposeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TransposeRowTests testCase = new com.google.common.collect.TableCollectionTest.TransposeRowTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testClear();
}

public void testContainsKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testContainsKey();
}

public void testContainsValue__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testContainsValue();
}

public void testEntrySet__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testGetNull();
}

public void testHashCode__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testSize();
}

public void testValues__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValues();
}

public void testValuesClear__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TreeRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.TreeRowTests testCase = new com.google.common.collect.TableCollectionTest.TreeRowTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testClear();
}

public void testContainsKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testContainsKey();
}

public void testContainsValue__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testContainsValue();
}

public void testEntrySet__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testGet();
}

public void testGetForEmptyMap__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testGetNull();
}

public void testHashCode__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testRemoveMissingKey();
}

public void testSize__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testSize();
}

public void testValues__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValues();
}

public void testValuesClear__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__HashRowTests() throws Exception {
  com.google.common.collect.TableCollectionTest.HashRowTests testCase = new com.google.common.collect.TableCollectionTest.HashRowTests();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
