--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.Tokens
-- Copyright   :  (c) Sven Panne 2015
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- All enumeration tokens from the
-- <http://www.opengl.org/registry/ OpenGL registry>.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.Tokens where

import Graphics.Rendering.OpenGL.Raw.Types

gl_1PASS_EXT :: GLenum
gl_1PASS_EXT = 0x80A1

gl_1PASS_SGIS :: GLenum
gl_1PASS_SGIS = 0x80A1

gl_2D :: GLenum
gl_2D = 0x0600

gl_2PASS_0_EXT :: GLenum
gl_2PASS_0_EXT = 0x80A2

gl_2PASS_0_SGIS :: GLenum
gl_2PASS_0_SGIS = 0x80A2

gl_2PASS_1_EXT :: GLenum
gl_2PASS_1_EXT = 0x80A3

gl_2PASS_1_SGIS :: GLenum
gl_2PASS_1_SGIS = 0x80A3

gl_2X_BIT_ATI :: GLbitfield
gl_2X_BIT_ATI = 0x00000001

gl_2_BYTES :: GLenum
gl_2_BYTES = 0x1407

gl_2_BYTES_NV :: GLenum
gl_2_BYTES_NV = 0x1407

gl_3D :: GLenum
gl_3D = 0x0601

gl_3DC_XY_AMD :: GLenum
gl_3DC_XY_AMD = 0x87FA

gl_3DC_X_AMD :: GLenum
gl_3DC_X_AMD = 0x87F9

gl_3D_COLOR :: GLenum
gl_3D_COLOR = 0x0602

gl_3D_COLOR_TEXTURE :: GLenum
gl_3D_COLOR_TEXTURE = 0x0603

gl_3_BYTES :: GLenum
gl_3_BYTES = 0x1408

gl_3_BYTES_NV :: GLenum
gl_3_BYTES_NV = 0x1408

gl_422_AVERAGE_EXT :: GLenum
gl_422_AVERAGE_EXT = 0x80CE

gl_422_EXT :: GLenum
gl_422_EXT = 0x80CC

gl_422_REV_AVERAGE_EXT :: GLenum
gl_422_REV_AVERAGE_EXT = 0x80CF

gl_422_REV_EXT :: GLenum
gl_422_REV_EXT = 0x80CD

gl_4D_COLOR_TEXTURE :: GLenum
gl_4D_COLOR_TEXTURE = 0x0604

gl_4PASS_0_EXT :: GLenum
gl_4PASS_0_EXT = 0x80A4

gl_4PASS_0_SGIS :: GLenum
gl_4PASS_0_SGIS = 0x80A4

gl_4PASS_1_EXT :: GLenum
gl_4PASS_1_EXT = 0x80A5

gl_4PASS_1_SGIS :: GLenum
gl_4PASS_1_SGIS = 0x80A5

gl_4PASS_2_EXT :: GLenum
gl_4PASS_2_EXT = 0x80A6

gl_4PASS_2_SGIS :: GLenum
gl_4PASS_2_SGIS = 0x80A6

gl_4PASS_3_EXT :: GLenum
gl_4PASS_3_EXT = 0x80A7

gl_4PASS_3_SGIS :: GLenum
gl_4PASS_3_SGIS = 0x80A7

gl_4X_BIT_ATI :: GLbitfield
gl_4X_BIT_ATI = 0x00000002

gl_4_BYTES :: GLenum
gl_4_BYTES = 0x1409

gl_4_BYTES_NV :: GLenum
gl_4_BYTES_NV = 0x1409

gl_8X_BIT_ATI :: GLbitfield
gl_8X_BIT_ATI = 0x00000004

gl_ABGR_EXT :: GLenum
gl_ABGR_EXT = 0x8000

gl_ACCUM :: GLenum
gl_ACCUM = 0x0100

gl_ACCUM_ADJACENT_PAIRS_NV :: GLenum
gl_ACCUM_ADJACENT_PAIRS_NV = 0x90AD

gl_ACCUM_ALPHA_BITS :: GLenum
gl_ACCUM_ALPHA_BITS = 0x0D5B

gl_ACCUM_BLUE_BITS :: GLenum
gl_ACCUM_BLUE_BITS = 0x0D5A

gl_ACCUM_BUFFER_BIT :: GLbitfield
gl_ACCUM_BUFFER_BIT = 0x00000200

gl_ACCUM_CLEAR_VALUE :: GLenum
gl_ACCUM_CLEAR_VALUE = 0x0B80

gl_ACCUM_GREEN_BITS :: GLenum
gl_ACCUM_GREEN_BITS = 0x0D59

gl_ACCUM_RED_BITS :: GLenum
gl_ACCUM_RED_BITS = 0x0D58

gl_ACTIVE_ATOMIC_COUNTER_BUFFERS :: GLenum
gl_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9

gl_ACTIVE_ATTRIBUTES :: GLenum
gl_ACTIVE_ATTRIBUTES = 0x8B89

gl_ACTIVE_ATTRIBUTE_MAX_LENGTH :: GLenum
gl_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A

gl_ACTIVE_PROGRAM :: GLenum
gl_ACTIVE_PROGRAM = 0x8259

gl_ACTIVE_PROGRAM_EXT :: GLenum
gl_ACTIVE_PROGRAM_EXT = 0x8B8D

gl_ACTIVE_RESOURCES :: GLenum
gl_ACTIVE_RESOURCES = 0x92F5

gl_ACTIVE_STENCIL_FACE_EXT :: GLenum
gl_ACTIVE_STENCIL_FACE_EXT = 0x8911

gl_ACTIVE_SUBROUTINES :: GLenum
gl_ACTIVE_SUBROUTINES = 0x8DE5

gl_ACTIVE_SUBROUTINE_MAX_LENGTH :: GLenum
gl_ACTIVE_SUBROUTINE_MAX_LENGTH = 0x8E48

gl_ACTIVE_SUBROUTINE_UNIFORMS :: GLenum
gl_ACTIVE_SUBROUTINE_UNIFORMS = 0x8DE6

gl_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS :: GLenum
gl_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 0x8E47

gl_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH :: GLenum
gl_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 0x8E49

gl_ACTIVE_TEXTURE :: GLenum
gl_ACTIVE_TEXTURE = 0x84E0

gl_ACTIVE_TEXTURE_ARB :: GLenum
gl_ACTIVE_TEXTURE_ARB = 0x84E0

gl_ACTIVE_UNIFORMS :: GLenum
gl_ACTIVE_UNIFORMS = 0x8B86

gl_ACTIVE_UNIFORM_BLOCKS :: GLenum
gl_ACTIVE_UNIFORM_BLOCKS = 0x8A36

gl_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH :: GLenum
gl_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 0x8A35

gl_ACTIVE_UNIFORM_MAX_LENGTH :: GLenum
gl_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87

gl_ACTIVE_VARIABLES :: GLenum
gl_ACTIVE_VARIABLES = 0x9305

gl_ACTIVE_VARYINGS_NV :: GLenum
gl_ACTIVE_VARYINGS_NV = 0x8C81

gl_ACTIVE_VARYING_MAX_LENGTH_NV :: GLenum
gl_ACTIVE_VARYING_MAX_LENGTH_NV = 0x8C82

gl_ACTIVE_VERTEX_UNITS_ARB :: GLenum
gl_ACTIVE_VERTEX_UNITS_ARB = 0x86A5

gl_ADD :: GLenum
gl_ADD = 0x0104

gl_ADD_ATI :: GLenum
gl_ADD_ATI = 0x8963

gl_ADD_BLEND_IMG :: GLenum
gl_ADD_BLEND_IMG = 0x8C09

gl_ADD_SIGNED :: GLenum
gl_ADD_SIGNED = 0x8574

gl_ADD_SIGNED_ARB :: GLenum
gl_ADD_SIGNED_ARB = 0x8574

gl_ADD_SIGNED_EXT :: GLenum
gl_ADD_SIGNED_EXT = 0x8574

gl_ADJACENT_PAIRS_NV :: GLenum
gl_ADJACENT_PAIRS_NV = 0x90AE

gl_AFFINE_2D_NV :: GLenum
gl_AFFINE_2D_NV = 0x9092

gl_AFFINE_3D_NV :: GLenum
gl_AFFINE_3D_NV = 0x9094

gl_ALIASED_LINE_WIDTH_RANGE :: GLenum
gl_ALIASED_LINE_WIDTH_RANGE = 0x846E

gl_ALIASED_POINT_SIZE_RANGE :: GLenum
gl_ALIASED_POINT_SIZE_RANGE = 0x846D

gl_ALLOW_DRAW_FRG_HINT_PGI :: GLenum
gl_ALLOW_DRAW_FRG_HINT_PGI = 0x1A210

gl_ALLOW_DRAW_MEM_HINT_PGI :: GLenum
gl_ALLOW_DRAW_MEM_HINT_PGI = 0x1A211

gl_ALLOW_DRAW_OBJ_HINT_PGI :: GLenum
gl_ALLOW_DRAW_OBJ_HINT_PGI = 0x1A20E

gl_ALLOW_DRAW_WIN_HINT_PGI :: GLenum
gl_ALLOW_DRAW_WIN_HINT_PGI = 0x1A20F

gl_ALL_ATTRIB_BITS :: GLbitfield
gl_ALL_ATTRIB_BITS = 0xFFFFFFFF

gl_ALL_BARRIER_BITS :: GLbitfield
gl_ALL_BARRIER_BITS = 0xFFFFFFFF

gl_ALL_BARRIER_BITS_EXT :: GLbitfield
gl_ALL_BARRIER_BITS_EXT = 0xFFFFFFFF

gl_ALL_COMPLETED_NV :: GLenum
gl_ALL_COMPLETED_NV = 0x84F2

gl_ALL_SHADER_BITS :: GLbitfield
gl_ALL_SHADER_BITS = 0xFFFFFFFF

gl_ALL_SHADER_BITS_EXT :: GLbitfield
gl_ALL_SHADER_BITS_EXT = 0xFFFFFFFF

gl_ALL_STATIC_DATA_IBM :: GLenum
gl_ALL_STATIC_DATA_IBM = 103060

gl_ALPHA :: GLenum
gl_ALPHA = 0x1906

gl_ALPHA12 :: GLenum
gl_ALPHA12 = 0x803D

gl_ALPHA12_EXT :: GLenum
gl_ALPHA12_EXT = 0x803D

gl_ALPHA16 :: GLenum
gl_ALPHA16 = 0x803E

gl_ALPHA16F_ARB :: GLenum
gl_ALPHA16F_ARB = 0x881C

gl_ALPHA16F_EXT :: GLenum
gl_ALPHA16F_EXT = 0x881C

gl_ALPHA16I_EXT :: GLenum
gl_ALPHA16I_EXT = 0x8D8A

gl_ALPHA16UI_EXT :: GLenum
gl_ALPHA16UI_EXT = 0x8D78

gl_ALPHA16_EXT :: GLenum
gl_ALPHA16_EXT = 0x803E

gl_ALPHA16_SNORM :: GLenum
gl_ALPHA16_SNORM = 0x9018

gl_ALPHA32F_ARB :: GLenum
gl_ALPHA32F_ARB = 0x8816

gl_ALPHA32F_EXT :: GLenum
gl_ALPHA32F_EXT = 0x8816

gl_ALPHA32I_EXT :: GLenum
gl_ALPHA32I_EXT = 0x8D84

gl_ALPHA32UI_EXT :: GLenum
gl_ALPHA32UI_EXT = 0x8D72

gl_ALPHA4 :: GLenum
gl_ALPHA4 = 0x803B

gl_ALPHA4_EXT :: GLenum
gl_ALPHA4_EXT = 0x803B

gl_ALPHA8 :: GLenum
gl_ALPHA8 = 0x803C

gl_ALPHA8I_EXT :: GLenum
gl_ALPHA8I_EXT = 0x8D90

gl_ALPHA8UI_EXT :: GLenum
gl_ALPHA8UI_EXT = 0x8D7E

gl_ALPHA8_EXT :: GLenum
gl_ALPHA8_EXT = 0x803C

gl_ALPHA8_OES :: GLenum
gl_ALPHA8_OES = 0x803C

gl_ALPHA8_SNORM :: GLenum
gl_ALPHA8_SNORM = 0x9014

gl_ALPHA_BIAS :: GLenum
gl_ALPHA_BIAS = 0x0D1D

gl_ALPHA_BITS :: GLenum
gl_ALPHA_BITS = 0x0D55

gl_ALPHA_FLOAT16_APPLE :: GLenum
gl_ALPHA_FLOAT16_APPLE = 0x881C

gl_ALPHA_FLOAT16_ATI :: GLenum
gl_ALPHA_FLOAT16_ATI = 0x881C

gl_ALPHA_FLOAT32_APPLE :: GLenum
gl_ALPHA_FLOAT32_APPLE = 0x8816

gl_ALPHA_FLOAT32_ATI :: GLenum
gl_ALPHA_FLOAT32_ATI = 0x8816

gl_ALPHA_INTEGER :: GLenum
gl_ALPHA_INTEGER = 0x8D97

gl_ALPHA_INTEGER_EXT :: GLenum
gl_ALPHA_INTEGER_EXT = 0x8D97

gl_ALPHA_MAX_CLAMP_INGR :: GLenum
gl_ALPHA_MAX_CLAMP_INGR = 0x8567

gl_ALPHA_MAX_SGIX :: GLenum
gl_ALPHA_MAX_SGIX = 0x8321

gl_ALPHA_MIN_CLAMP_INGR :: GLenum
gl_ALPHA_MIN_CLAMP_INGR = 0x8563

gl_ALPHA_MIN_SGIX :: GLenum
gl_ALPHA_MIN_SGIX = 0x8320

gl_ALPHA_SCALE :: GLenum
gl_ALPHA_SCALE = 0x0D1C

gl_ALPHA_SNORM :: GLenum
gl_ALPHA_SNORM = 0x9010

gl_ALPHA_TEST :: GLenum
gl_ALPHA_TEST = 0x0BC0

gl_ALPHA_TEST_FUNC :: GLenum
gl_ALPHA_TEST_FUNC = 0x0BC1

gl_ALPHA_TEST_FUNC_QCOM :: GLenum
gl_ALPHA_TEST_FUNC_QCOM = 0x0BC1

gl_ALPHA_TEST_QCOM :: GLenum
gl_ALPHA_TEST_QCOM = 0x0BC0

gl_ALPHA_TEST_REF :: GLenum
gl_ALPHA_TEST_REF = 0x0BC2

gl_ALPHA_TEST_REF_QCOM :: GLenum
gl_ALPHA_TEST_REF_QCOM = 0x0BC2

gl_ALREADY_SIGNALED :: GLenum
gl_ALREADY_SIGNALED = 0x911A

gl_ALREADY_SIGNALED_APPLE :: GLenum
gl_ALREADY_SIGNALED_APPLE = 0x911A

gl_ALWAYS :: GLenum
gl_ALWAYS = 0x0207

gl_ALWAYS_FAST_HINT_PGI :: GLenum
gl_ALWAYS_FAST_HINT_PGI = 0x1A20C

gl_ALWAYS_SOFT_HINT_PGI :: GLenum
gl_ALWAYS_SOFT_HINT_PGI = 0x1A20D

gl_AMBIENT :: GLenum
gl_AMBIENT = 0x1200

gl_AMBIENT_AND_DIFFUSE :: GLenum
gl_AMBIENT_AND_DIFFUSE = 0x1602

gl_AND :: GLenum
gl_AND = 0x1501

gl_AND_INVERTED :: GLenum
gl_AND_INVERTED = 0x1504

gl_AND_REVERSE :: GLenum
gl_AND_REVERSE = 0x1502

gl_ANY_SAMPLES_PASSED :: GLenum
gl_ANY_SAMPLES_PASSED = 0x8C2F

gl_ANY_SAMPLES_PASSED_CONSERVATIVE :: GLenum
gl_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A

gl_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT :: GLenum
gl_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT = 0x8D6A

gl_ANY_SAMPLES_PASSED_EXT :: GLenum
gl_ANY_SAMPLES_PASSED_EXT = 0x8C2F

gl_ARC_TO_NV :: GLubyte
gl_ARC_TO_NV = 0xFE

gl_ARRAY_BUFFER :: GLenum
gl_ARRAY_BUFFER = 0x8892

gl_ARRAY_BUFFER_ARB :: GLenum
gl_ARRAY_BUFFER_ARB = 0x8892

gl_ARRAY_BUFFER_BINDING :: GLenum
gl_ARRAY_BUFFER_BINDING = 0x8894

gl_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_ARRAY_BUFFER_BINDING_ARB = 0x8894

gl_ARRAY_ELEMENT_LOCK_COUNT_EXT :: GLenum
gl_ARRAY_ELEMENT_LOCK_COUNT_EXT = 0x81A9

gl_ARRAY_ELEMENT_LOCK_FIRST_EXT :: GLenum
gl_ARRAY_ELEMENT_LOCK_FIRST_EXT = 0x81A8

gl_ARRAY_OBJECT_BUFFER_ATI :: GLenum
gl_ARRAY_OBJECT_BUFFER_ATI = 0x8766

gl_ARRAY_OBJECT_OFFSET_ATI :: GLenum
gl_ARRAY_OBJECT_OFFSET_ATI = 0x8767

gl_ARRAY_SIZE :: GLenum
gl_ARRAY_SIZE = 0x92FB

gl_ARRAY_STRIDE :: GLenum
gl_ARRAY_STRIDE = 0x92FE

gl_ASYNC_DRAW_PIXELS_SGIX :: GLenum
gl_ASYNC_DRAW_PIXELS_SGIX = 0x835D

gl_ASYNC_HISTOGRAM_SGIX :: GLenum
gl_ASYNC_HISTOGRAM_SGIX = 0x832C

gl_ASYNC_MARKER_SGIX :: GLenum
gl_ASYNC_MARKER_SGIX = 0x8329

gl_ASYNC_READ_PIXELS_SGIX :: GLenum
gl_ASYNC_READ_PIXELS_SGIX = 0x835E

gl_ASYNC_TEX_IMAGE_SGIX :: GLenum
gl_ASYNC_TEX_IMAGE_SGIX = 0x835C

gl_ATC_RGBA_EXPLICIT_ALPHA_AMD :: GLenum
gl_ATC_RGBA_EXPLICIT_ALPHA_AMD = 0x8C93

gl_ATC_RGBA_INTERPOLATED_ALPHA_AMD :: GLenum
gl_ATC_RGBA_INTERPOLATED_ALPHA_AMD = 0x87EE

gl_ATC_RGB_AMD :: GLenum
gl_ATC_RGB_AMD = 0x8C92

gl_ATOMIC_COUNTER_BARRIER_BIT :: GLbitfield
gl_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000

gl_ATOMIC_COUNTER_BARRIER_BIT_EXT :: GLbitfield
gl_ATOMIC_COUNTER_BARRIER_BIT_EXT = 0x00001000

gl_ATOMIC_COUNTER_BUFFER :: GLenum
gl_ATOMIC_COUNTER_BUFFER = 0x92C0

gl_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS :: GLenum
gl_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = 0x92C5

gl_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES :: GLenum
gl_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = 0x92C6

gl_ATOMIC_COUNTER_BUFFER_BINDING :: GLenum
gl_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1

gl_ATOMIC_COUNTER_BUFFER_DATA_SIZE :: GLenum
gl_ATOMIC_COUNTER_BUFFER_DATA_SIZE = 0x92C4

gl_ATOMIC_COUNTER_BUFFER_INDEX :: GLenum
gl_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301

gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER :: GLenum
gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 0x90ED

gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER :: GLenum
gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = 0x92CB

gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER :: GLenum
gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = 0x92CA

gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER :: GLenum
gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = 0x92C8

gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER :: GLenum
gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9

gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER :: GLenum
gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = 0x92C7

gl_ATOMIC_COUNTER_BUFFER_SIZE :: GLenum
gl_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3

gl_ATOMIC_COUNTER_BUFFER_START :: GLenum
gl_ATOMIC_COUNTER_BUFFER_START = 0x92C2

gl_ATTACHED_SHADERS :: GLenum
gl_ATTACHED_SHADERS = 0x8B85

gl_ATTENUATION_EXT :: GLenum
gl_ATTENUATION_EXT = 0x834D

gl_ATTRIB_ARRAY_POINTER_NV :: GLenum
gl_ATTRIB_ARRAY_POINTER_NV = 0x8645

gl_ATTRIB_ARRAY_SIZE_NV :: GLenum
gl_ATTRIB_ARRAY_SIZE_NV = 0x8623

gl_ATTRIB_ARRAY_STRIDE_NV :: GLenum
gl_ATTRIB_ARRAY_STRIDE_NV = 0x8624

gl_ATTRIB_ARRAY_TYPE_NV :: GLenum
gl_ATTRIB_ARRAY_TYPE_NV = 0x8625

gl_ATTRIB_STACK_DEPTH :: GLenum
gl_ATTRIB_STACK_DEPTH = 0x0BB0

gl_AUTO_GENERATE_MIPMAP :: GLenum
gl_AUTO_GENERATE_MIPMAP = 0x8295

gl_AUTO_NORMAL :: GLenum
gl_AUTO_NORMAL = 0x0D80

gl_AUX0 :: GLenum
gl_AUX0 = 0x0409

gl_AUX1 :: GLenum
gl_AUX1 = 0x040A

gl_AUX2 :: GLenum
gl_AUX2 = 0x040B

gl_AUX3 :: GLenum
gl_AUX3 = 0x040C

gl_AUX_BUFFERS :: GLenum
gl_AUX_BUFFERS = 0x0C00

gl_AUX_DEPTH_STENCIL_APPLE :: GLenum
gl_AUX_DEPTH_STENCIL_APPLE = 0x8A14

gl_AVERAGE_EXT :: GLenum
gl_AVERAGE_EXT = 0x8335

gl_AVERAGE_HP :: GLenum
gl_AVERAGE_HP = 0x8160

gl_BACK :: GLenum
gl_BACK = 0x0405

gl_BACK_LEFT :: GLenum
gl_BACK_LEFT = 0x0402

gl_BACK_NORMALS_HINT_PGI :: GLenum
gl_BACK_NORMALS_HINT_PGI = 0x1A223

gl_BACK_PRIMARY_COLOR_NV :: GLenum
gl_BACK_PRIMARY_COLOR_NV = 0x8C77

gl_BACK_RIGHT :: GLenum
gl_BACK_RIGHT = 0x0403

gl_BACK_SECONDARY_COLOR_NV :: GLenum
gl_BACK_SECONDARY_COLOR_NV = 0x8C78

gl_BEVEL_NV :: GLenum
gl_BEVEL_NV = 0x90A6

gl_BGR :: GLenum
gl_BGR = 0x80E0

gl_BGRA :: GLenum
gl_BGRA = 0x80E1

gl_BGRA8_EXT :: GLenum
gl_BGRA8_EXT = 0x93A1

gl_BGRA_EXT :: GLenum
gl_BGRA_EXT = 0x80E1

gl_BGRA_IMG :: GLenum
gl_BGRA_IMG = 0x80E1

gl_BGRA_INTEGER :: GLenum
gl_BGRA_INTEGER = 0x8D9B

gl_BGRA_INTEGER_EXT :: GLenum
gl_BGRA_INTEGER_EXT = 0x8D9B

gl_BGR_EXT :: GLenum
gl_BGR_EXT = 0x80E0

gl_BGR_INTEGER :: GLenum
gl_BGR_INTEGER = 0x8D9A

gl_BGR_INTEGER_EXT :: GLenum
gl_BGR_INTEGER_EXT = 0x8D9A

gl_BIAS_BIT_ATI :: GLbitfield
gl_BIAS_BIT_ATI = 0x00000008

gl_BIAS_BY_NEGATIVE_ONE_HALF_NV :: GLenum
gl_BIAS_BY_NEGATIVE_ONE_HALF_NV = 0x8541

gl_BINNING_CONTROL_HINT_QCOM :: GLenum
gl_BINNING_CONTROL_HINT_QCOM = 0x8FB0

gl_BINORMAL_ARRAY_EXT :: GLenum
gl_BINORMAL_ARRAY_EXT = 0x843A

gl_BINORMAL_ARRAY_POINTER_EXT :: GLenum
gl_BINORMAL_ARRAY_POINTER_EXT = 0x8443

gl_BINORMAL_ARRAY_STRIDE_EXT :: GLenum
gl_BINORMAL_ARRAY_STRIDE_EXT = 0x8441

gl_BINORMAL_ARRAY_TYPE_EXT :: GLenum
gl_BINORMAL_ARRAY_TYPE_EXT = 0x8440

gl_BITMAP :: GLenum
gl_BITMAP = 0x1A00

gl_BITMAP_TOKEN :: GLenum
gl_BITMAP_TOKEN = 0x0704

gl_BLEND :: GLenum
gl_BLEND = 0x0BE2

gl_BLEND_ADVANCED_COHERENT_KHR :: GLenum
gl_BLEND_ADVANCED_COHERENT_KHR = 0x9285

gl_BLEND_ADVANCED_COHERENT_NV :: GLenum
gl_BLEND_ADVANCED_COHERENT_NV = 0x9285

gl_BLEND_COLOR :: GLenum
gl_BLEND_COLOR = 0x8005

gl_BLEND_COLOR_EXT :: GLenum
gl_BLEND_COLOR_EXT = 0x8005

gl_BLEND_DST :: GLenum
gl_BLEND_DST = 0x0BE0

gl_BLEND_DST_ALPHA :: GLenum
gl_BLEND_DST_ALPHA = 0x80CA

gl_BLEND_DST_ALPHA_EXT :: GLenum
gl_BLEND_DST_ALPHA_EXT = 0x80CA

gl_BLEND_DST_ALPHA_OES :: GLenum
gl_BLEND_DST_ALPHA_OES = 0x80CA

gl_BLEND_DST_RGB :: GLenum
gl_BLEND_DST_RGB = 0x80C8

gl_BLEND_DST_RGB_EXT :: GLenum
gl_BLEND_DST_RGB_EXT = 0x80C8

gl_BLEND_DST_RGB_OES :: GLenum
gl_BLEND_DST_RGB_OES = 0x80C8

gl_BLEND_EQUATION :: GLenum
gl_BLEND_EQUATION = 0x8009

gl_BLEND_EQUATION_ALPHA :: GLenum
gl_BLEND_EQUATION_ALPHA = 0x883D

gl_BLEND_EQUATION_ALPHA_EXT :: GLenum
gl_BLEND_EQUATION_ALPHA_EXT = 0x883D

gl_BLEND_EQUATION_ALPHA_OES :: GLenum
gl_BLEND_EQUATION_ALPHA_OES = 0x883D

gl_BLEND_EQUATION_EXT :: GLenum
gl_BLEND_EQUATION_EXT = 0x8009

gl_BLEND_EQUATION_OES :: GLenum
gl_BLEND_EQUATION_OES = 0x8009

gl_BLEND_EQUATION_RGB :: GLenum
gl_BLEND_EQUATION_RGB = 0x8009

gl_BLEND_EQUATION_RGB_EXT :: GLenum
gl_BLEND_EQUATION_RGB_EXT = 0x8009

gl_BLEND_EQUATION_RGB_OES :: GLenum
gl_BLEND_EQUATION_RGB_OES = 0x8009

gl_BLEND_OVERLAP_NV :: GLenum
gl_BLEND_OVERLAP_NV = 0x9281

gl_BLEND_PREMULTIPLIED_SRC_NV :: GLenum
gl_BLEND_PREMULTIPLIED_SRC_NV = 0x9280

gl_BLEND_SRC :: GLenum
gl_BLEND_SRC = 0x0BE1

gl_BLEND_SRC_ALPHA :: GLenum
gl_BLEND_SRC_ALPHA = 0x80CB

gl_BLEND_SRC_ALPHA_EXT :: GLenum
gl_BLEND_SRC_ALPHA_EXT = 0x80CB

gl_BLEND_SRC_ALPHA_OES :: GLenum
gl_BLEND_SRC_ALPHA_OES = 0x80CB

gl_BLEND_SRC_RGB :: GLenum
gl_BLEND_SRC_RGB = 0x80C9

gl_BLEND_SRC_RGB_EXT :: GLenum
gl_BLEND_SRC_RGB_EXT = 0x80C9

gl_BLEND_SRC_RGB_OES :: GLenum
gl_BLEND_SRC_RGB_OES = 0x80C9

gl_BLOCK_INDEX :: GLenum
gl_BLOCK_INDEX = 0x92FD

gl_BLUE :: GLenum
gl_BLUE = 0x1905

gl_BLUE_BIAS :: GLenum
gl_BLUE_BIAS = 0x0D1B

gl_BLUE_BITS :: GLenum
gl_BLUE_BITS = 0x0D54

gl_BLUE_BIT_ATI :: GLbitfield
gl_BLUE_BIT_ATI = 0x00000004

gl_BLUE_INTEGER :: GLenum
gl_BLUE_INTEGER = 0x8D96

gl_BLUE_INTEGER_EXT :: GLenum
gl_BLUE_INTEGER_EXT = 0x8D96

gl_BLUE_MAX_CLAMP_INGR :: GLenum
gl_BLUE_MAX_CLAMP_INGR = 0x8566

gl_BLUE_MIN_CLAMP_INGR :: GLenum
gl_BLUE_MIN_CLAMP_INGR = 0x8562

gl_BLUE_NV :: GLenum
gl_BLUE_NV = 0x1905

gl_BLUE_SCALE :: GLenum
gl_BLUE_SCALE = 0x0D1A

gl_BOLD_BIT_NV :: GLbitfield
gl_BOLD_BIT_NV = 0x01

gl_BOOL :: GLenum
gl_BOOL = 0x8B56

gl_BOOL_ARB :: GLenum
gl_BOOL_ARB = 0x8B56

gl_BOOL_VEC2 :: GLenum
gl_BOOL_VEC2 = 0x8B57

gl_BOOL_VEC2_ARB :: GLenum
gl_BOOL_VEC2_ARB = 0x8B57

gl_BOOL_VEC3 :: GLenum
gl_BOOL_VEC3 = 0x8B58

gl_BOOL_VEC3_ARB :: GLenum
gl_BOOL_VEC3_ARB = 0x8B58

gl_BOOL_VEC4 :: GLenum
gl_BOOL_VEC4 = 0x8B59

gl_BOOL_VEC4_ARB :: GLenum
gl_BOOL_VEC4_ARB = 0x8B59

gl_BOUNDING_BOX_NV :: GLenum
gl_BOUNDING_BOX_NV = 0x908D

gl_BOUNDING_BOX_OF_BOUNDING_BOXES_NV :: GLenum
gl_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = 0x909C

gl_BROWSER_DEFAULT_WEBGL :: GLenum
gl_BROWSER_DEFAULT_WEBGL = 0x9244

gl_BUFFER :: GLenum
gl_BUFFER = 0x82E0

gl_BUFFER_ACCESS :: GLenum
gl_BUFFER_ACCESS = 0x88BB

gl_BUFFER_ACCESS_ARB :: GLenum
gl_BUFFER_ACCESS_ARB = 0x88BB

gl_BUFFER_ACCESS_FLAGS :: GLenum
gl_BUFFER_ACCESS_FLAGS = 0x911F

gl_BUFFER_ACCESS_OES :: GLenum
gl_BUFFER_ACCESS_OES = 0x88BB

gl_BUFFER_BINDING :: GLenum
gl_BUFFER_BINDING = 0x9302

gl_BUFFER_DATA_SIZE :: GLenum
gl_BUFFER_DATA_SIZE = 0x9303

gl_BUFFER_FLUSHING_UNMAP_APPLE :: GLenum
gl_BUFFER_FLUSHING_UNMAP_APPLE = 0x8A13

gl_BUFFER_GPU_ADDRESS_NV :: GLenum
gl_BUFFER_GPU_ADDRESS_NV = 0x8F1D

gl_BUFFER_IMMUTABLE_STORAGE :: GLenum
gl_BUFFER_IMMUTABLE_STORAGE = 0x821F

gl_BUFFER_KHR :: GLenum
gl_BUFFER_KHR = 0x82E0

gl_BUFFER_MAPPED :: GLenum
gl_BUFFER_MAPPED = 0x88BC

gl_BUFFER_MAPPED_ARB :: GLenum
gl_BUFFER_MAPPED_ARB = 0x88BC

gl_BUFFER_MAPPED_OES :: GLenum
gl_BUFFER_MAPPED_OES = 0x88BC

gl_BUFFER_MAP_LENGTH :: GLenum
gl_BUFFER_MAP_LENGTH = 0x9120

gl_BUFFER_MAP_OFFSET :: GLenum
gl_BUFFER_MAP_OFFSET = 0x9121

gl_BUFFER_MAP_POINTER :: GLenum
gl_BUFFER_MAP_POINTER = 0x88BD

gl_BUFFER_MAP_POINTER_ARB :: GLenum
gl_BUFFER_MAP_POINTER_ARB = 0x88BD

gl_BUFFER_MAP_POINTER_OES :: GLenum
gl_BUFFER_MAP_POINTER_OES = 0x88BD

gl_BUFFER_OBJECT_APPLE :: GLenum
gl_BUFFER_OBJECT_APPLE = 0x85B3

gl_BUFFER_OBJECT_EXT :: GLenum
gl_BUFFER_OBJECT_EXT = 0x9151

gl_BUFFER_SERIALIZED_MODIFY_APPLE :: GLenum
gl_BUFFER_SERIALIZED_MODIFY_APPLE = 0x8A12

gl_BUFFER_SIZE :: GLenum
gl_BUFFER_SIZE = 0x8764

gl_BUFFER_SIZE_ARB :: GLenum
gl_BUFFER_SIZE_ARB = 0x8764

gl_BUFFER_STORAGE_FLAGS :: GLenum
gl_BUFFER_STORAGE_FLAGS = 0x8220

gl_BUFFER_UPDATE_BARRIER_BIT :: GLbitfield
gl_BUFFER_UPDATE_BARRIER_BIT = 0x00000200

gl_BUFFER_UPDATE_BARRIER_BIT_EXT :: GLbitfield
gl_BUFFER_UPDATE_BARRIER_BIT_EXT = 0x00000200

gl_BUFFER_USAGE :: GLenum
gl_BUFFER_USAGE = 0x8765

gl_BUFFER_USAGE_ARB :: GLenum
gl_BUFFER_USAGE_ARB = 0x8765

gl_BUFFER_VARIABLE :: GLenum
gl_BUFFER_VARIABLE = 0x92E5

gl_BUMP_ENVMAP_ATI :: GLenum
gl_BUMP_ENVMAP_ATI = 0x877B

gl_BUMP_NUM_TEX_UNITS_ATI :: GLenum
gl_BUMP_NUM_TEX_UNITS_ATI = 0x8777

gl_BUMP_ROT_MATRIX_ATI :: GLenum
gl_BUMP_ROT_MATRIX_ATI = 0x8775

gl_BUMP_ROT_MATRIX_SIZE_ATI :: GLenum
gl_BUMP_ROT_MATRIX_SIZE_ATI = 0x8776

gl_BUMP_TARGET_ATI :: GLenum
gl_BUMP_TARGET_ATI = 0x877C

gl_BUMP_TEX_UNITS_ATI :: GLenum
gl_BUMP_TEX_UNITS_ATI = 0x8778

gl_BYTE :: GLenum
gl_BYTE = 0x1400

gl_C3F_V3F :: GLenum
gl_C3F_V3F = 0x2A24

gl_C4F_N3F_V3F :: GLenum
gl_C4F_N3F_V3F = 0x2A26

gl_C4UB_V2F :: GLenum
gl_C4UB_V2F = 0x2A22

gl_C4UB_V3F :: GLenum
gl_C4UB_V3F = 0x2A23

gl_CALLIGRAPHIC_FRAGMENT_SGIX :: GLenum
gl_CALLIGRAPHIC_FRAGMENT_SGIX = 0x8183

gl_CAVEAT_SUPPORT :: GLenum
gl_CAVEAT_SUPPORT = 0x82B8

gl_CCW :: GLenum
gl_CCW = 0x0901

gl_CIRCULAR_CCW_ARC_TO_NV :: GLubyte
gl_CIRCULAR_CCW_ARC_TO_NV = 0xF8

gl_CIRCULAR_CW_ARC_TO_NV :: GLubyte
gl_CIRCULAR_CW_ARC_TO_NV = 0xFA

gl_CIRCULAR_TANGENT_ARC_TO_NV :: GLubyte
gl_CIRCULAR_TANGENT_ARC_TO_NV = 0xFC

gl_CLAMP :: GLenum
gl_CLAMP = 0x2900

gl_CLAMP_FRAGMENT_COLOR :: GLenum
gl_CLAMP_FRAGMENT_COLOR = 0x891B

gl_CLAMP_FRAGMENT_COLOR_ARB :: GLenum
gl_CLAMP_FRAGMENT_COLOR_ARB = 0x891B

gl_CLAMP_READ_COLOR :: GLenum
gl_CLAMP_READ_COLOR = 0x891C

gl_CLAMP_READ_COLOR_ARB :: GLenum
gl_CLAMP_READ_COLOR_ARB = 0x891C

gl_CLAMP_TO_BORDER :: GLenum
gl_CLAMP_TO_BORDER = 0x812D

gl_CLAMP_TO_BORDER_ARB :: GLenum
gl_CLAMP_TO_BORDER_ARB = 0x812D

gl_CLAMP_TO_BORDER_EXT :: GLenum
gl_CLAMP_TO_BORDER_EXT = 0x812D

gl_CLAMP_TO_BORDER_NV :: GLenum
gl_CLAMP_TO_BORDER_NV = 0x812D

gl_CLAMP_TO_BORDER_OES :: GLenum
gl_CLAMP_TO_BORDER_OES = 0x812D

gl_CLAMP_TO_BORDER_SGIS :: GLenum
gl_CLAMP_TO_BORDER_SGIS = 0x812D

gl_CLAMP_TO_EDGE :: GLenum
gl_CLAMP_TO_EDGE = 0x812F

gl_CLAMP_TO_EDGE_SGIS :: GLenum
gl_CLAMP_TO_EDGE_SGIS = 0x812F

gl_CLAMP_VERTEX_COLOR :: GLenum
gl_CLAMP_VERTEX_COLOR = 0x891A

gl_CLAMP_VERTEX_COLOR_ARB :: GLenum
gl_CLAMP_VERTEX_COLOR_ARB = 0x891A

gl_CLEAR :: GLenum
gl_CLEAR = 0x1500

gl_CLEAR_BUFFER :: GLenum
gl_CLEAR_BUFFER = 0x82B4

gl_CLEAR_TEXTURE :: GLenum
gl_CLEAR_TEXTURE = 0x9365

gl_CLIENT_ACTIVE_TEXTURE :: GLenum
gl_CLIENT_ACTIVE_TEXTURE = 0x84E1

gl_CLIENT_ACTIVE_TEXTURE_ARB :: GLenum
gl_CLIENT_ACTIVE_TEXTURE_ARB = 0x84E1

gl_CLIENT_ALL_ATTRIB_BITS :: GLbitfield
gl_CLIENT_ALL_ATTRIB_BITS = 0xFFFFFFFF

gl_CLIENT_ATTRIB_STACK_DEPTH :: GLenum
gl_CLIENT_ATTRIB_STACK_DEPTH = 0x0BB1

gl_CLIENT_MAPPED_BUFFER_BARRIER_BIT :: GLbitfield
gl_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 0x00004000

gl_CLIENT_PIXEL_STORE_BIT :: GLbitfield
gl_CLIENT_PIXEL_STORE_BIT = 0x00000001

gl_CLIENT_STORAGE_BIT :: GLbitfield
gl_CLIENT_STORAGE_BIT = 0x0200

gl_CLIENT_VERTEX_ARRAY_BIT :: GLbitfield
gl_CLIENT_VERTEX_ARRAY_BIT = 0x00000002

gl_CLIPPING_INPUT_PRIMITIVES_ARB :: GLenum
gl_CLIPPING_INPUT_PRIMITIVES_ARB = 0x82F6

gl_CLIPPING_OUTPUT_PRIMITIVES_ARB :: GLenum
gl_CLIPPING_OUTPUT_PRIMITIVES_ARB = 0x82F7

gl_CLIP_DEPTH_MODE :: GLenum
gl_CLIP_DEPTH_MODE = 0x935D

gl_CLIP_DISTANCE0 :: GLenum
gl_CLIP_DISTANCE0 = 0x3000

gl_CLIP_DISTANCE0_APPLE :: GLenum
gl_CLIP_DISTANCE0_APPLE = 0x3000

gl_CLIP_DISTANCE1 :: GLenum
gl_CLIP_DISTANCE1 = 0x3001

gl_CLIP_DISTANCE1_APPLE :: GLenum
gl_CLIP_DISTANCE1_APPLE = 0x3001

gl_CLIP_DISTANCE2 :: GLenum
gl_CLIP_DISTANCE2 = 0x3002

gl_CLIP_DISTANCE2_APPLE :: GLenum
gl_CLIP_DISTANCE2_APPLE = 0x3002

gl_CLIP_DISTANCE3 :: GLenum
gl_CLIP_DISTANCE3 = 0x3003

gl_CLIP_DISTANCE3_APPLE :: GLenum
gl_CLIP_DISTANCE3_APPLE = 0x3003

gl_CLIP_DISTANCE4 :: GLenum
gl_CLIP_DISTANCE4 = 0x3004

gl_CLIP_DISTANCE4_APPLE :: GLenum
gl_CLIP_DISTANCE4_APPLE = 0x3004

gl_CLIP_DISTANCE5 :: GLenum
gl_CLIP_DISTANCE5 = 0x3005

gl_CLIP_DISTANCE5_APPLE :: GLenum
gl_CLIP_DISTANCE5_APPLE = 0x3005

gl_CLIP_DISTANCE6 :: GLenum
gl_CLIP_DISTANCE6 = 0x3006

gl_CLIP_DISTANCE6_APPLE :: GLenum
gl_CLIP_DISTANCE6_APPLE = 0x3006

gl_CLIP_DISTANCE7 :: GLenum
gl_CLIP_DISTANCE7 = 0x3007

gl_CLIP_DISTANCE7_APPLE :: GLenum
gl_CLIP_DISTANCE7_APPLE = 0x3007

gl_CLIP_DISTANCE_NV :: GLenum
gl_CLIP_DISTANCE_NV = 0x8C7A

gl_CLIP_FAR_HINT_PGI :: GLenum
gl_CLIP_FAR_HINT_PGI = 0x1A221

gl_CLIP_NEAR_HINT_PGI :: GLenum
gl_CLIP_NEAR_HINT_PGI = 0x1A220

gl_CLIP_ORIGIN :: GLenum
gl_CLIP_ORIGIN = 0x935C

gl_CLIP_PLANE0 :: GLenum
gl_CLIP_PLANE0 = 0x3000

gl_CLIP_PLANE0_IMG :: GLenum
gl_CLIP_PLANE0_IMG = 0x3000

gl_CLIP_PLANE1 :: GLenum
gl_CLIP_PLANE1 = 0x3001

gl_CLIP_PLANE1_IMG :: GLenum
gl_CLIP_PLANE1_IMG = 0x3001

gl_CLIP_PLANE2 :: GLenum
gl_CLIP_PLANE2 = 0x3002

gl_CLIP_PLANE2_IMG :: GLenum
gl_CLIP_PLANE2_IMG = 0x3002

gl_CLIP_PLANE3 :: GLenum
gl_CLIP_PLANE3 = 0x3003

gl_CLIP_PLANE3_IMG :: GLenum
gl_CLIP_PLANE3_IMG = 0x3003

gl_CLIP_PLANE4 :: GLenum
gl_CLIP_PLANE4 = 0x3004

gl_CLIP_PLANE4_IMG :: GLenum
gl_CLIP_PLANE4_IMG = 0x3004

gl_CLIP_PLANE5 :: GLenum
gl_CLIP_PLANE5 = 0x3005

gl_CLIP_PLANE5_IMG :: GLenum
gl_CLIP_PLANE5_IMG = 0x3005

gl_CLIP_VOLUME_CLIPPING_HINT_EXT :: GLenum
gl_CLIP_VOLUME_CLIPPING_HINT_EXT = 0x80F0

gl_CLOSE_PATH_NV :: GLubyte
gl_CLOSE_PATH_NV = 0x00

gl_CMYKA_EXT :: GLenum
gl_CMYKA_EXT = 0x800D

gl_CMYK_EXT :: GLenum
gl_CMYK_EXT = 0x800C

gl_CND0_ATI :: GLenum
gl_CND0_ATI = 0x896B

gl_CND_ATI :: GLenum
gl_CND_ATI = 0x896A

gl_COEFF :: GLenum
gl_COEFF = 0x0A00

gl_COLOR :: GLenum
gl_COLOR = 0x1800

gl_COLOR3_BIT_PGI :: GLbitfield
gl_COLOR3_BIT_PGI = 0x00010000

gl_COLOR4_BIT_PGI :: GLbitfield
gl_COLOR4_BIT_PGI = 0x00020000

gl_COLORBURN_KHR :: GLenum
gl_COLORBURN_KHR = 0x929A

gl_COLORBURN_NV :: GLenum
gl_COLORBURN_NV = 0x929A

gl_COLORDODGE_KHR :: GLenum
gl_COLORDODGE_KHR = 0x9299

gl_COLORDODGE_NV :: GLenum
gl_COLORDODGE_NV = 0x9299

gl_COLOR_ALPHA_PAIRING_ATI :: GLenum
gl_COLOR_ALPHA_PAIRING_ATI = 0x8975

gl_COLOR_ARRAY :: GLenum
gl_COLOR_ARRAY = 0x8076

gl_COLOR_ARRAY_ADDRESS_NV :: GLenum
gl_COLOR_ARRAY_ADDRESS_NV = 0x8F23

gl_COLOR_ARRAY_BUFFER_BINDING :: GLenum
gl_COLOR_ARRAY_BUFFER_BINDING = 0x8898

gl_COLOR_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x8898

gl_COLOR_ARRAY_COUNT_EXT :: GLenum
gl_COLOR_ARRAY_COUNT_EXT = 0x8084

gl_COLOR_ARRAY_EXT :: GLenum
gl_COLOR_ARRAY_EXT = 0x8076

gl_COLOR_ARRAY_LENGTH_NV :: GLenum
gl_COLOR_ARRAY_LENGTH_NV = 0x8F2D

gl_COLOR_ARRAY_LIST_IBM :: GLenum
gl_COLOR_ARRAY_LIST_IBM = 103072

gl_COLOR_ARRAY_LIST_STRIDE_IBM :: GLenum
gl_COLOR_ARRAY_LIST_STRIDE_IBM = 103082

gl_COLOR_ARRAY_PARALLEL_POINTERS_INTEL :: GLenum
gl_COLOR_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F7

gl_COLOR_ARRAY_POINTER :: GLenum
gl_COLOR_ARRAY_POINTER = 0x8090

gl_COLOR_ARRAY_POINTER_EXT :: GLenum
gl_COLOR_ARRAY_POINTER_EXT = 0x8090

gl_COLOR_ARRAY_SIZE :: GLenum
gl_COLOR_ARRAY_SIZE = 0x8081

gl_COLOR_ARRAY_SIZE_EXT :: GLenum
gl_COLOR_ARRAY_SIZE_EXT = 0x8081

gl_COLOR_ARRAY_STRIDE :: GLenum
gl_COLOR_ARRAY_STRIDE = 0x8083

gl_COLOR_ARRAY_STRIDE_EXT :: GLenum
gl_COLOR_ARRAY_STRIDE_EXT = 0x8083

gl_COLOR_ARRAY_TYPE :: GLenum
gl_COLOR_ARRAY_TYPE = 0x8082

gl_COLOR_ARRAY_TYPE_EXT :: GLenum
gl_COLOR_ARRAY_TYPE_EXT = 0x8082

gl_COLOR_ATTACHMENT0 :: GLenum
gl_COLOR_ATTACHMENT0 = 0x8CE0

gl_COLOR_ATTACHMENT0_EXT :: GLenum
gl_COLOR_ATTACHMENT0_EXT = 0x8CE0

gl_COLOR_ATTACHMENT0_NV :: GLenum
gl_COLOR_ATTACHMENT0_NV = 0x8CE0

gl_COLOR_ATTACHMENT0_OES :: GLenum
gl_COLOR_ATTACHMENT0_OES = 0x8CE0

gl_COLOR_ATTACHMENT1 :: GLenum
gl_COLOR_ATTACHMENT1 = 0x8CE1

gl_COLOR_ATTACHMENT10 :: GLenum
gl_COLOR_ATTACHMENT10 = 0x8CEA

gl_COLOR_ATTACHMENT10_EXT :: GLenum
gl_COLOR_ATTACHMENT10_EXT = 0x8CEA

gl_COLOR_ATTACHMENT10_NV :: GLenum
gl_COLOR_ATTACHMENT10_NV = 0x8CEA

gl_COLOR_ATTACHMENT11 :: GLenum
gl_COLOR_ATTACHMENT11 = 0x8CEB

gl_COLOR_ATTACHMENT11_EXT :: GLenum
gl_COLOR_ATTACHMENT11_EXT = 0x8CEB

gl_COLOR_ATTACHMENT11_NV :: GLenum
gl_COLOR_ATTACHMENT11_NV = 0x8CEB

gl_COLOR_ATTACHMENT12 :: GLenum
gl_COLOR_ATTACHMENT12 = 0x8CEC

gl_COLOR_ATTACHMENT12_EXT :: GLenum
gl_COLOR_ATTACHMENT12_EXT = 0x8CEC

gl_COLOR_ATTACHMENT12_NV :: GLenum
gl_COLOR_ATTACHMENT12_NV = 0x8CEC

gl_COLOR_ATTACHMENT13 :: GLenum
gl_COLOR_ATTACHMENT13 = 0x8CED

gl_COLOR_ATTACHMENT13_EXT :: GLenum
gl_COLOR_ATTACHMENT13_EXT = 0x8CED

gl_COLOR_ATTACHMENT13_NV :: GLenum
gl_COLOR_ATTACHMENT13_NV = 0x8CED

gl_COLOR_ATTACHMENT14 :: GLenum
gl_COLOR_ATTACHMENT14 = 0x8CEE

gl_COLOR_ATTACHMENT14_EXT :: GLenum
gl_COLOR_ATTACHMENT14_EXT = 0x8CEE

gl_COLOR_ATTACHMENT14_NV :: GLenum
gl_COLOR_ATTACHMENT14_NV = 0x8CEE

gl_COLOR_ATTACHMENT15 :: GLenum
gl_COLOR_ATTACHMENT15 = 0x8CEF

gl_COLOR_ATTACHMENT15_EXT :: GLenum
gl_COLOR_ATTACHMENT15_EXT = 0x8CEF

gl_COLOR_ATTACHMENT15_NV :: GLenum
gl_COLOR_ATTACHMENT15_NV = 0x8CEF

gl_COLOR_ATTACHMENT1_EXT :: GLenum
gl_COLOR_ATTACHMENT1_EXT = 0x8CE1

gl_COLOR_ATTACHMENT1_NV :: GLenum
gl_COLOR_ATTACHMENT1_NV = 0x8CE1

gl_COLOR_ATTACHMENT2 :: GLenum
gl_COLOR_ATTACHMENT2 = 0x8CE2

gl_COLOR_ATTACHMENT2_EXT :: GLenum
gl_COLOR_ATTACHMENT2_EXT = 0x8CE2

gl_COLOR_ATTACHMENT2_NV :: GLenum
gl_COLOR_ATTACHMENT2_NV = 0x8CE2

gl_COLOR_ATTACHMENT3 :: GLenum
gl_COLOR_ATTACHMENT3 = 0x8CE3

gl_COLOR_ATTACHMENT3_EXT :: GLenum
gl_COLOR_ATTACHMENT3_EXT = 0x8CE3

gl_COLOR_ATTACHMENT3_NV :: GLenum
gl_COLOR_ATTACHMENT3_NV = 0x8CE3

gl_COLOR_ATTACHMENT4 :: GLenum
gl_COLOR_ATTACHMENT4 = 0x8CE4

gl_COLOR_ATTACHMENT4_EXT :: GLenum
gl_COLOR_ATTACHMENT4_EXT = 0x8CE4

gl_COLOR_ATTACHMENT4_NV :: GLenum
gl_COLOR_ATTACHMENT4_NV = 0x8CE4

gl_COLOR_ATTACHMENT5 :: GLenum
gl_COLOR_ATTACHMENT5 = 0x8CE5

gl_COLOR_ATTACHMENT5_EXT :: GLenum
gl_COLOR_ATTACHMENT5_EXT = 0x8CE5

gl_COLOR_ATTACHMENT5_NV :: GLenum
gl_COLOR_ATTACHMENT5_NV = 0x8CE5

gl_COLOR_ATTACHMENT6 :: GLenum
gl_COLOR_ATTACHMENT6 = 0x8CE6

gl_COLOR_ATTACHMENT6_EXT :: GLenum
gl_COLOR_ATTACHMENT6_EXT = 0x8CE6

gl_COLOR_ATTACHMENT6_NV :: GLenum
gl_COLOR_ATTACHMENT6_NV = 0x8CE6

gl_COLOR_ATTACHMENT7 :: GLenum
gl_COLOR_ATTACHMENT7 = 0x8CE7

gl_COLOR_ATTACHMENT7_EXT :: GLenum
gl_COLOR_ATTACHMENT7_EXT = 0x8CE7

gl_COLOR_ATTACHMENT7_NV :: GLenum
gl_COLOR_ATTACHMENT7_NV = 0x8CE7

gl_COLOR_ATTACHMENT8 :: GLenum
gl_COLOR_ATTACHMENT8 = 0x8CE8

gl_COLOR_ATTACHMENT8_EXT :: GLenum
gl_COLOR_ATTACHMENT8_EXT = 0x8CE8

gl_COLOR_ATTACHMENT8_NV :: GLenum
gl_COLOR_ATTACHMENT8_NV = 0x8CE8

gl_COLOR_ATTACHMENT9 :: GLenum
gl_COLOR_ATTACHMENT9 = 0x8CE9

gl_COLOR_ATTACHMENT9_EXT :: GLenum
gl_COLOR_ATTACHMENT9_EXT = 0x8CE9

gl_COLOR_ATTACHMENT9_NV :: GLenum
gl_COLOR_ATTACHMENT9_NV = 0x8CE9

gl_COLOR_ATTACHMENT_EXT :: GLenum
gl_COLOR_ATTACHMENT_EXT = 0x90F0

gl_COLOR_BUFFER_BIT :: GLbitfield
gl_COLOR_BUFFER_BIT = 0x00004000

gl_COLOR_BUFFER_BIT0_QCOM :: GLbitfield
gl_COLOR_BUFFER_BIT0_QCOM = 0x00000001

gl_COLOR_BUFFER_BIT1_QCOM :: GLbitfield
gl_COLOR_BUFFER_BIT1_QCOM = 0x00000002

gl_COLOR_BUFFER_BIT2_QCOM :: GLbitfield
gl_COLOR_BUFFER_BIT2_QCOM = 0x00000004

gl_COLOR_BUFFER_BIT3_QCOM :: GLbitfield
gl_COLOR_BUFFER_BIT3_QCOM = 0x00000008

gl_COLOR_BUFFER_BIT4_QCOM :: GLbitfield
gl_COLOR_BUFFER_BIT4_QCOM = 0x00000010

gl_COLOR_BUFFER_BIT5_QCOM :: GLbitfield
gl_COLOR_BUFFER_BIT5_QCOM = 0x00000020

gl_COLOR_BUFFER_BIT6_QCOM :: GLbitfield
gl_COLOR_BUFFER_BIT6_QCOM = 0x00000040

gl_COLOR_BUFFER_BIT7_QCOM :: GLbitfield
gl_COLOR_BUFFER_BIT7_QCOM = 0x00000080

gl_COLOR_CLEAR_UNCLAMPED_VALUE_ATI :: GLenum
gl_COLOR_CLEAR_UNCLAMPED_VALUE_ATI = 0x8835

gl_COLOR_CLEAR_VALUE :: GLenum
gl_COLOR_CLEAR_VALUE = 0x0C22

gl_COLOR_COMPONENTS :: GLenum
gl_COLOR_COMPONENTS = 0x8283

gl_COLOR_ENCODING :: GLenum
gl_COLOR_ENCODING = 0x8296

gl_COLOR_EXT :: GLenum
gl_COLOR_EXT = 0x1800

gl_COLOR_FLOAT_APPLE :: GLenum
gl_COLOR_FLOAT_APPLE = 0x8A0F

gl_COLOR_INDEX :: GLenum
gl_COLOR_INDEX = 0x1900

gl_COLOR_INDEX12_EXT :: GLenum
gl_COLOR_INDEX12_EXT = 0x80E6

gl_COLOR_INDEX16_EXT :: GLenum
gl_COLOR_INDEX16_EXT = 0x80E7

gl_COLOR_INDEX1_EXT :: GLenum
gl_COLOR_INDEX1_EXT = 0x80E2

gl_COLOR_INDEX2_EXT :: GLenum
gl_COLOR_INDEX2_EXT = 0x80E3

gl_COLOR_INDEX4_EXT :: GLenum
gl_COLOR_INDEX4_EXT = 0x80E4

gl_COLOR_INDEX8_EXT :: GLenum
gl_COLOR_INDEX8_EXT = 0x80E5

gl_COLOR_INDEXES :: GLenum
gl_COLOR_INDEXES = 0x1603

gl_COLOR_LOGIC_OP :: GLenum
gl_COLOR_LOGIC_OP = 0x0BF2

gl_COLOR_MATERIAL :: GLenum
gl_COLOR_MATERIAL = 0x0B57

gl_COLOR_MATERIAL_FACE :: GLenum
gl_COLOR_MATERIAL_FACE = 0x0B55

gl_COLOR_MATERIAL_PARAMETER :: GLenum
gl_COLOR_MATERIAL_PARAMETER = 0x0B56

gl_COLOR_MATRIX :: GLenum
gl_COLOR_MATRIX = 0x80B1

gl_COLOR_MATRIX_SGI :: GLenum
gl_COLOR_MATRIX_SGI = 0x80B1

gl_COLOR_MATRIX_STACK_DEPTH :: GLenum
gl_COLOR_MATRIX_STACK_DEPTH = 0x80B2

gl_COLOR_MATRIX_STACK_DEPTH_SGI :: GLenum
gl_COLOR_MATRIX_STACK_DEPTH_SGI = 0x80B2

gl_COLOR_RENDERABLE :: GLenum
gl_COLOR_RENDERABLE = 0x8286

gl_COLOR_SAMPLES_NV :: GLenum
gl_COLOR_SAMPLES_NV = 0x8E20

gl_COLOR_SUM :: GLenum
gl_COLOR_SUM = 0x8458

gl_COLOR_SUM_ARB :: GLenum
gl_COLOR_SUM_ARB = 0x8458

gl_COLOR_SUM_CLAMP_NV :: GLenum
gl_COLOR_SUM_CLAMP_NV = 0x854F

gl_COLOR_SUM_EXT :: GLenum
gl_COLOR_SUM_EXT = 0x8458

gl_COLOR_TABLE :: GLenum
gl_COLOR_TABLE = 0x80D0

gl_COLOR_TABLE_ALPHA_SIZE :: GLenum
gl_COLOR_TABLE_ALPHA_SIZE = 0x80DD

gl_COLOR_TABLE_ALPHA_SIZE_SGI :: GLenum
gl_COLOR_TABLE_ALPHA_SIZE_SGI = 0x80DD

gl_COLOR_TABLE_BIAS :: GLenum
gl_COLOR_TABLE_BIAS = 0x80D7

gl_COLOR_TABLE_BIAS_SGI :: GLenum
gl_COLOR_TABLE_BIAS_SGI = 0x80D7

gl_COLOR_TABLE_BLUE_SIZE :: GLenum
gl_COLOR_TABLE_BLUE_SIZE = 0x80DC

gl_COLOR_TABLE_BLUE_SIZE_SGI :: GLenum
gl_COLOR_TABLE_BLUE_SIZE_SGI = 0x80DC

gl_COLOR_TABLE_FORMAT :: GLenum
gl_COLOR_TABLE_FORMAT = 0x80D8

gl_COLOR_TABLE_FORMAT_SGI :: GLenum
gl_COLOR_TABLE_FORMAT_SGI = 0x80D8

gl_COLOR_TABLE_GREEN_SIZE :: GLenum
gl_COLOR_TABLE_GREEN_SIZE = 0x80DB

gl_COLOR_TABLE_GREEN_SIZE_SGI :: GLenum
gl_COLOR_TABLE_GREEN_SIZE_SGI = 0x80DB

gl_COLOR_TABLE_INTENSITY_SIZE :: GLenum
gl_COLOR_TABLE_INTENSITY_SIZE = 0x80DF

gl_COLOR_TABLE_INTENSITY_SIZE_SGI :: GLenum
gl_COLOR_TABLE_INTENSITY_SIZE_SGI = 0x80DF

gl_COLOR_TABLE_LUMINANCE_SIZE :: GLenum
gl_COLOR_TABLE_LUMINANCE_SIZE = 0x80DE

gl_COLOR_TABLE_LUMINANCE_SIZE_SGI :: GLenum
gl_COLOR_TABLE_LUMINANCE_SIZE_SGI = 0x80DE

gl_COLOR_TABLE_RED_SIZE :: GLenum
gl_COLOR_TABLE_RED_SIZE = 0x80DA

gl_COLOR_TABLE_RED_SIZE_SGI :: GLenum
gl_COLOR_TABLE_RED_SIZE_SGI = 0x80DA

gl_COLOR_TABLE_SCALE :: GLenum
gl_COLOR_TABLE_SCALE = 0x80D6

gl_COLOR_TABLE_SCALE_SGI :: GLenum
gl_COLOR_TABLE_SCALE_SGI = 0x80D6

gl_COLOR_TABLE_SGI :: GLenum
gl_COLOR_TABLE_SGI = 0x80D0

gl_COLOR_TABLE_WIDTH :: GLenum
gl_COLOR_TABLE_WIDTH = 0x80D9

gl_COLOR_TABLE_WIDTH_SGI :: GLenum
gl_COLOR_TABLE_WIDTH_SGI = 0x80D9

gl_COLOR_WRITEMASK :: GLenum
gl_COLOR_WRITEMASK = 0x0C23

gl_COMBINE :: GLenum
gl_COMBINE = 0x8570

gl_COMBINE4_NV :: GLenum
gl_COMBINE4_NV = 0x8503

gl_COMBINER0_NV :: GLenum
gl_COMBINER0_NV = 0x8550

gl_COMBINER1_NV :: GLenum
gl_COMBINER1_NV = 0x8551

gl_COMBINER2_NV :: GLenum
gl_COMBINER2_NV = 0x8552

gl_COMBINER3_NV :: GLenum
gl_COMBINER3_NV = 0x8553

gl_COMBINER4_NV :: GLenum
gl_COMBINER4_NV = 0x8554

gl_COMBINER5_NV :: GLenum
gl_COMBINER5_NV = 0x8555

gl_COMBINER6_NV :: GLenum
gl_COMBINER6_NV = 0x8556

gl_COMBINER7_NV :: GLenum
gl_COMBINER7_NV = 0x8557

gl_COMBINER_AB_DOT_PRODUCT_NV :: GLenum
gl_COMBINER_AB_DOT_PRODUCT_NV = 0x8545

gl_COMBINER_AB_OUTPUT_NV :: GLenum
gl_COMBINER_AB_OUTPUT_NV = 0x854A

gl_COMBINER_BIAS_NV :: GLenum
gl_COMBINER_BIAS_NV = 0x8549

gl_COMBINER_CD_DOT_PRODUCT_NV :: GLenum
gl_COMBINER_CD_DOT_PRODUCT_NV = 0x8546

gl_COMBINER_CD_OUTPUT_NV :: GLenum
gl_COMBINER_CD_OUTPUT_NV = 0x854B

gl_COMBINER_COMPONENT_USAGE_NV :: GLenum
gl_COMBINER_COMPONENT_USAGE_NV = 0x8544

gl_COMBINER_INPUT_NV :: GLenum
gl_COMBINER_INPUT_NV = 0x8542

gl_COMBINER_MAPPING_NV :: GLenum
gl_COMBINER_MAPPING_NV = 0x8543

gl_COMBINER_MUX_SUM_NV :: GLenum
gl_COMBINER_MUX_SUM_NV = 0x8547

gl_COMBINER_SCALE_NV :: GLenum
gl_COMBINER_SCALE_NV = 0x8548

gl_COMBINER_SUM_OUTPUT_NV :: GLenum
gl_COMBINER_SUM_OUTPUT_NV = 0x854C

gl_COMBINE_ALPHA :: GLenum
gl_COMBINE_ALPHA = 0x8572

gl_COMBINE_ALPHA_ARB :: GLenum
gl_COMBINE_ALPHA_ARB = 0x8572

gl_COMBINE_ALPHA_EXT :: GLenum
gl_COMBINE_ALPHA_EXT = 0x8572

gl_COMBINE_ARB :: GLenum
gl_COMBINE_ARB = 0x8570

gl_COMBINE_EXT :: GLenum
gl_COMBINE_EXT = 0x8570

gl_COMBINE_RGB :: GLenum
gl_COMBINE_RGB = 0x8571

gl_COMBINE_RGB_ARB :: GLenum
gl_COMBINE_RGB_ARB = 0x8571

gl_COMBINE_RGB_EXT :: GLenum
gl_COMBINE_RGB_EXT = 0x8571

gl_COMMAND_BARRIER_BIT :: GLbitfield
gl_COMMAND_BARRIER_BIT = 0x00000040

gl_COMMAND_BARRIER_BIT_EXT :: GLbitfield
gl_COMMAND_BARRIER_BIT_EXT = 0x00000040

gl_COMPARE_REF_DEPTH_TO_TEXTURE_EXT :: GLenum
gl_COMPARE_REF_DEPTH_TO_TEXTURE_EXT = 0x884E

gl_COMPARE_REF_TO_TEXTURE :: GLenum
gl_COMPARE_REF_TO_TEXTURE = 0x884E

gl_COMPARE_REF_TO_TEXTURE_EXT :: GLenum
gl_COMPARE_REF_TO_TEXTURE_EXT = 0x884E

gl_COMPARE_R_TO_TEXTURE :: GLenum
gl_COMPARE_R_TO_TEXTURE = 0x884E

gl_COMPARE_R_TO_TEXTURE_ARB :: GLenum
gl_COMPARE_R_TO_TEXTURE_ARB = 0x884E

gl_COMPATIBLE_SUBROUTINES :: GLenum
gl_COMPATIBLE_SUBROUTINES = 0x8E4B

gl_COMPILE :: GLenum
gl_COMPILE = 0x1300

gl_COMPILE_AND_EXECUTE :: GLenum
gl_COMPILE_AND_EXECUTE = 0x1301

gl_COMPILE_STATUS :: GLenum
gl_COMPILE_STATUS = 0x8B81

gl_COMPRESSED_ALPHA :: GLenum
gl_COMPRESSED_ALPHA = 0x84E9

gl_COMPRESSED_ALPHA_ARB :: GLenum
gl_COMPRESSED_ALPHA_ARB = 0x84E9

gl_COMPRESSED_INTENSITY :: GLenum
gl_COMPRESSED_INTENSITY = 0x84EC

gl_COMPRESSED_INTENSITY_ARB :: GLenum
gl_COMPRESSED_INTENSITY_ARB = 0x84EC

gl_COMPRESSED_LUMINANCE :: GLenum
gl_COMPRESSED_LUMINANCE = 0x84EA

gl_COMPRESSED_LUMINANCE_ALPHA :: GLenum
gl_COMPRESSED_LUMINANCE_ALPHA = 0x84EB

gl_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI :: GLenum
gl_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI = 0x8837

gl_COMPRESSED_LUMINANCE_ALPHA_ARB :: GLenum
gl_COMPRESSED_LUMINANCE_ALPHA_ARB = 0x84EB

gl_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT :: GLenum
gl_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C72

gl_COMPRESSED_LUMINANCE_ARB :: GLenum
gl_COMPRESSED_LUMINANCE_ARB = 0x84EA

gl_COMPRESSED_LUMINANCE_LATC1_EXT :: GLenum
gl_COMPRESSED_LUMINANCE_LATC1_EXT = 0x8C70

gl_COMPRESSED_R11_EAC :: GLenum
gl_COMPRESSED_R11_EAC = 0x9270

gl_COMPRESSED_R11_EAC_OES :: GLenum
gl_COMPRESSED_R11_EAC_OES = 0x9270

gl_COMPRESSED_RED :: GLenum
gl_COMPRESSED_RED = 0x8225

gl_COMPRESSED_RED_GREEN_RGTC2_EXT :: GLenum
gl_COMPRESSED_RED_GREEN_RGTC2_EXT = 0x8DBD

gl_COMPRESSED_RED_RGTC1 :: GLenum
gl_COMPRESSED_RED_RGTC1 = 0x8DBB

gl_COMPRESSED_RED_RGTC1_EXT :: GLenum
gl_COMPRESSED_RED_RGTC1_EXT = 0x8DBB

gl_COMPRESSED_RG :: GLenum
gl_COMPRESSED_RG = 0x8226

gl_COMPRESSED_RG11_EAC :: GLenum
gl_COMPRESSED_RG11_EAC = 0x9272

gl_COMPRESSED_RG11_EAC_OES :: GLenum
gl_COMPRESSED_RG11_EAC_OES = 0x9272

gl_COMPRESSED_RGB :: GLenum
gl_COMPRESSED_RGB = 0x84ED

gl_COMPRESSED_RGB8_ETC2 :: GLenum
gl_COMPRESSED_RGB8_ETC2 = 0x9274

gl_COMPRESSED_RGB8_ETC2_OES :: GLenum
gl_COMPRESSED_RGB8_ETC2_OES = 0x9274

gl_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 :: GLenum
gl_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276

gl_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES :: GLenum
gl_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES = 0x9276

gl_COMPRESSED_RGBA :: GLenum
gl_COMPRESSED_RGBA = 0x84EE

gl_COMPRESSED_RGBA8_ETC2_EAC :: GLenum
gl_COMPRESSED_RGBA8_ETC2_EAC = 0x9278

gl_COMPRESSED_RGBA8_ETC2_EAC_OES :: GLenum
gl_COMPRESSED_RGBA8_ETC2_EAC_OES = 0x9278

gl_COMPRESSED_RGBA_ARB :: GLenum
gl_COMPRESSED_RGBA_ARB = 0x84EE

gl_COMPRESSED_RGBA_ASTC_10x10_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_10x10_KHR = 0x93BB

gl_COMPRESSED_RGBA_ASTC_10x5_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_10x5_KHR = 0x93B8

gl_COMPRESSED_RGBA_ASTC_10x6_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_10x6_KHR = 0x93B9

gl_COMPRESSED_RGBA_ASTC_10x8_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_10x8_KHR = 0x93BA

gl_COMPRESSED_RGBA_ASTC_12x10_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_12x10_KHR = 0x93BC

gl_COMPRESSED_RGBA_ASTC_12x12_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_12x12_KHR = 0x93BD

gl_COMPRESSED_RGBA_ASTC_3x3x3_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_3x3x3_OES = 0x93C0

gl_COMPRESSED_RGBA_ASTC_4x3x3_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_4x3x3_OES = 0x93C1

gl_COMPRESSED_RGBA_ASTC_4x4_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_4x4_KHR = 0x93B0

gl_COMPRESSED_RGBA_ASTC_4x4x3_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_4x4x3_OES = 0x93C2

gl_COMPRESSED_RGBA_ASTC_4x4x4_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_4x4x4_OES = 0x93C3

gl_COMPRESSED_RGBA_ASTC_5x4_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_5x4_KHR = 0x93B1

gl_COMPRESSED_RGBA_ASTC_5x4x4_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_5x4x4_OES = 0x93C4

gl_COMPRESSED_RGBA_ASTC_5x5_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_5x5_KHR = 0x93B2

gl_COMPRESSED_RGBA_ASTC_5x5x4_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_5x5x4_OES = 0x93C5

gl_COMPRESSED_RGBA_ASTC_5x5x5_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_5x5x5_OES = 0x93C6

gl_COMPRESSED_RGBA_ASTC_6x5_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_6x5_KHR = 0x93B3

gl_COMPRESSED_RGBA_ASTC_6x5x5_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_6x5x5_OES = 0x93C7

gl_COMPRESSED_RGBA_ASTC_6x6_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_6x6_KHR = 0x93B4

gl_COMPRESSED_RGBA_ASTC_6x6x5_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_6x6x5_OES = 0x93C8

gl_COMPRESSED_RGBA_ASTC_6x6x6_OES :: GLenum
gl_COMPRESSED_RGBA_ASTC_6x6x6_OES = 0x93C9

gl_COMPRESSED_RGBA_ASTC_8x5_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_8x5_KHR = 0x93B5

gl_COMPRESSED_RGBA_ASTC_8x6_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_8x6_KHR = 0x93B6

gl_COMPRESSED_RGBA_ASTC_8x8_KHR :: GLenum
gl_COMPRESSED_RGBA_ASTC_8x8_KHR = 0x93B7

gl_COMPRESSED_RGBA_BPTC_UNORM :: GLenum
gl_COMPRESSED_RGBA_BPTC_UNORM = 0x8E8C

gl_COMPRESSED_RGBA_BPTC_UNORM_ARB :: GLenum
gl_COMPRESSED_RGBA_BPTC_UNORM_ARB = 0x8E8C

gl_COMPRESSED_RGBA_FXT1_3DFX :: GLenum
gl_COMPRESSED_RGBA_FXT1_3DFX = 0x86B1

gl_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG :: GLenum
gl_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 0x8C03

gl_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG :: GLenum
gl_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG = 0x9137

gl_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG :: GLenum
gl_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 0x8C02

gl_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG :: GLenum
gl_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG = 0x9138

gl_COMPRESSED_RGBA_S3TC_DXT1_EXT :: GLenum
gl_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1

gl_COMPRESSED_RGBA_S3TC_DXT3_ANGLE :: GLenum
gl_COMPRESSED_RGBA_S3TC_DXT3_ANGLE = 0x83F2

gl_COMPRESSED_RGBA_S3TC_DXT3_EXT :: GLenum
gl_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2

gl_COMPRESSED_RGBA_S3TC_DXT5_ANGLE :: GLenum
gl_COMPRESSED_RGBA_S3TC_DXT5_ANGLE = 0x83F3

gl_COMPRESSED_RGBA_S3TC_DXT5_EXT :: GLenum
gl_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3

gl_COMPRESSED_RGB_ARB :: GLenum
gl_COMPRESSED_RGB_ARB = 0x84ED

gl_COMPRESSED_RGB_BPTC_SIGNED_FLOAT :: GLenum
gl_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = 0x8E8E

gl_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB :: GLenum
gl_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = 0x8E8E

gl_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT :: GLenum
gl_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = 0x8E8F

gl_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB :: GLenum
gl_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = 0x8E8F

gl_COMPRESSED_RGB_FXT1_3DFX :: GLenum
gl_COMPRESSED_RGB_FXT1_3DFX = 0x86B0

gl_COMPRESSED_RGB_PVRTC_2BPPV1_IMG :: GLenum
gl_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 0x8C01

gl_COMPRESSED_RGB_PVRTC_4BPPV1_IMG :: GLenum
gl_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 0x8C00

gl_COMPRESSED_RGB_S3TC_DXT1_EXT :: GLenum
gl_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0

gl_COMPRESSED_RG_RGTC2 :: GLenum
gl_COMPRESSED_RG_RGTC2 = 0x8DBD

gl_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT :: GLenum
gl_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C73

gl_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT :: GLenum
gl_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT = 0x8C71

gl_COMPRESSED_SIGNED_R11_EAC :: GLenum
gl_COMPRESSED_SIGNED_R11_EAC = 0x9271

gl_COMPRESSED_SIGNED_R11_EAC_OES :: GLenum
gl_COMPRESSED_SIGNED_R11_EAC_OES = 0x9271

gl_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT :: GLenum
gl_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = 0x8DBE

gl_COMPRESSED_SIGNED_RED_RGTC1 :: GLenum
gl_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC

gl_COMPRESSED_SIGNED_RED_RGTC1_EXT :: GLenum
gl_COMPRESSED_SIGNED_RED_RGTC1_EXT = 0x8DBC

gl_COMPRESSED_SIGNED_RG11_EAC :: GLenum
gl_COMPRESSED_SIGNED_RG11_EAC = 0x9273

gl_COMPRESSED_SIGNED_RG11_EAC_OES :: GLenum
gl_COMPRESSED_SIGNED_RG11_EAC_OES = 0x9273

gl_COMPRESSED_SIGNED_RG_RGTC2 :: GLenum
gl_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE

gl_COMPRESSED_SLUMINANCE :: GLenum
gl_COMPRESSED_SLUMINANCE = 0x8C4A

gl_COMPRESSED_SLUMINANCE_ALPHA :: GLenum
gl_COMPRESSED_SLUMINANCE_ALPHA = 0x8C4B

gl_COMPRESSED_SLUMINANCE_ALPHA_EXT :: GLenum
gl_COMPRESSED_SLUMINANCE_ALPHA_EXT = 0x8C4B

gl_COMPRESSED_SLUMINANCE_EXT :: GLenum
gl_COMPRESSED_SLUMINANCE_EXT = 0x8C4A

gl_COMPRESSED_SRGB :: GLenum
gl_COMPRESSED_SRGB = 0x8C48

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = 0x93DB

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = 0x93D8

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = 0x93D9

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = 0x93DA

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = 0x93DC

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = 0x93DD

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES = 0x93E0

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES = 0x93E1

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = 0x93D0

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES = 0x93E2

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES = 0x93E3

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = 0x93D1

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES = 0x93E4

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = 0x93D2

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES = 0x93E5

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES = 0x93E6

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = 0x93D3

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES = 0x93E7

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = 0x93D4

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES = 0x93E8

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES = 0x93E9

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = 0x93D5

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = 0x93D6

gl_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = 0x93D7

gl_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279

gl_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC_OES :: GLenum
gl_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC_OES = 0x9279

gl_COMPRESSED_SRGB8_ETC2 :: GLenum
gl_COMPRESSED_SRGB8_ETC2 = 0x9275

gl_COMPRESSED_SRGB8_ETC2_OES :: GLenum
gl_COMPRESSED_SRGB8_ETC2_OES = 0x9275

gl_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 :: GLenum
gl_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277

gl_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES :: GLenum
gl_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES = 0x9277

gl_COMPRESSED_SRGB_ALPHA :: GLenum
gl_COMPRESSED_SRGB_ALPHA = 0x8C49

gl_COMPRESSED_SRGB_ALPHA_BPTC_UNORM :: GLenum
gl_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = 0x8E8D

gl_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB :: GLenum
gl_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = 0x8E8D

gl_COMPRESSED_SRGB_ALPHA_EXT :: GLenum
gl_COMPRESSED_SRGB_ALPHA_EXT = 0x8C49

gl_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT :: GLenum
gl_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT = 0x8A56

gl_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG :: GLenum
gl_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG = 0x93F0

gl_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT :: GLenum
gl_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT = 0x8A57

gl_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG :: GLenum
gl_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG = 0x93F1

gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT :: GLenum
gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = 0x8C4D

gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV :: GLenum
gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV = 0x8C4D

gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT :: GLenum
gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = 0x8C4E

gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV :: GLenum
gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV = 0x8C4E

gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT :: GLenum
gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = 0x8C4F

gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV :: GLenum
gl_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV = 0x8C4F

gl_COMPRESSED_SRGB_EXT :: GLenum
gl_COMPRESSED_SRGB_EXT = 0x8C48

gl_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT :: GLenum
gl_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT = 0x8A54

gl_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT :: GLenum
gl_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT = 0x8A55

gl_COMPRESSED_SRGB_S3TC_DXT1_EXT :: GLenum
gl_COMPRESSED_SRGB_S3TC_DXT1_EXT = 0x8C4C

gl_COMPRESSED_SRGB_S3TC_DXT1_NV :: GLenum
gl_COMPRESSED_SRGB_S3TC_DXT1_NV = 0x8C4C

gl_COMPRESSED_TEXTURE_FORMATS :: GLenum
gl_COMPRESSED_TEXTURE_FORMATS = 0x86A3

gl_COMPRESSED_TEXTURE_FORMATS_ARB :: GLenum
gl_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A3

gl_COMPUTE_PROGRAM_NV :: GLenum
gl_COMPUTE_PROGRAM_NV = 0x90FB

gl_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV :: GLenum
gl_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV = 0x90FC

gl_COMPUTE_SHADER :: GLenum
gl_COMPUTE_SHADER = 0x91B9

gl_COMPUTE_SHADER_BIT :: GLbitfield
gl_COMPUTE_SHADER_BIT = 0x00000020

gl_COMPUTE_SHADER_INVOCATIONS_ARB :: GLenum
gl_COMPUTE_SHADER_INVOCATIONS_ARB = 0x82F5

gl_COMPUTE_SUBROUTINE :: GLenum
gl_COMPUTE_SUBROUTINE = 0x92ED

gl_COMPUTE_SUBROUTINE_UNIFORM :: GLenum
gl_COMPUTE_SUBROUTINE_UNIFORM = 0x92F3

gl_COMPUTE_TEXTURE :: GLenum
gl_COMPUTE_TEXTURE = 0x82A0

gl_COMPUTE_WORK_GROUP_SIZE :: GLenum
gl_COMPUTE_WORK_GROUP_SIZE = 0x8267

gl_COMP_BIT_ATI :: GLbitfield
gl_COMP_BIT_ATI = 0x00000002

gl_CONDITION_SATISFIED :: GLenum
gl_CONDITION_SATISFIED = 0x911C

gl_CONDITION_SATISFIED_APPLE :: GLenum
gl_CONDITION_SATISFIED_APPLE = 0x911C

gl_CONFORMANT_NV :: GLenum
gl_CONFORMANT_NV = 0x9374

gl_CONIC_CURVE_TO_NV :: GLubyte
gl_CONIC_CURVE_TO_NV = 0x1A

gl_CONJOINT_NV :: GLenum
gl_CONJOINT_NV = 0x9284

gl_CONSERVATIVE_RASTERIZATION_NV :: GLenum
gl_CONSERVATIVE_RASTERIZATION_NV = 0x9346

gl_CONSERVE_MEMORY_HINT_PGI :: GLenum
gl_CONSERVE_MEMORY_HINT_PGI = 0x1A1FD

gl_CONSTANT :: GLenum
gl_CONSTANT = 0x8576

gl_CONSTANT_ALPHA :: GLenum
gl_CONSTANT_ALPHA = 0x8003

gl_CONSTANT_ALPHA_EXT :: GLenum
gl_CONSTANT_ALPHA_EXT = 0x8003

gl_CONSTANT_ARB :: GLenum
gl_CONSTANT_ARB = 0x8576

gl_CONSTANT_ATTENUATION :: GLenum
gl_CONSTANT_ATTENUATION = 0x1207

gl_CONSTANT_BORDER :: GLenum
gl_CONSTANT_BORDER = 0x8151

gl_CONSTANT_BORDER_HP :: GLenum
gl_CONSTANT_BORDER_HP = 0x8151

gl_CONSTANT_COLOR :: GLenum
gl_CONSTANT_COLOR = 0x8001

gl_CONSTANT_COLOR0_NV :: GLenum
gl_CONSTANT_COLOR0_NV = 0x852A

gl_CONSTANT_COLOR1_NV :: GLenum
gl_CONSTANT_COLOR1_NV = 0x852B

gl_CONSTANT_COLOR_EXT :: GLenum
gl_CONSTANT_COLOR_EXT = 0x8001

gl_CONSTANT_EXT :: GLenum
gl_CONSTANT_EXT = 0x8576

gl_CONSTANT_NV :: GLenum
gl_CONSTANT_NV = 0x8576

gl_CONST_EYE_NV :: GLenum
gl_CONST_EYE_NV = 0x86E5

gl_CONTEXT_COMPATIBILITY_PROFILE_BIT :: GLbitfield
gl_CONTEXT_COMPATIBILITY_PROFILE_BIT = 0x00000002

gl_CONTEXT_CORE_PROFILE_BIT :: GLbitfield
gl_CONTEXT_CORE_PROFILE_BIT = 0x00000001

gl_CONTEXT_FLAGS :: GLenum
gl_CONTEXT_FLAGS = 0x821E

gl_CONTEXT_FLAG_DEBUG_BIT :: GLbitfield
gl_CONTEXT_FLAG_DEBUG_BIT = 0x00000002

gl_CONTEXT_FLAG_DEBUG_BIT_KHR :: GLbitfield
gl_CONTEXT_FLAG_DEBUG_BIT_KHR = 0x00000002

gl_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT :: GLbitfield
gl_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x00000001

gl_CONTEXT_FLAG_ROBUST_ACCESS_BIT :: GLbitfield
gl_CONTEXT_FLAG_ROBUST_ACCESS_BIT = 0x00000004

gl_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB :: GLbitfield
gl_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 0x00000004

gl_CONTEXT_LOST :: GLenum
gl_CONTEXT_LOST = 0x0507

gl_CONTEXT_LOST_KHR :: GLenum
gl_CONTEXT_LOST_KHR = 0x0507

gl_CONTEXT_LOST_WEBGL :: GLenum
gl_CONTEXT_LOST_WEBGL = 0x9242

gl_CONTEXT_PROFILE_MASK :: GLenum
gl_CONTEXT_PROFILE_MASK = 0x9126

gl_CONTEXT_RELEASE_BEHAVIOR :: GLenum
gl_CONTEXT_RELEASE_BEHAVIOR = 0x82FB

gl_CONTEXT_RELEASE_BEHAVIOR_FLUSH :: GLenum
gl_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 0x82FC

gl_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR :: GLenum
gl_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR = 0x82FC

gl_CONTEXT_RELEASE_BEHAVIOR_KHR :: GLenum
gl_CONTEXT_RELEASE_BEHAVIOR_KHR = 0x82FB

gl_CONTEXT_ROBUST_ACCESS :: GLenum
gl_CONTEXT_ROBUST_ACCESS = 0x90F3

gl_CONTEXT_ROBUST_ACCESS_EXT :: GLenum
gl_CONTEXT_ROBUST_ACCESS_EXT = 0x90F3

gl_CONTEXT_ROBUST_ACCESS_KHR :: GLenum
gl_CONTEXT_ROBUST_ACCESS_KHR = 0x90F3

gl_CONTINUOUS_AMD :: GLenum
gl_CONTINUOUS_AMD = 0x9007

gl_CONTRAST_NV :: GLenum
gl_CONTRAST_NV = 0x92A1

gl_CONVEX_HULL_NV :: GLenum
gl_CONVEX_HULL_NV = 0x908B

gl_CONVOLUTION_1D :: GLenum
gl_CONVOLUTION_1D = 0x8010

gl_CONVOLUTION_1D_EXT :: GLenum
gl_CONVOLUTION_1D_EXT = 0x8010

gl_CONVOLUTION_2D :: GLenum
gl_CONVOLUTION_2D = 0x8011

gl_CONVOLUTION_2D_EXT :: GLenum
gl_CONVOLUTION_2D_EXT = 0x8011

gl_CONVOLUTION_BORDER_COLOR :: GLenum
gl_CONVOLUTION_BORDER_COLOR = 0x8154

gl_CONVOLUTION_BORDER_COLOR_HP :: GLenum
gl_CONVOLUTION_BORDER_COLOR_HP = 0x8154

gl_CONVOLUTION_BORDER_MODE :: GLenum
gl_CONVOLUTION_BORDER_MODE = 0x8013

gl_CONVOLUTION_BORDER_MODE_EXT :: GLenum
gl_CONVOLUTION_BORDER_MODE_EXT = 0x8013

gl_CONVOLUTION_FILTER_BIAS :: GLenum
gl_CONVOLUTION_FILTER_BIAS = 0x8015

gl_CONVOLUTION_FILTER_BIAS_EXT :: GLenum
gl_CONVOLUTION_FILTER_BIAS_EXT = 0x8015

gl_CONVOLUTION_FILTER_SCALE :: GLenum
gl_CONVOLUTION_FILTER_SCALE = 0x8014

gl_CONVOLUTION_FILTER_SCALE_EXT :: GLenum
gl_CONVOLUTION_FILTER_SCALE_EXT = 0x8014

gl_CONVOLUTION_FORMAT :: GLenum
gl_CONVOLUTION_FORMAT = 0x8017

gl_CONVOLUTION_FORMAT_EXT :: GLenum
gl_CONVOLUTION_FORMAT_EXT = 0x8017

gl_CONVOLUTION_HEIGHT :: GLenum
gl_CONVOLUTION_HEIGHT = 0x8019

gl_CONVOLUTION_HEIGHT_EXT :: GLenum
gl_CONVOLUTION_HEIGHT_EXT = 0x8019

gl_CONVOLUTION_HINT_SGIX :: GLenum
gl_CONVOLUTION_HINT_SGIX = 0x8316

gl_CONVOLUTION_WIDTH :: GLenum
gl_CONVOLUTION_WIDTH = 0x8018

gl_CONVOLUTION_WIDTH_EXT :: GLenum
gl_CONVOLUTION_WIDTH_EXT = 0x8018

gl_CON_0_ATI :: GLenum
gl_CON_0_ATI = 0x8941

gl_CON_10_ATI :: GLenum
gl_CON_10_ATI = 0x894B

gl_CON_11_ATI :: GLenum
gl_CON_11_ATI = 0x894C

gl_CON_12_ATI :: GLenum
gl_CON_12_ATI = 0x894D

gl_CON_13_ATI :: GLenum
gl_CON_13_ATI = 0x894E

gl_CON_14_ATI :: GLenum
gl_CON_14_ATI = 0x894F

gl_CON_15_ATI :: GLenum
gl_CON_15_ATI = 0x8950

gl_CON_16_ATI :: GLenum
gl_CON_16_ATI = 0x8951

gl_CON_17_ATI :: GLenum
gl_CON_17_ATI = 0x8952

gl_CON_18_ATI :: GLenum
gl_CON_18_ATI = 0x8953

gl_CON_19_ATI :: GLenum
gl_CON_19_ATI = 0x8954

gl_CON_1_ATI :: GLenum
gl_CON_1_ATI = 0x8942

gl_CON_20_ATI :: GLenum
gl_CON_20_ATI = 0x8955

gl_CON_21_ATI :: GLenum
gl_CON_21_ATI = 0x8956

gl_CON_22_ATI :: GLenum
gl_CON_22_ATI = 0x8957

gl_CON_23_ATI :: GLenum
gl_CON_23_ATI = 0x8958

gl_CON_24_ATI :: GLenum
gl_CON_24_ATI = 0x8959

gl_CON_25_ATI :: GLenum
gl_CON_25_ATI = 0x895A

gl_CON_26_ATI :: GLenum
gl_CON_26_ATI = 0x895B

gl_CON_27_ATI :: GLenum
gl_CON_27_ATI = 0x895C

gl_CON_28_ATI :: GLenum
gl_CON_28_ATI = 0x895D

gl_CON_29_ATI :: GLenum
gl_CON_29_ATI = 0x895E

gl_CON_2_ATI :: GLenum
gl_CON_2_ATI = 0x8943

gl_CON_30_ATI :: GLenum
gl_CON_30_ATI = 0x895F

gl_CON_31_ATI :: GLenum
gl_CON_31_ATI = 0x8960

gl_CON_3_ATI :: GLenum
gl_CON_3_ATI = 0x8944

gl_CON_4_ATI :: GLenum
gl_CON_4_ATI = 0x8945

gl_CON_5_ATI :: GLenum
gl_CON_5_ATI = 0x8946

gl_CON_6_ATI :: GLenum
gl_CON_6_ATI = 0x8947

gl_CON_7_ATI :: GLenum
gl_CON_7_ATI = 0x8948

gl_CON_8_ATI :: GLenum
gl_CON_8_ATI = 0x8949

gl_CON_9_ATI :: GLenum
gl_CON_9_ATI = 0x894A

gl_COORD_REPLACE :: GLenum
gl_COORD_REPLACE = 0x8862

gl_COORD_REPLACE_ARB :: GLenum
gl_COORD_REPLACE_ARB = 0x8862

gl_COORD_REPLACE_NV :: GLenum
gl_COORD_REPLACE_NV = 0x8862

gl_COORD_REPLACE_OES :: GLenum
gl_COORD_REPLACE_OES = 0x8862

gl_COPY :: GLenum
gl_COPY = 0x1503

gl_COPY_INVERTED :: GLenum
gl_COPY_INVERTED = 0x150C

gl_COPY_PIXEL_TOKEN :: GLenum
gl_COPY_PIXEL_TOKEN = 0x0706

gl_COPY_READ_BUFFER :: GLenum
gl_COPY_READ_BUFFER = 0x8F36

gl_COPY_READ_BUFFER_BINDING :: GLenum
gl_COPY_READ_BUFFER_BINDING = 0x8F36

gl_COPY_READ_BUFFER_NV :: GLenum
gl_COPY_READ_BUFFER_NV = 0x8F36

gl_COPY_WRITE_BUFFER :: GLenum
gl_COPY_WRITE_BUFFER = 0x8F37

gl_COPY_WRITE_BUFFER_BINDING :: GLenum
gl_COPY_WRITE_BUFFER_BINDING = 0x8F37

gl_COPY_WRITE_BUFFER_NV :: GLenum
gl_COPY_WRITE_BUFFER_NV = 0x8F37

gl_COUNTER_RANGE_AMD :: GLenum
gl_COUNTER_RANGE_AMD = 0x8BC1

gl_COUNTER_TYPE_AMD :: GLenum
gl_COUNTER_TYPE_AMD = 0x8BC0

gl_COUNT_DOWN_NV :: GLenum
gl_COUNT_DOWN_NV = 0x9089

gl_COUNT_UP_NV :: GLenum
gl_COUNT_UP_NV = 0x9088

gl_COVERAGE_ALL_FRAGMENTS_NV :: GLenum
gl_COVERAGE_ALL_FRAGMENTS_NV = 0x8ED5

gl_COVERAGE_ATTACHMENT_NV :: GLenum
gl_COVERAGE_ATTACHMENT_NV = 0x8ED2

gl_COVERAGE_AUTOMATIC_NV :: GLenum
gl_COVERAGE_AUTOMATIC_NV = 0x8ED7

gl_COVERAGE_BUFFERS_NV :: GLenum
gl_COVERAGE_BUFFERS_NV = 0x8ED3

gl_COVERAGE_BUFFER_BIT_NV :: GLbitfield
gl_COVERAGE_BUFFER_BIT_NV = 0x00008000

gl_COVERAGE_COMPONENT4_NV :: GLenum
gl_COVERAGE_COMPONENT4_NV = 0x8ED1

gl_COVERAGE_COMPONENT_NV :: GLenum
gl_COVERAGE_COMPONENT_NV = 0x8ED0

gl_COVERAGE_EDGE_FRAGMENTS_NV :: GLenum
gl_COVERAGE_EDGE_FRAGMENTS_NV = 0x8ED6

gl_COVERAGE_MODULATION_NV :: GLenum
gl_COVERAGE_MODULATION_NV = 0x9332

gl_COVERAGE_MODULATION_TABLE_NV :: GLenum
gl_COVERAGE_MODULATION_TABLE_NV = 0x9331

gl_COVERAGE_MODULATION_TABLE_SIZE_NV :: GLenum
gl_COVERAGE_MODULATION_TABLE_SIZE_NV = 0x9333

gl_COVERAGE_SAMPLES_NV :: GLenum
gl_COVERAGE_SAMPLES_NV = 0x8ED4

gl_CPU_OPTIMIZED_QCOM :: GLenum
gl_CPU_OPTIMIZED_QCOM = 0x8FB1

gl_CUBIC_CURVE_TO_NV :: GLubyte
gl_CUBIC_CURVE_TO_NV = 0x0C

gl_CUBIC_EXT :: GLenum
gl_CUBIC_EXT = 0x8334

gl_CUBIC_HP :: GLenum
gl_CUBIC_HP = 0x815F

gl_CULL_FACE :: GLenum
gl_CULL_FACE = 0x0B44

gl_CULL_FACE_MODE :: GLenum
gl_CULL_FACE_MODE = 0x0B45

gl_CULL_FRAGMENT_NV :: GLenum
gl_CULL_FRAGMENT_NV = 0x86E7

gl_CULL_MODES_NV :: GLenum
gl_CULL_MODES_NV = 0x86E0

gl_CULL_VERTEX_EXT :: GLenum
gl_CULL_VERTEX_EXT = 0x81AA

gl_CULL_VERTEX_EYE_POSITION_EXT :: GLenum
gl_CULL_VERTEX_EYE_POSITION_EXT = 0x81AB

gl_CULL_VERTEX_IBM :: GLenum
gl_CULL_VERTEX_IBM = 103050

gl_CULL_VERTEX_OBJECT_POSITION_EXT :: GLenum
gl_CULL_VERTEX_OBJECT_POSITION_EXT = 0x81AC

gl_CURRENT_ATTRIB_NV :: GLenum
gl_CURRENT_ATTRIB_NV = 0x8626

gl_CURRENT_BINORMAL_EXT :: GLenum
gl_CURRENT_BINORMAL_EXT = 0x843C

gl_CURRENT_BIT :: GLbitfield
gl_CURRENT_BIT = 0x00000001

gl_CURRENT_COLOR :: GLenum
gl_CURRENT_COLOR = 0x0B00

gl_CURRENT_FOG_COORD :: GLenum
gl_CURRENT_FOG_COORD = 0x8453

gl_CURRENT_FOG_COORDINATE :: GLenum
gl_CURRENT_FOG_COORDINATE = 0x8453

gl_CURRENT_FOG_COORDINATE_EXT :: GLenum
gl_CURRENT_FOG_COORDINATE_EXT = 0x8453

gl_CURRENT_INDEX :: GLenum
gl_CURRENT_INDEX = 0x0B01

gl_CURRENT_MATRIX_ARB :: GLenum
gl_CURRENT_MATRIX_ARB = 0x8641

gl_CURRENT_MATRIX_INDEX_ARB :: GLenum
gl_CURRENT_MATRIX_INDEX_ARB = 0x8845

gl_CURRENT_MATRIX_NV :: GLenum
gl_CURRENT_MATRIX_NV = 0x8641

gl_CURRENT_MATRIX_STACK_DEPTH_ARB :: GLenum
gl_CURRENT_MATRIX_STACK_DEPTH_ARB = 0x8640

gl_CURRENT_MATRIX_STACK_DEPTH_NV :: GLenum
gl_CURRENT_MATRIX_STACK_DEPTH_NV = 0x8640

gl_CURRENT_NORMAL :: GLenum
gl_CURRENT_NORMAL = 0x0B02

gl_CURRENT_OCCLUSION_QUERY_ID_NV :: GLenum
gl_CURRENT_OCCLUSION_QUERY_ID_NV = 0x8865

gl_CURRENT_PALETTE_MATRIX_ARB :: GLenum
gl_CURRENT_PALETTE_MATRIX_ARB = 0x8843

gl_CURRENT_PALETTE_MATRIX_OES :: GLenum
gl_CURRENT_PALETTE_MATRIX_OES = 0x8843

gl_CURRENT_PROGRAM :: GLenum
gl_CURRENT_PROGRAM = 0x8B8D

gl_CURRENT_QUERY :: GLenum
gl_CURRENT_QUERY = 0x8865

gl_CURRENT_QUERY_ARB :: GLenum
gl_CURRENT_QUERY_ARB = 0x8865

gl_CURRENT_QUERY_EXT :: GLenum
gl_CURRENT_QUERY_EXT = 0x8865

gl_CURRENT_RASTER_COLOR :: GLenum
gl_CURRENT_RASTER_COLOR = 0x0B04

gl_CURRENT_RASTER_DISTANCE :: GLenum
gl_CURRENT_RASTER_DISTANCE = 0x0B09

gl_CURRENT_RASTER_INDEX :: GLenum
gl_CURRENT_RASTER_INDEX = 0x0B05

gl_CURRENT_RASTER_NORMAL_SGIX :: GLenum
gl_CURRENT_RASTER_NORMAL_SGIX = 0x8406

gl_CURRENT_RASTER_POSITION :: GLenum
gl_CURRENT_RASTER_POSITION = 0x0B07

gl_CURRENT_RASTER_POSITION_VALID :: GLenum
gl_CURRENT_RASTER_POSITION_VALID = 0x0B08

gl_CURRENT_RASTER_SECONDARY_COLOR :: GLenum
gl_CURRENT_RASTER_SECONDARY_COLOR = 0x845F

gl_CURRENT_RASTER_TEXTURE_COORDS :: GLenum
gl_CURRENT_RASTER_TEXTURE_COORDS = 0x0B06

gl_CURRENT_SECONDARY_COLOR :: GLenum
gl_CURRENT_SECONDARY_COLOR = 0x8459

gl_CURRENT_SECONDARY_COLOR_EXT :: GLenum
gl_CURRENT_SECONDARY_COLOR_EXT = 0x8459

gl_CURRENT_TANGENT_EXT :: GLenum
gl_CURRENT_TANGENT_EXT = 0x843B

gl_CURRENT_TEXTURE_COORDS :: GLenum
gl_CURRENT_TEXTURE_COORDS = 0x0B03

gl_CURRENT_TIME_NV :: GLenum
gl_CURRENT_TIME_NV = 0x8E28

gl_CURRENT_VERTEX_ATTRIB :: GLenum
gl_CURRENT_VERTEX_ATTRIB = 0x8626

gl_CURRENT_VERTEX_ATTRIB_ARB :: GLenum
gl_CURRENT_VERTEX_ATTRIB_ARB = 0x8626

gl_CURRENT_VERTEX_EXT :: GLenum
gl_CURRENT_VERTEX_EXT = 0x87E2

gl_CURRENT_VERTEX_WEIGHT_EXT :: GLenum
gl_CURRENT_VERTEX_WEIGHT_EXT = 0x850B

gl_CURRENT_WEIGHT_ARB :: GLenum
gl_CURRENT_WEIGHT_ARB = 0x86A8

gl_CW :: GLenum
gl_CW = 0x0900

gl_DARKEN_KHR :: GLenum
gl_DARKEN_KHR = 0x9297

gl_DARKEN_NV :: GLenum
gl_DARKEN_NV = 0x9297

gl_DATA_BUFFER_AMD :: GLenum
gl_DATA_BUFFER_AMD = 0x9151

gl_DEBUG_ASSERT_MESA :: GLenum
gl_DEBUG_ASSERT_MESA = 0x875B

gl_DEBUG_CALLBACK_FUNCTION :: GLenum
gl_DEBUG_CALLBACK_FUNCTION = 0x8244

gl_DEBUG_CALLBACK_FUNCTION_ARB :: GLenum
gl_DEBUG_CALLBACK_FUNCTION_ARB = 0x8244

gl_DEBUG_CALLBACK_FUNCTION_KHR :: GLenum
gl_DEBUG_CALLBACK_FUNCTION_KHR = 0x8244

gl_DEBUG_CALLBACK_USER_PARAM :: GLenum
gl_DEBUG_CALLBACK_USER_PARAM = 0x8245

gl_DEBUG_CALLBACK_USER_PARAM_ARB :: GLenum
gl_DEBUG_CALLBACK_USER_PARAM_ARB = 0x8245

gl_DEBUG_CALLBACK_USER_PARAM_KHR :: GLenum
gl_DEBUG_CALLBACK_USER_PARAM_KHR = 0x8245

gl_DEBUG_CATEGORY_API_ERROR_AMD :: GLenum
gl_DEBUG_CATEGORY_API_ERROR_AMD = 0x9149

gl_DEBUG_CATEGORY_APPLICATION_AMD :: GLenum
gl_DEBUG_CATEGORY_APPLICATION_AMD = 0x914F

gl_DEBUG_CATEGORY_DEPRECATION_AMD :: GLenum
gl_DEBUG_CATEGORY_DEPRECATION_AMD = 0x914B

gl_DEBUG_CATEGORY_OTHER_AMD :: GLenum
gl_DEBUG_CATEGORY_OTHER_AMD = 0x9150

gl_DEBUG_CATEGORY_PERFORMANCE_AMD :: GLenum
gl_DEBUG_CATEGORY_PERFORMANCE_AMD = 0x914D

gl_DEBUG_CATEGORY_SHADER_COMPILER_AMD :: GLenum
gl_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 0x914E

gl_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD :: GLenum
gl_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 0x914C

gl_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD :: GLenum
gl_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 0x914A

gl_DEBUG_GROUP_STACK_DEPTH :: GLenum
gl_DEBUG_GROUP_STACK_DEPTH = 0x826D

gl_DEBUG_GROUP_STACK_DEPTH_KHR :: GLenum
gl_DEBUG_GROUP_STACK_DEPTH_KHR = 0x826D

gl_DEBUG_LOGGED_MESSAGES :: GLenum
gl_DEBUG_LOGGED_MESSAGES = 0x9145

gl_DEBUG_LOGGED_MESSAGES_AMD :: GLenum
gl_DEBUG_LOGGED_MESSAGES_AMD = 0x9145

gl_DEBUG_LOGGED_MESSAGES_ARB :: GLenum
gl_DEBUG_LOGGED_MESSAGES_ARB = 0x9145

gl_DEBUG_LOGGED_MESSAGES_KHR :: GLenum
gl_DEBUG_LOGGED_MESSAGES_KHR = 0x9145

gl_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH :: GLenum
gl_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 0x8243

gl_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB :: GLenum
gl_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 0x8243

gl_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR :: GLenum
gl_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 0x8243

gl_DEBUG_OBJECT_MESA :: GLenum
gl_DEBUG_OBJECT_MESA = 0x8759

gl_DEBUG_OUTPUT :: GLenum
gl_DEBUG_OUTPUT = 0x92E0

gl_DEBUG_OUTPUT_KHR :: GLenum
gl_DEBUG_OUTPUT_KHR = 0x92E0

gl_DEBUG_OUTPUT_SYNCHRONOUS :: GLenum
gl_DEBUG_OUTPUT_SYNCHRONOUS = 0x8242

gl_DEBUG_OUTPUT_SYNCHRONOUS_ARB :: GLenum
gl_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 0x8242

gl_DEBUG_OUTPUT_SYNCHRONOUS_KHR :: GLenum
gl_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 0x8242

gl_DEBUG_PRINT_MESA :: GLenum
gl_DEBUG_PRINT_MESA = 0x875A

gl_DEBUG_SEVERITY_HIGH :: GLenum
gl_DEBUG_SEVERITY_HIGH = 0x9146

gl_DEBUG_SEVERITY_HIGH_AMD :: GLenum
gl_DEBUG_SEVERITY_HIGH_AMD = 0x9146

gl_DEBUG_SEVERITY_HIGH_ARB :: GLenum
gl_DEBUG_SEVERITY_HIGH_ARB = 0x9146

gl_DEBUG_SEVERITY_HIGH_KHR :: GLenum
gl_DEBUG_SEVERITY_HIGH_KHR = 0x9146

gl_DEBUG_SEVERITY_LOW :: GLenum
gl_DEBUG_SEVERITY_LOW = 0x9148

gl_DEBUG_SEVERITY_LOW_AMD :: GLenum
gl_DEBUG_SEVERITY_LOW_AMD = 0x9148

gl_DEBUG_SEVERITY_LOW_ARB :: GLenum
gl_DEBUG_SEVERITY_LOW_ARB = 0x9148

gl_DEBUG_SEVERITY_LOW_KHR :: GLenum
gl_DEBUG_SEVERITY_LOW_KHR = 0x9148

gl_DEBUG_SEVERITY_MEDIUM :: GLenum
gl_DEBUG_SEVERITY_MEDIUM = 0x9147

gl_DEBUG_SEVERITY_MEDIUM_AMD :: GLenum
gl_DEBUG_SEVERITY_MEDIUM_AMD = 0x9147

gl_DEBUG_SEVERITY_MEDIUM_ARB :: GLenum
gl_DEBUG_SEVERITY_MEDIUM_ARB = 0x9147

gl_DEBUG_SEVERITY_MEDIUM_KHR :: GLenum
gl_DEBUG_SEVERITY_MEDIUM_KHR = 0x9147

gl_DEBUG_SEVERITY_NOTIFICATION :: GLenum
gl_DEBUG_SEVERITY_NOTIFICATION = 0x826B

gl_DEBUG_SEVERITY_NOTIFICATION_KHR :: GLenum
gl_DEBUG_SEVERITY_NOTIFICATION_KHR = 0x826B

gl_DEBUG_SOURCE_API :: GLenum
gl_DEBUG_SOURCE_API = 0x8246

gl_DEBUG_SOURCE_API_ARB :: GLenum
gl_DEBUG_SOURCE_API_ARB = 0x8246

gl_DEBUG_SOURCE_API_KHR :: GLenum
gl_DEBUG_SOURCE_API_KHR = 0x8246

gl_DEBUG_SOURCE_APPLICATION :: GLenum
gl_DEBUG_SOURCE_APPLICATION = 0x824A

gl_DEBUG_SOURCE_APPLICATION_ARB :: GLenum
gl_DEBUG_SOURCE_APPLICATION_ARB = 0x824A

gl_DEBUG_SOURCE_APPLICATION_KHR :: GLenum
gl_DEBUG_SOURCE_APPLICATION_KHR = 0x824A

gl_DEBUG_SOURCE_OTHER :: GLenum
gl_DEBUG_SOURCE_OTHER = 0x824B

gl_DEBUG_SOURCE_OTHER_ARB :: GLenum
gl_DEBUG_SOURCE_OTHER_ARB = 0x824B

gl_DEBUG_SOURCE_OTHER_KHR :: GLenum
gl_DEBUG_SOURCE_OTHER_KHR = 0x824B

gl_DEBUG_SOURCE_SHADER_COMPILER :: GLenum
gl_DEBUG_SOURCE_SHADER_COMPILER = 0x8248

gl_DEBUG_SOURCE_SHADER_COMPILER_ARB :: GLenum
gl_DEBUG_SOURCE_SHADER_COMPILER_ARB = 0x8248

gl_DEBUG_SOURCE_SHADER_COMPILER_KHR :: GLenum
gl_DEBUG_SOURCE_SHADER_COMPILER_KHR = 0x8248

gl_DEBUG_SOURCE_THIRD_PARTY :: GLenum
gl_DEBUG_SOURCE_THIRD_PARTY = 0x8249

gl_DEBUG_SOURCE_THIRD_PARTY_ARB :: GLenum
gl_DEBUG_SOURCE_THIRD_PARTY_ARB = 0x8249

gl_DEBUG_SOURCE_THIRD_PARTY_KHR :: GLenum
gl_DEBUG_SOURCE_THIRD_PARTY_KHR = 0x8249

gl_DEBUG_SOURCE_WINDOW_SYSTEM :: GLenum
gl_DEBUG_SOURCE_WINDOW_SYSTEM = 0x8247

gl_DEBUG_SOURCE_WINDOW_SYSTEM_ARB :: GLenum
gl_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 0x8247

gl_DEBUG_SOURCE_WINDOW_SYSTEM_KHR :: GLenum
gl_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 0x8247

gl_DEBUG_TYPE_DEPRECATED_BEHAVIOR :: GLenum
gl_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 0x824D

gl_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB :: GLenum
gl_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 0x824D

gl_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR :: GLenum
gl_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 0x824D

gl_DEBUG_TYPE_ERROR :: GLenum
gl_DEBUG_TYPE_ERROR = 0x824C

gl_DEBUG_TYPE_ERROR_ARB :: GLenum
gl_DEBUG_TYPE_ERROR_ARB = 0x824C

gl_DEBUG_TYPE_ERROR_KHR :: GLenum
gl_DEBUG_TYPE_ERROR_KHR = 0x824C

gl_DEBUG_TYPE_MARKER :: GLenum
gl_DEBUG_TYPE_MARKER = 0x8268

gl_DEBUG_TYPE_MARKER_KHR :: GLenum
gl_DEBUG_TYPE_MARKER_KHR = 0x8268

gl_DEBUG_TYPE_OTHER :: GLenum
gl_DEBUG_TYPE_OTHER = 0x8251

gl_DEBUG_TYPE_OTHER_ARB :: GLenum
gl_DEBUG_TYPE_OTHER_ARB = 0x8251

gl_DEBUG_TYPE_OTHER_KHR :: GLenum
gl_DEBUG_TYPE_OTHER_KHR = 0x8251

gl_DEBUG_TYPE_PERFORMANCE :: GLenum
gl_DEBUG_TYPE_PERFORMANCE = 0x8250

gl_DEBUG_TYPE_PERFORMANCE_ARB :: GLenum
gl_DEBUG_TYPE_PERFORMANCE_ARB = 0x8250

gl_DEBUG_TYPE_PERFORMANCE_KHR :: GLenum
gl_DEBUG_TYPE_PERFORMANCE_KHR = 0x8250

gl_DEBUG_TYPE_POP_GROUP :: GLenum
gl_DEBUG_TYPE_POP_GROUP = 0x826A

gl_DEBUG_TYPE_POP_GROUP_KHR :: GLenum
gl_DEBUG_TYPE_POP_GROUP_KHR = 0x826A

gl_DEBUG_TYPE_PORTABILITY :: GLenum
gl_DEBUG_TYPE_PORTABILITY = 0x824F

gl_DEBUG_TYPE_PORTABILITY_ARB :: GLenum
gl_DEBUG_TYPE_PORTABILITY_ARB = 0x824F

gl_DEBUG_TYPE_PORTABILITY_KHR :: GLenum
gl_DEBUG_TYPE_PORTABILITY_KHR = 0x824F

gl_DEBUG_TYPE_PUSH_GROUP :: GLenum
gl_DEBUG_TYPE_PUSH_GROUP = 0x8269

gl_DEBUG_TYPE_PUSH_GROUP_KHR :: GLenum
gl_DEBUG_TYPE_PUSH_GROUP_KHR = 0x8269

gl_DEBUG_TYPE_UNDEFINED_BEHAVIOR :: GLenum
gl_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 0x824E

gl_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB :: GLenum
gl_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 0x824E

gl_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR :: GLenum
gl_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 0x824E

gl_DECAL :: GLenum
gl_DECAL = 0x2101

gl_DECODE_EXT :: GLenum
gl_DECODE_EXT = 0x8A49

gl_DECR :: GLenum
gl_DECR = 0x1E03

gl_DECR_WRAP :: GLenum
gl_DECR_WRAP = 0x8508

gl_DECR_WRAP_EXT :: GLenum
gl_DECR_WRAP_EXT = 0x8508

gl_DECR_WRAP_OES :: GLenum
gl_DECR_WRAP_OES = 0x8508

gl_DEFORMATIONS_MASK_SGIX :: GLenum
gl_DEFORMATIONS_MASK_SGIX = 0x8196

gl_DELETE_STATUS :: GLenum
gl_DELETE_STATUS = 0x8B80

gl_DEPENDENT_AR_TEXTURE_2D_NV :: GLenum
gl_DEPENDENT_AR_TEXTURE_2D_NV = 0x86E9

gl_DEPENDENT_GB_TEXTURE_2D_NV :: GLenum
gl_DEPENDENT_GB_TEXTURE_2D_NV = 0x86EA

gl_DEPENDENT_HILO_TEXTURE_2D_NV :: GLenum
gl_DEPENDENT_HILO_TEXTURE_2D_NV = 0x8858

gl_DEPENDENT_RGB_TEXTURE_3D_NV :: GLenum
gl_DEPENDENT_RGB_TEXTURE_3D_NV = 0x8859

gl_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV :: GLenum
gl_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = 0x885A

gl_DEPTH :: GLenum
gl_DEPTH = 0x1801

gl_DEPTH24_STENCIL8 :: GLenum
gl_DEPTH24_STENCIL8 = 0x88F0

gl_DEPTH24_STENCIL8_EXT :: GLenum
gl_DEPTH24_STENCIL8_EXT = 0x88F0

gl_DEPTH24_STENCIL8_OES :: GLenum
gl_DEPTH24_STENCIL8_OES = 0x88F0

gl_DEPTH32F_STENCIL8 :: GLenum
gl_DEPTH32F_STENCIL8 = 0x8CAD

gl_DEPTH32F_STENCIL8_NV :: GLenum
gl_DEPTH32F_STENCIL8_NV = 0x8DAC

gl_DEPTH_ATTACHMENT :: GLenum
gl_DEPTH_ATTACHMENT = 0x8D00

gl_DEPTH_ATTACHMENT_EXT :: GLenum
gl_DEPTH_ATTACHMENT_EXT = 0x8D00

gl_DEPTH_ATTACHMENT_OES :: GLenum
gl_DEPTH_ATTACHMENT_OES = 0x8D00

gl_DEPTH_BIAS :: GLenum
gl_DEPTH_BIAS = 0x0D1F

gl_DEPTH_BITS :: GLenum
gl_DEPTH_BITS = 0x0D56

gl_DEPTH_BOUNDS_EXT :: GLenum
gl_DEPTH_BOUNDS_EXT = 0x8891

gl_DEPTH_BOUNDS_TEST_EXT :: GLenum
gl_DEPTH_BOUNDS_TEST_EXT = 0x8890

gl_DEPTH_BUFFER_BIT :: GLbitfield
gl_DEPTH_BUFFER_BIT = 0x00000100

gl_DEPTH_BUFFER_BIT0_QCOM :: GLbitfield
gl_DEPTH_BUFFER_BIT0_QCOM = 0x00000100

gl_DEPTH_BUFFER_BIT1_QCOM :: GLbitfield
gl_DEPTH_BUFFER_BIT1_QCOM = 0x00000200

gl_DEPTH_BUFFER_BIT2_QCOM :: GLbitfield
gl_DEPTH_BUFFER_BIT2_QCOM = 0x00000400

gl_DEPTH_BUFFER_BIT3_QCOM :: GLbitfield
gl_DEPTH_BUFFER_BIT3_QCOM = 0x00000800

gl_DEPTH_BUFFER_BIT4_QCOM :: GLbitfield
gl_DEPTH_BUFFER_BIT4_QCOM = 0x00001000

gl_DEPTH_BUFFER_BIT5_QCOM :: GLbitfield
gl_DEPTH_BUFFER_BIT5_QCOM = 0x00002000

gl_DEPTH_BUFFER_BIT6_QCOM :: GLbitfield
gl_DEPTH_BUFFER_BIT6_QCOM = 0x00004000

gl_DEPTH_BUFFER_BIT7_QCOM :: GLbitfield
gl_DEPTH_BUFFER_BIT7_QCOM = 0x00008000

gl_DEPTH_BUFFER_FLOAT_MODE_NV :: GLenum
gl_DEPTH_BUFFER_FLOAT_MODE_NV = 0x8DAF

gl_DEPTH_CLAMP :: GLenum
gl_DEPTH_CLAMP = 0x864F

gl_DEPTH_CLAMP_FAR_AMD :: GLenum
gl_DEPTH_CLAMP_FAR_AMD = 0x901F

gl_DEPTH_CLAMP_NEAR_AMD :: GLenum
gl_DEPTH_CLAMP_NEAR_AMD = 0x901E

gl_DEPTH_CLAMP_NV :: GLenum
gl_DEPTH_CLAMP_NV = 0x864F

gl_DEPTH_CLEAR_VALUE :: GLenum
gl_DEPTH_CLEAR_VALUE = 0x0B73

gl_DEPTH_COMPONENT :: GLenum
gl_DEPTH_COMPONENT = 0x1902

gl_DEPTH_COMPONENT16 :: GLenum
gl_DEPTH_COMPONENT16 = 0x81A5

gl_DEPTH_COMPONENT16_ARB :: GLenum
gl_DEPTH_COMPONENT16_ARB = 0x81A5

gl_DEPTH_COMPONENT16_NONLINEAR_NV :: GLenum
gl_DEPTH_COMPONENT16_NONLINEAR_NV = 0x8E2C

gl_DEPTH_COMPONENT16_OES :: GLenum
gl_DEPTH_COMPONENT16_OES = 0x81A5

gl_DEPTH_COMPONENT16_SGIX :: GLenum
gl_DEPTH_COMPONENT16_SGIX = 0x81A5

gl_DEPTH_COMPONENT24 :: GLenum
gl_DEPTH_COMPONENT24 = 0x81A6

gl_DEPTH_COMPONENT24_ARB :: GLenum
gl_DEPTH_COMPONENT24_ARB = 0x81A6

gl_DEPTH_COMPONENT24_OES :: GLenum
gl_DEPTH_COMPONENT24_OES = 0x81A6

gl_DEPTH_COMPONENT24_SGIX :: GLenum
gl_DEPTH_COMPONENT24_SGIX = 0x81A6

gl_DEPTH_COMPONENT32 :: GLenum
gl_DEPTH_COMPONENT32 = 0x81A7

gl_DEPTH_COMPONENT32F :: GLenum
gl_DEPTH_COMPONENT32F = 0x8CAC

gl_DEPTH_COMPONENT32F_NV :: GLenum
gl_DEPTH_COMPONENT32F_NV = 0x8DAB

gl_DEPTH_COMPONENT32_ARB :: GLenum
gl_DEPTH_COMPONENT32_ARB = 0x81A7

gl_DEPTH_COMPONENT32_OES :: GLenum
gl_DEPTH_COMPONENT32_OES = 0x81A7

gl_DEPTH_COMPONENT32_SGIX :: GLenum
gl_DEPTH_COMPONENT32_SGIX = 0x81A7

gl_DEPTH_COMPONENTS :: GLenum
gl_DEPTH_COMPONENTS = 0x8284

gl_DEPTH_EXT :: GLenum
gl_DEPTH_EXT = 0x1801

gl_DEPTH_FUNC :: GLenum
gl_DEPTH_FUNC = 0x0B74

gl_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX :: GLenum
gl_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX = 0x8311

gl_DEPTH_PASS_INSTRUMENT_MAX_SGIX :: GLenum
gl_DEPTH_PASS_INSTRUMENT_MAX_SGIX = 0x8312

gl_DEPTH_PASS_INSTRUMENT_SGIX :: GLenum
gl_DEPTH_PASS_INSTRUMENT_SGIX = 0x8310

gl_DEPTH_RANGE :: GLenum
gl_DEPTH_RANGE = 0x0B70

gl_DEPTH_RENDERABLE :: GLenum
gl_DEPTH_RENDERABLE = 0x8287

gl_DEPTH_SAMPLES_NV :: GLenum
gl_DEPTH_SAMPLES_NV = 0x932D

gl_DEPTH_SCALE :: GLenum
gl_DEPTH_SCALE = 0x0D1E

gl_DEPTH_STENCIL :: GLenum
gl_DEPTH_STENCIL = 0x84F9

gl_DEPTH_STENCIL_ATTACHMENT :: GLenum
gl_DEPTH_STENCIL_ATTACHMENT = 0x821A

gl_DEPTH_STENCIL_EXT :: GLenum
gl_DEPTH_STENCIL_EXT = 0x84F9

gl_DEPTH_STENCIL_MESA :: GLenum
gl_DEPTH_STENCIL_MESA = 0x8750

gl_DEPTH_STENCIL_NV :: GLenum
gl_DEPTH_STENCIL_NV = 0x84F9

gl_DEPTH_STENCIL_OES :: GLenum
gl_DEPTH_STENCIL_OES = 0x84F9

gl_DEPTH_STENCIL_TEXTURE_MODE :: GLenum
gl_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA

gl_DEPTH_STENCIL_TO_BGRA_NV :: GLenum
gl_DEPTH_STENCIL_TO_BGRA_NV = 0x886F

gl_DEPTH_STENCIL_TO_RGBA_NV :: GLenum
gl_DEPTH_STENCIL_TO_RGBA_NV = 0x886E

gl_DEPTH_TEST :: GLenum
gl_DEPTH_TEST = 0x0B71

gl_DEPTH_TEXTURE_MODE :: GLenum
gl_DEPTH_TEXTURE_MODE = 0x884B

gl_DEPTH_TEXTURE_MODE_ARB :: GLenum
gl_DEPTH_TEXTURE_MODE_ARB = 0x884B

gl_DEPTH_WRITEMASK :: GLenum
gl_DEPTH_WRITEMASK = 0x0B72

gl_DETAIL_TEXTURE_2D_BINDING_SGIS :: GLenum
gl_DETAIL_TEXTURE_2D_BINDING_SGIS = 0x8096

gl_DETAIL_TEXTURE_2D_SGIS :: GLenum
gl_DETAIL_TEXTURE_2D_SGIS = 0x8095

gl_DETAIL_TEXTURE_FUNC_POINTS_SGIS :: GLenum
gl_DETAIL_TEXTURE_FUNC_POINTS_SGIS = 0x809C

gl_DETAIL_TEXTURE_LEVEL_SGIS :: GLenum
gl_DETAIL_TEXTURE_LEVEL_SGIS = 0x809A

gl_DETAIL_TEXTURE_MODE_SGIS :: GLenum
gl_DETAIL_TEXTURE_MODE_SGIS = 0x809B

gl_DIFFERENCE_KHR :: GLenum
gl_DIFFERENCE_KHR = 0x929E

gl_DIFFERENCE_NV :: GLenum
gl_DIFFERENCE_NV = 0x929E

gl_DIFFUSE :: GLenum
gl_DIFFUSE = 0x1201

gl_DISCARD_ATI :: GLenum
gl_DISCARD_ATI = 0x8763

gl_DISCARD_NV :: GLenum
gl_DISCARD_NV = 0x8530

gl_DISCRETE_AMD :: GLenum
gl_DISCRETE_AMD = 0x9006

gl_DISJOINT_NV :: GLenum
gl_DISJOINT_NV = 0x9283

gl_DISPATCH_INDIRECT_BUFFER :: GLenum
gl_DISPATCH_INDIRECT_BUFFER = 0x90EE

gl_DISPATCH_INDIRECT_BUFFER_BINDING :: GLenum
gl_DISPATCH_INDIRECT_BUFFER_BINDING = 0x90EF

gl_DISPLAY_LIST :: GLenum
gl_DISPLAY_LIST = 0x82E7

gl_DISTANCE_ATTENUATION_EXT :: GLenum
gl_DISTANCE_ATTENUATION_EXT = 0x8129

gl_DISTANCE_ATTENUATION_SGIS :: GLenum
gl_DISTANCE_ATTENUATION_SGIS = 0x8129

gl_DITHER :: GLenum
gl_DITHER = 0x0BD0

gl_DMP_PROGRAM_BINARY_DMP :: GLenum
gl_DMP_PROGRAM_BINARY_DMP = 0x9253

gl_DOMAIN :: GLenum
gl_DOMAIN = 0x0A02

gl_DONT_CARE :: GLenum
gl_DONT_CARE = 0x1100

gl_DOT2_ADD_ATI :: GLenum
gl_DOT2_ADD_ATI = 0x896C

gl_DOT3_ATI :: GLenum
gl_DOT3_ATI = 0x8966

gl_DOT3_RGB :: GLenum
gl_DOT3_RGB = 0x86AE

gl_DOT3_RGBA :: GLenum
gl_DOT3_RGBA = 0x86AF

gl_DOT3_RGBA_ARB :: GLenum
gl_DOT3_RGBA_ARB = 0x86AF

gl_DOT3_RGBA_EXT :: GLenum
gl_DOT3_RGBA_EXT = 0x8741

gl_DOT3_RGBA_IMG :: GLenum
gl_DOT3_RGBA_IMG = 0x86AF

gl_DOT3_RGB_ARB :: GLenum
gl_DOT3_RGB_ARB = 0x86AE

gl_DOT3_RGB_EXT :: GLenum
gl_DOT3_RGB_EXT = 0x8740

gl_DOT4_ATI :: GLenum
gl_DOT4_ATI = 0x8967

gl_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV :: GLenum
gl_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = 0x885D

gl_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV :: GLenum
gl_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = 0x86F3

gl_DOT_PRODUCT_DEPTH_REPLACE_NV :: GLenum
gl_DOT_PRODUCT_DEPTH_REPLACE_NV = 0x86ED

gl_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV :: GLenum
gl_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = 0x86F1

gl_DOT_PRODUCT_NV :: GLenum
gl_DOT_PRODUCT_NV = 0x86EC

gl_DOT_PRODUCT_PASS_THROUGH_NV :: GLenum
gl_DOT_PRODUCT_PASS_THROUGH_NV = 0x885B

gl_DOT_PRODUCT_REFLECT_CUBE_MAP_NV :: GLenum
gl_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = 0x86F2

gl_DOT_PRODUCT_TEXTURE_1D_NV :: GLenum
gl_DOT_PRODUCT_TEXTURE_1D_NV = 0x885C

gl_DOT_PRODUCT_TEXTURE_2D_NV :: GLenum
gl_DOT_PRODUCT_TEXTURE_2D_NV = 0x86EE

gl_DOT_PRODUCT_TEXTURE_3D_NV :: GLenum
gl_DOT_PRODUCT_TEXTURE_3D_NV = 0x86EF

gl_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV :: GLenum
gl_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = 0x86F0

gl_DOT_PRODUCT_TEXTURE_RECTANGLE_NV :: GLenum
gl_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = 0x864E

gl_DOUBLE :: GLenum
gl_DOUBLE = 0x140A

gl_DOUBLEBUFFER :: GLenum
gl_DOUBLEBUFFER = 0x0C32

gl_DOUBLE_EXT :: GLenum
gl_DOUBLE_EXT = 0x140A

gl_DOUBLE_MAT2 :: GLenum
gl_DOUBLE_MAT2 = 0x8F46

gl_DOUBLE_MAT2_EXT :: GLenum
gl_DOUBLE_MAT2_EXT = 0x8F46

gl_DOUBLE_MAT2x3 :: GLenum
gl_DOUBLE_MAT2x3 = 0x8F49

gl_DOUBLE_MAT2x3_EXT :: GLenum
gl_DOUBLE_MAT2x3_EXT = 0x8F49

gl_DOUBLE_MAT2x4 :: GLenum
gl_DOUBLE_MAT2x4 = 0x8F4A

gl_DOUBLE_MAT2x4_EXT :: GLenum
gl_DOUBLE_MAT2x4_EXT = 0x8F4A

gl_DOUBLE_MAT3 :: GLenum
gl_DOUBLE_MAT3 = 0x8F47

gl_DOUBLE_MAT3_EXT :: GLenum
gl_DOUBLE_MAT3_EXT = 0x8F47

gl_DOUBLE_MAT3x2 :: GLenum
gl_DOUBLE_MAT3x2 = 0x8F4B

gl_DOUBLE_MAT3x2_EXT :: GLenum
gl_DOUBLE_MAT3x2_EXT = 0x8F4B

gl_DOUBLE_MAT3x4 :: GLenum
gl_DOUBLE_MAT3x4 = 0x8F4C

gl_DOUBLE_MAT3x4_EXT :: GLenum
gl_DOUBLE_MAT3x4_EXT = 0x8F4C

gl_DOUBLE_MAT4 :: GLenum
gl_DOUBLE_MAT4 = 0x8F48

gl_DOUBLE_MAT4_EXT :: GLenum
gl_DOUBLE_MAT4_EXT = 0x8F48

gl_DOUBLE_MAT4x2 :: GLenum
gl_DOUBLE_MAT4x2 = 0x8F4D

gl_DOUBLE_MAT4x2_EXT :: GLenum
gl_DOUBLE_MAT4x2_EXT = 0x8F4D

gl_DOUBLE_MAT4x3 :: GLenum
gl_DOUBLE_MAT4x3 = 0x8F4E

gl_DOUBLE_MAT4x3_EXT :: GLenum
gl_DOUBLE_MAT4x3_EXT = 0x8F4E

gl_DOUBLE_VEC2 :: GLenum
gl_DOUBLE_VEC2 = 0x8FFC

gl_DOUBLE_VEC2_EXT :: GLenum
gl_DOUBLE_VEC2_EXT = 0x8FFC

gl_DOUBLE_VEC3 :: GLenum
gl_DOUBLE_VEC3 = 0x8FFD

gl_DOUBLE_VEC3_EXT :: GLenum
gl_DOUBLE_VEC3_EXT = 0x8FFD

gl_DOUBLE_VEC4 :: GLenum
gl_DOUBLE_VEC4 = 0x8FFE

gl_DOUBLE_VEC4_EXT :: GLenum
gl_DOUBLE_VEC4_EXT = 0x8FFE

gl_DRAW_BUFFER :: GLenum
gl_DRAW_BUFFER = 0x0C01

gl_DRAW_BUFFER0 :: GLenum
gl_DRAW_BUFFER0 = 0x8825

gl_DRAW_BUFFER0_ARB :: GLenum
gl_DRAW_BUFFER0_ARB = 0x8825

gl_DRAW_BUFFER0_ATI :: GLenum
gl_DRAW_BUFFER0_ATI = 0x8825

gl_DRAW_BUFFER0_EXT :: GLenum
gl_DRAW_BUFFER0_EXT = 0x8825

gl_DRAW_BUFFER0_NV :: GLenum
gl_DRAW_BUFFER0_NV = 0x8825

gl_DRAW_BUFFER1 :: GLenum
gl_DRAW_BUFFER1 = 0x8826

gl_DRAW_BUFFER10 :: GLenum
gl_DRAW_BUFFER10 = 0x882F

gl_DRAW_BUFFER10_ARB :: GLenum
gl_DRAW_BUFFER10_ARB = 0x882F

gl_DRAW_BUFFER10_ATI :: GLenum
gl_DRAW_BUFFER10_ATI = 0x882F

gl_DRAW_BUFFER10_EXT :: GLenum
gl_DRAW_BUFFER10_EXT = 0x882F

gl_DRAW_BUFFER10_NV :: GLenum
gl_DRAW_BUFFER10_NV = 0x882F

gl_DRAW_BUFFER11 :: GLenum
gl_DRAW_BUFFER11 = 0x8830

gl_DRAW_BUFFER11_ARB :: GLenum
gl_DRAW_BUFFER11_ARB = 0x8830

gl_DRAW_BUFFER11_ATI :: GLenum
gl_DRAW_BUFFER11_ATI = 0x8830

gl_DRAW_BUFFER11_EXT :: GLenum
gl_DRAW_BUFFER11_EXT = 0x8830

gl_DRAW_BUFFER11_NV :: GLenum
gl_DRAW_BUFFER11_NV = 0x8830

gl_DRAW_BUFFER12 :: GLenum
gl_DRAW_BUFFER12 = 0x8831

gl_DRAW_BUFFER12_ARB :: GLenum
gl_DRAW_BUFFER12_ARB = 0x8831

gl_DRAW_BUFFER12_ATI :: GLenum
gl_DRAW_BUFFER12_ATI = 0x8831

gl_DRAW_BUFFER12_EXT :: GLenum
gl_DRAW_BUFFER12_EXT = 0x8831

gl_DRAW_BUFFER12_NV :: GLenum
gl_DRAW_BUFFER12_NV = 0x8831

gl_DRAW_BUFFER13 :: GLenum
gl_DRAW_BUFFER13 = 0x8832

gl_DRAW_BUFFER13_ARB :: GLenum
gl_DRAW_BUFFER13_ARB = 0x8832

gl_DRAW_BUFFER13_ATI :: GLenum
gl_DRAW_BUFFER13_ATI = 0x8832

gl_DRAW_BUFFER13_EXT :: GLenum
gl_DRAW_BUFFER13_EXT = 0x8832

gl_DRAW_BUFFER13_NV :: GLenum
gl_DRAW_BUFFER13_NV = 0x8832

gl_DRAW_BUFFER14 :: GLenum
gl_DRAW_BUFFER14 = 0x8833

gl_DRAW_BUFFER14_ARB :: GLenum
gl_DRAW_BUFFER14_ARB = 0x8833

gl_DRAW_BUFFER14_ATI :: GLenum
gl_DRAW_BUFFER14_ATI = 0x8833

gl_DRAW_BUFFER14_EXT :: GLenum
gl_DRAW_BUFFER14_EXT = 0x8833

gl_DRAW_BUFFER14_NV :: GLenum
gl_DRAW_BUFFER14_NV = 0x8833

gl_DRAW_BUFFER15 :: GLenum
gl_DRAW_BUFFER15 = 0x8834

gl_DRAW_BUFFER15_ARB :: GLenum
gl_DRAW_BUFFER15_ARB = 0x8834

gl_DRAW_BUFFER15_ATI :: GLenum
gl_DRAW_BUFFER15_ATI = 0x8834

gl_DRAW_BUFFER15_EXT :: GLenum
gl_DRAW_BUFFER15_EXT = 0x8834

gl_DRAW_BUFFER15_NV :: GLenum
gl_DRAW_BUFFER15_NV = 0x8834

gl_DRAW_BUFFER1_ARB :: GLenum
gl_DRAW_BUFFER1_ARB = 0x8826

gl_DRAW_BUFFER1_ATI :: GLenum
gl_DRAW_BUFFER1_ATI = 0x8826

gl_DRAW_BUFFER1_EXT :: GLenum
gl_DRAW_BUFFER1_EXT = 0x8826

gl_DRAW_BUFFER1_NV :: GLenum
gl_DRAW_BUFFER1_NV = 0x8826

gl_DRAW_BUFFER2 :: GLenum
gl_DRAW_BUFFER2 = 0x8827

gl_DRAW_BUFFER2_ARB :: GLenum
gl_DRAW_BUFFER2_ARB = 0x8827

gl_DRAW_BUFFER2_ATI :: GLenum
gl_DRAW_BUFFER2_ATI = 0x8827

gl_DRAW_BUFFER2_EXT :: GLenum
gl_DRAW_BUFFER2_EXT = 0x8827

gl_DRAW_BUFFER2_NV :: GLenum
gl_DRAW_BUFFER2_NV = 0x8827

gl_DRAW_BUFFER3 :: GLenum
gl_DRAW_BUFFER3 = 0x8828

gl_DRAW_BUFFER3_ARB :: GLenum
gl_DRAW_BUFFER3_ARB = 0x8828

gl_DRAW_BUFFER3_ATI :: GLenum
gl_DRAW_BUFFER3_ATI = 0x8828

gl_DRAW_BUFFER3_EXT :: GLenum
gl_DRAW_BUFFER3_EXT = 0x8828

gl_DRAW_BUFFER3_NV :: GLenum
gl_DRAW_BUFFER3_NV = 0x8828

gl_DRAW_BUFFER4 :: GLenum
gl_DRAW_BUFFER4 = 0x8829

gl_DRAW_BUFFER4_ARB :: GLenum
gl_DRAW_BUFFER4_ARB = 0x8829

gl_DRAW_BUFFER4_ATI :: GLenum
gl_DRAW_BUFFER4_ATI = 0x8829

gl_DRAW_BUFFER4_EXT :: GLenum
gl_DRAW_BUFFER4_EXT = 0x8829

gl_DRAW_BUFFER4_NV :: GLenum
gl_DRAW_BUFFER4_NV = 0x8829

gl_DRAW_BUFFER5 :: GLenum
gl_DRAW_BUFFER5 = 0x882A

gl_DRAW_BUFFER5_ARB :: GLenum
gl_DRAW_BUFFER5_ARB = 0x882A

gl_DRAW_BUFFER5_ATI :: GLenum
gl_DRAW_BUFFER5_ATI = 0x882A

gl_DRAW_BUFFER5_EXT :: GLenum
gl_DRAW_BUFFER5_EXT = 0x882A

gl_DRAW_BUFFER5_NV :: GLenum
gl_DRAW_BUFFER5_NV = 0x882A

gl_DRAW_BUFFER6 :: GLenum
gl_DRAW_BUFFER6 = 0x882B

gl_DRAW_BUFFER6_ARB :: GLenum
gl_DRAW_BUFFER6_ARB = 0x882B

gl_DRAW_BUFFER6_ATI :: GLenum
gl_DRAW_BUFFER6_ATI = 0x882B

gl_DRAW_BUFFER6_EXT :: GLenum
gl_DRAW_BUFFER6_EXT = 0x882B

gl_DRAW_BUFFER6_NV :: GLenum
gl_DRAW_BUFFER6_NV = 0x882B

gl_DRAW_BUFFER7 :: GLenum
gl_DRAW_BUFFER7 = 0x882C

gl_DRAW_BUFFER7_ARB :: GLenum
gl_DRAW_BUFFER7_ARB = 0x882C

gl_DRAW_BUFFER7_ATI :: GLenum
gl_DRAW_BUFFER7_ATI = 0x882C

gl_DRAW_BUFFER7_EXT :: GLenum
gl_DRAW_BUFFER7_EXT = 0x882C

gl_DRAW_BUFFER7_NV :: GLenum
gl_DRAW_BUFFER7_NV = 0x882C

gl_DRAW_BUFFER8 :: GLenum
gl_DRAW_BUFFER8 = 0x882D

gl_DRAW_BUFFER8_ARB :: GLenum
gl_DRAW_BUFFER8_ARB = 0x882D

gl_DRAW_BUFFER8_ATI :: GLenum
gl_DRAW_BUFFER8_ATI = 0x882D

gl_DRAW_BUFFER8_EXT :: GLenum
gl_DRAW_BUFFER8_EXT = 0x882D

gl_DRAW_BUFFER8_NV :: GLenum
gl_DRAW_BUFFER8_NV = 0x882D

gl_DRAW_BUFFER9 :: GLenum
gl_DRAW_BUFFER9 = 0x882E

gl_DRAW_BUFFER9_ARB :: GLenum
gl_DRAW_BUFFER9_ARB = 0x882E

gl_DRAW_BUFFER9_ATI :: GLenum
gl_DRAW_BUFFER9_ATI = 0x882E

gl_DRAW_BUFFER9_EXT :: GLenum
gl_DRAW_BUFFER9_EXT = 0x882E

gl_DRAW_BUFFER9_NV :: GLenum
gl_DRAW_BUFFER9_NV = 0x882E

gl_DRAW_BUFFER_EXT :: GLenum
gl_DRAW_BUFFER_EXT = 0x0C01

gl_DRAW_FRAMEBUFFER :: GLenum
gl_DRAW_FRAMEBUFFER = 0x8CA9

gl_DRAW_FRAMEBUFFER_ANGLE :: GLenum
gl_DRAW_FRAMEBUFFER_ANGLE = 0x8CA9

gl_DRAW_FRAMEBUFFER_APPLE :: GLenum
gl_DRAW_FRAMEBUFFER_APPLE = 0x8CA9

gl_DRAW_FRAMEBUFFER_BINDING :: GLenum
gl_DRAW_FRAMEBUFFER_BINDING = 0x8CA6

gl_DRAW_FRAMEBUFFER_BINDING_ANGLE :: GLenum
gl_DRAW_FRAMEBUFFER_BINDING_ANGLE = 0x8CA6

gl_DRAW_FRAMEBUFFER_BINDING_APPLE :: GLenum
gl_DRAW_FRAMEBUFFER_BINDING_APPLE = 0x8CA6

gl_DRAW_FRAMEBUFFER_BINDING_EXT :: GLenum
gl_DRAW_FRAMEBUFFER_BINDING_EXT = 0x8CA6

gl_DRAW_FRAMEBUFFER_BINDING_NV :: GLenum
gl_DRAW_FRAMEBUFFER_BINDING_NV = 0x8CA6

gl_DRAW_FRAMEBUFFER_EXT :: GLenum
gl_DRAW_FRAMEBUFFER_EXT = 0x8CA9

gl_DRAW_FRAMEBUFFER_NV :: GLenum
gl_DRAW_FRAMEBUFFER_NV = 0x8CA9

gl_DRAW_INDIRECT_ADDRESS_NV :: GLenum
gl_DRAW_INDIRECT_ADDRESS_NV = 0x8F41

gl_DRAW_INDIRECT_BUFFER :: GLenum
gl_DRAW_INDIRECT_BUFFER = 0x8F3F

gl_DRAW_INDIRECT_BUFFER_BINDING :: GLenum
gl_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43

gl_DRAW_INDIRECT_LENGTH_NV :: GLenum
gl_DRAW_INDIRECT_LENGTH_NV = 0x8F42

gl_DRAW_INDIRECT_UNIFIED_NV :: GLenum
gl_DRAW_INDIRECT_UNIFIED_NV = 0x8F40

gl_DRAW_PIXELS_APPLE :: GLenum
gl_DRAW_PIXELS_APPLE = 0x8A0A

gl_DRAW_PIXEL_TOKEN :: GLenum
gl_DRAW_PIXEL_TOKEN = 0x0705

gl_DSDT8_MAG8_INTENSITY8_NV :: GLenum
gl_DSDT8_MAG8_INTENSITY8_NV = 0x870B

gl_DSDT8_MAG8_NV :: GLenum
gl_DSDT8_MAG8_NV = 0x870A

gl_DSDT8_NV :: GLenum
gl_DSDT8_NV = 0x8709

gl_DSDT_MAG_INTENSITY_NV :: GLenum
gl_DSDT_MAG_INTENSITY_NV = 0x86DC

gl_DSDT_MAG_NV :: GLenum
gl_DSDT_MAG_NV = 0x86F6

gl_DSDT_MAG_VIB_NV :: GLenum
gl_DSDT_MAG_VIB_NV = 0x86F7

gl_DSDT_NV :: GLenum
gl_DSDT_NV = 0x86F5

gl_DST_ALPHA :: GLenum
gl_DST_ALPHA = 0x0304

gl_DST_ATOP_NV :: GLenum
gl_DST_ATOP_NV = 0x928F

gl_DST_COLOR :: GLenum
gl_DST_COLOR = 0x0306

gl_DST_IN_NV :: GLenum
gl_DST_IN_NV = 0x928B

gl_DST_NV :: GLenum
gl_DST_NV = 0x9287

gl_DST_OUT_NV :: GLenum
gl_DST_OUT_NV = 0x928D

gl_DST_OVER_NV :: GLenum
gl_DST_OVER_NV = 0x9289

gl_DS_BIAS_NV :: GLenum
gl_DS_BIAS_NV = 0x8716

gl_DS_SCALE_NV :: GLenum
gl_DS_SCALE_NV = 0x8710

gl_DT_BIAS_NV :: GLenum
gl_DT_BIAS_NV = 0x8717

gl_DT_SCALE_NV :: GLenum
gl_DT_SCALE_NV = 0x8711

gl_DU8DV8_ATI :: GLenum
gl_DU8DV8_ATI = 0x877A

gl_DUAL_ALPHA12_SGIS :: GLenum
gl_DUAL_ALPHA12_SGIS = 0x8112

gl_DUAL_ALPHA16_SGIS :: GLenum
gl_DUAL_ALPHA16_SGIS = 0x8113

gl_DUAL_ALPHA4_SGIS :: GLenum
gl_DUAL_ALPHA4_SGIS = 0x8110

gl_DUAL_ALPHA8_SGIS :: GLenum
gl_DUAL_ALPHA8_SGIS = 0x8111

gl_DUAL_INTENSITY12_SGIS :: GLenum
gl_DUAL_INTENSITY12_SGIS = 0x811A

gl_DUAL_INTENSITY16_SGIS :: GLenum
gl_DUAL_INTENSITY16_SGIS = 0x811B

gl_DUAL_INTENSITY4_SGIS :: GLenum
gl_DUAL_INTENSITY4_SGIS = 0x8118

gl_DUAL_INTENSITY8_SGIS :: GLenum
gl_DUAL_INTENSITY8_SGIS = 0x8119

gl_DUAL_LUMINANCE12_SGIS :: GLenum
gl_DUAL_LUMINANCE12_SGIS = 0x8116

gl_DUAL_LUMINANCE16_SGIS :: GLenum
gl_DUAL_LUMINANCE16_SGIS = 0x8117

gl_DUAL_LUMINANCE4_SGIS :: GLenum
gl_DUAL_LUMINANCE4_SGIS = 0x8114

gl_DUAL_LUMINANCE8_SGIS :: GLenum
gl_DUAL_LUMINANCE8_SGIS = 0x8115

gl_DUAL_LUMINANCE_ALPHA4_SGIS :: GLenum
gl_DUAL_LUMINANCE_ALPHA4_SGIS = 0x811C

gl_DUAL_LUMINANCE_ALPHA8_SGIS :: GLenum
gl_DUAL_LUMINANCE_ALPHA8_SGIS = 0x811D

gl_DUAL_TEXTURE_SELECT_SGIS :: GLenum
gl_DUAL_TEXTURE_SELECT_SGIS = 0x8124

gl_DUDV_ATI :: GLenum
gl_DUDV_ATI = 0x8779

gl_DUP_FIRST_CUBIC_CURVE_TO_NV :: GLubyte
gl_DUP_FIRST_CUBIC_CURVE_TO_NV = 0xF2

gl_DUP_LAST_CUBIC_CURVE_TO_NV :: GLubyte
gl_DUP_LAST_CUBIC_CURVE_TO_NV = 0xF4

gl_DYNAMIC_ATI :: GLenum
gl_DYNAMIC_ATI = 0x8761

gl_DYNAMIC_COPY :: GLenum
gl_DYNAMIC_COPY = 0x88EA

gl_DYNAMIC_COPY_ARB :: GLenum
gl_DYNAMIC_COPY_ARB = 0x88EA

gl_DYNAMIC_DRAW :: GLenum
gl_DYNAMIC_DRAW = 0x88E8

gl_DYNAMIC_DRAW_ARB :: GLenum
gl_DYNAMIC_DRAW_ARB = 0x88E8

gl_DYNAMIC_READ :: GLenum
gl_DYNAMIC_READ = 0x88E9

gl_DYNAMIC_READ_ARB :: GLenum
gl_DYNAMIC_READ_ARB = 0x88E9

gl_DYNAMIC_STORAGE_BIT :: GLbitfield
gl_DYNAMIC_STORAGE_BIT = 0x0100

gl_EDGEFLAG_BIT_PGI :: GLbitfield
gl_EDGEFLAG_BIT_PGI = 0x00040000

gl_EDGE_FLAG :: GLenum
gl_EDGE_FLAG = 0x0B43

gl_EDGE_FLAG_ARRAY :: GLenum
gl_EDGE_FLAG_ARRAY = 0x8079

gl_EDGE_FLAG_ARRAY_ADDRESS_NV :: GLenum
gl_EDGE_FLAG_ARRAY_ADDRESS_NV = 0x8F26

gl_EDGE_FLAG_ARRAY_BUFFER_BINDING :: GLenum
gl_EDGE_FLAG_ARRAY_BUFFER_BINDING = 0x889B

gl_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = 0x889B

gl_EDGE_FLAG_ARRAY_COUNT_EXT :: GLenum
gl_EDGE_FLAG_ARRAY_COUNT_EXT = 0x808D

gl_EDGE_FLAG_ARRAY_EXT :: GLenum
gl_EDGE_FLAG_ARRAY_EXT = 0x8079

gl_EDGE_FLAG_ARRAY_LENGTH_NV :: GLenum
gl_EDGE_FLAG_ARRAY_LENGTH_NV = 0x8F30

gl_EDGE_FLAG_ARRAY_LIST_IBM :: GLenum
gl_EDGE_FLAG_ARRAY_LIST_IBM = 103075

gl_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM :: GLenum
gl_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM = 103085

gl_EDGE_FLAG_ARRAY_POINTER :: GLenum
gl_EDGE_FLAG_ARRAY_POINTER = 0x8093

gl_EDGE_FLAG_ARRAY_POINTER_EXT :: GLenum
gl_EDGE_FLAG_ARRAY_POINTER_EXT = 0x8093

gl_EDGE_FLAG_ARRAY_STRIDE :: GLenum
gl_EDGE_FLAG_ARRAY_STRIDE = 0x808C

gl_EDGE_FLAG_ARRAY_STRIDE_EXT :: GLenum
gl_EDGE_FLAG_ARRAY_STRIDE_EXT = 0x808C

gl_EFFECTIVE_RASTER_SAMPLES_EXT :: GLenum
gl_EFFECTIVE_RASTER_SAMPLES_EXT = 0x932C

gl_EIGHTH_BIT_ATI :: GLbitfield
gl_EIGHTH_BIT_ATI = 0x00000020

gl_ELEMENT_ARRAY_ADDRESS_NV :: GLenum
gl_ELEMENT_ARRAY_ADDRESS_NV = 0x8F29

gl_ELEMENT_ARRAY_APPLE :: GLenum
gl_ELEMENT_ARRAY_APPLE = 0x8A0C

gl_ELEMENT_ARRAY_ATI :: GLenum
gl_ELEMENT_ARRAY_ATI = 0x8768

gl_ELEMENT_ARRAY_BARRIER_BIT :: GLbitfield
gl_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002

gl_ELEMENT_ARRAY_BARRIER_BIT_EXT :: GLbitfield
gl_ELEMENT_ARRAY_BARRIER_BIT_EXT = 0x00000002

gl_ELEMENT_ARRAY_BUFFER :: GLenum
gl_ELEMENT_ARRAY_BUFFER = 0x8893

gl_ELEMENT_ARRAY_BUFFER_ARB :: GLenum
gl_ELEMENT_ARRAY_BUFFER_ARB = 0x8893

gl_ELEMENT_ARRAY_BUFFER_BINDING :: GLenum
gl_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895

gl_ELEMENT_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_ELEMENT_ARRAY_BUFFER_BINDING_ARB = 0x8895

gl_ELEMENT_ARRAY_LENGTH_NV :: GLenum
gl_ELEMENT_ARRAY_LENGTH_NV = 0x8F33

gl_ELEMENT_ARRAY_POINTER_APPLE :: GLenum
gl_ELEMENT_ARRAY_POINTER_APPLE = 0x8A0E

gl_ELEMENT_ARRAY_POINTER_ATI :: GLenum
gl_ELEMENT_ARRAY_POINTER_ATI = 0x876A

gl_ELEMENT_ARRAY_TYPE_APPLE :: GLenum
gl_ELEMENT_ARRAY_TYPE_APPLE = 0x8A0D

gl_ELEMENT_ARRAY_TYPE_ATI :: GLenum
gl_ELEMENT_ARRAY_TYPE_ATI = 0x8769

gl_ELEMENT_ARRAY_UNIFIED_NV :: GLenum
gl_ELEMENT_ARRAY_UNIFIED_NV = 0x8F1F

gl_EMBOSS_CONSTANT_NV :: GLenum
gl_EMBOSS_CONSTANT_NV = 0x855E

gl_EMBOSS_LIGHT_NV :: GLenum
gl_EMBOSS_LIGHT_NV = 0x855D

gl_EMBOSS_MAP_NV :: GLenum
gl_EMBOSS_MAP_NV = 0x855F

gl_EMISSION :: GLenum
gl_EMISSION = 0x1600

gl_ENABLE_BIT :: GLbitfield
gl_ENABLE_BIT = 0x00002000

gl_EQUAL :: GLenum
gl_EQUAL = 0x0202

gl_EQUIV :: GLenum
gl_EQUIV = 0x1509

gl_ETC1_RGB8_OES :: GLenum
gl_ETC1_RGB8_OES = 0x8D64

gl_ETC1_SRGB8_NV :: GLenum
gl_ETC1_SRGB8_NV = 0x88EE

gl_EVAL_2D_NV :: GLenum
gl_EVAL_2D_NV = 0x86C0

gl_EVAL_BIT :: GLbitfield
gl_EVAL_BIT = 0x00010000

gl_EVAL_FRACTIONAL_TESSELLATION_NV :: GLenum
gl_EVAL_FRACTIONAL_TESSELLATION_NV = 0x86C5

gl_EVAL_TRIANGULAR_2D_NV :: GLenum
gl_EVAL_TRIANGULAR_2D_NV = 0x86C1

gl_EVAL_VERTEX_ATTRIB0_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB0_NV = 0x86C6

gl_EVAL_VERTEX_ATTRIB10_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB10_NV = 0x86D0

gl_EVAL_VERTEX_ATTRIB11_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB11_NV = 0x86D1

gl_EVAL_VERTEX_ATTRIB12_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB12_NV = 0x86D2

gl_EVAL_VERTEX_ATTRIB13_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB13_NV = 0x86D3

gl_EVAL_VERTEX_ATTRIB14_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB14_NV = 0x86D4

gl_EVAL_VERTEX_ATTRIB15_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB15_NV = 0x86D5

gl_EVAL_VERTEX_ATTRIB1_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB1_NV = 0x86C7

gl_EVAL_VERTEX_ATTRIB2_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB2_NV = 0x86C8

gl_EVAL_VERTEX_ATTRIB3_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB3_NV = 0x86C9

gl_EVAL_VERTEX_ATTRIB4_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB4_NV = 0x86CA

gl_EVAL_VERTEX_ATTRIB5_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB5_NV = 0x86CB

gl_EVAL_VERTEX_ATTRIB6_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB6_NV = 0x86CC

gl_EVAL_VERTEX_ATTRIB7_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB7_NV = 0x86CD

gl_EVAL_VERTEX_ATTRIB8_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB8_NV = 0x86CE

gl_EVAL_VERTEX_ATTRIB9_NV :: GLenum
gl_EVAL_VERTEX_ATTRIB9_NV = 0x86CF

gl_EXCLUSION_KHR :: GLenum
gl_EXCLUSION_KHR = 0x92A0

gl_EXCLUSION_NV :: GLenum
gl_EXCLUSION_NV = 0x92A0

gl_EXP :: GLenum
gl_EXP = 0x0800

gl_EXP2 :: GLenum
gl_EXP2 = 0x0801

gl_EXPAND_NEGATE_NV :: GLenum
gl_EXPAND_NEGATE_NV = 0x8539

gl_EXPAND_NORMAL_NV :: GLenum
gl_EXPAND_NORMAL_NV = 0x8538

gl_EXTENSIONS :: GLenum
gl_EXTENSIONS = 0x1F03

gl_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD :: GLenum
gl_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD = 0x9160

gl_EYE_DISTANCE_TO_LINE_SGIS :: GLenum
gl_EYE_DISTANCE_TO_LINE_SGIS = 0x81F2

gl_EYE_DISTANCE_TO_POINT_SGIS :: GLenum
gl_EYE_DISTANCE_TO_POINT_SGIS = 0x81F0

gl_EYE_LINEAR :: GLenum
gl_EYE_LINEAR = 0x2400

gl_EYE_LINEAR_NV :: GLenum
gl_EYE_LINEAR_NV = 0x2400

gl_EYE_LINE_SGIS :: GLenum
gl_EYE_LINE_SGIS = 0x81F6

gl_EYE_PLANE :: GLenum
gl_EYE_PLANE = 0x2502

gl_EYE_PLANE_ABSOLUTE_NV :: GLenum
gl_EYE_PLANE_ABSOLUTE_NV = 0x855C

gl_EYE_POINT_SGIS :: GLenum
gl_EYE_POINT_SGIS = 0x81F4

gl_EYE_RADIAL_NV :: GLenum
gl_EYE_RADIAL_NV = 0x855B

gl_E_TIMES_F_NV :: GLenum
gl_E_TIMES_F_NV = 0x8531

gl_FACTOR_ALPHA_MODULATE_IMG :: GLenum
gl_FACTOR_ALPHA_MODULATE_IMG = 0x8C07

gl_FACTOR_MAX_AMD :: GLenum
gl_FACTOR_MAX_AMD = 0x901D

gl_FACTOR_MIN_AMD :: GLenum
gl_FACTOR_MIN_AMD = 0x901C

gl_FAILURE_NV :: GLenum
gl_FAILURE_NV = 0x9030

gl_FALSE :: GLenum
gl_FALSE = 0

gl_FASTEST :: GLenum
gl_FASTEST = 0x1101

gl_FEEDBACK :: GLenum
gl_FEEDBACK = 0x1C01

gl_FEEDBACK_BUFFER_POINTER :: GLenum
gl_FEEDBACK_BUFFER_POINTER = 0x0DF0

gl_FEEDBACK_BUFFER_SIZE :: GLenum
gl_FEEDBACK_BUFFER_SIZE = 0x0DF1

gl_FEEDBACK_BUFFER_TYPE :: GLenum
gl_FEEDBACK_BUFFER_TYPE = 0x0DF2

gl_FENCE_APPLE :: GLenum
gl_FENCE_APPLE = 0x8A0B

gl_FENCE_CONDITION_NV :: GLenum
gl_FENCE_CONDITION_NV = 0x84F4

gl_FENCE_STATUS_NV :: GLenum
gl_FENCE_STATUS_NV = 0x84F3

gl_FETCH_PER_SAMPLE_ARM :: GLenum
gl_FETCH_PER_SAMPLE_ARM = 0x8F65

gl_FIELDS_NV :: GLenum
gl_FIELDS_NV = 0x8E27

gl_FIELD_LOWER_NV :: GLenum
gl_FIELD_LOWER_NV = 0x9023

gl_FIELD_UPPER_NV :: GLenum
gl_FIELD_UPPER_NV = 0x9022

gl_FILE_NAME_NV :: GLenum
gl_FILE_NAME_NV = 0x9074

gl_FILL :: GLenum
gl_FILL = 0x1B02

gl_FILL_RECTANGLE_NV :: GLenum
gl_FILL_RECTANGLE_NV = 0x933C

gl_FILTER :: GLenum
gl_FILTER = 0x829A

gl_FILTER4_SGIS :: GLenum
gl_FILTER4_SGIS = 0x8146

gl_FIRST_TO_REST_NV :: GLenum
gl_FIRST_TO_REST_NV = 0x90AF

gl_FIRST_VERTEX_CONVENTION :: GLenum
gl_FIRST_VERTEX_CONVENTION = 0x8E4D

gl_FIRST_VERTEX_CONVENTION_EXT :: GLenum
gl_FIRST_VERTEX_CONVENTION_EXT = 0x8E4D

gl_FIRST_VERTEX_CONVENTION_OES :: GLenum
gl_FIRST_VERTEX_CONVENTION_OES = 0x8E4D

gl_FIXED :: GLenum
gl_FIXED = 0x140C

gl_FIXED_OES :: GLenum
gl_FIXED_OES = 0x140C

gl_FIXED_ONLY :: GLenum
gl_FIXED_ONLY = 0x891D

gl_FIXED_ONLY_ARB :: GLenum
gl_FIXED_ONLY_ARB = 0x891D

gl_FLAT :: GLenum
gl_FLAT = 0x1D00

gl_FLOAT :: GLenum
gl_FLOAT = 0x1406

gl_FLOAT16_NV :: GLenum
gl_FLOAT16_NV = 0x8FF8

gl_FLOAT16_VEC2_NV :: GLenum
gl_FLOAT16_VEC2_NV = 0x8FF9

gl_FLOAT16_VEC3_NV :: GLenum
gl_FLOAT16_VEC3_NV = 0x8FFA

gl_FLOAT16_VEC4_NV :: GLenum
gl_FLOAT16_VEC4_NV = 0x8FFB

gl_FLOAT_32_UNSIGNED_INT_24_8_REV :: GLenum
gl_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD

gl_FLOAT_32_UNSIGNED_INT_24_8_REV_NV :: GLenum
gl_FLOAT_32_UNSIGNED_INT_24_8_REV_NV = 0x8DAD

gl_FLOAT_CLEAR_COLOR_VALUE_NV :: GLenum
gl_FLOAT_CLEAR_COLOR_VALUE_NV = 0x888D

gl_FLOAT_MAT2 :: GLenum
gl_FLOAT_MAT2 = 0x8B5A

gl_FLOAT_MAT2_ARB :: GLenum
gl_FLOAT_MAT2_ARB = 0x8B5A

gl_FLOAT_MAT2x3 :: GLenum
gl_FLOAT_MAT2x3 = 0x8B65

gl_FLOAT_MAT2x3_NV :: GLenum
gl_FLOAT_MAT2x3_NV = 0x8B65

gl_FLOAT_MAT2x4 :: GLenum
gl_FLOAT_MAT2x4 = 0x8B66

gl_FLOAT_MAT2x4_NV :: GLenum
gl_FLOAT_MAT2x4_NV = 0x8B66

gl_FLOAT_MAT3 :: GLenum
gl_FLOAT_MAT3 = 0x8B5B

gl_FLOAT_MAT3_ARB :: GLenum
gl_FLOAT_MAT3_ARB = 0x8B5B

gl_FLOAT_MAT3x2 :: GLenum
gl_FLOAT_MAT3x2 = 0x8B67

gl_FLOAT_MAT3x2_NV :: GLenum
gl_FLOAT_MAT3x2_NV = 0x8B67

gl_FLOAT_MAT3x4 :: GLenum
gl_FLOAT_MAT3x4 = 0x8B68

gl_FLOAT_MAT3x4_NV :: GLenum
gl_FLOAT_MAT3x4_NV = 0x8B68

gl_FLOAT_MAT4 :: GLenum
gl_FLOAT_MAT4 = 0x8B5C

gl_FLOAT_MAT4_ARB :: GLenum
gl_FLOAT_MAT4_ARB = 0x8B5C

gl_FLOAT_MAT4x2 :: GLenum
gl_FLOAT_MAT4x2 = 0x8B69

gl_FLOAT_MAT4x2_NV :: GLenum
gl_FLOAT_MAT4x2_NV = 0x8B69

gl_FLOAT_MAT4x3 :: GLenum
gl_FLOAT_MAT4x3 = 0x8B6A

gl_FLOAT_MAT4x3_NV :: GLenum
gl_FLOAT_MAT4x3_NV = 0x8B6A

gl_FLOAT_R16_NV :: GLenum
gl_FLOAT_R16_NV = 0x8884

gl_FLOAT_R32_NV :: GLenum
gl_FLOAT_R32_NV = 0x8885

gl_FLOAT_RG16_NV :: GLenum
gl_FLOAT_RG16_NV = 0x8886

gl_FLOAT_RG32_NV :: GLenum
gl_FLOAT_RG32_NV = 0x8887

gl_FLOAT_RGB16_NV :: GLenum
gl_FLOAT_RGB16_NV = 0x8888

gl_FLOAT_RGB32_NV :: GLenum
gl_FLOAT_RGB32_NV = 0x8889

gl_FLOAT_RGBA16_NV :: GLenum
gl_FLOAT_RGBA16_NV = 0x888A

gl_FLOAT_RGBA32_NV :: GLenum
gl_FLOAT_RGBA32_NV = 0x888B

gl_FLOAT_RGBA_MODE_NV :: GLenum
gl_FLOAT_RGBA_MODE_NV = 0x888E

gl_FLOAT_RGBA_NV :: GLenum
gl_FLOAT_RGBA_NV = 0x8883

gl_FLOAT_RGB_NV :: GLenum
gl_FLOAT_RGB_NV = 0x8882

gl_FLOAT_RG_NV :: GLenum
gl_FLOAT_RG_NV = 0x8881

gl_FLOAT_R_NV :: GLenum
gl_FLOAT_R_NV = 0x8880

gl_FLOAT_VEC2 :: GLenum
gl_FLOAT_VEC2 = 0x8B50

gl_FLOAT_VEC2_ARB :: GLenum
gl_FLOAT_VEC2_ARB = 0x8B50

gl_FLOAT_VEC3 :: GLenum
gl_FLOAT_VEC3 = 0x8B51

gl_FLOAT_VEC3_ARB :: GLenum
gl_FLOAT_VEC3_ARB = 0x8B51

gl_FLOAT_VEC4 :: GLenum
gl_FLOAT_VEC4 = 0x8B52

gl_FLOAT_VEC4_ARB :: GLenum
gl_FLOAT_VEC4_ARB = 0x8B52

gl_FOG :: GLenum
gl_FOG = 0x0B60

gl_FOG_BIT :: GLbitfield
gl_FOG_BIT = 0x00000080

gl_FOG_COLOR :: GLenum
gl_FOG_COLOR = 0x0B66

gl_FOG_COORD :: GLenum
gl_FOG_COORD = 0x8451

gl_FOG_COORDINATE :: GLenum
gl_FOG_COORDINATE = 0x8451

gl_FOG_COORDINATE_ARRAY :: GLenum
gl_FOG_COORDINATE_ARRAY = 0x8457

gl_FOG_COORDINATE_ARRAY_BUFFER_BINDING :: GLenum
gl_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 0x889D

gl_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = 0x889D

gl_FOG_COORDINATE_ARRAY_EXT :: GLenum
gl_FOG_COORDINATE_ARRAY_EXT = 0x8457

gl_FOG_COORDINATE_ARRAY_LIST_IBM :: GLenum
gl_FOG_COORDINATE_ARRAY_LIST_IBM = 103076

gl_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM :: GLenum
gl_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM = 103086

gl_FOG_COORDINATE_ARRAY_POINTER :: GLenum
gl_FOG_COORDINATE_ARRAY_POINTER = 0x8456

gl_FOG_COORDINATE_ARRAY_POINTER_EXT :: GLenum
gl_FOG_COORDINATE_ARRAY_POINTER_EXT = 0x8456

gl_FOG_COORDINATE_ARRAY_STRIDE :: GLenum
gl_FOG_COORDINATE_ARRAY_STRIDE = 0x8455

gl_FOG_COORDINATE_ARRAY_STRIDE_EXT :: GLenum
gl_FOG_COORDINATE_ARRAY_STRIDE_EXT = 0x8455

gl_FOG_COORDINATE_ARRAY_TYPE :: GLenum
gl_FOG_COORDINATE_ARRAY_TYPE = 0x8454

gl_FOG_COORDINATE_ARRAY_TYPE_EXT :: GLenum
gl_FOG_COORDINATE_ARRAY_TYPE_EXT = 0x8454

gl_FOG_COORDINATE_EXT :: GLenum
gl_FOG_COORDINATE_EXT = 0x8451

gl_FOG_COORDINATE_SOURCE :: GLenum
gl_FOG_COORDINATE_SOURCE = 0x8450

gl_FOG_COORDINATE_SOURCE_EXT :: GLenum
gl_FOG_COORDINATE_SOURCE_EXT = 0x8450

gl_FOG_COORD_ARRAY :: GLenum
gl_FOG_COORD_ARRAY = 0x8457

gl_FOG_COORD_ARRAY_ADDRESS_NV :: GLenum
gl_FOG_COORD_ARRAY_ADDRESS_NV = 0x8F28

gl_FOG_COORD_ARRAY_BUFFER_BINDING :: GLenum
gl_FOG_COORD_ARRAY_BUFFER_BINDING = 0x889D

gl_FOG_COORD_ARRAY_LENGTH_NV :: GLenum
gl_FOG_COORD_ARRAY_LENGTH_NV = 0x8F32

gl_FOG_COORD_ARRAY_POINTER :: GLenum
gl_FOG_COORD_ARRAY_POINTER = 0x8456

gl_FOG_COORD_ARRAY_STRIDE :: GLenum
gl_FOG_COORD_ARRAY_STRIDE = 0x8455

gl_FOG_COORD_ARRAY_TYPE :: GLenum
gl_FOG_COORD_ARRAY_TYPE = 0x8454

gl_FOG_COORD_SRC :: GLenum
gl_FOG_COORD_SRC = 0x8450

gl_FOG_DENSITY :: GLenum
gl_FOG_DENSITY = 0x0B62

gl_FOG_DISTANCE_MODE_NV :: GLenum
gl_FOG_DISTANCE_MODE_NV = 0x855A

gl_FOG_END :: GLenum
gl_FOG_END = 0x0B64

gl_FOG_FUNC_POINTS_SGIS :: GLenum
gl_FOG_FUNC_POINTS_SGIS = 0x812B

gl_FOG_FUNC_SGIS :: GLenum
gl_FOG_FUNC_SGIS = 0x812A

gl_FOG_HINT :: GLenum
gl_FOG_HINT = 0x0C54

gl_FOG_INDEX :: GLenum
gl_FOG_INDEX = 0x0B61

gl_FOG_MODE :: GLenum
gl_FOG_MODE = 0x0B65

gl_FOG_OFFSET_SGIX :: GLenum
gl_FOG_OFFSET_SGIX = 0x8198

gl_FOG_OFFSET_VALUE_SGIX :: GLenum
gl_FOG_OFFSET_VALUE_SGIX = 0x8199

gl_FOG_SPECULAR_TEXTURE_WIN :: GLenum
gl_FOG_SPECULAR_TEXTURE_WIN = 0x80EC

gl_FOG_START :: GLenum
gl_FOG_START = 0x0B63

gl_FONT_ASCENDER_BIT_NV :: GLbitfield
gl_FONT_ASCENDER_BIT_NV = 0x00200000

gl_FONT_DESCENDER_BIT_NV :: GLbitfield
gl_FONT_DESCENDER_BIT_NV = 0x00400000

gl_FONT_GLYPHS_AVAILABLE_NV :: GLenum
gl_FONT_GLYPHS_AVAILABLE_NV = 0x9368

gl_FONT_HAS_KERNING_BIT_NV :: GLbitfield
gl_FONT_HAS_KERNING_BIT_NV = 0x10000000

gl_FONT_HEIGHT_BIT_NV :: GLbitfield
gl_FONT_HEIGHT_BIT_NV = 0x00800000

gl_FONT_MAX_ADVANCE_HEIGHT_BIT_NV :: GLbitfield
gl_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = 0x02000000

gl_FONT_MAX_ADVANCE_WIDTH_BIT_NV :: GLbitfield
gl_FONT_MAX_ADVANCE_WIDTH_BIT_NV = 0x01000000

gl_FONT_NUM_GLYPH_INDICES_BIT_NV :: GLbitfield
gl_FONT_NUM_GLYPH_INDICES_BIT_NV = 0x20000000

gl_FONT_TARGET_UNAVAILABLE_NV :: GLenum
gl_FONT_TARGET_UNAVAILABLE_NV = 0x9369

gl_FONT_UNAVAILABLE_NV :: GLenum
gl_FONT_UNAVAILABLE_NV = 0x936A

gl_FONT_UNDERLINE_POSITION_BIT_NV :: GLbitfield
gl_FONT_UNDERLINE_POSITION_BIT_NV = 0x04000000

gl_FONT_UNDERLINE_THICKNESS_BIT_NV :: GLbitfield
gl_FONT_UNDERLINE_THICKNESS_BIT_NV = 0x08000000

gl_FONT_UNINTELLIGIBLE_NV :: GLenum
gl_FONT_UNINTELLIGIBLE_NV = 0x936B

gl_FONT_UNITS_PER_EM_BIT_NV :: GLbitfield
gl_FONT_UNITS_PER_EM_BIT_NV = 0x00100000

gl_FONT_X_MAX_BOUNDS_BIT_NV :: GLbitfield
gl_FONT_X_MAX_BOUNDS_BIT_NV = 0x00040000

gl_FONT_X_MIN_BOUNDS_BIT_NV :: GLbitfield
gl_FONT_X_MIN_BOUNDS_BIT_NV = 0x00010000

gl_FONT_Y_MAX_BOUNDS_BIT_NV :: GLbitfield
gl_FONT_Y_MAX_BOUNDS_BIT_NV = 0x00080000

gl_FONT_Y_MIN_BOUNDS_BIT_NV :: GLbitfield
gl_FONT_Y_MIN_BOUNDS_BIT_NV = 0x00020000

gl_FORCE_BLUE_TO_ONE_NV :: GLenum
gl_FORCE_BLUE_TO_ONE_NV = 0x8860

gl_FORMAT_SUBSAMPLE_244_244_OML :: GLenum
gl_FORMAT_SUBSAMPLE_244_244_OML = 0x8983

gl_FORMAT_SUBSAMPLE_24_24_OML :: GLenum
gl_FORMAT_SUBSAMPLE_24_24_OML = 0x8982

gl_FRACTIONAL_EVEN :: GLenum
gl_FRACTIONAL_EVEN = 0x8E7C

gl_FRACTIONAL_EVEN_EXT :: GLenum
gl_FRACTIONAL_EVEN_EXT = 0x8E7C

gl_FRACTIONAL_EVEN_OES :: GLenum
gl_FRACTIONAL_EVEN_OES = 0x8E7C

gl_FRACTIONAL_ODD :: GLenum
gl_FRACTIONAL_ODD = 0x8E7B

gl_FRACTIONAL_ODD_EXT :: GLenum
gl_FRACTIONAL_ODD_EXT = 0x8E7B

gl_FRACTIONAL_ODD_OES :: GLenum
gl_FRACTIONAL_ODD_OES = 0x8E7B

gl_FRAGMENTS_INSTRUMENT_COUNTERS_SGIX :: GLenum
gl_FRAGMENTS_INSTRUMENT_COUNTERS_SGIX = 0x8314

gl_FRAGMENTS_INSTRUMENT_MAX_SGIX :: GLenum
gl_FRAGMENTS_INSTRUMENT_MAX_SGIX = 0x8315

gl_FRAGMENTS_INSTRUMENT_SGIX :: GLenum
gl_FRAGMENTS_INSTRUMENT_SGIX = 0x8313

gl_FRAGMENT_ALPHA_MODULATE_IMG :: GLenum
gl_FRAGMENT_ALPHA_MODULATE_IMG = 0x8C08

gl_FRAGMENT_COLOR_EXT :: GLenum
gl_FRAGMENT_COLOR_EXT = 0x834C

gl_FRAGMENT_COLOR_MATERIAL_FACE_SGIX :: GLenum
gl_FRAGMENT_COLOR_MATERIAL_FACE_SGIX = 0x8402

gl_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX :: GLenum
gl_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX = 0x8403

gl_FRAGMENT_COLOR_MATERIAL_SGIX :: GLenum
gl_FRAGMENT_COLOR_MATERIAL_SGIX = 0x8401

gl_FRAGMENT_COVERAGE_COLOR_NV :: GLenum
gl_FRAGMENT_COVERAGE_COLOR_NV = 0x92DE

gl_FRAGMENT_COVERAGE_TO_COLOR_NV :: GLenum
gl_FRAGMENT_COVERAGE_TO_COLOR_NV = 0x92DD

gl_FRAGMENT_DEPTH :: GLenum
gl_FRAGMENT_DEPTH = 0x8452

gl_FRAGMENT_DEPTH_EXT :: GLenum
gl_FRAGMENT_DEPTH_EXT = 0x8452

gl_FRAGMENT_INPUT_NV :: GLenum
gl_FRAGMENT_INPUT_NV = 0x936D

gl_FRAGMENT_INTERPOLATION_OFFSET_BITS :: GLenum
gl_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D

gl_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES :: GLenum
gl_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES = 0x8E5D

gl_FRAGMENT_LIGHT0_SGIX :: GLenum
gl_FRAGMENT_LIGHT0_SGIX = 0x840C

gl_FRAGMENT_LIGHT1_SGIX :: GLenum
gl_FRAGMENT_LIGHT1_SGIX = 0x840D

gl_FRAGMENT_LIGHT2_SGIX :: GLenum
gl_FRAGMENT_LIGHT2_SGIX = 0x840E

gl_FRAGMENT_LIGHT3_SGIX :: GLenum
gl_FRAGMENT_LIGHT3_SGIX = 0x840F

gl_FRAGMENT_LIGHT4_SGIX :: GLenum
gl_FRAGMENT_LIGHT4_SGIX = 0x8410

gl_FRAGMENT_LIGHT5_SGIX :: GLenum
gl_FRAGMENT_LIGHT5_SGIX = 0x8411

gl_FRAGMENT_LIGHT6_SGIX :: GLenum
gl_FRAGMENT_LIGHT6_SGIX = 0x8412

gl_FRAGMENT_LIGHT7_SGIX :: GLenum
gl_FRAGMENT_LIGHT7_SGIX = 0x8413

gl_FRAGMENT_LIGHTING_SGIX :: GLenum
gl_FRAGMENT_LIGHTING_SGIX = 0x8400

gl_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX :: GLenum
gl_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = 0x840A

gl_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX :: GLenum
gl_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = 0x8408

gl_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX :: GLenum
gl_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = 0x840B

gl_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX :: GLenum
gl_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = 0x8409

gl_FRAGMENT_MATERIAL_EXT :: GLenum
gl_FRAGMENT_MATERIAL_EXT = 0x8349

gl_FRAGMENT_NORMAL_EXT :: GLenum
gl_FRAGMENT_NORMAL_EXT = 0x834A

gl_FRAGMENT_PROGRAM_ARB :: GLenum
gl_FRAGMENT_PROGRAM_ARB = 0x8804

gl_FRAGMENT_PROGRAM_BINDING_NV :: GLenum
gl_FRAGMENT_PROGRAM_BINDING_NV = 0x8873

gl_FRAGMENT_PROGRAM_CALLBACK_DATA_MESA :: GLenum
gl_FRAGMENT_PROGRAM_CALLBACK_DATA_MESA = 0x8BB3

gl_FRAGMENT_PROGRAM_CALLBACK_FUNC_MESA :: GLenum
gl_FRAGMENT_PROGRAM_CALLBACK_FUNC_MESA = 0x8BB2

gl_FRAGMENT_PROGRAM_CALLBACK_MESA :: GLenum
gl_FRAGMENT_PROGRAM_CALLBACK_MESA = 0x8BB1

gl_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV :: GLenum
gl_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV = 0x8E5D

gl_FRAGMENT_PROGRAM_NV :: GLenum
gl_FRAGMENT_PROGRAM_NV = 0x8870

gl_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV :: GLenum
gl_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA4

gl_FRAGMENT_PROGRAM_POSITION_MESA :: GLenum
gl_FRAGMENT_PROGRAM_POSITION_MESA = 0x8BB0

gl_FRAGMENT_SHADER :: GLenum
gl_FRAGMENT_SHADER = 0x8B30

gl_FRAGMENT_SHADER_ARB :: GLenum
gl_FRAGMENT_SHADER_ARB = 0x8B30

gl_FRAGMENT_SHADER_ATI :: GLenum
gl_FRAGMENT_SHADER_ATI = 0x8920

gl_FRAGMENT_SHADER_BIT :: GLbitfield
gl_FRAGMENT_SHADER_BIT = 0x00000002

gl_FRAGMENT_SHADER_BIT_EXT :: GLbitfield
gl_FRAGMENT_SHADER_BIT_EXT = 0x00000002

gl_FRAGMENT_SHADER_DERIVATIVE_HINT :: GLenum
gl_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B

gl_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB :: GLenum
gl_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = 0x8B8B

gl_FRAGMENT_SHADER_DERIVATIVE_HINT_OES :: GLenum
gl_FRAGMENT_SHADER_DERIVATIVE_HINT_OES = 0x8B8B

gl_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT :: GLenum
gl_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT = 0x8A52

gl_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM :: GLenum
gl_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM = 0x8F66

gl_FRAGMENT_SHADER_INVOCATIONS_ARB :: GLenum
gl_FRAGMENT_SHADER_INVOCATIONS_ARB = 0x82F4

gl_FRAGMENT_SUBROUTINE :: GLenum
gl_FRAGMENT_SUBROUTINE = 0x92EC

gl_FRAGMENT_SUBROUTINE_UNIFORM :: GLenum
gl_FRAGMENT_SUBROUTINE_UNIFORM = 0x92F2

gl_FRAGMENT_TEXTURE :: GLenum
gl_FRAGMENT_TEXTURE = 0x829F

gl_FRAMEBUFFER :: GLenum
gl_FRAMEBUFFER = 0x8D40

gl_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215

gl_FRAMEBUFFER_ATTACHMENT_ANGLE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_ANGLE = 0x93A3

gl_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214

gl_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210

gl_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT = 0x8210

gl_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211

gl_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT = 0x8211

gl_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216

gl_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213

gl_FRAMEBUFFER_ATTACHMENT_LAYERED :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_LAYERED = 0x8DA7

gl_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = 0x8DA7

gl_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT = 0x8DA7

gl_FRAMEBUFFER_ATTACHMENT_LAYERED_OES :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_LAYERED_OES = 0x8DA7

gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1

gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = 0x8CD1

gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES = 0x8CD1

gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0

gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = 0x8CD0

gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES = 0x8CD0

gl_FRAMEBUFFER_ATTACHMENT_RED_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212

gl_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = 0x8CD4

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES = 0x8CD4

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = 0x8CD3

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES = 0x8CD3

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT = 0x8CD4

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = 0x8CD2

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES = 0x8CD2

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT = 0x8D6C

gl_FRAMEBUFFER_BARRIER_BIT :: GLbitfield
gl_FRAMEBUFFER_BARRIER_BIT = 0x00000400

gl_FRAMEBUFFER_BARRIER_BIT_EXT :: GLbitfield
gl_FRAMEBUFFER_BARRIER_BIT_EXT = 0x00000400

gl_FRAMEBUFFER_BINDING :: GLenum
gl_FRAMEBUFFER_BINDING = 0x8CA6

gl_FRAMEBUFFER_BINDING_ANGLE :: GLenum
gl_FRAMEBUFFER_BINDING_ANGLE = 0x8CA6

gl_FRAMEBUFFER_BINDING_EXT :: GLenum
gl_FRAMEBUFFER_BINDING_EXT = 0x8CA6

gl_FRAMEBUFFER_BINDING_OES :: GLenum
gl_FRAMEBUFFER_BINDING_OES = 0x8CA6

gl_FRAMEBUFFER_BLEND :: GLenum
gl_FRAMEBUFFER_BLEND = 0x828B

gl_FRAMEBUFFER_COMPLETE :: GLenum
gl_FRAMEBUFFER_COMPLETE = 0x8CD5

gl_FRAMEBUFFER_COMPLETE_EXT :: GLenum
gl_FRAMEBUFFER_COMPLETE_EXT = 0x8CD5

gl_FRAMEBUFFER_COMPLETE_OES :: GLenum
gl_FRAMEBUFFER_COMPLETE_OES = 0x8CD5

gl_FRAMEBUFFER_DEFAULT :: GLenum
gl_FRAMEBUFFER_DEFAULT = 0x8218

gl_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS :: GLenum
gl_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 0x9314

gl_FRAMEBUFFER_DEFAULT_HEIGHT :: GLenum
gl_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311

gl_FRAMEBUFFER_DEFAULT_LAYERS :: GLenum
gl_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312

gl_FRAMEBUFFER_DEFAULT_LAYERS_EXT :: GLenum
gl_FRAMEBUFFER_DEFAULT_LAYERS_EXT = 0x9312

gl_FRAMEBUFFER_DEFAULT_LAYERS_OES :: GLenum
gl_FRAMEBUFFER_DEFAULT_LAYERS_OES = 0x9312

gl_FRAMEBUFFER_DEFAULT_SAMPLES :: GLenum
gl_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313

gl_FRAMEBUFFER_DEFAULT_WIDTH :: GLenum
gl_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310

gl_FRAMEBUFFER_EXT :: GLenum
gl_FRAMEBUFFER_EXT = 0x8D40

gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6

gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = 0x8CD6

gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES = 0x8CD6

gl_FRAMEBUFFER_INCOMPLETE_DIMENSIONS :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 0x8CD9

gl_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = 0x8CD9

gl_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES = 0x8CD9

gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB

gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = 0x8CDB

gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_OES :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_OES = 0x8CDB

gl_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = 0x8CDA

gl_FRAMEBUFFER_INCOMPLETE_FORMATS_OES :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_FORMATS_OES = 0x8CDA

gl_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = 0x8DA9

gl_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT = 0x8DA9

gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 0x8DA8

gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB = 0x8DA8

gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT = 0x8DA8

gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES = 0x8DA8

gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7

gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = 0x8CD7

gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES = 0x8CD7

gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56

gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE = 0x8D56

gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE = 0x8D56

gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT = 0x8D56

gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG = 0x9134

gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV = 0x8D56

gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC

gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = 0x8CDC

gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_OES :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_OES = 0x8CDC

gl_FRAMEBUFFER_OES :: GLenum
gl_FRAMEBUFFER_OES = 0x8D40

gl_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV :: GLenum
gl_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV = 0x9342

gl_FRAMEBUFFER_RENDERABLE :: GLenum
gl_FRAMEBUFFER_RENDERABLE = 0x8289

gl_FRAMEBUFFER_RENDERABLE_LAYERED :: GLenum
gl_FRAMEBUFFER_RENDERABLE_LAYERED = 0x828A

gl_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV :: GLenum
gl_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV = 0x9343

gl_FRAMEBUFFER_SRGB :: GLenum
gl_FRAMEBUFFER_SRGB = 0x8DB9

gl_FRAMEBUFFER_SRGB_CAPABLE_EXT :: GLenum
gl_FRAMEBUFFER_SRGB_CAPABLE_EXT = 0x8DBA

gl_FRAMEBUFFER_SRGB_EXT :: GLenum
gl_FRAMEBUFFER_SRGB_EXT = 0x8DB9

gl_FRAMEBUFFER_UNDEFINED :: GLenum
gl_FRAMEBUFFER_UNDEFINED = 0x8219

gl_FRAMEBUFFER_UNDEFINED_OES :: GLenum
gl_FRAMEBUFFER_UNDEFINED_OES = 0x8219

gl_FRAMEBUFFER_UNSUPPORTED :: GLenum
gl_FRAMEBUFFER_UNSUPPORTED = 0x8CDD

gl_FRAMEBUFFER_UNSUPPORTED_EXT :: GLenum
gl_FRAMEBUFFER_UNSUPPORTED_EXT = 0x8CDD

gl_FRAMEBUFFER_UNSUPPORTED_OES :: GLenum
gl_FRAMEBUFFER_UNSUPPORTED_OES = 0x8CDD

gl_FRAMEZOOM_FACTOR_SGIX :: GLenum
gl_FRAMEZOOM_FACTOR_SGIX = 0x818C

gl_FRAMEZOOM_SGIX :: GLenum
gl_FRAMEZOOM_SGIX = 0x818B

gl_FRAME_NV :: GLenum
gl_FRAME_NV = 0x8E26

gl_FRONT :: GLenum
gl_FRONT = 0x0404

gl_FRONT_AND_BACK :: GLenum
gl_FRONT_AND_BACK = 0x0408

gl_FRONT_FACE :: GLenum
gl_FRONT_FACE = 0x0B46

gl_FRONT_LEFT :: GLenum
gl_FRONT_LEFT = 0x0400

gl_FRONT_RIGHT :: GLenum
gl_FRONT_RIGHT = 0x0401

gl_FULL_RANGE_EXT :: GLenum
gl_FULL_RANGE_EXT = 0x87E1

gl_FULL_STIPPLE_HINT_PGI :: GLenum
gl_FULL_STIPPLE_HINT_PGI = 0x1A219

gl_FULL_SUPPORT :: GLenum
gl_FULL_SUPPORT = 0x82B7

gl_FUNC_ADD :: GLenum
gl_FUNC_ADD = 0x8006

gl_FUNC_ADD_EXT :: GLenum
gl_FUNC_ADD_EXT = 0x8006

gl_FUNC_ADD_OES :: GLenum
gl_FUNC_ADD_OES = 0x8006

gl_FUNC_REVERSE_SUBTRACT :: GLenum
gl_FUNC_REVERSE_SUBTRACT = 0x800B

gl_FUNC_REVERSE_SUBTRACT_EXT :: GLenum
gl_FUNC_REVERSE_SUBTRACT_EXT = 0x800B

gl_FUNC_REVERSE_SUBTRACT_OES :: GLenum
gl_FUNC_REVERSE_SUBTRACT_OES = 0x800B

gl_FUNC_SUBTRACT :: GLenum
gl_FUNC_SUBTRACT = 0x800A

gl_FUNC_SUBTRACT_EXT :: GLenum
gl_FUNC_SUBTRACT_EXT = 0x800A

gl_FUNC_SUBTRACT_OES :: GLenum
gl_FUNC_SUBTRACT_OES = 0x800A

gl_GCCSO_SHADER_BINARY_FJ :: GLenum
gl_GCCSO_SHADER_BINARY_FJ = 0x9260

gl_GENERATE_MIPMAP :: GLenum
gl_GENERATE_MIPMAP = 0x8191

gl_GENERATE_MIPMAP_HINT :: GLenum
gl_GENERATE_MIPMAP_HINT = 0x8192

gl_GENERATE_MIPMAP_HINT_SGIS :: GLenum
gl_GENERATE_MIPMAP_HINT_SGIS = 0x8192

gl_GENERATE_MIPMAP_SGIS :: GLenum
gl_GENERATE_MIPMAP_SGIS = 0x8191

gl_GENERIC_ATTRIB_NV :: GLenum
gl_GENERIC_ATTRIB_NV = 0x8C7D

gl_GEOMETRY_DEFORMATION_BIT_SGIX :: GLbitfield
gl_GEOMETRY_DEFORMATION_BIT_SGIX = 0x00000002

gl_GEOMETRY_DEFORMATION_SGIX :: GLenum
gl_GEOMETRY_DEFORMATION_SGIX = 0x8194

gl_GEOMETRY_INPUT_TYPE :: GLenum
gl_GEOMETRY_INPUT_TYPE = 0x8917

gl_GEOMETRY_INPUT_TYPE_ARB :: GLenum
gl_GEOMETRY_INPUT_TYPE_ARB = 0x8DDB

gl_GEOMETRY_INPUT_TYPE_EXT :: GLenum
gl_GEOMETRY_INPUT_TYPE_EXT = 0x8DDB

gl_GEOMETRY_LINKED_INPUT_TYPE_EXT :: GLenum
gl_GEOMETRY_LINKED_INPUT_TYPE_EXT = 0x8917

gl_GEOMETRY_LINKED_INPUT_TYPE_OES :: GLenum
gl_GEOMETRY_LINKED_INPUT_TYPE_OES = 0x8917

gl_GEOMETRY_LINKED_OUTPUT_TYPE_EXT :: GLenum
gl_GEOMETRY_LINKED_OUTPUT_TYPE_EXT = 0x8918

gl_GEOMETRY_LINKED_OUTPUT_TYPE_OES :: GLenum
gl_GEOMETRY_LINKED_OUTPUT_TYPE_OES = 0x8918

gl_GEOMETRY_LINKED_VERTICES_OUT_EXT :: GLenum
gl_GEOMETRY_LINKED_VERTICES_OUT_EXT = 0x8916

gl_GEOMETRY_LINKED_VERTICES_OUT_OES :: GLenum
gl_GEOMETRY_LINKED_VERTICES_OUT_OES = 0x8916

gl_GEOMETRY_OUTPUT_TYPE :: GLenum
gl_GEOMETRY_OUTPUT_TYPE = 0x8918

gl_GEOMETRY_OUTPUT_TYPE_ARB :: GLenum
gl_GEOMETRY_OUTPUT_TYPE_ARB = 0x8DDC

gl_GEOMETRY_OUTPUT_TYPE_EXT :: GLenum
gl_GEOMETRY_OUTPUT_TYPE_EXT = 0x8DDC

gl_GEOMETRY_PROGRAM_NV :: GLenum
gl_GEOMETRY_PROGRAM_NV = 0x8C26

gl_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV :: GLenum
gl_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA3

gl_GEOMETRY_SHADER :: GLenum
gl_GEOMETRY_SHADER = 0x8DD9

gl_GEOMETRY_SHADER_ARB :: GLenum
gl_GEOMETRY_SHADER_ARB = 0x8DD9

gl_GEOMETRY_SHADER_BIT :: GLbitfield
gl_GEOMETRY_SHADER_BIT = 0x00000004

gl_GEOMETRY_SHADER_BIT_EXT :: GLbitfield
gl_GEOMETRY_SHADER_BIT_EXT = 0x00000004

gl_GEOMETRY_SHADER_BIT_OES :: GLbitfield
gl_GEOMETRY_SHADER_BIT_OES = 0x00000004

gl_GEOMETRY_SHADER_EXT :: GLenum
gl_GEOMETRY_SHADER_EXT = 0x8DD9

gl_GEOMETRY_SHADER_INVOCATIONS :: GLenum
gl_GEOMETRY_SHADER_INVOCATIONS = 0x887F

gl_GEOMETRY_SHADER_INVOCATIONS_EXT :: GLenum
gl_GEOMETRY_SHADER_INVOCATIONS_EXT = 0x887F

gl_GEOMETRY_SHADER_INVOCATIONS_OES :: GLenum
gl_GEOMETRY_SHADER_INVOCATIONS_OES = 0x887F

gl_GEOMETRY_SHADER_OES :: GLenum
gl_GEOMETRY_SHADER_OES = 0x8DD9

gl_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB :: GLenum
gl_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB = 0x82F3

gl_GEOMETRY_SUBROUTINE :: GLenum
gl_GEOMETRY_SUBROUTINE = 0x92EB

gl_GEOMETRY_SUBROUTINE_UNIFORM :: GLenum
gl_GEOMETRY_SUBROUTINE_UNIFORM = 0x92F1

gl_GEOMETRY_TEXTURE :: GLenum
gl_GEOMETRY_TEXTURE = 0x829E

gl_GEOMETRY_VERTICES_OUT :: GLenum
gl_GEOMETRY_VERTICES_OUT = 0x8916

gl_GEOMETRY_VERTICES_OUT_ARB :: GLenum
gl_GEOMETRY_VERTICES_OUT_ARB = 0x8DDA

gl_GEOMETRY_VERTICES_OUT_EXT :: GLenum
gl_GEOMETRY_VERTICES_OUT_EXT = 0x8DDA

gl_GEQUAL :: GLenum
gl_GEQUAL = 0x0206

gl_GET_TEXTURE_IMAGE_FORMAT :: GLenum
gl_GET_TEXTURE_IMAGE_FORMAT = 0x8291

gl_GET_TEXTURE_IMAGE_TYPE :: GLenum
gl_GET_TEXTURE_IMAGE_TYPE = 0x8292

gl_GLOBAL_ALPHA_FACTOR_SUN :: GLenum
gl_GLOBAL_ALPHA_FACTOR_SUN = 0x81DA

gl_GLOBAL_ALPHA_SUN :: GLenum
gl_GLOBAL_ALPHA_SUN = 0x81D9

gl_GLYPH_HAS_KERNING_BIT_NV :: GLbitfield
gl_GLYPH_HAS_KERNING_BIT_NV = 0x100

gl_GLYPH_HEIGHT_BIT_NV :: GLbitfield
gl_GLYPH_HEIGHT_BIT_NV = 0x02

gl_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV :: GLbitfield
gl_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = 0x10

gl_GLYPH_HORIZONTAL_BEARING_X_BIT_NV :: GLbitfield
gl_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = 0x04

gl_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV :: GLbitfield
gl_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = 0x08

gl_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV :: GLbitfield
gl_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = 0x80

gl_GLYPH_VERTICAL_BEARING_X_BIT_NV :: GLbitfield
gl_GLYPH_VERTICAL_BEARING_X_BIT_NV = 0x20

gl_GLYPH_VERTICAL_BEARING_Y_BIT_NV :: GLbitfield
gl_GLYPH_VERTICAL_BEARING_Y_BIT_NV = 0x40

gl_GLYPH_WIDTH_BIT_NV :: GLbitfield
gl_GLYPH_WIDTH_BIT_NV = 0x01

gl_GPU_ADDRESS_NV :: GLenum
gl_GPU_ADDRESS_NV = 0x8F34

gl_GPU_DISJOINT_EXT :: GLenum
gl_GPU_DISJOINT_EXT = 0x8FBB

gl_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX :: GLenum
gl_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX = 0x9049

gl_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX :: GLenum
gl_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX = 0x9047

gl_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX :: GLenum
gl_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX = 0x904B

gl_GPU_MEMORY_INFO_EVICTION_COUNT_NVX :: GLenum
gl_GPU_MEMORY_INFO_EVICTION_COUNT_NVX = 0x904A

gl_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX :: GLenum
gl_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX = 0x9048

gl_GPU_OPTIMIZED_QCOM :: GLenum
gl_GPU_OPTIMIZED_QCOM = 0x8FB2

gl_GREATER :: GLenum
gl_GREATER = 0x0204

gl_GREEN :: GLenum
gl_GREEN = 0x1904

gl_GREEN_BIAS :: GLenum
gl_GREEN_BIAS = 0x0D19

gl_GREEN_BITS :: GLenum
gl_GREEN_BITS = 0x0D53

gl_GREEN_BIT_ATI :: GLbitfield
gl_GREEN_BIT_ATI = 0x00000002

gl_GREEN_INTEGER :: GLenum
gl_GREEN_INTEGER = 0x8D95

gl_GREEN_INTEGER_EXT :: GLenum
gl_GREEN_INTEGER_EXT = 0x8D95

gl_GREEN_MAX_CLAMP_INGR :: GLenum
gl_GREEN_MAX_CLAMP_INGR = 0x8565

gl_GREEN_MIN_CLAMP_INGR :: GLenum
gl_GREEN_MIN_CLAMP_INGR = 0x8561

gl_GREEN_NV :: GLenum
gl_GREEN_NV = 0x1904

gl_GREEN_SCALE :: GLenum
gl_GREEN_SCALE = 0x0D18

gl_GUILTY_CONTEXT_RESET :: GLenum
gl_GUILTY_CONTEXT_RESET = 0x8253

gl_GUILTY_CONTEXT_RESET_ARB :: GLenum
gl_GUILTY_CONTEXT_RESET_ARB = 0x8253

gl_GUILTY_CONTEXT_RESET_EXT :: GLenum
gl_GUILTY_CONTEXT_RESET_EXT = 0x8253

gl_GUILTY_CONTEXT_RESET_KHR :: GLenum
gl_GUILTY_CONTEXT_RESET_KHR = 0x8253

gl_HALF_APPLE :: GLenum
gl_HALF_APPLE = 0x140B

gl_HALF_BIAS_NEGATE_NV :: GLenum
gl_HALF_BIAS_NEGATE_NV = 0x853B

gl_HALF_BIAS_NORMAL_NV :: GLenum
gl_HALF_BIAS_NORMAL_NV = 0x853A

gl_HALF_BIT_ATI :: GLbitfield
gl_HALF_BIT_ATI = 0x00000008

gl_HALF_FLOAT :: GLenum
gl_HALF_FLOAT = 0x140B

gl_HALF_FLOAT_ARB :: GLenum
gl_HALF_FLOAT_ARB = 0x140B

gl_HALF_FLOAT_NV :: GLenum
gl_HALF_FLOAT_NV = 0x140B

gl_HALF_FLOAT_OES :: GLenum
gl_HALF_FLOAT_OES = 0x8D61

gl_HARDLIGHT_KHR :: GLenum
gl_HARDLIGHT_KHR = 0x929B

gl_HARDLIGHT_NV :: GLenum
gl_HARDLIGHT_NV = 0x929B

gl_HARDMIX_NV :: GLenum
gl_HARDMIX_NV = 0x92A9

gl_HIGH_FLOAT :: GLenum
gl_HIGH_FLOAT = 0x8DF2

gl_HIGH_INT :: GLenum
gl_HIGH_INT = 0x8DF5

gl_HILO16_NV :: GLenum
gl_HILO16_NV = 0x86F8

gl_HILO8_NV :: GLenum
gl_HILO8_NV = 0x885E

gl_HILO_NV :: GLenum
gl_HILO_NV = 0x86F4

gl_HINT_BIT :: GLbitfield
gl_HINT_BIT = 0x00008000

gl_HISTOGRAM :: GLenum
gl_HISTOGRAM = 0x8024

gl_HISTOGRAM_ALPHA_SIZE :: GLenum
gl_HISTOGRAM_ALPHA_SIZE = 0x802B

gl_HISTOGRAM_ALPHA_SIZE_EXT :: GLenum
gl_HISTOGRAM_ALPHA_SIZE_EXT = 0x802B

gl_HISTOGRAM_BLUE_SIZE :: GLenum
gl_HISTOGRAM_BLUE_SIZE = 0x802A

gl_HISTOGRAM_BLUE_SIZE_EXT :: GLenum
gl_HISTOGRAM_BLUE_SIZE_EXT = 0x802A

gl_HISTOGRAM_EXT :: GLenum
gl_HISTOGRAM_EXT = 0x8024

gl_HISTOGRAM_FORMAT :: GLenum
gl_HISTOGRAM_FORMAT = 0x8027

gl_HISTOGRAM_FORMAT_EXT :: GLenum
gl_HISTOGRAM_FORMAT_EXT = 0x8027

gl_HISTOGRAM_GREEN_SIZE :: GLenum
gl_HISTOGRAM_GREEN_SIZE = 0x8029

gl_HISTOGRAM_GREEN_SIZE_EXT :: GLenum
gl_HISTOGRAM_GREEN_SIZE_EXT = 0x8029

gl_HISTOGRAM_LUMINANCE_SIZE :: GLenum
gl_HISTOGRAM_LUMINANCE_SIZE = 0x802C

gl_HISTOGRAM_LUMINANCE_SIZE_EXT :: GLenum
gl_HISTOGRAM_LUMINANCE_SIZE_EXT = 0x802C

gl_HISTOGRAM_RED_SIZE :: GLenum
gl_HISTOGRAM_RED_SIZE = 0x8028

gl_HISTOGRAM_RED_SIZE_EXT :: GLenum
gl_HISTOGRAM_RED_SIZE_EXT = 0x8028

gl_HISTOGRAM_SINK :: GLenum
gl_HISTOGRAM_SINK = 0x802D

gl_HISTOGRAM_SINK_EXT :: GLenum
gl_HISTOGRAM_SINK_EXT = 0x802D

gl_HISTOGRAM_WIDTH :: GLenum
gl_HISTOGRAM_WIDTH = 0x8026

gl_HISTOGRAM_WIDTH_EXT :: GLenum
gl_HISTOGRAM_WIDTH_EXT = 0x8026

gl_HI_BIAS_NV :: GLenum
gl_HI_BIAS_NV = 0x8714

gl_HI_SCALE_NV :: GLenum
gl_HI_SCALE_NV = 0x870E

gl_HORIZONTAL_LINE_TO_NV :: GLubyte
gl_HORIZONTAL_LINE_TO_NV = 0x06

gl_HSL_COLOR_KHR :: GLenum
gl_HSL_COLOR_KHR = 0x92AF

gl_HSL_COLOR_NV :: GLenum
gl_HSL_COLOR_NV = 0x92AF

gl_HSL_HUE_KHR :: GLenum
gl_HSL_HUE_KHR = 0x92AD

gl_HSL_HUE_NV :: GLenum
gl_HSL_HUE_NV = 0x92AD

gl_HSL_LUMINOSITY_KHR :: GLenum
gl_HSL_LUMINOSITY_KHR = 0x92B0

gl_HSL_LUMINOSITY_NV :: GLenum
gl_HSL_LUMINOSITY_NV = 0x92B0

gl_HSL_SATURATION_KHR :: GLenum
gl_HSL_SATURATION_KHR = 0x92AE

gl_HSL_SATURATION_NV :: GLenum
gl_HSL_SATURATION_NV = 0x92AE

gl_IDENTITY_NV :: GLenum
gl_IDENTITY_NV = 0x862A

gl_IGNORE_BORDER_HP :: GLenum
gl_IGNORE_BORDER_HP = 0x8150

gl_IMAGE_1D :: GLenum
gl_IMAGE_1D = 0x904C

gl_IMAGE_1D_ARRAY :: GLenum
gl_IMAGE_1D_ARRAY = 0x9052

gl_IMAGE_1D_ARRAY_EXT :: GLenum
gl_IMAGE_1D_ARRAY_EXT = 0x9052

gl_IMAGE_1D_EXT :: GLenum
gl_IMAGE_1D_EXT = 0x904C

gl_IMAGE_2D :: GLenum
gl_IMAGE_2D = 0x904D

gl_IMAGE_2D_ARRAY :: GLenum
gl_IMAGE_2D_ARRAY = 0x9053

gl_IMAGE_2D_ARRAY_EXT :: GLenum
gl_IMAGE_2D_ARRAY_EXT = 0x9053

gl_IMAGE_2D_EXT :: GLenum
gl_IMAGE_2D_EXT = 0x904D

gl_IMAGE_2D_MULTISAMPLE :: GLenum
gl_IMAGE_2D_MULTISAMPLE = 0x9055

gl_IMAGE_2D_MULTISAMPLE_ARRAY :: GLenum
gl_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056

gl_IMAGE_2D_MULTISAMPLE_ARRAY_EXT :: GLenum
gl_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x9056

gl_IMAGE_2D_MULTISAMPLE_EXT :: GLenum
gl_IMAGE_2D_MULTISAMPLE_EXT = 0x9055

gl_IMAGE_2D_RECT :: GLenum
gl_IMAGE_2D_RECT = 0x904F

gl_IMAGE_2D_RECT_EXT :: GLenum
gl_IMAGE_2D_RECT_EXT = 0x904F

gl_IMAGE_3D :: GLenum
gl_IMAGE_3D = 0x904E

gl_IMAGE_3D_EXT :: GLenum
gl_IMAGE_3D_EXT = 0x904E

gl_IMAGE_BINDING_ACCESS :: GLenum
gl_IMAGE_BINDING_ACCESS = 0x8F3E

gl_IMAGE_BINDING_ACCESS_EXT :: GLenum
gl_IMAGE_BINDING_ACCESS_EXT = 0x8F3E

gl_IMAGE_BINDING_FORMAT :: GLenum
gl_IMAGE_BINDING_FORMAT = 0x906E

gl_IMAGE_BINDING_FORMAT_EXT :: GLenum
gl_IMAGE_BINDING_FORMAT_EXT = 0x906E

gl_IMAGE_BINDING_LAYER :: GLenum
gl_IMAGE_BINDING_LAYER = 0x8F3D

gl_IMAGE_BINDING_LAYERED :: GLenum
gl_IMAGE_BINDING_LAYERED = 0x8F3C

gl_IMAGE_BINDING_LAYERED_EXT :: GLenum
gl_IMAGE_BINDING_LAYERED_EXT = 0x8F3C

gl_IMAGE_BINDING_LAYER_EXT :: GLenum
gl_IMAGE_BINDING_LAYER_EXT = 0x8F3D

gl_IMAGE_BINDING_LEVEL :: GLenum
gl_IMAGE_BINDING_LEVEL = 0x8F3B

gl_IMAGE_BINDING_LEVEL_EXT :: GLenum
gl_IMAGE_BINDING_LEVEL_EXT = 0x8F3B

gl_IMAGE_BINDING_NAME :: GLenum
gl_IMAGE_BINDING_NAME = 0x8F3A

gl_IMAGE_BINDING_NAME_EXT :: GLenum
gl_IMAGE_BINDING_NAME_EXT = 0x8F3A

gl_IMAGE_BUFFER :: GLenum
gl_IMAGE_BUFFER = 0x9051

gl_IMAGE_BUFFER_EXT :: GLenum
gl_IMAGE_BUFFER_EXT = 0x9051

gl_IMAGE_BUFFER_OES :: GLenum
gl_IMAGE_BUFFER_OES = 0x9051

gl_IMAGE_CLASS_10_10_10_2 :: GLenum
gl_IMAGE_CLASS_10_10_10_2 = 0x82C3

gl_IMAGE_CLASS_11_11_10 :: GLenum
gl_IMAGE_CLASS_11_11_10 = 0x82C2

gl_IMAGE_CLASS_1_X_16 :: GLenum
gl_IMAGE_CLASS_1_X_16 = 0x82BE

gl_IMAGE_CLASS_1_X_32 :: GLenum
gl_IMAGE_CLASS_1_X_32 = 0x82BB

gl_IMAGE_CLASS_1_X_8 :: GLenum
gl_IMAGE_CLASS_1_X_8 = 0x82C1

gl_IMAGE_CLASS_2_X_16 :: GLenum
gl_IMAGE_CLASS_2_X_16 = 0x82BD

gl_IMAGE_CLASS_2_X_32 :: GLenum
gl_IMAGE_CLASS_2_X_32 = 0x82BA

gl_IMAGE_CLASS_2_X_8 :: GLenum
gl_IMAGE_CLASS_2_X_8 = 0x82C0

gl_IMAGE_CLASS_4_X_16 :: GLenum
gl_IMAGE_CLASS_4_X_16 = 0x82BC

gl_IMAGE_CLASS_4_X_32 :: GLenum
gl_IMAGE_CLASS_4_X_32 = 0x82B9

gl_IMAGE_CLASS_4_X_8 :: GLenum
gl_IMAGE_CLASS_4_X_8 = 0x82BF

gl_IMAGE_COMPATIBILITY_CLASS :: GLenum
gl_IMAGE_COMPATIBILITY_CLASS = 0x82A8

gl_IMAGE_CUBE :: GLenum
gl_IMAGE_CUBE = 0x9050

gl_IMAGE_CUBE_EXT :: GLenum
gl_IMAGE_CUBE_EXT = 0x9050

gl_IMAGE_CUBE_MAP_ARRAY :: GLenum
gl_IMAGE_CUBE_MAP_ARRAY = 0x9054

gl_IMAGE_CUBE_MAP_ARRAY_EXT :: GLenum
gl_IMAGE_CUBE_MAP_ARRAY_EXT = 0x9054

gl_IMAGE_CUBE_MAP_ARRAY_OES :: GLenum
gl_IMAGE_CUBE_MAP_ARRAY_OES = 0x9054

gl_IMAGE_CUBIC_WEIGHT_HP :: GLenum
gl_IMAGE_CUBIC_WEIGHT_HP = 0x815E

gl_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS :: GLenum
gl_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 0x90C9

gl_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE :: GLenum
gl_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 0x90C8

gl_IMAGE_FORMAT_COMPATIBILITY_TYPE :: GLenum
gl_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7

gl_IMAGE_MAG_FILTER_HP :: GLenum
gl_IMAGE_MAG_FILTER_HP = 0x815C

gl_IMAGE_MIN_FILTER_HP :: GLenum
gl_IMAGE_MIN_FILTER_HP = 0x815D

gl_IMAGE_PIXEL_FORMAT :: GLenum
gl_IMAGE_PIXEL_FORMAT = 0x82A9

gl_IMAGE_PIXEL_TYPE :: GLenum
gl_IMAGE_PIXEL_TYPE = 0x82AA

gl_IMAGE_ROTATE_ANGLE_HP :: GLenum
gl_IMAGE_ROTATE_ANGLE_HP = 0x8159

gl_IMAGE_ROTATE_ORIGIN_X_HP :: GLenum
gl_IMAGE_ROTATE_ORIGIN_X_HP = 0x815A

gl_IMAGE_ROTATE_ORIGIN_Y_HP :: GLenum
gl_IMAGE_ROTATE_ORIGIN_Y_HP = 0x815B

gl_IMAGE_SCALE_X_HP :: GLenum
gl_IMAGE_SCALE_X_HP = 0x8155

gl_IMAGE_SCALE_Y_HP :: GLenum
gl_IMAGE_SCALE_Y_HP = 0x8156

gl_IMAGE_TEXEL_SIZE :: GLenum
gl_IMAGE_TEXEL_SIZE = 0x82A7

gl_IMAGE_TRANSFORM_2D_HP :: GLenum
gl_IMAGE_TRANSFORM_2D_HP = 0x8161

gl_IMAGE_TRANSLATE_X_HP :: GLenum
gl_IMAGE_TRANSLATE_X_HP = 0x8157

gl_IMAGE_TRANSLATE_Y_HP :: GLenum
gl_IMAGE_TRANSLATE_Y_HP = 0x8158

gl_IMPLEMENTATION_COLOR_READ_FORMAT :: GLenum
gl_IMPLEMENTATION_COLOR_READ_FORMAT = 0x8B9B

gl_IMPLEMENTATION_COLOR_READ_FORMAT_OES :: GLenum
gl_IMPLEMENTATION_COLOR_READ_FORMAT_OES = 0x8B9B

gl_IMPLEMENTATION_COLOR_READ_TYPE :: GLenum
gl_IMPLEMENTATION_COLOR_READ_TYPE = 0x8B9A

gl_IMPLEMENTATION_COLOR_READ_TYPE_OES :: GLenum
gl_IMPLEMENTATION_COLOR_READ_TYPE_OES = 0x8B9A

gl_INCR :: GLenum
gl_INCR = 0x1E02

gl_INCR_WRAP :: GLenum
gl_INCR_WRAP = 0x8507

gl_INCR_WRAP_EXT :: GLenum
gl_INCR_WRAP_EXT = 0x8507

gl_INCR_WRAP_OES :: GLenum
gl_INCR_WRAP_OES = 0x8507

gl_INDEX :: GLenum
gl_INDEX = 0x8222

gl_INDEX_ARRAY :: GLenum
gl_INDEX_ARRAY = 0x8077

gl_INDEX_ARRAY_ADDRESS_NV :: GLenum
gl_INDEX_ARRAY_ADDRESS_NV = 0x8F24

gl_INDEX_ARRAY_BUFFER_BINDING :: GLenum
gl_INDEX_ARRAY_BUFFER_BINDING = 0x8899

gl_INDEX_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_INDEX_ARRAY_BUFFER_BINDING_ARB = 0x8899

gl_INDEX_ARRAY_COUNT_EXT :: GLenum
gl_INDEX_ARRAY_COUNT_EXT = 0x8087

gl_INDEX_ARRAY_EXT :: GLenum
gl_INDEX_ARRAY_EXT = 0x8077

gl_INDEX_ARRAY_LENGTH_NV :: GLenum
gl_INDEX_ARRAY_LENGTH_NV = 0x8F2E

gl_INDEX_ARRAY_LIST_IBM :: GLenum
gl_INDEX_ARRAY_LIST_IBM = 103073

gl_INDEX_ARRAY_LIST_STRIDE_IBM :: GLenum
gl_INDEX_ARRAY_LIST_STRIDE_IBM = 103083

gl_INDEX_ARRAY_POINTER :: GLenum
gl_INDEX_ARRAY_POINTER = 0x8091

gl_INDEX_ARRAY_POINTER_EXT :: GLenum
gl_INDEX_ARRAY_POINTER_EXT = 0x8091

gl_INDEX_ARRAY_STRIDE :: GLenum
gl_INDEX_ARRAY_STRIDE = 0x8086

gl_INDEX_ARRAY_STRIDE_EXT :: GLenum
gl_INDEX_ARRAY_STRIDE_EXT = 0x8086

gl_INDEX_ARRAY_TYPE :: GLenum
gl_INDEX_ARRAY_TYPE = 0x8085

gl_INDEX_ARRAY_TYPE_EXT :: GLenum
gl_INDEX_ARRAY_TYPE_EXT = 0x8085

gl_INDEX_BITS :: GLenum
gl_INDEX_BITS = 0x0D51

gl_INDEX_BIT_PGI :: GLbitfield
gl_INDEX_BIT_PGI = 0x00080000

gl_INDEX_CLEAR_VALUE :: GLenum
gl_INDEX_CLEAR_VALUE = 0x0C20

gl_INDEX_LOGIC_OP :: GLenum
gl_INDEX_LOGIC_OP = 0x0BF1

gl_INDEX_MATERIAL_EXT :: GLenum
gl_INDEX_MATERIAL_EXT = 0x81B8

gl_INDEX_MATERIAL_FACE_EXT :: GLenum
gl_INDEX_MATERIAL_FACE_EXT = 0x81BA

gl_INDEX_MATERIAL_PARAMETER_EXT :: GLenum
gl_INDEX_MATERIAL_PARAMETER_EXT = 0x81B9

gl_INDEX_MODE :: GLenum
gl_INDEX_MODE = 0x0C30

gl_INDEX_OFFSET :: GLenum
gl_INDEX_OFFSET = 0x0D13

gl_INDEX_SHIFT :: GLenum
gl_INDEX_SHIFT = 0x0D12

gl_INDEX_TEST_EXT :: GLenum
gl_INDEX_TEST_EXT = 0x81B5

gl_INDEX_TEST_FUNC_EXT :: GLenum
gl_INDEX_TEST_FUNC_EXT = 0x81B6

gl_INDEX_TEST_REF_EXT :: GLenum
gl_INDEX_TEST_REF_EXT = 0x81B7

gl_INDEX_WRITEMASK :: GLenum
gl_INDEX_WRITEMASK = 0x0C21

gl_INFO_LOG_LENGTH :: GLenum
gl_INFO_LOG_LENGTH = 0x8B84

gl_INNOCENT_CONTEXT_RESET :: GLenum
gl_INNOCENT_CONTEXT_RESET = 0x8254

gl_INNOCENT_CONTEXT_RESET_ARB :: GLenum
gl_INNOCENT_CONTEXT_RESET_ARB = 0x8254

gl_INNOCENT_CONTEXT_RESET_EXT :: GLenum
gl_INNOCENT_CONTEXT_RESET_EXT = 0x8254

gl_INNOCENT_CONTEXT_RESET_KHR :: GLenum
gl_INNOCENT_CONTEXT_RESET_KHR = 0x8254

gl_INSTRUMENT_BUFFER_POINTER_SGIX :: GLenum
gl_INSTRUMENT_BUFFER_POINTER_SGIX = 0x8180

gl_INSTRUMENT_MEASUREMENTS_SGIX :: GLenum
gl_INSTRUMENT_MEASUREMENTS_SGIX = 0x8181

gl_INT :: GLenum
gl_INT = 0x1404

gl_INT16_NV :: GLenum
gl_INT16_NV = 0x8FE4

gl_INT16_VEC2_NV :: GLenum
gl_INT16_VEC2_NV = 0x8FE5

gl_INT16_VEC3_NV :: GLenum
gl_INT16_VEC3_NV = 0x8FE6

gl_INT16_VEC4_NV :: GLenum
gl_INT16_VEC4_NV = 0x8FE7

gl_INT64_NV :: GLenum
gl_INT64_NV = 0x140E

gl_INT64_VEC2_NV :: GLenum
gl_INT64_VEC2_NV = 0x8FE9

gl_INT64_VEC3_NV :: GLenum
gl_INT64_VEC3_NV = 0x8FEA

gl_INT64_VEC4_NV :: GLenum
gl_INT64_VEC4_NV = 0x8FEB

gl_INT8_NV :: GLenum
gl_INT8_NV = 0x8FE0

gl_INT8_VEC2_NV :: GLenum
gl_INT8_VEC2_NV = 0x8FE1

gl_INT8_VEC3_NV :: GLenum
gl_INT8_VEC3_NV = 0x8FE2

gl_INT8_VEC4_NV :: GLenum
gl_INT8_VEC4_NV = 0x8FE3

gl_INTENSITY :: GLenum
gl_INTENSITY = 0x8049

gl_INTENSITY12 :: GLenum
gl_INTENSITY12 = 0x804C

gl_INTENSITY12_EXT :: GLenum
gl_INTENSITY12_EXT = 0x804C

gl_INTENSITY16 :: GLenum
gl_INTENSITY16 = 0x804D

gl_INTENSITY16F_ARB :: GLenum
gl_INTENSITY16F_ARB = 0x881D

gl_INTENSITY16I_EXT :: GLenum
gl_INTENSITY16I_EXT = 0x8D8B

gl_INTENSITY16UI_EXT :: GLenum
gl_INTENSITY16UI_EXT = 0x8D79

gl_INTENSITY16_EXT :: GLenum
gl_INTENSITY16_EXT = 0x804D

gl_INTENSITY16_SNORM :: GLenum
gl_INTENSITY16_SNORM = 0x901B

gl_INTENSITY32F_ARB :: GLenum
gl_INTENSITY32F_ARB = 0x8817

gl_INTENSITY32I_EXT :: GLenum
gl_INTENSITY32I_EXT = 0x8D85

gl_INTENSITY32UI_EXT :: GLenum
gl_INTENSITY32UI_EXT = 0x8D73

gl_INTENSITY4 :: GLenum
gl_INTENSITY4 = 0x804A

gl_INTENSITY4_EXT :: GLenum
gl_INTENSITY4_EXT = 0x804A

gl_INTENSITY8 :: GLenum
gl_INTENSITY8 = 0x804B

gl_INTENSITY8I_EXT :: GLenum
gl_INTENSITY8I_EXT = 0x8D91

gl_INTENSITY8UI_EXT :: GLenum
gl_INTENSITY8UI_EXT = 0x8D7F

gl_INTENSITY8_EXT :: GLenum
gl_INTENSITY8_EXT = 0x804B

gl_INTENSITY8_SNORM :: GLenum
gl_INTENSITY8_SNORM = 0x9017

gl_INTENSITY_EXT :: GLenum
gl_INTENSITY_EXT = 0x8049

gl_INTENSITY_FLOAT16_APPLE :: GLenum
gl_INTENSITY_FLOAT16_APPLE = 0x881D

gl_INTENSITY_FLOAT16_ATI :: GLenum
gl_INTENSITY_FLOAT16_ATI = 0x881D

gl_INTENSITY_FLOAT32_APPLE :: GLenum
gl_INTENSITY_FLOAT32_APPLE = 0x8817

gl_INTENSITY_FLOAT32_ATI :: GLenum
gl_INTENSITY_FLOAT32_ATI = 0x8817

gl_INTENSITY_SNORM :: GLenum
gl_INTENSITY_SNORM = 0x9013

gl_INTERLACE_OML :: GLenum
gl_INTERLACE_OML = 0x8980

gl_INTERLACE_READ_INGR :: GLenum
gl_INTERLACE_READ_INGR = 0x8568

gl_INTERLACE_READ_OML :: GLenum
gl_INTERLACE_READ_OML = 0x8981

gl_INTERLACE_SGIX :: GLenum
gl_INTERLACE_SGIX = 0x8094

gl_INTERLEAVED_ATTRIBS :: GLenum
gl_INTERLEAVED_ATTRIBS = 0x8C8C

gl_INTERLEAVED_ATTRIBS_EXT :: GLenum
gl_INTERLEAVED_ATTRIBS_EXT = 0x8C8C

gl_INTERLEAVED_ATTRIBS_NV :: GLenum
gl_INTERLEAVED_ATTRIBS_NV = 0x8C8C

gl_INTERNALFORMAT_ALPHA_SIZE :: GLenum
gl_INTERNALFORMAT_ALPHA_SIZE = 0x8274

gl_INTERNALFORMAT_ALPHA_TYPE :: GLenum
gl_INTERNALFORMAT_ALPHA_TYPE = 0x827B

gl_INTERNALFORMAT_BLUE_SIZE :: GLenum
gl_INTERNALFORMAT_BLUE_SIZE = 0x8273

gl_INTERNALFORMAT_BLUE_TYPE :: GLenum
gl_INTERNALFORMAT_BLUE_TYPE = 0x827A

gl_INTERNALFORMAT_DEPTH_SIZE :: GLenum
gl_INTERNALFORMAT_DEPTH_SIZE = 0x8275

gl_INTERNALFORMAT_DEPTH_TYPE :: GLenum
gl_INTERNALFORMAT_DEPTH_TYPE = 0x827C

gl_INTERNALFORMAT_GREEN_SIZE :: GLenum
gl_INTERNALFORMAT_GREEN_SIZE = 0x8272

gl_INTERNALFORMAT_GREEN_TYPE :: GLenum
gl_INTERNALFORMAT_GREEN_TYPE = 0x8279

gl_INTERNALFORMAT_PREFERRED :: GLenum
gl_INTERNALFORMAT_PREFERRED = 0x8270

gl_INTERNALFORMAT_RED_SIZE :: GLenum
gl_INTERNALFORMAT_RED_SIZE = 0x8271

gl_INTERNALFORMAT_RED_TYPE :: GLenum
gl_INTERNALFORMAT_RED_TYPE = 0x8278

gl_INTERNALFORMAT_SHARED_SIZE :: GLenum
gl_INTERNALFORMAT_SHARED_SIZE = 0x8277

gl_INTERNALFORMAT_STENCIL_SIZE :: GLenum
gl_INTERNALFORMAT_STENCIL_SIZE = 0x8276

gl_INTERNALFORMAT_STENCIL_TYPE :: GLenum
gl_INTERNALFORMAT_STENCIL_TYPE = 0x827D

gl_INTERNALFORMAT_SUPPORTED :: GLenum
gl_INTERNALFORMAT_SUPPORTED = 0x826F

gl_INTERPOLATE :: GLenum
gl_INTERPOLATE = 0x8575

gl_INTERPOLATE_ARB :: GLenum
gl_INTERPOLATE_ARB = 0x8575

gl_INTERPOLATE_EXT :: GLenum
gl_INTERPOLATE_EXT = 0x8575

gl_INT_10_10_10_2_OES :: GLenum
gl_INT_10_10_10_2_OES = 0x8DF7

gl_INT_2_10_10_10_REV :: GLenum
gl_INT_2_10_10_10_REV = 0x8D9F

gl_INT_IMAGE_1D :: GLenum
gl_INT_IMAGE_1D = 0x9057

gl_INT_IMAGE_1D_ARRAY :: GLenum
gl_INT_IMAGE_1D_ARRAY = 0x905D

gl_INT_IMAGE_1D_ARRAY_EXT :: GLenum
gl_INT_IMAGE_1D_ARRAY_EXT = 0x905D

gl_INT_IMAGE_1D_EXT :: GLenum
gl_INT_IMAGE_1D_EXT = 0x9057

gl_INT_IMAGE_2D :: GLenum
gl_INT_IMAGE_2D = 0x9058

gl_INT_IMAGE_2D_ARRAY :: GLenum
gl_INT_IMAGE_2D_ARRAY = 0x905E

gl_INT_IMAGE_2D_ARRAY_EXT :: GLenum
gl_INT_IMAGE_2D_ARRAY_EXT = 0x905E

gl_INT_IMAGE_2D_EXT :: GLenum
gl_INT_IMAGE_2D_EXT = 0x9058

gl_INT_IMAGE_2D_MULTISAMPLE :: GLenum
gl_INT_IMAGE_2D_MULTISAMPLE = 0x9060

gl_INT_IMAGE_2D_MULTISAMPLE_ARRAY :: GLenum
gl_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061

gl_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT :: GLenum
gl_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x9061

gl_INT_IMAGE_2D_MULTISAMPLE_EXT :: GLenum
gl_INT_IMAGE_2D_MULTISAMPLE_EXT = 0x9060

gl_INT_IMAGE_2D_RECT :: GLenum
gl_INT_IMAGE_2D_RECT = 0x905A

gl_INT_IMAGE_2D_RECT_EXT :: GLenum
gl_INT_IMAGE_2D_RECT_EXT = 0x905A

gl_INT_IMAGE_3D :: GLenum
gl_INT_IMAGE_3D = 0x9059

gl_INT_IMAGE_3D_EXT :: GLenum
gl_INT_IMAGE_3D_EXT = 0x9059

gl_INT_IMAGE_BUFFER :: GLenum
gl_INT_IMAGE_BUFFER = 0x905C

gl_INT_IMAGE_BUFFER_EXT :: GLenum
gl_INT_IMAGE_BUFFER_EXT = 0x905C

gl_INT_IMAGE_BUFFER_OES :: GLenum
gl_INT_IMAGE_BUFFER_OES = 0x905C

gl_INT_IMAGE_CUBE :: GLenum
gl_INT_IMAGE_CUBE = 0x905B

gl_INT_IMAGE_CUBE_EXT :: GLenum
gl_INT_IMAGE_CUBE_EXT = 0x905B

gl_INT_IMAGE_CUBE_MAP_ARRAY :: GLenum
gl_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F

gl_INT_IMAGE_CUBE_MAP_ARRAY_EXT :: GLenum
gl_INT_IMAGE_CUBE_MAP_ARRAY_EXT = 0x905F

gl_INT_IMAGE_CUBE_MAP_ARRAY_OES :: GLenum
gl_INT_IMAGE_CUBE_MAP_ARRAY_OES = 0x905F

gl_INT_SAMPLER_1D :: GLenum
gl_INT_SAMPLER_1D = 0x8DC9

gl_INT_SAMPLER_1D_ARRAY :: GLenum
gl_INT_SAMPLER_1D_ARRAY = 0x8DCE

gl_INT_SAMPLER_1D_ARRAY_EXT :: GLenum
gl_INT_SAMPLER_1D_ARRAY_EXT = 0x8DCE

gl_INT_SAMPLER_1D_EXT :: GLenum
gl_INT_SAMPLER_1D_EXT = 0x8DC9

gl_INT_SAMPLER_2D :: GLenum
gl_INT_SAMPLER_2D = 0x8DCA

gl_INT_SAMPLER_2D_ARRAY :: GLenum
gl_INT_SAMPLER_2D_ARRAY = 0x8DCF

gl_INT_SAMPLER_2D_ARRAY_EXT :: GLenum
gl_INT_SAMPLER_2D_ARRAY_EXT = 0x8DCF

gl_INT_SAMPLER_2D_EXT :: GLenum
gl_INT_SAMPLER_2D_EXT = 0x8DCA

gl_INT_SAMPLER_2D_MULTISAMPLE :: GLenum
gl_INT_SAMPLER_2D_MULTISAMPLE = 0x9109

gl_INT_SAMPLER_2D_MULTISAMPLE_ARRAY :: GLenum
gl_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C

gl_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES :: GLenum
gl_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910C

gl_INT_SAMPLER_2D_RECT :: GLenum
gl_INT_SAMPLER_2D_RECT = 0x8DCD

gl_INT_SAMPLER_2D_RECT_EXT :: GLenum
gl_INT_SAMPLER_2D_RECT_EXT = 0x8DCD

gl_INT_SAMPLER_3D :: GLenum
gl_INT_SAMPLER_3D = 0x8DCB

gl_INT_SAMPLER_3D_EXT :: GLenum
gl_INT_SAMPLER_3D_EXT = 0x8DCB

gl_INT_SAMPLER_BUFFER :: GLenum
gl_INT_SAMPLER_BUFFER = 0x8DD0

gl_INT_SAMPLER_BUFFER_AMD :: GLenum
gl_INT_SAMPLER_BUFFER_AMD = 0x9002

gl_INT_SAMPLER_BUFFER_EXT :: GLenum
gl_INT_SAMPLER_BUFFER_EXT = 0x8DD0

gl_INT_SAMPLER_BUFFER_OES :: GLenum
gl_INT_SAMPLER_BUFFER_OES = 0x8DD0

gl_INT_SAMPLER_CUBE :: GLenum
gl_INT_SAMPLER_CUBE = 0x8DCC

gl_INT_SAMPLER_CUBE_EXT :: GLenum
gl_INT_SAMPLER_CUBE_EXT = 0x8DCC

gl_INT_SAMPLER_CUBE_MAP_ARRAY :: GLenum
gl_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E

gl_INT_SAMPLER_CUBE_MAP_ARRAY_ARB :: GLenum
gl_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900E

gl_INT_SAMPLER_CUBE_MAP_ARRAY_EXT :: GLenum
gl_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900E

gl_INT_SAMPLER_CUBE_MAP_ARRAY_OES :: GLenum
gl_INT_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900E

gl_INT_SAMPLER_RENDERBUFFER_NV :: GLenum
gl_INT_SAMPLER_RENDERBUFFER_NV = 0x8E57

gl_INT_VEC2 :: GLenum
gl_INT_VEC2 = 0x8B53

gl_INT_VEC2_ARB :: GLenum
gl_INT_VEC2_ARB = 0x8B53

gl_INT_VEC3 :: GLenum
gl_INT_VEC3 = 0x8B54

gl_INT_VEC3_ARB :: GLenum
gl_INT_VEC3_ARB = 0x8B54

gl_INT_VEC4 :: GLenum
gl_INT_VEC4 = 0x8B55

gl_INT_VEC4_ARB :: GLenum
gl_INT_VEC4_ARB = 0x8B55

gl_INVALID_ENUM :: GLenum
gl_INVALID_ENUM = 0x0500

gl_INVALID_FRAMEBUFFER_OPERATION :: GLenum
gl_INVALID_FRAMEBUFFER_OPERATION = 0x0506

gl_INVALID_FRAMEBUFFER_OPERATION_EXT :: GLenum
gl_INVALID_FRAMEBUFFER_OPERATION_EXT = 0x0506

gl_INVALID_FRAMEBUFFER_OPERATION_OES :: GLenum
gl_INVALID_FRAMEBUFFER_OPERATION_OES = 0x0506

gl_INVALID_INDEX :: GLuint
gl_INVALID_INDEX = 0xFFFFFFFF

gl_INVALID_OPERATION :: GLenum
gl_INVALID_OPERATION = 0x0502

gl_INVALID_VALUE :: GLenum
gl_INVALID_VALUE = 0x0501

gl_INVARIANT_DATATYPE_EXT :: GLenum
gl_INVARIANT_DATATYPE_EXT = 0x87EB

gl_INVARIANT_EXT :: GLenum
gl_INVARIANT_EXT = 0x87C2

gl_INVARIANT_VALUE_EXT :: GLenum
gl_INVARIANT_VALUE_EXT = 0x87EA

gl_INVERSE_NV :: GLenum
gl_INVERSE_NV = 0x862B

gl_INVERSE_TRANSPOSE_NV :: GLenum
gl_INVERSE_TRANSPOSE_NV = 0x862D

gl_INVERT :: GLenum
gl_INVERT = 0x150A

gl_INVERTED_SCREEN_W_REND :: GLenum
gl_INVERTED_SCREEN_W_REND = 0x8491

gl_INVERT_OVG_NV :: GLenum
gl_INVERT_OVG_NV = 0x92B4

gl_INVERT_RGB_NV :: GLenum
gl_INVERT_RGB_NV = 0x92A3

gl_IR_INSTRUMENT1_SGIX :: GLenum
gl_IR_INSTRUMENT1_SGIX = 0x817F

gl_ISOLINES :: GLenum
gl_ISOLINES = 0x8E7A

gl_ISOLINES_EXT :: GLenum
gl_ISOLINES_EXT = 0x8E7A

gl_ISOLINES_OES :: GLenum
gl_ISOLINES_OES = 0x8E7A

gl_IS_PER_PATCH :: GLenum
gl_IS_PER_PATCH = 0x92E7

gl_IS_PER_PATCH_EXT :: GLenum
gl_IS_PER_PATCH_EXT = 0x92E7

gl_IS_PER_PATCH_OES :: GLenum
gl_IS_PER_PATCH_OES = 0x92E7

gl_IS_ROW_MAJOR :: GLenum
gl_IS_ROW_MAJOR = 0x9300

gl_ITALIC_BIT_NV :: GLbitfield
gl_ITALIC_BIT_NV = 0x02

gl_IUI_N3F_V2F_EXT :: GLenum
gl_IUI_N3F_V2F_EXT = 0x81AF

gl_IUI_N3F_V3F_EXT :: GLenum
gl_IUI_N3F_V3F_EXT = 0x81B0

gl_IUI_V2F_EXT :: GLenum
gl_IUI_V2F_EXT = 0x81AD

gl_IUI_V3F_EXT :: GLenum
gl_IUI_V3F_EXT = 0x81AE

gl_KEEP :: GLenum
gl_KEEP = 0x1E00

gl_LARGE_CCW_ARC_TO_NV :: GLubyte
gl_LARGE_CCW_ARC_TO_NV = 0x16

gl_LARGE_CW_ARC_TO_NV :: GLubyte
gl_LARGE_CW_ARC_TO_NV = 0x18

gl_LAST_VERTEX_CONVENTION :: GLenum
gl_LAST_VERTEX_CONVENTION = 0x8E4E

gl_LAST_VERTEX_CONVENTION_EXT :: GLenum
gl_LAST_VERTEX_CONVENTION_EXT = 0x8E4E

gl_LAST_VERTEX_CONVENTION_OES :: GLenum
gl_LAST_VERTEX_CONVENTION_OES = 0x8E4E

gl_LAST_VIDEO_CAPTURE_STATUS_NV :: GLenum
gl_LAST_VIDEO_CAPTURE_STATUS_NV = 0x9027

gl_LAYER_NV :: GLenum
gl_LAYER_NV = 0x8DAA

gl_LAYER_PROVOKING_VERTEX :: GLenum
gl_LAYER_PROVOKING_VERTEX = 0x825E

gl_LAYER_PROVOKING_VERTEX_EXT :: GLenum
gl_LAYER_PROVOKING_VERTEX_EXT = 0x825E

gl_LAYER_PROVOKING_VERTEX_OES :: GLenum
gl_LAYER_PROVOKING_VERTEX_OES = 0x825E

gl_LAYOUT_DEFAULT_INTEL :: GLenum
gl_LAYOUT_DEFAULT_INTEL = 0

gl_LAYOUT_LINEAR_CPU_CACHED_INTEL :: GLenum
gl_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2

gl_LAYOUT_LINEAR_INTEL :: GLenum
gl_LAYOUT_LINEAR_INTEL = 1

gl_LEFT :: GLenum
gl_LEFT = 0x0406

gl_LEQUAL :: GLenum
gl_LEQUAL = 0x0203

gl_LERP_ATI :: GLenum
gl_LERP_ATI = 0x8969

gl_LESS :: GLenum
gl_LESS = 0x0201

gl_LIGHT0 :: GLenum
gl_LIGHT0 = 0x4000

gl_LIGHT1 :: GLenum
gl_LIGHT1 = 0x4001

gl_LIGHT2 :: GLenum
gl_LIGHT2 = 0x4002

gl_LIGHT3 :: GLenum
gl_LIGHT3 = 0x4003

gl_LIGHT4 :: GLenum
gl_LIGHT4 = 0x4004

gl_LIGHT5 :: GLenum
gl_LIGHT5 = 0x4005

gl_LIGHT6 :: GLenum
gl_LIGHT6 = 0x4006

gl_LIGHT7 :: GLenum
gl_LIGHT7 = 0x4007

gl_LIGHTEN_KHR :: GLenum
gl_LIGHTEN_KHR = 0x9298

gl_LIGHTEN_NV :: GLenum
gl_LIGHTEN_NV = 0x9298

gl_LIGHTING :: GLenum
gl_LIGHTING = 0x0B50

gl_LIGHTING_BIT :: GLbitfield
gl_LIGHTING_BIT = 0x00000040

gl_LIGHT_ENV_MODE_SGIX :: GLenum
gl_LIGHT_ENV_MODE_SGIX = 0x8407

gl_LIGHT_MODEL_AMBIENT :: GLenum
gl_LIGHT_MODEL_AMBIENT = 0x0B53

gl_LIGHT_MODEL_COLOR_CONTROL :: GLenum
gl_LIGHT_MODEL_COLOR_CONTROL = 0x81F8

gl_LIGHT_MODEL_COLOR_CONTROL_EXT :: GLenum
gl_LIGHT_MODEL_COLOR_CONTROL_EXT = 0x81F8

gl_LIGHT_MODEL_LOCAL_VIEWER :: GLenum
gl_LIGHT_MODEL_LOCAL_VIEWER = 0x0B51

gl_LIGHT_MODEL_SPECULAR_VECTOR_APPLE :: GLenum
gl_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = 0x85B0

gl_LIGHT_MODEL_TWO_SIDE :: GLenum
gl_LIGHT_MODEL_TWO_SIDE = 0x0B52

gl_LINE :: GLenum
gl_LINE = 0x1B01

gl_LINEAR :: GLenum
gl_LINEAR = 0x2601

gl_LINEARBURN_NV :: GLenum
gl_LINEARBURN_NV = 0x92A5

gl_LINEARDODGE_NV :: GLenum
gl_LINEARDODGE_NV = 0x92A4

gl_LINEARLIGHT_NV :: GLenum
gl_LINEARLIGHT_NV = 0x92A7

gl_LINEAR_ATTENUATION :: GLenum
gl_LINEAR_ATTENUATION = 0x1208

gl_LINEAR_CLIPMAP_LINEAR_SGIX :: GLenum
gl_LINEAR_CLIPMAP_LINEAR_SGIX = 0x8170

gl_LINEAR_CLIPMAP_NEAREST_SGIX :: GLenum
gl_LINEAR_CLIPMAP_NEAREST_SGIX = 0x844F

gl_LINEAR_DETAIL_ALPHA_SGIS :: GLenum
gl_LINEAR_DETAIL_ALPHA_SGIS = 0x8098

gl_LINEAR_DETAIL_COLOR_SGIS :: GLenum
gl_LINEAR_DETAIL_COLOR_SGIS = 0x8099

gl_LINEAR_DETAIL_SGIS :: GLenum
gl_LINEAR_DETAIL_SGIS = 0x8097

gl_LINEAR_MIPMAP_LINEAR :: GLenum
gl_LINEAR_MIPMAP_LINEAR = 0x2703

gl_LINEAR_MIPMAP_NEAREST :: GLenum
gl_LINEAR_MIPMAP_NEAREST = 0x2701

gl_LINEAR_SHARPEN_ALPHA_SGIS :: GLenum
gl_LINEAR_SHARPEN_ALPHA_SGIS = 0x80AE

gl_LINEAR_SHARPEN_COLOR_SGIS :: GLenum
gl_LINEAR_SHARPEN_COLOR_SGIS = 0x80AF

gl_LINEAR_SHARPEN_SGIS :: GLenum
gl_LINEAR_SHARPEN_SGIS = 0x80AD

gl_LINES :: GLenum
gl_LINES = 0x0001

gl_LINES_ADJACENCY :: GLenum
gl_LINES_ADJACENCY = 0x000A

gl_LINES_ADJACENCY_ARB :: GLenum
gl_LINES_ADJACENCY_ARB = 0x000A

gl_LINES_ADJACENCY_EXT :: GLenum
gl_LINES_ADJACENCY_EXT = 0x000A

gl_LINES_ADJACENCY_OES :: GLenum
gl_LINES_ADJACENCY_OES = 0x000A

gl_LINE_BIT :: GLbitfield
gl_LINE_BIT = 0x00000004

gl_LINE_LOOP :: GLenum
gl_LINE_LOOP = 0x0002

gl_LINE_QUALITY_HINT_SGIX :: GLenum
gl_LINE_QUALITY_HINT_SGIX = 0x835B

gl_LINE_RESET_TOKEN :: GLenum
gl_LINE_RESET_TOKEN = 0x0707

gl_LINE_SMOOTH :: GLenum
gl_LINE_SMOOTH = 0x0B20

gl_LINE_SMOOTH_HINT :: GLenum
gl_LINE_SMOOTH_HINT = 0x0C52

gl_LINE_STIPPLE :: GLenum
gl_LINE_STIPPLE = 0x0B24

gl_LINE_STIPPLE_PATTERN :: GLenum
gl_LINE_STIPPLE_PATTERN = 0x0B25

gl_LINE_STIPPLE_REPEAT :: GLenum
gl_LINE_STIPPLE_REPEAT = 0x0B26

gl_LINE_STRIP :: GLenum
gl_LINE_STRIP = 0x0003

gl_LINE_STRIP_ADJACENCY :: GLenum
gl_LINE_STRIP_ADJACENCY = 0x000B

gl_LINE_STRIP_ADJACENCY_ARB :: GLenum
gl_LINE_STRIP_ADJACENCY_ARB = 0x000B

gl_LINE_STRIP_ADJACENCY_EXT :: GLenum
gl_LINE_STRIP_ADJACENCY_EXT = 0x000B

gl_LINE_STRIP_ADJACENCY_OES :: GLenum
gl_LINE_STRIP_ADJACENCY_OES = 0x000B

gl_LINE_TOKEN :: GLenum
gl_LINE_TOKEN = 0x0702

gl_LINE_TO_NV :: GLubyte
gl_LINE_TO_NV = 0x04

gl_LINE_WIDTH :: GLenum
gl_LINE_WIDTH = 0x0B21

gl_LINE_WIDTH_GRANULARITY :: GLenum
gl_LINE_WIDTH_GRANULARITY = 0x0B23

gl_LINE_WIDTH_RANGE :: GLenum
gl_LINE_WIDTH_RANGE = 0x0B22

gl_LINK_STATUS :: GLenum
gl_LINK_STATUS = 0x8B82

gl_LIST_BASE :: GLenum
gl_LIST_BASE = 0x0B32

gl_LIST_BIT :: GLbitfield
gl_LIST_BIT = 0x00020000

gl_LIST_INDEX :: GLenum
gl_LIST_INDEX = 0x0B33

gl_LIST_MODE :: GLenum
gl_LIST_MODE = 0x0B30

gl_LIST_PRIORITY_SGIX :: GLenum
gl_LIST_PRIORITY_SGIX = 0x8182

gl_LOAD :: GLenum
gl_LOAD = 0x0101

gl_LOCAL_CONSTANT_DATATYPE_EXT :: GLenum
gl_LOCAL_CONSTANT_DATATYPE_EXT = 0x87ED

gl_LOCAL_CONSTANT_EXT :: GLenum
gl_LOCAL_CONSTANT_EXT = 0x87C3

gl_LOCAL_CONSTANT_VALUE_EXT :: GLenum
gl_LOCAL_CONSTANT_VALUE_EXT = 0x87EC

gl_LOCAL_EXT :: GLenum
gl_LOCAL_EXT = 0x87C4

gl_LOCATION :: GLenum
gl_LOCATION = 0x930E

gl_LOCATION_COMPONENT :: GLenum
gl_LOCATION_COMPONENT = 0x934A

gl_LOCATION_INDEX :: GLenum
gl_LOCATION_INDEX = 0x930F

gl_LOGIC_OP :: GLenum
gl_LOGIC_OP = 0x0BF1

gl_LOGIC_OP_MODE :: GLenum
gl_LOGIC_OP_MODE = 0x0BF0

gl_LOSE_CONTEXT_ON_RESET :: GLenum
gl_LOSE_CONTEXT_ON_RESET = 0x8252

gl_LOSE_CONTEXT_ON_RESET_ARB :: GLenum
gl_LOSE_CONTEXT_ON_RESET_ARB = 0x8252

gl_LOSE_CONTEXT_ON_RESET_EXT :: GLenum
gl_LOSE_CONTEXT_ON_RESET_EXT = 0x8252

gl_LOSE_CONTEXT_ON_RESET_KHR :: GLenum
gl_LOSE_CONTEXT_ON_RESET_KHR = 0x8252

gl_LOWER_LEFT :: GLenum
gl_LOWER_LEFT = 0x8CA1

gl_LOW_FLOAT :: GLenum
gl_LOW_FLOAT = 0x8DF0

gl_LOW_INT :: GLenum
gl_LOW_INT = 0x8DF3

gl_LO_BIAS_NV :: GLenum
gl_LO_BIAS_NV = 0x8715

gl_LO_SCALE_NV :: GLenum
gl_LO_SCALE_NV = 0x870F

gl_LUMINANCE :: GLenum
gl_LUMINANCE = 0x1909

gl_LUMINANCE12 :: GLenum
gl_LUMINANCE12 = 0x8041

gl_LUMINANCE12_ALPHA12 :: GLenum
gl_LUMINANCE12_ALPHA12 = 0x8047

gl_LUMINANCE12_ALPHA12_EXT :: GLenum
gl_LUMINANCE12_ALPHA12_EXT = 0x8047

gl_LUMINANCE12_ALPHA4 :: GLenum
gl_LUMINANCE12_ALPHA4 = 0x8046

gl_LUMINANCE12_ALPHA4_EXT :: GLenum
gl_LUMINANCE12_ALPHA4_EXT = 0x8046

gl_LUMINANCE12_EXT :: GLenum
gl_LUMINANCE12_EXT = 0x8041

gl_LUMINANCE16 :: GLenum
gl_LUMINANCE16 = 0x8042

gl_LUMINANCE16F_ARB :: GLenum
gl_LUMINANCE16F_ARB = 0x881E

gl_LUMINANCE16F_EXT :: GLenum
gl_LUMINANCE16F_EXT = 0x881E

gl_LUMINANCE16I_EXT :: GLenum
gl_LUMINANCE16I_EXT = 0x8D8C

gl_LUMINANCE16UI_EXT :: GLenum
gl_LUMINANCE16UI_EXT = 0x8D7A

gl_LUMINANCE16_ALPHA16 :: GLenum
gl_LUMINANCE16_ALPHA16 = 0x8048

gl_LUMINANCE16_ALPHA16_EXT :: GLenum
gl_LUMINANCE16_ALPHA16_EXT = 0x8048

gl_LUMINANCE16_ALPHA16_SNORM :: GLenum
gl_LUMINANCE16_ALPHA16_SNORM = 0x901A

gl_LUMINANCE16_EXT :: GLenum
gl_LUMINANCE16_EXT = 0x8042

gl_LUMINANCE16_SNORM :: GLenum
gl_LUMINANCE16_SNORM = 0x9019

gl_LUMINANCE32F_ARB :: GLenum
gl_LUMINANCE32F_ARB = 0x8818

gl_LUMINANCE32F_EXT :: GLenum
gl_LUMINANCE32F_EXT = 0x8818

gl_LUMINANCE32I_EXT :: GLenum
gl_LUMINANCE32I_EXT = 0x8D86

gl_LUMINANCE32UI_EXT :: GLenum
gl_LUMINANCE32UI_EXT = 0x8D74

gl_LUMINANCE4 :: GLenum
gl_LUMINANCE4 = 0x803F

gl_LUMINANCE4_ALPHA4 :: GLenum
gl_LUMINANCE4_ALPHA4 = 0x8043

gl_LUMINANCE4_ALPHA4_EXT :: GLenum
gl_LUMINANCE4_ALPHA4_EXT = 0x8043

gl_LUMINANCE4_ALPHA4_OES :: GLenum
gl_LUMINANCE4_ALPHA4_OES = 0x8043

gl_LUMINANCE4_EXT :: GLenum
gl_LUMINANCE4_EXT = 0x803F

gl_LUMINANCE6_ALPHA2 :: GLenum
gl_LUMINANCE6_ALPHA2 = 0x8044

gl_LUMINANCE6_ALPHA2_EXT :: GLenum
gl_LUMINANCE6_ALPHA2_EXT = 0x8044

gl_LUMINANCE8 :: GLenum
gl_LUMINANCE8 = 0x8040

gl_LUMINANCE8I_EXT :: GLenum
gl_LUMINANCE8I_EXT = 0x8D92

gl_LUMINANCE8UI_EXT :: GLenum
gl_LUMINANCE8UI_EXT = 0x8D80

gl_LUMINANCE8_ALPHA8 :: GLenum
gl_LUMINANCE8_ALPHA8 = 0x8045

gl_LUMINANCE8_ALPHA8_EXT :: GLenum
gl_LUMINANCE8_ALPHA8_EXT = 0x8045

gl_LUMINANCE8_ALPHA8_OES :: GLenum
gl_LUMINANCE8_ALPHA8_OES = 0x8045

gl_LUMINANCE8_ALPHA8_SNORM :: GLenum
gl_LUMINANCE8_ALPHA8_SNORM = 0x9016

gl_LUMINANCE8_EXT :: GLenum
gl_LUMINANCE8_EXT = 0x8040

gl_LUMINANCE8_OES :: GLenum
gl_LUMINANCE8_OES = 0x8040

gl_LUMINANCE8_SNORM :: GLenum
gl_LUMINANCE8_SNORM = 0x9015

gl_LUMINANCE_ALPHA :: GLenum
gl_LUMINANCE_ALPHA = 0x190A

gl_LUMINANCE_ALPHA16F_ARB :: GLenum
gl_LUMINANCE_ALPHA16F_ARB = 0x881F

gl_LUMINANCE_ALPHA16F_EXT :: GLenum
gl_LUMINANCE_ALPHA16F_EXT = 0x881F

gl_LUMINANCE_ALPHA16I_EXT :: GLenum
gl_LUMINANCE_ALPHA16I_EXT = 0x8D8D

gl_LUMINANCE_ALPHA16UI_EXT :: GLenum
gl_LUMINANCE_ALPHA16UI_EXT = 0x8D7B

gl_LUMINANCE_ALPHA32F_ARB :: GLenum
gl_LUMINANCE_ALPHA32F_ARB = 0x8819

gl_LUMINANCE_ALPHA32F_EXT :: GLenum
gl_LUMINANCE_ALPHA32F_EXT = 0x8819

gl_LUMINANCE_ALPHA32I_EXT :: GLenum
gl_LUMINANCE_ALPHA32I_EXT = 0x8D87

gl_LUMINANCE_ALPHA32UI_EXT :: GLenum
gl_LUMINANCE_ALPHA32UI_EXT = 0x8D75

gl_LUMINANCE_ALPHA8I_EXT :: GLenum
gl_LUMINANCE_ALPHA8I_EXT = 0x8D93

gl_LUMINANCE_ALPHA8UI_EXT :: GLenum
gl_LUMINANCE_ALPHA8UI_EXT = 0x8D81

gl_LUMINANCE_ALPHA_FLOAT16_APPLE :: GLenum
gl_LUMINANCE_ALPHA_FLOAT16_APPLE = 0x881F

gl_LUMINANCE_ALPHA_FLOAT16_ATI :: GLenum
gl_LUMINANCE_ALPHA_FLOAT16_ATI = 0x881F

gl_LUMINANCE_ALPHA_FLOAT32_APPLE :: GLenum
gl_LUMINANCE_ALPHA_FLOAT32_APPLE = 0x8819

gl_LUMINANCE_ALPHA_FLOAT32_ATI :: GLenum
gl_LUMINANCE_ALPHA_FLOAT32_ATI = 0x8819

gl_LUMINANCE_ALPHA_INTEGER_EXT :: GLenum
gl_LUMINANCE_ALPHA_INTEGER_EXT = 0x8D9D

gl_LUMINANCE_ALPHA_SNORM :: GLenum
gl_LUMINANCE_ALPHA_SNORM = 0x9012

gl_LUMINANCE_FLOAT16_APPLE :: GLenum
gl_LUMINANCE_FLOAT16_APPLE = 0x881E

gl_LUMINANCE_FLOAT16_ATI :: GLenum
gl_LUMINANCE_FLOAT16_ATI = 0x881E

gl_LUMINANCE_FLOAT32_APPLE :: GLenum
gl_LUMINANCE_FLOAT32_APPLE = 0x8818

gl_LUMINANCE_FLOAT32_ATI :: GLenum
gl_LUMINANCE_FLOAT32_ATI = 0x8818

gl_LUMINANCE_INTEGER_EXT :: GLenum
gl_LUMINANCE_INTEGER_EXT = 0x8D9C

gl_LUMINANCE_SNORM :: GLenum
gl_LUMINANCE_SNORM = 0x9011

gl_MAD_ATI :: GLenum
gl_MAD_ATI = 0x8968

gl_MAGNITUDE_BIAS_NV :: GLenum
gl_MAGNITUDE_BIAS_NV = 0x8718

gl_MAGNITUDE_SCALE_NV :: GLenum
gl_MAGNITUDE_SCALE_NV = 0x8712

gl_MAJOR_VERSION :: GLenum
gl_MAJOR_VERSION = 0x821B

gl_MALI_PROGRAM_BINARY_ARM :: GLenum
gl_MALI_PROGRAM_BINARY_ARM = 0x8F61

gl_MALI_SHADER_BINARY_ARM :: GLenum
gl_MALI_SHADER_BINARY_ARM = 0x8F60

gl_MANUAL_GENERATE_MIPMAP :: GLenum
gl_MANUAL_GENERATE_MIPMAP = 0x8294

gl_MAP1_BINORMAL_EXT :: GLenum
gl_MAP1_BINORMAL_EXT = 0x8446

gl_MAP1_COLOR_4 :: GLenum
gl_MAP1_COLOR_4 = 0x0D90

gl_MAP1_GRID_DOMAIN :: GLenum
gl_MAP1_GRID_DOMAIN = 0x0DD0

gl_MAP1_GRID_SEGMENTS :: GLenum
gl_MAP1_GRID_SEGMENTS = 0x0DD1

gl_MAP1_INDEX :: GLenum
gl_MAP1_INDEX = 0x0D91

gl_MAP1_NORMAL :: GLenum
gl_MAP1_NORMAL = 0x0D92

gl_MAP1_TANGENT_EXT :: GLenum
gl_MAP1_TANGENT_EXT = 0x8444

gl_MAP1_TEXTURE_COORD_1 :: GLenum
gl_MAP1_TEXTURE_COORD_1 = 0x0D93

gl_MAP1_TEXTURE_COORD_2 :: GLenum
gl_MAP1_TEXTURE_COORD_2 = 0x0D94

gl_MAP1_TEXTURE_COORD_3 :: GLenum
gl_MAP1_TEXTURE_COORD_3 = 0x0D95

gl_MAP1_TEXTURE_COORD_4 :: GLenum
gl_MAP1_TEXTURE_COORD_4 = 0x0D96

gl_MAP1_VERTEX_3 :: GLenum
gl_MAP1_VERTEX_3 = 0x0D97

gl_MAP1_VERTEX_4 :: GLenum
gl_MAP1_VERTEX_4 = 0x0D98

gl_MAP1_VERTEX_ATTRIB0_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB0_4_NV = 0x8660

gl_MAP1_VERTEX_ATTRIB10_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB10_4_NV = 0x866A

gl_MAP1_VERTEX_ATTRIB11_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB11_4_NV = 0x866B

gl_MAP1_VERTEX_ATTRIB12_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB12_4_NV = 0x866C

gl_MAP1_VERTEX_ATTRIB13_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB13_4_NV = 0x866D

gl_MAP1_VERTEX_ATTRIB14_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB14_4_NV = 0x866E

gl_MAP1_VERTEX_ATTRIB15_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB15_4_NV = 0x866F

gl_MAP1_VERTEX_ATTRIB1_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB1_4_NV = 0x8661

gl_MAP1_VERTEX_ATTRIB2_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB2_4_NV = 0x8662

gl_MAP1_VERTEX_ATTRIB3_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB3_4_NV = 0x8663

gl_MAP1_VERTEX_ATTRIB4_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB4_4_NV = 0x8664

gl_MAP1_VERTEX_ATTRIB5_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB5_4_NV = 0x8665

gl_MAP1_VERTEX_ATTRIB6_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB6_4_NV = 0x8666

gl_MAP1_VERTEX_ATTRIB7_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB7_4_NV = 0x8667

gl_MAP1_VERTEX_ATTRIB8_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB8_4_NV = 0x8668

gl_MAP1_VERTEX_ATTRIB9_4_NV :: GLenum
gl_MAP1_VERTEX_ATTRIB9_4_NV = 0x8669

gl_MAP2_BINORMAL_EXT :: GLenum
gl_MAP2_BINORMAL_EXT = 0x8447

gl_MAP2_COLOR_4 :: GLenum
gl_MAP2_COLOR_4 = 0x0DB0

gl_MAP2_GRID_DOMAIN :: GLenum
gl_MAP2_GRID_DOMAIN = 0x0DD2

gl_MAP2_GRID_SEGMENTS :: GLenum
gl_MAP2_GRID_SEGMENTS = 0x0DD3

gl_MAP2_INDEX :: GLenum
gl_MAP2_INDEX = 0x0DB1

gl_MAP2_NORMAL :: GLenum
gl_MAP2_NORMAL = 0x0DB2

gl_MAP2_TANGENT_EXT :: GLenum
gl_MAP2_TANGENT_EXT = 0x8445

gl_MAP2_TEXTURE_COORD_1 :: GLenum
gl_MAP2_TEXTURE_COORD_1 = 0x0DB3

gl_MAP2_TEXTURE_COORD_2 :: GLenum
gl_MAP2_TEXTURE_COORD_2 = 0x0DB4

gl_MAP2_TEXTURE_COORD_3 :: GLenum
gl_MAP2_TEXTURE_COORD_3 = 0x0DB5

gl_MAP2_TEXTURE_COORD_4 :: GLenum
gl_MAP2_TEXTURE_COORD_4 = 0x0DB6

gl_MAP2_VERTEX_3 :: GLenum
gl_MAP2_VERTEX_3 = 0x0DB7

gl_MAP2_VERTEX_4 :: GLenum
gl_MAP2_VERTEX_4 = 0x0DB8

gl_MAP2_VERTEX_ATTRIB0_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB0_4_NV = 0x8670

gl_MAP2_VERTEX_ATTRIB10_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB10_4_NV = 0x867A

gl_MAP2_VERTEX_ATTRIB11_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB11_4_NV = 0x867B

gl_MAP2_VERTEX_ATTRIB12_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB12_4_NV = 0x867C

gl_MAP2_VERTEX_ATTRIB13_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB13_4_NV = 0x867D

gl_MAP2_VERTEX_ATTRIB14_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB14_4_NV = 0x867E

gl_MAP2_VERTEX_ATTRIB15_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB15_4_NV = 0x867F

gl_MAP2_VERTEX_ATTRIB1_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB1_4_NV = 0x8671

gl_MAP2_VERTEX_ATTRIB2_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB2_4_NV = 0x8672

gl_MAP2_VERTEX_ATTRIB3_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB3_4_NV = 0x8673

gl_MAP2_VERTEX_ATTRIB4_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB4_4_NV = 0x8674

gl_MAP2_VERTEX_ATTRIB5_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB5_4_NV = 0x8675

gl_MAP2_VERTEX_ATTRIB6_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB6_4_NV = 0x8676

gl_MAP2_VERTEX_ATTRIB7_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB7_4_NV = 0x8677

gl_MAP2_VERTEX_ATTRIB8_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB8_4_NV = 0x8678

gl_MAP2_VERTEX_ATTRIB9_4_NV :: GLenum
gl_MAP2_VERTEX_ATTRIB9_4_NV = 0x8679

gl_MAP_ATTRIB_U_ORDER_NV :: GLenum
gl_MAP_ATTRIB_U_ORDER_NV = 0x86C3

gl_MAP_ATTRIB_V_ORDER_NV :: GLenum
gl_MAP_ATTRIB_V_ORDER_NV = 0x86C4

gl_MAP_COHERENT_BIT :: GLbitfield
gl_MAP_COHERENT_BIT = 0x0080

gl_MAP_COLOR :: GLenum
gl_MAP_COLOR = 0x0D10

gl_MAP_FLUSH_EXPLICIT_BIT :: GLbitfield
gl_MAP_FLUSH_EXPLICIT_BIT = 0x0010

gl_MAP_FLUSH_EXPLICIT_BIT_EXT :: GLbitfield
gl_MAP_FLUSH_EXPLICIT_BIT_EXT = 0x0010

gl_MAP_INVALIDATE_BUFFER_BIT :: GLbitfield
gl_MAP_INVALIDATE_BUFFER_BIT = 0x0008

gl_MAP_INVALIDATE_BUFFER_BIT_EXT :: GLbitfield
gl_MAP_INVALIDATE_BUFFER_BIT_EXT = 0x0008

gl_MAP_INVALIDATE_RANGE_BIT :: GLbitfield
gl_MAP_INVALIDATE_RANGE_BIT = 0x0004

gl_MAP_INVALIDATE_RANGE_BIT_EXT :: GLbitfield
gl_MAP_INVALIDATE_RANGE_BIT_EXT = 0x0004

gl_MAP_PERSISTENT_BIT :: GLbitfield
gl_MAP_PERSISTENT_BIT = 0x0040

gl_MAP_READ_BIT :: GLbitfield
gl_MAP_READ_BIT = 0x0001

gl_MAP_READ_BIT_EXT :: GLbitfield
gl_MAP_READ_BIT_EXT = 0x0001

gl_MAP_STENCIL :: GLenum
gl_MAP_STENCIL = 0x0D11

gl_MAP_TESSELLATION_NV :: GLenum
gl_MAP_TESSELLATION_NV = 0x86C2

gl_MAP_UNSYNCHRONIZED_BIT :: GLbitfield
gl_MAP_UNSYNCHRONIZED_BIT = 0x0020

gl_MAP_UNSYNCHRONIZED_BIT_EXT :: GLbitfield
gl_MAP_UNSYNCHRONIZED_BIT_EXT = 0x0020

gl_MAP_WRITE_BIT :: GLbitfield
gl_MAP_WRITE_BIT = 0x0002

gl_MAP_WRITE_BIT_EXT :: GLbitfield
gl_MAP_WRITE_BIT_EXT = 0x0002

gl_MATERIAL_SIDE_HINT_PGI :: GLenum
gl_MATERIAL_SIDE_HINT_PGI = 0x1A22C

gl_MATRIX0_ARB :: GLenum
gl_MATRIX0_ARB = 0x88C0

gl_MATRIX0_NV :: GLenum
gl_MATRIX0_NV = 0x8630

gl_MATRIX10_ARB :: GLenum
gl_MATRIX10_ARB = 0x88CA

gl_MATRIX11_ARB :: GLenum
gl_MATRIX11_ARB = 0x88CB

gl_MATRIX12_ARB :: GLenum
gl_MATRIX12_ARB = 0x88CC

gl_MATRIX13_ARB :: GLenum
gl_MATRIX13_ARB = 0x88CD

gl_MATRIX14_ARB :: GLenum
gl_MATRIX14_ARB = 0x88CE

gl_MATRIX15_ARB :: GLenum
gl_MATRIX15_ARB = 0x88CF

gl_MATRIX16_ARB :: GLenum
gl_MATRIX16_ARB = 0x88D0

gl_MATRIX17_ARB :: GLenum
gl_MATRIX17_ARB = 0x88D1

gl_MATRIX18_ARB :: GLenum
gl_MATRIX18_ARB = 0x88D2

gl_MATRIX19_ARB :: GLenum
gl_MATRIX19_ARB = 0x88D3

gl_MATRIX1_ARB :: GLenum
gl_MATRIX1_ARB = 0x88C1

gl_MATRIX1_NV :: GLenum
gl_MATRIX1_NV = 0x8631

gl_MATRIX20_ARB :: GLenum
gl_MATRIX20_ARB = 0x88D4

gl_MATRIX21_ARB :: GLenum
gl_MATRIX21_ARB = 0x88D5

gl_MATRIX22_ARB :: GLenum
gl_MATRIX22_ARB = 0x88D6

gl_MATRIX23_ARB :: GLenum
gl_MATRIX23_ARB = 0x88D7

gl_MATRIX24_ARB :: GLenum
gl_MATRIX24_ARB = 0x88D8

gl_MATRIX25_ARB :: GLenum
gl_MATRIX25_ARB = 0x88D9

gl_MATRIX26_ARB :: GLenum
gl_MATRIX26_ARB = 0x88DA

gl_MATRIX27_ARB :: GLenum
gl_MATRIX27_ARB = 0x88DB

gl_MATRIX28_ARB :: GLenum
gl_MATRIX28_ARB = 0x88DC

gl_MATRIX29_ARB :: GLenum
gl_MATRIX29_ARB = 0x88DD

gl_MATRIX2_ARB :: GLenum
gl_MATRIX2_ARB = 0x88C2

gl_MATRIX2_NV :: GLenum
gl_MATRIX2_NV = 0x8632

gl_MATRIX30_ARB :: GLenum
gl_MATRIX30_ARB = 0x88DE

gl_MATRIX31_ARB :: GLenum
gl_MATRIX31_ARB = 0x88DF

gl_MATRIX3_ARB :: GLenum
gl_MATRIX3_ARB = 0x88C3

gl_MATRIX3_NV :: GLenum
gl_MATRIX3_NV = 0x8633

gl_MATRIX4_ARB :: GLenum
gl_MATRIX4_ARB = 0x88C4

gl_MATRIX4_NV :: GLenum
gl_MATRIX4_NV = 0x8634

gl_MATRIX5_ARB :: GLenum
gl_MATRIX5_ARB = 0x88C5

gl_MATRIX5_NV :: GLenum
gl_MATRIX5_NV = 0x8635

gl_MATRIX6_ARB :: GLenum
gl_MATRIX6_ARB = 0x88C6

gl_MATRIX6_NV :: GLenum
gl_MATRIX6_NV = 0x8636

gl_MATRIX7_ARB :: GLenum
gl_MATRIX7_ARB = 0x88C7

gl_MATRIX7_NV :: GLenum
gl_MATRIX7_NV = 0x8637

gl_MATRIX8_ARB :: GLenum
gl_MATRIX8_ARB = 0x88C8

gl_MATRIX9_ARB :: GLenum
gl_MATRIX9_ARB = 0x88C9

gl_MATRIX_EXT :: GLenum
gl_MATRIX_EXT = 0x87C0

gl_MATRIX_INDEX_ARRAY_ARB :: GLenum
gl_MATRIX_INDEX_ARRAY_ARB = 0x8844

gl_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES :: GLenum
gl_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES = 0x8B9E

gl_MATRIX_INDEX_ARRAY_OES :: GLenum
gl_MATRIX_INDEX_ARRAY_OES = 0x8844

gl_MATRIX_INDEX_ARRAY_POINTER_ARB :: GLenum
gl_MATRIX_INDEX_ARRAY_POINTER_ARB = 0x8849

gl_MATRIX_INDEX_ARRAY_POINTER_OES :: GLenum
gl_MATRIX_INDEX_ARRAY_POINTER_OES = 0x8849

gl_MATRIX_INDEX_ARRAY_SIZE_ARB :: GLenum
gl_MATRIX_INDEX_ARRAY_SIZE_ARB = 0x8846

gl_MATRIX_INDEX_ARRAY_SIZE_OES :: GLenum
gl_MATRIX_INDEX_ARRAY_SIZE_OES = 0x8846

gl_MATRIX_INDEX_ARRAY_STRIDE_ARB :: GLenum
gl_MATRIX_INDEX_ARRAY_STRIDE_ARB = 0x8848

gl_MATRIX_INDEX_ARRAY_STRIDE_OES :: GLenum
gl_MATRIX_INDEX_ARRAY_STRIDE_OES = 0x8848

gl_MATRIX_INDEX_ARRAY_TYPE_ARB :: GLenum
gl_MATRIX_INDEX_ARRAY_TYPE_ARB = 0x8847

gl_MATRIX_INDEX_ARRAY_TYPE_OES :: GLenum
gl_MATRIX_INDEX_ARRAY_TYPE_OES = 0x8847

gl_MATRIX_MODE :: GLenum
gl_MATRIX_MODE = 0x0BA0

gl_MATRIX_PALETTE_ARB :: GLenum
gl_MATRIX_PALETTE_ARB = 0x8840

gl_MATRIX_PALETTE_OES :: GLenum
gl_MATRIX_PALETTE_OES = 0x8840

gl_MATRIX_STRIDE :: GLenum
gl_MATRIX_STRIDE = 0x92FF

gl_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI :: GLbitfield
gl_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI = 0x00200000

gl_MAT_AMBIENT_BIT_PGI :: GLbitfield
gl_MAT_AMBIENT_BIT_PGI = 0x00100000

gl_MAT_COLOR_INDEXES_BIT_PGI :: GLbitfield
gl_MAT_COLOR_INDEXES_BIT_PGI = 0x01000000

gl_MAT_DIFFUSE_BIT_PGI :: GLbitfield
gl_MAT_DIFFUSE_BIT_PGI = 0x00400000

gl_MAT_EMISSION_BIT_PGI :: GLbitfield
gl_MAT_EMISSION_BIT_PGI = 0x00800000

gl_MAT_SHININESS_BIT_PGI :: GLbitfield
gl_MAT_SHININESS_BIT_PGI = 0x02000000

gl_MAT_SPECULAR_BIT_PGI :: GLbitfield
gl_MAT_SPECULAR_BIT_PGI = 0x04000000

gl_MAX :: GLenum
gl_MAX = 0x8008

gl_MAX_3D_TEXTURE_SIZE :: GLenum
gl_MAX_3D_TEXTURE_SIZE = 0x8073

gl_MAX_3D_TEXTURE_SIZE_EXT :: GLenum
gl_MAX_3D_TEXTURE_SIZE_EXT = 0x8073

gl_MAX_3D_TEXTURE_SIZE_OES :: GLenum
gl_MAX_3D_TEXTURE_SIZE_OES = 0x8073

gl_MAX_4D_TEXTURE_SIZE_SGIS :: GLenum
gl_MAX_4D_TEXTURE_SIZE_SGIS = 0x8138

gl_MAX_ACTIVE_LIGHTS_SGIX :: GLenum
gl_MAX_ACTIVE_LIGHTS_SGIX = 0x8405

gl_MAX_ARRAY_TEXTURE_LAYERS :: GLenum
gl_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF

gl_MAX_ARRAY_TEXTURE_LAYERS_EXT :: GLenum
gl_MAX_ARRAY_TEXTURE_LAYERS_EXT = 0x88FF

gl_MAX_ASYNC_DRAW_PIXELS_SGIX :: GLenum
gl_MAX_ASYNC_DRAW_PIXELS_SGIX = 0x8360

gl_MAX_ASYNC_HISTOGRAM_SGIX :: GLenum
gl_MAX_ASYNC_HISTOGRAM_SGIX = 0x832D

gl_MAX_ASYNC_READ_PIXELS_SGIX :: GLenum
gl_MAX_ASYNC_READ_PIXELS_SGIX = 0x8361

gl_MAX_ASYNC_TEX_IMAGE_SGIX :: GLenum
gl_MAX_ASYNC_TEX_IMAGE_SGIX = 0x835F

gl_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS :: GLenum
gl_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 0x92DC

gl_MAX_ATOMIC_COUNTER_BUFFER_SIZE :: GLenum
gl_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 0x92D8

gl_MAX_ATTRIB_STACK_DEPTH :: GLenum
gl_MAX_ATTRIB_STACK_DEPTH = 0x0D35

gl_MAX_BINDABLE_UNIFORM_SIZE_EXT :: GLenum
gl_MAX_BINDABLE_UNIFORM_SIZE_EXT = 0x8DED

gl_MAX_CLIENT_ATTRIB_STACK_DEPTH :: GLenum
gl_MAX_CLIENT_ATTRIB_STACK_DEPTH = 0x0D3B

gl_MAX_CLIPMAP_DEPTH_SGIX :: GLenum
gl_MAX_CLIPMAP_DEPTH_SGIX = 0x8177

gl_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX :: GLenum
gl_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX = 0x8178

gl_MAX_CLIP_DISTANCES :: GLenum
gl_MAX_CLIP_DISTANCES = 0x0D32

gl_MAX_CLIP_DISTANCES_APPLE :: GLenum
gl_MAX_CLIP_DISTANCES_APPLE = 0x0D32

gl_MAX_CLIP_PLANES :: GLenum
gl_MAX_CLIP_PLANES = 0x0D32

gl_MAX_CLIP_PLANES_IMG :: GLenum
gl_MAX_CLIP_PLANES_IMG = 0x0D32

gl_MAX_COLOR_ATTACHMENTS :: GLenum
gl_MAX_COLOR_ATTACHMENTS = 0x8CDF

gl_MAX_COLOR_ATTACHMENTS_EXT :: GLenum
gl_MAX_COLOR_ATTACHMENTS_EXT = 0x8CDF

gl_MAX_COLOR_ATTACHMENTS_NV :: GLenum
gl_MAX_COLOR_ATTACHMENTS_NV = 0x8CDF

gl_MAX_COLOR_MATRIX_STACK_DEPTH :: GLenum
gl_MAX_COLOR_MATRIX_STACK_DEPTH = 0x80B3

gl_MAX_COLOR_MATRIX_STACK_DEPTH_SGI :: GLenum
gl_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = 0x80B3

gl_MAX_COLOR_TEXTURE_SAMPLES :: GLenum
gl_MAX_COLOR_TEXTURE_SAMPLES = 0x910E

gl_MAX_COMBINED_ATOMIC_COUNTERS :: GLenum
gl_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7

gl_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS :: GLenum
gl_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 0x92D1

gl_MAX_COMBINED_CLIP_AND_CULL_DISTANCES :: GLenum
gl_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 0x82FA

gl_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 0x8266

gl_MAX_COMBINED_DIMENSIONS :: GLenum
gl_MAX_COMBINED_DIMENSIONS = 0x8282

gl_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 0x8A33

gl_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 0x8A32

gl_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT :: GLenum
gl_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT = 0x8A32

gl_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES :: GLenum
gl_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES = 0x8A32

gl_MAX_COMBINED_IMAGE_UNIFORMS :: GLenum
gl_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF

gl_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS :: GLenum
gl_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39

gl_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT :: GLenum
gl_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT = 0x8F39

gl_MAX_COMBINED_SHADER_OUTPUT_RESOURCES :: GLenum
gl_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 0x8F39

gl_MAX_COMBINED_SHADER_STORAGE_BLOCKS :: GLenum
gl_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 0x90DC

gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E

gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT :: GLenum
gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = 0x8E1E

gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES :: GLenum
gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES = 0x8E1E

gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F

gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT :: GLenum
gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = 0x8E1F

gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES :: GLenum
gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = 0x8E1F

gl_MAX_COMBINED_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D

gl_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB :: GLenum
gl_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = 0x8B4D

gl_MAX_COMBINED_UNIFORM_BLOCKS :: GLenum
gl_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E

gl_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 0x8A31

gl_MAX_COMPUTE_ATOMIC_COUNTERS :: GLenum
gl_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265

gl_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS :: GLenum
gl_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 0x8264

gl_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB :: GLenum
gl_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB = 0x90EB

gl_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB :: GLenum
gl_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB = 0x91BF

gl_MAX_COMPUTE_IMAGE_UNIFORMS :: GLenum
gl_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD

gl_MAX_COMPUTE_SHADER_STORAGE_BLOCKS :: GLenum
gl_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 0x90DB

gl_MAX_COMPUTE_SHARED_MEMORY_SIZE :: GLenum
gl_MAX_COMPUTE_SHARED_MEMORY_SIZE = 0x8262

gl_MAX_COMPUTE_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 0x91BC

gl_MAX_COMPUTE_UNIFORM_BLOCKS :: GLenum
gl_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB

gl_MAX_COMPUTE_UNIFORM_COMPONENTS :: GLenum
gl_MAX_COMPUTE_UNIFORM_COMPONENTS = 0x8263

gl_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB :: GLenum
gl_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB = 0x9344

gl_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB :: GLenum
gl_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB = 0x9345

gl_MAX_COMPUTE_WORK_GROUP_COUNT :: GLenum
gl_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE

gl_MAX_COMPUTE_WORK_GROUP_INVOCATIONS :: GLenum
gl_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 0x90EB

gl_MAX_COMPUTE_WORK_GROUP_SIZE :: GLenum
gl_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF

gl_MAX_CONVOLUTION_HEIGHT :: GLenum
gl_MAX_CONVOLUTION_HEIGHT = 0x801B

gl_MAX_CONVOLUTION_HEIGHT_EXT :: GLenum
gl_MAX_CONVOLUTION_HEIGHT_EXT = 0x801B

gl_MAX_CONVOLUTION_WIDTH :: GLenum
gl_MAX_CONVOLUTION_WIDTH = 0x801A

gl_MAX_CONVOLUTION_WIDTH_EXT :: GLenum
gl_MAX_CONVOLUTION_WIDTH_EXT = 0x801A

gl_MAX_CUBE_MAP_TEXTURE_SIZE :: GLenum
gl_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C

gl_MAX_CUBE_MAP_TEXTURE_SIZE_ARB :: GLenum
gl_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = 0x851C

gl_MAX_CUBE_MAP_TEXTURE_SIZE_EXT :: GLenum
gl_MAX_CUBE_MAP_TEXTURE_SIZE_EXT = 0x851C

gl_MAX_CUBE_MAP_TEXTURE_SIZE_OES :: GLenum
gl_MAX_CUBE_MAP_TEXTURE_SIZE_OES = 0x851C

gl_MAX_CULL_DISTANCES :: GLenum
gl_MAX_CULL_DISTANCES = 0x82F9

gl_MAX_DEBUG_GROUP_STACK_DEPTH :: GLenum
gl_MAX_DEBUG_GROUP_STACK_DEPTH = 0x826C

gl_MAX_DEBUG_GROUP_STACK_DEPTH_KHR :: GLenum
gl_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 0x826C

gl_MAX_DEBUG_LOGGED_MESSAGES :: GLenum
gl_MAX_DEBUG_LOGGED_MESSAGES = 0x9144

gl_MAX_DEBUG_LOGGED_MESSAGES_AMD :: GLenum
gl_MAX_DEBUG_LOGGED_MESSAGES_AMD = 0x9144

gl_MAX_DEBUG_LOGGED_MESSAGES_ARB :: GLenum
gl_MAX_DEBUG_LOGGED_MESSAGES_ARB = 0x9144

gl_MAX_DEBUG_LOGGED_MESSAGES_KHR :: GLenum
gl_MAX_DEBUG_LOGGED_MESSAGES_KHR = 0x9144

gl_MAX_DEBUG_MESSAGE_LENGTH :: GLenum
gl_MAX_DEBUG_MESSAGE_LENGTH = 0x9143

gl_MAX_DEBUG_MESSAGE_LENGTH_AMD :: GLenum
gl_MAX_DEBUG_MESSAGE_LENGTH_AMD = 0x9143

gl_MAX_DEBUG_MESSAGE_LENGTH_ARB :: GLenum
gl_MAX_DEBUG_MESSAGE_LENGTH_ARB = 0x9143

gl_MAX_DEBUG_MESSAGE_LENGTH_KHR :: GLenum
gl_MAX_DEBUG_MESSAGE_LENGTH_KHR = 0x9143

gl_MAX_DEEP_3D_TEXTURE_DEPTH_NV :: GLenum
gl_MAX_DEEP_3D_TEXTURE_DEPTH_NV = 0x90D1

gl_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV :: GLenum
gl_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV = 0x90D0

gl_MAX_DEFORMATION_ORDER_SGIX :: GLenum
gl_MAX_DEFORMATION_ORDER_SGIX = 0x8197

gl_MAX_DEPTH :: GLenum
gl_MAX_DEPTH = 0x8280

gl_MAX_DEPTH_TEXTURE_SAMPLES :: GLenum
gl_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F

gl_MAX_DRAW_BUFFERS :: GLenum
gl_MAX_DRAW_BUFFERS = 0x8824

gl_MAX_DRAW_BUFFERS_ARB :: GLenum
gl_MAX_DRAW_BUFFERS_ARB = 0x8824

gl_MAX_DRAW_BUFFERS_ATI :: GLenum
gl_MAX_DRAW_BUFFERS_ATI = 0x8824

gl_MAX_DRAW_BUFFERS_EXT :: GLenum
gl_MAX_DRAW_BUFFERS_EXT = 0x8824

gl_MAX_DRAW_BUFFERS_NV :: GLenum
gl_MAX_DRAW_BUFFERS_NV = 0x8824

gl_MAX_DUAL_SOURCE_DRAW_BUFFERS :: GLenum
gl_MAX_DUAL_SOURCE_DRAW_BUFFERS = 0x88FC

gl_MAX_ELEMENTS_INDICES :: GLenum
gl_MAX_ELEMENTS_INDICES = 0x80E9

gl_MAX_ELEMENTS_INDICES_EXT :: GLenum
gl_MAX_ELEMENTS_INDICES_EXT = 0x80E9

gl_MAX_ELEMENTS_VERTICES :: GLenum
gl_MAX_ELEMENTS_VERTICES = 0x80E8

gl_MAX_ELEMENTS_VERTICES_EXT :: GLenum
gl_MAX_ELEMENTS_VERTICES_EXT = 0x80E8

gl_MAX_ELEMENT_INDEX :: GLenum
gl_MAX_ELEMENT_INDEX = 0x8D6B

gl_MAX_EVAL_ORDER :: GLenum
gl_MAX_EVAL_ORDER = 0x0D30

gl_MAX_EXT :: GLenum
gl_MAX_EXT = 0x8008

gl_MAX_FOG_FUNC_POINTS_SGIS :: GLenum
gl_MAX_FOG_FUNC_POINTS_SGIS = 0x812C

gl_MAX_FRAGMENT_ATOMIC_COUNTERS :: GLenum
gl_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6

gl_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS :: GLenum
gl_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 0x92D0

gl_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT :: GLenum
gl_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT = 0x8DE3

gl_MAX_FRAGMENT_IMAGE_UNIFORMS :: GLenum
gl_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE

gl_MAX_FRAGMENT_INPUT_COMPONENTS :: GLenum
gl_MAX_FRAGMENT_INPUT_COMPONENTS = 0x9125

gl_MAX_FRAGMENT_INTERPOLATION_OFFSET :: GLenum
gl_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C

gl_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV :: GLenum
gl_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV = 0x8E5C

gl_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES :: GLenum
gl_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES = 0x8E5C

gl_MAX_FRAGMENT_LIGHTS_SGIX :: GLenum
gl_MAX_FRAGMENT_LIGHTS_SGIX = 0x8404

gl_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV :: GLenum
gl_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = 0x8868

gl_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS :: GLenum
gl_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 0x90DA

gl_MAX_FRAGMENT_UNIFORM_BLOCKS :: GLenum
gl_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D

gl_MAX_FRAGMENT_UNIFORM_COMPONENTS :: GLenum
gl_MAX_FRAGMENT_UNIFORM_COMPONENTS = 0x8B49

gl_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB :: GLenum
gl_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = 0x8B49

gl_MAX_FRAGMENT_UNIFORM_VECTORS :: GLenum
gl_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD

gl_MAX_FRAMEBUFFER_HEIGHT :: GLenum
gl_MAX_FRAMEBUFFER_HEIGHT = 0x9316

gl_MAX_FRAMEBUFFER_LAYERS :: GLenum
gl_MAX_FRAMEBUFFER_LAYERS = 0x9317

gl_MAX_FRAMEBUFFER_LAYERS_EXT :: GLenum
gl_MAX_FRAMEBUFFER_LAYERS_EXT = 0x9317

gl_MAX_FRAMEBUFFER_LAYERS_OES :: GLenum
gl_MAX_FRAMEBUFFER_LAYERS_OES = 0x9317

gl_MAX_FRAMEBUFFER_SAMPLES :: GLenum
gl_MAX_FRAMEBUFFER_SAMPLES = 0x9318

gl_MAX_FRAMEBUFFER_WIDTH :: GLenum
gl_MAX_FRAMEBUFFER_WIDTH = 0x9315

gl_MAX_FRAMEZOOM_FACTOR_SGIX :: GLenum
gl_MAX_FRAMEZOOM_FACTOR_SGIX = 0x818D

gl_MAX_GENERAL_COMBINERS_NV :: GLenum
gl_MAX_GENERAL_COMBINERS_NV = 0x854D

gl_MAX_GEOMETRY_ATOMIC_COUNTERS :: GLenum
gl_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5

gl_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT :: GLenum
gl_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT = 0x92D5

gl_MAX_GEOMETRY_ATOMIC_COUNTERS_OES :: GLenum
gl_MAX_GEOMETRY_ATOMIC_COUNTERS_OES = 0x92D5

gl_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS :: GLenum
gl_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 0x92CF

gl_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT :: GLenum
gl_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CF

gl_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES :: GLenum
gl_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES = 0x92CF

gl_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT :: GLenum
gl_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT = 0x8DE4

gl_MAX_GEOMETRY_IMAGE_UNIFORMS :: GLenum
gl_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD

gl_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT :: GLenum
gl_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT = 0x90CD

gl_MAX_GEOMETRY_IMAGE_UNIFORMS_OES :: GLenum
gl_MAX_GEOMETRY_IMAGE_UNIFORMS_OES = 0x90CD

gl_MAX_GEOMETRY_INPUT_COMPONENTS :: GLenum
gl_MAX_GEOMETRY_INPUT_COMPONENTS = 0x9123

gl_MAX_GEOMETRY_INPUT_COMPONENTS_EXT :: GLenum
gl_MAX_GEOMETRY_INPUT_COMPONENTS_EXT = 0x9123

gl_MAX_GEOMETRY_INPUT_COMPONENTS_OES :: GLenum
gl_MAX_GEOMETRY_INPUT_COMPONENTS_OES = 0x9123

gl_MAX_GEOMETRY_OUTPUT_COMPONENTS :: GLenum
gl_MAX_GEOMETRY_OUTPUT_COMPONENTS = 0x9124

gl_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT :: GLenum
gl_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT = 0x9124

gl_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES :: GLenum
gl_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES = 0x9124

gl_MAX_GEOMETRY_OUTPUT_VERTICES :: GLenum
gl_MAX_GEOMETRY_OUTPUT_VERTICES = 0x8DE0

gl_MAX_GEOMETRY_OUTPUT_VERTICES_ARB :: GLenum
gl_MAX_GEOMETRY_OUTPUT_VERTICES_ARB = 0x8DE0

gl_MAX_GEOMETRY_OUTPUT_VERTICES_EXT :: GLenum
gl_MAX_GEOMETRY_OUTPUT_VERTICES_EXT = 0x8DE0

gl_MAX_GEOMETRY_OUTPUT_VERTICES_OES :: GLenum
gl_MAX_GEOMETRY_OUTPUT_VERTICES_OES = 0x8DE0

gl_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV :: GLenum
gl_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV = 0x8E5A

gl_MAX_GEOMETRY_SHADER_INVOCATIONS :: GLenum
gl_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A

gl_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT :: GLenum
gl_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT = 0x8E5A

gl_MAX_GEOMETRY_SHADER_INVOCATIONS_OES :: GLenum
gl_MAX_GEOMETRY_SHADER_INVOCATIONS_OES = 0x8E5A

gl_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS :: GLenum
gl_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 0x90D7

gl_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT :: GLenum
gl_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT = 0x90D7

gl_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES :: GLenum
gl_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES = 0x90D7

gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 0x8C29

gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB :: GLenum
gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB = 0x8C29

gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT :: GLenum
gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT = 0x8C29

gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES :: GLenum
gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES = 0x8C29

gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS :: GLenum
gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 0x8DE1

gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB :: GLenum
gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB = 0x8DE1

gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT :: GLenum
gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT = 0x8DE1

gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES :: GLenum
gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES = 0x8DE1

gl_MAX_GEOMETRY_UNIFORM_BLOCKS :: GLenum
gl_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C

gl_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT :: GLenum
gl_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT = 0x8A2C

gl_MAX_GEOMETRY_UNIFORM_BLOCKS_OES :: GLenum
gl_MAX_GEOMETRY_UNIFORM_BLOCKS_OES = 0x8A2C

gl_MAX_GEOMETRY_UNIFORM_COMPONENTS :: GLenum
gl_MAX_GEOMETRY_UNIFORM_COMPONENTS = 0x8DDF

gl_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB :: GLenum
gl_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB = 0x8DDF

gl_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT :: GLenum
gl_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT = 0x8DDF

gl_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES :: GLenum
gl_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES = 0x8DDF

gl_MAX_GEOMETRY_VARYING_COMPONENTS_ARB :: GLenum
gl_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = 0x8DDD

gl_MAX_GEOMETRY_VARYING_COMPONENTS_EXT :: GLenum
gl_MAX_GEOMETRY_VARYING_COMPONENTS_EXT = 0x8DDD

gl_MAX_HEIGHT :: GLenum
gl_MAX_HEIGHT = 0x827F

gl_MAX_IMAGE_SAMPLES :: GLenum
gl_MAX_IMAGE_SAMPLES = 0x906D

gl_MAX_IMAGE_SAMPLES_EXT :: GLenum
gl_MAX_IMAGE_SAMPLES_EXT = 0x906D

gl_MAX_IMAGE_UNITS :: GLenum
gl_MAX_IMAGE_UNITS = 0x8F38

gl_MAX_IMAGE_UNITS_EXT :: GLenum
gl_MAX_IMAGE_UNITS_EXT = 0x8F38

gl_MAX_INTEGER_SAMPLES :: GLenum
gl_MAX_INTEGER_SAMPLES = 0x9110

gl_MAX_LABEL_LENGTH :: GLenum
gl_MAX_LABEL_LENGTH = 0x82E8

gl_MAX_LABEL_LENGTH_KHR :: GLenum
gl_MAX_LABEL_LENGTH_KHR = 0x82E8

gl_MAX_LAYERS :: GLenum
gl_MAX_LAYERS = 0x8281

gl_MAX_LIGHTS :: GLenum
gl_MAX_LIGHTS = 0x0D31

gl_MAX_LIST_NESTING :: GLenum
gl_MAX_LIST_NESTING = 0x0B31

gl_MAX_MAP_TESSELLATION_NV :: GLenum
gl_MAX_MAP_TESSELLATION_NV = 0x86D6

gl_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB :: GLenum
gl_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 0x8841

gl_MAX_MODELVIEW_STACK_DEPTH :: GLenum
gl_MAX_MODELVIEW_STACK_DEPTH = 0x0D36

gl_MAX_MULTISAMPLE_COVERAGE_MODES_NV :: GLenum
gl_MAX_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E11

gl_MAX_MULTIVIEW_BUFFERS_EXT :: GLenum
gl_MAX_MULTIVIEW_BUFFERS_EXT = 0x90F2

gl_MAX_NAME_LENGTH :: GLenum
gl_MAX_NAME_LENGTH = 0x92F6

gl_MAX_NAME_STACK_DEPTH :: GLenum
gl_MAX_NAME_STACK_DEPTH = 0x0D37

gl_MAX_NUM_ACTIVE_VARIABLES :: GLenum
gl_MAX_NUM_ACTIVE_VARIABLES = 0x92F7

gl_MAX_NUM_COMPATIBLE_SUBROUTINES :: GLenum
gl_MAX_NUM_COMPATIBLE_SUBROUTINES = 0x92F8

gl_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT :: GLenum
gl_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87CA

gl_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT :: GLenum
gl_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = 0x87CD

gl_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT :: GLenum
gl_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = 0x87CE

gl_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT :: GLenum
gl_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87CC

gl_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT :: GLenum
gl_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = 0x87CB

gl_MAX_PALETTE_MATRICES_ARB :: GLenum
gl_MAX_PALETTE_MATRICES_ARB = 0x8842

gl_MAX_PALETTE_MATRICES_OES :: GLenum
gl_MAX_PALETTE_MATRICES_OES = 0x8842

gl_MAX_PATCH_VERTICES :: GLenum
gl_MAX_PATCH_VERTICES = 0x8E7D

gl_MAX_PATCH_VERTICES_EXT :: GLenum
gl_MAX_PATCH_VERTICES_EXT = 0x8E7D

gl_MAX_PATCH_VERTICES_OES :: GLenum
gl_MAX_PATCH_VERTICES_OES = 0x8E7D

gl_MAX_PIXEL_MAP_TABLE :: GLenum
gl_MAX_PIXEL_MAP_TABLE = 0x0D34

gl_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT :: GLenum
gl_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = 0x8337

gl_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI :: GLenum
gl_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = 0x87F1

gl_MAX_PROGRAM_ADDRESS_REGISTERS_ARB :: GLenum
gl_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B1

gl_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB :: GLenum
gl_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x880B

gl_MAX_PROGRAM_ATTRIBS_ARB :: GLenum
gl_MAX_PROGRAM_ATTRIBS_ARB = 0x88AD

gl_MAX_PROGRAM_ATTRIB_COMPONENTS_NV :: GLenum
gl_MAX_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8908

gl_MAX_PROGRAM_CALL_DEPTH_NV :: GLenum
gl_MAX_PROGRAM_CALL_DEPTH_NV = 0x88F5

gl_MAX_PROGRAM_ENV_PARAMETERS_ARB :: GLenum
gl_MAX_PROGRAM_ENV_PARAMETERS_ARB = 0x88B5

gl_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV :: GLenum
gl_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = 0x88F4

gl_MAX_PROGRAM_GENERIC_ATTRIBS_NV :: GLenum
gl_MAX_PROGRAM_GENERIC_ATTRIBS_NV = 0x8DA5

gl_MAX_PROGRAM_GENERIC_RESULTS_NV :: GLenum
gl_MAX_PROGRAM_GENERIC_RESULTS_NV = 0x8DA6

gl_MAX_PROGRAM_IF_DEPTH_NV :: GLenum
gl_MAX_PROGRAM_IF_DEPTH_NV = 0x88F6

gl_MAX_PROGRAM_INSTRUCTIONS_ARB :: GLenum
gl_MAX_PROGRAM_INSTRUCTIONS_ARB = 0x88A1

gl_MAX_PROGRAM_LOCAL_PARAMETERS_ARB :: GLenum
gl_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = 0x88B4

gl_MAX_PROGRAM_LOOP_COUNT_NV :: GLenum
gl_MAX_PROGRAM_LOOP_COUNT_NV = 0x88F8

gl_MAX_PROGRAM_LOOP_DEPTH_NV :: GLenum
gl_MAX_PROGRAM_LOOP_DEPTH_NV = 0x88F7

gl_MAX_PROGRAM_MATRICES_ARB :: GLenum
gl_MAX_PROGRAM_MATRICES_ARB = 0x862F

gl_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB :: GLenum
gl_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = 0x862E

gl_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB :: GLenum
gl_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B3

gl_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB :: GLenum
gl_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x880E

gl_MAX_PROGRAM_NATIVE_ATTRIBS_ARB :: GLenum
gl_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AF

gl_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB :: GLenum
gl_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A3

gl_MAX_PROGRAM_NATIVE_PARAMETERS_ARB :: GLenum
gl_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AB

gl_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB :: GLenum
gl_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A7

gl_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB :: GLenum
gl_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x8810

gl_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB :: GLenum
gl_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x880F

gl_MAX_PROGRAM_OUTPUT_VERTICES_NV :: GLenum
gl_MAX_PROGRAM_OUTPUT_VERTICES_NV = 0x8C27

gl_MAX_PROGRAM_PARAMETERS_ARB :: GLenum
gl_MAX_PROGRAM_PARAMETERS_ARB = 0x88A9

gl_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV :: GLenum
gl_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV = 0x8DA0

gl_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV :: GLenum
gl_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV = 0x8DA1

gl_MAX_PROGRAM_PATCH_ATTRIBS_NV :: GLenum
gl_MAX_PROGRAM_PATCH_ATTRIBS_NV = 0x86D8

gl_MAX_PROGRAM_RESULT_COMPONENTS_NV :: GLenum
gl_MAX_PROGRAM_RESULT_COMPONENTS_NV = 0x8909

gl_MAX_PROGRAM_SUBROUTINE_NUM_NV :: GLenum
gl_MAX_PROGRAM_SUBROUTINE_NUM_NV = 0x8F45

gl_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV :: GLenum
gl_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV = 0x8F44

gl_MAX_PROGRAM_TEMPORARIES_ARB :: GLenum
gl_MAX_PROGRAM_TEMPORARIES_ARB = 0x88A5

gl_MAX_PROGRAM_TEXEL_OFFSET :: GLenum
gl_MAX_PROGRAM_TEXEL_OFFSET = 0x8905

gl_MAX_PROGRAM_TEXEL_OFFSET_EXT :: GLenum
gl_MAX_PROGRAM_TEXEL_OFFSET_EXT = 0x8905

gl_MAX_PROGRAM_TEXEL_OFFSET_NV :: GLenum
gl_MAX_PROGRAM_TEXEL_OFFSET_NV = 0x8905

gl_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB :: GLenum
gl_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB = 0x8F9F

gl_MAX_PROGRAM_TEXTURE_GATHER_OFFSET :: GLenum
gl_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5F

gl_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB :: GLenum
gl_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5F

gl_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV :: GLenum
gl_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV = 0x8E5F

gl_MAX_PROGRAM_TEX_INDIRECTIONS_ARB :: GLenum
gl_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = 0x880D

gl_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB :: GLenum
gl_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x880C

gl_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV :: GLenum
gl_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV = 0x8C28

gl_MAX_PROJECTION_STACK_DEPTH :: GLenum
gl_MAX_PROJECTION_STACK_DEPTH = 0x0D38

gl_MAX_RASTER_SAMPLES_EXT :: GLenum
gl_MAX_RASTER_SAMPLES_EXT = 0x9329

gl_MAX_RATIONAL_EVAL_ORDER_NV :: GLenum
gl_MAX_RATIONAL_EVAL_ORDER_NV = 0x86D7

gl_MAX_RECTANGLE_TEXTURE_SIZE :: GLenum
gl_MAX_RECTANGLE_TEXTURE_SIZE = 0x84F8

gl_MAX_RECTANGLE_TEXTURE_SIZE_ARB :: GLenum
gl_MAX_RECTANGLE_TEXTURE_SIZE_ARB = 0x84F8

gl_MAX_RECTANGLE_TEXTURE_SIZE_NV :: GLenum
gl_MAX_RECTANGLE_TEXTURE_SIZE_NV = 0x84F8

gl_MAX_RENDERBUFFER_SIZE :: GLenum
gl_MAX_RENDERBUFFER_SIZE = 0x84E8

gl_MAX_RENDERBUFFER_SIZE_EXT :: GLenum
gl_MAX_RENDERBUFFER_SIZE_EXT = 0x84E8

gl_MAX_RENDERBUFFER_SIZE_OES :: GLenum
gl_MAX_RENDERBUFFER_SIZE_OES = 0x84E8

gl_MAX_SAMPLES :: GLenum
gl_MAX_SAMPLES = 0x8D57

gl_MAX_SAMPLES_ANGLE :: GLenum
gl_MAX_SAMPLES_ANGLE = 0x8D57

gl_MAX_SAMPLES_APPLE :: GLenum
gl_MAX_SAMPLES_APPLE = 0x8D57

gl_MAX_SAMPLES_EXT :: GLenum
gl_MAX_SAMPLES_EXT = 0x8D57

gl_MAX_SAMPLES_IMG :: GLenum
gl_MAX_SAMPLES_IMG = 0x9135

gl_MAX_SAMPLES_NV :: GLenum
gl_MAX_SAMPLES_NV = 0x8D57

gl_MAX_SAMPLE_MASK_WORDS :: GLenum
gl_MAX_SAMPLE_MASK_WORDS = 0x8E59

gl_MAX_SAMPLE_MASK_WORDS_NV :: GLenum
gl_MAX_SAMPLE_MASK_WORDS_NV = 0x8E59

gl_MAX_SERVER_WAIT_TIMEOUT :: GLenum
gl_MAX_SERVER_WAIT_TIMEOUT = 0x9111

gl_MAX_SERVER_WAIT_TIMEOUT_APPLE :: GLenum
gl_MAX_SERVER_WAIT_TIMEOUT_APPLE = 0x9111

gl_MAX_SHADER_BUFFER_ADDRESS_NV :: GLenum
gl_MAX_SHADER_BUFFER_ADDRESS_NV = 0x8F35

gl_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT :: GLenum
gl_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT = 0x8F63

gl_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT :: GLenum
gl_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT = 0x8F67

gl_MAX_SHADER_STORAGE_BLOCK_SIZE :: GLenum
gl_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE

gl_MAX_SHADER_STORAGE_BUFFER_BINDINGS :: GLenum
gl_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 0x90DD

gl_MAX_SHININESS_NV :: GLenum
gl_MAX_SHININESS_NV = 0x8504

gl_MAX_SPARSE_3D_TEXTURE_SIZE_AMD :: GLenum
gl_MAX_SPARSE_3D_TEXTURE_SIZE_AMD = 0x9199

gl_MAX_SPARSE_3D_TEXTURE_SIZE_ARB :: GLenum
gl_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = 0x9199

gl_MAX_SPARSE_ARRAY_TEXTURE_LAYERS :: GLenum
gl_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 0x919A

gl_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB :: GLenum
gl_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB = 0x919A

gl_MAX_SPARSE_TEXTURE_SIZE_AMD :: GLenum
gl_MAX_SPARSE_TEXTURE_SIZE_AMD = 0x9198

gl_MAX_SPARSE_TEXTURE_SIZE_ARB :: GLenum
gl_MAX_SPARSE_TEXTURE_SIZE_ARB = 0x9198

gl_MAX_SPOT_EXPONENT_NV :: GLenum
gl_MAX_SPOT_EXPONENT_NV = 0x8505

gl_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV :: GLenum
gl_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV = 0x9349

gl_MAX_SUBROUTINES :: GLenum
gl_MAX_SUBROUTINES = 0x8DE7

gl_MAX_SUBROUTINE_UNIFORM_LOCATIONS :: GLenum
gl_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 0x8DE8

gl_MAX_TESS_CONTROL_ATOMIC_COUNTERS :: GLenum
gl_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 0x92D3

gl_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT :: GLenum
gl_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT = 0x92D3

gl_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES :: GLenum
gl_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES = 0x92D3

gl_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS :: GLenum
gl_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 0x92CD

gl_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT :: GLenum
gl_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CD

gl_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES :: GLenum
gl_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES = 0x92CD

gl_MAX_TESS_CONTROL_IMAGE_UNIFORMS :: GLenum
gl_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 0x90CB

gl_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT :: GLenum
gl_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT = 0x90CB

gl_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES :: GLenum
gl_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES = 0x90CB

gl_MAX_TESS_CONTROL_INPUT_COMPONENTS :: GLenum
gl_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C

gl_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT :: GLenum
gl_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT = 0x886C

gl_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES :: GLenum
gl_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES = 0x886C

gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS :: GLenum
gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83

gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT :: GLenum
gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT = 0x8E83

gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES :: GLenum
gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES = 0x8E83

gl_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS :: GLenum
gl_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 0x90D8

gl_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT :: GLenum
gl_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT = 0x90D8

gl_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES :: GLenum
gl_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES = 0x90D8

gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81

gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT :: GLenum
gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT = 0x8E81

gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES :: GLenum
gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES = 0x8E81

gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS :: GLenum
gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85

gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT :: GLenum
gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT = 0x8E85

gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES :: GLenum
gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES = 0x8E85

gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS :: GLenum
gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89

gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT :: GLenum
gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT = 0x8E89

gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES :: GLenum
gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES = 0x8E89

gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS :: GLenum
gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F

gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT :: GLenum
gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = 0x8E7F

gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES :: GLenum
gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES = 0x8E7F

gl_MAX_TESS_EVALUATION_ATOMIC_COUNTERS :: GLenum
gl_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 0x92D4

gl_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT = 0x92D4

gl_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES :: GLenum
gl_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES = 0x92D4

gl_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS :: GLenum
gl_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 0x92CE

gl_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CE

gl_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES :: GLenum
gl_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES = 0x92CE

gl_MAX_TESS_EVALUATION_IMAGE_UNIFORMS :: GLenum
gl_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 0x90CC

gl_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT = 0x90CC

gl_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES :: GLenum
gl_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES = 0x90CC

gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS :: GLenum
gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D

gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT = 0x886D

gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES :: GLenum
gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES = 0x886D

gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS :: GLenum
gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86

gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT = 0x8E86

gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES :: GLenum
gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES = 0x8E86

gl_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS :: GLenum
gl_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 0x90D9

gl_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT = 0x90D9

gl_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES :: GLenum
gl_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES = 0x90D9

gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82

gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT = 0x8E82

gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES :: GLenum
gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES = 0x8E82

gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS :: GLenum
gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A

gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT = 0x8E8A

gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES :: GLenum
gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES = 0x8E8A

gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS :: GLenum
gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80

gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT :: GLenum
gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = 0x8E80

gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES :: GLenum
gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = 0x8E80

gl_MAX_TESS_GEN_LEVEL :: GLenum
gl_MAX_TESS_GEN_LEVEL = 0x8E7E

gl_MAX_TESS_GEN_LEVEL_EXT :: GLenum
gl_MAX_TESS_GEN_LEVEL_EXT = 0x8E7E

gl_MAX_TESS_GEN_LEVEL_OES :: GLenum
gl_MAX_TESS_GEN_LEVEL_OES = 0x8E7E

gl_MAX_TESS_PATCH_COMPONENTS :: GLenum
gl_MAX_TESS_PATCH_COMPONENTS = 0x8E84

gl_MAX_TESS_PATCH_COMPONENTS_EXT :: GLenum
gl_MAX_TESS_PATCH_COMPONENTS_EXT = 0x8E84

gl_MAX_TESS_PATCH_COMPONENTS_OES :: GLenum
gl_MAX_TESS_PATCH_COMPONENTS_OES = 0x8E84

gl_MAX_TEXTURE_BUFFER_SIZE :: GLenum
gl_MAX_TEXTURE_BUFFER_SIZE = 0x8C2B

gl_MAX_TEXTURE_BUFFER_SIZE_ARB :: GLenum
gl_MAX_TEXTURE_BUFFER_SIZE_ARB = 0x8C2B

gl_MAX_TEXTURE_BUFFER_SIZE_EXT :: GLenum
gl_MAX_TEXTURE_BUFFER_SIZE_EXT = 0x8C2B

gl_MAX_TEXTURE_BUFFER_SIZE_OES :: GLenum
gl_MAX_TEXTURE_BUFFER_SIZE_OES = 0x8C2B

gl_MAX_TEXTURE_COORDS :: GLenum
gl_MAX_TEXTURE_COORDS = 0x8871

gl_MAX_TEXTURE_COORDS_ARB :: GLenum
gl_MAX_TEXTURE_COORDS_ARB = 0x8871

gl_MAX_TEXTURE_COORDS_NV :: GLenum
gl_MAX_TEXTURE_COORDS_NV = 0x8871

gl_MAX_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_TEXTURE_IMAGE_UNITS = 0x8872

gl_MAX_TEXTURE_IMAGE_UNITS_ARB :: GLenum
gl_MAX_TEXTURE_IMAGE_UNITS_ARB = 0x8872

gl_MAX_TEXTURE_IMAGE_UNITS_NV :: GLenum
gl_MAX_TEXTURE_IMAGE_UNITS_NV = 0x8872

gl_MAX_TEXTURE_LOD_BIAS :: GLenum
gl_MAX_TEXTURE_LOD_BIAS = 0x84FD

gl_MAX_TEXTURE_LOD_BIAS_EXT :: GLenum
gl_MAX_TEXTURE_LOD_BIAS_EXT = 0x84FD

gl_MAX_TEXTURE_MAX_ANISOTROPY_EXT :: GLenum
gl_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF

gl_MAX_TEXTURE_SIZE :: GLenum
gl_MAX_TEXTURE_SIZE = 0x0D33

gl_MAX_TEXTURE_STACK_DEPTH :: GLenum
gl_MAX_TEXTURE_STACK_DEPTH = 0x0D39

gl_MAX_TEXTURE_UNITS :: GLenum
gl_MAX_TEXTURE_UNITS = 0x84E2

gl_MAX_TEXTURE_UNITS_ARB :: GLenum
gl_MAX_TEXTURE_UNITS_ARB = 0x84E2

gl_MAX_TRACK_MATRICES_NV :: GLenum
gl_MAX_TRACK_MATRICES_NV = 0x862F

gl_MAX_TRACK_MATRIX_STACK_DEPTH_NV :: GLenum
gl_MAX_TRACK_MATRIX_STACK_DEPTH_NV = 0x862E

gl_MAX_TRANSFORM_FEEDBACK_BUFFERS :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_BUFFERS = 0x8E70

gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A

gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = 0x8C8A

gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 0x8C8A

gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 0x8C8B

gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = 0x8C8B

gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = 0x8C8B

gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 0x8C80

gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = 0x8C80

gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = 0x8C80

gl_MAX_UNIFORM_BLOCK_SIZE :: GLenum
gl_MAX_UNIFORM_BLOCK_SIZE = 0x8A30

gl_MAX_UNIFORM_BUFFER_BINDINGS :: GLenum
gl_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F

gl_MAX_UNIFORM_LOCATIONS :: GLenum
gl_MAX_UNIFORM_LOCATIONS = 0x826E

gl_MAX_VARYING_COMPONENTS :: GLenum
gl_MAX_VARYING_COMPONENTS = 0x8B4B

gl_MAX_VARYING_COMPONENTS_EXT :: GLenum
gl_MAX_VARYING_COMPONENTS_EXT = 0x8B4B

gl_MAX_VARYING_FLOATS :: GLenum
gl_MAX_VARYING_FLOATS = 0x8B4B

gl_MAX_VARYING_FLOATS_ARB :: GLenum
gl_MAX_VARYING_FLOATS_ARB = 0x8B4B

gl_MAX_VARYING_VECTORS :: GLenum
gl_MAX_VARYING_VECTORS = 0x8DFC

gl_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV :: GLenum
gl_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = 0x8520

gl_MAX_VERTEX_ATOMIC_COUNTERS :: GLenum
gl_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2

gl_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS :: GLenum
gl_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 0x92CC

gl_MAX_VERTEX_ATTRIBS :: GLenum
gl_MAX_VERTEX_ATTRIBS = 0x8869

gl_MAX_VERTEX_ATTRIBS_ARB :: GLenum
gl_MAX_VERTEX_ATTRIBS_ARB = 0x8869

gl_MAX_VERTEX_ATTRIB_BINDINGS :: GLenum
gl_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA

gl_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET :: GLenum
gl_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D9

gl_MAX_VERTEX_ATTRIB_STRIDE :: GLenum
gl_MAX_VERTEX_ATTRIB_STRIDE = 0x82E5

gl_MAX_VERTEX_BINDABLE_UNIFORMS_EXT :: GLenum
gl_MAX_VERTEX_BINDABLE_UNIFORMS_EXT = 0x8DE2

gl_MAX_VERTEX_HINT_PGI :: GLenum
gl_MAX_VERTEX_HINT_PGI = 0x1A22D

gl_MAX_VERTEX_IMAGE_UNIFORMS :: GLenum
gl_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA

gl_MAX_VERTEX_OUTPUT_COMPONENTS :: GLenum
gl_MAX_VERTEX_OUTPUT_COMPONENTS = 0x9122

gl_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT :: GLenum
gl_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87C5

gl_MAX_VERTEX_SHADER_INVARIANTS_EXT :: GLenum
gl_MAX_VERTEX_SHADER_INVARIANTS_EXT = 0x87C7

gl_MAX_VERTEX_SHADER_LOCALS_EXT :: GLenum
gl_MAX_VERTEX_SHADER_LOCALS_EXT = 0x87C9

gl_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT :: GLenum
gl_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87C8

gl_MAX_VERTEX_SHADER_STORAGE_BLOCKS :: GLenum
gl_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 0x90D6

gl_MAX_VERTEX_SHADER_VARIANTS_EXT :: GLenum
gl_MAX_VERTEX_SHADER_VARIANTS_EXT = 0x87C6

gl_MAX_VERTEX_STREAMS :: GLenum
gl_MAX_VERTEX_STREAMS = 0x8E71

gl_MAX_VERTEX_STREAMS_ATI :: GLenum
gl_MAX_VERTEX_STREAMS_ATI = 0x876B

gl_MAX_VERTEX_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C

gl_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB :: GLenum
gl_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = 0x8B4C

gl_MAX_VERTEX_UNIFORM_BLOCKS :: GLenum
gl_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B

gl_MAX_VERTEX_UNIFORM_COMPONENTS :: GLenum
gl_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A

gl_MAX_VERTEX_UNIFORM_COMPONENTS_ARB :: GLenum
gl_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = 0x8B4A

gl_MAX_VERTEX_UNIFORM_VECTORS :: GLenum
gl_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB

gl_MAX_VERTEX_UNITS_ARB :: GLenum
gl_MAX_VERTEX_UNITS_ARB = 0x86A4

gl_MAX_VERTEX_UNITS_OES :: GLenum
gl_MAX_VERTEX_UNITS_OES = 0x86A4

gl_MAX_VERTEX_VARYING_COMPONENTS_ARB :: GLenum
gl_MAX_VERTEX_VARYING_COMPONENTS_ARB = 0x8DDE

gl_MAX_VERTEX_VARYING_COMPONENTS_EXT :: GLenum
gl_MAX_VERTEX_VARYING_COMPONENTS_EXT = 0x8DDE

gl_MAX_VIEWPORTS :: GLenum
gl_MAX_VIEWPORTS = 0x825B

gl_MAX_VIEWPORTS_NV :: GLenum
gl_MAX_VIEWPORTS_NV = 0x825B

gl_MAX_VIEWPORT_DIMS :: GLenum
gl_MAX_VIEWPORT_DIMS = 0x0D3A

gl_MAX_WIDTH :: GLenum
gl_MAX_WIDTH = 0x827E

gl_MEDIUM_FLOAT :: GLenum
gl_MEDIUM_FLOAT = 0x8DF1

gl_MEDIUM_INT :: GLenum
gl_MEDIUM_INT = 0x8DF4

gl_MIN :: GLenum
gl_MIN = 0x8007

gl_MINMAX :: GLenum
gl_MINMAX = 0x802E

gl_MINMAX_EXT :: GLenum
gl_MINMAX_EXT = 0x802E

gl_MINMAX_FORMAT :: GLenum
gl_MINMAX_FORMAT = 0x802F

gl_MINMAX_FORMAT_EXT :: GLenum
gl_MINMAX_FORMAT_EXT = 0x802F

gl_MINMAX_SINK :: GLenum
gl_MINMAX_SINK = 0x8030

gl_MINMAX_SINK_EXT :: GLenum
gl_MINMAX_SINK_EXT = 0x8030

gl_MINOR_VERSION :: GLenum
gl_MINOR_VERSION = 0x821C

gl_MINUS_CLAMPED_NV :: GLenum
gl_MINUS_CLAMPED_NV = 0x92B3

gl_MINUS_NV :: GLenum
gl_MINUS_NV = 0x929F

gl_MIN_EXT :: GLenum
gl_MIN_EXT = 0x8007

gl_MIN_FRAGMENT_INTERPOLATION_OFFSET :: GLenum
gl_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B

gl_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV :: GLenum
gl_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV = 0x8E5B

gl_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES :: GLenum
gl_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES = 0x8E5B

gl_MIN_LOD_WARNING_AMD :: GLenum
gl_MIN_LOD_WARNING_AMD = 0x919C

gl_MIN_MAP_BUFFER_ALIGNMENT :: GLenum
gl_MIN_MAP_BUFFER_ALIGNMENT = 0x90BC

gl_MIN_PROGRAM_TEXEL_OFFSET :: GLenum
gl_MIN_PROGRAM_TEXEL_OFFSET = 0x8904

gl_MIN_PROGRAM_TEXEL_OFFSET_EXT :: GLenum
gl_MIN_PROGRAM_TEXEL_OFFSET_EXT = 0x8904

gl_MIN_PROGRAM_TEXEL_OFFSET_NV :: GLenum
gl_MIN_PROGRAM_TEXEL_OFFSET_NV = 0x8904

gl_MIN_PROGRAM_TEXTURE_GATHER_OFFSET :: GLenum
gl_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5E

gl_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB :: GLenum
gl_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5E

gl_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV :: GLenum
gl_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV = 0x8E5E

gl_MIN_SAMPLE_SHADING_VALUE :: GLenum
gl_MIN_SAMPLE_SHADING_VALUE = 0x8C37

gl_MIN_SAMPLE_SHADING_VALUE_ARB :: GLenum
gl_MIN_SAMPLE_SHADING_VALUE_ARB = 0x8C37

gl_MIN_SAMPLE_SHADING_VALUE_OES :: GLenum
gl_MIN_SAMPLE_SHADING_VALUE_OES = 0x8C37

gl_MIN_SPARSE_LEVEL_AMD :: GLenum
gl_MIN_SPARSE_LEVEL_AMD = 0x919B

gl_MIPMAP :: GLenum
gl_MIPMAP = 0x8293

gl_MIRRORED_REPEAT :: GLenum
gl_MIRRORED_REPEAT = 0x8370

gl_MIRRORED_REPEAT_ARB :: GLenum
gl_MIRRORED_REPEAT_ARB = 0x8370

gl_MIRRORED_REPEAT_IBM :: GLenum
gl_MIRRORED_REPEAT_IBM = 0x8370

gl_MIRRORED_REPEAT_OES :: GLenum
gl_MIRRORED_REPEAT_OES = 0x8370

gl_MIRROR_CLAMP_ATI :: GLenum
gl_MIRROR_CLAMP_ATI = 0x8742

gl_MIRROR_CLAMP_EXT :: GLenum
gl_MIRROR_CLAMP_EXT = 0x8742

gl_MIRROR_CLAMP_TO_BORDER_EXT :: GLenum
gl_MIRROR_CLAMP_TO_BORDER_EXT = 0x8912

gl_MIRROR_CLAMP_TO_EDGE :: GLenum
gl_MIRROR_CLAMP_TO_EDGE = 0x8743

gl_MIRROR_CLAMP_TO_EDGE_ATI :: GLenum
gl_MIRROR_CLAMP_TO_EDGE_ATI = 0x8743

gl_MIRROR_CLAMP_TO_EDGE_EXT :: GLenum
gl_MIRROR_CLAMP_TO_EDGE_EXT = 0x8743

gl_MITER_REVERT_NV :: GLenum
gl_MITER_REVERT_NV = 0x90A7

gl_MITER_TRUNCATE_NV :: GLenum
gl_MITER_TRUNCATE_NV = 0x90A8

gl_MIXED_DEPTH_SAMPLES_SUPPORTED_NV :: GLenum
gl_MIXED_DEPTH_SAMPLES_SUPPORTED_NV = 0x932F

gl_MIXED_STENCIL_SAMPLES_SUPPORTED_NV :: GLenum
gl_MIXED_STENCIL_SAMPLES_SUPPORTED_NV = 0x9330

gl_MODELVIEW :: GLenum
gl_MODELVIEW = 0x1700

gl_MODELVIEW0_ARB :: GLenum
gl_MODELVIEW0_ARB = 0x1700

gl_MODELVIEW0_EXT :: GLenum
gl_MODELVIEW0_EXT = 0x1700

gl_MODELVIEW0_MATRIX_EXT :: GLenum
gl_MODELVIEW0_MATRIX_EXT = 0x0BA6

gl_MODELVIEW0_STACK_DEPTH_EXT :: GLenum
gl_MODELVIEW0_STACK_DEPTH_EXT = 0x0BA3

gl_MODELVIEW10_ARB :: GLenum
gl_MODELVIEW10_ARB = 0x872A

gl_MODELVIEW11_ARB :: GLenum
gl_MODELVIEW11_ARB = 0x872B

gl_MODELVIEW12_ARB :: GLenum
gl_MODELVIEW12_ARB = 0x872C

gl_MODELVIEW13_ARB :: GLenum
gl_MODELVIEW13_ARB = 0x872D

gl_MODELVIEW14_ARB :: GLenum
gl_MODELVIEW14_ARB = 0x872E

gl_MODELVIEW15_ARB :: GLenum
gl_MODELVIEW15_ARB = 0x872F

gl_MODELVIEW16_ARB :: GLenum
gl_MODELVIEW16_ARB = 0x8730

gl_MODELVIEW17_ARB :: GLenum
gl_MODELVIEW17_ARB = 0x8731

gl_MODELVIEW18_ARB :: GLenum
gl_MODELVIEW18_ARB = 0x8732

gl_MODELVIEW19_ARB :: GLenum
gl_MODELVIEW19_ARB = 0x8733

gl_MODELVIEW1_ARB :: GLenum
gl_MODELVIEW1_ARB = 0x850A

gl_MODELVIEW1_EXT :: GLenum
gl_MODELVIEW1_EXT = 0x850A

gl_MODELVIEW1_MATRIX_EXT :: GLenum
gl_MODELVIEW1_MATRIX_EXT = 0x8506

gl_MODELVIEW1_STACK_DEPTH_EXT :: GLenum
gl_MODELVIEW1_STACK_DEPTH_EXT = 0x8502

gl_MODELVIEW20_ARB :: GLenum
gl_MODELVIEW20_ARB = 0x8734

gl_MODELVIEW21_ARB :: GLenum
gl_MODELVIEW21_ARB = 0x8735

gl_MODELVIEW22_ARB :: GLenum
gl_MODELVIEW22_ARB = 0x8736

gl_MODELVIEW23_ARB :: GLenum
gl_MODELVIEW23_ARB = 0x8737

gl_MODELVIEW24_ARB :: GLenum
gl_MODELVIEW24_ARB = 0x8738

gl_MODELVIEW25_ARB :: GLenum
gl_MODELVIEW25_ARB = 0x8739

gl_MODELVIEW26_ARB :: GLenum
gl_MODELVIEW26_ARB = 0x873A

gl_MODELVIEW27_ARB :: GLenum
gl_MODELVIEW27_ARB = 0x873B

gl_MODELVIEW28_ARB :: GLenum
gl_MODELVIEW28_ARB = 0x873C

gl_MODELVIEW29_ARB :: GLenum
gl_MODELVIEW29_ARB = 0x873D

gl_MODELVIEW2_ARB :: GLenum
gl_MODELVIEW2_ARB = 0x8722

gl_MODELVIEW30_ARB :: GLenum
gl_MODELVIEW30_ARB = 0x873E

gl_MODELVIEW31_ARB :: GLenum
gl_MODELVIEW31_ARB = 0x873F

gl_MODELVIEW3_ARB :: GLenum
gl_MODELVIEW3_ARB = 0x8723

gl_MODELVIEW4_ARB :: GLenum
gl_MODELVIEW4_ARB = 0x8724

gl_MODELVIEW5_ARB :: GLenum
gl_MODELVIEW5_ARB = 0x8725

gl_MODELVIEW6_ARB :: GLenum
gl_MODELVIEW6_ARB = 0x8726

gl_MODELVIEW7_ARB :: GLenum
gl_MODELVIEW7_ARB = 0x8727

gl_MODELVIEW8_ARB :: GLenum
gl_MODELVIEW8_ARB = 0x8728

gl_MODELVIEW9_ARB :: GLenum
gl_MODELVIEW9_ARB = 0x8729

gl_MODELVIEW_MATRIX :: GLenum
gl_MODELVIEW_MATRIX = 0x0BA6

gl_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES :: GLenum
gl_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES = 0x898D

gl_MODELVIEW_PROJECTION_NV :: GLenum
gl_MODELVIEW_PROJECTION_NV = 0x8629

gl_MODELVIEW_STACK_DEPTH :: GLenum
gl_MODELVIEW_STACK_DEPTH = 0x0BA3

gl_MODULATE :: GLenum
gl_MODULATE = 0x2100

gl_MODULATE_ADD_ATI :: GLenum
gl_MODULATE_ADD_ATI = 0x8744

gl_MODULATE_COLOR_IMG :: GLenum
gl_MODULATE_COLOR_IMG = 0x8C04

gl_MODULATE_SIGNED_ADD_ATI :: GLenum
gl_MODULATE_SIGNED_ADD_ATI = 0x8745

gl_MODULATE_SUBTRACT_ATI :: GLenum
gl_MODULATE_SUBTRACT_ATI = 0x8746

gl_MOVE_TO_CONTINUES_NV :: GLenum
gl_MOVE_TO_CONTINUES_NV = 0x90B6

gl_MOVE_TO_NV :: GLubyte
gl_MOVE_TO_NV = 0x02

gl_MOVE_TO_RESETS_NV :: GLenum
gl_MOVE_TO_RESETS_NV = 0x90B5

gl_MOV_ATI :: GLenum
gl_MOV_ATI = 0x8961

gl_MULT :: GLenum
gl_MULT = 0x0103

gl_MULTIPLY_KHR :: GLenum
gl_MULTIPLY_KHR = 0x9294

gl_MULTIPLY_NV :: GLenum
gl_MULTIPLY_NV = 0x9294

gl_MULTISAMPLE :: GLenum
gl_MULTISAMPLE = 0x809D

gl_MULTISAMPLES_NV :: GLenum
gl_MULTISAMPLES_NV = 0x9371

gl_MULTISAMPLE_3DFX :: GLenum
gl_MULTISAMPLE_3DFX = 0x86B2

gl_MULTISAMPLE_ARB :: GLenum
gl_MULTISAMPLE_ARB = 0x809D

gl_MULTISAMPLE_BIT :: GLbitfield
gl_MULTISAMPLE_BIT = 0x20000000

gl_MULTISAMPLE_BIT_3DFX :: GLbitfield
gl_MULTISAMPLE_BIT_3DFX = 0x20000000

gl_MULTISAMPLE_BIT_ARB :: GLbitfield
gl_MULTISAMPLE_BIT_ARB = 0x20000000

gl_MULTISAMPLE_BIT_EXT :: GLbitfield
gl_MULTISAMPLE_BIT_EXT = 0x20000000

gl_MULTISAMPLE_BUFFER_BIT0_QCOM :: GLbitfield
gl_MULTISAMPLE_BUFFER_BIT0_QCOM = 0x01000000

gl_MULTISAMPLE_BUFFER_BIT1_QCOM :: GLbitfield
gl_MULTISAMPLE_BUFFER_BIT1_QCOM = 0x02000000

gl_MULTISAMPLE_BUFFER_BIT2_QCOM :: GLbitfield
gl_MULTISAMPLE_BUFFER_BIT2_QCOM = 0x04000000

gl_MULTISAMPLE_BUFFER_BIT3_QCOM :: GLbitfield
gl_MULTISAMPLE_BUFFER_BIT3_QCOM = 0x08000000

gl_MULTISAMPLE_BUFFER_BIT4_QCOM :: GLbitfield
gl_MULTISAMPLE_BUFFER_BIT4_QCOM = 0x10000000

gl_MULTISAMPLE_BUFFER_BIT5_QCOM :: GLbitfield
gl_MULTISAMPLE_BUFFER_BIT5_QCOM = 0x20000000

gl_MULTISAMPLE_BUFFER_BIT6_QCOM :: GLbitfield
gl_MULTISAMPLE_BUFFER_BIT6_QCOM = 0x40000000

gl_MULTISAMPLE_BUFFER_BIT7_QCOM :: GLbitfield
gl_MULTISAMPLE_BUFFER_BIT7_QCOM = 0x80000000

gl_MULTISAMPLE_COVERAGE_MODES_NV :: GLenum
gl_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E12

gl_MULTISAMPLE_EXT :: GLenum
gl_MULTISAMPLE_EXT = 0x809D

gl_MULTISAMPLE_FILTER_HINT_NV :: GLenum
gl_MULTISAMPLE_FILTER_HINT_NV = 0x8534

gl_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT :: GLenum
gl_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT = 0x932B

gl_MULTISAMPLE_SGIS :: GLenum
gl_MULTISAMPLE_SGIS = 0x809D

gl_MULTIVIEW_EXT :: GLenum
gl_MULTIVIEW_EXT = 0x90F1

gl_MUL_ATI :: GLenum
gl_MUL_ATI = 0x8964

gl_MVP_MATRIX_EXT :: GLenum
gl_MVP_MATRIX_EXT = 0x87E3

gl_N3F_V3F :: GLenum
gl_N3F_V3F = 0x2A25

gl_NAMED_STRING_LENGTH_ARB :: GLenum
gl_NAMED_STRING_LENGTH_ARB = 0x8DE9

gl_NAMED_STRING_TYPE_ARB :: GLenum
gl_NAMED_STRING_TYPE_ARB = 0x8DEA

gl_NAME_LENGTH :: GLenum
gl_NAME_LENGTH = 0x92F9

gl_NAME_STACK_DEPTH :: GLenum
gl_NAME_STACK_DEPTH = 0x0D70

gl_NAND :: GLenum
gl_NAND = 0x150E

gl_NATIVE_GRAPHICS_BEGIN_HINT_PGI :: GLenum
gl_NATIVE_GRAPHICS_BEGIN_HINT_PGI = 0x1A203

gl_NATIVE_GRAPHICS_END_HINT_PGI :: GLenum
gl_NATIVE_GRAPHICS_END_HINT_PGI = 0x1A204

gl_NATIVE_GRAPHICS_HANDLE_PGI :: GLenum
gl_NATIVE_GRAPHICS_HANDLE_PGI = 0x1A202

gl_NEAREST :: GLenum
gl_NEAREST = 0x2600

gl_NEAREST_CLIPMAP_LINEAR_SGIX :: GLenum
gl_NEAREST_CLIPMAP_LINEAR_SGIX = 0x844E

gl_NEAREST_CLIPMAP_NEAREST_SGIX :: GLenum
gl_NEAREST_CLIPMAP_NEAREST_SGIX = 0x844D

gl_NEAREST_MIPMAP_LINEAR :: GLenum
gl_NEAREST_MIPMAP_LINEAR = 0x2702

gl_NEAREST_MIPMAP_NEAREST :: GLenum
gl_NEAREST_MIPMAP_NEAREST = 0x2700

gl_NEGATE_BIT_ATI :: GLbitfield
gl_NEGATE_BIT_ATI = 0x00000004

gl_NEGATIVE_ONE_EXT :: GLenum
gl_NEGATIVE_ONE_EXT = 0x87DF

gl_NEGATIVE_ONE_TO_ONE :: GLenum
gl_NEGATIVE_ONE_TO_ONE = 0x935E

gl_NEGATIVE_W_EXT :: GLenum
gl_NEGATIVE_W_EXT = 0x87DC

gl_NEGATIVE_X_EXT :: GLenum
gl_NEGATIVE_X_EXT = 0x87D9

gl_NEGATIVE_Y_EXT :: GLenum
gl_NEGATIVE_Y_EXT = 0x87DA

gl_NEGATIVE_Z_EXT :: GLenum
gl_NEGATIVE_Z_EXT = 0x87DB

gl_NEVER :: GLenum
gl_NEVER = 0x0200

gl_NEXT_BUFFER_NV :: GLenum
gl_NEXT_BUFFER_NV = -2

gl_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV :: GLenum
gl_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV = 0x9025

gl_NICEST :: GLenum
gl_NICEST = 0x1102

gl_NONE :: GLenum
gl_NONE = 0

gl_NONE_OES :: GLenum
gl_NONE_OES = 0

gl_NOOP :: GLenum
gl_NOOP = 0x1505

gl_NOR :: GLenum
gl_NOR = 0x1508

gl_NORMALIZE :: GLenum
gl_NORMALIZE = 0x0BA1

gl_NORMALIZED_RANGE_EXT :: GLenum
gl_NORMALIZED_RANGE_EXT = 0x87E0

gl_NORMAL_ARRAY :: GLenum
gl_NORMAL_ARRAY = 0x8075

gl_NORMAL_ARRAY_ADDRESS_NV :: GLenum
gl_NORMAL_ARRAY_ADDRESS_NV = 0x8F22

gl_NORMAL_ARRAY_BUFFER_BINDING :: GLenum
gl_NORMAL_ARRAY_BUFFER_BINDING = 0x8897

gl_NORMAL_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_NORMAL_ARRAY_BUFFER_BINDING_ARB = 0x8897

gl_NORMAL_ARRAY_COUNT_EXT :: GLenum
gl_NORMAL_ARRAY_COUNT_EXT = 0x8080

gl_NORMAL_ARRAY_EXT :: GLenum
gl_NORMAL_ARRAY_EXT = 0x8075

gl_NORMAL_ARRAY_LENGTH_NV :: GLenum
gl_NORMAL_ARRAY_LENGTH_NV = 0x8F2C

gl_NORMAL_ARRAY_LIST_IBM :: GLenum
gl_NORMAL_ARRAY_LIST_IBM = 103071

gl_NORMAL_ARRAY_LIST_STRIDE_IBM :: GLenum
gl_NORMAL_ARRAY_LIST_STRIDE_IBM = 103081

gl_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL :: GLenum
gl_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F6

gl_NORMAL_ARRAY_POINTER :: GLenum
gl_NORMAL_ARRAY_POINTER = 0x808F

gl_NORMAL_ARRAY_POINTER_EXT :: GLenum
gl_NORMAL_ARRAY_POINTER_EXT = 0x808F

gl_NORMAL_ARRAY_STRIDE :: GLenum
gl_NORMAL_ARRAY_STRIDE = 0x807F

gl_NORMAL_ARRAY_STRIDE_EXT :: GLenum
gl_NORMAL_ARRAY_STRIDE_EXT = 0x807F

gl_NORMAL_ARRAY_TYPE :: GLenum
gl_NORMAL_ARRAY_TYPE = 0x807E

gl_NORMAL_ARRAY_TYPE_EXT :: GLenum
gl_NORMAL_ARRAY_TYPE_EXT = 0x807E

gl_NORMAL_BIT_PGI :: GLbitfield
gl_NORMAL_BIT_PGI = 0x08000000

gl_NORMAL_MAP :: GLenum
gl_NORMAL_MAP = 0x8511

gl_NORMAL_MAP_ARB :: GLenum
gl_NORMAL_MAP_ARB = 0x8511

gl_NORMAL_MAP_EXT :: GLenum
gl_NORMAL_MAP_EXT = 0x8511

gl_NORMAL_MAP_NV :: GLenum
gl_NORMAL_MAP_NV = 0x8511

gl_NORMAL_MAP_OES :: GLenum
gl_NORMAL_MAP_OES = 0x8511

gl_NOTEQUAL :: GLenum
gl_NOTEQUAL = 0x0205

gl_NO_ERROR :: GLenum
gl_NO_ERROR = 0

gl_NO_RESET_NOTIFICATION :: GLenum
gl_NO_RESET_NOTIFICATION = 0x8261

gl_NO_RESET_NOTIFICATION_ARB :: GLenum
gl_NO_RESET_NOTIFICATION_ARB = 0x8261

gl_NO_RESET_NOTIFICATION_EXT :: GLenum
gl_NO_RESET_NOTIFICATION_EXT = 0x8261

gl_NO_RESET_NOTIFICATION_KHR :: GLenum
gl_NO_RESET_NOTIFICATION_KHR = 0x8261

gl_NUM_ACTIVE_VARIABLES :: GLenum
gl_NUM_ACTIVE_VARIABLES = 0x9304

gl_NUM_COMPATIBLE_SUBROUTINES :: GLenum
gl_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A

gl_NUM_COMPRESSED_TEXTURE_FORMATS :: GLenum
gl_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2

gl_NUM_COMPRESSED_TEXTURE_FORMATS_ARB :: GLenum
gl_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A2

gl_NUM_EXTENSIONS :: GLenum
gl_NUM_EXTENSIONS = 0x821D

gl_NUM_FILL_STREAMS_NV :: GLenum
gl_NUM_FILL_STREAMS_NV = 0x8E29

gl_NUM_FRAGMENT_CONSTANTS_ATI :: GLenum
gl_NUM_FRAGMENT_CONSTANTS_ATI = 0x896F

gl_NUM_FRAGMENT_REGISTERS_ATI :: GLenum
gl_NUM_FRAGMENT_REGISTERS_ATI = 0x896E

gl_NUM_GENERAL_COMBINERS_NV :: GLenum
gl_NUM_GENERAL_COMBINERS_NV = 0x854E

gl_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI :: GLenum
gl_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI = 0x8973

gl_NUM_INSTRUCTIONS_PER_PASS_ATI :: GLenum
gl_NUM_INSTRUCTIONS_PER_PASS_ATI = 0x8971

gl_NUM_INSTRUCTIONS_TOTAL_ATI :: GLenum
gl_NUM_INSTRUCTIONS_TOTAL_ATI = 0x8972

gl_NUM_LOOPBACK_COMPONENTS_ATI :: GLenum
gl_NUM_LOOPBACK_COMPONENTS_ATI = 0x8974

gl_NUM_PASSES_ATI :: GLenum
gl_NUM_PASSES_ATI = 0x8970

gl_NUM_PROGRAM_BINARY_FORMATS :: GLenum
gl_NUM_PROGRAM_BINARY_FORMATS = 0x87FE

gl_NUM_PROGRAM_BINARY_FORMATS_OES :: GLenum
gl_NUM_PROGRAM_BINARY_FORMATS_OES = 0x87FE

gl_NUM_SAMPLE_COUNTS :: GLenum
gl_NUM_SAMPLE_COUNTS = 0x9380

gl_NUM_SHADER_BINARY_FORMATS :: GLenum
gl_NUM_SHADER_BINARY_FORMATS = 0x8DF9

gl_NUM_SHADING_LANGUAGE_VERSIONS :: GLenum
gl_NUM_SHADING_LANGUAGE_VERSIONS = 0x82E9

gl_NUM_SPARSE_LEVELS_ARB :: GLenum
gl_NUM_SPARSE_LEVELS_ARB = 0x91AA

gl_NUM_VIDEO_CAPTURE_STREAMS_NV :: GLenum
gl_NUM_VIDEO_CAPTURE_STREAMS_NV = 0x9024

gl_NUM_VIRTUAL_PAGE_SIZES_ARB :: GLenum
gl_NUM_VIRTUAL_PAGE_SIZES_ARB = 0x91A8

gl_OBJECT_ACTIVE_ATTRIBUTES_ARB :: GLenum
gl_OBJECT_ACTIVE_ATTRIBUTES_ARB = 0x8B89

gl_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB :: GLenum
gl_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = 0x8B8A

gl_OBJECT_ACTIVE_UNIFORMS_ARB :: GLenum
gl_OBJECT_ACTIVE_UNIFORMS_ARB = 0x8B86

gl_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB :: GLenum
gl_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 0x8B87

gl_OBJECT_ATTACHED_OBJECTS_ARB :: GLenum
gl_OBJECT_ATTACHED_OBJECTS_ARB = 0x8B85

gl_OBJECT_BUFFER_SIZE_ATI :: GLenum
gl_OBJECT_BUFFER_SIZE_ATI = 0x8764

gl_OBJECT_BUFFER_USAGE_ATI :: GLenum
gl_OBJECT_BUFFER_USAGE_ATI = 0x8765

gl_OBJECT_COMPILE_STATUS_ARB :: GLenum
gl_OBJECT_COMPILE_STATUS_ARB = 0x8B81

gl_OBJECT_DELETE_STATUS_ARB :: GLenum
gl_OBJECT_DELETE_STATUS_ARB = 0x8B80

gl_OBJECT_DISTANCE_TO_LINE_SGIS :: GLenum
gl_OBJECT_DISTANCE_TO_LINE_SGIS = 0x81F3

gl_OBJECT_DISTANCE_TO_POINT_SGIS :: GLenum
gl_OBJECT_DISTANCE_TO_POINT_SGIS = 0x81F1

gl_OBJECT_INFO_LOG_LENGTH_ARB :: GLenum
gl_OBJECT_INFO_LOG_LENGTH_ARB = 0x8B84

gl_OBJECT_LINEAR :: GLenum
gl_OBJECT_LINEAR = 0x2401

gl_OBJECT_LINEAR_NV :: GLenum
gl_OBJECT_LINEAR_NV = 0x2401

gl_OBJECT_LINE_SGIS :: GLenum
gl_OBJECT_LINE_SGIS = 0x81F7

gl_OBJECT_LINK_STATUS_ARB :: GLenum
gl_OBJECT_LINK_STATUS_ARB = 0x8B82

gl_OBJECT_PLANE :: GLenum
gl_OBJECT_PLANE = 0x2501

gl_OBJECT_POINT_SGIS :: GLenum
gl_OBJECT_POINT_SGIS = 0x81F5

gl_OBJECT_SHADER_SOURCE_LENGTH_ARB :: GLenum
gl_OBJECT_SHADER_SOURCE_LENGTH_ARB = 0x8B88

gl_OBJECT_SUBTYPE_ARB :: GLenum
gl_OBJECT_SUBTYPE_ARB = 0x8B4F

gl_OBJECT_TYPE :: GLenum
gl_OBJECT_TYPE = 0x9112

gl_OBJECT_TYPE_APPLE :: GLenum
gl_OBJECT_TYPE_APPLE = 0x9112

gl_OBJECT_TYPE_ARB :: GLenum
gl_OBJECT_TYPE_ARB = 0x8B4E

gl_OBJECT_VALIDATE_STATUS_ARB :: GLenum
gl_OBJECT_VALIDATE_STATUS_ARB = 0x8B83

gl_OCCLUSION_QUERY_EVENT_MASK_AMD :: GLenum
gl_OCCLUSION_QUERY_EVENT_MASK_AMD = 0x874F

gl_OCCLUSION_TEST_HP :: GLenum
gl_OCCLUSION_TEST_HP = 0x8165

gl_OCCLUSION_TEST_RESULT_HP :: GLenum
gl_OCCLUSION_TEST_RESULT_HP = 0x8166

gl_OFFSET :: GLenum
gl_OFFSET = 0x92FC

gl_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV :: GLenum
gl_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = 0x8856

gl_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV :: GLenum
gl_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8857

gl_OFFSET_HILO_TEXTURE_2D_NV :: GLenum
gl_OFFSET_HILO_TEXTURE_2D_NV = 0x8854

gl_OFFSET_HILO_TEXTURE_RECTANGLE_NV :: GLenum
gl_OFFSET_HILO_TEXTURE_RECTANGLE_NV = 0x8855

gl_OFFSET_PROJECTIVE_TEXTURE_2D_NV :: GLenum
gl_OFFSET_PROJECTIVE_TEXTURE_2D_NV = 0x8850

gl_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV :: GLenum
gl_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = 0x8851

gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV :: GLenum
gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8852

gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV :: GLenum
gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = 0x8853

gl_OFFSET_TEXTURE_2D_BIAS_NV :: GLenum
gl_OFFSET_TEXTURE_2D_BIAS_NV = 0x86E3

gl_OFFSET_TEXTURE_2D_MATRIX_NV :: GLenum
gl_OFFSET_TEXTURE_2D_MATRIX_NV = 0x86E1

gl_OFFSET_TEXTURE_2D_NV :: GLenum
gl_OFFSET_TEXTURE_2D_NV = 0x86E8

gl_OFFSET_TEXTURE_2D_SCALE_NV :: GLenum
gl_OFFSET_TEXTURE_2D_SCALE_NV = 0x86E2

gl_OFFSET_TEXTURE_BIAS_NV :: GLenum
gl_OFFSET_TEXTURE_BIAS_NV = 0x86E3

gl_OFFSET_TEXTURE_MATRIX_NV :: GLenum
gl_OFFSET_TEXTURE_MATRIX_NV = 0x86E1

gl_OFFSET_TEXTURE_RECTANGLE_NV :: GLenum
gl_OFFSET_TEXTURE_RECTANGLE_NV = 0x864C

gl_OFFSET_TEXTURE_RECTANGLE_SCALE_NV :: GLenum
gl_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = 0x864D

gl_OFFSET_TEXTURE_SCALE_NV :: GLenum
gl_OFFSET_TEXTURE_SCALE_NV = 0x86E2

gl_ONE :: GLenum
gl_ONE = 1

gl_ONE_EXT :: GLenum
gl_ONE_EXT = 0x87DE

gl_ONE_MINUS_CONSTANT_ALPHA :: GLenum
gl_ONE_MINUS_CONSTANT_ALPHA = 0x8004

gl_ONE_MINUS_CONSTANT_ALPHA_EXT :: GLenum
gl_ONE_MINUS_CONSTANT_ALPHA_EXT = 0x8004

gl_ONE_MINUS_CONSTANT_COLOR :: GLenum
gl_ONE_MINUS_CONSTANT_COLOR = 0x8002

gl_ONE_MINUS_CONSTANT_COLOR_EXT :: GLenum
gl_ONE_MINUS_CONSTANT_COLOR_EXT = 0x8002

gl_ONE_MINUS_DST_ALPHA :: GLenum
gl_ONE_MINUS_DST_ALPHA = 0x0305

gl_ONE_MINUS_DST_COLOR :: GLenum
gl_ONE_MINUS_DST_COLOR = 0x0307

gl_ONE_MINUS_SRC1_ALPHA :: GLenum
gl_ONE_MINUS_SRC1_ALPHA = 0x88FB

gl_ONE_MINUS_SRC1_COLOR :: GLenum
gl_ONE_MINUS_SRC1_COLOR = 0x88FA

gl_ONE_MINUS_SRC_ALPHA :: GLenum
gl_ONE_MINUS_SRC_ALPHA = 0x0303

gl_ONE_MINUS_SRC_COLOR :: GLenum
gl_ONE_MINUS_SRC_COLOR = 0x0301

gl_OPERAND0_ALPHA :: GLenum
gl_OPERAND0_ALPHA = 0x8598

gl_OPERAND0_ALPHA_ARB :: GLenum
gl_OPERAND0_ALPHA_ARB = 0x8598

gl_OPERAND0_ALPHA_EXT :: GLenum
gl_OPERAND0_ALPHA_EXT = 0x8598

gl_OPERAND0_RGB :: GLenum
gl_OPERAND0_RGB = 0x8590

gl_OPERAND0_RGB_ARB :: GLenum
gl_OPERAND0_RGB_ARB = 0x8590

gl_OPERAND0_RGB_EXT :: GLenum
gl_OPERAND0_RGB_EXT = 0x8590

gl_OPERAND1_ALPHA :: GLenum
gl_OPERAND1_ALPHA = 0x8599

gl_OPERAND1_ALPHA_ARB :: GLenum
gl_OPERAND1_ALPHA_ARB = 0x8599

gl_OPERAND1_ALPHA_EXT :: GLenum
gl_OPERAND1_ALPHA_EXT = 0x8599

gl_OPERAND1_RGB :: GLenum
gl_OPERAND1_RGB = 0x8591

gl_OPERAND1_RGB_ARB :: GLenum
gl_OPERAND1_RGB_ARB = 0x8591

gl_OPERAND1_RGB_EXT :: GLenum
gl_OPERAND1_RGB_EXT = 0x8591

gl_OPERAND2_ALPHA :: GLenum
gl_OPERAND2_ALPHA = 0x859A

gl_OPERAND2_ALPHA_ARB :: GLenum
gl_OPERAND2_ALPHA_ARB = 0x859A

gl_OPERAND2_ALPHA_EXT :: GLenum
gl_OPERAND2_ALPHA_EXT = 0x859A

gl_OPERAND2_RGB :: GLenum
gl_OPERAND2_RGB = 0x8592

gl_OPERAND2_RGB_ARB :: GLenum
gl_OPERAND2_RGB_ARB = 0x8592

gl_OPERAND2_RGB_EXT :: GLenum
gl_OPERAND2_RGB_EXT = 0x8592

gl_OPERAND3_ALPHA_NV :: GLenum
gl_OPERAND3_ALPHA_NV = 0x859B

gl_OPERAND3_RGB_NV :: GLenum
gl_OPERAND3_RGB_NV = 0x8593

gl_OP_ADD_EXT :: GLenum
gl_OP_ADD_EXT = 0x8787

gl_OP_CLAMP_EXT :: GLenum
gl_OP_CLAMP_EXT = 0x878E

gl_OP_CROSS_PRODUCT_EXT :: GLenum
gl_OP_CROSS_PRODUCT_EXT = 0x8797

gl_OP_DOT3_EXT :: GLenum
gl_OP_DOT3_EXT = 0x8784

gl_OP_DOT4_EXT :: GLenum
gl_OP_DOT4_EXT = 0x8785

gl_OP_EXP_BASE_2_EXT :: GLenum
gl_OP_EXP_BASE_2_EXT = 0x8791

gl_OP_FLOOR_EXT :: GLenum
gl_OP_FLOOR_EXT = 0x878F

gl_OP_FRAC_EXT :: GLenum
gl_OP_FRAC_EXT = 0x8789

gl_OP_INDEX_EXT :: GLenum
gl_OP_INDEX_EXT = 0x8782

gl_OP_LOG_BASE_2_EXT :: GLenum
gl_OP_LOG_BASE_2_EXT = 0x8792

gl_OP_MADD_EXT :: GLenum
gl_OP_MADD_EXT = 0x8788

gl_OP_MAX_EXT :: GLenum
gl_OP_MAX_EXT = 0x878A

gl_OP_MIN_EXT :: GLenum
gl_OP_MIN_EXT = 0x878B

gl_OP_MOV_EXT :: GLenum
gl_OP_MOV_EXT = 0x8799

gl_OP_MULTIPLY_MATRIX_EXT :: GLenum
gl_OP_MULTIPLY_MATRIX_EXT = 0x8798

gl_OP_MUL_EXT :: GLenum
gl_OP_MUL_EXT = 0x8786

gl_OP_NEGATE_EXT :: GLenum
gl_OP_NEGATE_EXT = 0x8783

gl_OP_POWER_EXT :: GLenum
gl_OP_POWER_EXT = 0x8793

gl_OP_RECIP_EXT :: GLenum
gl_OP_RECIP_EXT = 0x8794

gl_OP_RECIP_SQRT_EXT :: GLenum
gl_OP_RECIP_SQRT_EXT = 0x8795

gl_OP_ROUND_EXT :: GLenum
gl_OP_ROUND_EXT = 0x8790

gl_OP_SET_GE_EXT :: GLenum
gl_OP_SET_GE_EXT = 0x878C

gl_OP_SET_LT_EXT :: GLenum
gl_OP_SET_LT_EXT = 0x878D

gl_OP_SUB_EXT :: GLenum
gl_OP_SUB_EXT = 0x8796

gl_OR :: GLenum
gl_OR = 0x1507

gl_ORDER :: GLenum
gl_ORDER = 0x0A01

gl_OR_INVERTED :: GLenum
gl_OR_INVERTED = 0x150D

gl_OR_REVERSE :: GLenum
gl_OR_REVERSE = 0x150B

gl_OUTPUT_COLOR0_EXT :: GLenum
gl_OUTPUT_COLOR0_EXT = 0x879B

gl_OUTPUT_COLOR1_EXT :: GLenum
gl_OUTPUT_COLOR1_EXT = 0x879C

gl_OUTPUT_FOG_EXT :: GLenum
gl_OUTPUT_FOG_EXT = 0x87BD

gl_OUTPUT_TEXTURE_COORD0_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD0_EXT = 0x879D

gl_OUTPUT_TEXTURE_COORD10_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD10_EXT = 0x87A7

gl_OUTPUT_TEXTURE_COORD11_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD11_EXT = 0x87A8

gl_OUTPUT_TEXTURE_COORD12_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD12_EXT = 0x87A9

gl_OUTPUT_TEXTURE_COORD13_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD13_EXT = 0x87AA

gl_OUTPUT_TEXTURE_COORD14_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD14_EXT = 0x87AB

gl_OUTPUT_TEXTURE_COORD15_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD15_EXT = 0x87AC

gl_OUTPUT_TEXTURE_COORD16_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD16_EXT = 0x87AD

gl_OUTPUT_TEXTURE_COORD17_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD17_EXT = 0x87AE

gl_OUTPUT_TEXTURE_COORD18_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD18_EXT = 0x87AF

gl_OUTPUT_TEXTURE_COORD19_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD19_EXT = 0x87B0

gl_OUTPUT_TEXTURE_COORD1_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD1_EXT = 0x879E

gl_OUTPUT_TEXTURE_COORD20_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD20_EXT = 0x87B1

gl_OUTPUT_TEXTURE_COORD21_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD21_EXT = 0x87B2

gl_OUTPUT_TEXTURE_COORD22_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD22_EXT = 0x87B3

gl_OUTPUT_TEXTURE_COORD23_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD23_EXT = 0x87B4

gl_OUTPUT_TEXTURE_COORD24_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD24_EXT = 0x87B5

gl_OUTPUT_TEXTURE_COORD25_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD25_EXT = 0x87B6

gl_OUTPUT_TEXTURE_COORD26_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD26_EXT = 0x87B7

gl_OUTPUT_TEXTURE_COORD27_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD27_EXT = 0x87B8

gl_OUTPUT_TEXTURE_COORD28_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD28_EXT = 0x87B9

gl_OUTPUT_TEXTURE_COORD29_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD29_EXT = 0x87BA

gl_OUTPUT_TEXTURE_COORD2_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD2_EXT = 0x879F

gl_OUTPUT_TEXTURE_COORD30_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD30_EXT = 0x87BB

gl_OUTPUT_TEXTURE_COORD31_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD31_EXT = 0x87BC

gl_OUTPUT_TEXTURE_COORD3_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD3_EXT = 0x87A0

gl_OUTPUT_TEXTURE_COORD4_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD4_EXT = 0x87A1

gl_OUTPUT_TEXTURE_COORD5_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD5_EXT = 0x87A2

gl_OUTPUT_TEXTURE_COORD6_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD6_EXT = 0x87A3

gl_OUTPUT_TEXTURE_COORD7_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD7_EXT = 0x87A4

gl_OUTPUT_TEXTURE_COORD8_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD8_EXT = 0x87A5

gl_OUTPUT_TEXTURE_COORD9_EXT :: GLenum
gl_OUTPUT_TEXTURE_COORD9_EXT = 0x87A6

gl_OUTPUT_VERTEX_EXT :: GLenum
gl_OUTPUT_VERTEX_EXT = 0x879A

gl_OUT_OF_MEMORY :: GLenum
gl_OUT_OF_MEMORY = 0x0505

gl_OVERLAY_KHR :: GLenum
gl_OVERLAY_KHR = 0x9296

gl_OVERLAY_NV :: GLenum
gl_OVERLAY_NV = 0x9296

gl_PACK_ALIGNMENT :: GLenum
gl_PACK_ALIGNMENT = 0x0D05

gl_PACK_CMYK_HINT_EXT :: GLenum
gl_PACK_CMYK_HINT_EXT = 0x800E

gl_PACK_COMPRESSED_BLOCK_DEPTH :: GLenum
gl_PACK_COMPRESSED_BLOCK_DEPTH = 0x912D

gl_PACK_COMPRESSED_BLOCK_HEIGHT :: GLenum
gl_PACK_COMPRESSED_BLOCK_HEIGHT = 0x912C

gl_PACK_COMPRESSED_BLOCK_SIZE :: GLenum
gl_PACK_COMPRESSED_BLOCK_SIZE = 0x912E

gl_PACK_COMPRESSED_BLOCK_WIDTH :: GLenum
gl_PACK_COMPRESSED_BLOCK_WIDTH = 0x912B

gl_PACK_COMPRESSED_SIZE_SGIX :: GLenum
gl_PACK_COMPRESSED_SIZE_SGIX = 0x831C

gl_PACK_IMAGE_DEPTH_SGIS :: GLenum
gl_PACK_IMAGE_DEPTH_SGIS = 0x8131

gl_PACK_IMAGE_HEIGHT :: GLenum
gl_PACK_IMAGE_HEIGHT = 0x806C

gl_PACK_IMAGE_HEIGHT_EXT :: GLenum
gl_PACK_IMAGE_HEIGHT_EXT = 0x806C

gl_PACK_INVERT_MESA :: GLenum
gl_PACK_INVERT_MESA = 0x8758

gl_PACK_LSB_FIRST :: GLenum
gl_PACK_LSB_FIRST = 0x0D01

gl_PACK_MAX_COMPRESSED_SIZE_SGIX :: GLenum
gl_PACK_MAX_COMPRESSED_SIZE_SGIX = 0x831B

gl_PACK_RESAMPLE_OML :: GLenum
gl_PACK_RESAMPLE_OML = 0x8984

gl_PACK_RESAMPLE_SGIX :: GLenum
gl_PACK_RESAMPLE_SGIX = 0x842E

gl_PACK_REVERSE_ROW_ORDER_ANGLE :: GLenum
gl_PACK_REVERSE_ROW_ORDER_ANGLE = 0x93A4

gl_PACK_ROW_BYTES_APPLE :: GLenum
gl_PACK_ROW_BYTES_APPLE = 0x8A15

gl_PACK_ROW_LENGTH :: GLenum
gl_PACK_ROW_LENGTH = 0x0D02

gl_PACK_SKIP_IMAGES :: GLenum
gl_PACK_SKIP_IMAGES = 0x806B

gl_PACK_SKIP_IMAGES_EXT :: GLenum
gl_PACK_SKIP_IMAGES_EXT = 0x806B

gl_PACK_SKIP_PIXELS :: GLenum
gl_PACK_SKIP_PIXELS = 0x0D04

gl_PACK_SKIP_ROWS :: GLenum
gl_PACK_SKIP_ROWS = 0x0D03

gl_PACK_SKIP_VOLUMES_SGIS :: GLenum
gl_PACK_SKIP_VOLUMES_SGIS = 0x8130

gl_PACK_SUBSAMPLE_RATE_SGIX :: GLenum
gl_PACK_SUBSAMPLE_RATE_SGIX = 0x85A0

gl_PACK_SWAP_BYTES :: GLenum
gl_PACK_SWAP_BYTES = 0x0D00

gl_PALETTE4_R5_G6_B5_OES :: GLenum
gl_PALETTE4_R5_G6_B5_OES = 0x8B92

gl_PALETTE4_RGB5_A1_OES :: GLenum
gl_PALETTE4_RGB5_A1_OES = 0x8B94

gl_PALETTE4_RGB8_OES :: GLenum
gl_PALETTE4_RGB8_OES = 0x8B90

gl_PALETTE4_RGBA4_OES :: GLenum
gl_PALETTE4_RGBA4_OES = 0x8B93

gl_PALETTE4_RGBA8_OES :: GLenum
gl_PALETTE4_RGBA8_OES = 0x8B91

gl_PALETTE8_R5_G6_B5_OES :: GLenum
gl_PALETTE8_R5_G6_B5_OES = 0x8B97

gl_PALETTE8_RGB5_A1_OES :: GLenum
gl_PALETTE8_RGB5_A1_OES = 0x8B99

gl_PALETTE8_RGB8_OES :: GLenum
gl_PALETTE8_RGB8_OES = 0x8B95

gl_PALETTE8_RGBA4_OES :: GLenum
gl_PALETTE8_RGBA4_OES = 0x8B98

gl_PALETTE8_RGBA8_OES :: GLenum
gl_PALETTE8_RGBA8_OES = 0x8B96

gl_PARALLEL_ARRAYS_INTEL :: GLenum
gl_PARALLEL_ARRAYS_INTEL = 0x83F4

gl_PARAMETER_BUFFER_ARB :: GLenum
gl_PARAMETER_BUFFER_ARB = 0x80EE

gl_PARAMETER_BUFFER_BINDING_ARB :: GLenum
gl_PARAMETER_BUFFER_BINDING_ARB = 0x80EF

gl_PARTIAL_SUCCESS_NV :: GLenum
gl_PARTIAL_SUCCESS_NV = 0x902E

gl_PASS_THROUGH_NV :: GLenum
gl_PASS_THROUGH_NV = 0x86E6

gl_PASS_THROUGH_TOKEN :: GLenum
gl_PASS_THROUGH_TOKEN = 0x0700

gl_PATCHES :: GLenum
gl_PATCHES = 0x000E

gl_PATCHES_EXT :: GLenum
gl_PATCHES_EXT = 0x000E

gl_PATCHES_OES :: GLenum
gl_PATCHES_OES = 0x000E

gl_PATCH_DEFAULT_INNER_LEVEL :: GLenum
gl_PATCH_DEFAULT_INNER_LEVEL = 0x8E73

gl_PATCH_DEFAULT_INNER_LEVEL_EXT :: GLenum
gl_PATCH_DEFAULT_INNER_LEVEL_EXT = 0x8E73

gl_PATCH_DEFAULT_OUTER_LEVEL :: GLenum
gl_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74

gl_PATCH_DEFAULT_OUTER_LEVEL_EXT :: GLenum
gl_PATCH_DEFAULT_OUTER_LEVEL_EXT = 0x8E74

gl_PATCH_VERTICES :: GLenum
gl_PATCH_VERTICES = 0x8E72

gl_PATCH_VERTICES_EXT :: GLenum
gl_PATCH_VERTICES_EXT = 0x8E72

gl_PATCH_VERTICES_OES :: GLenum
gl_PATCH_VERTICES_OES = 0x8E72

gl_PATH_CLIENT_LENGTH_NV :: GLenum
gl_PATH_CLIENT_LENGTH_NV = 0x907F

gl_PATH_COMMAND_COUNT_NV :: GLenum
gl_PATH_COMMAND_COUNT_NV = 0x909D

gl_PATH_COMPUTED_LENGTH_NV :: GLenum
gl_PATH_COMPUTED_LENGTH_NV = 0x90A0

gl_PATH_COORD_COUNT_NV :: GLenum
gl_PATH_COORD_COUNT_NV = 0x909E

gl_PATH_COVER_DEPTH_FUNC_NV :: GLenum
gl_PATH_COVER_DEPTH_FUNC_NV = 0x90BF

gl_PATH_DASH_ARRAY_COUNT_NV :: GLenum
gl_PATH_DASH_ARRAY_COUNT_NV = 0x909F

gl_PATH_DASH_CAPS_NV :: GLenum
gl_PATH_DASH_CAPS_NV = 0x907B

gl_PATH_DASH_OFFSET_NV :: GLenum
gl_PATH_DASH_OFFSET_NV = 0x907E

gl_PATH_DASH_OFFSET_RESET_NV :: GLenum
gl_PATH_DASH_OFFSET_RESET_NV = 0x90B4

gl_PATH_END_CAPS_NV :: GLenum
gl_PATH_END_CAPS_NV = 0x9076

gl_PATH_ERROR_POSITION_NV :: GLenum
gl_PATH_ERROR_POSITION_NV = 0x90AB

gl_PATH_FILL_BOUNDING_BOX_NV :: GLenum
gl_PATH_FILL_BOUNDING_BOX_NV = 0x90A1

gl_PATH_FILL_COVER_MODE_NV :: GLenum
gl_PATH_FILL_COVER_MODE_NV = 0x9082

gl_PATH_FILL_MASK_NV :: GLenum
gl_PATH_FILL_MASK_NV = 0x9081

gl_PATH_FILL_MODE_NV :: GLenum
gl_PATH_FILL_MODE_NV = 0x9080

gl_PATH_FOG_GEN_MODE_NV :: GLenum
gl_PATH_FOG_GEN_MODE_NV = 0x90AC

gl_PATH_FORMAT_PS_NV :: GLenum
gl_PATH_FORMAT_PS_NV = 0x9071

gl_PATH_FORMAT_SVG_NV :: GLenum
gl_PATH_FORMAT_SVG_NV = 0x9070

gl_PATH_GEN_COEFF_NV :: GLenum
gl_PATH_GEN_COEFF_NV = 0x90B1

gl_PATH_GEN_COLOR_FORMAT_NV :: GLenum
gl_PATH_GEN_COLOR_FORMAT_NV = 0x90B2

gl_PATH_GEN_COMPONENTS_NV :: GLenum
gl_PATH_GEN_COMPONENTS_NV = 0x90B3

gl_PATH_GEN_MODE_NV :: GLenum
gl_PATH_GEN_MODE_NV = 0x90B0

gl_PATH_INITIAL_DASH_CAP_NV :: GLenum
gl_PATH_INITIAL_DASH_CAP_NV = 0x907C

gl_PATH_INITIAL_END_CAP_NV :: GLenum
gl_PATH_INITIAL_END_CAP_NV = 0x9077

gl_PATH_JOIN_STYLE_NV :: GLenum
gl_PATH_JOIN_STYLE_NV = 0x9079

gl_PATH_MAX_MODELVIEW_STACK_DEPTH_NV :: GLenum
gl_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = 0x0D36

gl_PATH_MAX_PROJECTION_STACK_DEPTH_NV :: GLenum
gl_PATH_MAX_PROJECTION_STACK_DEPTH_NV = 0x0D38

gl_PATH_MITER_LIMIT_NV :: GLenum
gl_PATH_MITER_LIMIT_NV = 0x907A

gl_PATH_MODELVIEW_MATRIX_NV :: GLenum
gl_PATH_MODELVIEW_MATRIX_NV = 0x0BA6

gl_PATH_MODELVIEW_NV :: GLenum
gl_PATH_MODELVIEW_NV = 0x1700

gl_PATH_MODELVIEW_STACK_DEPTH_NV :: GLenum
gl_PATH_MODELVIEW_STACK_DEPTH_NV = 0x0BA3

gl_PATH_OBJECT_BOUNDING_BOX_NV :: GLenum
gl_PATH_OBJECT_BOUNDING_BOX_NV = 0x908A

gl_PATH_PROJECTION_MATRIX_NV :: GLenum
gl_PATH_PROJECTION_MATRIX_NV = 0x0BA7

gl_PATH_PROJECTION_NV :: GLenum
gl_PATH_PROJECTION_NV = 0x1701

gl_PATH_PROJECTION_STACK_DEPTH_NV :: GLenum
gl_PATH_PROJECTION_STACK_DEPTH_NV = 0x0BA4

gl_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV :: GLenum
gl_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = 0x90BD

gl_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV :: GLenum
gl_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = 0x90BE

gl_PATH_STENCIL_FUNC_NV :: GLenum
gl_PATH_STENCIL_FUNC_NV = 0x90B7

gl_PATH_STENCIL_REF_NV :: GLenum
gl_PATH_STENCIL_REF_NV = 0x90B8

gl_PATH_STENCIL_VALUE_MASK_NV :: GLenum
gl_PATH_STENCIL_VALUE_MASK_NV = 0x90B9

gl_PATH_STROKE_BOUNDING_BOX_NV :: GLenum
gl_PATH_STROKE_BOUNDING_BOX_NV = 0x90A2

gl_PATH_STROKE_COVER_MODE_NV :: GLenum
gl_PATH_STROKE_COVER_MODE_NV = 0x9083

gl_PATH_STROKE_MASK_NV :: GLenum
gl_PATH_STROKE_MASK_NV = 0x9084

gl_PATH_STROKE_WIDTH_NV :: GLenum
gl_PATH_STROKE_WIDTH_NV = 0x9075

gl_PATH_TERMINAL_DASH_CAP_NV :: GLenum
gl_PATH_TERMINAL_DASH_CAP_NV = 0x907D

gl_PATH_TERMINAL_END_CAP_NV :: GLenum
gl_PATH_TERMINAL_END_CAP_NV = 0x9078

gl_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV :: GLenum
gl_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = 0x84E3

gl_PATH_TRANSPOSE_PROJECTION_MATRIX_NV :: GLenum
gl_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = 0x84E4

gl_PERCENTAGE_AMD :: GLenum
gl_PERCENTAGE_AMD = 0x8BC3

gl_PERFMON_GLOBAL_MODE_QCOM :: GLenum
gl_PERFMON_GLOBAL_MODE_QCOM = 0x8FA0

gl_PERFMON_RESULT_AMD :: GLenum
gl_PERFMON_RESULT_AMD = 0x8BC6

gl_PERFMON_RESULT_AVAILABLE_AMD :: GLenum
gl_PERFMON_RESULT_AVAILABLE_AMD = 0x8BC4

gl_PERFMON_RESULT_SIZE_AMD :: GLenum
gl_PERFMON_RESULT_SIZE_AMD = 0x8BC5

gl_PERFORMANCE_MONITOR_AMD :: GLenum
gl_PERFORMANCE_MONITOR_AMD = 0x9152

gl_PERFQUERY_COUNTER_DATA_BOOL32_INTEL :: GLenum
gl_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 0x94FC

gl_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL :: GLenum
gl_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 0x94FB

gl_PERFQUERY_COUNTER_DATA_FLOAT_INTEL :: GLenum
gl_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 0x94FA

gl_PERFQUERY_COUNTER_DATA_UINT32_INTEL :: GLenum
gl_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 0x94F8

gl_PERFQUERY_COUNTER_DATA_UINT64_INTEL :: GLenum
gl_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 0x94F9

gl_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL :: GLenum
gl_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 0x94FF

gl_PERFQUERY_COUNTER_DURATION_NORM_INTEL :: GLenum
gl_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 0x94F1

gl_PERFQUERY_COUNTER_DURATION_RAW_INTEL :: GLenum
gl_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 0x94F2

gl_PERFQUERY_COUNTER_EVENT_INTEL :: GLenum
gl_PERFQUERY_COUNTER_EVENT_INTEL = 0x94F0

gl_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL :: GLenum
gl_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 0x94FE

gl_PERFQUERY_COUNTER_RAW_INTEL :: GLenum
gl_PERFQUERY_COUNTER_RAW_INTEL = 0x94F4

gl_PERFQUERY_COUNTER_THROUGHPUT_INTEL :: GLenum
gl_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 0x94F3

gl_PERFQUERY_COUNTER_TIMESTAMP_INTEL :: GLenum
gl_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 0x94F5

gl_PERFQUERY_DONOT_FLUSH_INTEL :: GLenum
gl_PERFQUERY_DONOT_FLUSH_INTEL = 0x83F9

gl_PERFQUERY_FLUSH_INTEL :: GLenum
gl_PERFQUERY_FLUSH_INTEL = 0x83FA

gl_PERFQUERY_GLOBAL_CONTEXT_INTEL :: GLbitfield
gl_PERFQUERY_GLOBAL_CONTEXT_INTEL = 0x00000001

gl_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL :: GLenum
gl_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 0x9500

gl_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL :: GLenum
gl_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 0x94FD

gl_PERFQUERY_SINGLE_CONTEXT_INTEL :: GLbitfield
gl_PERFQUERY_SINGLE_CONTEXT_INTEL = 0x00000000

gl_PERFQUERY_WAIT_INTEL :: GLenum
gl_PERFQUERY_WAIT_INTEL = 0x83FB

gl_PERSPECTIVE_CORRECTION_HINT :: GLenum
gl_PERSPECTIVE_CORRECTION_HINT = 0x0C50

gl_PERTURB_EXT :: GLenum
gl_PERTURB_EXT = 0x85AE

gl_PER_STAGE_CONSTANTS_NV :: GLenum
gl_PER_STAGE_CONSTANTS_NV = 0x8535

gl_PHONG_HINT_WIN :: GLenum
gl_PHONG_HINT_WIN = 0x80EB

gl_PHONG_WIN :: GLenum
gl_PHONG_WIN = 0x80EA

gl_PINLIGHT_NV :: GLenum
gl_PINLIGHT_NV = 0x92A8

gl_PIXEL_BUFFER_BARRIER_BIT :: GLbitfield
gl_PIXEL_BUFFER_BARRIER_BIT = 0x00000080

gl_PIXEL_BUFFER_BARRIER_BIT_EXT :: GLbitfield
gl_PIXEL_BUFFER_BARRIER_BIT_EXT = 0x00000080

gl_PIXEL_COUNTER_BITS_NV :: GLenum
gl_PIXEL_COUNTER_BITS_NV = 0x8864

gl_PIXEL_COUNT_AVAILABLE_NV :: GLenum
gl_PIXEL_COUNT_AVAILABLE_NV = 0x8867

gl_PIXEL_COUNT_NV :: GLenum
gl_PIXEL_COUNT_NV = 0x8866

gl_PIXEL_CUBIC_WEIGHT_EXT :: GLenum
gl_PIXEL_CUBIC_WEIGHT_EXT = 0x8333

gl_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS :: GLenum
gl_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = 0x8355

gl_PIXEL_FRAGMENT_RGB_SOURCE_SGIS :: GLenum
gl_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = 0x8354

gl_PIXEL_GROUP_COLOR_SGIS :: GLenum
gl_PIXEL_GROUP_COLOR_SGIS = 0x8356

gl_PIXEL_MAG_FILTER_EXT :: GLenum
gl_PIXEL_MAG_FILTER_EXT = 0x8331

gl_PIXEL_MAP_A_TO_A :: GLenum
gl_PIXEL_MAP_A_TO_A = 0x0C79

gl_PIXEL_MAP_A_TO_A_SIZE :: GLenum
gl_PIXEL_MAP_A_TO_A_SIZE = 0x0CB9

gl_PIXEL_MAP_B_TO_B :: GLenum
gl_PIXEL_MAP_B_TO_B = 0x0C78

gl_PIXEL_MAP_B_TO_B_SIZE :: GLenum
gl_PIXEL_MAP_B_TO_B_SIZE = 0x0CB8

gl_PIXEL_MAP_G_TO_G :: GLenum
gl_PIXEL_MAP_G_TO_G = 0x0C77

gl_PIXEL_MAP_G_TO_G_SIZE :: GLenum
gl_PIXEL_MAP_G_TO_G_SIZE = 0x0CB7

gl_PIXEL_MAP_I_TO_A :: GLenum
gl_PIXEL_MAP_I_TO_A = 0x0C75

gl_PIXEL_MAP_I_TO_A_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_A_SIZE = 0x0CB5

gl_PIXEL_MAP_I_TO_B :: GLenum
gl_PIXEL_MAP_I_TO_B = 0x0C74

gl_PIXEL_MAP_I_TO_B_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_B_SIZE = 0x0CB4

gl_PIXEL_MAP_I_TO_G :: GLenum
gl_PIXEL_MAP_I_TO_G = 0x0C73

gl_PIXEL_MAP_I_TO_G_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_G_SIZE = 0x0CB3

gl_PIXEL_MAP_I_TO_I :: GLenum
gl_PIXEL_MAP_I_TO_I = 0x0C70

gl_PIXEL_MAP_I_TO_I_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_I_SIZE = 0x0CB0

gl_PIXEL_MAP_I_TO_R :: GLenum
gl_PIXEL_MAP_I_TO_R = 0x0C72

gl_PIXEL_MAP_I_TO_R_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_R_SIZE = 0x0CB2

gl_PIXEL_MAP_R_TO_R :: GLenum
gl_PIXEL_MAP_R_TO_R = 0x0C76

gl_PIXEL_MAP_R_TO_R_SIZE :: GLenum
gl_PIXEL_MAP_R_TO_R_SIZE = 0x0CB6

gl_PIXEL_MAP_S_TO_S :: GLenum
gl_PIXEL_MAP_S_TO_S = 0x0C71

gl_PIXEL_MAP_S_TO_S_SIZE :: GLenum
gl_PIXEL_MAP_S_TO_S_SIZE = 0x0CB1

gl_PIXEL_MIN_FILTER_EXT :: GLenum
gl_PIXEL_MIN_FILTER_EXT = 0x8332

gl_PIXEL_MODE_BIT :: GLbitfield
gl_PIXEL_MODE_BIT = 0x00000020

gl_PIXEL_PACK_BUFFER :: GLenum
gl_PIXEL_PACK_BUFFER = 0x88EB

gl_PIXEL_PACK_BUFFER_ARB :: GLenum
gl_PIXEL_PACK_BUFFER_ARB = 0x88EB

gl_PIXEL_PACK_BUFFER_BINDING :: GLenum
gl_PIXEL_PACK_BUFFER_BINDING = 0x88ED

gl_PIXEL_PACK_BUFFER_BINDING_ARB :: GLenum
gl_PIXEL_PACK_BUFFER_BINDING_ARB = 0x88ED

gl_PIXEL_PACK_BUFFER_BINDING_EXT :: GLenum
gl_PIXEL_PACK_BUFFER_BINDING_EXT = 0x88ED

gl_PIXEL_PACK_BUFFER_EXT :: GLenum
gl_PIXEL_PACK_BUFFER_EXT = 0x88EB

gl_PIXEL_SUBSAMPLE_2424_SGIX :: GLenum
gl_PIXEL_SUBSAMPLE_2424_SGIX = 0x85A3

gl_PIXEL_SUBSAMPLE_4242_SGIX :: GLenum
gl_PIXEL_SUBSAMPLE_4242_SGIX = 0x85A4

gl_PIXEL_SUBSAMPLE_4444_SGIX :: GLenum
gl_PIXEL_SUBSAMPLE_4444_SGIX = 0x85A2

gl_PIXEL_TEXTURE_SGIS :: GLenum
gl_PIXEL_TEXTURE_SGIS = 0x8353

gl_PIXEL_TEX_GEN_ALPHA_LS_SGIX :: GLenum
gl_PIXEL_TEX_GEN_ALPHA_LS_SGIX = 0x8189

gl_PIXEL_TEX_GEN_ALPHA_MS_SGIX :: GLenum
gl_PIXEL_TEX_GEN_ALPHA_MS_SGIX = 0x818A

gl_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX :: GLenum
gl_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX = 0x8188

gl_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX :: GLenum
gl_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX = 0x8187

gl_PIXEL_TEX_GEN_MODE_SGIX :: GLenum
gl_PIXEL_TEX_GEN_MODE_SGIX = 0x832B

gl_PIXEL_TEX_GEN_Q_CEILING_SGIX :: GLenum
gl_PIXEL_TEX_GEN_Q_CEILING_SGIX = 0x8184

gl_PIXEL_TEX_GEN_Q_FLOOR_SGIX :: GLenum
gl_PIXEL_TEX_GEN_Q_FLOOR_SGIX = 0x8186

gl_PIXEL_TEX_GEN_Q_ROUND_SGIX :: GLenum
gl_PIXEL_TEX_GEN_Q_ROUND_SGIX = 0x8185

gl_PIXEL_TEX_GEN_SGIX :: GLenum
gl_PIXEL_TEX_GEN_SGIX = 0x8139

gl_PIXEL_TILE_BEST_ALIGNMENT_SGIX :: GLenum
gl_PIXEL_TILE_BEST_ALIGNMENT_SGIX = 0x813E

gl_PIXEL_TILE_CACHE_INCREMENT_SGIX :: GLenum
gl_PIXEL_TILE_CACHE_INCREMENT_SGIX = 0x813F

gl_PIXEL_TILE_CACHE_SIZE_SGIX :: GLenum
gl_PIXEL_TILE_CACHE_SIZE_SGIX = 0x8145

gl_PIXEL_TILE_GRID_DEPTH_SGIX :: GLenum
gl_PIXEL_TILE_GRID_DEPTH_SGIX = 0x8144

gl_PIXEL_TILE_GRID_HEIGHT_SGIX :: GLenum
gl_PIXEL_TILE_GRID_HEIGHT_SGIX = 0x8143

gl_PIXEL_TILE_GRID_WIDTH_SGIX :: GLenum
gl_PIXEL_TILE_GRID_WIDTH_SGIX = 0x8142

gl_PIXEL_TILE_HEIGHT_SGIX :: GLenum
gl_PIXEL_TILE_HEIGHT_SGIX = 0x8141

gl_PIXEL_TILE_WIDTH_SGIX :: GLenum
gl_PIXEL_TILE_WIDTH_SGIX = 0x8140

gl_PIXEL_TRANSFORM_2D_EXT :: GLenum
gl_PIXEL_TRANSFORM_2D_EXT = 0x8330

gl_PIXEL_TRANSFORM_2D_MATRIX_EXT :: GLenum
gl_PIXEL_TRANSFORM_2D_MATRIX_EXT = 0x8338

gl_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT :: GLenum
gl_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = 0x8336

gl_PIXEL_UNPACK_BUFFER :: GLenum
gl_PIXEL_UNPACK_BUFFER = 0x88EC

gl_PIXEL_UNPACK_BUFFER_ARB :: GLenum
gl_PIXEL_UNPACK_BUFFER_ARB = 0x88EC

gl_PIXEL_UNPACK_BUFFER_BINDING :: GLenum
gl_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF

gl_PIXEL_UNPACK_BUFFER_BINDING_ARB :: GLenum
gl_PIXEL_UNPACK_BUFFER_BINDING_ARB = 0x88EF

gl_PIXEL_UNPACK_BUFFER_BINDING_EXT :: GLenum
gl_PIXEL_UNPACK_BUFFER_BINDING_EXT = 0x88EF

gl_PIXEL_UNPACK_BUFFER_EXT :: GLenum
gl_PIXEL_UNPACK_BUFFER_EXT = 0x88EC

gl_PLUS_CLAMPED_ALPHA_NV :: GLenum
gl_PLUS_CLAMPED_ALPHA_NV = 0x92B2

gl_PLUS_CLAMPED_NV :: GLenum
gl_PLUS_CLAMPED_NV = 0x92B1

gl_PLUS_DARKER_NV :: GLenum
gl_PLUS_DARKER_NV = 0x9292

gl_PLUS_NV :: GLenum
gl_PLUS_NV = 0x9291

gl_PN_TRIANGLES_ATI :: GLenum
gl_PN_TRIANGLES_ATI = 0x87F0

gl_PN_TRIANGLES_NORMAL_MODE_ATI :: GLenum
gl_PN_TRIANGLES_NORMAL_MODE_ATI = 0x87F3

gl_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI :: GLenum
gl_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = 0x87F7

gl_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI :: GLenum
gl_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = 0x87F8

gl_PN_TRIANGLES_POINT_MODE_ATI :: GLenum
gl_PN_TRIANGLES_POINT_MODE_ATI = 0x87F2

gl_PN_TRIANGLES_POINT_MODE_CUBIC_ATI :: GLenum
gl_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = 0x87F6

gl_PN_TRIANGLES_POINT_MODE_LINEAR_ATI :: GLenum
gl_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = 0x87F5

gl_PN_TRIANGLES_TESSELATION_LEVEL_ATI :: GLenum
gl_PN_TRIANGLES_TESSELATION_LEVEL_ATI = 0x87F4

gl_POINT :: GLenum
gl_POINT = 0x1B00

gl_POINTS :: GLenum
gl_POINTS = 0x0000

gl_POINT_BIT :: GLbitfield
gl_POINT_BIT = 0x00000002

gl_POINT_DISTANCE_ATTENUATION :: GLenum
gl_POINT_DISTANCE_ATTENUATION = 0x8129

gl_POINT_DISTANCE_ATTENUATION_ARB :: GLenum
gl_POINT_DISTANCE_ATTENUATION_ARB = 0x8129

gl_POINT_FADE_THRESHOLD_SIZE :: GLenum
gl_POINT_FADE_THRESHOLD_SIZE = 0x8128

gl_POINT_FADE_THRESHOLD_SIZE_ARB :: GLenum
gl_POINT_FADE_THRESHOLD_SIZE_ARB = 0x8128

gl_POINT_FADE_THRESHOLD_SIZE_EXT :: GLenum
gl_POINT_FADE_THRESHOLD_SIZE_EXT = 0x8128

gl_POINT_FADE_THRESHOLD_SIZE_SGIS :: GLenum
gl_POINT_FADE_THRESHOLD_SIZE_SGIS = 0x8128

gl_POINT_SIZE :: GLenum
gl_POINT_SIZE = 0x0B11

gl_POINT_SIZE_ARRAY_BUFFER_BINDING_OES :: GLenum
gl_POINT_SIZE_ARRAY_BUFFER_BINDING_OES = 0x8B9F

gl_POINT_SIZE_ARRAY_OES :: GLenum
gl_POINT_SIZE_ARRAY_OES = 0x8B9C

gl_POINT_SIZE_ARRAY_POINTER_OES :: GLenum
gl_POINT_SIZE_ARRAY_POINTER_OES = 0x898C

gl_POINT_SIZE_ARRAY_STRIDE_OES :: GLenum
gl_POINT_SIZE_ARRAY_STRIDE_OES = 0x898B

gl_POINT_SIZE_ARRAY_TYPE_OES :: GLenum
gl_POINT_SIZE_ARRAY_TYPE_OES = 0x898A

gl_POINT_SIZE_GRANULARITY :: GLenum
gl_POINT_SIZE_GRANULARITY = 0x0B13

gl_POINT_SIZE_MAX :: GLenum
gl_POINT_SIZE_MAX = 0x8127

gl_POINT_SIZE_MAX_ARB :: GLenum
gl_POINT_SIZE_MAX_ARB = 0x8127

gl_POINT_SIZE_MAX_EXT :: GLenum
gl_POINT_SIZE_MAX_EXT = 0x8127

gl_POINT_SIZE_MAX_SGIS :: GLenum
gl_POINT_SIZE_MAX_SGIS = 0x8127

gl_POINT_SIZE_MIN :: GLenum
gl_POINT_SIZE_MIN = 0x8126

gl_POINT_SIZE_MIN_ARB :: GLenum
gl_POINT_SIZE_MIN_ARB = 0x8126

gl_POINT_SIZE_MIN_EXT :: GLenum
gl_POINT_SIZE_MIN_EXT = 0x8126

gl_POINT_SIZE_MIN_SGIS :: GLenum
gl_POINT_SIZE_MIN_SGIS = 0x8126

gl_POINT_SIZE_RANGE :: GLenum
gl_POINT_SIZE_RANGE = 0x0B12

gl_POINT_SMOOTH :: GLenum
gl_POINT_SMOOTH = 0x0B10

gl_POINT_SMOOTH_HINT :: GLenum
gl_POINT_SMOOTH_HINT = 0x0C51

gl_POINT_SPRITE :: GLenum
gl_POINT_SPRITE = 0x8861

gl_POINT_SPRITE_ARB :: GLenum
gl_POINT_SPRITE_ARB = 0x8861

gl_POINT_SPRITE_COORD_ORIGIN :: GLenum
gl_POINT_SPRITE_COORD_ORIGIN = 0x8CA0

gl_POINT_SPRITE_NV :: GLenum
gl_POINT_SPRITE_NV = 0x8861

gl_POINT_SPRITE_OES :: GLenum
gl_POINT_SPRITE_OES = 0x8861

gl_POINT_SPRITE_R_MODE_NV :: GLenum
gl_POINT_SPRITE_R_MODE_NV = 0x8863

gl_POINT_TOKEN :: GLenum
gl_POINT_TOKEN = 0x0701

gl_POLYGON :: GLenum
gl_POLYGON = 0x0009

gl_POLYGON_BIT :: GLbitfield
gl_POLYGON_BIT = 0x00000008

gl_POLYGON_MODE :: GLenum
gl_POLYGON_MODE = 0x0B40

gl_POLYGON_OFFSET_BIAS_EXT :: GLenum
gl_POLYGON_OFFSET_BIAS_EXT = 0x8039

gl_POLYGON_OFFSET_CLAMP_EXT :: GLenum
gl_POLYGON_OFFSET_CLAMP_EXT = 0x8E1B

gl_POLYGON_OFFSET_EXT :: GLenum
gl_POLYGON_OFFSET_EXT = 0x8037

gl_POLYGON_OFFSET_FACTOR :: GLenum
gl_POLYGON_OFFSET_FACTOR = 0x8038

gl_POLYGON_OFFSET_FACTOR_EXT :: GLenum
gl_POLYGON_OFFSET_FACTOR_EXT = 0x8038

gl_POLYGON_OFFSET_FILL :: GLenum
gl_POLYGON_OFFSET_FILL = 0x8037

gl_POLYGON_OFFSET_LINE :: GLenum
gl_POLYGON_OFFSET_LINE = 0x2A02

gl_POLYGON_OFFSET_POINT :: GLenum
gl_POLYGON_OFFSET_POINT = 0x2A01

gl_POLYGON_OFFSET_UNITS :: GLenum
gl_POLYGON_OFFSET_UNITS = 0x2A00

gl_POLYGON_SMOOTH :: GLenum
gl_POLYGON_SMOOTH = 0x0B41

gl_POLYGON_SMOOTH_HINT :: GLenum
gl_POLYGON_SMOOTH_HINT = 0x0C53

gl_POLYGON_STIPPLE :: GLenum
gl_POLYGON_STIPPLE = 0x0B42

gl_POLYGON_STIPPLE_BIT :: GLbitfield
gl_POLYGON_STIPPLE_BIT = 0x00000010

gl_POLYGON_TOKEN :: GLenum
gl_POLYGON_TOKEN = 0x0703

gl_POSITION :: GLenum
gl_POSITION = 0x1203

gl_POST_COLOR_MATRIX_ALPHA_BIAS :: GLenum
gl_POST_COLOR_MATRIX_ALPHA_BIAS = 0x80BB

gl_POST_COLOR_MATRIX_ALPHA_BIAS_SGI :: GLenum
gl_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = 0x80BB

gl_POST_COLOR_MATRIX_ALPHA_SCALE :: GLenum
gl_POST_COLOR_MATRIX_ALPHA_SCALE = 0x80B7

gl_POST_COLOR_MATRIX_ALPHA_SCALE_SGI :: GLenum
gl_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = 0x80B7

gl_POST_COLOR_MATRIX_BLUE_BIAS :: GLenum
gl_POST_COLOR_MATRIX_BLUE_BIAS = 0x80BA

gl_POST_COLOR_MATRIX_BLUE_BIAS_SGI :: GLenum
gl_POST_COLOR_MATRIX_BLUE_BIAS_SGI = 0x80BA

gl_POST_COLOR_MATRIX_BLUE_SCALE :: GLenum
gl_POST_COLOR_MATRIX_BLUE_SCALE = 0x80B6

gl_POST_COLOR_MATRIX_BLUE_SCALE_SGI :: GLenum
gl_POST_COLOR_MATRIX_BLUE_SCALE_SGI = 0x80B6

gl_POST_COLOR_MATRIX_COLOR_TABLE :: GLenum
gl_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D2

gl_POST_COLOR_MATRIX_COLOR_TABLE_SGI :: GLenum
gl_POST_COLOR_MATRIX_COLOR_TABLE_SGI = 0x80D2

gl_POST_COLOR_MATRIX_GREEN_BIAS :: GLenum
gl_POST_COLOR_MATRIX_GREEN_BIAS = 0x80B9

gl_POST_COLOR_MATRIX_GREEN_BIAS_SGI :: GLenum
gl_POST_COLOR_MATRIX_GREEN_BIAS_SGI = 0x80B9

gl_POST_COLOR_MATRIX_GREEN_SCALE :: GLenum
gl_POST_COLOR_MATRIX_GREEN_SCALE = 0x80B5

gl_POST_COLOR_MATRIX_GREEN_SCALE_SGI :: GLenum
gl_POST_COLOR_MATRIX_GREEN_SCALE_SGI = 0x80B5

gl_POST_COLOR_MATRIX_RED_BIAS :: GLenum
gl_POST_COLOR_MATRIX_RED_BIAS = 0x80B8

gl_POST_COLOR_MATRIX_RED_BIAS_SGI :: GLenum
gl_POST_COLOR_MATRIX_RED_BIAS_SGI = 0x80B8

gl_POST_COLOR_MATRIX_RED_SCALE :: GLenum
gl_POST_COLOR_MATRIX_RED_SCALE = 0x80B4

gl_POST_COLOR_MATRIX_RED_SCALE_SGI :: GLenum
gl_POST_COLOR_MATRIX_RED_SCALE_SGI = 0x80B4

gl_POST_CONVOLUTION_ALPHA_BIAS :: GLenum
gl_POST_CONVOLUTION_ALPHA_BIAS = 0x8023

gl_POST_CONVOLUTION_ALPHA_BIAS_EXT :: GLenum
gl_POST_CONVOLUTION_ALPHA_BIAS_EXT = 0x8023

gl_POST_CONVOLUTION_ALPHA_SCALE :: GLenum
gl_POST_CONVOLUTION_ALPHA_SCALE = 0x801F

gl_POST_CONVOLUTION_ALPHA_SCALE_EXT :: GLenum
gl_POST_CONVOLUTION_ALPHA_SCALE_EXT = 0x801F

gl_POST_CONVOLUTION_BLUE_BIAS :: GLenum
gl_POST_CONVOLUTION_BLUE_BIAS = 0x8022

gl_POST_CONVOLUTION_BLUE_BIAS_EXT :: GLenum
gl_POST_CONVOLUTION_BLUE_BIAS_EXT = 0x8022

gl_POST_CONVOLUTION_BLUE_SCALE :: GLenum
gl_POST_CONVOLUTION_BLUE_SCALE = 0x801E

gl_POST_CONVOLUTION_BLUE_SCALE_EXT :: GLenum
gl_POST_CONVOLUTION_BLUE_SCALE_EXT = 0x801E

gl_POST_CONVOLUTION_COLOR_TABLE :: GLenum
gl_POST_CONVOLUTION_COLOR_TABLE = 0x80D1

gl_POST_CONVOLUTION_COLOR_TABLE_SGI :: GLenum
gl_POST_CONVOLUTION_COLOR_TABLE_SGI = 0x80D1

gl_POST_CONVOLUTION_GREEN_BIAS :: GLenum
gl_POST_CONVOLUTION_GREEN_BIAS = 0x8021

gl_POST_CONVOLUTION_GREEN_BIAS_EXT :: GLenum
gl_POST_CONVOLUTION_GREEN_BIAS_EXT = 0x8021

gl_POST_CONVOLUTION_GREEN_SCALE :: GLenum
gl_POST_CONVOLUTION_GREEN_SCALE = 0x801D

gl_POST_CONVOLUTION_GREEN_SCALE_EXT :: GLenum
gl_POST_CONVOLUTION_GREEN_SCALE_EXT = 0x801D

gl_POST_CONVOLUTION_RED_BIAS :: GLenum
gl_POST_CONVOLUTION_RED_BIAS = 0x8020

gl_POST_CONVOLUTION_RED_BIAS_EXT :: GLenum
gl_POST_CONVOLUTION_RED_BIAS_EXT = 0x8020

gl_POST_CONVOLUTION_RED_SCALE :: GLenum
gl_POST_CONVOLUTION_RED_SCALE = 0x801C

gl_POST_CONVOLUTION_RED_SCALE_EXT :: GLenum
gl_POST_CONVOLUTION_RED_SCALE_EXT = 0x801C

gl_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP :: GLenum
gl_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = 0x8162

gl_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX :: GLenum
gl_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX = 0x817B

gl_POST_TEXTURE_FILTER_BIAS_SGIX :: GLenum
gl_POST_TEXTURE_FILTER_BIAS_SGIX = 0x8179

gl_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX :: GLenum
gl_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX = 0x817C

gl_POST_TEXTURE_FILTER_SCALE_SGIX :: GLenum
gl_POST_TEXTURE_FILTER_SCALE_SGIX = 0x817A

gl_PREFER_DOUBLEBUFFER_HINT_PGI :: GLenum
gl_PREFER_DOUBLEBUFFER_HINT_PGI = 0x1A1F8

gl_PRESENT_DURATION_NV :: GLenum
gl_PRESENT_DURATION_NV = 0x8E2B

gl_PRESENT_TIME_NV :: GLenum
gl_PRESENT_TIME_NV = 0x8E2A

gl_PRESERVE_ATI :: GLenum
gl_PRESERVE_ATI = 0x8762

gl_PREVIOUS :: GLenum
gl_PREVIOUS = 0x8578

gl_PREVIOUS_ARB :: GLenum
gl_PREVIOUS_ARB = 0x8578

gl_PREVIOUS_EXT :: GLenum
gl_PREVIOUS_EXT = 0x8578

gl_PREVIOUS_TEXTURE_INPUT_NV :: GLenum
gl_PREVIOUS_TEXTURE_INPUT_NV = 0x86E4

gl_PRIMARY_COLOR :: GLenum
gl_PRIMARY_COLOR = 0x8577

gl_PRIMARY_COLOR_ARB :: GLenum
gl_PRIMARY_COLOR_ARB = 0x8577

gl_PRIMARY_COLOR_EXT :: GLenum
gl_PRIMARY_COLOR_EXT = 0x8577

gl_PRIMARY_COLOR_NV :: GLenum
gl_PRIMARY_COLOR_NV = 0x852C

gl_PRIMITIVES_GENERATED :: GLenum
gl_PRIMITIVES_GENERATED = 0x8C87

gl_PRIMITIVES_GENERATED_EXT :: GLenum
gl_PRIMITIVES_GENERATED_EXT = 0x8C87

gl_PRIMITIVES_GENERATED_NV :: GLenum
gl_PRIMITIVES_GENERATED_NV = 0x8C87

gl_PRIMITIVES_GENERATED_OES :: GLenum
gl_PRIMITIVES_GENERATED_OES = 0x8C87

gl_PRIMITIVES_SUBMITTED_ARB :: GLenum
gl_PRIMITIVES_SUBMITTED_ARB = 0x82EF

gl_PRIMITIVE_BOUNDING_BOX_EXT :: GLenum
gl_PRIMITIVE_BOUNDING_BOX_EXT = 0x92BE

gl_PRIMITIVE_BOUNDING_BOX_OES :: GLenum
gl_PRIMITIVE_BOUNDING_BOX_OES = 0x92BE

gl_PRIMITIVE_ID_NV :: GLenum
gl_PRIMITIVE_ID_NV = 0x8C7C

gl_PRIMITIVE_RESTART :: GLenum
gl_PRIMITIVE_RESTART = 0x8F9D

gl_PRIMITIVE_RESTART_FIXED_INDEX :: GLenum
gl_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69

gl_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED :: GLenum
gl_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 0x8221

gl_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED_OES :: GLenum
gl_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED_OES = 0x8221

gl_PRIMITIVE_RESTART_INDEX :: GLenum
gl_PRIMITIVE_RESTART_INDEX = 0x8F9E

gl_PRIMITIVE_RESTART_INDEX_NV :: GLenum
gl_PRIMITIVE_RESTART_INDEX_NV = 0x8559

gl_PRIMITIVE_RESTART_NV :: GLenum
gl_PRIMITIVE_RESTART_NV = 0x8558

gl_PROGRAM :: GLenum
gl_PROGRAM = 0x82E2

gl_PROGRAMMABLE_SAMPLE_LOCATION_NV :: GLenum
gl_PROGRAMMABLE_SAMPLE_LOCATION_NV = 0x9341

gl_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV :: GLenum
gl_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV = 0x9340

gl_PROGRAM_ADDRESS_REGISTERS_ARB :: GLenum
gl_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B0

gl_PROGRAM_ALU_INSTRUCTIONS_ARB :: GLenum
gl_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x8805

gl_PROGRAM_ATTRIBS_ARB :: GLenum
gl_PROGRAM_ATTRIBS_ARB = 0x88AC

gl_PROGRAM_ATTRIB_COMPONENTS_NV :: GLenum
gl_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8906

gl_PROGRAM_BINARY_ANGLE :: GLenum
gl_PROGRAM_BINARY_ANGLE = 0x93A6

gl_PROGRAM_BINARY_FORMATS :: GLenum
gl_PROGRAM_BINARY_FORMATS = 0x87FF

gl_PROGRAM_BINARY_FORMATS_OES :: GLenum
gl_PROGRAM_BINARY_FORMATS_OES = 0x87FF

gl_PROGRAM_BINARY_LENGTH :: GLenum
gl_PROGRAM_BINARY_LENGTH = 0x8741

gl_PROGRAM_BINARY_LENGTH_OES :: GLenum
gl_PROGRAM_BINARY_LENGTH_OES = 0x8741

gl_PROGRAM_BINARY_RETRIEVABLE_HINT :: GLenum
gl_PROGRAM_BINARY_RETRIEVABLE_HINT = 0x8257

gl_PROGRAM_BINDING_ARB :: GLenum
gl_PROGRAM_BINDING_ARB = 0x8677

gl_PROGRAM_ERROR_POSITION_ARB :: GLenum
gl_PROGRAM_ERROR_POSITION_ARB = 0x864B

gl_PROGRAM_ERROR_POSITION_NV :: GLenum
gl_PROGRAM_ERROR_POSITION_NV = 0x864B

gl_PROGRAM_ERROR_STRING_ARB :: GLenum
gl_PROGRAM_ERROR_STRING_ARB = 0x8874

gl_PROGRAM_ERROR_STRING_NV :: GLenum
gl_PROGRAM_ERROR_STRING_NV = 0x8874

gl_PROGRAM_FORMAT_ARB :: GLenum
gl_PROGRAM_FORMAT_ARB = 0x8876

gl_PROGRAM_FORMAT_ASCII_ARB :: GLenum
gl_PROGRAM_FORMAT_ASCII_ARB = 0x8875

gl_PROGRAM_INPUT :: GLenum
gl_PROGRAM_INPUT = 0x92E3

gl_PROGRAM_INSTRUCTIONS_ARB :: GLenum
gl_PROGRAM_INSTRUCTIONS_ARB = 0x88A0

gl_PROGRAM_KHR :: GLenum
gl_PROGRAM_KHR = 0x82E2

gl_PROGRAM_LENGTH_ARB :: GLenum
gl_PROGRAM_LENGTH_ARB = 0x8627

gl_PROGRAM_LENGTH_NV :: GLenum
gl_PROGRAM_LENGTH_NV = 0x8627

gl_PROGRAM_MATRIX_EXT :: GLenum
gl_PROGRAM_MATRIX_EXT = 0x8E2D

gl_PROGRAM_MATRIX_STACK_DEPTH_EXT :: GLenum
gl_PROGRAM_MATRIX_STACK_DEPTH_EXT = 0x8E2F

gl_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB :: GLenum
gl_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B2

gl_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB :: GLenum
gl_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x8808

gl_PROGRAM_NATIVE_ATTRIBS_ARB :: GLenum
gl_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AE

gl_PROGRAM_NATIVE_INSTRUCTIONS_ARB :: GLenum
gl_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A2

gl_PROGRAM_NATIVE_PARAMETERS_ARB :: GLenum
gl_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AA

gl_PROGRAM_NATIVE_TEMPORARIES_ARB :: GLenum
gl_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A6

gl_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB :: GLenum
gl_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x880A

gl_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB :: GLenum
gl_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x8809

gl_PROGRAM_OBJECT_ARB :: GLenum
gl_PROGRAM_OBJECT_ARB = 0x8B40

gl_PROGRAM_OBJECT_EXT :: GLenum
gl_PROGRAM_OBJECT_EXT = 0x8B40

gl_PROGRAM_OUTPUT :: GLenum
gl_PROGRAM_OUTPUT = 0x92E4

gl_PROGRAM_PARAMETERS_ARB :: GLenum
gl_PROGRAM_PARAMETERS_ARB = 0x88A8

gl_PROGRAM_PARAMETER_NV :: GLenum
gl_PROGRAM_PARAMETER_NV = 0x8644

gl_PROGRAM_PIPELINE :: GLenum
gl_PROGRAM_PIPELINE = 0x82E4

gl_PROGRAM_PIPELINE_BINDING :: GLenum
gl_PROGRAM_PIPELINE_BINDING = 0x825A

gl_PROGRAM_PIPELINE_BINDING_EXT :: GLenum
gl_PROGRAM_PIPELINE_BINDING_EXT = 0x825A

gl_PROGRAM_PIPELINE_KHR :: GLenum
gl_PROGRAM_PIPELINE_KHR = 0x82E4

gl_PROGRAM_PIPELINE_OBJECT_EXT :: GLenum
gl_PROGRAM_PIPELINE_OBJECT_EXT = 0x8A4F

gl_PROGRAM_POINT_SIZE :: GLenum
gl_PROGRAM_POINT_SIZE = 0x8642

gl_PROGRAM_POINT_SIZE_ARB :: GLenum
gl_PROGRAM_POINT_SIZE_ARB = 0x8642

gl_PROGRAM_POINT_SIZE_EXT :: GLenum
gl_PROGRAM_POINT_SIZE_EXT = 0x8642

gl_PROGRAM_RESIDENT_NV :: GLenum
gl_PROGRAM_RESIDENT_NV = 0x8647

gl_PROGRAM_RESULT_COMPONENTS_NV :: GLenum
gl_PROGRAM_RESULT_COMPONENTS_NV = 0x8907

gl_PROGRAM_SEPARABLE :: GLenum
gl_PROGRAM_SEPARABLE = 0x8258

gl_PROGRAM_SEPARABLE_EXT :: GLenum
gl_PROGRAM_SEPARABLE_EXT = 0x8258

gl_PROGRAM_STRING_ARB :: GLenum
gl_PROGRAM_STRING_ARB = 0x8628

gl_PROGRAM_STRING_NV :: GLenum
gl_PROGRAM_STRING_NV = 0x8628

gl_PROGRAM_TARGET_NV :: GLenum
gl_PROGRAM_TARGET_NV = 0x8646

gl_PROGRAM_TEMPORARIES_ARB :: GLenum
gl_PROGRAM_TEMPORARIES_ARB = 0x88A4

gl_PROGRAM_TEX_INDIRECTIONS_ARB :: GLenum
gl_PROGRAM_TEX_INDIRECTIONS_ARB = 0x8807

gl_PROGRAM_TEX_INSTRUCTIONS_ARB :: GLenum
gl_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x8806

gl_PROGRAM_UNDER_NATIVE_LIMITS_ARB :: GLenum
gl_PROGRAM_UNDER_NATIVE_LIMITS_ARB = 0x88B6

gl_PROJECTION :: GLenum
gl_PROJECTION = 0x1701

gl_PROJECTION_MATRIX :: GLenum
gl_PROJECTION_MATRIX = 0x0BA7

gl_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES :: GLenum
gl_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES = 0x898E

gl_PROJECTION_STACK_DEPTH :: GLenum
gl_PROJECTION_STACK_DEPTH = 0x0BA4

gl_PROVOKING_VERTEX :: GLenum
gl_PROVOKING_VERTEX = 0x8E4F

gl_PROVOKING_VERTEX_EXT :: GLenum
gl_PROVOKING_VERTEX_EXT = 0x8E4F

gl_PROXY_COLOR_TABLE :: GLenum
gl_PROXY_COLOR_TABLE = 0x80D3

gl_PROXY_COLOR_TABLE_SGI :: GLenum
gl_PROXY_COLOR_TABLE_SGI = 0x80D3

gl_PROXY_HISTOGRAM :: GLenum
gl_PROXY_HISTOGRAM = 0x8025

gl_PROXY_HISTOGRAM_EXT :: GLenum
gl_PROXY_HISTOGRAM_EXT = 0x8025

gl_PROXY_POST_COLOR_MATRIX_COLOR_TABLE :: GLenum
gl_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5

gl_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI :: GLenum
gl_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = 0x80D5

gl_PROXY_POST_CONVOLUTION_COLOR_TABLE :: GLenum
gl_PROXY_POST_CONVOLUTION_COLOR_TABLE = 0x80D4

gl_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI :: GLenum
gl_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = 0x80D4

gl_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP :: GLenum
gl_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = 0x8163

gl_PROXY_TEXTURE_1D :: GLenum
gl_PROXY_TEXTURE_1D = 0x8063

gl_PROXY_TEXTURE_1D_ARRAY :: GLenum
gl_PROXY_TEXTURE_1D_ARRAY = 0x8C19

gl_PROXY_TEXTURE_1D_ARRAY_EXT :: GLenum
gl_PROXY_TEXTURE_1D_ARRAY_EXT = 0x8C19

gl_PROXY_TEXTURE_1D_EXT :: GLenum
gl_PROXY_TEXTURE_1D_EXT = 0x8063

gl_PROXY_TEXTURE_1D_STACK_MESAX :: GLenum
gl_PROXY_TEXTURE_1D_STACK_MESAX = 0x875B

gl_PROXY_TEXTURE_2D :: GLenum
gl_PROXY_TEXTURE_2D = 0x8064

gl_PROXY_TEXTURE_2D_ARRAY :: GLenum
gl_PROXY_TEXTURE_2D_ARRAY = 0x8C1B

gl_PROXY_TEXTURE_2D_ARRAY_EXT :: GLenum
gl_PROXY_TEXTURE_2D_ARRAY_EXT = 0x8C1B

gl_PROXY_TEXTURE_2D_EXT :: GLenum
gl_PROXY_TEXTURE_2D_EXT = 0x8064

gl_PROXY_TEXTURE_2D_MULTISAMPLE :: GLenum
gl_PROXY_TEXTURE_2D_MULTISAMPLE = 0x9101

gl_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY :: GLenum
gl_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9103

gl_PROXY_TEXTURE_2D_STACK_MESAX :: GLenum
gl_PROXY_TEXTURE_2D_STACK_MESAX = 0x875C

gl_PROXY_TEXTURE_3D :: GLenum
gl_PROXY_TEXTURE_3D = 0x8070

gl_PROXY_TEXTURE_3D_EXT :: GLenum
gl_PROXY_TEXTURE_3D_EXT = 0x8070

gl_PROXY_TEXTURE_4D_SGIS :: GLenum
gl_PROXY_TEXTURE_4D_SGIS = 0x8135

gl_PROXY_TEXTURE_COLOR_TABLE_SGI :: GLenum
gl_PROXY_TEXTURE_COLOR_TABLE_SGI = 0x80BD

gl_PROXY_TEXTURE_CUBE_MAP :: GLenum
gl_PROXY_TEXTURE_CUBE_MAP = 0x851B

gl_PROXY_TEXTURE_CUBE_MAP_ARB :: GLenum
gl_PROXY_TEXTURE_CUBE_MAP_ARB = 0x851B

gl_PROXY_TEXTURE_CUBE_MAP_ARRAY :: GLenum
gl_PROXY_TEXTURE_CUBE_MAP_ARRAY = 0x900B

gl_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB :: GLenum
gl_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x900B

gl_PROXY_TEXTURE_CUBE_MAP_EXT :: GLenum
gl_PROXY_TEXTURE_CUBE_MAP_EXT = 0x851B

gl_PROXY_TEXTURE_RECTANGLE :: GLenum
gl_PROXY_TEXTURE_RECTANGLE = 0x84F7

gl_PROXY_TEXTURE_RECTANGLE_ARB :: GLenum
gl_PROXY_TEXTURE_RECTANGLE_ARB = 0x84F7

gl_PROXY_TEXTURE_RECTANGLE_NV :: GLenum
gl_PROXY_TEXTURE_RECTANGLE_NV = 0x84F7

gl_PURGEABLE_APPLE :: GLenum
gl_PURGEABLE_APPLE = 0x8A1D

gl_Q :: GLenum
gl_Q = 0x2003

gl_QUADRATIC_ATTENUATION :: GLenum
gl_QUADRATIC_ATTENUATION = 0x1209

gl_QUADRATIC_CURVE_TO_NV :: GLubyte
gl_QUADRATIC_CURVE_TO_NV = 0x0A

gl_QUADS :: GLenum
gl_QUADS = 0x0007

gl_QUADS_EXT :: GLenum
gl_QUADS_EXT = 0x0007

gl_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION :: GLenum
gl_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 0x8E4C

gl_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT :: GLenum
gl_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT = 0x8E4C

gl_QUADS_OES :: GLenum
gl_QUADS_OES = 0x0007

gl_QUAD_ALPHA4_SGIS :: GLenum
gl_QUAD_ALPHA4_SGIS = 0x811E

gl_QUAD_ALPHA8_SGIS :: GLenum
gl_QUAD_ALPHA8_SGIS = 0x811F

gl_QUAD_INTENSITY4_SGIS :: GLenum
gl_QUAD_INTENSITY4_SGIS = 0x8122

gl_QUAD_INTENSITY8_SGIS :: GLenum
gl_QUAD_INTENSITY8_SGIS = 0x8123

gl_QUAD_LUMINANCE4_SGIS :: GLenum
gl_QUAD_LUMINANCE4_SGIS = 0x8120

gl_QUAD_LUMINANCE8_SGIS :: GLenum
gl_QUAD_LUMINANCE8_SGIS = 0x8121

gl_QUAD_MESH_SUN :: GLenum
gl_QUAD_MESH_SUN = 0x8614

gl_QUAD_STRIP :: GLenum
gl_QUAD_STRIP = 0x0008

gl_QUAD_TEXTURE_SELECT_SGIS :: GLenum
gl_QUAD_TEXTURE_SELECT_SGIS = 0x8125

gl_QUARTER_BIT_ATI :: GLbitfield
gl_QUARTER_BIT_ATI = 0x00000010

gl_QUERY :: GLenum
gl_QUERY = 0x82E3

gl_QUERY_ALL_EVENT_BITS_AMD :: GLuint
gl_QUERY_ALL_EVENT_BITS_AMD = 0xFFFFFFFF

gl_QUERY_BUFFER :: GLenum
gl_QUERY_BUFFER = 0x9192

gl_QUERY_BUFFER_AMD :: GLenum
gl_QUERY_BUFFER_AMD = 0x9192

gl_QUERY_BUFFER_BARRIER_BIT :: GLbitfield
gl_QUERY_BUFFER_BARRIER_BIT = 0x00008000

gl_QUERY_BUFFER_BINDING :: GLenum
gl_QUERY_BUFFER_BINDING = 0x9193

gl_QUERY_BUFFER_BINDING_AMD :: GLenum
gl_QUERY_BUFFER_BINDING_AMD = 0x9193

gl_QUERY_BY_REGION_NO_WAIT :: GLenum
gl_QUERY_BY_REGION_NO_WAIT = 0x8E16

gl_QUERY_BY_REGION_NO_WAIT_INVERTED :: GLenum
gl_QUERY_BY_REGION_NO_WAIT_INVERTED = 0x8E1A

gl_QUERY_BY_REGION_NO_WAIT_NV :: GLenum
gl_QUERY_BY_REGION_NO_WAIT_NV = 0x8E16

gl_QUERY_BY_REGION_WAIT :: GLenum
gl_QUERY_BY_REGION_WAIT = 0x8E15

gl_QUERY_BY_REGION_WAIT_INVERTED :: GLenum
gl_QUERY_BY_REGION_WAIT_INVERTED = 0x8E19

gl_QUERY_BY_REGION_WAIT_NV :: GLenum
gl_QUERY_BY_REGION_WAIT_NV = 0x8E15

gl_QUERY_COUNTER_BITS :: GLenum
gl_QUERY_COUNTER_BITS = 0x8864

gl_QUERY_COUNTER_BITS_ARB :: GLenum
gl_QUERY_COUNTER_BITS_ARB = 0x8864

gl_QUERY_COUNTER_BITS_EXT :: GLenum
gl_QUERY_COUNTER_BITS_EXT = 0x8864

gl_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD :: GLuint
gl_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD = 0x00000008

gl_QUERY_DEPTH_FAIL_EVENT_BIT_AMD :: GLuint
gl_QUERY_DEPTH_FAIL_EVENT_BIT_AMD = 0x00000002

gl_QUERY_DEPTH_PASS_EVENT_BIT_AMD :: GLuint
gl_QUERY_DEPTH_PASS_EVENT_BIT_AMD = 0x00000001

gl_QUERY_KHR :: GLenum
gl_QUERY_KHR = 0x82E3

gl_QUERY_NO_WAIT :: GLenum
gl_QUERY_NO_WAIT = 0x8E14

gl_QUERY_NO_WAIT_INVERTED :: GLenum
gl_QUERY_NO_WAIT_INVERTED = 0x8E18

gl_QUERY_NO_WAIT_NV :: GLenum
gl_QUERY_NO_WAIT_NV = 0x8E14

gl_QUERY_OBJECT_AMD :: GLenum
gl_QUERY_OBJECT_AMD = 0x9153

gl_QUERY_OBJECT_EXT :: GLenum
gl_QUERY_OBJECT_EXT = 0x9153

gl_QUERY_RESULT :: GLenum
gl_QUERY_RESULT = 0x8866

gl_QUERY_RESULT_ARB :: GLenum
gl_QUERY_RESULT_ARB = 0x8866

gl_QUERY_RESULT_AVAILABLE :: GLenum
gl_QUERY_RESULT_AVAILABLE = 0x8867

gl_QUERY_RESULT_AVAILABLE_ARB :: GLenum
gl_QUERY_RESULT_AVAILABLE_ARB = 0x8867

gl_QUERY_RESULT_AVAILABLE_EXT :: GLenum
gl_QUERY_RESULT_AVAILABLE_EXT = 0x8867

gl_QUERY_RESULT_EXT :: GLenum
gl_QUERY_RESULT_EXT = 0x8866

gl_QUERY_RESULT_NO_WAIT :: GLenum
gl_QUERY_RESULT_NO_WAIT = 0x9194

gl_QUERY_RESULT_NO_WAIT_AMD :: GLenum
gl_QUERY_RESULT_NO_WAIT_AMD = 0x9194

gl_QUERY_STENCIL_FAIL_EVENT_BIT_AMD :: GLuint
gl_QUERY_STENCIL_FAIL_EVENT_BIT_AMD = 0x00000004

gl_QUERY_TARGET :: GLenum
gl_QUERY_TARGET = 0x82EA

gl_QUERY_WAIT :: GLenum
gl_QUERY_WAIT = 0x8E13

gl_QUERY_WAIT_INVERTED :: GLenum
gl_QUERY_WAIT_INVERTED = 0x8E17

gl_QUERY_WAIT_NV :: GLenum
gl_QUERY_WAIT_NV = 0x8E13

gl_R :: GLenum
gl_R = 0x2002

gl_R11F_G11F_B10F :: GLenum
gl_R11F_G11F_B10F = 0x8C3A

gl_R11F_G11F_B10F_APPLE :: GLenum
gl_R11F_G11F_B10F_APPLE = 0x8C3A

gl_R11F_G11F_B10F_EXT :: GLenum
gl_R11F_G11F_B10F_EXT = 0x8C3A

gl_R16 :: GLenum
gl_R16 = 0x822A

gl_R16F :: GLenum
gl_R16F = 0x822D

gl_R16F_EXT :: GLenum
gl_R16F_EXT = 0x822D

gl_R16I :: GLenum
gl_R16I = 0x8233

gl_R16UI :: GLenum
gl_R16UI = 0x8234

gl_R16_EXT :: GLenum
gl_R16_EXT = 0x822A

gl_R16_SNORM :: GLenum
gl_R16_SNORM = 0x8F98

gl_R16_SNORM_EXT :: GLenum
gl_R16_SNORM_EXT = 0x8F98

gl_R1UI_C3F_V3F_SUN :: GLenum
gl_R1UI_C3F_V3F_SUN = 0x85C6

gl_R1UI_C4F_N3F_V3F_SUN :: GLenum
gl_R1UI_C4F_N3F_V3F_SUN = 0x85C8

gl_R1UI_C4UB_V3F_SUN :: GLenum
gl_R1UI_C4UB_V3F_SUN = 0x85C5

gl_R1UI_N3F_V3F_SUN :: GLenum
gl_R1UI_N3F_V3F_SUN = 0x85C7

gl_R1UI_T2F_C4F_N3F_V3F_SUN :: GLenum
gl_R1UI_T2F_C4F_N3F_V3F_SUN = 0x85CB

gl_R1UI_T2F_N3F_V3F_SUN :: GLenum
gl_R1UI_T2F_N3F_V3F_SUN = 0x85CA

gl_R1UI_T2F_V3F_SUN :: GLenum
gl_R1UI_T2F_V3F_SUN = 0x85C9

gl_R1UI_V3F_SUN :: GLenum
gl_R1UI_V3F_SUN = 0x85C4

gl_R32F :: GLenum
gl_R32F = 0x822E

gl_R32F_EXT :: GLenum
gl_R32F_EXT = 0x822E

gl_R32I :: GLenum
gl_R32I = 0x8235

gl_R32UI :: GLenum
gl_R32UI = 0x8236

gl_R3_G3_B2 :: GLenum
gl_R3_G3_B2 = 0x2A10

gl_R8 :: GLenum
gl_R8 = 0x8229

gl_R8I :: GLenum
gl_R8I = 0x8231

gl_R8UI :: GLenum
gl_R8UI = 0x8232

gl_R8_EXT :: GLenum
gl_R8_EXT = 0x8229

gl_R8_SNORM :: GLenum
gl_R8_SNORM = 0x8F94

gl_RASTERIZER_DISCARD :: GLenum
gl_RASTERIZER_DISCARD = 0x8C89

gl_RASTERIZER_DISCARD_EXT :: GLenum
gl_RASTERIZER_DISCARD_EXT = 0x8C89

gl_RASTERIZER_DISCARD_NV :: GLenum
gl_RASTERIZER_DISCARD_NV = 0x8C89

gl_RASTER_FIXED_SAMPLE_LOCATIONS_EXT :: GLenum
gl_RASTER_FIXED_SAMPLE_LOCATIONS_EXT = 0x932A

gl_RASTER_MULTISAMPLE_EXT :: GLenum
gl_RASTER_MULTISAMPLE_EXT = 0x9327

gl_RASTER_POSITION_UNCLIPPED_IBM :: GLenum
gl_RASTER_POSITION_UNCLIPPED_IBM = 0x19262

gl_RASTER_SAMPLES_EXT :: GLenum
gl_RASTER_SAMPLES_EXT = 0x9328

gl_READ_BUFFER :: GLenum
gl_READ_BUFFER = 0x0C02

gl_READ_BUFFER_EXT :: GLenum
gl_READ_BUFFER_EXT = 0x0C02

gl_READ_BUFFER_NV :: GLenum
gl_READ_BUFFER_NV = 0x0C02

gl_READ_FRAMEBUFFER :: GLenum
gl_READ_FRAMEBUFFER = 0x8CA8

gl_READ_FRAMEBUFFER_ANGLE :: GLenum
gl_READ_FRAMEBUFFER_ANGLE = 0x8CA8

gl_READ_FRAMEBUFFER_APPLE :: GLenum
gl_READ_FRAMEBUFFER_APPLE = 0x8CA8

gl_READ_FRAMEBUFFER_BINDING :: GLenum
gl_READ_FRAMEBUFFER_BINDING = 0x8CAA

gl_READ_FRAMEBUFFER_BINDING_ANGLE :: GLenum
gl_READ_FRAMEBUFFER_BINDING_ANGLE = 0x8CAA

gl_READ_FRAMEBUFFER_BINDING_APPLE :: GLenum
gl_READ_FRAMEBUFFER_BINDING_APPLE = 0x8CAA

gl_READ_FRAMEBUFFER_BINDING_EXT :: GLenum
gl_READ_FRAMEBUFFER_BINDING_EXT = 0x8CAA

gl_READ_FRAMEBUFFER_BINDING_NV :: GLenum
gl_READ_FRAMEBUFFER_BINDING_NV = 0x8CAA

gl_READ_FRAMEBUFFER_EXT :: GLenum
gl_READ_FRAMEBUFFER_EXT = 0x8CA8

gl_READ_FRAMEBUFFER_NV :: GLenum
gl_READ_FRAMEBUFFER_NV = 0x8CA8

gl_READ_ONLY :: GLenum
gl_READ_ONLY = 0x88B8

gl_READ_ONLY_ARB :: GLenum
gl_READ_ONLY_ARB = 0x88B8

gl_READ_PIXELS :: GLenum
gl_READ_PIXELS = 0x828C

gl_READ_PIXELS_FORMAT :: GLenum
gl_READ_PIXELS_FORMAT = 0x828D

gl_READ_PIXELS_TYPE :: GLenum
gl_READ_PIXELS_TYPE = 0x828E

gl_READ_PIXEL_DATA_RANGE_LENGTH_NV :: GLenum
gl_READ_PIXEL_DATA_RANGE_LENGTH_NV = 0x887B

gl_READ_PIXEL_DATA_RANGE_NV :: GLenum
gl_READ_PIXEL_DATA_RANGE_NV = 0x8879

gl_READ_PIXEL_DATA_RANGE_POINTER_NV :: GLenum
gl_READ_PIXEL_DATA_RANGE_POINTER_NV = 0x887D

gl_READ_WRITE :: GLenum
gl_READ_WRITE = 0x88BA

gl_READ_WRITE_ARB :: GLenum
gl_READ_WRITE_ARB = 0x88BA

gl_RECIP_ADD_SIGNED_ALPHA_IMG :: GLenum
gl_RECIP_ADD_SIGNED_ALPHA_IMG = 0x8C05

gl_RECLAIM_MEMORY_HINT_PGI :: GLenum
gl_RECLAIM_MEMORY_HINT_PGI = 0x1A1FE

gl_RECT_NV :: GLubyte
gl_RECT_NV = 0xF6

gl_RED :: GLenum
gl_RED = 0x1903

gl_REDUCE :: GLenum
gl_REDUCE = 0x8016

gl_REDUCE_EXT :: GLenum
gl_REDUCE_EXT = 0x8016

gl_RED_BIAS :: GLenum
gl_RED_BIAS = 0x0D15

gl_RED_BITS :: GLenum
gl_RED_BITS = 0x0D52

gl_RED_BIT_ATI :: GLbitfield
gl_RED_BIT_ATI = 0x00000001

gl_RED_EXT :: GLenum
gl_RED_EXT = 0x1903

gl_RED_INTEGER :: GLenum
gl_RED_INTEGER = 0x8D94

gl_RED_INTEGER_EXT :: GLenum
gl_RED_INTEGER_EXT = 0x8D94

gl_RED_MAX_CLAMP_INGR :: GLenum
gl_RED_MAX_CLAMP_INGR = 0x8564

gl_RED_MIN_CLAMP_INGR :: GLenum
gl_RED_MIN_CLAMP_INGR = 0x8560

gl_RED_NV :: GLenum
gl_RED_NV = 0x1903

gl_RED_SCALE :: GLenum
gl_RED_SCALE = 0x0D14

gl_RED_SNORM :: GLenum
gl_RED_SNORM = 0x8F90

gl_REFERENCED_BY_COMPUTE_SHADER :: GLenum
gl_REFERENCED_BY_COMPUTE_SHADER = 0x930B

gl_REFERENCED_BY_FRAGMENT_SHADER :: GLenum
gl_REFERENCED_BY_FRAGMENT_SHADER = 0x930A

gl_REFERENCED_BY_GEOMETRY_SHADER :: GLenum
gl_REFERENCED_BY_GEOMETRY_SHADER = 0x9309

gl_REFERENCED_BY_GEOMETRY_SHADER_EXT :: GLenum
gl_REFERENCED_BY_GEOMETRY_SHADER_EXT = 0x9309

gl_REFERENCED_BY_GEOMETRY_SHADER_OES :: GLenum
gl_REFERENCED_BY_GEOMETRY_SHADER_OES = 0x9309

gl_REFERENCED_BY_TESS_CONTROL_SHADER :: GLenum
gl_REFERENCED_BY_TESS_CONTROL_SHADER = 0x9307

gl_REFERENCED_BY_TESS_CONTROL_SHADER_EXT :: GLenum
gl_REFERENCED_BY_TESS_CONTROL_SHADER_EXT = 0x9307

gl_REFERENCED_BY_TESS_CONTROL_SHADER_OES :: GLenum
gl_REFERENCED_BY_TESS_CONTROL_SHADER_OES = 0x9307

gl_REFERENCED_BY_TESS_EVALUATION_SHADER :: GLenum
gl_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x9308

gl_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT :: GLenum
gl_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT = 0x9308

gl_REFERENCED_BY_TESS_EVALUATION_SHADER_OES :: GLenum
gl_REFERENCED_BY_TESS_EVALUATION_SHADER_OES = 0x9308

gl_REFERENCED_BY_VERTEX_SHADER :: GLenum
gl_REFERENCED_BY_VERTEX_SHADER = 0x9306

gl_REFERENCE_PLANE_EQUATION_SGIX :: GLenum
gl_REFERENCE_PLANE_EQUATION_SGIX = 0x817E

gl_REFERENCE_PLANE_SGIX :: GLenum
gl_REFERENCE_PLANE_SGIX = 0x817D

gl_REFLECTION_MAP :: GLenum
gl_REFLECTION_MAP = 0x8512

gl_REFLECTION_MAP_ARB :: GLenum
gl_REFLECTION_MAP_ARB = 0x8512

gl_REFLECTION_MAP_EXT :: GLenum
gl_REFLECTION_MAP_EXT = 0x8512

gl_REFLECTION_MAP_NV :: GLenum
gl_REFLECTION_MAP_NV = 0x8512

gl_REFLECTION_MAP_OES :: GLenum
gl_REFLECTION_MAP_OES = 0x8512

gl_REGISTER_COMBINERS_NV :: GLenum
gl_REGISTER_COMBINERS_NV = 0x8522

gl_REG_0_ATI :: GLenum
gl_REG_0_ATI = 0x8921

gl_REG_10_ATI :: GLenum
gl_REG_10_ATI = 0x892B

gl_REG_11_ATI :: GLenum
gl_REG_11_ATI = 0x892C

gl_REG_12_ATI :: GLenum
gl_REG_12_ATI = 0x892D

gl_REG_13_ATI :: GLenum
gl_REG_13_ATI = 0x892E

gl_REG_14_ATI :: GLenum
gl_REG_14_ATI = 0x892F

gl_REG_15_ATI :: GLenum
gl_REG_15_ATI = 0x8930

gl_REG_16_ATI :: GLenum
gl_REG_16_ATI = 0x8931

gl_REG_17_ATI :: GLenum
gl_REG_17_ATI = 0x8932

gl_REG_18_ATI :: GLenum
gl_REG_18_ATI = 0x8933

gl_REG_19_ATI :: GLenum
gl_REG_19_ATI = 0x8934

gl_REG_1_ATI :: GLenum
gl_REG_1_ATI = 0x8922

gl_REG_20_ATI :: GLenum
gl_REG_20_ATI = 0x8935

gl_REG_21_ATI :: GLenum
gl_REG_21_ATI = 0x8936

gl_REG_22_ATI :: GLenum
gl_REG_22_ATI = 0x8937

gl_REG_23_ATI :: GLenum
gl_REG_23_ATI = 0x8938

gl_REG_24_ATI :: GLenum
gl_REG_24_ATI = 0x8939

gl_REG_25_ATI :: GLenum
gl_REG_25_ATI = 0x893A

gl_REG_26_ATI :: GLenum
gl_REG_26_ATI = 0x893B

gl_REG_27_ATI :: GLenum
gl_REG_27_ATI = 0x893C

gl_REG_28_ATI :: GLenum
gl_REG_28_ATI = 0x893D

gl_REG_29_ATI :: GLenum
gl_REG_29_ATI = 0x893E

gl_REG_2_ATI :: GLenum
gl_REG_2_ATI = 0x8923

gl_REG_30_ATI :: GLenum
gl_REG_30_ATI = 0x893F

gl_REG_31_ATI :: GLenum
gl_REG_31_ATI = 0x8940

gl_REG_3_ATI :: GLenum
gl_REG_3_ATI = 0x8924

gl_REG_4_ATI :: GLenum
gl_REG_4_ATI = 0x8925

gl_REG_5_ATI :: GLenum
gl_REG_5_ATI = 0x8926

gl_REG_6_ATI :: GLenum
gl_REG_6_ATI = 0x8927

gl_REG_7_ATI :: GLenum
gl_REG_7_ATI = 0x8928

gl_REG_8_ATI :: GLenum
gl_REG_8_ATI = 0x8929

gl_REG_9_ATI :: GLenum
gl_REG_9_ATI = 0x892A

gl_RELATIVE_ARC_TO_NV :: GLubyte
gl_RELATIVE_ARC_TO_NV = 0xFF

gl_RELATIVE_CONIC_CURVE_TO_NV :: GLubyte
gl_RELATIVE_CONIC_CURVE_TO_NV = 0x1B

gl_RELATIVE_CUBIC_CURVE_TO_NV :: GLubyte
gl_RELATIVE_CUBIC_CURVE_TO_NV = 0x0D

gl_RELATIVE_HORIZONTAL_LINE_TO_NV :: GLubyte
gl_RELATIVE_HORIZONTAL_LINE_TO_NV = 0x07

gl_RELATIVE_LARGE_CCW_ARC_TO_NV :: GLubyte
gl_RELATIVE_LARGE_CCW_ARC_TO_NV = 0x17

gl_RELATIVE_LARGE_CW_ARC_TO_NV :: GLubyte
gl_RELATIVE_LARGE_CW_ARC_TO_NV = 0x19

gl_RELATIVE_LINE_TO_NV :: GLubyte
gl_RELATIVE_LINE_TO_NV = 0x05

gl_RELATIVE_MOVE_TO_NV :: GLubyte
gl_RELATIVE_MOVE_TO_NV = 0x03

gl_RELATIVE_QUADRATIC_CURVE_TO_NV :: GLubyte
gl_RELATIVE_QUADRATIC_CURVE_TO_NV = 0x0B

gl_RELATIVE_RECT_NV :: GLubyte
gl_RELATIVE_RECT_NV = 0xF7

gl_RELATIVE_ROUNDED_RECT2_NV :: GLubyte
gl_RELATIVE_ROUNDED_RECT2_NV = 0xEB

gl_RELATIVE_ROUNDED_RECT4_NV :: GLubyte
gl_RELATIVE_ROUNDED_RECT4_NV = 0xED

gl_RELATIVE_ROUNDED_RECT8_NV :: GLubyte
gl_RELATIVE_ROUNDED_RECT8_NV = 0xEF

gl_RELATIVE_ROUNDED_RECT_NV :: GLubyte
gl_RELATIVE_ROUNDED_RECT_NV = 0xE9

gl_RELATIVE_SMALL_CCW_ARC_TO_NV :: GLubyte
gl_RELATIVE_SMALL_CCW_ARC_TO_NV = 0x13

gl_RELATIVE_SMALL_CW_ARC_TO_NV :: GLubyte
gl_RELATIVE_SMALL_CW_ARC_TO_NV = 0x15

gl_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV :: GLubyte
gl_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = 0x11

gl_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV :: GLubyte
gl_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0F

gl_RELATIVE_VERTICAL_LINE_TO_NV :: GLubyte
gl_RELATIVE_VERTICAL_LINE_TO_NV = 0x09

gl_RELEASED_APPLE :: GLenum
gl_RELEASED_APPLE = 0x8A19

gl_RENDER :: GLenum
gl_RENDER = 0x1C00

gl_RENDERBUFFER :: GLenum
gl_RENDERBUFFER = 0x8D41

gl_RENDERBUFFER_ALPHA_SIZE :: GLenum
gl_RENDERBUFFER_ALPHA_SIZE = 0x8D53

gl_RENDERBUFFER_ALPHA_SIZE_EXT :: GLenum
gl_RENDERBUFFER_ALPHA_SIZE_EXT = 0x8D53

gl_RENDERBUFFER_ALPHA_SIZE_OES :: GLenum
gl_RENDERBUFFER_ALPHA_SIZE_OES = 0x8D53

gl_RENDERBUFFER_BINDING :: GLenum
gl_RENDERBUFFER_BINDING = 0x8CA7

gl_RENDERBUFFER_BINDING_ANGLE :: GLenum
gl_RENDERBUFFER_BINDING_ANGLE = 0x8CA7

gl_RENDERBUFFER_BINDING_EXT :: GLenum
gl_RENDERBUFFER_BINDING_EXT = 0x8CA7

gl_RENDERBUFFER_BINDING_OES :: GLenum
gl_RENDERBUFFER_BINDING_OES = 0x8CA7

gl_RENDERBUFFER_BLUE_SIZE :: GLenum
gl_RENDERBUFFER_BLUE_SIZE = 0x8D52

gl_RENDERBUFFER_BLUE_SIZE_EXT :: GLenum
gl_RENDERBUFFER_BLUE_SIZE_EXT = 0x8D52

gl_RENDERBUFFER_BLUE_SIZE_OES :: GLenum
gl_RENDERBUFFER_BLUE_SIZE_OES = 0x8D52

gl_RENDERBUFFER_COLOR_SAMPLES_NV :: GLenum
gl_RENDERBUFFER_COLOR_SAMPLES_NV = 0x8E10

gl_RENDERBUFFER_COVERAGE_SAMPLES_NV :: GLenum
gl_RENDERBUFFER_COVERAGE_SAMPLES_NV = 0x8CAB

gl_RENDERBUFFER_DEPTH_SIZE :: GLenum
gl_RENDERBUFFER_DEPTH_SIZE = 0x8D54

gl_RENDERBUFFER_DEPTH_SIZE_EXT :: GLenum
gl_RENDERBUFFER_DEPTH_SIZE_EXT = 0x8D54

gl_RENDERBUFFER_DEPTH_SIZE_OES :: GLenum
gl_RENDERBUFFER_DEPTH_SIZE_OES = 0x8D54

gl_RENDERBUFFER_EXT :: GLenum
gl_RENDERBUFFER_EXT = 0x8D41

gl_RENDERBUFFER_FREE_MEMORY_ATI :: GLenum
gl_RENDERBUFFER_FREE_MEMORY_ATI = 0x87FD

gl_RENDERBUFFER_GREEN_SIZE :: GLenum
gl_RENDERBUFFER_GREEN_SIZE = 0x8D51

gl_RENDERBUFFER_GREEN_SIZE_EXT :: GLenum
gl_RENDERBUFFER_GREEN_SIZE_EXT = 0x8D51

gl_RENDERBUFFER_GREEN_SIZE_OES :: GLenum
gl_RENDERBUFFER_GREEN_SIZE_OES = 0x8D51

gl_RENDERBUFFER_HEIGHT :: GLenum
gl_RENDERBUFFER_HEIGHT = 0x8D43

gl_RENDERBUFFER_HEIGHT_EXT :: GLenum
gl_RENDERBUFFER_HEIGHT_EXT = 0x8D43

gl_RENDERBUFFER_HEIGHT_OES :: GLenum
gl_RENDERBUFFER_HEIGHT_OES = 0x8D43

gl_RENDERBUFFER_INTERNAL_FORMAT :: GLenum
gl_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44

gl_RENDERBUFFER_INTERNAL_FORMAT_EXT :: GLenum
gl_RENDERBUFFER_INTERNAL_FORMAT_EXT = 0x8D44

gl_RENDERBUFFER_INTERNAL_FORMAT_OES :: GLenum
gl_RENDERBUFFER_INTERNAL_FORMAT_OES = 0x8D44

gl_RENDERBUFFER_OES :: GLenum
gl_RENDERBUFFER_OES = 0x8D41

gl_RENDERBUFFER_RED_SIZE :: GLenum
gl_RENDERBUFFER_RED_SIZE = 0x8D50

gl_RENDERBUFFER_RED_SIZE_EXT :: GLenum
gl_RENDERBUFFER_RED_SIZE_EXT = 0x8D50

gl_RENDERBUFFER_RED_SIZE_OES :: GLenum
gl_RENDERBUFFER_RED_SIZE_OES = 0x8D50

gl_RENDERBUFFER_SAMPLES :: GLenum
gl_RENDERBUFFER_SAMPLES = 0x8CAB

gl_RENDERBUFFER_SAMPLES_ANGLE :: GLenum
gl_RENDERBUFFER_SAMPLES_ANGLE = 0x8CAB

gl_RENDERBUFFER_SAMPLES_APPLE :: GLenum
gl_RENDERBUFFER_SAMPLES_APPLE = 0x8CAB

gl_RENDERBUFFER_SAMPLES_EXT :: GLenum
gl_RENDERBUFFER_SAMPLES_EXT = 0x8CAB

gl_RENDERBUFFER_SAMPLES_IMG :: GLenum
gl_RENDERBUFFER_SAMPLES_IMG = 0x9133

gl_RENDERBUFFER_SAMPLES_NV :: GLenum
gl_RENDERBUFFER_SAMPLES_NV = 0x8CAB

gl_RENDERBUFFER_STENCIL_SIZE :: GLenum
gl_RENDERBUFFER_STENCIL_SIZE = 0x8D55

gl_RENDERBUFFER_STENCIL_SIZE_EXT :: GLenum
gl_RENDERBUFFER_STENCIL_SIZE_EXT = 0x8D55

gl_RENDERBUFFER_STENCIL_SIZE_OES :: GLenum
gl_RENDERBUFFER_STENCIL_SIZE_OES = 0x8D55

gl_RENDERBUFFER_WIDTH :: GLenum
gl_RENDERBUFFER_WIDTH = 0x8D42

gl_RENDERBUFFER_WIDTH_EXT :: GLenum
gl_RENDERBUFFER_WIDTH_EXT = 0x8D42

gl_RENDERBUFFER_WIDTH_OES :: GLenum
gl_RENDERBUFFER_WIDTH_OES = 0x8D42

gl_RENDERER :: GLenum
gl_RENDERER = 0x1F01

gl_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM :: GLenum
gl_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM = 0x8FB3

gl_RENDER_MODE :: GLenum
gl_RENDER_MODE = 0x0C40

gl_REPEAT :: GLenum
gl_REPEAT = 0x2901

gl_REPLACE :: GLenum
gl_REPLACE = 0x1E01

gl_REPLACEMENT_CODE_ARRAY_POINTER_SUN :: GLenum
gl_REPLACEMENT_CODE_ARRAY_POINTER_SUN = 0x85C3

gl_REPLACEMENT_CODE_ARRAY_STRIDE_SUN :: GLenum
gl_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = 0x85C2

gl_REPLACEMENT_CODE_ARRAY_SUN :: GLenum
gl_REPLACEMENT_CODE_ARRAY_SUN = 0x85C0

gl_REPLACEMENT_CODE_ARRAY_TYPE_SUN :: GLenum
gl_REPLACEMENT_CODE_ARRAY_TYPE_SUN = 0x85C1

gl_REPLACEMENT_CODE_SUN :: GLenum
gl_REPLACEMENT_CODE_SUN = 0x81D8

gl_REPLACE_EXT :: GLenum
gl_REPLACE_EXT = 0x8062

gl_REPLACE_MIDDLE_SUN :: GLenum
gl_REPLACE_MIDDLE_SUN = 0x0002

gl_REPLACE_OLDEST_SUN :: GLenum
gl_REPLACE_OLDEST_SUN = 0x0003

gl_REPLACE_VALUE_AMD :: GLenum
gl_REPLACE_VALUE_AMD = 0x874B

gl_REPLICATE_BORDER :: GLenum
gl_REPLICATE_BORDER = 0x8153

gl_REPLICATE_BORDER_HP :: GLenum
gl_REPLICATE_BORDER_HP = 0x8153

gl_REQUIRED_TEXTURE_IMAGE_UNITS_OES :: GLenum
gl_REQUIRED_TEXTURE_IMAGE_UNITS_OES = 0x8D68

gl_RESAMPLE_AVERAGE_OML :: GLenum
gl_RESAMPLE_AVERAGE_OML = 0x8988

gl_RESAMPLE_DECIMATE_OML :: GLenum
gl_RESAMPLE_DECIMATE_OML = 0x8989

gl_RESAMPLE_DECIMATE_SGIX :: GLenum
gl_RESAMPLE_DECIMATE_SGIX = 0x8430

gl_RESAMPLE_REPLICATE_OML :: GLenum
gl_RESAMPLE_REPLICATE_OML = 0x8986

gl_RESAMPLE_REPLICATE_SGIX :: GLenum
gl_RESAMPLE_REPLICATE_SGIX = 0x8433

gl_RESAMPLE_ZERO_FILL_OML :: GLenum
gl_RESAMPLE_ZERO_FILL_OML = 0x8987

gl_RESAMPLE_ZERO_FILL_SGIX :: GLenum
gl_RESAMPLE_ZERO_FILL_SGIX = 0x8434

gl_RESCALE_NORMAL :: GLenum
gl_RESCALE_NORMAL = 0x803A

gl_RESCALE_NORMAL_EXT :: GLenum
gl_RESCALE_NORMAL_EXT = 0x803A

gl_RESET_NOTIFICATION_STRATEGY :: GLenum
gl_RESET_NOTIFICATION_STRATEGY = 0x8256

gl_RESET_NOTIFICATION_STRATEGY_ARB :: GLenum
gl_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256

gl_RESET_NOTIFICATION_STRATEGY_EXT :: GLenum
gl_RESET_NOTIFICATION_STRATEGY_EXT = 0x8256

gl_RESET_NOTIFICATION_STRATEGY_KHR :: GLenum
gl_RESET_NOTIFICATION_STRATEGY_KHR = 0x8256

gl_RESTART_PATH_NV :: GLubyte
gl_RESTART_PATH_NV = 0xF0

gl_RESTART_SUN :: GLenum
gl_RESTART_SUN = 0x0001

gl_RETAINED_APPLE :: GLenum
gl_RETAINED_APPLE = 0x8A1B

gl_RETURN :: GLenum
gl_RETURN = 0x0102

gl_RG :: GLenum
gl_RG = 0x8227

gl_RG16 :: GLenum
gl_RG16 = 0x822C

gl_RG16F :: GLenum
gl_RG16F = 0x822F

gl_RG16F_EXT :: GLenum
gl_RG16F_EXT = 0x822F

gl_RG16I :: GLenum
gl_RG16I = 0x8239

gl_RG16UI :: GLenum
gl_RG16UI = 0x823A

gl_RG16_EXT :: GLenum
gl_RG16_EXT = 0x822C

gl_RG16_SNORM :: GLenum
gl_RG16_SNORM = 0x8F99

gl_RG16_SNORM_EXT :: GLenum
gl_RG16_SNORM_EXT = 0x8F99

gl_RG32F :: GLenum
gl_RG32F = 0x8230

gl_RG32F_EXT :: GLenum
gl_RG32F_EXT = 0x8230

gl_RG32I :: GLenum
gl_RG32I = 0x823B

gl_RG32UI :: GLenum
gl_RG32UI = 0x823C

gl_RG8 :: GLenum
gl_RG8 = 0x822B

gl_RG8I :: GLenum
gl_RG8I = 0x8237

gl_RG8UI :: GLenum
gl_RG8UI = 0x8238

gl_RG8_EXT :: GLenum
gl_RG8_EXT = 0x822B

gl_RG8_SNORM :: GLenum
gl_RG8_SNORM = 0x8F95

gl_RGB :: GLenum
gl_RGB = 0x1907

gl_RGB10 :: GLenum
gl_RGB10 = 0x8052

gl_RGB10_A2 :: GLenum
gl_RGB10_A2 = 0x8059

gl_RGB10_A2UI :: GLenum
gl_RGB10_A2UI = 0x906F

gl_RGB10_A2_EXT :: GLenum
gl_RGB10_A2_EXT = 0x8059

gl_RGB10_EXT :: GLenum
gl_RGB10_EXT = 0x8052

gl_RGB12 :: GLenum
gl_RGB12 = 0x8053

gl_RGB12_EXT :: GLenum
gl_RGB12_EXT = 0x8053

gl_RGB16 :: GLenum
gl_RGB16 = 0x8054

gl_RGB16F :: GLenum
gl_RGB16F = 0x881B

gl_RGB16F_ARB :: GLenum
gl_RGB16F_ARB = 0x881B

gl_RGB16F_EXT :: GLenum
gl_RGB16F_EXT = 0x881B

gl_RGB16I :: GLenum
gl_RGB16I = 0x8D89

gl_RGB16I_EXT :: GLenum
gl_RGB16I_EXT = 0x8D89

gl_RGB16UI :: GLenum
gl_RGB16UI = 0x8D77

gl_RGB16UI_EXT :: GLenum
gl_RGB16UI_EXT = 0x8D77

gl_RGB16_EXT :: GLenum
gl_RGB16_EXT = 0x8054

gl_RGB16_SNORM :: GLenum
gl_RGB16_SNORM = 0x8F9A

gl_RGB16_SNORM_EXT :: GLenum
gl_RGB16_SNORM_EXT = 0x8F9A

gl_RGB2_EXT :: GLenum
gl_RGB2_EXT = 0x804E

gl_RGB32F :: GLenum
gl_RGB32F = 0x8815

gl_RGB32F_ARB :: GLenum
gl_RGB32F_ARB = 0x8815

gl_RGB32F_EXT :: GLenum
gl_RGB32F_EXT = 0x8815

gl_RGB32I :: GLenum
gl_RGB32I = 0x8D83

gl_RGB32I_EXT :: GLenum
gl_RGB32I_EXT = 0x8D83

gl_RGB32UI :: GLenum
gl_RGB32UI = 0x8D71

gl_RGB32UI_EXT :: GLenum
gl_RGB32UI_EXT = 0x8D71

gl_RGB4 :: GLenum
gl_RGB4 = 0x804F

gl_RGB4_EXT :: GLenum
gl_RGB4_EXT = 0x804F

gl_RGB4_S3TC :: GLenum
gl_RGB4_S3TC = 0x83A1

gl_RGB5 :: GLenum
gl_RGB5 = 0x8050

gl_RGB565 :: GLenum
gl_RGB565 = 0x8D62

gl_RGB565_OES :: GLenum
gl_RGB565_OES = 0x8D62

gl_RGB5_A1 :: GLenum
gl_RGB5_A1 = 0x8057

gl_RGB5_A1_EXT :: GLenum
gl_RGB5_A1_EXT = 0x8057

gl_RGB5_A1_OES :: GLenum
gl_RGB5_A1_OES = 0x8057

gl_RGB5_EXT :: GLenum
gl_RGB5_EXT = 0x8050

gl_RGB8 :: GLenum
gl_RGB8 = 0x8051

gl_RGB8I :: GLenum
gl_RGB8I = 0x8D8F

gl_RGB8I_EXT :: GLenum
gl_RGB8I_EXT = 0x8D8F

gl_RGB8UI :: GLenum
gl_RGB8UI = 0x8D7D

gl_RGB8UI_EXT :: GLenum
gl_RGB8UI_EXT = 0x8D7D

gl_RGB8_EXT :: GLenum
gl_RGB8_EXT = 0x8051

gl_RGB8_OES :: GLenum
gl_RGB8_OES = 0x8051

gl_RGB8_SNORM :: GLenum
gl_RGB8_SNORM = 0x8F96

gl_RGB9_E5 :: GLenum
gl_RGB9_E5 = 0x8C3D

gl_RGB9_E5_APPLE :: GLenum
gl_RGB9_E5_APPLE = 0x8C3D

gl_RGB9_E5_EXT :: GLenum
gl_RGB9_E5_EXT = 0x8C3D

gl_RGBA :: GLenum
gl_RGBA = 0x1908

gl_RGBA12 :: GLenum
gl_RGBA12 = 0x805A

gl_RGBA12_EXT :: GLenum
gl_RGBA12_EXT = 0x805A

gl_RGBA16 :: GLenum
gl_RGBA16 = 0x805B

gl_RGBA16F :: GLenum
gl_RGBA16F = 0x881A

gl_RGBA16F_ARB :: GLenum
gl_RGBA16F_ARB = 0x881A

gl_RGBA16F_EXT :: GLenum
gl_RGBA16F_EXT = 0x881A

gl_RGBA16I :: GLenum
gl_RGBA16I = 0x8D88

gl_RGBA16I_EXT :: GLenum
gl_RGBA16I_EXT = 0x8D88

gl_RGBA16UI :: GLenum
gl_RGBA16UI = 0x8D76

gl_RGBA16UI_EXT :: GLenum
gl_RGBA16UI_EXT = 0x8D76

gl_RGBA16_EXT :: GLenum
gl_RGBA16_EXT = 0x805B

gl_RGBA16_SNORM :: GLenum
gl_RGBA16_SNORM = 0x8F9B

gl_RGBA16_SNORM_EXT :: GLenum
gl_RGBA16_SNORM_EXT = 0x8F9B

gl_RGBA2 :: GLenum
gl_RGBA2 = 0x8055

gl_RGBA2_EXT :: GLenum
gl_RGBA2_EXT = 0x8055

gl_RGBA32F :: GLenum
gl_RGBA32F = 0x8814

gl_RGBA32F_ARB :: GLenum
gl_RGBA32F_ARB = 0x8814

gl_RGBA32F_EXT :: GLenum
gl_RGBA32F_EXT = 0x8814

gl_RGBA32I :: GLenum
gl_RGBA32I = 0x8D82

gl_RGBA32I_EXT :: GLenum
gl_RGBA32I_EXT = 0x8D82

gl_RGBA32UI :: GLenum
gl_RGBA32UI = 0x8D70

gl_RGBA32UI_EXT :: GLenum
gl_RGBA32UI_EXT = 0x8D70

gl_RGBA4 :: GLenum
gl_RGBA4 = 0x8056

gl_RGBA4_DXT5_S3TC :: GLenum
gl_RGBA4_DXT5_S3TC = 0x83A5

gl_RGBA4_EXT :: GLenum
gl_RGBA4_EXT = 0x8056

gl_RGBA4_OES :: GLenum
gl_RGBA4_OES = 0x8056

gl_RGBA4_S3TC :: GLenum
gl_RGBA4_S3TC = 0x83A3

gl_RGBA8 :: GLenum
gl_RGBA8 = 0x8058

gl_RGBA8I :: GLenum
gl_RGBA8I = 0x8D8E

gl_RGBA8I_EXT :: GLenum
gl_RGBA8I_EXT = 0x8D8E

gl_RGBA8UI :: GLenum
gl_RGBA8UI = 0x8D7C

gl_RGBA8UI_EXT :: GLenum
gl_RGBA8UI_EXT = 0x8D7C

gl_RGBA8_EXT :: GLenum
gl_RGBA8_EXT = 0x8058

gl_RGBA8_OES :: GLenum
gl_RGBA8_OES = 0x8058

gl_RGBA8_SNORM :: GLenum
gl_RGBA8_SNORM = 0x8F97

gl_RGBA_DXT5_S3TC :: GLenum
gl_RGBA_DXT5_S3TC = 0x83A4

gl_RGBA_FLOAT16_APPLE :: GLenum
gl_RGBA_FLOAT16_APPLE = 0x881A

gl_RGBA_FLOAT16_ATI :: GLenum
gl_RGBA_FLOAT16_ATI = 0x881A

gl_RGBA_FLOAT32_APPLE :: GLenum
gl_RGBA_FLOAT32_APPLE = 0x8814

gl_RGBA_FLOAT32_ATI :: GLenum
gl_RGBA_FLOAT32_ATI = 0x8814

gl_RGBA_FLOAT_MODE_ARB :: GLenum
gl_RGBA_FLOAT_MODE_ARB = 0x8820

gl_RGBA_FLOAT_MODE_ATI :: GLenum
gl_RGBA_FLOAT_MODE_ATI = 0x8820

gl_RGBA_INTEGER :: GLenum
gl_RGBA_INTEGER = 0x8D99

gl_RGBA_INTEGER_EXT :: GLenum
gl_RGBA_INTEGER_EXT = 0x8D99

gl_RGBA_INTEGER_MODE_EXT :: GLenum
gl_RGBA_INTEGER_MODE_EXT = 0x8D9E

gl_RGBA_MODE :: GLenum
gl_RGBA_MODE = 0x0C31

gl_RGBA_S3TC :: GLenum
gl_RGBA_S3TC = 0x83A2

gl_RGBA_SIGNED_COMPONENTS_EXT :: GLenum
gl_RGBA_SIGNED_COMPONENTS_EXT = 0x8C3C

gl_RGBA_SNORM :: GLenum
gl_RGBA_SNORM = 0x8F93

gl_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV :: GLenum
gl_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = 0x86D9

gl_RGB_422_APPLE :: GLenum
gl_RGB_422_APPLE = 0x8A1F

gl_RGB_FLOAT16_APPLE :: GLenum
gl_RGB_FLOAT16_APPLE = 0x881B

gl_RGB_FLOAT16_ATI :: GLenum
gl_RGB_FLOAT16_ATI = 0x881B

gl_RGB_FLOAT32_APPLE :: GLenum
gl_RGB_FLOAT32_APPLE = 0x8815

gl_RGB_FLOAT32_ATI :: GLenum
gl_RGB_FLOAT32_ATI = 0x8815

gl_RGB_INTEGER :: GLenum
gl_RGB_INTEGER = 0x8D98

gl_RGB_INTEGER_EXT :: GLenum
gl_RGB_INTEGER_EXT = 0x8D98

gl_RGB_RAW_422_APPLE :: GLenum
gl_RGB_RAW_422_APPLE = 0x8A51

gl_RGB_S3TC :: GLenum
gl_RGB_S3TC = 0x83A0

gl_RGB_SCALE :: GLenum
gl_RGB_SCALE = 0x8573

gl_RGB_SCALE_ARB :: GLenum
gl_RGB_SCALE_ARB = 0x8573

gl_RGB_SCALE_EXT :: GLenum
gl_RGB_SCALE_EXT = 0x8573

gl_RGB_SNORM :: GLenum
gl_RGB_SNORM = 0x8F92

gl_RG_EXT :: GLenum
gl_RG_EXT = 0x8227

gl_RG_INTEGER :: GLenum
gl_RG_INTEGER = 0x8228

gl_RG_SNORM :: GLenum
gl_RG_SNORM = 0x8F91

gl_RIGHT :: GLenum
gl_RIGHT = 0x0407

gl_ROUNDED_RECT2_NV :: GLubyte
gl_ROUNDED_RECT2_NV = 0xEA

gl_ROUNDED_RECT4_NV :: GLubyte
gl_ROUNDED_RECT4_NV = 0xEC

gl_ROUNDED_RECT8_NV :: GLubyte
gl_ROUNDED_RECT8_NV = 0xEE

gl_ROUNDED_RECT_NV :: GLubyte
gl_ROUNDED_RECT_NV = 0xE8

gl_ROUND_NV :: GLenum
gl_ROUND_NV = 0x90A4

gl_S :: GLenum
gl_S = 0x2000

gl_SAMPLER :: GLenum
gl_SAMPLER = 0x82E6

gl_SAMPLER_1D :: GLenum
gl_SAMPLER_1D = 0x8B5D

gl_SAMPLER_1D_ARB :: GLenum
gl_SAMPLER_1D_ARB = 0x8B5D

gl_SAMPLER_1D_ARRAY :: GLenum
gl_SAMPLER_1D_ARRAY = 0x8DC0

gl_SAMPLER_1D_ARRAY_EXT :: GLenum
gl_SAMPLER_1D_ARRAY_EXT = 0x8DC0

gl_SAMPLER_1D_ARRAY_SHADOW :: GLenum
gl_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3

gl_SAMPLER_1D_ARRAY_SHADOW_EXT :: GLenum
gl_SAMPLER_1D_ARRAY_SHADOW_EXT = 0x8DC3

gl_SAMPLER_1D_SHADOW :: GLenum
gl_SAMPLER_1D_SHADOW = 0x8B61

gl_SAMPLER_1D_SHADOW_ARB :: GLenum
gl_SAMPLER_1D_SHADOW_ARB = 0x8B61

gl_SAMPLER_2D :: GLenum
gl_SAMPLER_2D = 0x8B5E

gl_SAMPLER_2D_ARB :: GLenum
gl_SAMPLER_2D_ARB = 0x8B5E

gl_SAMPLER_2D_ARRAY :: GLenum
gl_SAMPLER_2D_ARRAY = 0x8DC1

gl_SAMPLER_2D_ARRAY_EXT :: GLenum
gl_SAMPLER_2D_ARRAY_EXT = 0x8DC1

gl_SAMPLER_2D_ARRAY_SHADOW :: GLenum
gl_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4

gl_SAMPLER_2D_ARRAY_SHADOW_EXT :: GLenum
gl_SAMPLER_2D_ARRAY_SHADOW_EXT = 0x8DC4

gl_SAMPLER_2D_ARRAY_SHADOW_NV :: GLenum
gl_SAMPLER_2D_ARRAY_SHADOW_NV = 0x8DC4

gl_SAMPLER_2D_MULTISAMPLE :: GLenum
gl_SAMPLER_2D_MULTISAMPLE = 0x9108

gl_SAMPLER_2D_MULTISAMPLE_ARRAY :: GLenum
gl_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B

gl_SAMPLER_2D_MULTISAMPLE_ARRAY_OES :: GLenum
gl_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910B

gl_SAMPLER_2D_RECT :: GLenum
gl_SAMPLER_2D_RECT = 0x8B63

gl_SAMPLER_2D_RECT_ARB :: GLenum
gl_SAMPLER_2D_RECT_ARB = 0x8B63

gl_SAMPLER_2D_RECT_SHADOW :: GLenum
gl_SAMPLER_2D_RECT_SHADOW = 0x8B64

gl_SAMPLER_2D_RECT_SHADOW_ARB :: GLenum
gl_SAMPLER_2D_RECT_SHADOW_ARB = 0x8B64

gl_SAMPLER_2D_SHADOW :: GLenum
gl_SAMPLER_2D_SHADOW = 0x8B62

gl_SAMPLER_2D_SHADOW_ARB :: GLenum
gl_SAMPLER_2D_SHADOW_ARB = 0x8B62

gl_SAMPLER_2D_SHADOW_EXT :: GLenum
gl_SAMPLER_2D_SHADOW_EXT = 0x8B62

gl_SAMPLER_3D :: GLenum
gl_SAMPLER_3D = 0x8B5F

gl_SAMPLER_3D_ARB :: GLenum
gl_SAMPLER_3D_ARB = 0x8B5F

gl_SAMPLER_3D_OES :: GLenum
gl_SAMPLER_3D_OES = 0x8B5F

gl_SAMPLER_BINDING :: GLenum
gl_SAMPLER_BINDING = 0x8919

gl_SAMPLER_BUFFER :: GLenum
gl_SAMPLER_BUFFER = 0x8DC2

gl_SAMPLER_BUFFER_AMD :: GLenum
gl_SAMPLER_BUFFER_AMD = 0x9001

gl_SAMPLER_BUFFER_EXT :: GLenum
gl_SAMPLER_BUFFER_EXT = 0x8DC2

gl_SAMPLER_BUFFER_OES :: GLenum
gl_SAMPLER_BUFFER_OES = 0x8DC2

gl_SAMPLER_CUBE :: GLenum
gl_SAMPLER_CUBE = 0x8B60

gl_SAMPLER_CUBE_ARB :: GLenum
gl_SAMPLER_CUBE_ARB = 0x8B60

gl_SAMPLER_CUBE_MAP_ARRAY :: GLenum
gl_SAMPLER_CUBE_MAP_ARRAY = 0x900C

gl_SAMPLER_CUBE_MAP_ARRAY_ARB :: GLenum
gl_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900C

gl_SAMPLER_CUBE_MAP_ARRAY_EXT :: GLenum
gl_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900C

gl_SAMPLER_CUBE_MAP_ARRAY_OES :: GLenum
gl_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900C

gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW :: GLenum
gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D

gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB :: GLenum
gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB = 0x900D

gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT :: GLenum
gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT = 0x900D

gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW_OES :: GLenum
gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW_OES = 0x900D

gl_SAMPLER_CUBE_SHADOW :: GLenum
gl_SAMPLER_CUBE_SHADOW = 0x8DC5

gl_SAMPLER_CUBE_SHADOW_EXT :: GLenum
gl_SAMPLER_CUBE_SHADOW_EXT = 0x8DC5

gl_SAMPLER_CUBE_SHADOW_NV :: GLenum
gl_SAMPLER_CUBE_SHADOW_NV = 0x8DC5

gl_SAMPLER_EXTERNAL_2D_Y2Y_EXT :: GLenum
gl_SAMPLER_EXTERNAL_2D_Y2Y_EXT = 0x8BE7

gl_SAMPLER_EXTERNAL_OES :: GLenum
gl_SAMPLER_EXTERNAL_OES = 0x8D66

gl_SAMPLER_KHR :: GLenum
gl_SAMPLER_KHR = 0x82E6

gl_SAMPLER_OBJECT_AMD :: GLenum
gl_SAMPLER_OBJECT_AMD = 0x9155

gl_SAMPLER_RENDERBUFFER_NV :: GLenum
gl_SAMPLER_RENDERBUFFER_NV = 0x8E56

gl_SAMPLES :: GLenum
gl_SAMPLES = 0x80A9

gl_SAMPLES_3DFX :: GLenum
gl_SAMPLES_3DFX = 0x86B4

gl_SAMPLES_ARB :: GLenum
gl_SAMPLES_ARB = 0x80A9

gl_SAMPLES_EXT :: GLenum
gl_SAMPLES_EXT = 0x80A9

gl_SAMPLES_PASSED :: GLenum
gl_SAMPLES_PASSED = 0x8914

gl_SAMPLES_PASSED_ARB :: GLenum
gl_SAMPLES_PASSED_ARB = 0x8914

gl_SAMPLES_SGIS :: GLenum
gl_SAMPLES_SGIS = 0x80A9

gl_SAMPLE_ALPHA_TO_COVERAGE :: GLenum
gl_SAMPLE_ALPHA_TO_COVERAGE = 0x809E

gl_SAMPLE_ALPHA_TO_COVERAGE_ARB :: GLenum
gl_SAMPLE_ALPHA_TO_COVERAGE_ARB = 0x809E

gl_SAMPLE_ALPHA_TO_MASK_EXT :: GLenum
gl_SAMPLE_ALPHA_TO_MASK_EXT = 0x809E

gl_SAMPLE_ALPHA_TO_MASK_SGIS :: GLenum
gl_SAMPLE_ALPHA_TO_MASK_SGIS = 0x809E

gl_SAMPLE_ALPHA_TO_ONE :: GLenum
gl_SAMPLE_ALPHA_TO_ONE = 0x809F

gl_SAMPLE_ALPHA_TO_ONE_ARB :: GLenum
gl_SAMPLE_ALPHA_TO_ONE_ARB = 0x809F

gl_SAMPLE_ALPHA_TO_ONE_EXT :: GLenum
gl_SAMPLE_ALPHA_TO_ONE_EXT = 0x809F

gl_SAMPLE_ALPHA_TO_ONE_SGIS :: GLenum
gl_SAMPLE_ALPHA_TO_ONE_SGIS = 0x809F

gl_SAMPLE_BUFFERS :: GLenum
gl_SAMPLE_BUFFERS = 0x80A8

gl_SAMPLE_BUFFERS_3DFX :: GLenum
gl_SAMPLE_BUFFERS_3DFX = 0x86B3

gl_SAMPLE_BUFFERS_ARB :: GLenum
gl_SAMPLE_BUFFERS_ARB = 0x80A8

gl_SAMPLE_BUFFERS_EXT :: GLenum
gl_SAMPLE_BUFFERS_EXT = 0x80A8

gl_SAMPLE_BUFFERS_SGIS :: GLenum
gl_SAMPLE_BUFFERS_SGIS = 0x80A8

gl_SAMPLE_COVERAGE :: GLenum
gl_SAMPLE_COVERAGE = 0x80A0

gl_SAMPLE_COVERAGE_ARB :: GLenum
gl_SAMPLE_COVERAGE_ARB = 0x80A0

gl_SAMPLE_COVERAGE_INVERT :: GLenum
gl_SAMPLE_COVERAGE_INVERT = 0x80AB

gl_SAMPLE_COVERAGE_INVERT_ARB :: GLenum
gl_SAMPLE_COVERAGE_INVERT_ARB = 0x80AB

gl_SAMPLE_COVERAGE_VALUE :: GLenum
gl_SAMPLE_COVERAGE_VALUE = 0x80AA

gl_SAMPLE_COVERAGE_VALUE_ARB :: GLenum
gl_SAMPLE_COVERAGE_VALUE_ARB = 0x80AA

gl_SAMPLE_LOCATION_NV :: GLenum
gl_SAMPLE_LOCATION_NV = 0x8E50

gl_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV :: GLenum
gl_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV = 0x933F

gl_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV :: GLenum
gl_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV = 0x933E

gl_SAMPLE_LOCATION_SUBPIXEL_BITS_NV :: GLenum
gl_SAMPLE_LOCATION_SUBPIXEL_BITS_NV = 0x933D

gl_SAMPLE_MASK :: GLenum
gl_SAMPLE_MASK = 0x8E51

gl_SAMPLE_MASK_EXT :: GLenum
gl_SAMPLE_MASK_EXT = 0x80A0

gl_SAMPLE_MASK_INVERT_EXT :: GLenum
gl_SAMPLE_MASK_INVERT_EXT = 0x80AB

gl_SAMPLE_MASK_INVERT_SGIS :: GLenum
gl_SAMPLE_MASK_INVERT_SGIS = 0x80AB

gl_SAMPLE_MASK_NV :: GLenum
gl_SAMPLE_MASK_NV = 0x8E51

gl_SAMPLE_MASK_SGIS :: GLenum
gl_SAMPLE_MASK_SGIS = 0x80A0

gl_SAMPLE_MASK_VALUE :: GLenum
gl_SAMPLE_MASK_VALUE = 0x8E52

gl_SAMPLE_MASK_VALUE_EXT :: GLenum
gl_SAMPLE_MASK_VALUE_EXT = 0x80AA

gl_SAMPLE_MASK_VALUE_NV :: GLenum
gl_SAMPLE_MASK_VALUE_NV = 0x8E52

gl_SAMPLE_MASK_VALUE_SGIS :: GLenum
gl_SAMPLE_MASK_VALUE_SGIS = 0x80AA

gl_SAMPLE_PATTERN_EXT :: GLenum
gl_SAMPLE_PATTERN_EXT = 0x80AC

gl_SAMPLE_PATTERN_SGIS :: GLenum
gl_SAMPLE_PATTERN_SGIS = 0x80AC

gl_SAMPLE_POSITION :: GLenum
gl_SAMPLE_POSITION = 0x8E50

gl_SAMPLE_POSITION_NV :: GLenum
gl_SAMPLE_POSITION_NV = 0x8E50

gl_SAMPLE_SHADING :: GLenum
gl_SAMPLE_SHADING = 0x8C36

gl_SAMPLE_SHADING_ARB :: GLenum
gl_SAMPLE_SHADING_ARB = 0x8C36

gl_SAMPLE_SHADING_OES :: GLenum
gl_SAMPLE_SHADING_OES = 0x8C36

gl_SATURATE_BIT_ATI :: GLbitfield
gl_SATURATE_BIT_ATI = 0x00000040

gl_SCALAR_EXT :: GLenum
gl_SCALAR_EXT = 0x87BE

gl_SCALEBIAS_HINT_SGIX :: GLenum
gl_SCALEBIAS_HINT_SGIX = 0x8322

gl_SCALED_RESOLVE_FASTEST_EXT :: GLenum
gl_SCALED_RESOLVE_FASTEST_EXT = 0x90BA

gl_SCALED_RESOLVE_NICEST_EXT :: GLenum
gl_SCALED_RESOLVE_NICEST_EXT = 0x90BB

gl_SCALE_BY_FOUR_NV :: GLenum
gl_SCALE_BY_FOUR_NV = 0x853F

gl_SCALE_BY_ONE_HALF_NV :: GLenum
gl_SCALE_BY_ONE_HALF_NV = 0x8540

gl_SCALE_BY_TWO_NV :: GLenum
gl_SCALE_BY_TWO_NV = 0x853E

gl_SCISSOR_BIT :: GLbitfield
gl_SCISSOR_BIT = 0x00080000

gl_SCISSOR_BOX :: GLenum
gl_SCISSOR_BOX = 0x0C10

gl_SCISSOR_TEST :: GLenum
gl_SCISSOR_TEST = 0x0C11

gl_SCREEN_COORDINATES_REND :: GLenum
gl_SCREEN_COORDINATES_REND = 0x8490

gl_SCREEN_KHR :: GLenum
gl_SCREEN_KHR = 0x9295

gl_SCREEN_NV :: GLenum
gl_SCREEN_NV = 0x9295

gl_SECONDARY_COLOR_ARRAY :: GLenum
gl_SECONDARY_COLOR_ARRAY = 0x845E

gl_SECONDARY_COLOR_ARRAY_ADDRESS_NV :: GLenum
gl_SECONDARY_COLOR_ARRAY_ADDRESS_NV = 0x8F27

gl_SECONDARY_COLOR_ARRAY_BUFFER_BINDING :: GLenum
gl_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 0x889C

gl_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x889C

gl_SECONDARY_COLOR_ARRAY_EXT :: GLenum
gl_SECONDARY_COLOR_ARRAY_EXT = 0x845E

gl_SECONDARY_COLOR_ARRAY_LENGTH_NV :: GLenum
gl_SECONDARY_COLOR_ARRAY_LENGTH_NV = 0x8F31

gl_SECONDARY_COLOR_ARRAY_LIST_IBM :: GLenum
gl_SECONDARY_COLOR_ARRAY_LIST_IBM = 103077

gl_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM :: GLenum
gl_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM = 103087

gl_SECONDARY_COLOR_ARRAY_POINTER :: GLenum
gl_SECONDARY_COLOR_ARRAY_POINTER = 0x845D

gl_SECONDARY_COLOR_ARRAY_POINTER_EXT :: GLenum
gl_SECONDARY_COLOR_ARRAY_POINTER_EXT = 0x845D

gl_SECONDARY_COLOR_ARRAY_SIZE :: GLenum
gl_SECONDARY_COLOR_ARRAY_SIZE = 0x845A

gl_SECONDARY_COLOR_ARRAY_SIZE_EXT :: GLenum
gl_SECONDARY_COLOR_ARRAY_SIZE_EXT = 0x845A

gl_SECONDARY_COLOR_ARRAY_STRIDE :: GLenum
gl_SECONDARY_COLOR_ARRAY_STRIDE = 0x845C

gl_SECONDARY_COLOR_ARRAY_STRIDE_EXT :: GLenum
gl_SECONDARY_COLOR_ARRAY_STRIDE_EXT = 0x845C

gl_SECONDARY_COLOR_ARRAY_TYPE :: GLenum
gl_SECONDARY_COLOR_ARRAY_TYPE = 0x845B

gl_SECONDARY_COLOR_ARRAY_TYPE_EXT :: GLenum
gl_SECONDARY_COLOR_ARRAY_TYPE_EXT = 0x845B

gl_SECONDARY_COLOR_NV :: GLenum
gl_SECONDARY_COLOR_NV = 0x852D

gl_SECONDARY_INTERPOLATOR_ATI :: GLenum
gl_SECONDARY_INTERPOLATOR_ATI = 0x896D

gl_SELECT :: GLenum
gl_SELECT = 0x1C02

gl_SELECTION_BUFFER_POINTER :: GLenum
gl_SELECTION_BUFFER_POINTER = 0x0DF3

gl_SELECTION_BUFFER_SIZE :: GLenum
gl_SELECTION_BUFFER_SIZE = 0x0DF4

gl_SEPARABLE_2D :: GLenum
gl_SEPARABLE_2D = 0x8012

gl_SEPARABLE_2D_EXT :: GLenum
gl_SEPARABLE_2D_EXT = 0x8012

gl_SEPARATE_ATTRIBS :: GLenum
gl_SEPARATE_ATTRIBS = 0x8C8D

gl_SEPARATE_ATTRIBS_EXT :: GLenum
gl_SEPARATE_ATTRIBS_EXT = 0x8C8D

gl_SEPARATE_ATTRIBS_NV :: GLenum
gl_SEPARATE_ATTRIBS_NV = 0x8C8D

gl_SEPARATE_SPECULAR_COLOR :: GLenum
gl_SEPARATE_SPECULAR_COLOR = 0x81FA

gl_SEPARATE_SPECULAR_COLOR_EXT :: GLenum
gl_SEPARATE_SPECULAR_COLOR_EXT = 0x81FA

gl_SET :: GLenum
gl_SET = 0x150F

gl_SET_AMD :: GLenum
gl_SET_AMD = 0x874A

gl_SGX_BINARY_IMG :: GLenum
gl_SGX_BINARY_IMG = 0x8C0A

gl_SGX_PROGRAM_BINARY_IMG :: GLenum
gl_SGX_PROGRAM_BINARY_IMG = 0x9130

gl_SHADER :: GLenum
gl_SHADER = 0x82E1

gl_SHADER_BINARY_DMP :: GLenum
gl_SHADER_BINARY_DMP = 0x9250

gl_SHADER_BINARY_FORMATS :: GLenum
gl_SHADER_BINARY_FORMATS = 0x8DF8

gl_SHADER_BINARY_VIV :: GLenum
gl_SHADER_BINARY_VIV = 0x8FC4

gl_SHADER_COMPILER :: GLenum
gl_SHADER_COMPILER = 0x8DFA

gl_SHADER_CONSISTENT_NV :: GLenum
gl_SHADER_CONSISTENT_NV = 0x86DD

gl_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV :: GLbitfield
gl_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV = 0x00000010

gl_SHADER_IMAGE_ACCESS_BARRIER_BIT :: GLbitfield
gl_SHADER_IMAGE_ACCESS_BARRIER_BIT = 0x00000020

gl_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT :: GLbitfield
gl_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT = 0x00000020

gl_SHADER_IMAGE_ATOMIC :: GLenum
gl_SHADER_IMAGE_ATOMIC = 0x82A6

gl_SHADER_IMAGE_LOAD :: GLenum
gl_SHADER_IMAGE_LOAD = 0x82A4

gl_SHADER_IMAGE_STORE :: GLenum
gl_SHADER_IMAGE_STORE = 0x82A5

gl_SHADER_INCLUDE_ARB :: GLenum
gl_SHADER_INCLUDE_ARB = 0x8DAE

gl_SHADER_KHR :: GLenum
gl_SHADER_KHR = 0x82E1

gl_SHADER_OBJECT_ARB :: GLenum
gl_SHADER_OBJECT_ARB = 0x8B48

gl_SHADER_OBJECT_EXT :: GLenum
gl_SHADER_OBJECT_EXT = 0x8B48

gl_SHADER_OPERATION_NV :: GLenum
gl_SHADER_OPERATION_NV = 0x86DF

gl_SHADER_PIXEL_LOCAL_STORAGE_EXT :: GLenum
gl_SHADER_PIXEL_LOCAL_STORAGE_EXT = 0x8F64

gl_SHADER_SOURCE_LENGTH :: GLenum
gl_SHADER_SOURCE_LENGTH = 0x8B88

gl_SHADER_STORAGE_BARRIER_BIT :: GLbitfield
gl_SHADER_STORAGE_BARRIER_BIT = 0x00002000

gl_SHADER_STORAGE_BLOCK :: GLenum
gl_SHADER_STORAGE_BLOCK = 0x92E6

gl_SHADER_STORAGE_BUFFER :: GLenum
gl_SHADER_STORAGE_BUFFER = 0x90D2

gl_SHADER_STORAGE_BUFFER_BINDING :: GLenum
gl_SHADER_STORAGE_BUFFER_BINDING = 0x90D3

gl_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT :: GLenum
gl_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 0x90DF

gl_SHADER_STORAGE_BUFFER_SIZE :: GLenum
gl_SHADER_STORAGE_BUFFER_SIZE = 0x90D5

gl_SHADER_STORAGE_BUFFER_START :: GLenum
gl_SHADER_STORAGE_BUFFER_START = 0x90D4

gl_SHADER_TYPE :: GLenum
gl_SHADER_TYPE = 0x8B4F

gl_SHADE_MODEL :: GLenum
gl_SHADE_MODEL = 0x0B54

gl_SHADING_LANGUAGE_VERSION :: GLenum
gl_SHADING_LANGUAGE_VERSION = 0x8B8C

gl_SHADING_LANGUAGE_VERSION_ARB :: GLenum
gl_SHADING_LANGUAGE_VERSION_ARB = 0x8B8C

gl_SHADOW_AMBIENT_SGIX :: GLenum
gl_SHADOW_AMBIENT_SGIX = 0x80BF

gl_SHADOW_ATTENUATION_EXT :: GLenum
gl_SHADOW_ATTENUATION_EXT = 0x834E

gl_SHARED_EDGE_NV :: GLubyte
gl_SHARED_EDGE_NV = 0xC0

gl_SHARED_TEXTURE_PALETTE_EXT :: GLenum
gl_SHARED_TEXTURE_PALETTE_EXT = 0x81FB

gl_SHARPEN_TEXTURE_FUNC_POINTS_SGIS :: GLenum
gl_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = 0x80B0

gl_SHININESS :: GLenum
gl_SHININESS = 0x1601

gl_SHORT :: GLenum
gl_SHORT = 0x1402

gl_SIGNALED :: GLenum
gl_SIGNALED = 0x9119

gl_SIGNALED_APPLE :: GLenum
gl_SIGNALED_APPLE = 0x9119

gl_SIGNED_ALPHA8_NV :: GLenum
gl_SIGNED_ALPHA8_NV = 0x8706

gl_SIGNED_ALPHA_NV :: GLenum
gl_SIGNED_ALPHA_NV = 0x8705

gl_SIGNED_HILO16_NV :: GLenum
gl_SIGNED_HILO16_NV = 0x86FA

gl_SIGNED_HILO8_NV :: GLenum
gl_SIGNED_HILO8_NV = 0x885F

gl_SIGNED_HILO_NV :: GLenum
gl_SIGNED_HILO_NV = 0x86F9

gl_SIGNED_IDENTITY_NV :: GLenum
gl_SIGNED_IDENTITY_NV = 0x853C

gl_SIGNED_INTENSITY8_NV :: GLenum
gl_SIGNED_INTENSITY8_NV = 0x8708

gl_SIGNED_INTENSITY_NV :: GLenum
gl_SIGNED_INTENSITY_NV = 0x8707

gl_SIGNED_LUMINANCE8_ALPHA8_NV :: GLenum
gl_SIGNED_LUMINANCE8_ALPHA8_NV = 0x8704

gl_SIGNED_LUMINANCE8_NV :: GLenum
gl_SIGNED_LUMINANCE8_NV = 0x8702

gl_SIGNED_LUMINANCE_ALPHA_NV :: GLenum
gl_SIGNED_LUMINANCE_ALPHA_NV = 0x8703

gl_SIGNED_LUMINANCE_NV :: GLenum
gl_SIGNED_LUMINANCE_NV = 0x8701

gl_SIGNED_NEGATE_NV :: GLenum
gl_SIGNED_NEGATE_NV = 0x853D

gl_SIGNED_NORMALIZED :: GLenum
gl_SIGNED_NORMALIZED = 0x8F9C

gl_SIGNED_RGB8_NV :: GLenum
gl_SIGNED_RGB8_NV = 0x86FF

gl_SIGNED_RGB8_UNSIGNED_ALPHA8_NV :: GLenum
gl_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = 0x870D

gl_SIGNED_RGBA8_NV :: GLenum
gl_SIGNED_RGBA8_NV = 0x86FC

gl_SIGNED_RGBA_NV :: GLenum
gl_SIGNED_RGBA_NV = 0x86FB

gl_SIGNED_RGB_NV :: GLenum
gl_SIGNED_RGB_NV = 0x86FE

gl_SIGNED_RGB_UNSIGNED_ALPHA_NV :: GLenum
gl_SIGNED_RGB_UNSIGNED_ALPHA_NV = 0x870C

gl_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST :: GLenum
gl_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 0x82AC

gl_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE :: GLenum
gl_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 0x82AE

gl_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST :: GLenum
gl_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 0x82AD

gl_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE :: GLenum
gl_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 0x82AF

gl_SINGLE_COLOR :: GLenum
gl_SINGLE_COLOR = 0x81F9

gl_SINGLE_COLOR_EXT :: GLenum
gl_SINGLE_COLOR_EXT = 0x81F9

gl_SKIP_COMPONENTS1_NV :: GLenum
gl_SKIP_COMPONENTS1_NV = -6

gl_SKIP_COMPONENTS2_NV :: GLenum
gl_SKIP_COMPONENTS2_NV = -5

gl_SKIP_COMPONENTS3_NV :: GLenum
gl_SKIP_COMPONENTS3_NV = -4

gl_SKIP_COMPONENTS4_NV :: GLenum
gl_SKIP_COMPONENTS4_NV = -3

gl_SKIP_DECODE_EXT :: GLenum
gl_SKIP_DECODE_EXT = 0x8A4A

gl_SKIP_MISSING_GLYPH_NV :: GLenum
gl_SKIP_MISSING_GLYPH_NV = 0x90A9

gl_SLICE_ACCUM_SUN :: GLenum
gl_SLICE_ACCUM_SUN = 0x85CC

gl_SLIM10U_SGIX :: GLenum
gl_SLIM10U_SGIX = 0x831E

gl_SLIM12S_SGIX :: GLenum
gl_SLIM12S_SGIX = 0x831F

gl_SLIM8U_SGIX :: GLenum
gl_SLIM8U_SGIX = 0x831D

gl_SLUMINANCE :: GLenum
gl_SLUMINANCE = 0x8C46

gl_SLUMINANCE8 :: GLenum
gl_SLUMINANCE8 = 0x8C47

gl_SLUMINANCE8_ALPHA8 :: GLenum
gl_SLUMINANCE8_ALPHA8 = 0x8C45

gl_SLUMINANCE8_ALPHA8_EXT :: GLenum
gl_SLUMINANCE8_ALPHA8_EXT = 0x8C45

gl_SLUMINANCE8_ALPHA8_NV :: GLenum
gl_SLUMINANCE8_ALPHA8_NV = 0x8C45

gl_SLUMINANCE8_EXT :: GLenum
gl_SLUMINANCE8_EXT = 0x8C47

gl_SLUMINANCE8_NV :: GLenum
gl_SLUMINANCE8_NV = 0x8C47

gl_SLUMINANCE_ALPHA :: GLenum
gl_SLUMINANCE_ALPHA = 0x8C44

gl_SLUMINANCE_ALPHA_EXT :: GLenum
gl_SLUMINANCE_ALPHA_EXT = 0x8C44

gl_SLUMINANCE_ALPHA_NV :: GLenum
gl_SLUMINANCE_ALPHA_NV = 0x8C44

gl_SLUMINANCE_EXT :: GLenum
gl_SLUMINANCE_EXT = 0x8C46

gl_SLUMINANCE_NV :: GLenum
gl_SLUMINANCE_NV = 0x8C46

gl_SMALL_CCW_ARC_TO_NV :: GLubyte
gl_SMALL_CCW_ARC_TO_NV = 0x12

gl_SMALL_CW_ARC_TO_NV :: GLubyte
gl_SMALL_CW_ARC_TO_NV = 0x14

gl_SMAPHS30_PROGRAM_BINARY_DMP :: GLenum
gl_SMAPHS30_PROGRAM_BINARY_DMP = 0x9251

gl_SMAPHS_PROGRAM_BINARY_DMP :: GLenum
gl_SMAPHS_PROGRAM_BINARY_DMP = 0x9252

gl_SMOOTH :: GLenum
gl_SMOOTH = 0x1D01

gl_SMOOTH_CUBIC_CURVE_TO_NV :: GLubyte
gl_SMOOTH_CUBIC_CURVE_TO_NV = 0x10

gl_SMOOTH_LINE_WIDTH_GRANULARITY :: GLenum
gl_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23

gl_SMOOTH_LINE_WIDTH_RANGE :: GLenum
gl_SMOOTH_LINE_WIDTH_RANGE = 0x0B22

gl_SMOOTH_POINT_SIZE_GRANULARITY :: GLenum
gl_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13

gl_SMOOTH_POINT_SIZE_RANGE :: GLenum
gl_SMOOTH_POINT_SIZE_RANGE = 0x0B12

gl_SMOOTH_QUADRATIC_CURVE_TO_NV :: GLubyte
gl_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0E

gl_SM_COUNT_NV :: GLenum
gl_SM_COUNT_NV = 0x933B

gl_SOFTLIGHT_KHR :: GLenum
gl_SOFTLIGHT_KHR = 0x929C

gl_SOFTLIGHT_NV :: GLenum
gl_SOFTLIGHT_NV = 0x929C

gl_SOURCE0_ALPHA :: GLenum
gl_SOURCE0_ALPHA = 0x8588

gl_SOURCE0_ALPHA_ARB :: GLenum
gl_SOURCE0_ALPHA_ARB = 0x8588

gl_SOURCE0_ALPHA_EXT :: GLenum
gl_SOURCE0_ALPHA_EXT = 0x8588

gl_SOURCE0_RGB :: GLenum
gl_SOURCE0_RGB = 0x8580

gl_SOURCE0_RGB_ARB :: GLenum
gl_SOURCE0_RGB_ARB = 0x8580

gl_SOURCE0_RGB_EXT :: GLenum
gl_SOURCE0_RGB_EXT = 0x8580

gl_SOURCE1_ALPHA :: GLenum
gl_SOURCE1_ALPHA = 0x8589

gl_SOURCE1_ALPHA_ARB :: GLenum
gl_SOURCE1_ALPHA_ARB = 0x8589

gl_SOURCE1_ALPHA_EXT :: GLenum
gl_SOURCE1_ALPHA_EXT = 0x8589

gl_SOURCE1_RGB :: GLenum
gl_SOURCE1_RGB = 0x8581

gl_SOURCE1_RGB_ARB :: GLenum
gl_SOURCE1_RGB_ARB = 0x8581

gl_SOURCE1_RGB_EXT :: GLenum
gl_SOURCE1_RGB_EXT = 0x8581

gl_SOURCE2_ALPHA :: GLenum
gl_SOURCE2_ALPHA = 0x858A

gl_SOURCE2_ALPHA_ARB :: GLenum
gl_SOURCE2_ALPHA_ARB = 0x858A

gl_SOURCE2_ALPHA_EXT :: GLenum
gl_SOURCE2_ALPHA_EXT = 0x858A

gl_SOURCE2_RGB :: GLenum
gl_SOURCE2_RGB = 0x8582

gl_SOURCE2_RGB_ARB :: GLenum
gl_SOURCE2_RGB_ARB = 0x8582

gl_SOURCE2_RGB_EXT :: GLenum
gl_SOURCE2_RGB_EXT = 0x8582

gl_SOURCE3_ALPHA_NV :: GLenum
gl_SOURCE3_ALPHA_NV = 0x858B

gl_SOURCE3_RGB_NV :: GLenum
gl_SOURCE3_RGB_NV = 0x8583

gl_SPARE0_NV :: GLenum
gl_SPARE0_NV = 0x852E

gl_SPARE0_PLUS_SECONDARY_COLOR_NV :: GLenum
gl_SPARE0_PLUS_SECONDARY_COLOR_NV = 0x8532

gl_SPARE1_NV :: GLenum
gl_SPARE1_NV = 0x852F

gl_SPARSE_BUFFER_PAGE_SIZE_ARB :: GLenum
gl_SPARSE_BUFFER_PAGE_SIZE_ARB = 0x82F8

gl_SPARSE_STORAGE_BIT_ARB :: GLbitfield
gl_SPARSE_STORAGE_BIT_ARB = 0x0400

gl_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB :: GLenum
gl_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = 0x91A9

gl_SPECULAR :: GLenum
gl_SPECULAR = 0x1202

gl_SPHERE_MAP :: GLenum
gl_SPHERE_MAP = 0x2402

gl_SPOT_CUTOFF :: GLenum
gl_SPOT_CUTOFF = 0x1206

gl_SPOT_DIRECTION :: GLenum
gl_SPOT_DIRECTION = 0x1204

gl_SPOT_EXPONENT :: GLenum
gl_SPOT_EXPONENT = 0x1205

gl_SPRITE_AXIAL_SGIX :: GLenum
gl_SPRITE_AXIAL_SGIX = 0x814C

gl_SPRITE_AXIS_SGIX :: GLenum
gl_SPRITE_AXIS_SGIX = 0x814A

gl_SPRITE_EYE_ALIGNED_SGIX :: GLenum
gl_SPRITE_EYE_ALIGNED_SGIX = 0x814E

gl_SPRITE_MODE_SGIX :: GLenum
gl_SPRITE_MODE_SGIX = 0x8149

gl_SPRITE_OBJECT_ALIGNED_SGIX :: GLenum
gl_SPRITE_OBJECT_ALIGNED_SGIX = 0x814D

gl_SPRITE_SGIX :: GLenum
gl_SPRITE_SGIX = 0x8148

gl_SPRITE_TRANSLATION_SGIX :: GLenum
gl_SPRITE_TRANSLATION_SGIX = 0x814B

gl_SQUARE_NV :: GLenum
gl_SQUARE_NV = 0x90A3

gl_SR8_EXT :: GLenum
gl_SR8_EXT = 0x8FBD

gl_SRC0_ALPHA :: GLenum
gl_SRC0_ALPHA = 0x8588

gl_SRC0_RGB :: GLenum
gl_SRC0_RGB = 0x8580

gl_SRC1_ALPHA :: GLenum
gl_SRC1_ALPHA = 0x8589

gl_SRC1_COLOR :: GLenum
gl_SRC1_COLOR = 0x88F9

gl_SRC1_RGB :: GLenum
gl_SRC1_RGB = 0x8581

gl_SRC2_ALPHA :: GLenum
gl_SRC2_ALPHA = 0x858A

gl_SRC2_RGB :: GLenum
gl_SRC2_RGB = 0x8582

gl_SRC_ALPHA :: GLenum
gl_SRC_ALPHA = 0x0302

gl_SRC_ALPHA_SATURATE :: GLenum
gl_SRC_ALPHA_SATURATE = 0x0308

gl_SRC_ATOP_NV :: GLenum
gl_SRC_ATOP_NV = 0x928E

gl_SRC_COLOR :: GLenum
gl_SRC_COLOR = 0x0300

gl_SRC_IN_NV :: GLenum
gl_SRC_IN_NV = 0x928A

gl_SRC_NV :: GLenum
gl_SRC_NV = 0x9286

gl_SRC_OUT_NV :: GLenum
gl_SRC_OUT_NV = 0x928C

gl_SRC_OVER_NV :: GLenum
gl_SRC_OVER_NV = 0x9288

gl_SRG8_EXT :: GLenum
gl_SRG8_EXT = 0x8FBE

gl_SRGB :: GLenum
gl_SRGB = 0x8C40

gl_SRGB8 :: GLenum
gl_SRGB8 = 0x8C41

gl_SRGB8_ALPHA8 :: GLenum
gl_SRGB8_ALPHA8 = 0x8C43

gl_SRGB8_ALPHA8_EXT :: GLenum
gl_SRGB8_ALPHA8_EXT = 0x8C43

gl_SRGB8_EXT :: GLenum
gl_SRGB8_EXT = 0x8C41

gl_SRGB8_NV :: GLenum
gl_SRGB8_NV = 0x8C41

gl_SRGB_ALPHA :: GLenum
gl_SRGB_ALPHA = 0x8C42

gl_SRGB_ALPHA_EXT :: GLenum
gl_SRGB_ALPHA_EXT = 0x8C42

gl_SRGB_DECODE_ARB :: GLenum
gl_SRGB_DECODE_ARB = 0x8299

gl_SRGB_EXT :: GLenum
gl_SRGB_EXT = 0x8C40

gl_SRGB_READ :: GLenum
gl_SRGB_READ = 0x8297

gl_SRGB_WRITE :: GLenum
gl_SRGB_WRITE = 0x8298

gl_STACK_OVERFLOW :: GLenum
gl_STACK_OVERFLOW = 0x0503

gl_STACK_OVERFLOW_KHR :: GLenum
gl_STACK_OVERFLOW_KHR = 0x0503

gl_STACK_UNDERFLOW :: GLenum
gl_STACK_UNDERFLOW = 0x0504

gl_STACK_UNDERFLOW_KHR :: GLenum
gl_STACK_UNDERFLOW_KHR = 0x0504

gl_STANDARD_FONT_FORMAT_NV :: GLenum
gl_STANDARD_FONT_FORMAT_NV = 0x936C

gl_STANDARD_FONT_NAME_NV :: GLenum
gl_STANDARD_FONT_NAME_NV = 0x9072

gl_STATE_RESTORE :: GLenum
gl_STATE_RESTORE = 0x8BDC

gl_STATIC_ATI :: GLenum
gl_STATIC_ATI = 0x8760

gl_STATIC_COPY :: GLenum
gl_STATIC_COPY = 0x88E6

gl_STATIC_COPY_ARB :: GLenum
gl_STATIC_COPY_ARB = 0x88E6

gl_STATIC_DRAW :: GLenum
gl_STATIC_DRAW = 0x88E4

gl_STATIC_DRAW_ARB :: GLenum
gl_STATIC_DRAW_ARB = 0x88E4

gl_STATIC_READ :: GLenum
gl_STATIC_READ = 0x88E5

gl_STATIC_READ_ARB :: GLenum
gl_STATIC_READ_ARB = 0x88E5

gl_STATIC_VERTEX_ARRAY_IBM :: GLenum
gl_STATIC_VERTEX_ARRAY_IBM = 103061

gl_STENCIL :: GLenum
gl_STENCIL = 0x1802

gl_STENCIL_ATTACHMENT :: GLenum
gl_STENCIL_ATTACHMENT = 0x8D20

gl_STENCIL_ATTACHMENT_EXT :: GLenum
gl_STENCIL_ATTACHMENT_EXT = 0x8D20

gl_STENCIL_ATTACHMENT_OES :: GLenum
gl_STENCIL_ATTACHMENT_OES = 0x8D20

gl_STENCIL_BACK_FAIL :: GLenum
gl_STENCIL_BACK_FAIL = 0x8801

gl_STENCIL_BACK_FAIL_ATI :: GLenum
gl_STENCIL_BACK_FAIL_ATI = 0x8801

gl_STENCIL_BACK_FUNC :: GLenum
gl_STENCIL_BACK_FUNC = 0x8800

gl_STENCIL_BACK_FUNC_ATI :: GLenum
gl_STENCIL_BACK_FUNC_ATI = 0x8800

gl_STENCIL_BACK_OP_VALUE_AMD :: GLenum
gl_STENCIL_BACK_OP_VALUE_AMD = 0x874D

gl_STENCIL_BACK_PASS_DEPTH_FAIL :: GLenum
gl_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802

gl_STENCIL_BACK_PASS_DEPTH_FAIL_ATI :: GLenum
gl_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = 0x8802

gl_STENCIL_BACK_PASS_DEPTH_PASS :: GLenum
gl_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803

gl_STENCIL_BACK_PASS_DEPTH_PASS_ATI :: GLenum
gl_STENCIL_BACK_PASS_DEPTH_PASS_ATI = 0x8803

gl_STENCIL_BACK_REF :: GLenum
gl_STENCIL_BACK_REF = 0x8CA3

gl_STENCIL_BACK_VALUE_MASK :: GLenum
gl_STENCIL_BACK_VALUE_MASK = 0x8CA4

gl_STENCIL_BACK_WRITEMASK :: GLenum
gl_STENCIL_BACK_WRITEMASK = 0x8CA5

gl_STENCIL_BITS :: GLenum
gl_STENCIL_BITS = 0x0D57

gl_STENCIL_BUFFER_BIT :: GLbitfield
gl_STENCIL_BUFFER_BIT = 0x00000400

gl_STENCIL_BUFFER_BIT0_QCOM :: GLbitfield
gl_STENCIL_BUFFER_BIT0_QCOM = 0x00010000

gl_STENCIL_BUFFER_BIT1_QCOM :: GLbitfield
gl_STENCIL_BUFFER_BIT1_QCOM = 0x00020000

gl_STENCIL_BUFFER_BIT2_QCOM :: GLbitfield
gl_STENCIL_BUFFER_BIT2_QCOM = 0x00040000

gl_STENCIL_BUFFER_BIT3_QCOM :: GLbitfield
gl_STENCIL_BUFFER_BIT3_QCOM = 0x00080000

gl_STENCIL_BUFFER_BIT4_QCOM :: GLbitfield
gl_STENCIL_BUFFER_BIT4_QCOM = 0x00100000

gl_STENCIL_BUFFER_BIT5_QCOM :: GLbitfield
gl_STENCIL_BUFFER_BIT5_QCOM = 0x00200000

gl_STENCIL_BUFFER_BIT6_QCOM :: GLbitfield
gl_STENCIL_BUFFER_BIT6_QCOM = 0x00400000

gl_STENCIL_BUFFER_BIT7_QCOM :: GLbitfield
gl_STENCIL_BUFFER_BIT7_QCOM = 0x00800000

gl_STENCIL_CLEAR_TAG_VALUE_EXT :: GLenum
gl_STENCIL_CLEAR_TAG_VALUE_EXT = 0x88F3

gl_STENCIL_CLEAR_VALUE :: GLenum
gl_STENCIL_CLEAR_VALUE = 0x0B91

gl_STENCIL_COMPONENTS :: GLenum
gl_STENCIL_COMPONENTS = 0x8285

gl_STENCIL_EXT :: GLenum
gl_STENCIL_EXT = 0x1802

gl_STENCIL_FAIL :: GLenum
gl_STENCIL_FAIL = 0x0B94

gl_STENCIL_FUNC :: GLenum
gl_STENCIL_FUNC = 0x0B92

gl_STENCIL_INDEX :: GLenum
gl_STENCIL_INDEX = 0x1901

gl_STENCIL_INDEX1 :: GLenum
gl_STENCIL_INDEX1 = 0x8D46

gl_STENCIL_INDEX16 :: GLenum
gl_STENCIL_INDEX16 = 0x8D49

gl_STENCIL_INDEX16_EXT :: GLenum
gl_STENCIL_INDEX16_EXT = 0x8D49

gl_STENCIL_INDEX1_EXT :: GLenum
gl_STENCIL_INDEX1_EXT = 0x8D46

gl_STENCIL_INDEX1_OES :: GLenum
gl_STENCIL_INDEX1_OES = 0x8D46

gl_STENCIL_INDEX4 :: GLenum
gl_STENCIL_INDEX4 = 0x8D47

gl_STENCIL_INDEX4_EXT :: GLenum
gl_STENCIL_INDEX4_EXT = 0x8D47

gl_STENCIL_INDEX4_OES :: GLenum
gl_STENCIL_INDEX4_OES = 0x8D47

gl_STENCIL_INDEX8 :: GLenum
gl_STENCIL_INDEX8 = 0x8D48

gl_STENCIL_INDEX8_EXT :: GLenum
gl_STENCIL_INDEX8_EXT = 0x8D48

gl_STENCIL_INDEX8_OES :: GLenum
gl_STENCIL_INDEX8_OES = 0x8D48

gl_STENCIL_INDEX_OES :: GLenum
gl_STENCIL_INDEX_OES = 0x1901

gl_STENCIL_OP_VALUE_AMD :: GLenum
gl_STENCIL_OP_VALUE_AMD = 0x874C

gl_STENCIL_PASS_DEPTH_FAIL :: GLenum
gl_STENCIL_PASS_DEPTH_FAIL = 0x0B95

gl_STENCIL_PASS_DEPTH_PASS :: GLenum
gl_STENCIL_PASS_DEPTH_PASS = 0x0B96

gl_STENCIL_REF :: GLenum
gl_STENCIL_REF = 0x0B97

gl_STENCIL_RENDERABLE :: GLenum
gl_STENCIL_RENDERABLE = 0x8288

gl_STENCIL_SAMPLES_NV :: GLenum
gl_STENCIL_SAMPLES_NV = 0x932E

gl_STENCIL_TAG_BITS_EXT :: GLenum
gl_STENCIL_TAG_BITS_EXT = 0x88F2

gl_STENCIL_TEST :: GLenum
gl_STENCIL_TEST = 0x0B90

gl_STENCIL_TEST_TWO_SIDE_EXT :: GLenum
gl_STENCIL_TEST_TWO_SIDE_EXT = 0x8910

gl_STENCIL_VALUE_MASK :: GLenum
gl_STENCIL_VALUE_MASK = 0x0B93

gl_STENCIL_WRITEMASK :: GLenum
gl_STENCIL_WRITEMASK = 0x0B98

gl_STEREO :: GLenum
gl_STEREO = 0x0C33

gl_STORAGE_CACHED_APPLE :: GLenum
gl_STORAGE_CACHED_APPLE = 0x85BE

gl_STORAGE_CLIENT_APPLE :: GLenum
gl_STORAGE_CLIENT_APPLE = 0x85B4

gl_STORAGE_PRIVATE_APPLE :: GLenum
gl_STORAGE_PRIVATE_APPLE = 0x85BD

gl_STORAGE_SHARED_APPLE :: GLenum
gl_STORAGE_SHARED_APPLE = 0x85BF

gl_STREAM_COPY :: GLenum
gl_STREAM_COPY = 0x88E2

gl_STREAM_COPY_ARB :: GLenum
gl_STREAM_COPY_ARB = 0x88E2

gl_STREAM_DRAW :: GLenum
gl_STREAM_DRAW = 0x88E0

gl_STREAM_DRAW_ARB :: GLenum
gl_STREAM_DRAW_ARB = 0x88E0

gl_STREAM_RASTERIZATION_AMD :: GLenum
gl_STREAM_RASTERIZATION_AMD = 0x91A0

gl_STREAM_READ :: GLenum
gl_STREAM_READ = 0x88E1

gl_STREAM_READ_ARB :: GLenum
gl_STREAM_READ_ARB = 0x88E1

gl_STRICT_DEPTHFUNC_HINT_PGI :: GLenum
gl_STRICT_DEPTHFUNC_HINT_PGI = 0x1A216

gl_STRICT_LIGHTING_HINT_PGI :: GLenum
gl_STRICT_LIGHTING_HINT_PGI = 0x1A217

gl_STRICT_SCISSOR_HINT_PGI :: GLenum
gl_STRICT_SCISSOR_HINT_PGI = 0x1A218

gl_SUBPIXEL_BITS :: GLenum
gl_SUBPIXEL_BITS = 0x0D50

gl_SUBPIXEL_PRECISION_BIAS_X_BITS_NV :: GLenum
gl_SUBPIXEL_PRECISION_BIAS_X_BITS_NV = 0x9347

gl_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV :: GLenum
gl_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV = 0x9348

gl_SUBSAMPLE_DISTANCE_AMD :: GLenum
gl_SUBSAMPLE_DISTANCE_AMD = 0x883F

gl_SUBTRACT :: GLenum
gl_SUBTRACT = 0x84E7

gl_SUBTRACT_ARB :: GLenum
gl_SUBTRACT_ARB = 0x84E7

gl_SUB_ATI :: GLenum
gl_SUB_ATI = 0x8965

gl_SUCCESS_NV :: GLenum
gl_SUCCESS_NV = 0x902F

gl_SUPERSAMPLE_SCALE_X_NV :: GLenum
gl_SUPERSAMPLE_SCALE_X_NV = 0x9372

gl_SUPERSAMPLE_SCALE_Y_NV :: GLenum
gl_SUPERSAMPLE_SCALE_Y_NV = 0x9373

gl_SURFACE_MAPPED_NV :: GLenum
gl_SURFACE_MAPPED_NV = 0x8700

gl_SURFACE_REGISTERED_NV :: GLenum
gl_SURFACE_REGISTERED_NV = 0x86FD

gl_SURFACE_STATE_NV :: GLenum
gl_SURFACE_STATE_NV = 0x86EB

gl_SWIZZLE_STQ_ATI :: GLenum
gl_SWIZZLE_STQ_ATI = 0x8977

gl_SWIZZLE_STQ_DQ_ATI :: GLenum
gl_SWIZZLE_STQ_DQ_ATI = 0x8979

gl_SWIZZLE_STRQ_ATI :: GLenum
gl_SWIZZLE_STRQ_ATI = 0x897A

gl_SWIZZLE_STRQ_DQ_ATI :: GLenum
gl_SWIZZLE_STRQ_DQ_ATI = 0x897B

gl_SWIZZLE_STR_ATI :: GLenum
gl_SWIZZLE_STR_ATI = 0x8976

gl_SWIZZLE_STR_DR_ATI :: GLenum
gl_SWIZZLE_STR_DR_ATI = 0x8978

gl_SYNC_CL_EVENT_ARB :: GLenum
gl_SYNC_CL_EVENT_ARB = 0x8240

gl_SYNC_CL_EVENT_COMPLETE_ARB :: GLenum
gl_SYNC_CL_EVENT_COMPLETE_ARB = 0x8241

gl_SYNC_CONDITION :: GLenum
gl_SYNC_CONDITION = 0x9113

gl_SYNC_CONDITION_APPLE :: GLenum
gl_SYNC_CONDITION_APPLE = 0x9113

gl_SYNC_FENCE :: GLenum
gl_SYNC_FENCE = 0x9116

gl_SYNC_FENCE_APPLE :: GLenum
gl_SYNC_FENCE_APPLE = 0x9116

gl_SYNC_FLAGS :: GLenum
gl_SYNC_FLAGS = 0x9115

gl_SYNC_FLAGS_APPLE :: GLenum
gl_SYNC_FLAGS_APPLE = 0x9115

gl_SYNC_FLUSH_COMMANDS_BIT :: GLbitfield
gl_SYNC_FLUSH_COMMANDS_BIT = 0x00000001

gl_SYNC_FLUSH_COMMANDS_BIT_APPLE :: GLbitfield
gl_SYNC_FLUSH_COMMANDS_BIT_APPLE = 0x00000001

gl_SYNC_GPU_COMMANDS_COMPLETE :: GLenum
gl_SYNC_GPU_COMMANDS_COMPLETE = 0x9117

gl_SYNC_GPU_COMMANDS_COMPLETE_APPLE :: GLenum
gl_SYNC_GPU_COMMANDS_COMPLETE_APPLE = 0x9117

gl_SYNC_OBJECT_APPLE :: GLenum
gl_SYNC_OBJECT_APPLE = 0x8A53

gl_SYNC_STATUS :: GLenum
gl_SYNC_STATUS = 0x9114

gl_SYNC_STATUS_APPLE :: GLenum
gl_SYNC_STATUS_APPLE = 0x9114

gl_SYNC_X11_FENCE_EXT :: GLenum
gl_SYNC_X11_FENCE_EXT = 0x90E1

gl_SYSTEM_FONT_NAME_NV :: GLenum
gl_SYSTEM_FONT_NAME_NV = 0x9073

gl_T :: GLenum
gl_T = 0x2001

gl_T2F_C3F_V3F :: GLenum
gl_T2F_C3F_V3F = 0x2A2A

gl_T2F_C4F_N3F_V3F :: GLenum
gl_T2F_C4F_N3F_V3F = 0x2A2C

gl_T2F_C4UB_V3F :: GLenum
gl_T2F_C4UB_V3F = 0x2A29

gl_T2F_IUI_N3F_V2F_EXT :: GLenum
gl_T2F_IUI_N3F_V2F_EXT = 0x81B3

gl_T2F_IUI_N3F_V3F_EXT :: GLenum
gl_T2F_IUI_N3F_V3F_EXT = 0x81B4

gl_T2F_IUI_V2F_EXT :: GLenum
gl_T2F_IUI_V2F_EXT = 0x81B1

gl_T2F_IUI_V3F_EXT :: GLenum
gl_T2F_IUI_V3F_EXT = 0x81B2

gl_T2F_N3F_V3F :: GLenum
gl_T2F_N3F_V3F = 0x2A2B

gl_T2F_V3F :: GLenum
gl_T2F_V3F = 0x2A27

gl_T4F_C4F_N3F_V4F :: GLenum
gl_T4F_C4F_N3F_V4F = 0x2A2D

gl_T4F_V4F :: GLenum
gl_T4F_V4F = 0x2A28

gl_TABLE_TOO_LARGE :: GLenum
gl_TABLE_TOO_LARGE = 0x8031

gl_TABLE_TOO_LARGE_EXT :: GLenum
gl_TABLE_TOO_LARGE_EXT = 0x8031

gl_TANGENT_ARRAY_EXT :: GLenum
gl_TANGENT_ARRAY_EXT = 0x8439

gl_TANGENT_ARRAY_POINTER_EXT :: GLenum
gl_TANGENT_ARRAY_POINTER_EXT = 0x8442

gl_TANGENT_ARRAY_STRIDE_EXT :: GLenum
gl_TANGENT_ARRAY_STRIDE_EXT = 0x843F

gl_TANGENT_ARRAY_TYPE_EXT :: GLenum
gl_TANGENT_ARRAY_TYPE_EXT = 0x843E

gl_TESSELLATION_FACTOR_AMD :: GLenum
gl_TESSELLATION_FACTOR_AMD = 0x9005

gl_TESSELLATION_MODE_AMD :: GLenum
gl_TESSELLATION_MODE_AMD = 0x9004

gl_TESS_CONTROL_OUTPUT_VERTICES :: GLenum
gl_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75

gl_TESS_CONTROL_OUTPUT_VERTICES_EXT :: GLenum
gl_TESS_CONTROL_OUTPUT_VERTICES_EXT = 0x8E75

gl_TESS_CONTROL_OUTPUT_VERTICES_OES :: GLenum
gl_TESS_CONTROL_OUTPUT_VERTICES_OES = 0x8E75

gl_TESS_CONTROL_PROGRAM_NV :: GLenum
gl_TESS_CONTROL_PROGRAM_NV = 0x891E

gl_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV :: GLenum
gl_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV = 0x8C74

gl_TESS_CONTROL_SHADER :: GLenum
gl_TESS_CONTROL_SHADER = 0x8E88

gl_TESS_CONTROL_SHADER_BIT :: GLbitfield
gl_TESS_CONTROL_SHADER_BIT = 0x00000008

gl_TESS_CONTROL_SHADER_BIT_EXT :: GLbitfield
gl_TESS_CONTROL_SHADER_BIT_EXT = 0x00000008

gl_TESS_CONTROL_SHADER_BIT_OES :: GLbitfield
gl_TESS_CONTROL_SHADER_BIT_OES = 0x00000008

gl_TESS_CONTROL_SHADER_EXT :: GLenum
gl_TESS_CONTROL_SHADER_EXT = 0x8E88

gl_TESS_CONTROL_SHADER_OES :: GLenum
gl_TESS_CONTROL_SHADER_OES = 0x8E88

gl_TESS_CONTROL_SHADER_PATCHES_ARB :: GLenum
gl_TESS_CONTROL_SHADER_PATCHES_ARB = 0x82F1

gl_TESS_CONTROL_SUBROUTINE :: GLenum
gl_TESS_CONTROL_SUBROUTINE = 0x92E9

gl_TESS_CONTROL_SUBROUTINE_UNIFORM :: GLenum
gl_TESS_CONTROL_SUBROUTINE_UNIFORM = 0x92EF

gl_TESS_CONTROL_TEXTURE :: GLenum
gl_TESS_CONTROL_TEXTURE = 0x829C

gl_TESS_EVALUATION_PROGRAM_NV :: GLenum
gl_TESS_EVALUATION_PROGRAM_NV = 0x891F

gl_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV :: GLenum
gl_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV = 0x8C75

gl_TESS_EVALUATION_SHADER :: GLenum
gl_TESS_EVALUATION_SHADER = 0x8E87

gl_TESS_EVALUATION_SHADER_BIT :: GLbitfield
gl_TESS_EVALUATION_SHADER_BIT = 0x00000010

gl_TESS_EVALUATION_SHADER_BIT_EXT :: GLbitfield
gl_TESS_EVALUATION_SHADER_BIT_EXT = 0x00000010

gl_TESS_EVALUATION_SHADER_BIT_OES :: GLbitfield
gl_TESS_EVALUATION_SHADER_BIT_OES = 0x00000010

gl_TESS_EVALUATION_SHADER_EXT :: GLenum
gl_TESS_EVALUATION_SHADER_EXT = 0x8E87

gl_TESS_EVALUATION_SHADER_INVOCATIONS_ARB :: GLenum
gl_TESS_EVALUATION_SHADER_INVOCATIONS_ARB = 0x82F2

gl_TESS_EVALUATION_SHADER_OES :: GLenum
gl_TESS_EVALUATION_SHADER_OES = 0x8E87

gl_TESS_EVALUATION_SUBROUTINE :: GLenum
gl_TESS_EVALUATION_SUBROUTINE = 0x92EA

gl_TESS_EVALUATION_SUBROUTINE_UNIFORM :: GLenum
gl_TESS_EVALUATION_SUBROUTINE_UNIFORM = 0x92F0

gl_TESS_EVALUATION_TEXTURE :: GLenum
gl_TESS_EVALUATION_TEXTURE = 0x829D

gl_TESS_GEN_MODE :: GLenum
gl_TESS_GEN_MODE = 0x8E76

gl_TESS_GEN_MODE_EXT :: GLenum
gl_TESS_GEN_MODE_EXT = 0x8E76

gl_TESS_GEN_MODE_OES :: GLenum
gl_TESS_GEN_MODE_OES = 0x8E76

gl_TESS_GEN_POINT_MODE :: GLenum
gl_TESS_GEN_POINT_MODE = 0x8E79

gl_TESS_GEN_POINT_MODE_EXT :: GLenum
gl_TESS_GEN_POINT_MODE_EXT = 0x8E79

gl_TESS_GEN_POINT_MODE_OES :: GLenum
gl_TESS_GEN_POINT_MODE_OES = 0x8E79

gl_TESS_GEN_SPACING :: GLenum
gl_TESS_GEN_SPACING = 0x8E77

gl_TESS_GEN_SPACING_EXT :: GLenum
gl_TESS_GEN_SPACING_EXT = 0x8E77

gl_TESS_GEN_SPACING_OES :: GLenum
gl_TESS_GEN_SPACING_OES = 0x8E77

gl_TESS_GEN_VERTEX_ORDER :: GLenum
gl_TESS_GEN_VERTEX_ORDER = 0x8E78

gl_TESS_GEN_VERTEX_ORDER_EXT :: GLenum
gl_TESS_GEN_VERTEX_ORDER_EXT = 0x8E78

gl_TESS_GEN_VERTEX_ORDER_OES :: GLenum
gl_TESS_GEN_VERTEX_ORDER_OES = 0x8E78

gl_TEXCOORD1_BIT_PGI :: GLbitfield
gl_TEXCOORD1_BIT_PGI = 0x10000000

gl_TEXCOORD2_BIT_PGI :: GLbitfield
gl_TEXCOORD2_BIT_PGI = 0x20000000

gl_TEXCOORD3_BIT_PGI :: GLbitfield
gl_TEXCOORD3_BIT_PGI = 0x40000000

gl_TEXCOORD4_BIT_PGI :: GLbitfield
gl_TEXCOORD4_BIT_PGI = 0x80000000

gl_TEXTURE :: GLenum
gl_TEXTURE = 0x1702

gl_TEXTURE0 :: GLenum
gl_TEXTURE0 = 0x84C0

gl_TEXTURE0_ARB :: GLenum
gl_TEXTURE0_ARB = 0x84C0

gl_TEXTURE1 :: GLenum
gl_TEXTURE1 = 0x84C1

gl_TEXTURE10 :: GLenum
gl_TEXTURE10 = 0x84CA

gl_TEXTURE10_ARB :: GLenum
gl_TEXTURE10_ARB = 0x84CA

gl_TEXTURE11 :: GLenum
gl_TEXTURE11 = 0x84CB

gl_TEXTURE11_ARB :: GLenum
gl_TEXTURE11_ARB = 0x84CB

gl_TEXTURE12 :: GLenum
gl_TEXTURE12 = 0x84CC

gl_TEXTURE12_ARB :: GLenum
gl_TEXTURE12_ARB = 0x84CC

gl_TEXTURE13 :: GLenum
gl_TEXTURE13 = 0x84CD

gl_TEXTURE13_ARB :: GLenum
gl_TEXTURE13_ARB = 0x84CD

gl_TEXTURE14 :: GLenum
gl_TEXTURE14 = 0x84CE

gl_TEXTURE14_ARB :: GLenum
gl_TEXTURE14_ARB = 0x84CE

gl_TEXTURE15 :: GLenum
gl_TEXTURE15 = 0x84CF

gl_TEXTURE15_ARB :: GLenum
gl_TEXTURE15_ARB = 0x84CF

gl_TEXTURE16 :: GLenum
gl_TEXTURE16 = 0x84D0

gl_TEXTURE16_ARB :: GLenum
gl_TEXTURE16_ARB = 0x84D0

gl_TEXTURE17 :: GLenum
gl_TEXTURE17 = 0x84D1

gl_TEXTURE17_ARB :: GLenum
gl_TEXTURE17_ARB = 0x84D1

gl_TEXTURE18 :: GLenum
gl_TEXTURE18 = 0x84D2

gl_TEXTURE18_ARB :: GLenum
gl_TEXTURE18_ARB = 0x84D2

gl_TEXTURE19 :: GLenum
gl_TEXTURE19 = 0x84D3

gl_TEXTURE19_ARB :: GLenum
gl_TEXTURE19_ARB = 0x84D3

gl_TEXTURE1_ARB :: GLenum
gl_TEXTURE1_ARB = 0x84C1

gl_TEXTURE2 :: GLenum
gl_TEXTURE2 = 0x84C2

gl_TEXTURE20 :: GLenum
gl_TEXTURE20 = 0x84D4

gl_TEXTURE20_ARB :: GLenum
gl_TEXTURE20_ARB = 0x84D4

gl_TEXTURE21 :: GLenum
gl_TEXTURE21 = 0x84D5

gl_TEXTURE21_ARB :: GLenum
gl_TEXTURE21_ARB = 0x84D5

gl_TEXTURE22 :: GLenum
gl_TEXTURE22 = 0x84D6

gl_TEXTURE22_ARB :: GLenum
gl_TEXTURE22_ARB = 0x84D6

gl_TEXTURE23 :: GLenum
gl_TEXTURE23 = 0x84D7

gl_TEXTURE23_ARB :: GLenum
gl_TEXTURE23_ARB = 0x84D7

gl_TEXTURE24 :: GLenum
gl_TEXTURE24 = 0x84D8

gl_TEXTURE24_ARB :: GLenum
gl_TEXTURE24_ARB = 0x84D8

gl_TEXTURE25 :: GLenum
gl_TEXTURE25 = 0x84D9

gl_TEXTURE25_ARB :: GLenum
gl_TEXTURE25_ARB = 0x84D9

gl_TEXTURE26 :: GLenum
gl_TEXTURE26 = 0x84DA

gl_TEXTURE26_ARB :: GLenum
gl_TEXTURE26_ARB = 0x84DA

gl_TEXTURE27 :: GLenum
gl_TEXTURE27 = 0x84DB

gl_TEXTURE27_ARB :: GLenum
gl_TEXTURE27_ARB = 0x84DB

gl_TEXTURE28 :: GLenum
gl_TEXTURE28 = 0x84DC

gl_TEXTURE28_ARB :: GLenum
gl_TEXTURE28_ARB = 0x84DC

gl_TEXTURE29 :: GLenum
gl_TEXTURE29 = 0x84DD

gl_TEXTURE29_ARB :: GLenum
gl_TEXTURE29_ARB = 0x84DD

gl_TEXTURE2_ARB :: GLenum
gl_TEXTURE2_ARB = 0x84C2

gl_TEXTURE3 :: GLenum
gl_TEXTURE3 = 0x84C3

gl_TEXTURE30 :: GLenum
gl_TEXTURE30 = 0x84DE

gl_TEXTURE30_ARB :: GLenum
gl_TEXTURE30_ARB = 0x84DE

gl_TEXTURE31 :: GLenum
gl_TEXTURE31 = 0x84DF

gl_TEXTURE31_ARB :: GLenum
gl_TEXTURE31_ARB = 0x84DF

gl_TEXTURE3_ARB :: GLenum
gl_TEXTURE3_ARB = 0x84C3

gl_TEXTURE4 :: GLenum
gl_TEXTURE4 = 0x84C4

gl_TEXTURE4_ARB :: GLenum
gl_TEXTURE4_ARB = 0x84C4

gl_TEXTURE5 :: GLenum
gl_TEXTURE5 = 0x84C5

gl_TEXTURE5_ARB :: GLenum
gl_TEXTURE5_ARB = 0x84C5

gl_TEXTURE6 :: GLenum
gl_TEXTURE6 = 0x84C6

gl_TEXTURE6_ARB :: GLenum
gl_TEXTURE6_ARB = 0x84C6

gl_TEXTURE7 :: GLenum
gl_TEXTURE7 = 0x84C7

gl_TEXTURE7_ARB :: GLenum
gl_TEXTURE7_ARB = 0x84C7

gl_TEXTURE8 :: GLenum
gl_TEXTURE8 = 0x84C8

gl_TEXTURE8_ARB :: GLenum
gl_TEXTURE8_ARB = 0x84C8

gl_TEXTURE9 :: GLenum
gl_TEXTURE9 = 0x84C9

gl_TEXTURE9_ARB :: GLenum
gl_TEXTURE9_ARB = 0x84C9

gl_TEXTURE_1D :: GLenum
gl_TEXTURE_1D = 0x0DE0

gl_TEXTURE_1D_ARRAY :: GLenum
gl_TEXTURE_1D_ARRAY = 0x8C18

gl_TEXTURE_1D_ARRAY_EXT :: GLenum
gl_TEXTURE_1D_ARRAY_EXT = 0x8C18

gl_TEXTURE_1D_BINDING_EXT :: GLenum
gl_TEXTURE_1D_BINDING_EXT = 0x8068

gl_TEXTURE_1D_STACK_BINDING_MESAX :: GLenum
gl_TEXTURE_1D_STACK_BINDING_MESAX = 0x875D

gl_TEXTURE_1D_STACK_MESAX :: GLenum
gl_TEXTURE_1D_STACK_MESAX = 0x8759

gl_TEXTURE_2D :: GLenum
gl_TEXTURE_2D = 0x0DE1

gl_TEXTURE_2D_ARRAY :: GLenum
gl_TEXTURE_2D_ARRAY = 0x8C1A

gl_TEXTURE_2D_ARRAY_EXT :: GLenum
gl_TEXTURE_2D_ARRAY_EXT = 0x8C1A

gl_TEXTURE_2D_BINDING_EXT :: GLenum
gl_TEXTURE_2D_BINDING_EXT = 0x8069

gl_TEXTURE_2D_MULTISAMPLE :: GLenum
gl_TEXTURE_2D_MULTISAMPLE = 0x9100

gl_TEXTURE_2D_MULTISAMPLE_ARRAY :: GLenum
gl_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102

gl_TEXTURE_2D_MULTISAMPLE_ARRAY_OES :: GLenum
gl_TEXTURE_2D_MULTISAMPLE_ARRAY_OES = 0x9102

gl_TEXTURE_2D_STACK_BINDING_MESAX :: GLenum
gl_TEXTURE_2D_STACK_BINDING_MESAX = 0x875E

gl_TEXTURE_2D_STACK_MESAX :: GLenum
gl_TEXTURE_2D_STACK_MESAX = 0x875A

gl_TEXTURE_3D :: GLenum
gl_TEXTURE_3D = 0x806F

gl_TEXTURE_3D_BINDING_EXT :: GLenum
gl_TEXTURE_3D_BINDING_EXT = 0x806A

gl_TEXTURE_3D_BINDING_OES :: GLenum
gl_TEXTURE_3D_BINDING_OES = 0x806A

gl_TEXTURE_3D_EXT :: GLenum
gl_TEXTURE_3D_EXT = 0x806F

gl_TEXTURE_3D_OES :: GLenum
gl_TEXTURE_3D_OES = 0x806F

gl_TEXTURE_4DSIZE_SGIS :: GLenum
gl_TEXTURE_4DSIZE_SGIS = 0x8136

gl_TEXTURE_4D_BINDING_SGIS :: GLenum
gl_TEXTURE_4D_BINDING_SGIS = 0x814F

gl_TEXTURE_4D_SGIS :: GLenum
gl_TEXTURE_4D_SGIS = 0x8134

gl_TEXTURE_ALPHA_MODULATE_IMG :: GLenum
gl_TEXTURE_ALPHA_MODULATE_IMG = 0x8C06

gl_TEXTURE_ALPHA_SIZE :: GLenum
gl_TEXTURE_ALPHA_SIZE = 0x805F

gl_TEXTURE_ALPHA_SIZE_EXT :: GLenum
gl_TEXTURE_ALPHA_SIZE_EXT = 0x805F

gl_TEXTURE_ALPHA_TYPE :: GLenum
gl_TEXTURE_ALPHA_TYPE = 0x8C13

gl_TEXTURE_ALPHA_TYPE_ARB :: GLenum
gl_TEXTURE_ALPHA_TYPE_ARB = 0x8C13

gl_TEXTURE_APPLICATION_MODE_EXT :: GLenum
gl_TEXTURE_APPLICATION_MODE_EXT = 0x834F

gl_TEXTURE_BASE_LEVEL :: GLenum
gl_TEXTURE_BASE_LEVEL = 0x813C

gl_TEXTURE_BASE_LEVEL_SGIS :: GLenum
gl_TEXTURE_BASE_LEVEL_SGIS = 0x813C

gl_TEXTURE_BINDING_1D :: GLenum
gl_TEXTURE_BINDING_1D = 0x8068

gl_TEXTURE_BINDING_1D_ARRAY :: GLenum
gl_TEXTURE_BINDING_1D_ARRAY = 0x8C1C

gl_TEXTURE_BINDING_1D_ARRAY_EXT :: GLenum
gl_TEXTURE_BINDING_1D_ARRAY_EXT = 0x8C1C

gl_TEXTURE_BINDING_2D :: GLenum
gl_TEXTURE_BINDING_2D = 0x8069

gl_TEXTURE_BINDING_2D_ARRAY :: GLenum
gl_TEXTURE_BINDING_2D_ARRAY = 0x8C1D

gl_TEXTURE_BINDING_2D_ARRAY_EXT :: GLenum
gl_TEXTURE_BINDING_2D_ARRAY_EXT = 0x8C1D

gl_TEXTURE_BINDING_2D_MULTISAMPLE :: GLenum
gl_TEXTURE_BINDING_2D_MULTISAMPLE = 0x9104

gl_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY :: GLenum
gl_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 0x9105

gl_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES :: GLenum
gl_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES = 0x9105

gl_TEXTURE_BINDING_3D :: GLenum
gl_TEXTURE_BINDING_3D = 0x806A

gl_TEXTURE_BINDING_3D_OES :: GLenum
gl_TEXTURE_BINDING_3D_OES = 0x806A

gl_TEXTURE_BINDING_BUFFER :: GLenum
gl_TEXTURE_BINDING_BUFFER = 0x8C2C

gl_TEXTURE_BINDING_BUFFER_ARB :: GLenum
gl_TEXTURE_BINDING_BUFFER_ARB = 0x8C2C

gl_TEXTURE_BINDING_BUFFER_EXT :: GLenum
gl_TEXTURE_BINDING_BUFFER_EXT = 0x8C2C

gl_TEXTURE_BINDING_BUFFER_OES :: GLenum
gl_TEXTURE_BINDING_BUFFER_OES = 0x8C2C

gl_TEXTURE_BINDING_CUBE_MAP :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP = 0x8514

gl_TEXTURE_BINDING_CUBE_MAP_ARB :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP_ARB = 0x8514

gl_TEXTURE_BINDING_CUBE_MAP_ARRAY :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP_ARRAY = 0x900A

gl_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB = 0x900A

gl_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT = 0x900A

gl_TEXTURE_BINDING_CUBE_MAP_ARRAY_OES :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP_ARRAY_OES = 0x900A

gl_TEXTURE_BINDING_CUBE_MAP_EXT :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP_EXT = 0x8514

gl_TEXTURE_BINDING_CUBE_MAP_OES :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP_OES = 0x8514

gl_TEXTURE_BINDING_EXTERNAL_OES :: GLenum
gl_TEXTURE_BINDING_EXTERNAL_OES = 0x8D67

gl_TEXTURE_BINDING_RECTANGLE :: GLenum
gl_TEXTURE_BINDING_RECTANGLE = 0x84F6

gl_TEXTURE_BINDING_RECTANGLE_ARB :: GLenum
gl_TEXTURE_BINDING_RECTANGLE_ARB = 0x84F6

gl_TEXTURE_BINDING_RECTANGLE_NV :: GLenum
gl_TEXTURE_BINDING_RECTANGLE_NV = 0x84F6

gl_TEXTURE_BINDING_RENDERBUFFER_NV :: GLenum
gl_TEXTURE_BINDING_RENDERBUFFER_NV = 0x8E53

gl_TEXTURE_BIT :: GLbitfield
gl_TEXTURE_BIT = 0x00040000

gl_TEXTURE_BLUE_SIZE :: GLenum
gl_TEXTURE_BLUE_SIZE = 0x805E

gl_TEXTURE_BLUE_SIZE_EXT :: GLenum
gl_TEXTURE_BLUE_SIZE_EXT = 0x805E

gl_TEXTURE_BLUE_TYPE :: GLenum
gl_TEXTURE_BLUE_TYPE = 0x8C12

gl_TEXTURE_BLUE_TYPE_ARB :: GLenum
gl_TEXTURE_BLUE_TYPE_ARB = 0x8C12

gl_TEXTURE_BORDER :: GLenum
gl_TEXTURE_BORDER = 0x1005

gl_TEXTURE_BORDER_COLOR :: GLenum
gl_TEXTURE_BORDER_COLOR = 0x1004

gl_TEXTURE_BORDER_COLOR_EXT :: GLenum
gl_TEXTURE_BORDER_COLOR_EXT = 0x1004

gl_TEXTURE_BORDER_COLOR_NV :: GLenum
gl_TEXTURE_BORDER_COLOR_NV = 0x1004

gl_TEXTURE_BORDER_COLOR_OES :: GLenum
gl_TEXTURE_BORDER_COLOR_OES = 0x1004

gl_TEXTURE_BORDER_VALUES_NV :: GLenum
gl_TEXTURE_BORDER_VALUES_NV = 0x871A

gl_TEXTURE_BUFFER :: GLenum
gl_TEXTURE_BUFFER = 0x8C2A

gl_TEXTURE_BUFFER_ARB :: GLenum
gl_TEXTURE_BUFFER_ARB = 0x8C2A

gl_TEXTURE_BUFFER_BINDING :: GLenum
gl_TEXTURE_BUFFER_BINDING = 0x8C2A

gl_TEXTURE_BUFFER_BINDING_EXT :: GLenum
gl_TEXTURE_BUFFER_BINDING_EXT = 0x8C2A

gl_TEXTURE_BUFFER_BINDING_OES :: GLenum
gl_TEXTURE_BUFFER_BINDING_OES = 0x8C2A

gl_TEXTURE_BUFFER_DATA_STORE_BINDING :: GLenum
gl_TEXTURE_BUFFER_DATA_STORE_BINDING = 0x8C2D

gl_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB :: GLenum
gl_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB = 0x8C2D

gl_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT :: GLenum
gl_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT = 0x8C2D

gl_TEXTURE_BUFFER_DATA_STORE_BINDING_OES :: GLenum
gl_TEXTURE_BUFFER_DATA_STORE_BINDING_OES = 0x8C2D

gl_TEXTURE_BUFFER_EXT :: GLenum
gl_TEXTURE_BUFFER_EXT = 0x8C2A

gl_TEXTURE_BUFFER_FORMAT_ARB :: GLenum
gl_TEXTURE_BUFFER_FORMAT_ARB = 0x8C2E

gl_TEXTURE_BUFFER_FORMAT_EXT :: GLenum
gl_TEXTURE_BUFFER_FORMAT_EXT = 0x8C2E

gl_TEXTURE_BUFFER_OES :: GLenum
gl_TEXTURE_BUFFER_OES = 0x8C2A

gl_TEXTURE_BUFFER_OFFSET :: GLenum
gl_TEXTURE_BUFFER_OFFSET = 0x919D

gl_TEXTURE_BUFFER_OFFSET_ALIGNMENT :: GLenum
gl_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 0x919F

gl_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT :: GLenum
gl_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT = 0x919F

gl_TEXTURE_BUFFER_OFFSET_ALIGNMENT_OES :: GLenum
gl_TEXTURE_BUFFER_OFFSET_ALIGNMENT_OES = 0x919F

gl_TEXTURE_BUFFER_OFFSET_EXT :: GLenum
gl_TEXTURE_BUFFER_OFFSET_EXT = 0x919D

gl_TEXTURE_BUFFER_OFFSET_OES :: GLenum
gl_TEXTURE_BUFFER_OFFSET_OES = 0x919D

gl_TEXTURE_BUFFER_SIZE :: GLenum
gl_TEXTURE_BUFFER_SIZE = 0x919E

gl_TEXTURE_BUFFER_SIZE_EXT :: GLenum
gl_TEXTURE_BUFFER_SIZE_EXT = 0x919E

gl_TEXTURE_BUFFER_SIZE_OES :: GLenum
gl_TEXTURE_BUFFER_SIZE_OES = 0x919E

gl_TEXTURE_CLIPMAP_CENTER_SGIX :: GLenum
gl_TEXTURE_CLIPMAP_CENTER_SGIX = 0x8171

gl_TEXTURE_CLIPMAP_DEPTH_SGIX :: GLenum
gl_TEXTURE_CLIPMAP_DEPTH_SGIX = 0x8176

gl_TEXTURE_CLIPMAP_FRAME_SGIX :: GLenum
gl_TEXTURE_CLIPMAP_FRAME_SGIX = 0x8172

gl_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX :: GLenum
gl_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = 0x8175

gl_TEXTURE_CLIPMAP_OFFSET_SGIX :: GLenum
gl_TEXTURE_CLIPMAP_OFFSET_SGIX = 0x8173

gl_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX :: GLenum
gl_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = 0x8174

gl_TEXTURE_COLOR_SAMPLES_NV :: GLenum
gl_TEXTURE_COLOR_SAMPLES_NV = 0x9046

gl_TEXTURE_COLOR_TABLE_SGI :: GLenum
gl_TEXTURE_COLOR_TABLE_SGI = 0x80BC

gl_TEXTURE_COLOR_WRITEMASK_SGIS :: GLenum
gl_TEXTURE_COLOR_WRITEMASK_SGIS = 0x81EF

gl_TEXTURE_COMPARE_FAIL_VALUE_ARB :: GLenum
gl_TEXTURE_COMPARE_FAIL_VALUE_ARB = 0x80BF

gl_TEXTURE_COMPARE_FUNC :: GLenum
gl_TEXTURE_COMPARE_FUNC = 0x884D

gl_TEXTURE_COMPARE_FUNC_ARB :: GLenum
gl_TEXTURE_COMPARE_FUNC_ARB = 0x884D

gl_TEXTURE_COMPARE_FUNC_EXT :: GLenum
gl_TEXTURE_COMPARE_FUNC_EXT = 0x884D

gl_TEXTURE_COMPARE_MODE :: GLenum
gl_TEXTURE_COMPARE_MODE = 0x884C

gl_TEXTURE_COMPARE_MODE_ARB :: GLenum
gl_TEXTURE_COMPARE_MODE_ARB = 0x884C

gl_TEXTURE_COMPARE_MODE_EXT :: GLenum
gl_TEXTURE_COMPARE_MODE_EXT = 0x884C

gl_TEXTURE_COMPARE_OPERATOR_SGIX :: GLenum
gl_TEXTURE_COMPARE_OPERATOR_SGIX = 0x819B

gl_TEXTURE_COMPARE_SGIX :: GLenum
gl_TEXTURE_COMPARE_SGIX = 0x819A

gl_TEXTURE_COMPONENTS :: GLenum
gl_TEXTURE_COMPONENTS = 0x1003

gl_TEXTURE_COMPRESSED :: GLenum
gl_TEXTURE_COMPRESSED = 0x86A1

gl_TEXTURE_COMPRESSED_ARB :: GLenum
gl_TEXTURE_COMPRESSED_ARB = 0x86A1

gl_TEXTURE_COMPRESSED_BLOCK_HEIGHT :: GLenum
gl_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 0x82B2

gl_TEXTURE_COMPRESSED_BLOCK_SIZE :: GLenum
gl_TEXTURE_COMPRESSED_BLOCK_SIZE = 0x82B3

gl_TEXTURE_COMPRESSED_BLOCK_WIDTH :: GLenum
gl_TEXTURE_COMPRESSED_BLOCK_WIDTH = 0x82B1

gl_TEXTURE_COMPRESSED_IMAGE_SIZE :: GLenum
gl_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0

gl_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB :: GLenum
gl_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = 0x86A0

gl_TEXTURE_COMPRESSION_HINT :: GLenum
gl_TEXTURE_COMPRESSION_HINT = 0x84EF

gl_TEXTURE_COMPRESSION_HINT_ARB :: GLenum
gl_TEXTURE_COMPRESSION_HINT_ARB = 0x84EF

gl_TEXTURE_CONSTANT_DATA_SUNX :: GLenum
gl_TEXTURE_CONSTANT_DATA_SUNX = 0x81D6

gl_TEXTURE_COORD_ARRAY :: GLenum
gl_TEXTURE_COORD_ARRAY = 0x8078

gl_TEXTURE_COORD_ARRAY_ADDRESS_NV :: GLenum
gl_TEXTURE_COORD_ARRAY_ADDRESS_NV = 0x8F25

gl_TEXTURE_COORD_ARRAY_BUFFER_BINDING :: GLenum
gl_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 0x889A

gl_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = 0x889A

gl_TEXTURE_COORD_ARRAY_COUNT_EXT :: GLenum
gl_TEXTURE_COORD_ARRAY_COUNT_EXT = 0x808B

gl_TEXTURE_COORD_ARRAY_EXT :: GLenum
gl_TEXTURE_COORD_ARRAY_EXT = 0x8078

gl_TEXTURE_COORD_ARRAY_LENGTH_NV :: GLenum
gl_TEXTURE_COORD_ARRAY_LENGTH_NV = 0x8F2F

gl_TEXTURE_COORD_ARRAY_LIST_IBM :: GLenum
gl_TEXTURE_COORD_ARRAY_LIST_IBM = 103074

gl_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM :: GLenum
gl_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM = 103084

gl_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL :: GLenum
gl_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F8

gl_TEXTURE_COORD_ARRAY_POINTER :: GLenum
gl_TEXTURE_COORD_ARRAY_POINTER = 0x8092

gl_TEXTURE_COORD_ARRAY_POINTER_EXT :: GLenum
gl_TEXTURE_COORD_ARRAY_POINTER_EXT = 0x8092

gl_TEXTURE_COORD_ARRAY_SIZE :: GLenum
gl_TEXTURE_COORD_ARRAY_SIZE = 0x8088

gl_TEXTURE_COORD_ARRAY_SIZE_EXT :: GLenum
gl_TEXTURE_COORD_ARRAY_SIZE_EXT = 0x8088

gl_TEXTURE_COORD_ARRAY_STRIDE :: GLenum
gl_TEXTURE_COORD_ARRAY_STRIDE = 0x808A

gl_TEXTURE_COORD_ARRAY_STRIDE_EXT :: GLenum
gl_TEXTURE_COORD_ARRAY_STRIDE_EXT = 0x808A

gl_TEXTURE_COORD_ARRAY_TYPE :: GLenum
gl_TEXTURE_COORD_ARRAY_TYPE = 0x8089

gl_TEXTURE_COORD_ARRAY_TYPE_EXT :: GLenum
gl_TEXTURE_COORD_ARRAY_TYPE_EXT = 0x8089

gl_TEXTURE_COORD_NV :: GLenum
gl_TEXTURE_COORD_NV = 0x8C79

gl_TEXTURE_COVERAGE_SAMPLES_NV :: GLenum
gl_TEXTURE_COVERAGE_SAMPLES_NV = 0x9045

gl_TEXTURE_CROP_RECT_OES :: GLenum
gl_TEXTURE_CROP_RECT_OES = 0x8B9D

gl_TEXTURE_CUBE_MAP :: GLenum
gl_TEXTURE_CUBE_MAP = 0x8513

gl_TEXTURE_CUBE_MAP_ARB :: GLenum
gl_TEXTURE_CUBE_MAP_ARB = 0x8513

gl_TEXTURE_CUBE_MAP_ARRAY :: GLenum
gl_TEXTURE_CUBE_MAP_ARRAY = 0x9009

gl_TEXTURE_CUBE_MAP_ARRAY_ARB :: GLenum
gl_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x9009

gl_TEXTURE_CUBE_MAP_ARRAY_EXT :: GLenum
gl_TEXTURE_CUBE_MAP_ARRAY_EXT = 0x9009

gl_TEXTURE_CUBE_MAP_ARRAY_OES :: GLenum
gl_TEXTURE_CUBE_MAP_ARRAY_OES = 0x9009

gl_TEXTURE_CUBE_MAP_EXT :: GLenum
gl_TEXTURE_CUBE_MAP_EXT = 0x8513

gl_TEXTURE_CUBE_MAP_NEGATIVE_X :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516

gl_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = 0x8516

gl_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT = 0x8516

gl_TEXTURE_CUBE_MAP_NEGATIVE_X_OES :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_X_OES = 0x8516

gl_TEXTURE_CUBE_MAP_NEGATIVE_Y :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518

gl_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = 0x8518

gl_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT = 0x8518

gl_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES = 0x8518

gl_TEXTURE_CUBE_MAP_NEGATIVE_Z :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A

gl_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = 0x851A

gl_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT = 0x851A

gl_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES = 0x851A

gl_TEXTURE_CUBE_MAP_OES :: GLenum
gl_TEXTURE_CUBE_MAP_OES = 0x8513

gl_TEXTURE_CUBE_MAP_POSITIVE_X :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515

gl_TEXTURE_CUBE_MAP_POSITIVE_X_ARB :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = 0x8515

gl_TEXTURE_CUBE_MAP_POSITIVE_X_EXT :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_X_EXT = 0x8515

gl_TEXTURE_CUBE_MAP_POSITIVE_X_OES :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_X_OES = 0x8515

gl_TEXTURE_CUBE_MAP_POSITIVE_Y :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517

gl_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = 0x8517

gl_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT = 0x8517

gl_TEXTURE_CUBE_MAP_POSITIVE_Y_OES :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Y_OES = 0x8517

gl_TEXTURE_CUBE_MAP_POSITIVE_Z :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519

gl_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = 0x8519

gl_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT = 0x8519

gl_TEXTURE_CUBE_MAP_POSITIVE_Z_OES :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Z_OES = 0x8519

gl_TEXTURE_CUBE_MAP_SEAMLESS :: GLenum
gl_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F

gl_TEXTURE_DEFORMATION_BIT_SGIX :: GLbitfield
gl_TEXTURE_DEFORMATION_BIT_SGIX = 0x00000001

gl_TEXTURE_DEFORMATION_SGIX :: GLenum
gl_TEXTURE_DEFORMATION_SGIX = 0x8195

gl_TEXTURE_DEPTH :: GLenum
gl_TEXTURE_DEPTH = 0x8071

gl_TEXTURE_DEPTH_EXT :: GLenum
gl_TEXTURE_DEPTH_EXT = 0x8071

gl_TEXTURE_DEPTH_QCOM :: GLenum
gl_TEXTURE_DEPTH_QCOM = 0x8BD4

gl_TEXTURE_DEPTH_SIZE :: GLenum
gl_TEXTURE_DEPTH_SIZE = 0x884A

gl_TEXTURE_DEPTH_SIZE_ARB :: GLenum
gl_TEXTURE_DEPTH_SIZE_ARB = 0x884A

gl_TEXTURE_DEPTH_TYPE :: GLenum
gl_TEXTURE_DEPTH_TYPE = 0x8C16

gl_TEXTURE_DEPTH_TYPE_ARB :: GLenum
gl_TEXTURE_DEPTH_TYPE_ARB = 0x8C16

gl_TEXTURE_DS_SIZE_NV :: GLenum
gl_TEXTURE_DS_SIZE_NV = 0x871D

gl_TEXTURE_DT_SIZE_NV :: GLenum
gl_TEXTURE_DT_SIZE_NV = 0x871E

gl_TEXTURE_ENV :: GLenum
gl_TEXTURE_ENV = 0x2300

gl_TEXTURE_ENV_BIAS_SGIX :: GLenum
gl_TEXTURE_ENV_BIAS_SGIX = 0x80BE

gl_TEXTURE_ENV_COLOR :: GLenum
gl_TEXTURE_ENV_COLOR = 0x2201

gl_TEXTURE_ENV_MODE :: GLenum
gl_TEXTURE_ENV_MODE = 0x2200

gl_TEXTURE_EXTERNAL_OES :: GLenum
gl_TEXTURE_EXTERNAL_OES = 0x8D65

gl_TEXTURE_FETCH_BARRIER_BIT :: GLbitfield
gl_TEXTURE_FETCH_BARRIER_BIT = 0x00000008

gl_TEXTURE_FETCH_BARRIER_BIT_EXT :: GLbitfield
gl_TEXTURE_FETCH_BARRIER_BIT_EXT = 0x00000008

gl_TEXTURE_FILTER4_SIZE_SGIS :: GLenum
gl_TEXTURE_FILTER4_SIZE_SGIS = 0x8147

gl_TEXTURE_FILTER_CONTROL :: GLenum
gl_TEXTURE_FILTER_CONTROL = 0x8500

gl_TEXTURE_FILTER_CONTROL_EXT :: GLenum
gl_TEXTURE_FILTER_CONTROL_EXT = 0x8500

gl_TEXTURE_FIXED_SAMPLE_LOCATIONS :: GLenum
gl_TEXTURE_FIXED_SAMPLE_LOCATIONS = 0x9107

gl_TEXTURE_FLOAT_COMPONENTS_NV :: GLenum
gl_TEXTURE_FLOAT_COMPONENTS_NV = 0x888C

gl_TEXTURE_FORMAT_QCOM :: GLenum
gl_TEXTURE_FORMAT_QCOM = 0x8BD6

gl_TEXTURE_FREE_MEMORY_ATI :: GLenum
gl_TEXTURE_FREE_MEMORY_ATI = 0x87FC

gl_TEXTURE_GATHER :: GLenum
gl_TEXTURE_GATHER = 0x82A2

gl_TEXTURE_GATHER_SHADOW :: GLenum
gl_TEXTURE_GATHER_SHADOW = 0x82A3

gl_TEXTURE_GEN_MODE :: GLenum
gl_TEXTURE_GEN_MODE = 0x2500

gl_TEXTURE_GEN_MODE_OES :: GLenum
gl_TEXTURE_GEN_MODE_OES = 0x2500

gl_TEXTURE_GEN_Q :: GLenum
gl_TEXTURE_GEN_Q = 0x0C63

gl_TEXTURE_GEN_R :: GLenum
gl_TEXTURE_GEN_R = 0x0C62

gl_TEXTURE_GEN_S :: GLenum
gl_TEXTURE_GEN_S = 0x0C60

gl_TEXTURE_GEN_STR_OES :: GLenum
gl_TEXTURE_GEN_STR_OES = 0x8D60

gl_TEXTURE_GEN_T :: GLenum
gl_TEXTURE_GEN_T = 0x0C61

gl_TEXTURE_GEQUAL_R_SGIX :: GLenum
gl_TEXTURE_GEQUAL_R_SGIX = 0x819D

gl_TEXTURE_GREEN_SIZE :: GLenum
gl_TEXTURE_GREEN_SIZE = 0x805D

gl_TEXTURE_GREEN_SIZE_EXT :: GLenum
gl_TEXTURE_GREEN_SIZE_EXT = 0x805D

gl_TEXTURE_GREEN_TYPE :: GLenum
gl_TEXTURE_GREEN_TYPE = 0x8C11

gl_TEXTURE_GREEN_TYPE_ARB :: GLenum
gl_TEXTURE_GREEN_TYPE_ARB = 0x8C11

gl_TEXTURE_HEIGHT :: GLenum
gl_TEXTURE_HEIGHT = 0x1001

gl_TEXTURE_HEIGHT_QCOM :: GLenum
gl_TEXTURE_HEIGHT_QCOM = 0x8BD3

gl_TEXTURE_HI_SIZE_NV :: GLenum
gl_TEXTURE_HI_SIZE_NV = 0x871B

gl_TEXTURE_IMAGE_FORMAT :: GLenum
gl_TEXTURE_IMAGE_FORMAT = 0x828F

gl_TEXTURE_IMAGE_TYPE :: GLenum
gl_TEXTURE_IMAGE_TYPE = 0x8290

gl_TEXTURE_IMAGE_VALID_QCOM :: GLenum
gl_TEXTURE_IMAGE_VALID_QCOM = 0x8BD8

gl_TEXTURE_IMMUTABLE_FORMAT :: GLenum
gl_TEXTURE_IMMUTABLE_FORMAT = 0x912F

gl_TEXTURE_IMMUTABLE_FORMAT_EXT :: GLenum
gl_TEXTURE_IMMUTABLE_FORMAT_EXT = 0x912F

gl_TEXTURE_IMMUTABLE_LEVELS :: GLenum
gl_TEXTURE_IMMUTABLE_LEVELS = 0x82DF

gl_TEXTURE_INDEX_SIZE_EXT :: GLenum
gl_TEXTURE_INDEX_SIZE_EXT = 0x80ED

gl_TEXTURE_INTENSITY_SIZE :: GLenum
gl_TEXTURE_INTENSITY_SIZE = 0x8061

gl_TEXTURE_INTENSITY_SIZE_EXT :: GLenum
gl_TEXTURE_INTENSITY_SIZE_EXT = 0x8061

gl_TEXTURE_INTENSITY_TYPE :: GLenum
gl_TEXTURE_INTENSITY_TYPE = 0x8C15

gl_TEXTURE_INTENSITY_TYPE_ARB :: GLenum
gl_TEXTURE_INTENSITY_TYPE_ARB = 0x8C15

gl_TEXTURE_INTERNAL_FORMAT :: GLenum
gl_TEXTURE_INTERNAL_FORMAT = 0x1003

gl_TEXTURE_INTERNAL_FORMAT_QCOM :: GLenum
gl_TEXTURE_INTERNAL_FORMAT_QCOM = 0x8BD5

gl_TEXTURE_LEQUAL_R_SGIX :: GLenum
gl_TEXTURE_LEQUAL_R_SGIX = 0x819C

gl_TEXTURE_LIGHTING_MODE_HP :: GLenum
gl_TEXTURE_LIGHTING_MODE_HP = 0x8167

gl_TEXTURE_LIGHT_EXT :: GLenum
gl_TEXTURE_LIGHT_EXT = 0x8350

gl_TEXTURE_LOD_BIAS :: GLenum
gl_TEXTURE_LOD_BIAS = 0x8501

gl_TEXTURE_LOD_BIAS_EXT :: GLenum
gl_TEXTURE_LOD_BIAS_EXT = 0x8501

gl_TEXTURE_LOD_BIAS_R_SGIX :: GLenum
gl_TEXTURE_LOD_BIAS_R_SGIX = 0x8190

gl_TEXTURE_LOD_BIAS_S_SGIX :: GLenum
gl_TEXTURE_LOD_BIAS_S_SGIX = 0x818E

gl_TEXTURE_LOD_BIAS_T_SGIX :: GLenum
gl_TEXTURE_LOD_BIAS_T_SGIX = 0x818F

gl_TEXTURE_LO_SIZE_NV :: GLenum
gl_TEXTURE_LO_SIZE_NV = 0x871C

gl_TEXTURE_LUMINANCE_SIZE :: GLenum
gl_TEXTURE_LUMINANCE_SIZE = 0x8060

gl_TEXTURE_LUMINANCE_SIZE_EXT :: GLenum
gl_TEXTURE_LUMINANCE_SIZE_EXT = 0x8060

gl_TEXTURE_LUMINANCE_TYPE :: GLenum
gl_TEXTURE_LUMINANCE_TYPE = 0x8C14

gl_TEXTURE_LUMINANCE_TYPE_ARB :: GLenum
gl_TEXTURE_LUMINANCE_TYPE_ARB = 0x8C14

gl_TEXTURE_MAG_FILTER :: GLenum
gl_TEXTURE_MAG_FILTER = 0x2800

gl_TEXTURE_MAG_SIZE_NV :: GLenum
gl_TEXTURE_MAG_SIZE_NV = 0x871F

gl_TEXTURE_MATERIAL_FACE_EXT :: GLenum
gl_TEXTURE_MATERIAL_FACE_EXT = 0x8351

gl_TEXTURE_MATERIAL_PARAMETER_EXT :: GLenum
gl_TEXTURE_MATERIAL_PARAMETER_EXT = 0x8352

gl_TEXTURE_MATRIX :: GLenum
gl_TEXTURE_MATRIX = 0x0BA8

gl_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES :: GLenum
gl_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES = 0x898F

gl_TEXTURE_MAX_ANISOTROPY_EXT :: GLenum
gl_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE

gl_TEXTURE_MAX_CLAMP_R_SGIX :: GLenum
gl_TEXTURE_MAX_CLAMP_R_SGIX = 0x836B

gl_TEXTURE_MAX_CLAMP_S_SGIX :: GLenum
gl_TEXTURE_MAX_CLAMP_S_SGIX = 0x8369

gl_TEXTURE_MAX_CLAMP_T_SGIX :: GLenum
gl_TEXTURE_MAX_CLAMP_T_SGIX = 0x836A

gl_TEXTURE_MAX_LEVEL :: GLenum
gl_TEXTURE_MAX_LEVEL = 0x813D

gl_TEXTURE_MAX_LEVEL_APPLE :: GLenum
gl_TEXTURE_MAX_LEVEL_APPLE = 0x813D

gl_TEXTURE_MAX_LEVEL_SGIS :: GLenum
gl_TEXTURE_MAX_LEVEL_SGIS = 0x813D

gl_TEXTURE_MAX_LOD :: GLenum
gl_TEXTURE_MAX_LOD = 0x813B

gl_TEXTURE_MAX_LOD_SGIS :: GLenum
gl_TEXTURE_MAX_LOD_SGIS = 0x813B

gl_TEXTURE_MEMORY_LAYOUT_INTEL :: GLenum
gl_TEXTURE_MEMORY_LAYOUT_INTEL = 0x83FF

gl_TEXTURE_MIN_FILTER :: GLenum
gl_TEXTURE_MIN_FILTER = 0x2801

gl_TEXTURE_MIN_LOD :: GLenum
gl_TEXTURE_MIN_LOD = 0x813A

gl_TEXTURE_MIN_LOD_SGIS :: GLenum
gl_TEXTURE_MIN_LOD_SGIS = 0x813A

gl_TEXTURE_MULTI_BUFFER_HINT_SGIX :: GLenum
gl_TEXTURE_MULTI_BUFFER_HINT_SGIX = 0x812E

gl_TEXTURE_NORMAL_EXT :: GLenum
gl_TEXTURE_NORMAL_EXT = 0x85AF

gl_TEXTURE_NUM_LEVELS_QCOM :: GLenum
gl_TEXTURE_NUM_LEVELS_QCOM = 0x8BD9

gl_TEXTURE_OBJECT_VALID_QCOM :: GLenum
gl_TEXTURE_OBJECT_VALID_QCOM = 0x8BDB

gl_TEXTURE_POST_SPECULAR_HP :: GLenum
gl_TEXTURE_POST_SPECULAR_HP = 0x8168

gl_TEXTURE_PRE_SPECULAR_HP :: GLenum
gl_TEXTURE_PRE_SPECULAR_HP = 0x8169

gl_TEXTURE_PRIORITY :: GLenum
gl_TEXTURE_PRIORITY = 0x8066

gl_TEXTURE_PRIORITY_EXT :: GLenum
gl_TEXTURE_PRIORITY_EXT = 0x8066

gl_TEXTURE_RANGE_LENGTH_APPLE :: GLenum
gl_TEXTURE_RANGE_LENGTH_APPLE = 0x85B7

gl_TEXTURE_RANGE_POINTER_APPLE :: GLenum
gl_TEXTURE_RANGE_POINTER_APPLE = 0x85B8

gl_TEXTURE_RECTANGLE :: GLenum
gl_TEXTURE_RECTANGLE = 0x84F5

gl_TEXTURE_RECTANGLE_ARB :: GLenum
gl_TEXTURE_RECTANGLE_ARB = 0x84F5

gl_TEXTURE_RECTANGLE_NV :: GLenum
gl_TEXTURE_RECTANGLE_NV = 0x84F5

gl_TEXTURE_RED_SIZE :: GLenum
gl_TEXTURE_RED_SIZE = 0x805C

gl_TEXTURE_RED_SIZE_EXT :: GLenum
gl_TEXTURE_RED_SIZE_EXT = 0x805C

gl_TEXTURE_RED_TYPE :: GLenum
gl_TEXTURE_RED_TYPE = 0x8C10

gl_TEXTURE_RED_TYPE_ARB :: GLenum
gl_TEXTURE_RED_TYPE_ARB = 0x8C10

gl_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV :: GLenum
gl_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV = 0x8E54

gl_TEXTURE_RENDERBUFFER_NV :: GLenum
gl_TEXTURE_RENDERBUFFER_NV = 0x8E55

gl_TEXTURE_RESIDENT :: GLenum
gl_TEXTURE_RESIDENT = 0x8067

gl_TEXTURE_RESIDENT_EXT :: GLenum
gl_TEXTURE_RESIDENT_EXT = 0x8067

gl_TEXTURE_SAMPLES :: GLenum
gl_TEXTURE_SAMPLES = 0x9106

gl_TEXTURE_SAMPLES_IMG :: GLenum
gl_TEXTURE_SAMPLES_IMG = 0x9136

gl_TEXTURE_SHADER_NV :: GLenum
gl_TEXTURE_SHADER_NV = 0x86DE

gl_TEXTURE_SHADOW :: GLenum
gl_TEXTURE_SHADOW = 0x82A1

gl_TEXTURE_SHARED_SIZE :: GLenum
gl_TEXTURE_SHARED_SIZE = 0x8C3F

gl_TEXTURE_SHARED_SIZE_EXT :: GLenum
gl_TEXTURE_SHARED_SIZE_EXT = 0x8C3F

gl_TEXTURE_SPARSE_ARB :: GLenum
gl_TEXTURE_SPARSE_ARB = 0x91A6

gl_TEXTURE_SRGB_DECODE_EXT :: GLenum
gl_TEXTURE_SRGB_DECODE_EXT = 0x8A48

gl_TEXTURE_STACK_DEPTH :: GLenum
gl_TEXTURE_STACK_DEPTH = 0x0BA5

gl_TEXTURE_STENCIL_SIZE :: GLenum
gl_TEXTURE_STENCIL_SIZE = 0x88F1

gl_TEXTURE_STENCIL_SIZE_EXT :: GLenum
gl_TEXTURE_STENCIL_SIZE_EXT = 0x88F1

gl_TEXTURE_STORAGE_HINT_APPLE :: GLenum
gl_TEXTURE_STORAGE_HINT_APPLE = 0x85BC

gl_TEXTURE_STORAGE_SPARSE_BIT_AMD :: GLbitfield
gl_TEXTURE_STORAGE_SPARSE_BIT_AMD = 0x00000001

gl_TEXTURE_SWIZZLE_A :: GLenum
gl_TEXTURE_SWIZZLE_A = 0x8E45

gl_TEXTURE_SWIZZLE_A_EXT :: GLenum
gl_TEXTURE_SWIZZLE_A_EXT = 0x8E45

gl_TEXTURE_SWIZZLE_B :: GLenum
gl_TEXTURE_SWIZZLE_B = 0x8E44

gl_TEXTURE_SWIZZLE_B_EXT :: GLenum
gl_TEXTURE_SWIZZLE_B_EXT = 0x8E44

gl_TEXTURE_SWIZZLE_G :: GLenum
gl_TEXTURE_SWIZZLE_G = 0x8E43

gl_TEXTURE_SWIZZLE_G_EXT :: GLenum
gl_TEXTURE_SWIZZLE_G_EXT = 0x8E43

gl_TEXTURE_SWIZZLE_R :: GLenum
gl_TEXTURE_SWIZZLE_R = 0x8E42

gl_TEXTURE_SWIZZLE_RGBA :: GLenum
gl_TEXTURE_SWIZZLE_RGBA = 0x8E46

gl_TEXTURE_SWIZZLE_RGBA_EXT :: GLenum
gl_TEXTURE_SWIZZLE_RGBA_EXT = 0x8E46

gl_TEXTURE_SWIZZLE_R_EXT :: GLenum
gl_TEXTURE_SWIZZLE_R_EXT = 0x8E42

gl_TEXTURE_TARGET :: GLenum
gl_TEXTURE_TARGET = 0x1006

gl_TEXTURE_TARGET_QCOM :: GLenum
gl_TEXTURE_TARGET_QCOM = 0x8BDA

gl_TEXTURE_TOO_LARGE_EXT :: GLenum
gl_TEXTURE_TOO_LARGE_EXT = 0x8065

gl_TEXTURE_TYPE_QCOM :: GLenum
gl_TEXTURE_TYPE_QCOM = 0x8BD7

gl_TEXTURE_UNSIGNED_REMAP_MODE_NV :: GLenum
gl_TEXTURE_UNSIGNED_REMAP_MODE_NV = 0x888F

gl_TEXTURE_UPDATE_BARRIER_BIT :: GLbitfield
gl_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100

gl_TEXTURE_UPDATE_BARRIER_BIT_EXT :: GLbitfield
gl_TEXTURE_UPDATE_BARRIER_BIT_EXT = 0x00000100

gl_TEXTURE_USAGE_ANGLE :: GLenum
gl_TEXTURE_USAGE_ANGLE = 0x93A2

gl_TEXTURE_VIEW :: GLenum
gl_TEXTURE_VIEW = 0x82B5

gl_TEXTURE_VIEW_MIN_LAYER :: GLenum
gl_TEXTURE_VIEW_MIN_LAYER = 0x82DD

gl_TEXTURE_VIEW_MIN_LAYER_EXT :: GLenum
gl_TEXTURE_VIEW_MIN_LAYER_EXT = 0x82DD

gl_TEXTURE_VIEW_MIN_LAYER_OES :: GLenum
gl_TEXTURE_VIEW_MIN_LAYER_OES = 0x82DD

gl_TEXTURE_VIEW_MIN_LEVEL :: GLenum
gl_TEXTURE_VIEW_MIN_LEVEL = 0x82DB

gl_TEXTURE_VIEW_MIN_LEVEL_EXT :: GLenum
gl_TEXTURE_VIEW_MIN_LEVEL_EXT = 0x82DB

gl_TEXTURE_VIEW_MIN_LEVEL_OES :: GLenum
gl_TEXTURE_VIEW_MIN_LEVEL_OES = 0x82DB

gl_TEXTURE_VIEW_NUM_LAYERS :: GLenum
gl_TEXTURE_VIEW_NUM_LAYERS = 0x82DE

gl_TEXTURE_VIEW_NUM_LAYERS_EXT :: GLenum
gl_TEXTURE_VIEW_NUM_LAYERS_EXT = 0x82DE

gl_TEXTURE_VIEW_NUM_LAYERS_OES :: GLenum
gl_TEXTURE_VIEW_NUM_LAYERS_OES = 0x82DE

gl_TEXTURE_VIEW_NUM_LEVELS :: GLenum
gl_TEXTURE_VIEW_NUM_LEVELS = 0x82DC

gl_TEXTURE_VIEW_NUM_LEVELS_EXT :: GLenum
gl_TEXTURE_VIEW_NUM_LEVELS_EXT = 0x82DC

gl_TEXTURE_VIEW_NUM_LEVELS_OES :: GLenum
gl_TEXTURE_VIEW_NUM_LEVELS_OES = 0x82DC

gl_TEXTURE_WIDTH :: GLenum
gl_TEXTURE_WIDTH = 0x1000

gl_TEXTURE_WIDTH_QCOM :: GLenum
gl_TEXTURE_WIDTH_QCOM = 0x8BD2

gl_TEXTURE_WRAP_Q_SGIS :: GLenum
gl_TEXTURE_WRAP_Q_SGIS = 0x8137

gl_TEXTURE_WRAP_R :: GLenum
gl_TEXTURE_WRAP_R = 0x8072

gl_TEXTURE_WRAP_R_EXT :: GLenum
gl_TEXTURE_WRAP_R_EXT = 0x8072

gl_TEXTURE_WRAP_R_OES :: GLenum
gl_TEXTURE_WRAP_R_OES = 0x8072

gl_TEXTURE_WRAP_S :: GLenum
gl_TEXTURE_WRAP_S = 0x2802

gl_TEXTURE_WRAP_T :: GLenum
gl_TEXTURE_WRAP_T = 0x2803

gl_TEXT_FRAGMENT_SHADER_ATI :: GLenum
gl_TEXT_FRAGMENT_SHADER_ATI = 0x8200

gl_TIMEOUT_EXPIRED :: GLenum
gl_TIMEOUT_EXPIRED = 0x911B

gl_TIMEOUT_EXPIRED_APPLE :: GLenum
gl_TIMEOUT_EXPIRED_APPLE = 0x911B

gl_TIMEOUT_IGNORED :: GLuint64
gl_TIMEOUT_IGNORED = 0xFFFFFFFFFFFFFFFF

gl_TIMEOUT_IGNORED_APPLE :: GLuint64
gl_TIMEOUT_IGNORED_APPLE = 0xFFFFFFFFFFFFFFFF

gl_TIMESTAMP :: GLenum
gl_TIMESTAMP = 0x8E28

gl_TIMESTAMP_EXT :: GLenum
gl_TIMESTAMP_EXT = 0x8E28

gl_TIME_ELAPSED :: GLenum
gl_TIME_ELAPSED = 0x88BF

gl_TIME_ELAPSED_EXT :: GLenum
gl_TIME_ELAPSED_EXT = 0x88BF

gl_TOP_LEVEL_ARRAY_SIZE :: GLenum
gl_TOP_LEVEL_ARRAY_SIZE = 0x930C

gl_TOP_LEVEL_ARRAY_STRIDE :: GLenum
gl_TOP_LEVEL_ARRAY_STRIDE = 0x930D

gl_TRACE_ALL_BITS_MESA :: GLbitfield
gl_TRACE_ALL_BITS_MESA = 0xFFFF

gl_TRACE_ARRAYS_BIT_MESA :: GLbitfield
gl_TRACE_ARRAYS_BIT_MESA = 0x0004

gl_TRACE_ERRORS_BIT_MESA :: GLbitfield
gl_TRACE_ERRORS_BIT_MESA = 0x0020

gl_TRACE_MASK_MESA :: GLenum
gl_TRACE_MASK_MESA = 0x8755

gl_TRACE_NAME_MESA :: GLenum
gl_TRACE_NAME_MESA = 0x8756

gl_TRACE_OPERATIONS_BIT_MESA :: GLbitfield
gl_TRACE_OPERATIONS_BIT_MESA = 0x0001

gl_TRACE_PIXELS_BIT_MESA :: GLbitfield
gl_TRACE_PIXELS_BIT_MESA = 0x0010

gl_TRACE_PRIMITIVES_BIT_MESA :: GLbitfield
gl_TRACE_PRIMITIVES_BIT_MESA = 0x0002

gl_TRACE_TEXTURES_BIT_MESA :: GLbitfield
gl_TRACE_TEXTURES_BIT_MESA = 0x0008

gl_TRACK_MATRIX_NV :: GLenum
gl_TRACK_MATRIX_NV = 0x8648

gl_TRACK_MATRIX_TRANSFORM_NV :: GLenum
gl_TRACK_MATRIX_TRANSFORM_NV = 0x8649

gl_TRANSFORM_BIT :: GLbitfield
gl_TRANSFORM_BIT = 0x00001000

gl_TRANSFORM_FEEDBACK :: GLenum
gl_TRANSFORM_FEEDBACK = 0x8E22

gl_TRANSFORM_FEEDBACK_ACTIVE :: GLenum
gl_TRANSFORM_FEEDBACK_ACTIVE = 0x8E24

gl_TRANSFORM_FEEDBACK_ATTRIBS_NV :: GLenum
gl_TRANSFORM_FEEDBACK_ATTRIBS_NV = 0x8C7E

gl_TRANSFORM_FEEDBACK_BARRIER_BIT :: GLbitfield
gl_TRANSFORM_FEEDBACK_BARRIER_BIT = 0x00000800

gl_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT :: GLbitfield
gl_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT = 0x00000800

gl_TRANSFORM_FEEDBACK_BINDING :: GLenum
gl_TRANSFORM_FEEDBACK_BINDING = 0x8E25

gl_TRANSFORM_FEEDBACK_BINDING_NV :: GLenum
gl_TRANSFORM_FEEDBACK_BINDING_NV = 0x8E25

gl_TRANSFORM_FEEDBACK_BUFFER :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E

gl_TRANSFORM_FEEDBACK_BUFFER_ACTIVE :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 0x8E24

gl_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV = 0x8E24

gl_TRANSFORM_FEEDBACK_BUFFER_BINDING :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_BINDING = 0x8C8F

gl_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = 0x8C8F

gl_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 0x8C8F

gl_TRANSFORM_FEEDBACK_BUFFER_EXT :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_EXT = 0x8C8E

gl_TRANSFORM_FEEDBACK_BUFFER_INDEX :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_INDEX = 0x934B

gl_TRANSFORM_FEEDBACK_BUFFER_MODE :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F

gl_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = 0x8C7F

gl_TRANSFORM_FEEDBACK_BUFFER_MODE_NV :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 0x8C7F

gl_TRANSFORM_FEEDBACK_BUFFER_NV :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_NV = 0x8C8E

gl_TRANSFORM_FEEDBACK_BUFFER_PAUSED :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 0x8E23

gl_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV = 0x8E23

gl_TRANSFORM_FEEDBACK_BUFFER_SIZE :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_SIZE = 0x8C85

gl_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = 0x8C85

gl_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = 0x8C85

gl_TRANSFORM_FEEDBACK_BUFFER_START :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_START = 0x8C84

gl_TRANSFORM_FEEDBACK_BUFFER_START_EXT :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_START_EXT = 0x8C84

gl_TRANSFORM_FEEDBACK_BUFFER_START_NV :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_START_NV = 0x8C84

gl_TRANSFORM_FEEDBACK_BUFFER_STRIDE :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 0x934C

gl_TRANSFORM_FEEDBACK_NV :: GLenum
gl_TRANSFORM_FEEDBACK_NV = 0x8E22

gl_TRANSFORM_FEEDBACK_OVERFLOW_ARB :: GLenum
gl_TRANSFORM_FEEDBACK_OVERFLOW_ARB = 0x82EC

gl_TRANSFORM_FEEDBACK_PAUSED :: GLenum
gl_TRANSFORM_FEEDBACK_PAUSED = 0x8E23

gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN :: GLenum
gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88

gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT :: GLenum
gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = 0x8C88

gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV :: GLenum
gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 0x8C88

gl_TRANSFORM_FEEDBACK_RECORD_NV :: GLenum
gl_TRANSFORM_FEEDBACK_RECORD_NV = 0x8C86

gl_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB :: GLenum
gl_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB = 0x82ED

gl_TRANSFORM_FEEDBACK_VARYING :: GLenum
gl_TRANSFORM_FEEDBACK_VARYING = 0x92F4

gl_TRANSFORM_FEEDBACK_VARYINGS :: GLenum
gl_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83

gl_TRANSFORM_FEEDBACK_VARYINGS_EXT :: GLenum
gl_TRANSFORM_FEEDBACK_VARYINGS_EXT = 0x8C83

gl_TRANSFORM_FEEDBACK_VARYINGS_NV :: GLenum
gl_TRANSFORM_FEEDBACK_VARYINGS_NV = 0x8C83

gl_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH :: GLenum
gl_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 0x8C76

gl_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT :: GLenum
gl_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = 0x8C76

gl_TRANSFORM_HINT_APPLE :: GLenum
gl_TRANSFORM_HINT_APPLE = 0x85B1

gl_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE :: GLenum
gl_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE = 0x93A0

gl_TRANSLATE_2D_NV :: GLenum
gl_TRANSLATE_2D_NV = 0x9090

gl_TRANSLATE_3D_NV :: GLenum
gl_TRANSLATE_3D_NV = 0x9091

gl_TRANSLATE_X_NV :: GLenum
gl_TRANSLATE_X_NV = 0x908E

gl_TRANSLATE_Y_NV :: GLenum
gl_TRANSLATE_Y_NV = 0x908F

gl_TRANSPOSE_AFFINE_2D_NV :: GLenum
gl_TRANSPOSE_AFFINE_2D_NV = 0x9096

gl_TRANSPOSE_AFFINE_3D_NV :: GLenum
gl_TRANSPOSE_AFFINE_3D_NV = 0x9098

gl_TRANSPOSE_COLOR_MATRIX :: GLenum
gl_TRANSPOSE_COLOR_MATRIX = 0x84E6

gl_TRANSPOSE_COLOR_MATRIX_ARB :: GLenum
gl_TRANSPOSE_COLOR_MATRIX_ARB = 0x84E6

gl_TRANSPOSE_CURRENT_MATRIX_ARB :: GLenum
gl_TRANSPOSE_CURRENT_MATRIX_ARB = 0x88B7

gl_TRANSPOSE_MODELVIEW_MATRIX :: GLenum
gl_TRANSPOSE_MODELVIEW_MATRIX = 0x84E3

gl_TRANSPOSE_MODELVIEW_MATRIX_ARB :: GLenum
gl_TRANSPOSE_MODELVIEW_MATRIX_ARB = 0x84E3

gl_TRANSPOSE_NV :: GLenum
gl_TRANSPOSE_NV = 0x862C

gl_TRANSPOSE_PROGRAM_MATRIX_EXT :: GLenum
gl_TRANSPOSE_PROGRAM_MATRIX_EXT = 0x8E2E

gl_TRANSPOSE_PROJECTION_MATRIX :: GLenum
gl_TRANSPOSE_PROJECTION_MATRIX = 0x84E4

gl_TRANSPOSE_PROJECTION_MATRIX_ARB :: GLenum
gl_TRANSPOSE_PROJECTION_MATRIX_ARB = 0x84E4

gl_TRANSPOSE_TEXTURE_MATRIX :: GLenum
gl_TRANSPOSE_TEXTURE_MATRIX = 0x84E5

gl_TRANSPOSE_TEXTURE_MATRIX_ARB :: GLenum
gl_TRANSPOSE_TEXTURE_MATRIX_ARB = 0x84E5

gl_TRIANGLES :: GLenum
gl_TRIANGLES = 0x0004

gl_TRIANGLES_ADJACENCY :: GLenum
gl_TRIANGLES_ADJACENCY = 0x000C

gl_TRIANGLES_ADJACENCY_ARB :: GLenum
gl_TRIANGLES_ADJACENCY_ARB = 0x000C

gl_TRIANGLES_ADJACENCY_EXT :: GLenum
gl_TRIANGLES_ADJACENCY_EXT = 0x000C

gl_TRIANGLES_ADJACENCY_OES :: GLenum
gl_TRIANGLES_ADJACENCY_OES = 0x000C

gl_TRIANGLE_FAN :: GLenum
gl_TRIANGLE_FAN = 0x0006

gl_TRIANGLE_LIST_SUN :: GLenum
gl_TRIANGLE_LIST_SUN = 0x81D7

gl_TRIANGLE_MESH_SUN :: GLenum
gl_TRIANGLE_MESH_SUN = 0x8615

gl_TRIANGLE_STRIP :: GLenum
gl_TRIANGLE_STRIP = 0x0005

gl_TRIANGLE_STRIP_ADJACENCY :: GLenum
gl_TRIANGLE_STRIP_ADJACENCY = 0x000D

gl_TRIANGLE_STRIP_ADJACENCY_ARB :: GLenum
gl_TRIANGLE_STRIP_ADJACENCY_ARB = 0x000D

gl_TRIANGLE_STRIP_ADJACENCY_EXT :: GLenum
gl_TRIANGLE_STRIP_ADJACENCY_EXT = 0x000D

gl_TRIANGLE_STRIP_ADJACENCY_OES :: GLenum
gl_TRIANGLE_STRIP_ADJACENCY_OES = 0x000D

gl_TRIANGULAR_NV :: GLenum
gl_TRIANGULAR_NV = 0x90A5

gl_TRUE :: GLenum
gl_TRUE = 1

gl_TYPE :: GLenum
gl_TYPE = 0x92FA

gl_UNCORRELATED_NV :: GLenum
gl_UNCORRELATED_NV = 0x9282

gl_UNDEFINED_APPLE :: GLenum
gl_UNDEFINED_APPLE = 0x8A1C

gl_UNDEFINED_VERTEX :: GLenum
gl_UNDEFINED_VERTEX = 0x8260

gl_UNDEFINED_VERTEX_EXT :: GLenum
gl_UNDEFINED_VERTEX_EXT = 0x8260

gl_UNDEFINED_VERTEX_OES :: GLenum
gl_UNDEFINED_VERTEX_OES = 0x8260

gl_UNIFORM :: GLenum
gl_UNIFORM = 0x92E1

gl_UNIFORM_ARRAY_STRIDE :: GLenum
gl_UNIFORM_ARRAY_STRIDE = 0x8A3C

gl_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX :: GLenum
gl_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA

gl_UNIFORM_BARRIER_BIT :: GLbitfield
gl_UNIFORM_BARRIER_BIT = 0x00000004

gl_UNIFORM_BARRIER_BIT_EXT :: GLbitfield
gl_UNIFORM_BARRIER_BIT_EXT = 0x00000004

gl_UNIFORM_BLOCK :: GLenum
gl_UNIFORM_BLOCK = 0x92E2

gl_UNIFORM_BLOCK_ACTIVE_UNIFORMS :: GLenum
gl_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42

gl_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES :: GLenum
gl_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43

gl_UNIFORM_BLOCK_BINDING :: GLenum
gl_UNIFORM_BLOCK_BINDING = 0x8A3F

gl_UNIFORM_BLOCK_DATA_SIZE :: GLenum
gl_UNIFORM_BLOCK_DATA_SIZE = 0x8A40

gl_UNIFORM_BLOCK_INDEX :: GLenum
gl_UNIFORM_BLOCK_INDEX = 0x8A3A

gl_UNIFORM_BLOCK_NAME_LENGTH :: GLenum
gl_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41

gl_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER :: GLenum
gl_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC

gl_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER :: GLenum
gl_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46

gl_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER :: GLenum
gl_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45

gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER :: GLenum
gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0

gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER :: GLenum
gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1

gl_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER :: GLenum
gl_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44

gl_UNIFORM_BUFFER :: GLenum
gl_UNIFORM_BUFFER = 0x8A11

gl_UNIFORM_BUFFER_ADDRESS_NV :: GLenum
gl_UNIFORM_BUFFER_ADDRESS_NV = 0x936F

gl_UNIFORM_BUFFER_BINDING :: GLenum
gl_UNIFORM_BUFFER_BINDING = 0x8A28

gl_UNIFORM_BUFFER_BINDING_EXT :: GLenum
gl_UNIFORM_BUFFER_BINDING_EXT = 0x8DEF

gl_UNIFORM_BUFFER_EXT :: GLenum
gl_UNIFORM_BUFFER_EXT = 0x8DEE

gl_UNIFORM_BUFFER_LENGTH_NV :: GLenum
gl_UNIFORM_BUFFER_LENGTH_NV = 0x9370

gl_UNIFORM_BUFFER_OFFSET_ALIGNMENT :: GLenum
gl_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 0x8A34

gl_UNIFORM_BUFFER_SIZE :: GLenum
gl_UNIFORM_BUFFER_SIZE = 0x8A2A

gl_UNIFORM_BUFFER_START :: GLenum
gl_UNIFORM_BUFFER_START = 0x8A29

gl_UNIFORM_BUFFER_UNIFIED_NV :: GLenum
gl_UNIFORM_BUFFER_UNIFIED_NV = 0x936E

gl_UNIFORM_IS_ROW_MAJOR :: GLenum
gl_UNIFORM_IS_ROW_MAJOR = 0x8A3E

gl_UNIFORM_MATRIX_STRIDE :: GLenum
gl_UNIFORM_MATRIX_STRIDE = 0x8A3D

gl_UNIFORM_NAME_LENGTH :: GLenum
gl_UNIFORM_NAME_LENGTH = 0x8A39

gl_UNIFORM_OFFSET :: GLenum
gl_UNIFORM_OFFSET = 0x8A3B

gl_UNIFORM_SIZE :: GLenum
gl_UNIFORM_SIZE = 0x8A38

gl_UNIFORM_TYPE :: GLenum
gl_UNIFORM_TYPE = 0x8A37

gl_UNKNOWN_CONTEXT_RESET :: GLenum
gl_UNKNOWN_CONTEXT_RESET = 0x8255

gl_UNKNOWN_CONTEXT_RESET_ARB :: GLenum
gl_UNKNOWN_CONTEXT_RESET_ARB = 0x8255

gl_UNKNOWN_CONTEXT_RESET_EXT :: GLenum
gl_UNKNOWN_CONTEXT_RESET_EXT = 0x8255

gl_UNKNOWN_CONTEXT_RESET_KHR :: GLenum
gl_UNKNOWN_CONTEXT_RESET_KHR = 0x8255

gl_UNPACK_ALIGNMENT :: GLenum
gl_UNPACK_ALIGNMENT = 0x0CF5

gl_UNPACK_CLIENT_STORAGE_APPLE :: GLenum
gl_UNPACK_CLIENT_STORAGE_APPLE = 0x85B2

gl_UNPACK_CMYK_HINT_EXT :: GLenum
gl_UNPACK_CMYK_HINT_EXT = 0x800F

gl_UNPACK_COLORSPACE_CONVERSION_WEBGL :: GLenum
gl_UNPACK_COLORSPACE_CONVERSION_WEBGL = 0x9243

gl_UNPACK_COMPRESSED_BLOCK_DEPTH :: GLenum
gl_UNPACK_COMPRESSED_BLOCK_DEPTH = 0x9129

gl_UNPACK_COMPRESSED_BLOCK_HEIGHT :: GLenum
gl_UNPACK_COMPRESSED_BLOCK_HEIGHT = 0x9128

gl_UNPACK_COMPRESSED_BLOCK_SIZE :: GLenum
gl_UNPACK_COMPRESSED_BLOCK_SIZE = 0x912A

gl_UNPACK_COMPRESSED_BLOCK_WIDTH :: GLenum
gl_UNPACK_COMPRESSED_BLOCK_WIDTH = 0x9127

gl_UNPACK_COMPRESSED_SIZE_SGIX :: GLenum
gl_UNPACK_COMPRESSED_SIZE_SGIX = 0x831A

gl_UNPACK_CONSTANT_DATA_SUNX :: GLenum
gl_UNPACK_CONSTANT_DATA_SUNX = 0x81D5

gl_UNPACK_FLIP_Y_WEBGL :: GLenum
gl_UNPACK_FLIP_Y_WEBGL = 0x9240

gl_UNPACK_IMAGE_DEPTH_SGIS :: GLenum
gl_UNPACK_IMAGE_DEPTH_SGIS = 0x8133

gl_UNPACK_IMAGE_HEIGHT :: GLenum
gl_UNPACK_IMAGE_HEIGHT = 0x806E

gl_UNPACK_IMAGE_HEIGHT_EXT :: GLenum
gl_UNPACK_IMAGE_HEIGHT_EXT = 0x806E

gl_UNPACK_LSB_FIRST :: GLenum
gl_UNPACK_LSB_FIRST = 0x0CF1

gl_UNPACK_PREMULTIPLY_ALPHA_WEBGL :: GLenum
gl_UNPACK_PREMULTIPLY_ALPHA_WEBGL = 0x9241

gl_UNPACK_RESAMPLE_OML :: GLenum
gl_UNPACK_RESAMPLE_OML = 0x8985

gl_UNPACK_RESAMPLE_SGIX :: GLenum
gl_UNPACK_RESAMPLE_SGIX = 0x842F

gl_UNPACK_ROW_BYTES_APPLE :: GLenum
gl_UNPACK_ROW_BYTES_APPLE = 0x8A16

gl_UNPACK_ROW_LENGTH :: GLenum
gl_UNPACK_ROW_LENGTH = 0x0CF2

gl_UNPACK_ROW_LENGTH_EXT :: GLenum
gl_UNPACK_ROW_LENGTH_EXT = 0x0CF2

gl_UNPACK_SKIP_IMAGES :: GLenum
gl_UNPACK_SKIP_IMAGES = 0x806D

gl_UNPACK_SKIP_IMAGES_EXT :: GLenum
gl_UNPACK_SKIP_IMAGES_EXT = 0x806D

gl_UNPACK_SKIP_PIXELS :: GLenum
gl_UNPACK_SKIP_PIXELS = 0x0CF4

gl_UNPACK_SKIP_PIXELS_EXT :: GLenum
gl_UNPACK_SKIP_PIXELS_EXT = 0x0CF4

gl_UNPACK_SKIP_ROWS :: GLenum
gl_UNPACK_SKIP_ROWS = 0x0CF3

gl_UNPACK_SKIP_ROWS_EXT :: GLenum
gl_UNPACK_SKIP_ROWS_EXT = 0x0CF3

gl_UNPACK_SKIP_VOLUMES_SGIS :: GLenum
gl_UNPACK_SKIP_VOLUMES_SGIS = 0x8132

gl_UNPACK_SUBSAMPLE_RATE_SGIX :: GLenum
gl_UNPACK_SUBSAMPLE_RATE_SGIX = 0x85A1

gl_UNPACK_SWAP_BYTES :: GLenum
gl_UNPACK_SWAP_BYTES = 0x0CF0

gl_UNSIGNALED :: GLenum
gl_UNSIGNALED = 0x9118

gl_UNSIGNALED_APPLE :: GLenum
gl_UNSIGNALED_APPLE = 0x9118

gl_UNSIGNED_BYTE :: GLenum
gl_UNSIGNED_BYTE = 0x1401

gl_UNSIGNED_BYTE_2_3_3_REV :: GLenum
gl_UNSIGNED_BYTE_2_3_3_REV = 0x8362

gl_UNSIGNED_BYTE_2_3_3_REV_EXT :: GLenum
gl_UNSIGNED_BYTE_2_3_3_REV_EXT = 0x8362

gl_UNSIGNED_BYTE_3_3_2 :: GLenum
gl_UNSIGNED_BYTE_3_3_2 = 0x8032

gl_UNSIGNED_BYTE_3_3_2_EXT :: GLenum
gl_UNSIGNED_BYTE_3_3_2_EXT = 0x8032

gl_UNSIGNED_IDENTITY_NV :: GLenum
gl_UNSIGNED_IDENTITY_NV = 0x8536

gl_UNSIGNED_INT :: GLenum
gl_UNSIGNED_INT = 0x1405

gl_UNSIGNED_INT16_NV :: GLenum
gl_UNSIGNED_INT16_NV = 0x8FF0

gl_UNSIGNED_INT16_VEC2_NV :: GLenum
gl_UNSIGNED_INT16_VEC2_NV = 0x8FF1

gl_UNSIGNED_INT16_VEC3_NV :: GLenum
gl_UNSIGNED_INT16_VEC3_NV = 0x8FF2

gl_UNSIGNED_INT16_VEC4_NV :: GLenum
gl_UNSIGNED_INT16_VEC4_NV = 0x8FF3

gl_UNSIGNED_INT64_AMD :: GLenum
gl_UNSIGNED_INT64_AMD = 0x8BC2

gl_UNSIGNED_INT64_ARB :: GLenum
gl_UNSIGNED_INT64_ARB = 0x140F

gl_UNSIGNED_INT64_NV :: GLenum
gl_UNSIGNED_INT64_NV = 0x140F

gl_UNSIGNED_INT64_VEC2_NV :: GLenum
gl_UNSIGNED_INT64_VEC2_NV = 0x8FF5

gl_UNSIGNED_INT64_VEC3_NV :: GLenum
gl_UNSIGNED_INT64_VEC3_NV = 0x8FF6

gl_UNSIGNED_INT64_VEC4_NV :: GLenum
gl_UNSIGNED_INT64_VEC4_NV = 0x8FF7

gl_UNSIGNED_INT8_NV :: GLenum
gl_UNSIGNED_INT8_NV = 0x8FEC

gl_UNSIGNED_INT8_VEC2_NV :: GLenum
gl_UNSIGNED_INT8_VEC2_NV = 0x8FED

gl_UNSIGNED_INT8_VEC3_NV :: GLenum
gl_UNSIGNED_INT8_VEC3_NV = 0x8FEE

gl_UNSIGNED_INT8_VEC4_NV :: GLenum
gl_UNSIGNED_INT8_VEC4_NV = 0x8FEF

gl_UNSIGNED_INT_10F_11F_11F_REV :: GLenum
gl_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B

gl_UNSIGNED_INT_10F_11F_11F_REV_APPLE :: GLenum
gl_UNSIGNED_INT_10F_11F_11F_REV_APPLE = 0x8C3B

gl_UNSIGNED_INT_10F_11F_11F_REV_EXT :: GLenum
gl_UNSIGNED_INT_10F_11F_11F_REV_EXT = 0x8C3B

gl_UNSIGNED_INT_10_10_10_2 :: GLenum
gl_UNSIGNED_INT_10_10_10_2 = 0x8036

gl_UNSIGNED_INT_10_10_10_2_EXT :: GLenum
gl_UNSIGNED_INT_10_10_10_2_EXT = 0x8036

gl_UNSIGNED_INT_10_10_10_2_OES :: GLenum
gl_UNSIGNED_INT_10_10_10_2_OES = 0x8DF6

gl_UNSIGNED_INT_24_8 :: GLenum
gl_UNSIGNED_INT_24_8 = 0x84FA

gl_UNSIGNED_INT_24_8_EXT :: GLenum
gl_UNSIGNED_INT_24_8_EXT = 0x84FA

gl_UNSIGNED_INT_24_8_MESA :: GLenum
gl_UNSIGNED_INT_24_8_MESA = 0x8751

gl_UNSIGNED_INT_24_8_NV :: GLenum
gl_UNSIGNED_INT_24_8_NV = 0x84FA

gl_UNSIGNED_INT_24_8_OES :: GLenum
gl_UNSIGNED_INT_24_8_OES = 0x84FA

gl_UNSIGNED_INT_2_10_10_10_REV :: GLenum
gl_UNSIGNED_INT_2_10_10_10_REV = 0x8368

gl_UNSIGNED_INT_2_10_10_10_REV_EXT :: GLenum
gl_UNSIGNED_INT_2_10_10_10_REV_EXT = 0x8368

gl_UNSIGNED_INT_5_9_9_9_REV :: GLenum
gl_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E

gl_UNSIGNED_INT_5_9_9_9_REV_APPLE :: GLenum
gl_UNSIGNED_INT_5_9_9_9_REV_APPLE = 0x8C3E

gl_UNSIGNED_INT_5_9_9_9_REV_EXT :: GLenum
gl_UNSIGNED_INT_5_9_9_9_REV_EXT = 0x8C3E

gl_UNSIGNED_INT_8_24_REV_MESA :: GLenum
gl_UNSIGNED_INT_8_24_REV_MESA = 0x8752

gl_UNSIGNED_INT_8_8_8_8 :: GLenum
gl_UNSIGNED_INT_8_8_8_8 = 0x8035

gl_UNSIGNED_INT_8_8_8_8_EXT :: GLenum
gl_UNSIGNED_INT_8_8_8_8_EXT = 0x8035

gl_UNSIGNED_INT_8_8_8_8_REV :: GLenum
gl_UNSIGNED_INT_8_8_8_8_REV = 0x8367

gl_UNSIGNED_INT_8_8_8_8_REV_EXT :: GLenum
gl_UNSIGNED_INT_8_8_8_8_REV_EXT = 0x8367

gl_UNSIGNED_INT_8_8_S8_S8_REV_NV :: GLenum
gl_UNSIGNED_INT_8_8_S8_S8_REV_NV = 0x86DB

gl_UNSIGNED_INT_ATOMIC_COUNTER :: GLenum
gl_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB

gl_UNSIGNED_INT_IMAGE_1D :: GLenum
gl_UNSIGNED_INT_IMAGE_1D = 0x9062

gl_UNSIGNED_INT_IMAGE_1D_ARRAY :: GLenum
gl_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068

gl_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT = 0x9068

gl_UNSIGNED_INT_IMAGE_1D_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_1D_EXT = 0x9062

gl_UNSIGNED_INT_IMAGE_2D :: GLenum
gl_UNSIGNED_INT_IMAGE_2D = 0x9063

gl_UNSIGNED_INT_IMAGE_2D_ARRAY :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069

gl_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT = 0x9069

gl_UNSIGNED_INT_IMAGE_2D_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_EXT = 0x9063

gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B

gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C

gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x906C

gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT = 0x906B

gl_UNSIGNED_INT_IMAGE_2D_RECT :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065

gl_UNSIGNED_INT_IMAGE_2D_RECT_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_2D_RECT_EXT = 0x9065

gl_UNSIGNED_INT_IMAGE_3D :: GLenum
gl_UNSIGNED_INT_IMAGE_3D = 0x9064

gl_UNSIGNED_INT_IMAGE_3D_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_3D_EXT = 0x9064

gl_UNSIGNED_INT_IMAGE_BUFFER :: GLenum
gl_UNSIGNED_INT_IMAGE_BUFFER = 0x9067

gl_UNSIGNED_INT_IMAGE_BUFFER_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_BUFFER_EXT = 0x9067

gl_UNSIGNED_INT_IMAGE_BUFFER_OES :: GLenum
gl_UNSIGNED_INT_IMAGE_BUFFER_OES = 0x9067

gl_UNSIGNED_INT_IMAGE_CUBE :: GLenum
gl_UNSIGNED_INT_IMAGE_CUBE = 0x9066

gl_UNSIGNED_INT_IMAGE_CUBE_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_CUBE_EXT = 0x9066

gl_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY :: GLenum
gl_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A

gl_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT :: GLenum
gl_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT = 0x906A

gl_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_OES :: GLenum
gl_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_OES = 0x906A

gl_UNSIGNED_INT_S8_S8_8_8_NV :: GLenum
gl_UNSIGNED_INT_S8_S8_8_8_NV = 0x86DA

gl_UNSIGNED_INT_SAMPLER_1D :: GLenum
gl_UNSIGNED_INT_SAMPLER_1D = 0x8DD1

gl_UNSIGNED_INT_SAMPLER_1D_ARRAY :: GLenum
gl_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6

gl_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT = 0x8DD6

gl_UNSIGNED_INT_SAMPLER_1D_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_1D_EXT = 0x8DD1

gl_UNSIGNED_INT_SAMPLER_2D :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D = 0x8DD2

gl_UNSIGNED_INT_SAMPLER_2D_ARRAY :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7

gl_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT = 0x8DD7

gl_UNSIGNED_INT_SAMPLER_2D_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_EXT = 0x8DD2

gl_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A

gl_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D

gl_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910D

gl_UNSIGNED_INT_SAMPLER_2D_RECT :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5

gl_UNSIGNED_INT_SAMPLER_2D_RECT_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_RECT_EXT = 0x8DD5

gl_UNSIGNED_INT_SAMPLER_3D :: GLenum
gl_UNSIGNED_INT_SAMPLER_3D = 0x8DD3

gl_UNSIGNED_INT_SAMPLER_3D_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_3D_EXT = 0x8DD3

gl_UNSIGNED_INT_SAMPLER_BUFFER :: GLenum
gl_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8

gl_UNSIGNED_INT_SAMPLER_BUFFER_AMD :: GLenum
gl_UNSIGNED_INT_SAMPLER_BUFFER_AMD = 0x9003

gl_UNSIGNED_INT_SAMPLER_BUFFER_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_BUFFER_EXT = 0x8DD8

gl_UNSIGNED_INT_SAMPLER_BUFFER_OES :: GLenum
gl_UNSIGNED_INT_SAMPLER_BUFFER_OES = 0x8DD8

gl_UNSIGNED_INT_SAMPLER_CUBE :: GLenum
gl_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4

gl_UNSIGNED_INT_SAMPLER_CUBE_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_CUBE_EXT = 0x8DD4

gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY :: GLenum
gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900F

gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB :: GLenum
gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900F

gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT :: GLenum
gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900F

gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_OES :: GLenum
gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900F

gl_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV :: GLenum
gl_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV = 0x8E58

gl_UNSIGNED_INT_VEC2 :: GLenum
gl_UNSIGNED_INT_VEC2 = 0x8DC6

gl_UNSIGNED_INT_VEC2_EXT :: GLenum
gl_UNSIGNED_INT_VEC2_EXT = 0x8DC6

gl_UNSIGNED_INT_VEC3 :: GLenum
gl_UNSIGNED_INT_VEC3 = 0x8DC7

gl_UNSIGNED_INT_VEC3_EXT :: GLenum
gl_UNSIGNED_INT_VEC3_EXT = 0x8DC7

gl_UNSIGNED_INT_VEC4 :: GLenum
gl_UNSIGNED_INT_VEC4 = 0x8DC8

gl_UNSIGNED_INT_VEC4_EXT :: GLenum
gl_UNSIGNED_INT_VEC4_EXT = 0x8DC8

gl_UNSIGNED_INVERT_NV :: GLenum
gl_UNSIGNED_INVERT_NV = 0x8537

gl_UNSIGNED_NORMALIZED :: GLenum
gl_UNSIGNED_NORMALIZED = 0x8C17

gl_UNSIGNED_NORMALIZED_ARB :: GLenum
gl_UNSIGNED_NORMALIZED_ARB = 0x8C17

gl_UNSIGNED_NORMALIZED_EXT :: GLenum
gl_UNSIGNED_NORMALIZED_EXT = 0x8C17

gl_UNSIGNED_SHORT :: GLenum
gl_UNSIGNED_SHORT = 0x1403

gl_UNSIGNED_SHORT_15_1_MESA :: GLenum
gl_UNSIGNED_SHORT_15_1_MESA = 0x8753

gl_UNSIGNED_SHORT_1_15_REV_MESA :: GLenum
gl_UNSIGNED_SHORT_1_15_REV_MESA = 0x8754

gl_UNSIGNED_SHORT_1_5_5_5_REV :: GLenum
gl_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366

gl_UNSIGNED_SHORT_1_5_5_5_REV_EXT :: GLenum
gl_UNSIGNED_SHORT_1_5_5_5_REV_EXT = 0x8366

gl_UNSIGNED_SHORT_4_4_4_4 :: GLenum
gl_UNSIGNED_SHORT_4_4_4_4 = 0x8033

gl_UNSIGNED_SHORT_4_4_4_4_EXT :: GLenum
gl_UNSIGNED_SHORT_4_4_4_4_EXT = 0x8033

gl_UNSIGNED_SHORT_4_4_4_4_REV :: GLenum
gl_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365

gl_UNSIGNED_SHORT_4_4_4_4_REV_EXT :: GLenum
gl_UNSIGNED_SHORT_4_4_4_4_REV_EXT = 0x8365

gl_UNSIGNED_SHORT_4_4_4_4_REV_IMG :: GLenum
gl_UNSIGNED_SHORT_4_4_4_4_REV_IMG = 0x8365

gl_UNSIGNED_SHORT_5_5_5_1 :: GLenum
gl_UNSIGNED_SHORT_5_5_5_1 = 0x8034

gl_UNSIGNED_SHORT_5_5_5_1_EXT :: GLenum
gl_UNSIGNED_SHORT_5_5_5_1_EXT = 0x8034

gl_UNSIGNED_SHORT_5_6_5 :: GLenum
gl_UNSIGNED_SHORT_5_6_5 = 0x8363

gl_UNSIGNED_SHORT_5_6_5_EXT :: GLenum
gl_UNSIGNED_SHORT_5_6_5_EXT = 0x8363

gl_UNSIGNED_SHORT_5_6_5_REV :: GLenum
gl_UNSIGNED_SHORT_5_6_5_REV = 0x8364

gl_UNSIGNED_SHORT_5_6_5_REV_EXT :: GLenum
gl_UNSIGNED_SHORT_5_6_5_REV_EXT = 0x8364

gl_UNSIGNED_SHORT_8_8_APPLE :: GLenum
gl_UNSIGNED_SHORT_8_8_APPLE = 0x85BA

gl_UNSIGNED_SHORT_8_8_MESA :: GLenum
gl_UNSIGNED_SHORT_8_8_MESA = 0x85BA

gl_UNSIGNED_SHORT_8_8_REV_APPLE :: GLenum
gl_UNSIGNED_SHORT_8_8_REV_APPLE = 0x85BB

gl_UNSIGNED_SHORT_8_8_REV_MESA :: GLenum
gl_UNSIGNED_SHORT_8_8_REV_MESA = 0x85BB

gl_UPPER_LEFT :: GLenum
gl_UPPER_LEFT = 0x8CA2

gl_USE_MISSING_GLYPH_NV :: GLenum
gl_USE_MISSING_GLYPH_NV = 0x90AA

gl_UTF16_NV :: GLenum
gl_UTF16_NV = 0x909B

gl_UTF8_NV :: GLenum
gl_UTF8_NV = 0x909A

gl_V2F :: GLenum
gl_V2F = 0x2A20

gl_V3F :: GLenum
gl_V3F = 0x2A21

gl_VALIDATE_STATUS :: GLenum
gl_VALIDATE_STATUS = 0x8B83

gl_VARIABLE_A_NV :: GLenum
gl_VARIABLE_A_NV = 0x8523

gl_VARIABLE_B_NV :: GLenum
gl_VARIABLE_B_NV = 0x8524

gl_VARIABLE_C_NV :: GLenum
gl_VARIABLE_C_NV = 0x8525

gl_VARIABLE_D_NV :: GLenum
gl_VARIABLE_D_NV = 0x8526

gl_VARIABLE_E_NV :: GLenum
gl_VARIABLE_E_NV = 0x8527

gl_VARIABLE_F_NV :: GLenum
gl_VARIABLE_F_NV = 0x8528

gl_VARIABLE_G_NV :: GLenum
gl_VARIABLE_G_NV = 0x8529

gl_VARIANT_ARRAY_EXT :: GLenum
gl_VARIANT_ARRAY_EXT = 0x87E8

gl_VARIANT_ARRAY_POINTER_EXT :: GLenum
gl_VARIANT_ARRAY_POINTER_EXT = 0x87E9

gl_VARIANT_ARRAY_STRIDE_EXT :: GLenum
gl_VARIANT_ARRAY_STRIDE_EXT = 0x87E6

gl_VARIANT_ARRAY_TYPE_EXT :: GLenum
gl_VARIANT_ARRAY_TYPE_EXT = 0x87E7

gl_VARIANT_DATATYPE_EXT :: GLenum
gl_VARIANT_DATATYPE_EXT = 0x87E5

gl_VARIANT_EXT :: GLenum
gl_VARIANT_EXT = 0x87C1

gl_VARIANT_VALUE_EXT :: GLenum
gl_VARIANT_VALUE_EXT = 0x87E4

gl_VBO_FREE_MEMORY_ATI :: GLenum
gl_VBO_FREE_MEMORY_ATI = 0x87FB

gl_VECTOR_EXT :: GLenum
gl_VECTOR_EXT = 0x87BF

gl_VENDOR :: GLenum
gl_VENDOR = 0x1F00

gl_VERSION :: GLenum
gl_VERSION = 0x1F02

gl_VERSION_ES_CL_1_0 :: GLenum
gl_VERSION_ES_CL_1_0 = 1

gl_VERSION_ES_CL_1_1 :: GLenum
gl_VERSION_ES_CL_1_1 = 1

gl_VERSION_ES_CM_1_1 :: GLenum
gl_VERSION_ES_CM_1_1 = 1

gl_VERTEX23_BIT_PGI :: GLbitfield
gl_VERTEX23_BIT_PGI = 0x00000004

gl_VERTEX4_BIT_PGI :: GLbitfield
gl_VERTEX4_BIT_PGI = 0x00000008

gl_VERTEX_ARRAY :: GLenum
gl_VERTEX_ARRAY = 0x8074

gl_VERTEX_ARRAY_ADDRESS_NV :: GLenum
gl_VERTEX_ARRAY_ADDRESS_NV = 0x8F21

gl_VERTEX_ARRAY_BINDING :: GLenum
gl_VERTEX_ARRAY_BINDING = 0x85B5

gl_VERTEX_ARRAY_BINDING_APPLE :: GLenum
gl_VERTEX_ARRAY_BINDING_APPLE = 0x85B5

gl_VERTEX_ARRAY_BINDING_OES :: GLenum
gl_VERTEX_ARRAY_BINDING_OES = 0x85B5

gl_VERTEX_ARRAY_BUFFER_BINDING :: GLenum
gl_VERTEX_ARRAY_BUFFER_BINDING = 0x8896

gl_VERTEX_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_VERTEX_ARRAY_BUFFER_BINDING_ARB = 0x8896

gl_VERTEX_ARRAY_COUNT_EXT :: GLenum
gl_VERTEX_ARRAY_COUNT_EXT = 0x807D

gl_VERTEX_ARRAY_EXT :: GLenum
gl_VERTEX_ARRAY_EXT = 0x8074

gl_VERTEX_ARRAY_KHR :: GLenum
gl_VERTEX_ARRAY_KHR = 0x8074

gl_VERTEX_ARRAY_LENGTH_NV :: GLenum
gl_VERTEX_ARRAY_LENGTH_NV = 0x8F2B

gl_VERTEX_ARRAY_LIST_IBM :: GLenum
gl_VERTEX_ARRAY_LIST_IBM = 103070

gl_VERTEX_ARRAY_LIST_STRIDE_IBM :: GLenum
gl_VERTEX_ARRAY_LIST_STRIDE_IBM = 103080

gl_VERTEX_ARRAY_OBJECT_AMD :: GLenum
gl_VERTEX_ARRAY_OBJECT_AMD = 0x9154

gl_VERTEX_ARRAY_OBJECT_EXT :: GLenum
gl_VERTEX_ARRAY_OBJECT_EXT = 0x9154

gl_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL :: GLenum
gl_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F5

gl_VERTEX_ARRAY_POINTER :: GLenum
gl_VERTEX_ARRAY_POINTER = 0x808E

gl_VERTEX_ARRAY_POINTER_EXT :: GLenum
gl_VERTEX_ARRAY_POINTER_EXT = 0x808E

gl_VERTEX_ARRAY_RANGE_APPLE :: GLenum
gl_VERTEX_ARRAY_RANGE_APPLE = 0x851D

gl_VERTEX_ARRAY_RANGE_LENGTH_APPLE :: GLenum
gl_VERTEX_ARRAY_RANGE_LENGTH_APPLE = 0x851E

gl_VERTEX_ARRAY_RANGE_LENGTH_NV :: GLenum
gl_VERTEX_ARRAY_RANGE_LENGTH_NV = 0x851E

gl_VERTEX_ARRAY_RANGE_NV :: GLenum
gl_VERTEX_ARRAY_RANGE_NV = 0x851D

gl_VERTEX_ARRAY_RANGE_POINTER_APPLE :: GLenum
gl_VERTEX_ARRAY_RANGE_POINTER_APPLE = 0x8521

gl_VERTEX_ARRAY_RANGE_POINTER_NV :: GLenum
gl_VERTEX_ARRAY_RANGE_POINTER_NV = 0x8521

gl_VERTEX_ARRAY_RANGE_VALID_NV :: GLenum
gl_VERTEX_ARRAY_RANGE_VALID_NV = 0x851F

gl_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV :: GLenum
gl_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = 0x8533

gl_VERTEX_ARRAY_SIZE :: GLenum
gl_VERTEX_ARRAY_SIZE = 0x807A

gl_VERTEX_ARRAY_SIZE_EXT :: GLenum
gl_VERTEX_ARRAY_SIZE_EXT = 0x807A

gl_VERTEX_ARRAY_STORAGE_HINT_APPLE :: GLenum
gl_VERTEX_ARRAY_STORAGE_HINT_APPLE = 0x851F

gl_VERTEX_ARRAY_STRIDE :: GLenum
gl_VERTEX_ARRAY_STRIDE = 0x807C

gl_VERTEX_ARRAY_STRIDE_EXT :: GLenum
gl_VERTEX_ARRAY_STRIDE_EXT = 0x807C

gl_VERTEX_ARRAY_TYPE :: GLenum
gl_VERTEX_ARRAY_TYPE = 0x807B

gl_VERTEX_ARRAY_TYPE_EXT :: GLenum
gl_VERTEX_ARRAY_TYPE_EXT = 0x807B

gl_VERTEX_ATTRIB_ARRAY0_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY0_NV = 0x8650

gl_VERTEX_ATTRIB_ARRAY10_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY10_NV = 0x865A

gl_VERTEX_ATTRIB_ARRAY11_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY11_NV = 0x865B

gl_VERTEX_ATTRIB_ARRAY12_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY12_NV = 0x865C

gl_VERTEX_ATTRIB_ARRAY13_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY13_NV = 0x865D

gl_VERTEX_ATTRIB_ARRAY14_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY14_NV = 0x865E

gl_VERTEX_ATTRIB_ARRAY15_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY15_NV = 0x865F

gl_VERTEX_ATTRIB_ARRAY1_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY1_NV = 0x8651

gl_VERTEX_ATTRIB_ARRAY2_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY2_NV = 0x8652

gl_VERTEX_ATTRIB_ARRAY3_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY3_NV = 0x8653

gl_VERTEX_ATTRIB_ARRAY4_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY4_NV = 0x8654

gl_VERTEX_ATTRIB_ARRAY5_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY5_NV = 0x8655

gl_VERTEX_ATTRIB_ARRAY6_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY6_NV = 0x8656

gl_VERTEX_ATTRIB_ARRAY7_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY7_NV = 0x8657

gl_VERTEX_ATTRIB_ARRAY8_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY8_NV = 0x8658

gl_VERTEX_ATTRIB_ARRAY9_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY9_NV = 0x8659

gl_VERTEX_ATTRIB_ARRAY_ADDRESS_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY_ADDRESS_NV = 0x8F20

gl_VERTEX_ATTRIB_ARRAY_BARRIER_BIT :: GLbitfield
gl_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 0x00000001

gl_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT :: GLbitfield
gl_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT = 0x00000001

gl_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING :: GLenum
gl_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F

gl_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = 0x889F

gl_VERTEX_ATTRIB_ARRAY_DIVISOR :: GLenum
gl_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE

gl_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE :: GLenum
gl_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE = 0x88FE

gl_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB :: GLenum
gl_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB = 0x88FE

gl_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT :: GLenum
gl_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT = 0x88FE

gl_VERTEX_ATTRIB_ARRAY_DIVISOR_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY_DIVISOR_NV = 0x88FE

gl_VERTEX_ATTRIB_ARRAY_ENABLED :: GLenum
gl_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622

gl_VERTEX_ATTRIB_ARRAY_ENABLED_ARB :: GLenum
gl_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = 0x8622

gl_VERTEX_ATTRIB_ARRAY_INTEGER :: GLenum
gl_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD

gl_VERTEX_ATTRIB_ARRAY_INTEGER_EXT :: GLenum
gl_VERTEX_ATTRIB_ARRAY_INTEGER_EXT = 0x88FD

gl_VERTEX_ATTRIB_ARRAY_INTEGER_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY_INTEGER_NV = 0x88FD

gl_VERTEX_ATTRIB_ARRAY_LENGTH_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY_LENGTH_NV = 0x8F2A

gl_VERTEX_ATTRIB_ARRAY_LONG :: GLenum
gl_VERTEX_ATTRIB_ARRAY_LONG = 0x874E

gl_VERTEX_ATTRIB_ARRAY_NORMALIZED :: GLenum
gl_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A

gl_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB :: GLenum
gl_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = 0x886A

gl_VERTEX_ATTRIB_ARRAY_POINTER :: GLenum
gl_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645

gl_VERTEX_ATTRIB_ARRAY_POINTER_ARB :: GLenum
gl_VERTEX_ATTRIB_ARRAY_POINTER_ARB = 0x8645

gl_VERTEX_ATTRIB_ARRAY_SIZE :: GLenum
gl_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623

gl_VERTEX_ATTRIB_ARRAY_SIZE_ARB :: GLenum
gl_VERTEX_ATTRIB_ARRAY_SIZE_ARB = 0x8623

gl_VERTEX_ATTRIB_ARRAY_STRIDE :: GLenum
gl_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624

gl_VERTEX_ATTRIB_ARRAY_STRIDE_ARB :: GLenum
gl_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = 0x8624

gl_VERTEX_ATTRIB_ARRAY_TYPE :: GLenum
gl_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625

gl_VERTEX_ATTRIB_ARRAY_TYPE_ARB :: GLenum
gl_VERTEX_ATTRIB_ARRAY_TYPE_ARB = 0x8625

gl_VERTEX_ATTRIB_ARRAY_UNIFIED_NV :: GLenum
gl_VERTEX_ATTRIB_ARRAY_UNIFIED_NV = 0x8F1E

gl_VERTEX_ATTRIB_BINDING :: GLenum
gl_VERTEX_ATTRIB_BINDING = 0x82D4

gl_VERTEX_ATTRIB_MAP1_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP1_APPLE = 0x8A00

gl_VERTEX_ATTRIB_MAP1_COEFF_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP1_COEFF_APPLE = 0x8A03

gl_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE = 0x8A05

gl_VERTEX_ATTRIB_MAP1_ORDER_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP1_ORDER_APPLE = 0x8A04

gl_VERTEX_ATTRIB_MAP1_SIZE_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP1_SIZE_APPLE = 0x8A02

gl_VERTEX_ATTRIB_MAP2_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP2_APPLE = 0x8A01

gl_VERTEX_ATTRIB_MAP2_COEFF_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP2_COEFF_APPLE = 0x8A07

gl_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE = 0x8A09

gl_VERTEX_ATTRIB_MAP2_ORDER_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP2_ORDER_APPLE = 0x8A08

gl_VERTEX_ATTRIB_MAP2_SIZE_APPLE :: GLenum
gl_VERTEX_ATTRIB_MAP2_SIZE_APPLE = 0x8A06

gl_VERTEX_ATTRIB_RELATIVE_OFFSET :: GLenum
gl_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5

gl_VERTEX_BINDING_BUFFER :: GLenum
gl_VERTEX_BINDING_BUFFER = 0x8F4F

gl_VERTEX_BINDING_DIVISOR :: GLenum
gl_VERTEX_BINDING_DIVISOR = 0x82D6

gl_VERTEX_BINDING_OFFSET :: GLenum
gl_VERTEX_BINDING_OFFSET = 0x82D7

gl_VERTEX_BINDING_STRIDE :: GLenum
gl_VERTEX_BINDING_STRIDE = 0x82D8

gl_VERTEX_BLEND_ARB :: GLenum
gl_VERTEX_BLEND_ARB = 0x86A7

gl_VERTEX_CONSISTENT_HINT_PGI :: GLenum
gl_VERTEX_CONSISTENT_HINT_PGI = 0x1A22B

gl_VERTEX_DATA_HINT_PGI :: GLenum
gl_VERTEX_DATA_HINT_PGI = 0x1A22A

gl_VERTEX_ELEMENT_SWIZZLE_AMD :: GLenum
gl_VERTEX_ELEMENT_SWIZZLE_AMD = 0x91A4

gl_VERTEX_ID_NV :: GLenum
gl_VERTEX_ID_NV = 0x8C7B

gl_VERTEX_ID_SWIZZLE_AMD :: GLenum
gl_VERTEX_ID_SWIZZLE_AMD = 0x91A5

gl_VERTEX_PRECLIP_HINT_SGIX :: GLenum
gl_VERTEX_PRECLIP_HINT_SGIX = 0x83EF

gl_VERTEX_PRECLIP_SGIX :: GLenum
gl_VERTEX_PRECLIP_SGIX = 0x83EE

gl_VERTEX_PROGRAM_ARB :: GLenum
gl_VERTEX_PROGRAM_ARB = 0x8620

gl_VERTEX_PROGRAM_BINDING_NV :: GLenum
gl_VERTEX_PROGRAM_BINDING_NV = 0x864A

gl_VERTEX_PROGRAM_CALLBACK_DATA_MESA :: GLenum
gl_VERTEX_PROGRAM_CALLBACK_DATA_MESA = 0x8BB7

gl_VERTEX_PROGRAM_CALLBACK_FUNC_MESA :: GLenum
gl_VERTEX_PROGRAM_CALLBACK_FUNC_MESA = 0x8BB6

gl_VERTEX_PROGRAM_CALLBACK_MESA :: GLenum
gl_VERTEX_PROGRAM_CALLBACK_MESA = 0x8BB5

gl_VERTEX_PROGRAM_NV :: GLenum
gl_VERTEX_PROGRAM_NV = 0x8620

gl_VERTEX_PROGRAM_PARAMETER_BUFFER_NV :: GLenum
gl_VERTEX_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA2

gl_VERTEX_PROGRAM_POINT_SIZE :: GLenum
gl_VERTEX_PROGRAM_POINT_SIZE = 0x8642

gl_VERTEX_PROGRAM_POINT_SIZE_ARB :: GLenum
gl_VERTEX_PROGRAM_POINT_SIZE_ARB = 0x8642

gl_VERTEX_PROGRAM_POINT_SIZE_NV :: GLenum
gl_VERTEX_PROGRAM_POINT_SIZE_NV = 0x8642

gl_VERTEX_PROGRAM_POSITION_MESA :: GLenum
gl_VERTEX_PROGRAM_POSITION_MESA = 0x8BB4

gl_VERTEX_PROGRAM_TWO_SIDE :: GLenum
gl_VERTEX_PROGRAM_TWO_SIDE = 0x8643

gl_VERTEX_PROGRAM_TWO_SIDE_ARB :: GLenum
gl_VERTEX_PROGRAM_TWO_SIDE_ARB = 0x8643

gl_VERTEX_PROGRAM_TWO_SIDE_NV :: GLenum
gl_VERTEX_PROGRAM_TWO_SIDE_NV = 0x8643

gl_VERTEX_SHADER :: GLenum
gl_VERTEX_SHADER = 0x8B31

gl_VERTEX_SHADER_ARB :: GLenum
gl_VERTEX_SHADER_ARB = 0x8B31

gl_VERTEX_SHADER_BINDING_EXT :: GLenum
gl_VERTEX_SHADER_BINDING_EXT = 0x8781

gl_VERTEX_SHADER_BIT :: GLbitfield
gl_VERTEX_SHADER_BIT = 0x00000001

gl_VERTEX_SHADER_BIT_EXT :: GLbitfield
gl_VERTEX_SHADER_BIT_EXT = 0x00000001

gl_VERTEX_SHADER_EXT :: GLenum
gl_VERTEX_SHADER_EXT = 0x8780

gl_VERTEX_SHADER_INSTRUCTIONS_EXT :: GLenum
gl_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87CF

gl_VERTEX_SHADER_INVARIANTS_EXT :: GLenum
gl_VERTEX_SHADER_INVARIANTS_EXT = 0x87D1

gl_VERTEX_SHADER_INVOCATIONS_ARB :: GLenum
gl_VERTEX_SHADER_INVOCATIONS_ARB = 0x82F0

gl_VERTEX_SHADER_LOCALS_EXT :: GLenum
gl_VERTEX_SHADER_LOCALS_EXT = 0x87D3

gl_VERTEX_SHADER_LOCAL_CONSTANTS_EXT :: GLenum
gl_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87D2

gl_VERTEX_SHADER_OPTIMIZED_EXT :: GLenum
gl_VERTEX_SHADER_OPTIMIZED_EXT = 0x87D4

gl_VERTEX_SHADER_VARIANTS_EXT :: GLenum
gl_VERTEX_SHADER_VARIANTS_EXT = 0x87D0

gl_VERTEX_SOURCE_ATI :: GLenum
gl_VERTEX_SOURCE_ATI = 0x8774

gl_VERTEX_STATE_PROGRAM_NV :: GLenum
gl_VERTEX_STATE_PROGRAM_NV = 0x8621

gl_VERTEX_STREAM0_ATI :: GLenum
gl_VERTEX_STREAM0_ATI = 0x876C

gl_VERTEX_STREAM1_ATI :: GLenum
gl_VERTEX_STREAM1_ATI = 0x876D

gl_VERTEX_STREAM2_ATI :: GLenum
gl_VERTEX_STREAM2_ATI = 0x876E

gl_VERTEX_STREAM3_ATI :: GLenum
gl_VERTEX_STREAM3_ATI = 0x876F

gl_VERTEX_STREAM4_ATI :: GLenum
gl_VERTEX_STREAM4_ATI = 0x8770

gl_VERTEX_STREAM5_ATI :: GLenum
gl_VERTEX_STREAM5_ATI = 0x8771

gl_VERTEX_STREAM6_ATI :: GLenum
gl_VERTEX_STREAM6_ATI = 0x8772

gl_VERTEX_STREAM7_ATI :: GLenum
gl_VERTEX_STREAM7_ATI = 0x8773

gl_VERTEX_SUBROUTINE :: GLenum
gl_VERTEX_SUBROUTINE = 0x92E8

gl_VERTEX_SUBROUTINE_UNIFORM :: GLenum
gl_VERTEX_SUBROUTINE_UNIFORM = 0x92EE

gl_VERTEX_TEXTURE :: GLenum
gl_VERTEX_TEXTURE = 0x829B

gl_VERTEX_WEIGHTING_EXT :: GLenum
gl_VERTEX_WEIGHTING_EXT = 0x8509

gl_VERTEX_WEIGHT_ARRAY_EXT :: GLenum
gl_VERTEX_WEIGHT_ARRAY_EXT = 0x850C

gl_VERTEX_WEIGHT_ARRAY_POINTER_EXT :: GLenum
gl_VERTEX_WEIGHT_ARRAY_POINTER_EXT = 0x8510

gl_VERTEX_WEIGHT_ARRAY_SIZE_EXT :: GLenum
gl_VERTEX_WEIGHT_ARRAY_SIZE_EXT = 0x850D

gl_VERTEX_WEIGHT_ARRAY_STRIDE_EXT :: GLenum
gl_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = 0x850F

gl_VERTEX_WEIGHT_ARRAY_TYPE_EXT :: GLenum
gl_VERTEX_WEIGHT_ARRAY_TYPE_EXT = 0x850E

gl_VERTICAL_LINE_TO_NV :: GLubyte
gl_VERTICAL_LINE_TO_NV = 0x08

gl_VERTICES_SUBMITTED_ARB :: GLenum
gl_VERTICES_SUBMITTED_ARB = 0x82EE

gl_VIBRANCE_BIAS_NV :: GLenum
gl_VIBRANCE_BIAS_NV = 0x8719

gl_VIBRANCE_SCALE_NV :: GLenum
gl_VIBRANCE_SCALE_NV = 0x8713

gl_VIDEO_BUFFER_BINDING_NV :: GLenum
gl_VIDEO_BUFFER_BINDING_NV = 0x9021

gl_VIDEO_BUFFER_INTERNAL_FORMAT_NV :: GLenum
gl_VIDEO_BUFFER_INTERNAL_FORMAT_NV = 0x902D

gl_VIDEO_BUFFER_NV :: GLenum
gl_VIDEO_BUFFER_NV = 0x9020

gl_VIDEO_BUFFER_PITCH_NV :: GLenum
gl_VIDEO_BUFFER_PITCH_NV = 0x9028

gl_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV :: GLenum
gl_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV = 0x903B

gl_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV :: GLenum
gl_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV = 0x903A

gl_VIDEO_CAPTURE_FRAME_HEIGHT_NV :: GLenum
gl_VIDEO_CAPTURE_FRAME_HEIGHT_NV = 0x9039

gl_VIDEO_CAPTURE_FRAME_WIDTH_NV :: GLenum
gl_VIDEO_CAPTURE_FRAME_WIDTH_NV = 0x9038

gl_VIDEO_CAPTURE_SURFACE_ORIGIN_NV :: GLenum
gl_VIDEO_CAPTURE_SURFACE_ORIGIN_NV = 0x903C

gl_VIDEO_CAPTURE_TO_422_SUPPORTED_NV :: GLenum
gl_VIDEO_CAPTURE_TO_422_SUPPORTED_NV = 0x9026

gl_VIDEO_COLOR_CONVERSION_MATRIX_NV :: GLenum
gl_VIDEO_COLOR_CONVERSION_MATRIX_NV = 0x9029

gl_VIDEO_COLOR_CONVERSION_MAX_NV :: GLenum
gl_VIDEO_COLOR_CONVERSION_MAX_NV = 0x902A

gl_VIDEO_COLOR_CONVERSION_MIN_NV :: GLenum
gl_VIDEO_COLOR_CONVERSION_MIN_NV = 0x902B

gl_VIDEO_COLOR_CONVERSION_OFFSET_NV :: GLenum
gl_VIDEO_COLOR_CONVERSION_OFFSET_NV = 0x902C

gl_VIEWPORT :: GLenum
gl_VIEWPORT = 0x0BA2

gl_VIEWPORT_BIT :: GLbitfield
gl_VIEWPORT_BIT = 0x00000800

gl_VIEWPORT_BOUNDS_RANGE :: GLenum
gl_VIEWPORT_BOUNDS_RANGE = 0x825D

gl_VIEWPORT_BOUNDS_RANGE_EXT :: GLenum
gl_VIEWPORT_BOUNDS_RANGE_EXT = 0x825D

gl_VIEWPORT_BOUNDS_RANGE_NV :: GLenum
gl_VIEWPORT_BOUNDS_RANGE_NV = 0x825D

gl_VIEWPORT_INDEX_PROVOKING_VERTEX :: GLenum
gl_VIEWPORT_INDEX_PROVOKING_VERTEX = 0x825F

gl_VIEWPORT_INDEX_PROVOKING_VERTEX_EXT :: GLenum
gl_VIEWPORT_INDEX_PROVOKING_VERTEX_EXT = 0x825F

gl_VIEWPORT_INDEX_PROVOKING_VERTEX_NV :: GLenum
gl_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = 0x825F

gl_VIEWPORT_SUBPIXEL_BITS :: GLenum
gl_VIEWPORT_SUBPIXEL_BITS = 0x825C

gl_VIEWPORT_SUBPIXEL_BITS_EXT :: GLenum
gl_VIEWPORT_SUBPIXEL_BITS_EXT = 0x825C

gl_VIEWPORT_SUBPIXEL_BITS_NV :: GLenum
gl_VIEWPORT_SUBPIXEL_BITS_NV = 0x825C

gl_VIEW_CLASS_128_BITS :: GLenum
gl_VIEW_CLASS_128_BITS = 0x82C4

gl_VIEW_CLASS_16_BITS :: GLenum
gl_VIEW_CLASS_16_BITS = 0x82CA

gl_VIEW_CLASS_24_BITS :: GLenum
gl_VIEW_CLASS_24_BITS = 0x82C9

gl_VIEW_CLASS_32_BITS :: GLenum
gl_VIEW_CLASS_32_BITS = 0x82C8

gl_VIEW_CLASS_48_BITS :: GLenum
gl_VIEW_CLASS_48_BITS = 0x82C7

gl_VIEW_CLASS_64_BITS :: GLenum
gl_VIEW_CLASS_64_BITS = 0x82C6

gl_VIEW_CLASS_8_BITS :: GLenum
gl_VIEW_CLASS_8_BITS = 0x82CB

gl_VIEW_CLASS_96_BITS :: GLenum
gl_VIEW_CLASS_96_BITS = 0x82C5

gl_VIEW_CLASS_BPTC_FLOAT :: GLenum
gl_VIEW_CLASS_BPTC_FLOAT = 0x82D3

gl_VIEW_CLASS_BPTC_UNORM :: GLenum
gl_VIEW_CLASS_BPTC_UNORM = 0x82D2

gl_VIEW_CLASS_RGTC1_RED :: GLenum
gl_VIEW_CLASS_RGTC1_RED = 0x82D0

gl_VIEW_CLASS_RGTC2_RG :: GLenum
gl_VIEW_CLASS_RGTC2_RG = 0x82D1

gl_VIEW_CLASS_S3TC_DXT1_RGB :: GLenum
gl_VIEW_CLASS_S3TC_DXT1_RGB = 0x82CC

gl_VIEW_CLASS_S3TC_DXT1_RGBA :: GLenum
gl_VIEW_CLASS_S3TC_DXT1_RGBA = 0x82CD

gl_VIEW_CLASS_S3TC_DXT3_RGBA :: GLenum
gl_VIEW_CLASS_S3TC_DXT3_RGBA = 0x82CE

gl_VIEW_CLASS_S3TC_DXT5_RGBA :: GLenum
gl_VIEW_CLASS_S3TC_DXT5_RGBA = 0x82CF

gl_VIEW_COMPATIBILITY_CLASS :: GLenum
gl_VIEW_COMPATIBILITY_CLASS = 0x82B6

gl_VIRTUAL_PAGE_SIZE_INDEX_ARB :: GLenum
gl_VIRTUAL_PAGE_SIZE_INDEX_ARB = 0x91A7

gl_VIRTUAL_PAGE_SIZE_X_AMD :: GLenum
gl_VIRTUAL_PAGE_SIZE_X_AMD = 0x9195

gl_VIRTUAL_PAGE_SIZE_X_ARB :: GLenum
gl_VIRTUAL_PAGE_SIZE_X_ARB = 0x9195

gl_VIRTUAL_PAGE_SIZE_Y_AMD :: GLenum
gl_VIRTUAL_PAGE_SIZE_Y_AMD = 0x9196

gl_VIRTUAL_PAGE_SIZE_Y_ARB :: GLenum
gl_VIRTUAL_PAGE_SIZE_Y_ARB = 0x9196

gl_VIRTUAL_PAGE_SIZE_Z_AMD :: GLenum
gl_VIRTUAL_PAGE_SIZE_Z_AMD = 0x9197

gl_VIRTUAL_PAGE_SIZE_Z_ARB :: GLenum
gl_VIRTUAL_PAGE_SIZE_Z_ARB = 0x9197

gl_VIVIDLIGHT_NV :: GLenum
gl_VIVIDLIGHT_NV = 0x92A6

gl_VOLATILE_APPLE :: GLenum
gl_VOLATILE_APPLE = 0x8A1A

gl_WAIT_FAILED :: GLenum
gl_WAIT_FAILED = 0x911D

gl_WAIT_FAILED_APPLE :: GLenum
gl_WAIT_FAILED_APPLE = 0x911D

gl_WARPS_PER_SM_NV :: GLenum
gl_WARPS_PER_SM_NV = 0x933A

gl_WARP_SIZE_NV :: GLenum
gl_WARP_SIZE_NV = 0x9339

gl_WEIGHT_ARRAY_ARB :: GLenum
gl_WEIGHT_ARRAY_ARB = 0x86AD

gl_WEIGHT_ARRAY_BUFFER_BINDING :: GLenum
gl_WEIGHT_ARRAY_BUFFER_BINDING = 0x889E

gl_WEIGHT_ARRAY_BUFFER_BINDING_ARB :: GLenum
gl_WEIGHT_ARRAY_BUFFER_BINDING_ARB = 0x889E

gl_WEIGHT_ARRAY_BUFFER_BINDING_OES :: GLenum
gl_WEIGHT_ARRAY_BUFFER_BINDING_OES = 0x889E

gl_WEIGHT_ARRAY_OES :: GLenum
gl_WEIGHT_ARRAY_OES = 0x86AD

gl_WEIGHT_ARRAY_POINTER_ARB :: GLenum
gl_WEIGHT_ARRAY_POINTER_ARB = 0x86AC

gl_WEIGHT_ARRAY_POINTER_OES :: GLenum
gl_WEIGHT_ARRAY_POINTER_OES = 0x86AC

gl_WEIGHT_ARRAY_SIZE_ARB :: GLenum
gl_WEIGHT_ARRAY_SIZE_ARB = 0x86AB

gl_WEIGHT_ARRAY_SIZE_OES :: GLenum
gl_WEIGHT_ARRAY_SIZE_OES = 0x86AB

gl_WEIGHT_ARRAY_STRIDE_ARB :: GLenum
gl_WEIGHT_ARRAY_STRIDE_ARB = 0x86AA

gl_WEIGHT_ARRAY_STRIDE_OES :: GLenum
gl_WEIGHT_ARRAY_STRIDE_OES = 0x86AA

gl_WEIGHT_ARRAY_TYPE_ARB :: GLenum
gl_WEIGHT_ARRAY_TYPE_ARB = 0x86A9

gl_WEIGHT_ARRAY_TYPE_OES :: GLenum
gl_WEIGHT_ARRAY_TYPE_OES = 0x86A9

gl_WEIGHT_SUM_UNITY_ARB :: GLenum
gl_WEIGHT_SUM_UNITY_ARB = 0x86A6

gl_WIDE_LINE_HINT_PGI :: GLenum
gl_WIDE_LINE_HINT_PGI = 0x1A222

gl_WRAP_BORDER_SUN :: GLenum
gl_WRAP_BORDER_SUN = 0x81D4

gl_WRITEONLY_RENDERING_QCOM :: GLenum
gl_WRITEONLY_RENDERING_QCOM = 0x8823

gl_WRITE_DISCARD_NV :: GLenum
gl_WRITE_DISCARD_NV = 0x88BE

gl_WRITE_ONLY :: GLenum
gl_WRITE_ONLY = 0x88B9

gl_WRITE_ONLY_ARB :: GLenum
gl_WRITE_ONLY_ARB = 0x88B9

gl_WRITE_ONLY_OES :: GLenum
gl_WRITE_ONLY_OES = 0x88B9

gl_WRITE_PIXEL_DATA_RANGE_LENGTH_NV :: GLenum
gl_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = 0x887A

gl_WRITE_PIXEL_DATA_RANGE_NV :: GLenum
gl_WRITE_PIXEL_DATA_RANGE_NV = 0x8878

gl_WRITE_PIXEL_DATA_RANGE_POINTER_NV :: GLenum
gl_WRITE_PIXEL_DATA_RANGE_POINTER_NV = 0x887C

gl_W_EXT :: GLenum
gl_W_EXT = 0x87D8

gl_XOR :: GLenum
gl_XOR = 0x1506

gl_XOR_NV :: GLenum
gl_XOR_NV = 0x1506

gl_X_EXT :: GLenum
gl_X_EXT = 0x87D5

gl_YCBAYCR8A_4224_NV :: GLenum
gl_YCBAYCR8A_4224_NV = 0x9032

gl_YCBCR_422_APPLE :: GLenum
gl_YCBCR_422_APPLE = 0x85B9

gl_YCBCR_MESA :: GLenum
gl_YCBCR_MESA = 0x8757

gl_YCBYCR8_422_NV :: GLenum
gl_YCBYCR8_422_NV = 0x9031

gl_YCRCBA_SGIX :: GLenum
gl_YCRCBA_SGIX = 0x8319

gl_YCRCB_422_SGIX :: GLenum
gl_YCRCB_422_SGIX = 0x81BB

gl_YCRCB_444_SGIX :: GLenum
gl_YCRCB_444_SGIX = 0x81BC

gl_YCRCB_SGIX :: GLenum
gl_YCRCB_SGIX = 0x8318

gl_Y_EXT :: GLenum
gl_Y_EXT = 0x87D6

gl_Z400_BINARY_AMD :: GLenum
gl_Z400_BINARY_AMD = 0x8740

gl_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV :: GLenum
gl_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV = 0x9036

gl_Z4Y12Z4CB12Z4CR12_444_NV :: GLenum
gl_Z4Y12Z4CB12Z4CR12_444_NV = 0x9037

gl_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV :: GLenum
gl_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV = 0x9035

gl_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV :: GLenum
gl_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV = 0x9034

gl_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV :: GLenum
gl_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV = 0x9033

gl_ZERO :: GLenum
gl_ZERO = 0

gl_ZERO_EXT :: GLenum
gl_ZERO_EXT = 0x87DD

gl_ZERO_TO_ONE :: GLenum
gl_ZERO_TO_ONE = 0x935F

gl_ZOOM_X :: GLenum
gl_ZOOM_X = 0x0D16

gl_ZOOM_Y :: GLenum
gl_ZOOM_Y = 0x0D17

gl_Z_EXT :: GLenum
gl_Z_EXT = 0x87D7

