<?php

//    showurl.php
//    Shows the info of a either retrieved or not URL
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: showurl.php,v 1.35 2006/08/24 12:53:21 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<a href=\"index.php\">" . $strMainPage . "</A>";
   die;
}
else
{
   eval("\$strhome = \"$strDBHome \";");
   if (!isset($IDUrl))
   {
      // Error
      DisplayErrMsg($strErrorNoUrlSelected);
      echo "<a href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";
      die;
   }
   
   // Retrieve Information from the DB
   $strSQL = "Select Schedule.Url as SUrl, Schedule.HopCount," .
      " Schedule.IDReferer, Schedule.IDServer as SIDServer, Url.*" .
      " from Schedule" .
      " LEFT JOIN Url ON Schedule.IDUrl=Url.IDUrl" .
      " WHERE Schedule.IDUrl=" . $IDUrl;

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows()>1)
   {
      DisplayErrMsg($strErrorDuplicateKey);
      die;
   }
   else if ($MyDB->NumRows()==0)
   {
?>
<p><?php echo $strNoOccurrencies; ?></p>
<?php
   }
   else
   {

      // Information retrieved
      $row = $MyDB->FetchArray();
      $MyDB->Free();

      $strSQL = "Select IDUrl from Url WHERE IDUrl=" . $IDUrl . ' AND Contents IS NOT NULL';

      $result=$MyDB->Query($dbname, $strSQL);
   
      if ($result)
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
   
      if ($num=$MyDB->NumRows())
         $DisplaySource = true;
      else
         $DisplaySource = false;

      $MyDB->Free();

      $Server="";

      // Get the server name
      if ($row["SIDServer"])
      {
         // Get the server name, if any
         $strSQL = "SELECT Server"
            . " FROM Server"
            . " WHERE IDServer=" . $row["SIDServer"];

         $result=$MyDB->Query($dbname, $strSQL);

         if ($result)
         {
            DisplayErrMsg($MyDB->errmsg);
            die;
         }

         if ($servrow = $MyDB->FetchArray())
            $Server=$servrow["Server"];

         $MyDB->Free();

      }

      $RefererUrl="";

      // Get the referer
      if ($row["IDReferer"])
      {

         $strSQL = "Select Schedule.Url" .
            " from Schedule" .
            " WHERE Schedule.IDUrl=" . $row["IDReferer"] ;

         $result=$MyDB->Query($dbname, $strSQL);

         if ($result)
         {
            DisplayErrMsg($MyDB->errmsg);
            die;
         }

         $refrow = $MyDB->FetchArray();
         $RefererUrl=$refrow["Url"];
         $MyDB->Free();

      }
            
      $URLName = $row["SUrl"];
      $pagetitle = "Database: $dbname - " . $strShowUrl . ": " . $URLName;
      $linkbar = "<a href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";
      $linkbar = $linkbar . " | " .
         "<a href=\"javascript:history.go(-1)\">" . $strBack . "</A>";
      
?>
<?php include ("./include/header.inc.php"); ?>
<?php

      // A database and a URL have been selected

?>
<h3><?php echo WriteHTML($URLName); ?></h3>
<?php
   if ($row['Url'])
   {
         // Info available - retrieved
         //echo '<div><pre>' .  var_dump($row) . '</pre></div>';
?>         
<div class="header">
<h4><?php echo $strInfoAvailable; ?>:</h4>
</div>

<div class="content">
<?php
      if ($row["Title"])
      {
?>
<strong><?php echo $strTitle; ?></strong>:  <?php echo $row["Title"]; ?><br>
<?php
      }
?>

<strong>Server</strong>:  <?php echo $Server; ?><br>
<strong><?php echo $strContentType; ?></strong>:  <?php echo $row["ContentType"]; ?><br>
<strong><?php echo $strCharset; ?></strong>:  <?php
   if (empty($row["Charset"]))
      $strcs = &$strNull;
   else
      if ($row["Charset"]=='unknown')
         $strcs = &$strOther;
      else
         $strcs = &$row["Charset"];
   echo $strcs; ?><br>
<strong><?php echo $strDocType; ?></strong>:  <?php
   if (empty($row["DocType"]))
      $strdt = &$strNull;
   else
      if ($row["DocType"]=='unknown')
         $strdt = &$strOther;
      else
         $strdt = &$row["DocType"];
   echo $strdt; ?><br>
<strong><?php echo $strContentLanguage; ?></strong>:  <?php
   echo (empty($row['ContentLanguage'])?'-':$row['ContentLanguage']); ?><br>
<strong><?php echo $strLastModified; ?></strong>:  <?php

   if (!strncmp($row["LastModified"], "0000", 4))
   {
      // No last modified value available"
      echo $strNoLastModified;
   }
   else echo $row["LastModified"] . '  GMT';      
   ?><br>
<?php
      if ($row["Description"])
      {
?>
<strong><?php echo $strDescription; ?></strong>:  <?php echo $row["Description"]; ?><br>
<?php
      }

      if ($row["Keywords"])
      {
?>
<strong><?php echo $strKeywords; ?></strong>:  <?php echo $row["Keywords"]; ?><br>
<?php
      }

      if ($row['HtDigEmail'])
      {
?>
<strong><?php echo $strHtDigEmail; ?></strong>:  <?php echo $row['HtDigEmail']; ?><br>
<?php
      }

      if ($row['HtDigEmailSubject'])
      {
?>
<strong><?php echo $strHtDigEmailSubject; ?></strong>:  <?php echo $row['HtDigEmailSubject']; ?><br>
<?php
      }

      if ($row['HtDigNotificationDate'])
      {
?>
<strong><?php echo $strHtDigNotificationDate; ?></strong>:  <?php echo $row['HtDigNotificationDate']; ?><br>
<?php
      }
?>
</div>

<div class="header">
<h4><?php echo $strRetrievingInfo; ?>:</h4>
</div>

<div class="content">
<strong><?php echo $strLastAccess; ?></strong>:  <?php 
   if (!strncmp($row["LastAccess"], "0000", 4))
   {
      // No last access value available"
      echo $strNoLastAccess;
   }
   else echo $row["LastAccess"] . '  GMT';      
?>
<br>
<strong><?php echo $strStatusCode; ?></strong>:  <?php echo $row["StatusCode"]; ?><br>
<strong><?php echo $strReasonPhrase; ?></strong>:  <?php echo $row["ReasonPhrase"]; ?><br>
<strong><?php echo $strReferer; ?></strong>:  <?php
   if ($RefererUrl) print GetURL($RefererUrl);
   else print ("-"); ?><br>
<strong><?php echo $strHopCount; ?></strong>:  <?php echo $row["HopCount"]; ?><br>
<?php
      if ($row["Location"])
      {
         // The URL has been redirected, so no outcoming info and size info
         // We should retrieve the Index of the redirected URL

      // Retrieve Information from the DB
      $strSQL = "Select IDUrl from Schedule" .
      " WHERE Url='" . $row["Location"] . "'";

      $result=$MyDB->Query($dbname, $strSQL);
   
      if ($resultloc)
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }

      $rowloc = $MyDB->FetchArray();
      $IDLocation=$rowloc["IDUrl"];
      $MyDB->Free();
      
      
                  
?>
<strong><?php echo $strLocation; ?></strong>:
<a href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $IDLocation; ?>"><?php echo $row["Location"]; ?></A><br>
<?php
      }
?>
<strong><?php echo $strConnectionStatus; ?></strong>:  <?php echo $row["ConnStatus"]; ?><br>
<strong><?php echo $strTransferEncoding; ?></strong>:  <?php echo $row["TransferEncoding"]?$row["TransferEncoding"]:"-"; ?><br>
</div>

<?php
      if (! $row["Location"])
      {
?>
<div class="header">
<h4><?php echo $strSizeInfo; ?>:</h4>
</div>

<div class="content">
<strong><?php echo $strSize; ?></strong>:  <?php
   if ($row["Size"] >= 0) {
?>
<?php echo number_format($row["Size"]); ?> Bytes<br>
<strong><?php echo $strSizeAdd; ?></strong>:  <?php echo number_format($row["SizeAdd"]); ?> Bytes<br>
<strong><?php echo $strPageWeight; ?></strong>:  <?php echo number_format($row["Size"]+$row["SizeAdd"]); ?> Bytes<br>
<?php
   }
   else echo $strUnknown;
   ?>
</div>

<div class="header">
<h4><?php echo $strOperations; ?></h4>
</div>

<div class="content">
<ul>
<li><a href="<?php echo $URLName; ?>" target="_blank"><?php echo $strOpenThisUrl; ?></A> (<?php echo $URLName; ?>)</li>
<?php
if ($DisplaySource)
{
?>
<li><a href="showsource.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $IDUrl; ?>" target="_urlsource"><?php echo $strShowThisUrlSource; ?></A></li>
<?php
   if (isset($Tidy))
   {
?>
<li><a href="showtidy.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $IDUrl; ?>" target="_tidy"><?php echo $strShowTidyReport; ?></A></li>
<?php
   }
} 
?>
</ul>
</div>

<?php
      }

      // Get the number of outgoing links from the current URL
      $strSQL = "SELECT COUNT(*) " .
         " FROM Link" .
         " WHERE Link.IDUrlSrc=$IDUrl" .
         " AND Link.LinkType='Normal'"; 

      if ($result=$MyDB->Query($dbname, $strSQL))
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
      else
      {
         $row = $MyDB->FetchRow();
         $NumWSM_OL=$row[0];
      }

      // Get the number of ingoing links to the current URL
      $strSQL = "SELECT COUNT(*) " .
         " FROM Link" .
         " WHERE Link.IDUrlDest=$IDUrl" .
         " AND Link.LinkType='Normal'"; 

      if ($result=$MyDB->Query($dbname, $strSQL))
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
      else
      {
         $row = $MyDB->FetchRow();
         $NumWSM_IL=$row[0];
      }

      // Get the number of documents in outgoing links from the current URL
      $strSQL = "SELECT DISTINCT IDUrlDest " .
         " FROM Link" .
         " WHERE Link.IDUrlSrc=$IDUrl" .
         " AND Link.LinkType='Normal'"; 

      if ($result=$MyDB->Query($dbname, $strSQL))
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
      else $NumWSM_OD = $MyDB->NumRows();

      // Get the number of documents in ingoing links from the current URL
      $strSQL = "SELECT DISTINCT IDUrlSrc " .
         " FROM Link" .
         " WHERE Link.IDUrlDest=$IDUrl" .
         " AND Link.LinkType='Normal'"; 

      if ($result=$MyDB->Query($dbname, $strSQL))
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
      else $NumWSM_ID = $MyDB->NumRows();

      // Calculates the total number of documents from links and links themselves
      // Obviously documents from links are always <= than links
      $NumWSM_L = $NumWSM_OL + $NumWSM_IL;
      $NumWSM_D = $NumWSM_OD + $NumWSM_ID;
      $ProWSM_OL = ($NumWSM_L > 0)?($NumWSM_OL / $NumWSM_L):0;
      $ProWSM_IL = ($NumWSM_L > 0)?($NumWSM_IL / $NumWSM_L):0;
      $ProWSM_OD = ($NumWSM_D > 0)?($NumWSM_OD / $NumWSM_D):0;
      $ProWSM_ID = ($NumWSM_D > 0)?($NumWSM_ID / $NumWSM_D):0;
?>

<div class="header">
<h4><?php echo $strWSM_Indexes; ?>: &nbsp;
[ <a href="#wsm_notes"><?php echo $strWSM_Notes; ?></a> ]
</h4>
</div>

<div class="content">
<table>
<tr>
<td>

<table class="wsm_graph">
<tr>
<td class="wsm_column">
<?php echo $strWSM_ExplaL; ?>: &nbsp;
</td>
<td>
<?php if ($NumWSM_L > 0) : ?>
<?php if ($NumWSM_OL > 0) : ?>
<img src="img/out.png" align="middle" hspace="2" alt="<?php
   echo $strWSM_ProOL . ': ' . number_format($ProWSM_OL, 2); ?>" height="5"
   width="<?php echo number_format(100*$ProWSM_OL, 0); ?>" border="1" bordercolor="black"><?php
   endif;
   if ($NumWSM_IL > 0) : ?><img src="img/in.png" align="middle" hspace="2" alt="<?php
   echo $strWSM_ProIL . ': ' . number_format($ProWSM_IL, 2); ?>" height="5"
   width="<?php echo number_format(100*$ProWSM_IL, 0); ?>" border="1" bordercolor="black"><?php
   endif; ?>
<?php else: ?>-
<?php endif; ?>
</td>
</tr>

<tr>
<td class="wsm_column">
<?php echo $strWSM_ExplaD; ?>: &nbsp;
</td>
<td>
<?php if ($NumWSM_D > 0) : ?>
<?php if ($NumWSM_OD > 0) : ?>
<img src="img/out.png" align="middle" hspace="2" alt="<?php
   echo $strWSM_ProOD . ': ' . number_format($ProWSM_OD, 2); ?>" height="5"
   width="<?php echo number_format(100*$ProWSM_OD, 0); ?>" border="1" bordercolor="black"><?php
   endif;
   if ($NumWSM_ID > 0) : ?><img
   src="img/in.png" align="middle" hspace="2" alt="<?php
   echo $strWSM_ProID . ': ' . number_format($ProWSM_ID, 2); ?>" height="5"
   width="<?php echo number_format(100*$ProWSM_ID, 0); ?>" border="1" bordercolor="black"><?php
   endif; ?>
<?php else: ?>-
<?php endif; ?>
</td>
</tr>

<tr>
<td colspan="2" class="wsm_notes">
<table>
<tr>
<td>
<img src="img/out.png" hspace="2" alt="<?php
   echo $strWSM_ExplaOut; ?>" height="5" width="5" border="1" bordercolor="black">
</td>
<td>
<?php echo $strWSM_ExplaOut; ?>
</td>
<td>
&nbsp; - &nbsp;
</td>
<td>
<img src="img/in.png" hspace="2" alt="<?php
   echo $strWSM_ExplaIn; ?>" height="5" width="5" border="1" bordercolor="black">
</td>
<td>
<?php echo $strWSM_ExplaIn; ?>
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>

<td>
<table class="wsm_data">

<tr>
<th colspan="2">
<?php echo $strWSM_Ratios; ?>
</th>
</tr>

<tr>
<td class="wsm_column">
<?php echo $strWSM_RatioL; ?>: &nbsp;
</td>
<td>
<?php if ($NumWSM_IL > 0)
      echo number_format(($NumWSM_OL / $NumWSM_IL), 2);
   else echo '-'; ?>
</td>
</tr>

<tr>
<td class="wsm_column">
<?php echo $strWSM_RatioD; ?>: &nbsp;
</td>
<td>
<?php if ($NumWSM_ID > 0)
      echo number_format(($NumWSM_OD / $NumWSM_ID), 2);
   else echo '-'; ?>
</td>
</tr>

</table>
</td>
</tr>
</table>
</div>

<?php

      // Info about outgoing links (both retrieved or not)
   
      $strSQL = "SELECT Schedule.Url, Schedule.Status, Link.*, " .
         " Url.StatusCode, Url.ReasonPhrase, Url.ContentType" . 
         " FROM Schedule, Link" .
         " LEFT JOIN Url ON Url.IDUrl=Link.IDUrlDest " .
         " WHERE Link.IDUrlSrc=" . $IDUrl . " AND " .
         " Schedule.IDUrl=Link.IDUrlDest" . 
         " ORDER BY Link.TagPosition, Link.AttrPosition";

      $result=$MyDB->Query($dbname, $strSQL);
   
      if ($result)
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
   
?>
<div class="header">
<h4><?php echo $strOutgoingLinks; ?>:</h4>
</div>

<div class="content">
<?php
      if ($num=$MyDB->NumRows())
      {
?>
<strong><?php echo $strRecordFound; ?></strong>: <?php echo $num; ?><br>
<table>
<tr>
<th>Url</th>
<th><?php echo $strRetrievingFlag; ?></th>
<th><?php echo $strLinkType; ?></th>
<th><?php echo $strStatusCode; ?></th>
<th><?php echo $strReasonPhrase; ?></th>
<th><?php echo $strContentType; ?></th>
<th><?php echo $strShow; ?></th>
</tr>
<?php      
         $i=0;
         while ($link=$MyDB->FetchArray())
         {
            ++$i;
            ($i % 2)? $trclass='odd':$trclass='even';
?>
 <tr class="<?php echo $trclass; ?>">
   <td><a href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlDest"]; ?>"><?php echo GetURL($link["Url"]); ?></A></td>
   <td align="center"><?php echo $link["Status"]; ?></td>
   <td align="center"><?php echo $link["LinkType"]; ?></td>
<?php
            if ($link["StatusCode"])
            {
?>
   <td align="center"><?php echo $link["StatusCode"]; ?></td>
   <td align="center"><?php echo $link["ReasonPhrase"]; ?></td>
   <td align="center"><?php echo $link["ContentType"]; ?></td>
<?php
            }
            else
            {
?>
   <td colspan="3" align="center"><em><?php echo $strNotRetrieved; ?></em></td>
<?php
            }
?>
   <td align="center">
<?php
   if (strcmp($link["LinkType"], "Redirection"))  // It's not a redirection
   {
?>
   <a href="showlink.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>&TagPosition=<?php echo $link["TagPosition"]; ?>&AttrPosition=<?php echo $link["AttrPosition"]; ?>"><?php echo $strShowLink; ?></A>
<?php
   }
?>
   </td>
 </tr>
<?php
         }
?>
</table>
<?php
      }
      else
      {
?>
<p><?php echo $strNoOccurrencies; ?></p>
<?php
      }
   }
   else
   {
?>
<em><?php echo $strNotRetrieved; ?></em><br>
<?php
   }
?>
</div>

<div class="header">
<h4><?php echo $strIncomingLinks; ?>:</h4>
</div>

<div class="content">
<?php

      // Info about incoming links - only retrieved, of course
   
   $strSQL = "Select Url.IDUrl, Url.Url, Url.ContentType," .
      " Link.*" .
      " from Link, Url" .
      " WHERE Link.IDUrlDest=" . $IDUrl . " AND " .
      " Link.IDUrlSrc=Url.IDUrl" . 
      " ORDER BY Url.Url";

      $result=$MyDB->Query($dbname, $strSQL);
   
      if ($result)
      {
         DisplayErrMsg($MyDB->errmsg);
         die;
      }
   
      if ($num=$MyDB->NumRows())
      {
?>
<strong><?php echo $strRecordFound; ?></strong>: <?php echo $num; ?><br>
<table>
<tr>
<th>Url</th>
<th><?php echo $strLinkType; ?></th>
<th><?php echo $strContentType; ?></th>
<th><?php echo $strShow; ?></th>
</tr>
<?php      
         $i=0;
         while ($link=$MyDB->FetchArray())
         {
            ++$i;
            ($i % 2)? $trclass='odd':$trclass='even';
?>
 <tr class="<?php echo $trclass; ?>">
   <td><a href="<?php echo $PHP_SELF; ?>?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>"><?php echo GetURL($link["Url"]); ?></A></td>
   <td align="center"><?php echo $link["LinkType"]; ?></td>
   <td align="center"><?php echo $link["ContentType"]; ?></td>
   <td align="center">
<?php
   if (strcmp($link["LinkType"], "Redirection"))  // It's not a redirection
   {
?>
   <a href="showlink.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>&TagPosition=<?php echo $link["TagPosition"]; ?>&AttrPosition=<?php echo $link["AttrPosition"]; ?>"><?php echo $strShowLink; ?></A>
<?php
   }
?>
   </td>
 </tr>
<?php
         }
?>
</table>
<?php
      }
      else
      {
?>
<p><?php echo $strNoOccurrencies; ?></p>
<?php
      }
   }
}

?>
</div>

<br>

<div class="header" id="wsm_notes">
<strong><?php echo $strWSM_Notes; ?></strong>
</div>

<div class="content">
<ul>
<li><?php echo $strWSM_L; ?></li>
<li><?php echo $strWSM_D; ?></li>
<li><?php echo $strWSM_OL; ?></li>
<li><?php echo $strWSM_IL; ?></li>
<li><?php echo $strWSM_OD; ?></li>
<li><?php echo $strWSM_ID; ?></li>
</ul>
</div>

<?php include ("./include/footer.inc.php"); ?>
