<!--⚠️ Note that this file is in Markdown but contains specific syntax for our doc-builder (similar to MDX) that may not be
rendered properly in your Markdown viewer.
-->

# जल्दी शुरू

[Hugging Face Hub](https://huggingface.co/) मशीन लर्निंग मॉडल, डेमो, डेटासेट और मेट्रिक्स साझा करने के लिए सबसे उपयुक्त स्थान है।
`huggingface_hub` लाइब्रेरी आपको अपने विकास परिवेश को छोड़े बिना हब के साथ इंटरैक्ट करने में मदद करती है।
आप आसानी से रिपॉजिटरी बना और प्रबंधित कर सकते हैं, फ़ाइलें डाउनलोड और अपलोड कर सकते हैं, और हब से उपयोगी मॉडल और डेटासेट मेटाडेटा प्राप्त कर सकते हैं।

## इंस्टालेशन

आरंभ करने के लिए, `huggingface_hub` लाइब्रेरी स्थापित करें:

```bash
pip install --upgrade huggingface_hub
```

अधिक विवरण के लिए, [installation](इंस्टॉलेशन) गाइड देखें।

## फ़ाइलें डाउनलोड करें

हब पर रिपॉजिटरी `git` वर्जन नियंत्रित हैं, और उपयोगकर्ता एक फ़ाइल या पूरी रिपॉजिटरी डाउनलोड कर सकते हैं।
फ़ाइलों को डाउनलोड करने के लिए आप [`hf_hub_download`] फ़ंक्शन का उपयोग कर सकते हैं।
यह फ़ंक्शन आपकी स्थानीय डिस्क पर एक फ़ाइल डाउनलोड और `cache` करेगा। अगली बार जब आपको उस फ़ाइल की आवश्यकता होगी,
तो यह आपके `cache` से लोड हो जाएगी, इसलिए आपको इसे फिर से डाउनलोड करने की आवश्यकता नहीं है।

आपको उस फ़ाइल की रिपॉजिटरी आईडी और फ़ाइल नाम की आवश्यकता होगी जिसे आप डाउनलोड करना चाहते हैं।
उदाहरण के लिए, [Pegasus](https://huggingface.co/google/pegasus-xsum) मॉडल कॉन्फ़िगरेशन फ़ाइल डाउनलोड करने के लिए:

```py
>>> from huggingface_hub import hf_hub_download
>>> hf_hub_download(repo_id="google/pegasus-xsum", filename="config.json")
```

फ़ाइल के किसी विशिष्ट संस्करण को डाउनलोड करने के लिए, शाखा नाम, टैग या कमिट हैश निर्दिष्ट करने के लिए `revision` पैरामीटर का उपयोग करें।
यदि आप कमिट हैश का उपयोग करना चुनते हैं, तो यह छोटे 7-वर्ण कमिट हैश के बजाय पूर्ण-लंबाई वाला हैश होना चाहिए:

```py
>>> from huggingface_hub import hf_hub_download
>>> hf_hub_download(
...     repo_id="google/pegasus-xsum",
...     filename="config.json",
...     revision="4d33b01d79672f27f001f6abade33f22d993b151"
... )
```

अधिक विवरण और विकल्पों के लिए, [`hf_hub_download`] के लिए एपीआई संदर्भ देखें।

## प्रमाणीकरण

कई मामलों में, हब के साथ इंटरैक्ट करने के लिए आपको `Hugging Face` खाते से प्रमाणित होना होगा:
निजी रेपो डाउनलोड करें, फ़ाइलें अपलोड करें, पीआर बनाएं,...
[एक खाता बनाएं](https://huggingface.co/join), यदि आपके पास पहले से कोई खाता नहीं है| और फिर अपना [User Access Token](https://huggingface.co/docs/hub/security-tokens) प्राप्त करने के लिए साइन इन करें, आपके [सेटिंग्स पेज](https://huggingface.co/settings/tokens) से। उपयोगकर्ता एक्सेस टोकन का उपयोग हब पर आपकी पहचान को प्रमाणित करने के लिए किया जाता है।

<Tip>

टोकन में `read` या `write` की अनुमतियाँ हो सकती हैं। यदि आप कोई रिपॉजिटरी बनाना या संपादित करना चाहते हैं तो सुनिश्चित करें कि आपके पास `write` का एक्सेस टोकन है। अन्यथा, अनजाने में आपके टोकन के लीक होने की स्थिति में जोखिम को कम करने के लिए `read` का टोकन जनरेट करना सबसे अच्छा है।

</Tip>

### लॉगिन कमांड

प्रमाणित करने का सबसे आसान तरीका टोकन को अपनी मशीन पर सहेजना है।
आप [`login`] कमांड का उपयोग करके टर्मिनल से ऐसा कर सकते हैं:

```bash
huggingface-cli login
```

कमांड आपको बताएगा कि क्या आप पहले से लॉग इन हैं और आपसे आपके टोकन के लिए पूछेगा। फिर टोकन को मान्य किया जाता है और आपकी `HF_HOME` निर्देशिका (डिफ़ॉल्ट रूप से `~/.cache/huggingface/token`) में सहेजा जाता है। 
हब के साथ इंटरैक्ट करने वाला कोई भी स्क्रिप्ट या लाइब्रेरी अनुरोध भेजते समय इस टोकन का उपयोग करेगा।

वैकल्पिक रूप से, आप किसी नोटबुक या स्क्रिप्ट में [`login`] का उपयोग करके प्रोग्रामेटिक रूप से लॉगिन कर सकते हैं:

```py
>>> from huggingface_hub import login
>>> login()
```

आप एक समय में केवल एक ही खाते में लॉग इन कर सकते हैं। नए खाते में लॉग इन करने से आप स्वचालित रूप से पिछले खाते से लॉग आउट हो जाएंगे।
अपने वर्तमान में सक्रिय खाते को निर्धारित करने के लिए, बस `huggingface-cli whoami` कमांड चलाएँ।

<Tip warning={true}>

एक बार लॉग इन करने के बाद, हब के सभी अनुरोध - यहां तक ​​कि वे तरीके जिनके लिए आवश्यक रूप से प्रमाणीकरण की आवश्यकता नहीं होती है - डिफ़ॉल्ट रूप से आपके एक्सेस टोकन का उपयोग करेंगे। यदि आप अपने टोकन के निहित उपयोग को अक्षम करना चाहते हैं, तो आपको एक पर्यावरण चर के रूप में `HF_HUB_DISABLE_IMPLICIT_TOKEN=1` सेट करना चाहिए [देखें संदर्भ](../package_reference/environment_variables#hfhubdisableimplicittoken)।

</Tip>

### स्थानीय रूप से कई टोकन प्रबंधित करें

आप प्रत्येक टोकन के साथ [`login`] कमांड से लॉग इन करके अपनी मशीन पर कई टोकन सहेज सकते हैं। यदि आपको इन टोकन के बीच स्थानीय रूप से स्विच करने की आवश्यकता है, तो आप [auth switch] कमांड का उपयोग कर सकते हैं:

```bash
huggingface-cli auth switch
```

यह कमांड आपको सहेजे गए टोकन की सूची से उसके नाम से एक टोकन चुनने के लिए कहेगा। एक बार चुने जाने के बाद, चुना गया टोकन `_active_` टोकन बन जाता है, और इसका उपयोग हब के साथ सभी इंटरैक्शन के लिए किया जाएगा।

आप `huggingface-cli auth list` के साथ अपनी मशीन पर उपलब्ध सभी एक्सेस टोकन सूचीबद्ध कर सकते हैं।

### पर्यावरण चर

पर्यावरण चर `HF_TOKEN` का उपयोग स्वयं को प्रमाणित करने के लिए भी किया जा सकता है। यह एक ऐसे स्थान में विशेष रूप से उपयोगी है जहाँ आप `HF_TOKEN` को [Space Secret](https://huggingface.co/docs/hub/spaces-overview#managing-secrets) के रूप में सेट कर सकते हैं।

<Tip>

**नया:** Google Colaboratory आपको अपनी नोटबुक के लिए [private keys](https://twitter.com/GoogleColab/status/1719798406195867814) परिभाषित करने देता है। स्वचालित रूप से प्रमाणित होने के लिए एक `HF_TOKEN` रहस्य परिभाषित करें!

</Tip>

पर्यावरण चर या रहस्य के माध्यम से प्रमाणीकरण को आपकी मशीन पर संग्रहीत टोकन पर प्राथमिकता दी जाती है।

### मेथड पैरामीटर

अंत में, `token` को पैरामीटर के रूप में स्वीकार करने वाली किसी भी विधि में अपना टोकन पास करके प्रमाणित करना भी संभव है।

```
from huggingface_hub import whoami

user = whoami(token=...)
```
सामान्यतः इसकी अनुशंसा नहीं की जाती है, सिवाय उन परिस्थितियों में जहाँ आप अपना टोकन स्थायी रूप से संग्रहीत नहीं करना चाहते हैं या यदि आपको एक साथ कई टोकन संभालने की आवश्यकता है।

<Tip warning={true}>

टोकन को पैरामीटर के रूप में पास करते समय कृपया सावधान रहें। अपने कोडबेस या नोटबुक में इसे हार्डकोड करने के बजाय टोकन को एक सुरक्षित वॉल्ट से लोड करना हमेशा सबसे अच्छा अभ्यास होता है। यदि आप अनजाने में अपना कोड साझा करते हैं तो हार्डकोडेड टोकन एक बड़ा रिसाव जोखिम पेश करते हैं।

</Tip>

## रिपॉजिटरी बनाएँ

एक बार जब आप पंजीकृत हो जाते हैं और लॉग इन कर लेते हैं, तो [`create_repo`]
फ़ंक्शन के साथ एक रिपॉजिटरी बनाएँ:

```py
>>> from huggingface_hub import HfApi
>>> api = HfApi()
>>> api.create_repo(repo_id="super-cool-model")
```

यदि आप चाहते हैं कि आपकी रिपॉजिटरी निजी हो, तो:

```py
>>> from huggingface_hub import HfApi
>>> api = HfApi()
>>> api.create_repo(repo_id="super-cool-model", private=True)
```

निजी रिपॉजिटरी आपके अलावा किसी और को दिखाई नहीं देंगी।

<Tip>

रिपॉजिटरी बनाने या हब पर सामग्री पुश करने के लिए, आपको एक उपयोगकर्ता एक्सेस
टोकन प्रदान करना होगा जिसके पास `write` की अनुमति हो।
टोकन बनाते समय आप अपने [सेटिंग्स पेज](https://huggingface.co/settings/tokens) में अनुमति चुन सकते हैं।

</Tip>

## फाइलें अपलोड करें

अपनी नव निर्मित रिपॉजिटरी में फ़ाइल जोड़ने के लिए [`upload_file`] फ़ंक्शन का उपयोग करें। आप
निर्दिष्ट करने की आवश्यकता है:

1. अपलोड करने के लिए फ़ाइल का पथ.
2. रिपोजिटरी में फ़ाइल का पथ.
3. रिपॉजिटरी आईडी जहाँ आप फ़ाइल जोड़ना चाहते हैं।

```py
>>> from huggingface_hub import HfApi
>>> api = HfApi()
>>> api.upload_file(
...     path_or_fileobj="/home/lysandre/dummy-test/README.md",
...     path_in_repo="README.md",
...     repo_id="lysandre/test-model",
... )
```

एक समय में एक से अधिक फ़ाइल अपलोड करने के लिए, [अपलोड](./guides/upload) मार्गदर्शिका पर एक नज़र डालें
जो आपको फ़ाइलें अपलोड करने के कई तरीकों से परिचित कराएगा (git के साथ या उसके बिना)।

## अगले कदम

`huggingface_hub` लाइब्रेरी उपयोगकर्ताओं को हब के साथ बातचीत करने का एक आसान तरीका प्रदान करती है
Python के साथ. हब पर आप अपनी फ़ाइलों और रिपॉजिटरी को कैसे प्रबंधित कर सकते हैं,,
इसके बारे में अधिक जानने के लिए, हम अनुशंसा करते हैं कि आप हमारे [कैसे करें मार्गदर्शिकाएं](./guides/अवलोकन) पढ़ें:

- [अपना भंडार प्रबंधित करें](./guides/repository)।
- हब से [डाउनलोड](./guides/download) फ़ाइलें।
- हब पर [अपलोड](./guides/upload) फ़ाइलें।
- अपने इच्छित मॉडल या डेटासेट के लिए [हब खोजें](./guides/search)।
- तेज अनुमान के लिए [अनुमान एपीआई तक पहुंचें](./guides/अनुमान)।
