#! /usr/bin/env python
# Build file for Python modules
import sys
from re import compile
from distutils.core import setup, Extension

inc_re = compile('^--include-dirs=(.*)$')
lib_re = compile('^--library-dirs=(.*)$')
exlib_re = compile('^--extra-library=(.*)$')
old_argv = sys.argv
sys.argv = []
inc_dirs = ['.']
lib_dirs = []
libs = ['sidl']

for i in old_argv:
  m = inc_re.match(i)
  if (m):
    if (len(m.group(1))): inc_dirs.append(m.group(1))
  else:
    m = lib_re.match(i)
    if (m):
      if (len(m.group(1))): lib_dirs.append(m.group(1))
    else:
      m = exlib_re.match(i)
      if (m):
        if (len(m.group(1))): libs.append(m.group(1))
      else:
        sys.argv.append(i)
setup(name='babel',
  include_dirs=inc_dirs,
  headers = [
    'sidl_BaseClass_Module.h',
    'sidl_BaseException_Module.h',
    'sidl_BaseInterface_Module.h',
    'sidl_CastException_Module.h',
    'sidl_ClassInfoI_Module.h',
    'sidl_ClassInfo_Module.h',
    'sidl_DFinder_Module.h',
    'sidl_DLL_Module.h',
    'sidl_Finder_Module.h',
    'sidl_InvViolation_Module.h',
    'sidl_LangSpecificException_Module.h',
    'sidl_Loader_Module.h',
    'sidl_MemoryAllocationException_Module.h',
    'sidl_NotImplementedException_Module.h',
    'sidl_PostViolation_Module.h',
    'sidl_PreViolation_Module.h',
    'sidl_RuntimeException_Module.h',
    'sidl_SIDLException_Module.h',
    'sidl_io_Deserializer_Module.h',
    'sidl_io_IOException_Module.h',
    'sidl_io_Serializable_Module.h',
    'sidl_io_Serializer_Module.h',
    'sidl_rmi_BindException_Module.h',
    'sidl_rmi_Call_Module.h',
    'sidl_rmi_ConnectException_Module.h',
    'sidl_rmi_ConnectRegistry_Module.h',
    'sidl_rmi_InstanceHandle_Module.h',
    'sidl_rmi_InstanceRegistry_Module.h',
    'sidl_rmi_Invocation_Module.h',
    'sidl_rmi_MalformedURLException_Module.h',
    'sidl_rmi_NetworkException_Module.h',
    'sidl_rmi_NoRouteToHostException_Module.h',
    'sidl_rmi_NoServerException_Module.h',
    'sidl_rmi_ObjectDoesNotExistException_Module.h',
    'sidl_rmi_ProtocolException_Module.h',
    'sidl_rmi_ProtocolFactory_Module.h',
    'sidl_rmi_Response_Module.h',
    'sidl_rmi_Return_Module.h',
    'sidl_rmi_ServerInfo_Module.h',
    'sidl_rmi_ServerRegistry_Module.h',
    'sidl_rmi_TicketBook_Module.h',
    'sidl_rmi_Ticket_Module.h',
    'sidl_rmi_TimeOutException_Module.h',
    'sidl_rmi_UnexpectedCloseException_Module.h',
    'sidl_rmi_UnknownHostException_Module.h',
    'sidlx_rmi_ChildSocket_Module.h',
    'sidlx_rmi_ClientSocket_Module.h',
    'sidlx_rmi_Common_Module.h',
    'sidlx_rmi_GenNetworkException_Module.h',
    'sidlx_rmi_IPv4Socket_Module.h',
    'sidlx_rmi_JimEchoServer_Module.h',
    'sidlx_rmi_NoServerException_Module.h',
    'sidlx_rmi_ServerSocket_Module.h',
    'sidlx_rmi_SimCall_Module.h',
    'sidlx_rmi_SimHandle_Module.h',
    'sidlx_rmi_SimReturn_Module.h',
    'sidlx_rmi_SimpleOrb_Module.h',
    'sidlx_rmi_SimpleServer_Module.h',
    'sidlx_rmi_SimpleTicketBook_Module.h',
    'sidlx_rmi_SimpleTicket_Module.h',
    'sidlx_rmi_Simsponse_Module.h',
    'sidlx_rmi_Simvocation_Module.h',
    'sidlx_rmi_Socket_Module.h'
  ],
  packages = [
    'sidl',
    'sidl.io',
    'sidl.rmi',
    'sidlx',
    'sidlx.rmi'
  ],
  ext_modules = [
    Extension('sidl.BaseClass',
      ["sidl/sidl_BaseClass_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.BaseException',
      ["sidl/sidl_BaseException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.BaseInterface',
      ["sidl/sidl_BaseInterface_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.CastException',
      ["sidl/sidl_CastException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.ClassInfo',
      ["sidl/sidl_ClassInfo_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.ClassInfoI',
      ["sidl/sidl_ClassInfoI_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.DFinder',
      ["sidl/sidl_DFinder_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.DLL',
      ["sidl/sidl_DLL_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.Finder',
      ["sidl/sidl_Finder_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.InvViolation',
      ["sidl/sidl_InvViolation_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.LangSpecificException',
      ["sidl/sidl_LangSpecificException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.Loader',
      ["sidl/sidl_Loader_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.MemoryAllocationException',
      ["sidl/sidl_MemoryAllocationException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.NotImplementedException',
      ["sidl/sidl_NotImplementedException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.PostViolation',
      ["sidl/sidl_PostViolation_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.PreViolation',
      ["sidl/sidl_PreViolation_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.RuntimeException',
      ["sidl/sidl_RuntimeException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.SIDLException',
      ["sidl/sidl_SIDLException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.io.Deserializer',
      ["sidl/io/sidl_io_Deserializer_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.io.IOException',
      ["sidl/io/sidl_io_IOException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.io.Serializable',
      ["sidl/io/sidl_io_Serializable_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.io.Serializer',
      ["sidl/io/sidl_io_Serializer_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.BindException',
      ["sidl/rmi/sidl_rmi_BindException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.Call',
      ["sidl/rmi/sidl_rmi_Call_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.ConnectException',
      ["sidl/rmi/sidl_rmi_ConnectException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.ConnectRegistry',
      ["sidl/rmi/sidl_rmi_ConnectRegistry_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.InstanceHandle',
      ["sidl/rmi/sidl_rmi_InstanceHandle_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.InstanceRegistry',
      ["sidl/rmi/sidl_rmi_InstanceRegistry_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.Invocation',
      ["sidl/rmi/sidl_rmi_Invocation_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.MalformedURLException',
      ["sidl/rmi/sidl_rmi_MalformedURLException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.NetworkException',
      ["sidl/rmi/sidl_rmi_NetworkException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.NoRouteToHostException',
      ["sidl/rmi/sidl_rmi_NoRouteToHostException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.NoServerException',
      ["sidl/rmi/sidl_rmi_NoServerException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.ObjectDoesNotExistException',
      ["sidl/rmi/sidl_rmi_ObjectDoesNotExistException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.ProtocolException',
      ["sidl/rmi/sidl_rmi_ProtocolException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.ProtocolFactory',
      ["sidl/rmi/sidl_rmi_ProtocolFactory_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.Response',
      ["sidl/rmi/sidl_rmi_Response_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.Return',
      ["sidl/rmi/sidl_rmi_Return_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.ServerInfo',
      ["sidl/rmi/sidl_rmi_ServerInfo_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.ServerRegistry',
      ["sidl/rmi/sidl_rmi_ServerRegistry_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.Ticket',
      ["sidl/rmi/sidl_rmi_Ticket_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.TicketBook',
      ["sidl/rmi/sidl_rmi_TicketBook_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.TimeOutException',
      ["sidl/rmi/sidl_rmi_TimeOutException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.UnexpectedCloseException',
      ["sidl/rmi/sidl_rmi_UnexpectedCloseException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidl.rmi.UnknownHostException',
      ["sidl/rmi/sidl_rmi_UnknownHostException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.ChildSocket',
      ["sidlx/rmi/sidlx_rmi_ChildSocket_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.ClientSocket',
      ["sidlx/rmi/sidlx_rmi_ClientSocket_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.Common',
      ["sidlx/rmi/sidlx_rmi_Common_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.GenNetworkException',
      ["sidlx/rmi/sidlx_rmi_GenNetworkException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.IPv4Socket',
      ["sidlx/rmi/sidlx_rmi_IPv4Socket_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.JimEchoServer',
      ["sidlx/rmi/sidlx_rmi_JimEchoServer_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.NoServerException',
      ["sidlx/rmi/sidlx_rmi_NoServerException_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.ServerSocket',
      ["sidlx/rmi/sidlx_rmi_ServerSocket_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.SimCall',
      ["sidlx/rmi/sidlx_rmi_SimCall_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.SimHandle',
      ["sidlx/rmi/sidlx_rmi_SimHandle_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.SimReturn',
      ["sidlx/rmi/sidlx_rmi_SimReturn_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.SimpleOrb',
      ["sidlx/rmi/sidlx_rmi_SimpleOrb_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.SimpleServer',
      ["sidlx/rmi/sidlx_rmi_SimpleServer_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.SimpleTicket',
      ["sidlx/rmi/sidlx_rmi_SimpleTicket_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.SimpleTicketBook',
      ["sidlx/rmi/sidlx_rmi_SimpleTicketBook_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.Simsponse',
      ["sidlx/rmi/sidlx_rmi_Simsponse_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.Simvocation',
      ["sidlx/rmi/sidlx_rmi_Simvocation_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('sidlx.rmi.Socket',
      ["sidlx/rmi/sidlx_rmi_Socket_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs)
  ])
