/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iobjecthelp.h"


#include "ierror.h"
#include "ihelpfactory.h"
#include "iobject.h"


iObjectHelpBase::iObjectHelpBase(const char *tag)
{
	mData = 0; 

	if(strlen(tag) > 15)
	{
		IERROR_FATAL("Tag is too long.");
	}
	else strcpy(mTag,tag);
}


iObjectHelpBase::~iObjectHelpBase()
{ 
	if(mData != 0) delete mData; 
}


iString iObjectHelpBase::GetText(int length) const
{
	static const iString null;
	if(mData != 0) return mData->GetText(length); else return null;
}


iString iObjectHelpBase::GetHTML() const
{
	static const iString null;
	if(mData != 0) return mData->GetHTML(); else return null;
}


//
//  Extra controls
//
const iString iObjectHelpBase::GetExtraTag(int type) const
{
	static const iString null;
	if(mData != 0) return mData->GetExtraTag(type); else return null;
}


iObjectTypeHelp::iObjectTypeHelp(const iObjectType *type) : iObjectHelpBase(("or."+type->ShortName()).ToCharPointer())
{
	mType = type;
	if(type != 0)
	{
		mData = iHelpFactory::FindData(this->GetTag(),iHelpFactory::_ObjectReference,true);
	}
}


iObjectTypeHelp::~iObjectTypeHelp()
{
}


iObjectKeyHelp::iObjectKeyHelp(const iObjectKey *key) : iObjectHelpBase(("or."+key->HelpEntryKey()).ToCharPointer())
{
	mKey = key;
	if(key != 0)
	{
		mData = iHelpFactory::FindData(this->GetTag(),iHelpFactory::_ObjectReference,true);
	}
}


iObjectKeyHelp::~iObjectKeyHelp()
{
}

