/*
 * File    : ActivityEditorOptionsPanel.java
 * Created : 10-jun-2002 09:59
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic;

import edu.xtec.jclic.automation.AutoContentProvider;
import edu.xtec.jclic.automation.AutoContentProviderEditor;
import edu.xtec.jclic.bags.ActivityBagElementEditor;
import edu.xtec.jclic.bags.SelectActivityClass;
import edu.xtec.jclic.beans.EventSoundsButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.StrUtils;
import edu.xtec.util.TripleString;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.09.16
 */
public class ActivityEditorOptionsPanel extends ActivityEditorInternalPanel {
    
    List<TripleString> contentProviders, allContentProviders;
    
    /** Creates new form MenuEditorPanel */
    public ActivityEditorOptionsPanel(ActivityEditorPanel parent) {
        super(parent);
        allContentProviders=AutoContentProviderEditor.getSystemContentProvidersList(options);
        initComponents();
        checkContentProviders();
        evSoundsBtn.setOptions(options);
        setEnabled(false);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        javax.swing.ButtonGroup helpBtnButtonGroup = new javax.swing.ButtonGroup();
        javax.swing.ButtonGroup infoBtnButtonGroup = new javax.swing.ButtonGroup();
        scroll = new javax.swing.JScrollPane();
        javax.swing.JPanel mainPanel = new javax.swing.JPanel();
        descPanel = new edu.xtec.jclic.beans.RollPanel();
        javax.swing.JLabel classLb = new javax.swing.JLabel();
        className = new javax.swing.JLabel();
        chClassBtn = new javax.swing.JButton();
        chClassBtn.addActionListener(this);
        javax.swing.JLabel nameLb = new javax.swing.JLabel();
        nameText = new javax.swing.JLabel();
        chNameBtn = new javax.swing.JButton();
        chNameBtn.addActionListener(this);
        javax.swing.JLabel descLb = new javax.swing.JLabel();
        descScroll = new javax.swing.JScrollPane();
        descText = new javax.swing.JTextPane();
        reportPanel = new edu.xtec.jclic.beans.RollPanel();
        bIncludeInReportsChk = new javax.swing.JCheckBox();
        javax.swing.JLabel codeLb = new javax.swing.JLabel();
        codeText = new javax.swing.JTextField();
        bRegisterActionsChk = new javax.swing.JCheckBox();
        uiPanel = new edu.xtec.jclic.beans.RollPanel();
        javax.swing.JLabel skinLb = new javax.swing.JLabel();
        skinCombo = new javax.swing.JComboBox(edu.xtec.jclic.skins.Skin.getSystemSkinList(true));
        javax.swing.JLabel evSoundsLb = new javax.swing.JLabel();
        evSoundsBtn = new edu.xtec.jclic.beans.EventSoundsButton();
        autoCpPanel = new edu.xtec.jclic.beans.RollPanel();
        javax.swing.JLabel autoCpLb = new javax.swing.JLabel();
        autoCpCombo = new javax.swing.JComboBox();
        autoCpEditBtn = new javax.swing.JButton();
        countersPanel = new edu.xtec.jclic.beans.RollPanel();
        timeCounterChk = new javax.swing.JCheckBox();
        javax.swing.JLabel maxTimeLb = new javax.swing.JLabel();
        maxTimeInt = new edu.xtec.jclic.beans.SmallIntEditor();
        countdownTimeChk = new javax.swing.JCheckBox();
        actionsCounterChk = new javax.swing.JCheckBox();
        javax.swing.JLabel maxActionsLb = new javax.swing.JLabel();
        maxActionsInt = new edu.xtec.jclic.beans.SmallIntEditor();
        countdownActionsChk = new javax.swing.JCheckBox();
        scoreCounterChk = new javax.swing.JCheckBox();
        buttonsPanel = new edu.xtec.jclic.beans.RollPanel();
        helpBtnChk = new javax.swing.JCheckBox();
        helpBtnMsg = new javax.swing.JRadioButton();
        helpBtnSolution = new javax.swing.JRadioButton();
        helpBtnMsgScroll = new javax.swing.JScrollPane();
        helpBtnMsgText = new javax.swing.JTextArea();
        infoBtnChk = new javax.swing.JCheckBox();
        infoBtnUrlChk = new javax.swing.JRadioButton();
        infoBtnUrlTxt = new javax.swing.JTextField();
        infoBtnCmdChk = new javax.swing.JRadioButton();
        infoBtnCmdTxt = new javax.swing.JTextField();
        behaviorPanel = new edu.xtec.jclic.beans.RollPanel();
        javax.swing.JLabel scrambleTimesLb = new javax.swing.JLabel();
        scrambleTimesInt = new edu.xtec.jclic.beans.SmallIntEditor();
        dragCellsChk = new javax.swing.JCheckBox();
        orderChk = new javax.swing.JCheckBox();
        javax.swing.JLabel spacer = new javax.swing.JLabel();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        mainPanel.setLayout(new java.awt.GridBagLayout());

        descPanel.setTitle(options.getMsg("edit_act_description_block"));
        descPanel.getMainPanel().setLayout(new java.awt.GridBagLayout());

        classLb.setText(options.getMsg("edit_act_class"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        descPanel.getMainPanel().add(classLb, gridBagConstraints);

        className.setText(" ");
        className.setPreferredSize(new java.awt.Dimension(200, 21));
        className.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        descPanel.getMainPanel().add(className, gridBagConstraints);

        chClassBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/edit.gif"))); // NOI18N
        chClassBtn.setToolTipText(options.getMsg("edit_act_changeType"));
        chClassBtn.setText("");
        chClassBtn.setMargin(new java.awt.Insets(2, 2, 2, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        descPanel.getMainPanel().add(chClassBtn, gridBagConstraints);

        nameLb.setText(options.getMsg("edit_act_name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        descPanel.getMainPanel().add(nameLb, gridBagConstraints);

        nameText.setPreferredSize(new java.awt.Dimension(200, 21));
        nameText.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        nameText.setMinimumSize(new java.awt.Dimension(110, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        descPanel.getMainPanel().add(nameText, gridBagConstraints);

        chNameBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/edit.gif"))); // NOI18N
        chNameBtn.setToolTipText(options.getMsg("edit_media_change_name"));
        chNameBtn.setText("");
        chNameBtn.setMargin(new java.awt.Insets(2, 2, 2, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        descPanel.getMainPanel().add(chNameBtn, gridBagConstraints);

        descLb.setText(options.getMsg("edit_act_description"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        descPanel.getMainPanel().add(descLb, gridBagConstraints);

        descScroll.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        descScroll.setPreferredSize(new java.awt.Dimension(300, 60));
        descScroll.setMinimumSize(new java.awt.Dimension(150, 60));

        descText.setToolTipText(options.getMsg("edit_act_description_tooltip"));
        descText.getDocument().addDocumentListener(this);
        descScroll.setViewportView(descText);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        descPanel.getMainPanel().add(descScroll, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mainPanel.add(descPanel, gridBagConstraints);

        reportPanel.setTitle(options.getMsg("edit_act_reports_block"));
        reportPanel.getMainPanel().setLayout(new java.awt.GridBagLayout());

        bIncludeInReportsChk.setToolTipText(options.getMsg("edit_act_includeInReports_tooltip"));
        bIncludeInReportsChk.setText(options.getMsg("edit_act_includeInReports"));
        bIncludeInReportsChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        reportPanel.getMainPanel().add(bIncludeInReportsChk, gridBagConstraints);

        codeLb.setLabelFor(codeText);
        codeLb.setText(options.getMsg("edit_act_code"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        reportPanel.getMainPanel().add(codeLb, gridBagConstraints);

        codeText.setToolTipText(options.getMsg("edit_act_code_tooltip"));
        codeText.setPreferredSize(new java.awt.Dimension(80, 21));
        codeText.setMinimumSize(new java.awt.Dimension(80, 21));
        codeText.getDocument().addDocumentListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 4);
        reportPanel.getMainPanel().add(codeText, gridBagConstraints);

        bRegisterActionsChk.setToolTipText(options.getMsg("edit_act_reportActions_tooltip"));
        bRegisterActionsChk.setText(options.getMsg("edit_act_reportActions"));
        bRegisterActionsChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 13);
        reportPanel.getMainPanel().add(bRegisterActionsChk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mainPanel.add(reportPanel, gridBagConstraints);

        uiPanel.setTitle(options.getMsg("edit_act_ui_block"));
        uiPanel.getMainPanel().setLayout(new java.awt.GridBagLayout());

        skinLb.setText(options.getMsg("settings_skin"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        uiPanel.getMainPanel().add(skinLb, gridBagConstraints);

        skinCombo.setEditable(true);
        skinCombo.setToolTipText(options.getMsg("settings_skin_tooltip"));
        skinCombo.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        uiPanel.getMainPanel().add(skinCombo, gridBagConstraints);

        evSoundsLb.setLabelFor(evSoundsBtn);
        evSoundsLb.setText(options.getMsg("edit_act_evsounds"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        uiPanel.getMainPanel().add(evSoundsLb, gridBagConstraints);

        evSoundsBtn.setToolTipText(options.getMsg("edit_act_evsounds_tooltip"));
        evSoundsBtn.addPropertyChangeListener(EventSoundsButton.PROP_EVSND_NAME, this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        uiPanel.getMainPanel().add(evSoundsBtn, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mainPanel.add(uiPanel, gridBagConstraints);

        autoCpPanel.setTitle(options.getMsg("edit_autocp_block"));
        autoCpPanel.getMainPanel().setLayout(new java.awt.GridBagLayout());

        autoCpLb.setText(options.getMsg("edit_autocp"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        autoCpPanel.getMainPanel().add(autoCpLb, gridBagConstraints);

        autoCpCombo.setPreferredSize(new java.awt.Dimension(200, 26));
        autoCpCombo.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        autoCpPanel.getMainPanel().add(autoCpCombo, gridBagConstraints);

        autoCpEditBtn.setToolTipText(options.getMsg("edit_autocp_btn_tooltip"));
        autoCpEditBtn.setText(options.getMsg("edit_autocp_btn"));
        autoCpEditBtn.setEnabled(false);
        autoCpEditBtn.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        autoCpPanel.getMainPanel().add(autoCpEditBtn, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mainPanel.add(autoCpPanel, gridBagConstraints);

        countersPanel.setTitle(options.getMsg("edit_act_counters_block"));
        countersPanel.getMainPanel().setLayout(new java.awt.GridBagLayout());

        timeCounterChk.setToolTipText(options.getMsg("edit_act_timeCounter_tooltip"));
        timeCounterChk.setText(options.getMsg("edit_act_timeCounter"));
        timeCounterChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        countersPanel.getMainPanel().add(timeCounterChk, gridBagConstraints);

        maxTimeLb.setText(options.getMsg("edit_act_maxTime"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        countersPanel.getMainPanel().add(maxTimeLb, gridBagConstraints);

        maxTimeInt.setToolTipText(options.getMsg("edit_act_maxTime_tooltip"));
        maxTimeInt.setMax(999);
        maxTimeInt.addPropertyChangeListener(SmallIntEditor.PROP_VALUE, this);
        countersPanel.getMainPanel().add(maxTimeInt, new java.awt.GridBagConstraints());

        countdownTimeChk.setToolTipText(options.getMsg("edit_act_countdown_tooltip"));
        countdownTimeChk.setText(options.getMsg("edit_act_countdown"));
        countdownTimeChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        countersPanel.getMainPanel().add(countdownTimeChk, gridBagConstraints);

        actionsCounterChk.setToolTipText(options.getMsg("edit_act_actionsCounter_tooltip"));
        actionsCounterChk.setText(options.getMsg("edit_act_actionsCounter"));
        actionsCounterChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        countersPanel.getMainPanel().add(actionsCounterChk, gridBagConstraints);

        maxActionsLb.setText(options.getMsg("edit_act_maxActions"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        countersPanel.getMainPanel().add(maxActionsLb, gridBagConstraints);

        maxActionsInt.setToolTipText(options.getMsg("edit_act_maxActions_tooltip"));
        maxActionsInt.setMax(999);
        maxActionsInt.addPropertyChangeListener(SmallIntEditor.PROP_VALUE, this);
        countersPanel.getMainPanel().add(maxActionsInt, new java.awt.GridBagConstraints());

        countdownActionsChk.setToolTipText(options.getMsg("edit_act_countdown_tooltip"));
        countdownActionsChk.setText(options.getMsg("edit_act_countdown"));
        countdownActionsChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        countersPanel.getMainPanel().add(countdownActionsChk, gridBagConstraints);

        scoreCounterChk.setText(options.getMsg("edit_act_scoreCounter"));
        scoreCounterChk.setToolTipText(options.getMsg("edit_act_scoreCounter_tooltip"));
        scoreCounterChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        countersPanel.getMainPanel().add(scoreCounterChk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mainPanel.add(countersPanel, gridBagConstraints);

        buttonsPanel.setTitle(options.getMsg("edit_act_buttons_block"));
        buttonsPanel.getMainPanel().setLayout(new java.awt.GridBagLayout());

        helpBtnChk.setText(options.getMsg("edit_act_helpBtn"));
        helpBtnChk.setToolTipText(options.getMsg("edit_act_helpBtn_tooltip"));
        helpBtnChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        buttonsPanel.getMainPanel().add(helpBtnChk, gridBagConstraints);

        helpBtnButtonGroup.add(helpBtnMsg);
        helpBtnMsg.setText(options.getMsg("edit_act_helpBtn_msg"));
        helpBtnMsg.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        buttonsPanel.getMainPanel().add(helpBtnMsg, gridBagConstraints);

        helpBtnButtonGroup.add(helpBtnSolution);
        helpBtnSolution.setText(options.getMsg("edit_act_helpBtn_solution"));
        helpBtnSolution.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        buttonsPanel.getMainPanel().add(helpBtnSolution, gridBagConstraints);

        helpBtnMsgScroll.setPreferredSize(new java.awt.Dimension(300, 60));
        helpBtnMsgScroll.setMinimumSize(new java.awt.Dimension(150, 60));

        helpBtnMsgText.setWrapStyleWord(true);
        helpBtnMsgText.setLineWrap(true);
        helpBtnMsgText.getDocument().addDocumentListener(this);
        helpBtnMsgScroll.setViewportView(helpBtnMsgText);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        buttonsPanel.getMainPanel().add(helpBtnMsgScroll, gridBagConstraints);

        infoBtnChk.setToolTipText(options.getMsg("edit_act_infoBtn_tooltip"));
        infoBtnChk.setText(options.getMsg("edit_act_infoBtn"));
        infoBtnChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(9, 3, 3, 3);
        buttonsPanel.getMainPanel().add(infoBtnChk, gridBagConstraints);

        infoBtnButtonGroup.add(infoBtnUrlChk);
        infoBtnUrlChk.setText(options.getMsg("edit_act_infoBtn_url"));
        infoBtnUrlChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        buttonsPanel.getMainPanel().add(infoBtnUrlChk, gridBagConstraints);

        infoBtnUrlTxt.setToolTipText(options.getMsg("edit_act_infoBtn_url_tooltip"));
        infoBtnUrlTxt.setPreferredSize(new java.awt.Dimension(300, 21));
        infoBtnUrlTxt.setMinimumSize(new java.awt.Dimension(100, 21));
        infoBtnUrlTxt.getDocument().addDocumentListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        buttonsPanel.getMainPanel().add(infoBtnUrlTxt, gridBagConstraints);

        infoBtnButtonGroup.add(infoBtnCmdChk);
        infoBtnCmdChk.setText(options.getMsg("edit_act_infoBtn_cmd"));
        infoBtnCmdChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        buttonsPanel.getMainPanel().add(infoBtnCmdChk, gridBagConstraints);

        infoBtnCmdTxt.setToolTipText(options.getMsg("edit_act_infoBtn_cmd_tooltip"));
        infoBtnCmdTxt.setPreferredSize(new java.awt.Dimension(300, 21));
        infoBtnCmdTxt.setMinimumSize(new java.awt.Dimension(100, 21));
        infoBtnCmdTxt.getDocument().addDocumentListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        buttonsPanel.getMainPanel().add(infoBtnCmdTxt, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mainPanel.add(buttonsPanel, gridBagConstraints);

        behaviorPanel.setTitle(options.getMsg("edit_act_behavior_block"));
        behaviorPanel.getMainPanel().setLayout(new java.awt.GridBagLayout());

        scrambleTimesLb.setLabelFor(scrambleTimesInt);
        scrambleTimesLb.setText(options.getMsg("edit_act_behavior_scramble_times"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        behaviorPanel.getMainPanel().add(scrambleTimesLb, gridBagConstraints);

        scrambleTimesInt.setToolTipText(options.getMsg("edit_act_behavior_scramble_times_tooltip"));
        scrambleTimesInt.setMax(999);
        scrambleTimesInt.setMin(1);
        scrambleTimesInt.setValue(30);
        scrambleTimesInt.addPropertyChangeListener(SmallIntEditor.PROP_VALUE, this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        behaviorPanel.getMainPanel().add(scrambleTimesInt, gridBagConstraints);

        dragCellsChk.setText(options.getMsg("edit_act_behavior_drag"));
        dragCellsChk.setToolTipText(options.getMsg("edit_act_behavior_drag_tooltip"));
        dragCellsChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        behaviorPanel.getMainPanel().add(dragCellsChk, gridBagConstraints);

        orderChk.setText(options.getMsg("edit_act_behavior_order"));
        orderChk.setToolTipText(options.getMsg("edit_act_behavior_order_tooltip"));
        orderChk.addActionListener(this);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        behaviorPanel.getMainPanel().add(orderChk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mainPanel.add(behaviorPanel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        mainPanel.add(spacer, gridBagConstraints);

        scroll.setViewportView(mainPanel);

        add(scroll);
    }// </editor-fold>//GEN-END:initComponents
                

    @Override
    public void setEnabled(boolean enabled){
        super.setEnabled(enabled);
        chNameBtn.setEnabled(enabled);
        chClassBtn.setEnabled(enabled);
        descText.setEnabled(enabled);
        bIncludeInReportsChk.setEnabled(enabled);
        skinCombo.setEnabled(enabled);
        evSoundsBtn.setEnabled(enabled);
        autoCpCombo.setEnabled(enabled);
        timeCounterChk.setEnabled(enabled);
        actionsCounterChk.setEnabled(enabled);
        scoreCounterChk.setEnabled(enabled);        
        helpBtnChk.setEnabled(enabled);
        infoBtnChk.setEnabled(enabled);
        scrambleTimesInt.setEnabled(enabled);
        dragCellsChk.setEnabled(enabled);
        orderChk.setEnabled(enabled);
        checkEnabled();
    }
    
    protected void checkEnabled(){
        boolean e=isEnabled();
        
        boolean b=e && bIncludeInReportsChk.isSelected();
        bRegisterActionsChk.setEnabled(b);
        codeText.setEnabled(b);
        
        autoCpEditBtn.setEnabled(e && autoCpCombo.getSelectedIndex()>0);
        
        b = e && timeCounterChk.isSelected();
        maxTimeInt.setEnabled(b);
        countdownTimeChk.setEnabled(b && maxTimeInt.getValue()>0);
        
        b = e && actionsCounterChk.isSelected();
        maxActionsInt.setEnabled(b);
        countdownActionsChk.setEnabled(b && maxActionsInt.getValue()>0);
        
        b = e && helpBtnChk.isSelected();
        helpBtnSolution.setEnabled(b);
        helpBtnMsg.setEnabled(b);
        helpBtnMsgText.setEnabled(b && helpBtnMsg.isSelected());
        helpBtnMsgScroll.setEnabled(b && helpBtnMsg.isSelected());
        
        b = e && infoBtnChk.isSelected();
        infoBtnUrlChk.setEnabled(b);
        infoBtnUrlTxt.setEnabled(b && infoBtnUrlChk.isSelected());
        infoBtnCmdChk.setEnabled(b);
        infoBtnCmdTxt.setEnabled(b && infoBtnCmdChk.isSelected());
        
    }
    
    private void checkContentProviders(){
        Activity act=getActivity();
        if(contentProviders==null){
            contentProviders=new ArrayList<TripleString>(allContentProviders.size());
        }
        else{
            contentProviders.clear();
        }
        autoCpCombo.removeAllItems();
        for (TripleString ts : allContentProviders) {
            boolean  isOk= (ts.getClassName()==null);
            if(!isOk && act!=null)
                isOk=AutoContentProvider.checkClient(ts.getClassName(), act.getClass());
            if(isOk){
                contentProviders.add(ts);
                autoCpCombo.addItem(ts);
            }
        }
    }
    
    public void fillData() {
        Activity act=getActivity();
        
        nameText.setText(act==null ? options.getMsg("UNNAMED") : act.name);
        descText.setText(act==null ? "" : act.description==null ? "" : act.description);
        String s= act==null ? "" : act.getShortClassName();
        if(s.startsWith(Activity.BASE_CLASS_TAG))
            s=s.substring(1);
        className.setText(s);
        
        bIncludeInReportsChk.setSelected(act==null ? true : act.includeInReports);
        bRegisterActionsChk.setSelected(act==null ? false : act.reportActions);
        codeText.setText(act==null ? "" : act.code);
        skinCombo.setSelectedItem(act==null ? null : act.skinFileName);
        evSoundsBtn.setMediaBagEditor(act==null ? null : getActivityEditor().getProjectEditor().getMediaBagEditor());
        evSoundsBtn.setEventSounds(act==null ? null : act.eventSounds);
        evSoundsBtn.setModified(false);
        checkContentProviders();
        String acpClassName=(act==null || act.acp==null) ? null : act.acp.getShortClassName();
        int index=Math.max(0, TripleString.getFirstItemWithClass(contentProviders, acpClassName));
        autoCpCombo.setSelectedIndex(index);
        
        timeCounterChk.setSelected(act==null ? true : act.bTimeCounter);
        maxTimeInt.setValue(act==null ? 0 : act.maxTime);
        countdownTimeChk.setSelected(act==null ? false : act.countDownTime);
        
        actionsCounterChk.setSelected(act==null ? false : act.bActionsCounter);
        maxActionsInt.setValue(act==null ? 0 : act.maxActions);
        countdownActionsChk.setSelected(act==null ? false : act.countDownActions);
        
        scoreCounterChk.setSelected(act==null ? true : act.bScoreCounter);
        
        helpBtnChk.setSelected(act==null ? true : act.helpWindow);
        boolean helpSolution = act!=null && (act.showSolution || act.helpMsg==null || act.helpMsg.length()==0);
        helpBtnSolution.setSelected(helpSolution);
        helpBtnMsg.setSelected(!helpSolution);
        helpBtnMsgText.setText(act==null ? "" : act.helpMsg);
        
        int v=0;
        if(act!=null && act.infoUrl!=null && act.infoUrl.length()>0)
            v=1;
        else if(act!=null && act.infoCmd!=null && act.infoCmd.length()>0)
            v=2;
        
        infoBtnChk.setSelected(v>0);
        infoBtnUrlChk.setSelected(v!=2);
        infoBtnCmdChk.setSelected(v==2);
        infoBtnUrlTxt.setText(act==null ? "" : act.infoUrl);
        infoBtnCmdTxt.setText(act==null ? "" : act.infoCmd);
        
        if(act!=null && act.hasRandom()){
            scrambleTimesInt.setValue(act.shuffles);
            //behaviorPanel.setVisible(true);
        }
        else{
            //behaviorPanel.setVisible(false);
        }
        
        dragCellsChk.setSelected(act==null ? false : act.dragCells);
        orderChk.setSelected(act==null ? false : act.useOrder);
        
        checkEnabled();
    }
    
    public void saveData(){
        Activity act=getActivity();
        if(act!=null){
            
            act.description=descText.getText();
            
            act.includeInReports=bIncludeInReportsChk.isSelected();
            act.reportActions=bRegisterActionsChk.isSelected();
            act.code=codeText.getText();
            act.skinFileName=(String)skinCombo.getSelectedItem();
            act.eventSounds=evSoundsBtn.getEventSounds();
            evSoundsBtn.setModified(false);
            
            act.bTimeCounter=timeCounterChk.isSelected();
            act.maxTime=maxTimeInt.getValue();
            act.countDownTime=countdownTimeChk.isSelected();
            
            act.bActionsCounter=actionsCounterChk.isSelected();
            act.maxActions= maxActionsInt.getValue();
            act.countDownActions=countdownActionsChk.isSelected();
            
            act.bScoreCounter=scoreCounterChk.isSelected();
            
            act.helpWindow=helpBtnChk.isSelected();
            act.showSolution=helpBtnSolution.isSelected();
            act.helpMsg=StrUtils.nullableString(helpBtnMsgText.getText());
            
            int v=0;
            if(infoBtnChk.isSelected()){
                if(infoBtnUrlChk.isSelected()){
                    act.infoUrl=StrUtils.nullableString(infoBtnUrlTxt.getText());
                    act.infoCmd=null;
                } else{
                    act.infoUrl=null;
                    act.infoCmd=StrUtils.nullableString(infoBtnCmdTxt.getText());
                }
            }
            else{
                act.infoUrl=null;
                act.infoCmd=null;
            }
            
            if(act.hasRandom())
                act.shuffles=scrambleTimesInt.getValue();
            
            act.dragCells=dragCellsChk.isSelected();
            act.useOrder=orderChk.isSelected();
        }
    }
        
    private static SelectActivityClass sac;
    
    @Override
    public boolean eventPerformed(EventObject ev){
        
        Object cmp=ev==null ? null : ev.getSource();
        boolean result=(cmp!=null);
        final ActivityEditor aed=getActivityEditor();
        
        if(cmp==chClassBtn && aed!=null){
            if(sac==null){
                sac=new SelectActivityClass(options);
                sac.setAlertMsg(options.getMsg("edit_act_changeType_warning"));
            }
            String oldClassName=getActivity().getShortClassName();            
            sac.setCurrentClassName(oldClassName);
            sac.setListFilter(getActivity().getSimilarActivityClasses(), true);
            if((result= getOptions().getMessages().showInputDlg(this, sac, "edit_act_changeType")
              && sac.getCurrentClassName()!=null 
              && !oldClassName.equals(sac.getCurrentClassName()))){
                ActivityBagElementEditor abed=aed.getActivityBagElementEditor();
                aed.collectData();
                aed.saveData();
                try{
                    abed.changeActivityClass(sac.getCurrentClassName());
                    abed.reselect();
                } catch(Exception ex){
                    options.getMessages().showErrorWarning(this, "ERROR", ex);
                }
            }
        }
        else if(cmp==chNameBtn && aed!=null){
            final String oldName=getActivity().name;
            final String newName=options.getMessages().showInputDlg(this, 
            "edit_media_rename", "edit_media_rename_prompt", oldName, 
            "edit_media_rename_title", false);
            if((result=newName!=null && !newName.equals(oldName))){
                final ProgressDialog progressDialog=new ProgressDialog(this, options);
                edu.xtec.util.SwingWorker sw=new edu.xtec.util.SwingWorker(){ 
                    
                    @Override
                    public Object construct(){
                        aed.rename(newName, ActivityEditorOptionsPanel.this, options.getMessages());
                        aed.getActivityBagElementEditor().reselect();
                        return null;
                    }
                    
                    @Override
                    public void finished(){
                        //nameText.setText(newName);
                        progressDialog.setVisible(false);                        
                    }
                };
                progressDialog.start("edit_media_rename", "edit_media_renaming", sw, false, false, false);                    
            }
        }        
        else if(cmp==autoCpCombo && aed!=null){
            AutoContentProviderEditor acped=aed.getAutoContentProviderEditor();
            TripleString ts=(TripleString)autoCpCombo.getSelectedItem();
            String acpClassName=ts==null ? null : ts.getClassName();
            if(acped!=null){
                if(acped.getAutoContentProvider().getShortClassName().equals(acpClassName))
                    return false;
                acped.removeFromParent();
                aed.getActivity().acp=null;
            }
            if(acpClassName!=null){
                try{
                    AutoContentProvider acp=AutoContentProvider.getAutoContentProvider(acpClassName);
                    aed.getActivity().acp=acp;
                    acp.getEditor(aed);
                } catch(Exception ex){
                    options.getMessages().showErrorWarning(this, "edit_acp_err_creating", ex);
                    aed.getActivity().acp=null;
                }
            }
        }
        else if(cmp==autoCpEditBtn && aed!=null){
            AutoContentProviderEditor acped=(AutoContentProviderEditor)aed.getFirstChild(AutoContentProviderEditor.class);
            if(acped!=null)
                acped.editData(this, options);
        }        
        
        if(result)
            checkEnabled();
        return result;
    }
    
    protected javax.swing.Icon getIcon(){
        return edu.xtec.util.ResourceManager.getImageIcon("icons/options.gif");
    }
    
    protected String getTitle() {
        return options.getMsg("edit_act_panels_options");
    }
    
    protected String getTooltip() {
        return options.getMsg("edit_act_panels_options_tooltip");
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox actionsCounterChk;
    private javax.swing.JComboBox autoCpCombo;
    private javax.swing.JButton autoCpEditBtn;
    private edu.xtec.jclic.beans.RollPanel autoCpPanel;
    private javax.swing.JCheckBox bIncludeInReportsChk;
    private javax.swing.JCheckBox bRegisterActionsChk;
    private edu.xtec.jclic.beans.RollPanel behaviorPanel;
    private edu.xtec.jclic.beans.RollPanel buttonsPanel;
    private javax.swing.JButton chClassBtn;
    private javax.swing.JButton chNameBtn;
    private javax.swing.JLabel className;
    private javax.swing.JTextField codeText;
    private javax.swing.JCheckBox countdownActionsChk;
    private javax.swing.JCheckBox countdownTimeChk;
    private edu.xtec.jclic.beans.RollPanel countersPanel;
    private edu.xtec.jclic.beans.RollPanel descPanel;
    private javax.swing.JScrollPane descScroll;
    private javax.swing.JTextPane descText;
    private javax.swing.JCheckBox dragCellsChk;
    private edu.xtec.jclic.beans.EventSoundsButton evSoundsBtn;
    private javax.swing.JCheckBox helpBtnChk;
    private javax.swing.JRadioButton helpBtnMsg;
    private javax.swing.JScrollPane helpBtnMsgScroll;
    private javax.swing.JTextArea helpBtnMsgText;
    private javax.swing.JRadioButton helpBtnSolution;
    private javax.swing.JCheckBox infoBtnChk;
    private javax.swing.JRadioButton infoBtnCmdChk;
    private javax.swing.JTextField infoBtnCmdTxt;
    private javax.swing.JRadioButton infoBtnUrlChk;
    private javax.swing.JTextField infoBtnUrlTxt;
    private edu.xtec.jclic.beans.SmallIntEditor maxActionsInt;
    private edu.xtec.jclic.beans.SmallIntEditor maxTimeInt;
    private javax.swing.JLabel nameText;
    private javax.swing.JCheckBox orderChk;
    private edu.xtec.jclic.beans.RollPanel reportPanel;
    private javax.swing.JCheckBox scoreCounterChk;
    private edu.xtec.jclic.beans.SmallIntEditor scrambleTimesInt;
    private javax.swing.JScrollPane scroll;
    private javax.swing.JComboBox skinCombo;
    private javax.swing.JCheckBox timeCounterChk;
    private edu.xtec.jclic.beans.RollPanel uiPanel;
    // End of variables declaration//GEN-END:variables
    
}
