/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
* This program is free software; you can redistribute it and/or           *
* modify it either under the terms of the GNU Lesser General Public       *
* License version 3 as published by the Free Software Foundation          *
* (the "LGPL") or, at your option, any later version.                     *
* If you do not alter this notice, a recipient may use your version       *
* of this file under the LGPL.                                            *
*                                                                         *
* You should have received a copy of the LGPL along with this library     *
* in the file COPYING; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                         *
* This software is distributed on an "AS IS" basis, WITHOUT WARRANTY      *
* OF ANY KIND, either express or implied. See the LGPL for                *
* the specific language governing rights and limitations.                 *
**************************************************************************/

#include "aes_utils.h"

std::string aes_encrypt(std::string in, std::string key){
    size_t textLength = ((in.length() / AES_BLOCK_SIZE)
                         + 1)  * AES_BLOCK_SIZE;

    if(key.length() < 32){
        key.append(32 - key.length(), '\0');
    }
    unsigned char *output = new unsigned char[textLength];

    AES_KEY *aesKey = new AES_KEY;
    AES_set_encrypt_key((unsigned char*)key.c_str(),
                        256, aesKey);

    AES_cbc_encrypt((unsigned char*)in.c_str(), output,
                    in.length() + 1,
                    aesKey, (unsigned char*)key.substr(16).c_str(), AES_ENCRYPT);

    std::string ret((char*) output, textLength);
    delete output;
    delete aesKey;

    return encode(ret);
}


std::string aes_decrypt(std::string in, std::string key){
    in = decode(in);
    if(key.length() < 32){
        key.append(32 - key.length(), '\0');
    }

    unsigned char *output = new unsigned char[in.length()];

    AES_KEY *aesKey = new AES_KEY;
    AES_set_decrypt_key((unsigned char*)key.c_str(), 256, aesKey); // key length is in bits, so 32 * 8 = 256

    AES_cbc_encrypt((unsigned char*)in.c_str(), output, in.length(), aesKey, (unsigned char*)key.substr(16).c_str(), AES_DECRYPT);

    std::string ret((char*) output);

    delete output;
    delete aesKey;

    return ret;
}
