; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,AVX512F
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=CHECK,AVX512DQ
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512f,+avx512vl,+avx512dq | FileCheck %s --check-prefixes=CHECK,AVX512DQVL

define <4 x i64> @PR32546(<8 x float> %a, <8 x float> %b, <8 x float> %c, <8 x float> %d) {
; AVX512F-LABEL: PR32546:
; AVX512F:       ## %bb.0: ## %entry
; AVX512F-NEXT:    ## kill: def $ymm3 killed $ymm3 def $zmm3
; AVX512F-NEXT:    ## kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vcmpltps %zmm3, %zmm2, %k1
; AVX512F-NEXT:    vcmpltps %zmm1, %zmm0, %k0 {%k1}
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    movzbl %al, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vpbroadcastd %xmm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512DQ-LABEL: PR32546:
; AVX512DQ:       ## %bb.0: ## %entry
; AVX512DQ-NEXT:    ## kill: def $ymm3 killed $ymm3 def $zmm3
; AVX512DQ-NEXT:    ## kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512DQ-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512DQ-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcmpltps %zmm3, %zmm2, %k1
; AVX512DQ-NEXT:    vcmpltps %zmm1, %zmm0, %k0 {%k1}
; AVX512DQ-NEXT:    kmovb %k0, %eax
; AVX512DQ-NEXT:    vmovd %eax, %xmm0
; AVX512DQ-NEXT:    vpbroadcastd %xmm0, %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512DQVL-LABEL: PR32546:
; AVX512DQVL:       ## %bb.0: ## %entry
; AVX512DQVL-NEXT:    vcmpltps %ymm3, %ymm2, %k1
; AVX512DQVL-NEXT:    vcmpltps %ymm1, %ymm0, %k0 {%k1}
; AVX512DQVL-NEXT:    kmovb %k0, %eax
; AVX512DQVL-NEXT:    vpbroadcastd %eax, %ymm0
; AVX512DQVL-NEXT:    retq
entry:
  %0 = tail call i8 @llvm.x86.avx512.mask.cmp.ps.256(<8 x float> %a, <8 x float> %b, i32 1, i8 -1)
  %1 = tail call i8 @llvm.x86.avx512.mask.cmp.ps.256(<8 x float> %c, <8 x float> %d, i32 1, i8 -1)
  %and17 = and i8 %1, %0
  %and = zext i8 %and17 to i32
  %2 = insertelement <8 x i32> undef, i32 %and, i32 0
  %vecinit7.i = shufflevector <8 x i32> %2, <8 x i32> undef, <8 x i32> zeroinitializer
  %3 = bitcast <8 x i32> %vecinit7.i to <4 x i64>
  ret <4 x i64> %3
}
 declare i8 @llvm.x86.avx512.mask.cmp.ps.256(<8 x float>, <8 x float>, i32, i8)
