/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionList;
import java.util.LinkedList;

public class TryBlock {
    private InstructionList instructions;
    private LinkedList exceptionHandlers = new LinkedList();

    TryBlock(InstructionList instructions) {
        this.instructions = instructions;
    }

    void addExceptionHandler(String name, Instruction handlerStart) {
        this.exceptionHandlers.add(new ExceptionHandler(name, handlerStart));
    }

    public ExceptionHandler[] getExceptionHandlers() {
        ExceptionHandler[] handlers = new ExceptionHandler[this.exceptionHandlers.size()];
        handlers = this.exceptionHandlers.toArray(handlers);
        return handlers;
    }

    public InstructionList getInstructionList() {
        return this.instructions;
    }

    public class ExceptionHandler {
        private Instruction handlerStart;
        private String name;

        ExceptionHandler(String name, Instruction handlerStart) {
            this.name = name;
            this.handlerStart = handlerStart;
        }

        public Instruction getHandlerStart() {
            return this.handlerStart;
        }

        public String getName() {
            return this.name;
        }
    }
}

