/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#include <Common.hpp>

#if   !defined(__ENGINE_HPP)
#include <Engine.hpp>
#endif 

using namespace corelinux;

//
// Default constructor
//

Engine::Engine( void ) 
   :
   Prototype<Engine>()
{
   ;  // do nothing
}

//
// Copy constructor
//

Engine::Engine( EngineCref aRef ) 
   :
   Prototype<Engine>(aRef)
{
   ;  // do nothing
}

//
// Destructor
//

Engine::~Engine( void )
{
   ;  // do nothing,
}

//
// Assignment operator
//

EngineRef   Engine::operator=( EngineCref aRef ) 
{
   return (*this);
}

//
// Equality operator, here we check if the engine cylinders are
// equal.
//
         
bool     Engine::operator==( EngineCref aRef ) const
{
   return (this->getCylinders() == aRef.getCylinders());
}


/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/11 03:22:19 $
   $Locker:  $
*/




