/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

/**
 * This class uses tests the Base64 class for proper behavior.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class Base64Test
	extends junit.framework.TestCase
{

	public Base64Test(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(Base64Test.class);
	}

	public void test() 
		throws Exception
	{
		assertTrue(Base64.getInstance() != null);

		for (int size = 64; size < 75; size++) {
			byte[] stuff = new byte[size];
			java.util.Random r = new java.util.Random();
			r.nextBytes(stuff);
			String out = new String(Base64.getInstance().encode(stuff));
			byte[] outb = Base64.getInstance().decode(out.toCharArray());
			for (int i = 0; i < stuff.length; i++)
				assertEquals(stuff[i], outb[i]);
		}

		try {
			Base64.getInstance().decode("\t\t\t\t\t=".toCharArray());
			fail("Should have failed decoding array");
		} catch (Base64Exception be) {
		}
	}
}
