with Ada.Text_IO; use Ada.Text_IO;
with B;
pragma Warnings (Off);
--  Add an explicit with to remove target dependent output
with System.Arith_64; with System.Soft_Links;
pragma Warnings (On);

--  So that this test works both with sjlj and zcx runtimes
with Ada.Exceptions;

procedure Rename is 
   --  Renaming subprograms

   procedure D is begin null; end D;

   procedure Bar;
   procedure Foo renames Bar;
   procedure Foo3;
   procedure Foo3 renames Bar; --  Rename as body

   procedure Bar is begin D; end Bar;

   --  Renaming subprogram from other package
   procedure Bar2 renames B.B_Foo;


   --  Rename intrisic subprogram
   function Next (A : Integer) return Integer renames Integer'Succ;
   function Equal (A, B : Integer) return Boolean renames "=";

   --  Renaming array indexes 
   --  Note: AI reference the value Arr (1)

   Arr : array (1 ..4) of Integer;
   I   : Integer := 1;
   AI  : Integer renames Arr (I);

   --  Renaming variable
   X : Integer;
   Y : Integer renames X;

   procedure C is
   begin
      Foo;
   end C;

begin
   Bar;
   Foo;

   Bar2;
   B.B_Foo;

   I := 1;
   AI := 2;

   X := 1;
   Y := 1;

   I := Next (I);

   --  Result in "1"
   Arr (1) := 1;
   Arr (2) := 2;
   Arr (3) := 3;
   Arr (4) := 4;
   I := 2;
   Put_Line ("Arr(2)=" & AI'Img);

end Rename;
