/*
 * State.java - 0.9.0    01/07/2001 - 15:47:55
 *
 * Copyright (C) 2000,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.groboclown.util.states.v1;


/**
 * The basic state object.
 *
 * @author Matt Albrecht
 * @version 0.9.0 Alpha
 */
public class State
{
    //---------------------------------------------------------------------
    // Public Static Fields
     
     
    //---------------------------------------------------------------------
    // Protected Static Fields
     
     
    //---------------------------------------------------------------------
    // Private Static Fields
     
     
    //---------------------------------------------------------------------
    // Public Fields
     
     
    //---------------------------------------------------------------------
    // Protected Fields
     
     
    //---------------------------------------------------------------------
    // Private Fields
    
    private int index;
    private int category;
     
     
     
    //---------------------------------------------------------------------
    // Constructors
     
     
    /**
     * Default Constructor - protected
     */
    protected State( int stateCategory, int stateIndex )
    {
        this.index = stateIndex;
        this.category = stateCategory;
    }
     
     
     
     
     
    //---------------------------------------------------------------------
    // Public Methods
     
    public boolean equals( Object o )
    {
        if (o == null) return false;
        if (o == this) return true;
        if (o instanceof State)
        {
            State s = (State)o;
            if (s.index == this.index && s.category == this.category)
            {
                return true;
            }
        }
        return false;
    }
    
    
    public int hashcode()
    {
        return this.index + this.category;
    }
    
    protected boolean isSameCategory( State s )
    {
        return (s.category == this.category);
    }
     
    //---------------------------------------------------------------------
    // Protected Methods
    
    
    protected int getIndex()
    {
        return this.index;
    }
    
    protected int getCategory()
    {
        return this.category;
    }
    
    
     
    //---------------------------------------------------------------------
    // Private Methods
}
 
