package org.jboss.cache.transaction;

import javax.naming.InitialContext;
import javax.transaction.TransactionManager;


/**
 * Uses JNDI to look-up the
 * {@link TransactionManager} instance from "java:/TransactionManager".
 *
 * @author Bela Ban, Aug 26 2003
 * @version $Id: JBossTransactionManagerLookup.java 4834 2007-12-11 17:28:33Z manik.surtani@jboss.com $
 */
public class JBossTransactionManagerLookup implements TransactionManagerLookup
{

   public TransactionManager getTransactionManager() throws Exception
   {
      return (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
   }

}
