package org.jboss.cache.marshall;

import org.testng.annotations.Test;

@Test(groups = {"functional"})
public abstract class RegionBasedMarshallingTestBase
{
   protected static final String ADDRESS_CLASSNAME = "org.jboss.cache.marshall.data.Address";
   protected static final String PERSON_CLASSNAME = "org.jboss.cache.marshall.data.Person";
   protected ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();

   protected ClassLoader getClassLoader() throws Exception
   {
      String[] includesClasses = {PERSON_CLASSNAME, ADDRESS_CLASSNAME};
      String[] excludesClasses = {};
      ClassLoader cl = Thread.currentThread().getContextClassLoader();
      return new SelectedClassnameClassLoader(includesClasses, excludesClasses, cl);
   }

   protected ClassLoader getFailingClassLoader() throws Exception
   {
      String[] includesClasses = {};
      String[] excludesClasses = {};
      String[] failingClasses = {PERSON_CLASSNAME, ADDRESS_CLASSNAME};
      ClassLoader cl = Thread.currentThread().getContextClassLoader();
      return new SelectedClassnameClassLoader(includesClasses, excludesClasses, failingClasses, cl);
   }

   protected void resetContextClassLoader()
   {
      Thread.currentThread().setContextClassLoader(originalClassLoader);
   }
}
