/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.devstudio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import net.sf.antcontrib.cpptasks.devstudio.DevStudioCCompiler;
import net.sf.antcontrib.cpptasks.ide.ProjectDef;
import net.sf.antcontrib.cpptasks.ide.ProjectWriter;
import org.apache.tools.ant.BuildException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class VisualStudioNETProjectWriter
implements ProjectWriter {
    private String version;

    public VisualStudioNETProjectWriter(String versionArg) {
        this.version = versionArg;
    }

    public void writeProject(File fileName, CCTask task, ProjectDef projectDef, List sources, Hashtable targets, TargetInfo linkTarget) throws IOException, SAXException {
        ProcessorConfiguration config;
        boolean isDebug = task.getDebug();
        String projectName = projectDef.getName();
        if (projectName == null) {
            projectName = fileName.getName();
        }
        File dspFile = new File(fileName + ".dsp");
        if (!projectDef.getOverwrite() && dspFile.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + dspFile.toString());
        }
        File dswFile = new File(fileName + ".dsw");
        if (!projectDef.getOverwrite() && dswFile.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + dswFile.toString());
        }
        CommandLineCompilerConfiguration compilerConfig = this.getBaseCompilerConfiguration(targets);
        if (compilerConfig == null) {
            throw new BuildException("Unable to generate Visual Studio.NET project when Microsoft C++ is not used.");
        }
        FileOutputStream outStream = new FileOutputStream(fileName + ".vcproj");
        OutputFormat format = new OutputFormat("xml", "UTF-8", true);
        XMLSerializer serializer = new XMLSerializer((OutputStream)outStream, format);
        ContentHandler content = serializer.asContentHandler();
        String basePath = fileName.getParentFile().getAbsolutePath();
        content.startDocument();
        AttributesImpl emptyAttrs = new AttributesImpl();
        this.startElement(content, "VisualStudioProject", new String[]{"ProjectType", "Version", "Name", "SccProjectName", "SccLocalPath"}, new String[]{"Visual C++", this.version, projectName, "", ""});
        content.startElement(null, "Platforms", "Platforms", emptyAttrs);
        this.startElement(content, "Platform", new String[]{"Name"}, new String[]{"Win32"});
        content.endElement(null, "Platform", "Platform");
        content.endElement(null, "Platforms", "Platforms");
        content.startElement(null, "Configurations", "Configurations", emptyAttrs);
        String[] configValues = new String[]{"Debug|Win32", ".\\Debug", ".\\Debug", "2", "0", "FALSE"};
        if (!isDebug) {
            configValues[0] = "Release|Win32";
        }
        this.startElement(content, "Configuration", new String[]{"Name", "OutputDirectory", "IntermediateDirectory", "ConfigurationType", "UseOfMFC", "ATLMinimizeCRunTimeLibraryUsage"}, configValues);
        String[] clValues = new String[]{"VCCLCompilerTool", "0", null, null, "1", "2", ".\\Debug\\testdllproh.pch", ".\\Debug/", ".\\Debug/", ".\\Debug/", "3", "TRUE", "4"};
        StringBuffer includeDirs = new StringBuffer();
        StringBuffer defines = new StringBuffer();
        String[] args = compilerConfig.getPreArguments();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("/I")) {
                includeDirs.append(args[i].substring(2));
                includeDirs.append(';');
            }
            if (!args[i].startsWith("/D")) continue;
            defines.append(args[i].substring(2));
            defines.append(";");
        }
        if (includeDirs.length() > 0) {
            includeDirs.setLength(includeDirs.length() - 1);
        }
        if (defines.length() > 0) {
            defines.setLength(defines.length() - 1);
        }
        clValues[2] = includeDirs.toString();
        clValues[3] = defines.toString();
        this.startElement(content, "Tool", new String[]{"Name", "Optimization", "AdditionalIncludeDirectories", "PreprocessorDefinitions", "RuntimeLibrary", "UsePrecompiledHeaders", "PrecompiledHeaderFile", "AssemblerListingLocation", "ObjectFile", "WarningLevel", "SuppressStartupBanner", "DebugInformationFormat"}, clValues);
        content.endElement(null, "Tool", "Tool");
        String[] linkerValues = new String[]{"VCLinkerTool", null, ".\\Debug/testdllproj.dll", "1", "TRUE", "TRUE", ".\\Debug\\testdllproh.pdb", "2", ".\\Debug/testdllproj.lib", "1"};
        if (!isDebug) {
            linkerValues[5] = "FALSE";
        }
        if ((config = linkTarget.getConfiguration()) instanceof CommandLineLinkerConfiguration) {
            CommandLineLinkerConfiguration linkConfig = (CommandLineLinkerConfiguration)config;
            File[] linkSources = linkTarget.getAllSources();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < linkSources.length; ++i) {
                if (targets.get(linkSources[i].getName()) != null) continue;
                String relPath = CUtil.getRelativePath(basePath, linkSources[i]);
                if (relPath.indexOf(32) > 0) {
                    buf.append('\"');
                    buf.append(relPath);
                    buf.append('\"');
                } else {
                    buf.append(relPath);
                }
                buf.append(';');
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
                linkerValues[1] = buf.toString();
            }
        }
        this.startElement(content, "Tool", new String[]{"Name", "AdditionalDependencies", "OutputFile", "LinkIncremental", "SuppressStartupBanner", "GenerateDebugInformation", "ProgramDatabaseFile", "SubSystem", "ImportLibrary", "TargetMachine"}, linkerValues);
        content.endElement(null, "Tool", "Tool");
        content.endElement(null, "Configuration", "Configuration");
        content.endElement(null, "Configurations", "Configurations");
        content.startElement(null, "References", "References", emptyAttrs);
        content.endElement(null, "References", "References");
        content.startElement(null, "Files", "Files", emptyAttrs);
        File[] sortedSources = new File[sources.size()];
        sources.toArray(sortedSources);
        Arrays.sort(sortedSources, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((File)o1).getName().compareTo(((File)o2).getName());
            }
        });
        this.writeFilteredSources("Source Files", "cpp;c;cxx;def;odl;idl;hpj;bat;asm;asmx", basePath, sortedSources, content);
        this.writeFilteredSources("Header Files", "h;hpp;hxx;hm;inl;inc;xsd", basePath, sortedSources, content);
        this.writeFilteredSources("Resource Files", "rc;ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe;resx", basePath, sortedSources, content);
        content.endElement(null, "Files", "Files");
        content.startElement(null, "Globals", "Globals", emptyAttrs);
        content.endElement(null, "Globals", "Globals");
        content.endElement(null, "VisualStudioProject", "VisualStudioProject");
        content.endDocument();
    }

    private void writeFilteredSources(String name, String filter, String basePath, File[] sortedSources, ContentHandler content) throws SAXException {
        AttributesImpl filterAttrs = new AttributesImpl();
        filterAttrs.addAttribute(null, "Name", "Name", "#PCDATA", name);
        filterAttrs.addAttribute(null, "Filter", "Filter", "#PCDATA", filter);
        content.startElement(null, "Filter", "Filter", filterAttrs);
        AttributesImpl fileAttrs = new AttributesImpl();
        fileAttrs.addAttribute(null, "RelativePath", "RelativePath", "#PCDATA", "");
        AttributesImpl fileConfigAttrs = new AttributesImpl();
        fileConfigAttrs.addAttribute(null, "Name", "Name", "#PCDATA", "Debug|Win32");
        AttributesImpl toolAttrs = new AttributesImpl();
        toolAttrs.addAttribute(null, "Name", "Name", "#PCDATA", "VCCLCompilerTool");
        toolAttrs.addAttribute(null, "Optimization", "Optimization", "#PCDATA", "0");
        toolAttrs.addAttribute(null, "PreprocessorDefinitions", "PreprocessorDefinitions", "#PCDATA", "WIN32;_DEBUG;_WINDOWS;$(NoInherit}");
        for (int i = 0; i < sortedSources.length; ++i) {
            if (!this.isGroupMember(filter, sortedSources[i])) continue;
            String relativePath = CUtil.getRelativePath(basePath, sortedSources[i]);
            fileAttrs.setValue(0, relativePath);
            content.startElement(null, "File", "File", fileAttrs);
            content.startElement(null, "FileConfiguration", "FileConfiguration", fileConfigAttrs);
            content.startElement(null, "Tool", "Tool", toolAttrs);
            content.endElement(null, "Tool", "Tool");
            content.endElement(null, "FileConfiguration", "FileConfiguration");
            content.endElement(null, "File", "File");
        }
        content.endElement(null, "Filter", "Filter");
    }

    private boolean isGroupMember(String filter, File candidate) {
        String fileName = candidate.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < fileName.length() - 1) {
            String extension = ";" + fileName.substring(lastDot + 1).toLowerCase() + ";";
            String semiFilter = ";" + filter + ";";
            return semiFilter.indexOf(extension) >= 0;
        }
        return false;
    }

    private void startElement(ContentHandler content, String tagName, String[] attributeNames, String[] attributeValues) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < attributeNames.length; ++i) {
            if (attributeValues[i] == null) continue;
            attributes.addAttribute(null, attributeNames[i], attributeNames[i], "#PCDATA", attributeValues[i]);
        }
        content.startElement(null, tagName, tagName, attributes);
    }

    private CommandLineCompilerConfiguration getBaseCompilerConfiguration(Hashtable targets) {
        CommandLineCompilerConfiguration compilerConfig = null;
        Iterator targetIter = targets.values().iterator();
        while (targetIter.hasNext()) {
            TargetInfo targetInfo = (TargetInfo)targetIter.next();
            ProcessorConfiguration config = targetInfo.getConfiguration();
            String identifier = config.getIdentifier();
            if (!(config instanceof CommandLineCompilerConfiguration) || !((compilerConfig = (CommandLineCompilerConfiguration)config).getCompiler() instanceof DevStudioCCompiler)) continue;
            return compilerConfig;
        }
        return null;
    }
}

