package Locales::DB::Language::da;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::da::VERSION = '0.09';

$Locales::DB::Language::da::cldr_version = '2.0';

%Locales::DB::Language::da::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Sprog\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ og\ \{1\}",
            'end'    => "\{0\}\ og\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Område\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '”',
        'quotation_end'             => '”',
        'quotation_start'           => '”'
    },
    'fallback' => [
        'nb',
        'nn',
        'sv',
        'en'
    ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "nej\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::da::code_to_name = (
    'aa'     => 'afar',
    'ab'     => 'abkhasisk',
    'ace'    => 'achinesisk',
    'ach'    => 'acoli',
    'ada'    => 'adangme',
    'ady'    => 'adyghe',
    'ae'     => 'avestan',
    'af'     => 'afrikaans',
    'afa'    => "afro\-asiatisk\ sprog",
    'afh'    => 'afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'ainu',
    'ak'     => 'akan',
    'akk'    => 'akkadisk',
    'ale'    => 'aleutisk',
    'alg'    => "algonkisk\ sprog",
    'alt'    => 'sydaltaisk',
    'am'     => 'amharisk',
    'an'     => 'aragonesisk',
    'ang'    => 'oldengelsk',
    'anp'    => 'angika',
    'apa'    => 'apachesprog',
    'ar'     => 'arabisk',
    'arc'    => 'aramæisk',
    'arn'    => 'araukansk',
    'arp'    => 'arapaho',
    'art'    => 'kunstsprog',
    'arw'    => 'arawak',
    'as'     => 'assamesisk',
    'asa'    => 'asu',
    'ast'    => 'asturisk',
    'ath'    => "athapaskisk\ sprog",
    'aus'    => "australsk\ sprog",
    'av'     => 'avarisk',
    'awa'    => 'awadhi',
    'ay'     => 'aymara',
    'az'     => 'azeri',
    'ba'     => 'bashkir',
    'bad'    => 'banda',
    'bai'    => "bamilekisk\ sprog",
    'bal'    => 'baluchi',
    'ban'    => 'balinesisk',
    'bas'    => 'basa',
    'bat'    => "baltisk\ sprog",
    'be'     => 'hviderussisk',
    'bej'    => 'beja',
    'bem'    => 'bemba',
    'ber'    => 'berberisk',
    'bez'    => 'bena',
    'bg'     => 'bulgarsk',
    'bh'     => 'bihari',
    'bho'    => 'bhojpuri',
    'bi'     => 'bislama',
    'bik'    => 'bikol',
    'bin'    => 'bini',
    'bla'    => 'siksika',
    'bm'     => 'bambara',
    'bn'     => 'bengalsk',
    'bnt'    => 'bantu',
    'bo'     => 'tibetansk',
    'br'     => 'bretonsk',
    'bra'    => 'braj',
    'brx'    => 'Bodo',
    'bs'     => 'bosnisk',
    'btk'    => 'batak',
    'bua'    => 'buriatisk',
    'bug'    => 'buginesisk',
    'byn'    => 'blin',
    'ca'     => 'catalansk',
    'cad'    => 'caddo',
    'cai'    => "mellemamerikansk\ indiansk\ sprog",
    'car'    => 'caribisk',
    'cau'    => "kaukasisk\ sprog",
    'cay'    => 'Cayuga',
    'cch'    => 'atsam',
    'ce'     => 'tjetjensk',
    'ceb'    => 'cebuano',
    'cel'    => "keltisk\ sprog",
    'cgg'    => 'Chiga',
    'ch'     => 'chamorro',
    'chb'    => 'chibcha',
    'chg'    => 'chagatai',
    'chk'    => 'chuukese',
    'chm'    => 'mari',
    'chn'    => 'chinook',
    'cho'    => 'choctaw',
    'chp'    => 'chipewyan',
    'chr'    => 'cherokee',
    'chy'    => 'cheyenne',
    'cmc'    => "chamiske\ sprog",
    'co'     => 'korsikansk',
    'cop'    => 'koptisk',
    'cpe'    => "engelsk\ baseret\ kreolsk\ eller\ pidgin",
    'cpf'    => "fransk\ baseret\ kreolsk\ eller\ pidginsprog",
    'cpp'    => "portugisisk\ baseret\ kreolsk\ eller\ pidginsprog",
    'cr'     => 'cree',
    'crh'    => "krim\ tyrkisk",
    'crp'    => "kreolsk\ eller\ pidginsprog",
    'cs'     => 'tjekkisk',
    'csb'    => 'kasjubisk',
    'cu'     => 'kirkeslavisk',
    'cus'    => "kusjitisk\ sprog",
    'cv'     => 'chuvash',
    'cy'     => 'walisisk',
    'da'     => 'dansk',
    'dak'    => 'dakota',
    'dar'    => 'dargwa',
    'dav'    => 'Taita',
    'day'    => 'dayak',
    'de'     => 'tysk',
    'de_at'  => "østrigsk\ tysk",
    'de_ch'  => 'schweizerhøjtysk',
    'del'    => 'delaware',
    'den'    => 'athapaskisk',
    'dgr'    => 'dogrib',
    'din'    => 'dinka',
    'dje'    => 'Zarma',
    'doi'    => 'dogri',
    'dra'    => "dravidisk\ sprog",
    'dsb'    => 'nedersorbisk',
    'dua'    => 'duala',
    'dum'    => 'middelhollandsk',
    'dv'     => 'divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'dyula',
    'dz'     => 'dzongkha',
    'ebu'    => 'kiembu',
    'ee'     => 'ewe',
    'efi'    => 'efik',
    'egy'    => 'oldegyptisk',
    'eka'    => 'ekajuk',
    'el'     => 'græsk',
    'elx'    => 'elamitisk',
    'en'     => 'engelsk',
    'en_au'  => "australsk\ engelsk",
    'en_ca'  => "canadisk\ engelsk",
    'en_gb'  => "britisk\ engelsk",
    'en_us'  => "amerikansk\ engelsk",
    'enm'    => 'middelengelsk',
    'eo'     => 'esperanto',
    'es'     => 'spansk',
    'es_419' => "latinamerikansk\ spansk",
    'es_es'  => "castiliansk\ spansk",
    'et'     => 'estisk',
    'eu'     => 'baskisk',
    'ewo'    => 'ewondo',
    'fa'     => 'persisk',
    'fan'    => 'fang',
    'fat'    => 'fanti',
    'ff'     => 'fulah',
    'fi'     => 'finsk',
    'fil'    => 'filippinsk',
    'fiu'    => "finsk\-ugrisk\ sprog",
    'fj'     => 'fijiansk',
    'fo'     => 'færøsk',
    'fon'    => 'fon',
    'fr'     => 'fransk',
    'fr_ca'  => "canadisk\ fransk",
    'fr_ch'  => "schweizisk\ fransk",
    'frm'    => 'middelfransk',
    'fro'    => 'oldfransk',
    'frr'    => 'nordfrisisk',
    'frs'    => 'østfrisisk',
    'fur'    => 'friulian',
    'fy'     => 'frisisk',
    'ga'     => 'irsk',
    'gaa'    => 'ga',
    'gay'    => 'gayo',
    'gba'    => 'gbaya',
    'gd'     => "skotsk\ gælisk",
    'gem'    => "germansk\ sprog",
    'gez'    => 'geez',
    'gil'    => 'gilbertesisk',
    'gl'     => 'galicisk',
    'gmh'    => 'middelhøjtysk',
    'gn'     => 'guarani',
    'goh'    => 'oldhøjtysk',
    'gon'    => 'gondi',
    'gor'    => 'gorontalo',
    'got'    => 'gotisk',
    'grb'    => 'grebo',
    'grc'    => 'oldgræsk',
    'gsw'    => 'schweizertysk',
    'gu'     => 'gujarati',
    'guz'    => 'Gusii',
    'gv'     => 'manx',
    'gwi'    => 'gwichin',
    'ha'     => 'hausa',
    'hai'    => 'haida',
    'haw'    => 'hawaiiansk',
    'he'     => 'hebraisk',
    'hi'     => 'hindi',
    'hil'    => 'hiligaynon',
    'him'    => 'himachali',
    'hit'    => 'hittitisk',
    'hmn'    => 'hmong',
    'ho'     => 'hirimotu',
    'hr'     => 'kroatisk',
    'hsb'    => 'øvresorbisk',
    'ht'     => 'haitisk',
    'hu'     => 'ungarsk',
    'hup'    => 'hupa',
    'hy'     => 'armensk',
    'hz'     => 'herero',
    'ia'     => 'interlingua',
    'iba'    => 'iban',
    'id'     => 'indonesisk',
    'ie'     => 'interlingue',
    'ig'     => 'igbo',
    'ii'     => "sichuan\ yi",
    'ijo'    => 'ijo',
    'ik'     => 'inupiaq',
    'ilo'    => 'iloko',
    'inc'    => "indisk\ sprog",
    'ine'    => "indo\-europæisk\ sprog",
    'inh'    => 'ingush',
    'io'     => 'ido',
    'ira'    => "iransk\ sprog",
    'iro'    => "irokesisk\ sprog",
    'is'     => 'islandsk',
    'it'     => 'italiensk',
    'iu'     => 'inuktitut',
    'ja'     => 'japansk',
    'jbo'    => 'lojban',
    'jmc'    => 'Machame',
    'jpr'    => "jødisk\-persisk",
    'jrb'    => "jødisk\-arabisk",
    'jv'     => 'javanesisk',
    'ka'     => 'georgisk',
    'kaa'    => 'karakalpakisk',
    'kab'    => 'kabyle',
    'kac'    => 'kachin',
    'kaj'    => 'jju',
    'kam'    => 'kamba',
    'kar'    => 'karen',
    'kaw'    => 'kawi',
    'kbd'    => 'kabardian',
    'kcg'    => 'tyap',
    'kde'    => 'Makonde',
    'kea'    => 'kapverdisk',
    'kfo'    => 'koro',
    'kg'     => 'kongo',
    'kha'    => 'khasi',
    'khi'    => 'khoisansprog',
    'kho'    => 'khotanesisk',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'kikuyu',
    'kj'     => 'kuanyama',
    'kk'     => 'kasakhisk',
    'kl'     => 'grønlandsk',
    'kln'    => 'Kalenjin',
    'km'     => 'khmer',
    'kmb'    => 'kimbundu',
    'kn'     => 'kannaresisk',
    'ko'     => 'koreansk',
    'kok'    => 'konkani',
    'kos'    => 'kosraean',
    'kpe'    => 'kpelle',
    'kr'     => 'kanuri',
    'krc'    => "karatjai\-balkar",
    'krl'    => 'karelsk',
    'kro'    => 'kru',
    'kru'    => 'kurukh',
    'ks'     => 'kashmiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'kurdisk',
    'kum'    => 'kymyk',
    'kut'    => 'kutenaj',
    'kv'     => 'komi',
    'kw'     => 'cornisk',
    'ky'     => 'kirgisisk',
    'la'     => 'latin',
    'lad'    => 'ladino',
    'lag'    => 'Langi',
    'lah'    => 'lahnda',
    'lam'    => 'lamba',
    'lb'     => 'luxembourgsk',
    'lez'    => 'lezghian',
    'lg'     => 'ganda',
    'li'     => 'limburgsk',
    'ln'     => 'lingala',
    'lo'     => 'laotisk',
    'lol'    => 'mongo',
    'loz'    => 'lozi',
    'lt'     => 'litauisk',
    'lu'     => "luba\-Katanga",
    'lua'    => "luba\-Lulua",
    'lui'    => 'luiseno',
    'lun'    => 'lunda',
    'luo'    => 'luo',
    'lus'    => 'lushai',
    'luy'    => 'olulujia',
    'lv'     => 'lettisk',
    'mad'    => 'madurese',
    'mag'    => 'magahi',
    'mai'    => 'maithili',
    'mak'    => 'makasar',
    'man'    => 'mandingo',
    'map'    => "austronesisk\ sprog",
    'mas'    => 'masai',
    'mdf'    => 'moksha',
    'mdr'    => 'mandar',
    'men'    => 'mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'malagasy',
    'mga'    => 'middelirsk',
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'marshallese',
    'mi'     => 'maori',
    'mic'    => 'micmac',
    'min'    => 'minangkabau',
    'mis'    => "diverse\ sprog",
    'mk'     => 'makedonsk',
    'mkh'    => "mon\-khmer\ sprog",
    'ml'     => 'malayalam',
    'mn'     => 'mongolsk',
    'mnc'    => 'manchu',
    'mni'    => 'manipuri',
    'mno'    => "manobo\ sprog",
    'mo'     => 'moldovisk',
    'moh'    => 'mohawk',
    'mos'    => 'mossi',
    'mr'     => 'marathisk',
    'ms'     => 'malay',
    'mt'     => 'maltesisk',
    'mua'    => 'Mundang',
    'mul'    => "flere\ sprog",
    'mun'    => 'mundasprog',
    'mus'    => 'creek',
    'mwl'    => 'mirandesisk',
    'mwr'    => 'marwari',
    'my'     => 'burmesisk',
    'myn'    => 'mayasprog',
    'myv'    => 'erzya',
    'na'     => 'nauru',
    'nah'    => 'nahuatl',
    'nai'    => "nordamerikansk\ indiansk\ sprog",
    'nap'    => 'neapolitansk',
    'naq'    => 'Nama',
    'nb'     => "norsk\ bokmål",
    'nd'     => 'nordndebele',
    'nds'    => 'nedertysk',
    'ne'     => 'nepalesisk',
    'new'    => 'newari',
    'ng'     => 'ndonga',
    'nia'    => 'nias',
    'nic'    => "Niger\-Congo\ sprog",
    'niu'    => 'niuean',
    'nl'     => 'hollandsk',
    'nl_be'  => 'flamsk',
    'nmg'    => 'Kwasio',
    'nn'     => 'nynorsk',
    'no'     => 'norsk',
    'nog'    => 'nogai',
    'non'    => 'oldislandsk',
    'nqo'    => "n\-ko",
    'nr'     => 'sydndebele',
    'nso'    => 'nordsotho',
    'nub'    => "nubisk\ sprog",
    'nus'    => 'Nuer',
    'nv'     => 'navajo',
    'nwc'    => "klassisk\ newarisk",
    'ny'     => 'nyanja',
    'nym'    => 'nyamwezi',
    'nyn'    => 'nyankole',
    'nyo'    => "nyoro\ sprog",
    'nzi'    => 'nzima',
    'oc'     => 'occitansk',
    'oj'     => 'ojibwa',
    'om'     => 'oromo',
    'or'     => 'oriya',
    'os'     => 'ossetisk',
    'osa'    => 'osage',
    'ota'    => "osmannisk\-tyrkisk",
    'oto'    => "otomi\ sprog",
    'pa'     => 'punjabi',
    'paa'    => "papua\-australsk\ sprog",
    'pag'    => 'pangasinan',
    'pal'    => 'pahlavi',
    'pam'    => 'pampanga',
    'pap'    => 'papiamento',
    'pau'    => 'palauansk',
    'peo'    => 'oldpersisk',
    'phi'    => "filippinsk\ sprog",
    'phn'    => 'fønikisk',
    'pi'     => 'pali',
    'pl'     => 'polsk',
    'pon'    => 'ponape',
    'pra'    => 'prakritsprog',
    'pro'    => 'oldprovencalsk',
    'ps'     => 'Pushto',
    'pt'     => 'portugisisk',
    'pt_br'  => "brasiliansk\ portugisisk",
    'pt_pt'  => "iberisk\ portugisisk",
    'qu'     => 'quechua',
    'raj'    => 'rajasthani',
    'rap'    => 'rapanui',
    'rar'    => 'rarotongan',
    'rm'     => 'rætoromansk',
    'rn'     => 'rundi',
    'ro'     => 'rumænsk',
    'roa'    => "romansk\ sprog",
    'rof'    => 'Rombo',
    'rom'    => 'romani',
    'ru'     => 'russisk',
    'rup'    => 'arumænsk',
    'rw'     => 'kinyarwanda',
    'rwk'    => 'Rwa',
    'sa'     => 'sanskrit',
    'sad'    => 'sandawe',
    'sah'    => 'yakut',
    'sai'    => "sydamerikansk\ indiansk\ sprog",
    'sal'    => "salikisk\ sprog",
    'sam'    => 'samaritansk',
    'saq'    => 'Samburu',
    'sas'    => 'sasak',
    'sat'    => 'santali',
    'sbp'    => 'Sangu',
    'sc'     => 'sardinsk',
    'scn'    => 'siciliansk',
    'sco'    => 'skotsk',
    'sd'     => 'sindhi',
    'se'     => 'nordsamisk',
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'selkupisk',
    'sem'    => "semitisk\ sprog",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'sango',
    'sga'    => 'oldirsk',
    'sgn'    => 'tegnsprog',
    'sh'     => 'serbokroatisk',
    'shi'    => 'Tachelhit',
    'shn'    => 'shan',
    'si'     => 'singalesisk',
    'sid'    => 'sidamo',
    'sio'    => "sioux\ sprog",
    'sit'    => "sino\-tibetansk\ sprog",
    'sk'     => 'slovakisk',
    'sl'     => 'slovensk',
    'sla'    => "slavisk\ sprog",
    'sm'     => 'samoansk',
    'sma'    => 'sydsamisk',
    'smi'    => "samisk\ sprog",
    'smj'    => "lule\ sami",
    'smn'    => "inari\ sami",
    'sms'    => "skolt\ sami",
    'sn'     => 'shona',
    'snk'    => 'soninke',
    'so'     => 'somalisk',
    'sog'    => 'sogdiansk',
    'son'    => 'songhai',
    'sq'     => 'albansk',
    'sr'     => 'serbisk',
    'srn'    => "sranan\ tongo",
    'srr'    => 'serer',
    'ss'     => 'swati',
    'ssa'    => "nilo\-saharansk\ sprog",
    'ssy'    => 'Saho',
    'st'     => 'sydsotho',
    'su'     => 'sundanesisk',
    'suk'    => 'sukuma',
    'sus'    => 'susu',
    'sux'    => 'sumerisk',
    'sv'     => 'svensk',
    'sw'     => 'swahili',
    'swb'    => 'shimaore',
    'swc'    => "Congo\ Swahili",
    'syc'    => "klassisk\ syrisk",
    'syr'    => 'syrisk',
    'ta'     => 'tamilsk',
    'tai'    => 'thaisprog',
    'te'     => 'telugu',
    'tem'    => 'temne',
    'teo'    => 'Teso',
    'ter'    => 'tereno',
    'tet'    => 'tetum',
    'tg'     => 'tajik',
    'th'     => 'thailandsk',
    'ti'     => 'tigrinya',
    'tig'    => 'tigre',
    'tiv'    => 'tivi',
    'tk'     => 'turkmensk',
    'tkl'    => 'tokelau',
    'tl'     => 'tagalog',
    'tlh'    => 'klingon',
    'tli'    => 'tlingit',
    'tmh'    => 'tamashek',
    'tn'     => 'tswana',
    'to'     => 'tongansk',
    'tog'    => "nyasa\ tongansk",
    'tpi'    => "tok\ pisin",
    'tr'     => 'tyrkisk',
    'trv'    => 'Taroko',
    'ts'     => 'tsonga',
    'tsi'    => 'tsimshisk',
    'tt'     => 'tatarisk',
    'tum'    => 'tumbuka',
    'tup'    => 'tupisprog',
    'tut'    => "altaisk\ sprog",
    'tvl'    => 'tuvalu',
    'tw'     => 'twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'tahitiansk',
    'tyv'    => 'tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'udmurt',
    'ug'     => 'uyghursk',
    'uga'    => 'ugaristisk',
    'uk'     => 'ukrainsk',
    'umb'    => 'umbundu',
    'und'    => "ukendt\ sprog",
    'ur'     => 'urdu',
    'uz'     => 'usbekisk',
    'vai'    => 'vai',
    've'     => 'venda',
    'vi'     => 'vietnamesisk',
    'vo'     => 'volapyk',
    'vot'    => 'votisk',
    'vun'    => 'Vunjo',
    'wa'     => 'vallonsk',
    'wae'    => 'Walser',
    'wak'    => "wakashansk\ sprog",
    'wal'    => 'walamo',
    'war'    => 'waray',
    'was'    => 'washo',
    'wen'    => "vendisk\ sprog",
    'wo'     => 'wolof',
    'xal'    => 'kalmyk',
    'xh'     => 'xhosa',
    'xog'    => 'Soga',
    'yao'    => 'yao',
    'yap'    => 'yap',
    'yav'    => 'Yangben',
    'yi'     => 'jiddisch',
    'yo'     => 'yoruba',
    'ypk'    => "yupisk\ sprog",
    'yue'    => 'kantonesisk',
    'za'     => 'zhuang',
    'zap'    => 'zapotec',
    'zbl'    => 'blissymboler',
    'zen'    => 'zenaga',
    'zh'     => 'kinesisk',
    'znd'    => 'zande',
    'zu'     => 'zulu',
    'zun'    => 'zuni',
    'zxx'    => "intet\ sprogligt\ indhold",
    'zza'    => 'zaza',
);

%Locales::DB::Language::da::name_to_code = (
    'abkhasisk'                                 => 'ab',
    'achinesisk'                                => 'ace',
    'acoli'                                     => 'ach',
    'adangme'                                   => 'ada',
    'adyghe'                                    => 'ady',
    'afar'                                      => 'aa',
    'afrihili'                                  => 'afh',
    'afrikaans'                                 => 'af',
    'afroasiatisksprog'                         => 'afa',
    'aghem'                                     => 'agq',
    'ainu'                                      => 'ain',
    'akan'                                      => 'ak',
    'akkadisk'                                  => 'akk',
    'albansk'                                   => 'sq',
    'aleutisk'                                  => 'ale',
    'algonkisksprog'                            => 'alg',
    'altaisksprog'                              => 'tut',
    'amerikanskengelsk'                         => 'en_us',
    'amharisk'                                  => 'am',
    'angika'                                    => 'anp',
    'apachesprog'                               => 'apa',
    'arabisk'                                   => 'ar',
    'aragonesisk'                               => 'an',
    'aramæisk'                                 => 'arc',
    'arapaho'                                   => 'arp',
    'araukansk'                                 => 'arn',
    'arawak'                                    => 'arw',
    'armensk'                                   => 'hy',
    'arumænsk'                                 => 'rup',
    'assamesisk'                                => 'as',
    'asturisk'                                  => 'ast',
    'asu'                                       => 'asa',
    'athapaskisk'                               => 'den',
    'athapaskisksprog'                          => 'ath',
    'atsam'                                     => 'cch',
    'australskengelsk'                          => 'en_au',
    'australsksprog'                            => 'aus',
    'austronesisksprog'                         => 'map',
    'avarisk'                                   => 'av',
    'avestan'                                   => 'ae',
    'awadhi'                                    => 'awa',
    'aymara'                                    => 'ay',
    'azeri'                                     => 'az',
    'bafia'                                     => 'ksf',
    'balinesisk'                                => 'ban',
    'baltisksprog'                              => 'bat',
    'baluchi'                                   => 'bal',
    'bambara'                                   => 'bm',
    'bamilekisksprog'                           => 'bai',
    'banda'                                     => 'bad',
    'bantu'                                     => 'bnt',
    'basa'                                      => 'bas',
    'bashkir'                                   => 'ba',
    'baskisk'                                   => 'eu',
    'batak'                                     => 'btk',
    'beja'                                      => 'bej',
    'bemba'                                     => 'bem',
    'bena'                                      => 'bez',
    'bengalsk'                                  => 'bn',
    'berberisk'                                 => 'ber',
    'bhojpuri'                                  => 'bho',
    'bihari'                                    => 'bh',
    'bikol'                                     => 'bik',
    'bini'                                      => 'bin',
    'bislama'                                   => 'bi',
    'blin'                                      => 'byn',
    'blissymboler'                              => 'zbl',
    'bodo'                                      => 'brx',
    'bosnisk'                                   => 'bs',
    'braj'                                      => 'bra',
    'brasilianskportugisisk'                    => 'pt_br',
    'bretonsk'                                  => 'br',
    'britiskengelsk'                            => 'en_gb',
    'buginesisk'                                => 'bug',
    'bulgarsk'                                  => 'bg',
    'buriatisk'                                 => 'bua',
    'burmesisk'                                 => 'my',
    'caddo'                                     => 'cad',
    'canadiskengelsk'                           => 'en_ca',
    'canadiskfransk'                            => 'fr_ca',
    'caribisk'                                  => 'car',
    'castilianskspansk'                         => 'es_es',
    'catalansk'                                 => 'ca',
    'cayuga'                                    => 'cay',
    'cebuano'                                   => 'ceb',
    'centralmoroccotamazight'                   => 'tzm',
    'chagatai'                                  => 'chg',
    'chamiskesprog'                             => 'cmc',
    'chamorro'                                  => 'ch',
    'cherokee'                                  => 'chr',
    'cheyenne'                                  => 'chy',
    'chibcha'                                   => 'chb',
    'chiga'                                     => 'cgg',
    'chinook'                                   => 'chn',
    'chipewyan'                                 => 'chp',
    'choctaw'                                   => 'cho',
    'chuukese'                                  => 'chk',
    'chuvash'                                   => 'cv',
    'colognian'                                 => 'ksh',
    'congoswahili'                              => 'swc',
    'cornisk'                                   => 'kw',
    'cree'                                      => 'cr',
    'creek'                                     => 'mus',
    'dakota'                                    => 'dak',
    'dansk'                                     => 'da',
    'dargwa'                                    => 'dar',
    'dayak'                                     => 'day',
    'delaware'                                  => 'del',
    'dinka'                                     => 'din',
    'divehi'                                    => 'dv',
    'diversesprog'                              => 'mis',
    'dogri'                                     => 'doi',
    'dogrib'                                    => 'dgr',
    'dravidisksprog'                            => 'dra',
    'duala'                                     => 'dua',
    'dyula'                                     => 'dyu',
    'dzongkha'                                  => 'dz',
    'efik'                                      => 'efi',
    'ekajuk'                                    => 'eka',
    'elamitisk'                                 => 'elx',
    'engelsk'                                   => 'en',
    'engelskbaseretkreolskellerpidgin'          => 'cpe',
    'erzya'                                     => 'myv',
    'esperanto'                                 => 'eo',
    'estisk'                                    => 'et',
    'ewe'                                       => 'ee',
    'ewondo'                                    => 'ewo',
    'fang'                                      => 'fan',
    'fanti'                                     => 'fat',
    'fijiansk'                                  => 'fj',
    'filippinsk'                                => 'fil',
    'filippinsksprog'                           => 'phi',
    'finsk'                                     => 'fi',
    'finskugrisksprog'                          => 'fiu',
    'flamsk'                                    => 'nl_be',
    'fleresprog'                                => 'mul',
    'fon'                                       => 'fon',
    'fransk'                                    => 'fr',
    'franskbaseretkreolskellerpidginsprog'      => 'cpf',
    'frisisk'                                   => 'fy',
    'friulian'                                  => 'fur',
    'fulah'                                     => 'ff',
    'færøsk'                                  => 'fo',
    'fønikisk'                                 => 'phn',
    'ga'                                        => 'gaa',
    'galicisk'                                  => 'gl',
    'ganda'                                     => 'lg',
    'gayo'                                      => 'gay',
    'gbaya'                                     => 'gba',
    'geez'                                      => 'gez',
    'georgisk'                                  => 'ka',
    'germansksprog'                             => 'gem',
    'gilbertesisk'                              => 'gil',
    'gondi'                                     => 'gon',
    'gorontalo'                                 => 'gor',
    'gotisk'                                    => 'got',
    'grebo'                                     => 'grb',
    'græsk'                                    => 'el',
    'grønlandsk'                               => 'kl',
    'guarani'                                   => 'gn',
    'gujarati'                                  => 'gu',
    'gusii'                                     => 'guz',
    'gwichin'                                   => 'gwi',
    'haida'                                     => 'hai',
    'haitisk'                                   => 'ht',
    'hausa'                                     => 'ha',
    'hawaiiansk'                                => 'haw',
    'hebraisk'                                  => 'he',
    'herero'                                    => 'hz',
    'hiligaynon'                                => 'hil',
    'himachali'                                 => 'him',
    'hindi'                                     => 'hi',
    'hirimotu'                                  => 'ho',
    'hittitisk'                                 => 'hit',
    'hmong'                                     => 'hmn',
    'hollandsk'                                 => 'nl',
    'hupa'                                      => 'hup',
    'hviderussisk'                              => 'be',
    'iban'                                      => 'iba',
    'iberiskportugisisk'                        => 'pt_pt',
    'ido'                                       => 'io',
    'igbo'                                      => 'ig',
    'ijo'                                       => 'ijo',
    'iloko'                                     => 'ilo',
    'inarisami'                                 => 'smn',
    'indisksprog'                               => 'inc',
    'indoeuropæisksprog'                       => 'ine',
    'indonesisk'                                => 'id',
    'ingush'                                    => 'inh',
    'interlingua'                               => 'ia',
    'interlingue'                               => 'ie',
    'intetsprogligtindhold'                     => 'zxx',
    'inuktitut'                                 => 'iu',
    'inupiaq'                                   => 'ik',
    'iransksprog'                               => 'ira',
    'irokesisksprog'                            => 'iro',
    'irsk'                                      => 'ga',
    'islandsk'                                  => 'is',
    'italiensk'                                 => 'it',
    'japansk'                                   => 'ja',
    'javanesisk'                                => 'jv',
    'jiddisch'                                  => 'yi',
    'jju'                                       => 'kaj',
    'jolafonyi'                                 => 'dyo',
    'jødiskarabisk'                            => 'jrb',
    'jødiskpersisk'                            => 'jpr',
    'kabardian'                                 => 'kbd',
    'kabyle'                                    => 'kab',
    'kachin'                                    => 'kac',
    'kalenjin'                                  => 'kln',
    'kalmyk'                                    => 'xal',
    'kamba'                                     => 'kam',
    'kannaresisk'                               => 'kn',
    'kantonesisk'                               => 'yue',
    'kanuri'                                    => 'kr',
    'kapverdisk'                                => 'kea',
    'karakalpakisk'                             => 'kaa',
    'karatjaibalkar'                            => 'krc',
    'karelsk'                                   => 'krl',
    'karen'                                     => 'kar',
    'kasakhisk'                                 => 'kk',
    'kashmiri'                                  => 'ks',
    'kasjubisk'                                 => 'csb',
    'kaukasisksprog'                            => 'cau',
    'kawi'                                      => 'kaw',
    'keltisksprog'                              => 'cel',
    'khasi'                                     => 'kha',
    'khmer'                                     => 'km',
    'khoisansprog'                              => 'khi',
    'khotanesisk'                               => 'kho',
    'kiembu'                                    => 'ebu',
    'kikuyu'                                    => 'ki',
    'kimbundu'                                  => 'kmb',
    'kinesisk'                                  => 'zh',
    'kinyarwanda'                               => 'rw',
    'kirgisisk'                                 => 'ky',
    'kirkeslavisk'                              => 'cu',
    'klassisknewarisk'                          => 'nwc',
    'klassisksyrisk'                            => 'syc',
    'klingon'                                   => 'tlh',
    'komi'                                      => 'kv',
    'kongo'                                     => 'kg',
    'konkani'                                   => 'kok',
    'koptisk'                                   => 'cop',
    'koreansk'                                  => 'ko',
    'koro'                                      => 'kfo',
    'korsikansk'                                => 'co',
    'kosraean'                                  => 'kos',
    'koyraborosenni'                            => 'ses',
    'koyrachiini'                               => 'khq',
    'kpelle'                                    => 'kpe',
    'kreolskellerpidginsprog'                   => 'crp',
    'krimtyrkisk'                               => 'crh',
    'kroatisk'                                  => 'hr',
    'kru'                                       => 'kro',
    'kuanyama'                                  => 'kj',
    'kunstsprog'                                => 'art',
    'kurdisk'                                   => 'ku',
    'kurukh'                                    => 'kru',
    'kusjitisksprog'                            => 'cus',
    'kutenaj'                                   => 'kut',
    'kwasio'                                    => 'nmg',
    'kymyk'                                     => 'kum',
    'ladino'                                    => 'lad',
    'lahnda'                                    => 'lah',
    'lamba'                                     => 'lam',
    'langi'                                     => 'lag',
    'laotisk'                                   => 'lo',
    'latin'                                     => 'la',
    'latinamerikanskspansk'                     => 'es_419',
    'lettisk'                                   => 'lv',
    'lezghian'                                  => 'lez',
    'limburgsk'                                 => 'li',
    'lingala'                                   => 'ln',
    'litauisk'                                  => 'lt',
    'lojban'                                    => 'jbo',
    'lozi'                                      => 'loz',
    'lubakatanga'                               => 'lu',
    'lubalulua'                                 => 'lua',
    'luiseno'                                   => 'lui',
    'lulesami'                                  => 'smj',
    'lunda'                                     => 'lun',
    'luo'                                       => 'luo',
    'lushai'                                    => 'lus',
    'luxembourgsk'                              => 'lb',
    'machame'                                   => 'jmc',
    'madurese'                                  => 'mad',
    'magahi'                                    => 'mag',
    'maithili'                                  => 'mai',
    'makasar'                                   => 'mak',
    'makedonsk'                                 => 'mk',
    'makhuwameetto'                             => 'mgh',
    'makonde'                                   => 'kde',
    'malagasy'                                  => 'mg',
    'malay'                                     => 'ms',
    'malayalam'                                 => 'ml',
    'maltesisk'                                 => 'mt',
    'manchu'                                    => 'mnc',
    'mandar'                                    => 'mdr',
    'mandingo'                                  => 'man',
    'manipuri'                                  => 'mni',
    'manobosprog'                               => 'mno',
    'manx'                                      => 'gv',
    'maori'                                     => 'mi',
    'marathisk'                                 => 'mr',
    'mari'                                      => 'chm',
    'marshallese'                               => 'mh',
    'marwari'                                   => 'mwr',
    'masai'                                     => 'mas',
    'mayasprog'                                 => 'myn',
    'mellemamerikanskindiansksprog'             => 'cai',
    'mende'                                     => 'men',
    'meru'                                      => 'mer',
    'micmac'                                    => 'mic',
    'middelengelsk'                             => 'enm',
    'middelfransk'                              => 'frm',
    'middelhollandsk'                           => 'dum',
    'middelhøjtysk'                            => 'gmh',
    'middelirsk'                                => 'mga',
    'minangkabau'                               => 'min',
    'mirandesisk'                               => 'mwl',
    'mohawk'                                    => 'moh',
    'moksha'                                    => 'mdf',
    'moldovisk'                                 => 'mo',
    'mongo'                                     => 'lol',
    'mongolsk'                                  => 'mn',
    'monkhmersprog'                             => 'mkh',
    'morisyen'                                  => 'mfe',
    'mossi'                                     => 'mos',
    'mundang'                                   => 'mua',
    'mundasprog'                                => 'mun',
    'nahuatl'                                   => 'nah',
    'nama'                                      => 'naq',
    'nauru'                                     => 'na',
    'navajo'                                    => 'nv',
    'ndonga'                                    => 'ng',
    'neapolitansk'                              => 'nap',
    'nedersorbisk'                              => 'dsb',
    'nedertysk'                                 => 'nds',
    'nepalesisk'                                => 'ne',
    'newari'                                    => 'new',
    'nias'                                      => 'nia',
    'nigercongosprog'                           => 'nic',
    'nilosaharansksprog'                        => 'ssa',
    'niuean'                                    => 'niu',
    'nko'                                       => 'nqo',
    'nogai'                                     => 'nog',
    'nordamerikanskindiansksprog'               => 'nai',
    'nordfrisisk'                               => 'frr',
    'nordndebele'                               => 'nd',
    'nordsamisk'                                => 'se',
    'nordsotho'                                 => 'nso',
    'norsk'                                     => 'no',
    'norskbokmål'                              => 'nb',
    'nubisksprog'                               => 'nub',
    'nuer'                                      => 'nus',
    'nyamwezi'                                  => 'nym',
    'nyanja'                                    => 'ny',
    'nyankole'                                  => 'nyn',
    'nyasatongansk'                             => 'tog',
    'nynorsk'                                   => 'nn',
    'nyorosprog'                                => 'nyo',
    'nzima'                                     => 'nzi',
    'occitansk'                                 => 'oc',
    'ojibwa'                                    => 'oj',
    'oldegyptisk'                               => 'egy',
    'oldengelsk'                                => 'ang',
    'oldfransk'                                 => 'fro',
    'oldgræsk'                                 => 'grc',
    'oldhøjtysk'                               => 'goh',
    'oldirsk'                                   => 'sga',
    'oldislandsk'                               => 'non',
    'oldpersisk'                                => 'peo',
    'oldprovencalsk'                            => 'pro',
    'olulujia'                                  => 'luy',
    'oriya'                                     => 'or',
    'oromo'                                     => 'om',
    'osage'                                     => 'osa',
    'osmannisktyrkisk'                          => 'ota',
    'ossetisk'                                  => 'os',
    'otomisprog'                                => 'oto',
    'pahlavi'                                   => 'pal',
    'palauansk'                                 => 'pau',
    'pali'                                      => 'pi',
    'pampanga'                                  => 'pam',
    'pangasinan'                                => 'pag',
    'papiamento'                                => 'pap',
    'papuaaustralsksprog'                       => 'paa',
    'persisk'                                   => 'fa',
    'polsk'                                     => 'pl',
    'ponape'                                    => 'pon',
    'portugisisk'                               => 'pt',
    'portugisiskbaseretkreolskellerpidginsprog' => 'cpp',
    'prakritsprog'                              => 'pra',
    'punjabi'                                   => 'pa',
    'pushto'                                    => 'ps',
    'quechua'                                   => 'qu',
    'rajasthani'                                => 'raj',
    'rapanui'                                   => 'rap',
    'rarotongan'                                => 'rar',
    'romani'                                    => 'rom',
    'romansksprog'                              => 'roa',
    'rombo'                                     => 'rof',
    'rumænsk'                                  => 'ro',
    'rundi'                                     => 'rn',
    'russisk'                                   => 'ru',
    'rwa'                                       => 'rwk',
    'rætoromansk'                              => 'rm',
    'saho'                                      => 'ssy',
    'salikisksprog'                             => 'sal',
    'samaritansk'                               => 'sam',
    'samburu'                                   => 'saq',
    'samisksprog'                               => 'smi',
    'samoansk'                                  => 'sm',
    'sandawe'                                   => 'sad',
    'sango'                                     => 'sg',
    'sangu'                                     => 'sbp',
    'sanskrit'                                  => 'sa',
    'santali'                                   => 'sat',
    'sardinsk'                                  => 'sc',
    'sasak'                                     => 'sas',
    'schweizerhøjtysk'                         => 'de_ch',
    'schweizertysk'                             => 'gsw',
    'schweiziskfransk'                          => 'fr_ch',
    'selkupisk'                                 => 'sel',
    'semitisksprog'                             => 'sem',
    'sena'                                      => 'seh',
    'seneca'                                    => 'see',
    'serbisk'                                   => 'sr',
    'serbokroatisk'                             => 'sh',
    'serer'                                     => 'srr',
    'shambala'                                  => 'ksb',
    'shan'                                      => 'shn',
    'shimaore'                                  => 'swb',
    'shona'                                     => 'sn',
    'sichuanyi'                                 => 'ii',
    'siciliansk'                                => 'scn',
    'sidamo'                                    => 'sid',
    'siksika'                                   => 'bla',
    'sindhi'                                    => 'sd',
    'singalesisk'                               => 'si',
    'sinotibetansksprog'                        => 'sit',
    'siouxsprog'                                => 'sio',
    'skoltsami'                                 => 'sms',
    'skotsk'                                    => 'sco',
    'skotskgælisk'                             => 'gd',
    'slavisksprog'                              => 'sla',
    'slovakisk'                                 => 'sk',
    'slovensk'                                  => 'sl',
    'soga'                                      => 'xog',
    'sogdiansk'                                 => 'sog',
    'somalisk'                                  => 'so',
    'songhai'                                   => 'son',
    'soninke'                                   => 'snk',
    'spansk'                                    => 'es',
    'sranantongo'                               => 'srn',
    'sukuma'                                    => 'suk',
    'sumerisk'                                  => 'sux',
    'sundanesisk'                               => 'su',
    'susu'                                      => 'sus',
    'svensk'                                    => 'sv',
    'swahili'                                   => 'sw',
    'swati'                                     => 'ss',
    'sydaltaisk'                                => 'alt',
    'sydamerikanskindiansksprog'                => 'sai',
    'sydndebele'                                => 'nr',
    'sydsamisk'                                 => 'sma',
    'sydsotho'                                  => 'st',
    'syrisk'                                    => 'syr',
    'tachelhit'                                 => 'shi',
    'tagalog'                                   => 'tl',
    'tahitiansk'                                => 'ty',
    'taita'                                     => 'dav',
    'tajik'                                     => 'tg',
    'tamashek'                                  => 'tmh',
    'tamilsk'                                   => 'ta',
    'taroko'                                    => 'trv',
    'tasawaq'                                   => 'twq',
    'tatarisk'                                  => 'tt',
    'tegnsprog'                                 => 'sgn',
    'telugu'                                    => 'te',
    'temne'                                     => 'tem',
    'tereno'                                    => 'ter',
    'teso'                                      => 'teo',
    'tetum'                                     => 'tet',
    'thailandsk'                                => 'th',
    'thaisprog'                                 => 'tai',
    'tibetansk'                                 => 'bo',
    'tigre'                                     => 'tig',
    'tigrinya'                                  => 'ti',
    'tivi'                                      => 'tiv',
    'tjekkisk'                                  => 'cs',
    'tjetjensk'                                 => 'ce',
    'tlingit'                                   => 'tli',
    'tokelau'                                   => 'tkl',
    'tokpisin'                                  => 'tpi',
    'tongansk'                                  => 'to',
    'tsimshisk'                                 => 'tsi',
    'tsonga'                                    => 'ts',
    'tswana'                                    => 'tn',
    'tumbuka'                                   => 'tum',
    'tupisprog'                                 => 'tup',
    'turkmensk'                                 => 'tk',
    'tuvalu'                                    => 'tvl',
    'tuvinian'                                  => 'tyv',
    'twi'                                       => 'tw',
    'tyap'                                      => 'kcg',
    'tyrkisk'                                   => 'tr',
    'tysk'                                      => 'de',
    'udmurt'                                    => 'udm',
    'ugaristisk'                                => 'uga',
    'ukendtsprog'                               => 'und',
    'ukrainsk'                                  => 'uk',
    'umbundu'                                   => 'umb',
    'ungarsk'                                   => 'hu',
    'urdu'                                      => 'ur',
    'usbekisk'                                  => 'uz',
    'uyghursk'                                  => 'ug',
    'vai'                                       => 'vai',
    'vallonsk'                                  => 'wa',
    'venda'                                     => 've',
    'vendisksprog'                              => 'wen',
    'vietnamesisk'                              => 'vi',
    'volapyk'                                   => 'vo',
    'votisk'                                    => 'vot',
    'vunjo'                                     => 'vun',
    'wakashansksprog'                           => 'wak',
    'walamo'                                    => 'wal',
    'walisisk'                                  => 'cy',
    'walser'                                    => 'wae',
    'waray'                                     => 'war',
    'washo'                                     => 'was',
    'wolof'                                     => 'wo',
    'xhosa'                                     => 'xh',
    'yakut'                                     => 'sah',
    'yangben'                                   => 'yav',
    'yao'                                       => 'yao',
    'yap'                                       => 'yap',
    'yoruba'                                    => 'yo',
    'yupisksprog'                               => 'ypk',
    'zande'                                     => 'znd',
    'zapotec'                                   => 'zap',
    'zarma'                                     => 'dje',
    'zaza'                                      => 'zza',
    'zenaga'                                    => 'zen',
    'zhuang'                                    => 'za',
    'zulu'                                      => 'zu',
    'zuni'                                      => 'zun',
    'østfrisisk'                               => 'frs',
    'østrigsktysk'                             => 'de_at',
    'øvresorbisk'                              => 'hsb',
);

1;
