# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20231210185942;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            43[1-6]|
            70[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [356]|
            4[124-7]|
            7[1-9]|
            8[1-6]|
            9[1-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              70|
              8
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            43[1-7]|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [48]|
            9[08]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '9',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'geographic' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'mobile' => '
          (?:
            43[07-9]|
            99[69]\\d
          )\\d{5}|
          (?:
            8[7-9]|
            98
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(700\\d{5})|(90\\d{6})',
                'toll_free' => '
          (?:
            00800\\d\\d|
            800
          )\\d{5}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{bg} = {"3599317", "Арчар",
"3593103", "Милево",
"3593523", "Синитево",
"3593705", "Въгларово",
"3595328", "Никола\ Козлево",
"3597159", "Априлово\,\ София",
"3593767", "Браница",
"35984776", "Хърсово\,\ Разград",
"359373", "Харманли",
"3596168", "Сушица\,\ В\.\ Търново",
"35971338", "Осиковска\ Лакавица",
"35971337", "Калугерово\,\ София",
"3599540", "Белотинци",
"3596918", "Дренов",
"3596998", "Голям\ извор\,\ Ловеч",
"3596540", "Асеново\,\ Плевен",
"3595522", "Искра\,\ Бургас",
"3593056", "Чепинци\,\ Смол\.",
"3595147", "Пчелник\,\ Варна",
"3593028", "Арда",
"3595102", "Падина\,\ Варна",
"3599168", "Бутан",
"35961603", "Лозен\,\ В\.\ Търново",
"3594332", "Ветрен\,\ Ст\.\ Загора",
"35941356", "Рупките",
"3595515", "Камено",
"3597728", "Друган",
"3596900", "Васильово",
"359518", "Провадия",
"35957304", "Дъбовик",
"3593628", "Миладиново",
"35931709", "Михилци",
"3599568", "Благово\,\ Монт\.",
"3594580", "Боринци",
"359431", "Казанлък",
"3595122", "Славейково\,\ Варна",
"3593146", "Куртово\ Конаре",
"3595713", "Стефаново\,\ Добр\.",
"359558", "Айтос",
"3595919", "Маринка",
"35959406", "Разбойна\,\ Бургас",
"3595310", "Радко\ Димитриево",
"3596920", "Лесидрен",
"3596329", "Царевец\,\ В\.\ Търново",
"3595115", "Генерал\ Кантарджиево",
"3595942", "Люляково\,\ Бургас",
"3596063", "Баячево",
"3595169", "Момчилово",
"3593926", "Добрич\,\ Хаск\.",
"3593123", "Калояново\,\ Пловдив",
"3594344", "Шаново",
"3598621", "Силистра",
"3593712", "Малево\,\ Хаск\.",
"3599329", "Рабиша",
"35930475", "Стоманево",
"3594138", "Гита",
"3593749", "Гарваново",
"3593725", "Стамболийски\,\ Хаск\.",
"359697", "Луковит",
"3599140", "Габаре",
"35930256", "Гълъбово\,\ Смол\.",
"3595766", "Методиево\,\ Добр\.",
"35995276", "Драганица",
"3596568", "Дъбован",
"35984269", "Недоклан",
"3599345", "Винарово\,\ Видин",
"35944", "Сливен",
"3596169", "Благоево\,\ В\.\ Търново",
"3596942", "Александрово\,\ Ловеч",
"3597158", "Доганово",
"3595329", "Мировци",
"3596115", "Ресен",
"3598132", "Юделник",
"3597126", "Горни\ Окол",
"3596965", "Бели\ Осъм",
"3596919", "Слатина\,\ Ловеч",
"35991888", "Веслец\,\ Враца",
"3596907", "Градежница",
"3595140", "Шкорпиловци",
"3595362", "Климент\,\ Шумен",
"3596122", "Беляковец",
"3596713", "Враниловци",
"35930412", "Девин",
"3596547", "Драгаш\ войвода",
"35963560", "Радишево",
"3598185", "Сеново",
"3595345", "Развигорово",
"3597143", "Вакарел",
"3593045", "Доспат",
"3594711", "Безмер\,\ Ямбол",
"3593555", "Нова\ махала\,\ Пазарджик",
"35935394", "Оборище\,\ Пазарджик",
"3599122", "Зверино",
"35984464", "Веселец\,\ Разград",
"3599547", "Винище",
"3597729", "Долна\ Диканя",
"3597745", "Егълница",
"3598673", "Алфатар",
"3597923", "Вратца",
"3593774", "Левка",
"3599169", "Рогозен",
"35969612", "Терзийско\,\ Ловеч",
"3599115", "Чирен",
"35971503", "Долно\ Камарци",
"3593029", "Петково\,\ Смол\.",
"3593662", "Железино",
"3599147", "Борован",
"35931394", "Васил\ Левски\,\ Пловдив",
"3599522", "Котеновци",
"3595918", "Русокастро",
"35981886", "Черешово\,\ Русе",
"3593645", "Аврен\,\ Кърдж\.",
"3595168", "Петров\ дол\,\ Варна",
"3596328", "Ореш",
"3597717", "Дивотино",
"3597053", "Кочериново",
"3593155", "Момино\ село",
"3594514", "Крушаре",
"3596934", "Катунец",
"35941331", "Гранит",
"3599515", "Мадан\,\ Монт\.",
"3599569", "Липен",
"35981262", "Бистренци",
"3593629", "Мост",
"3594736", "Светлина",
"3598144", "Батишница",
"3595397", "Методиево\,\ Шумен",
"3593753", "Оряхово\,\ Хаск\.",
"359618", "Горна\ Оряховица",
"35967304", "Крамолин",
"35991186", "Баурене",
"3597526", "Рибново",
"3595317", "Ивански",
"359454", "Твърдица\,\ Сливен",
"3597048", "Блажиево",
"3597106", "Ямна",
"3596515", "Славяново\,\ Плевен",
"3596569", "Ленково",
"35967392", "Яворец",
"3596927", "Умаревци",
"3597181", "Пирдоп",
"3594587", "Ябланово",
"3599328", "Долни\ Лом",
"35961308", "Вишовград",
"35963203", "Хаджидимитрово\,\ В\.\ Търново",
"35961307", "Стамболово\,\ В\.\ Търново",
"3595752", "Нова\ Камена",
"3593748", "Лясковец\,\ Хаск\.",
"3596147", "Иванча\,\ В\.\ Търново",
"3599356", "Каленик\,\ Видин",
"35984720", "Топчии",
"35961105", "Присово",
"3596522", "Згалево",
"35974201", "Капатово",
"3594139", "Свобода\,\ Ст\.\ Загора",
"35974322", "Петрово\,\ Благ\.",
"35960451", "Обител",
"35963565", "Мечка\,\ Плевен",
"3599110", "Вировско",
"35960384", "Гагово",
"3593196", "Дрангово\,\ Пловдив",
"3597042", "Коркина",
"3599315", "Градец\,\ Видин",
"35992", "Враца",
"3598661", "Тутракан",
"3593163", "Искра\,\ Пловдив",
"3595726", "Царичино",
"3596528", "Вълчитрън",
"3593707", "Николово\,\ Хаск\.",
"3599322", "Орешец\,\ Видин",
"3596556", "Горна\ Митрополия",
"3593719", "Книжовник",
"3596046", "Врани\ кон",
"3595758", "Кладенци",
"3593040", "Триград",
"3593765", "Иваново\,\ Хаск\.",
"3596322", "Алеково\,\ В\.\ Търново",
"3599556", "Говежда",
"3595340", "Висока\ поляна\,\ Шумен",
"3595949", "Планиница\,\ Бургас",
"3595162", "Белоградец",
"3595912", "Полски\ извор",
"35960372", "Крепча",
"3599528", "Гаганица",
"3595145", "Гроздьово",
"3596023", "Подгорица",
"3595129", "Блъсково",
"35962", "Велико\ Търново",
"3596960", "Белиш",
"35991183", "Фурен",
"3595517", "Равнец\,\ Бургас",
"3593116", "Крумово\,\ Пловдив",
"3595743", "Шабла",
"35931702", "Долна\ махала\,\ Пловдив",
"35961203", "Емен",
"3599128", "Елисейна",
"35937420", "Подкрепа",
"3598633", "Старо\ село\,\ Силистра",
"3594339", "Юлиево",
"3596953", "Борима",
"3593516", "Црънча\,\ Пазарджик",
"35941277", "Загоре",
"3596003", "Преселец",
"3595117", "Ботево\,\ Варна",
"35951536", "Николаевка",
"3597034", "Джерман",
"3596510", "Тотлебен",
"3595967", "Бата",
"3597426", "Марикостиново",
"3595529", "Крушово\,\ Бургас",
"3593563", "Варвара\,\ Пазарджик",
"35941145", "Арнаутито",
"3598138", "Бръшлен",
"35971506", "Габра",
"3597152", "Горна\ Малина",
"35984725", "Киченица",
"359938", "Кула",
"3596590", "Ракита\,\ Плевен",
"3596948", "Кърпачево",
"3595781", "Свобода\,\ Добр\.",
"3599347", "Бела\ Рада",
"3596156", "Родина",
"35991203", "Лик",
"3596128", "Хотница",
"3593727", "Нова\ Надежда",
"35981464", "Острица\,\ Русе",
"3595368", "Тъкач",
"3596529", "Коиловци",
"3596967", "Калейца",
"3593695", "Комунига",
"3594132", "Оризово",
"3596905", "Дивчовото",
"35959403", "Речица",
"359538", "Велики\ Преслав",
"3599184", "Оходен",
"359865", "Силистра",
"3596117", "Дебелец\,\ В\.\ Търново",
"3595759", "Кочмар",
"3593718", "Войводово\,\ Хаск\.",
"35984", "Разград",
"35961405", "Петко\ Каравелово",
"3598187", "Тетово",
"35967399", "Малки\ Вършец",
"35935418", "Кръстава",
"35930517", "Забърдо",
"3595347", "Живково\,\ Шумен",
"3598194", "Сандрово",
"3596562", "Гиген",
"3596545", "Любеново\,\ Плевен",
"35971304", "Липница\,\ София",
"35967774", "Белица\,\ Габр\.",
"3599545", "Габровница",
"3595128", "Житница\,\ Варна",
"3593557", "Бяга",
"35953220", "Памукчии\,\ Шумен",
"3593622", "Стремци",
"3593700", "Тракиец",
"3598114", "Пиргово",
"3595948", "Снягово\,\ Бургас",
"35931309", "Климент\,\ Пловдив",
"359308", "Мадан\,\ Смол\.",
"3595590", "Житосвят",
"3599117", "Криводол",
"3599529", "Боровци",
"35931324", "Мраченик",
"3599340", "Септемврийци\,\ Видин",
"3599162", "Михайлово\,\ Враца",
"3593647", "Черничево\,\ Кърдж\.",
"3593157", "Болярино",
"3597715", "Студена\,\ Перник",
"3593022", "Виево",
"3595556", "Голямо\ Буково",
"3595108", "Садово\,\ Варна",
"3599145", "Бреница\,\ Враца",
"3595528", "Невестино\,\ Бургас",
"3596726", "Скалско",
"3593720", "Маджарово",
"3596992", "Златна\ Панега",
"35963571", "Брестовец",
"3593323", "Болярци\,\ Пловдив",
"3594144", "Ковачево\,\ Ст\.\ Загора",
"3595395", "Чернооково\,\ Шумен",
"3594741", "Болярово",
"3599129", "Синьо\ бърдо",
"3599517", "Кобиляк",
"3596584", "Белене",
"3594338", "Крън",
"3596517", "Подем",
"3596071", "Антоново",
"3596925", "Владиня",
"3597166", "Владо\ Тричков",
"3597916", "Багренци",
"35930419", "Ягодина",
"35931401", "Кадиево",
"3596129", "Габровци",
"3597193", "Голеш\,\ София",
"35941353", "Плодовитово",
"3595315", "Царев\ брод",
"35952", "Варна",
"3596145", "Страхилово",
"35947204", "Пчела",
"3599726", "Замфир",
"359707", "Сапарева\ баня",
"35961606", "Владислав",
"3596912", "Баховица",
"3594585", "Жеравна",
"3593346", "Мулдава",
"3596047", "Зелена\ морава",
"3593706", "Тънково\,\ Хаск\.",
"3596557", "Брегаре",
"3598678", "Срацимир\,\ Силистра",
"35931620", "Добри\ дол\,\ Пловдив",
"35931993", "Сърнегор",
"3597928", "Гърляно",
"3596002", "Съединение\,\ Търг\.",
"3595727", "Сенокос\,\ Добр\.",
"3597148", "Мухово",
"3596952", "Орешак\,\ Ловеч",
"35961309", "Горско\ Калугерово",
"359608", "Попово\,\ Търг\.",
"3593781", "Симеоновград",
"3598632", "Зафирово",
"35963575", "Бохот",
"35941174", "Подслон\,\ Ст\.\ Загора",
"3593197", "Тюркмен",
"35974406", "Добърско",
"3597755", "Велковци\,\ Перник",
"3596718", "Драгановци",
"3593671", "Подкова",
"3593117", "Катуница",
"3593109", "Лилково",
"3595516", "Индже\ войвода",
"3593529", "Мокрище",
"3597442", "Якоруда",
"35984735", "Свещари",
"3595734", "Преселенци",
"3594777", "Тенево",
"3595131", "Вълчи\ дол",
"3593055", "Елховец",
"3593545", "Драгиново",
"3599557", "Горно\ Церовене",
"3593562", "Славовица\,\ Пазарджик",
"35971398", "Осиковица",
"35941489", "Боздуганово",
"3599323", "Дреновец",
"3597427", "Първомай\,\ Благ\.",
"3597910", "Берсин",
"3593129", "Скутаре",
"3595116", "Крумово\,\ Варна",
"3593743", "Силен",
"3598644", "Чернолик",
"3594321", "Мъглиж",
"3593517", "Лесичово",
"3593071", "Златоград",
"359677", "Трявна",
"3593925", "Крум",
"3593162", "Градина\,\ Пловдив",
"3593340", "Нови\ извор",
"35969244", "Тепава",
"3597043", "Големо\ село",
"3593145", "Кричим",
"35941116", "Сладък\ Кладенец",
"3599720", "Ковачица",
"3597174", "Калотина",
"35931606", "Воден\,\ Пловдив",
"3593726", "Клокотница",
"3595742", "Раковски\,\ Добр\.",
"3596720", "Керека",
"3595765", "Ловчанци",
"3596022", "Пробуда\,\ Търг\.",
"3593758", "Йерусалимово",
"359861", "Силистра",
"3596157", "Сливовица",
"3595719", "Дончево",
"3599346", "Синаговци",
"3595913", "Крушевец",
"3593584", "Ветрен\,\ Пазарджик",
"35953436", "Черноглавци",
"3597434", "Струмяни",
"3595163", "Млада\ гвардия",
"3596069", "Васил\ Левски\,\ Търг\.",
"35991401", "Враняк",
"3597058", "Стоб",
"3596323", "Българско\ сливово",
"3597548", "Годешево",
"3596531", "Изгрев\,\ Плевен",
"3599742", "Якимово",
"3597149", "Живково\,\ София",
"3594770", "Генерал\ Инзово",
"3595346", "Каменяк\,\ Шумен",
"3593322", "Златовръх",
"3597723", "Долни\ Раковец",
"3599719", "Аспарухово\,\ Монт\.",
"3599550", "Митровци",
"35941330", "Ценово\,\ Ст\.\ Загора",
"3593110", "Поповица",
"3597929", "Соволяно",
"3594764", "Маленово",
"35974327", "Ново\ Делчево",
"35974495", "Юруково",
"3598679", "Кайнарджа",
"3596116", "Големаните",
"35932", "Пловдив",
"3593023", "Момчиловци",
"3597125", "Говедарци",
"3596966", "Шипково",
"3599163", "Хърлец",
"3595323", "Плиска",
"3596163", "Камен\,\ В\.\ Търново",
"35984721", "Липник",
"35984749", "Севар",
"3593190", "Върбен\,\ Пловдив",
"3596913", "Славяни",
"35931708", "Песнопой\,\ Пловдив",
"35931707", "Черноземен",
"3599116", "Костелево",
"3593108", "Бойково",
"3593556", "Радилово",
"3597192", "Гинци",
"3593046", "Барутин",
"3596550", "Ставерци",
"35937704", "Младиново",
"35960378", "Цар\ Асен\,\ Търг\.",
"35960377", "Априлово\,\ Търг\.",
"3593528", "Говедаре",
"3599516", "Лехчево",
"3595952", "Малко\ Търново",
"3596563", "Брест\,\ Плевен",
"35963561", "Гривица",
"359470", "Тополовград",
"3596727", "Ганчовец",
"3593128", "Златитрап",
"3599131", "Добролево",
"35984763", "Бели\ Лом",
"3596150", "Златарица",
"3593646", "Токачка",
"359747", "Разлог",
"3595557", "Бистрец\,\ Бургас",
"3593156", "Шишманци",
"35935256", "Сбор\,\ Пазарджик",
"359726", "Своге",
"3593347", "Леново",
"3599727", "Медковец",
"3597549", "Долен\,\ Благ\.",
"3599355", "Косово\,\ Видин",
"3596068", "Божурка",
"3596734", "Петко\ Славейков",
"3593623", "Бойно",
"3597917", "Таваличево",
"3594354", "Зимница\,\ Ст\.\ Загора",
"3597525", "Баничан",
"3597105", "Малки\ Искър",
"3596516", "Искър\,\ Плевен",
"3595718", "Смолница",
"3593759", "Бориславци",
"3597167", "Церово\,\ София",
"3593510", "Овчеполци",
"3595943", "Вресово",
"3596062", "Стража\,\ Търг\.",
"3598694", "Зебил",
"35930418", "Буйново\,\ Смол\.",
"35930417", "Грохотно",
"3596555", "Байкал",
"35984766", "Каменар\,\ Разград",
"3593766", "Бисер",
"3593195", "Розовец",
"3595712", "Стожер",
"3595123", "Равна\,\ Варна",
"35935501", "Равногор",
"3596029", "Надарево",
"3595749", "Крапец\,\ Добр\.",
"35941335", "Могилово",
"3599316", "Ново\ село\,\ Видин",
"35937421", "Долно\ поле",
"3595958", "Граматиково",
"3597120", "Долна\ баня",
"3599171", "Оряхово\,\ Враца",
"3594361", "Павел\ баня",
"3593115", "Куклен",
"3594554", "Трапоклово",
"35961101", "Велчево\,\ В\.\ Търново",
"3599555", "Копиловци\,\ Монт\.",
"35965165", "Писарово\,\ Плевен",
"3594775", "Каравелово\,\ Ямбол",
"3595146", "Горен\ чифлик",
"3593057", "Пловдивци",
"3593713", "Динево",
"3593122", "Маноле",
"3593547", "Сърница\,\ Пазарджик",
"3594154", "Медникарово",
"3594751", "Войника",
"3593515", "Калугерово\,\ Пазарджик",
"3593569", "Карабунар",
"35981268", "Кривина\,\ Русе",
"3593927", "Черногорово\,\ Хаск\.",
"359318", "Съединение\,\ Пловдив",
"3597520", "Корница",
"3597425", "Кулата",
"3593147", "Ново\ село\,\ Пловдив",
"3593522", "Гелеменово",
"3593657", "Жълтуша",
"3593102", "Караджово",
"35931308", "Богдан\,\ Пловдив",
"35960450", "Долна\ Хубавка",
"3598639", "Коларово\,\ Силистра",
"3595767", "Житница\,\ Добр\.",
"3597118", "Драговищица\,\ София",
"3596155", "Константин",
"3593328", "Долнослав",
"35961302", "Батак\,\ В\.\ Търново",
"3599748", "Дългоделци",
"35961394", "Дъскот",
"3596959", "Дебнево",
"3594333", "Дъбово\,\ Ст\.\ Загора",
"3596571", "Лепица",
"3594730", "Княжево",
"3595523", "Крумово\ градище",
"3593934", "Скобелево\,\ Хаск\.",
"35936401", "Странджево",
"35967397", "Ряховците",
"35967398", "Дамяново",
"35935419", "Света\ Петка",
"35974388", "Горно\ Спанчево",
"3596028", "Вардун",
"3593752", "Малко\ градище",
"359973", "Козлодуй",
"35931603", "Виница",
"35941113", "Пряпорец\,\ Ст\.\ Загора",
"3593050", "Букова\ поляна",
"359722", "Самоков",
"3596546", "Лозица\,\ Плевен",
"35963570", "Староселци",
"3595748", "Дуранкулак",
"3596981", "Петревене",
"3597127", "Широки\ дол",
"3597052", "Пастра",
"3593696", "Пчеларово\,\ Кърдж\.",
"3596906", "Черни\ Вит",
"3598161", "Ветово",
"3594101", "Опан",
"3599523", "Бързия",
"3596523", "Крушовица\,\ Плевен",
"35984730", "Голям\ Поровец",
"3595753", "Орляк",
"35955505", "Драчево",
"3597731", "Трън",
"3595571", "Сунгурларе",
"35936702", "Горски\ извор\,\ Кърдж\.",
"3597134", "Врачеш",
"3595959", "Звездец",
"3599546", "Славотин",
"3593168", "Езерово\,\ Пловдив",
"35941279", "Стрелец\,\ Ст\.\ Загора",
"3595774", "Коритен",
"3594737", "Синапово",
"35946", "Ямбол",
"3595396", "Ловец\,\ Шумен",
"3597448", "Бачево",
"3596712", "Гъбене",
"3596123", "Буковец\,\ В\.\ Търново",
"3595363", "Гусла",
"35971798", "Василовци\,Соф\.",
"3593568", "Виноградец",
"3593631", "Момчилград",
"3595555", "Факия",
"3598133", "Ряхово",
"3595760", "Божурово\,\ Добр\.",
"3596725", "Гостилица",
"3599146", "Соколаре",
"35977221", "Кондофрей",
"35931996", "Свежен",
"3596943", "Горско\ Сливово",
"3599725", "Комощица",
"3596146", "Полски\ Сеновец",
"359720", "Етрополе",
"3598672", "Брадвари",
"3594586", "Нейково\,\ Сливен",
"3597922", "Драговищица\,\ Кюст\.",
"3593345", "Лясково\,\ Пловдив",
"3599123", "Роман",
"3593920", "Златополе",
"3597119", "Дръмша",
"3596926", "Горно\ Павликене",
"3597165", "Миланово\,\ София",
"3598638", "Богданци\,\ Силистра",
"35953221", "Стоян\ Михайловски",
"3597915", "Невестино\,\ Кюст\.",
"3596958", "Априлци\,\ Ловеч",
"3594724", "Раздел\,\ Ямбол",
"3597142", "Костенец",
"3595316", "Салманово",
"3597527", "Горно\ Дряново",
"3599749", "Черни\ връх\,\ Монт\.",
"3594121", "Люляк",
"35974403", "Долно\ Драглище",
"3593587", "Сестримо",
"35974408", "Обидим",
"3594331", "Гурково\,\ Ст\.\ Загора",
"3592", "София",
"35974407", "Кремен\,\ Благ\.",
"3593935", "Върбица\,\ Хаск\.",
"3594748", "Воден\,\ Ямбол",
"35960385", "Ломци",
"3597437", "Мелник",
"35963564", "Биволаре",
"359746", "Сандански",
"3599333", "Бойница",
"3595521", "Венец\,\ Бургас",
"3596154", "Буйновци",
"3595101", "Дъбравино",
"3596573", "Койнаре",
"3596032", "Зараево",
"359868", "Силистра",
"35993342", "Киреево",
"3597177", "Алдомировци",
"35991189", "Три\ кладенци",
"3594753", "Зорница\,\ Ямбол",
"359727", "Сливница\,\ София",
"3597424", "Кърналово",
"3594350", "Горно\ Изворово",
"3597036", "Баланово",
"3594155", "Главан\,\ Ст\.\ Загора",
"3593514", "Черногорово\,\ Пазарджик",
"3598647", "Паисиево",
"35961602", "Царски\ извор",
"35956", "Бургас",
"3595737", "Люляково\,\ Добр\.",
"3598669", "Гарван\,\ Силистра",
"35991668", "Манастирище",
"3594774", "Крумово\,\ Ямбол",
"3594363", "Габарево",
"3599173", "Галово",
"3597938", "Долно\ Уйно",
"3599554", "Чипровци",
"3593114", "Брестник",
"359601", "Търговище",
"3593711", "Долно\ Ботево",
"3598622", "Алеково\,\ Силистра",
"35953437", "Габрица\,\ Шумен",
"35951429", "Солник",
"35931390", "Московец",
"3593194", "Зелениково\,\ Пловдив",
"3595941", "Скалак\,\ Бургас",
"35941144", "Калояновец",
"35937604", "Върбово\,\ Хаск\.",
"35934", "Пазарджик",
"3596173", "Долна\ Оряховица",
"3596044", "Долно\ Козарево",
"3596554", "Крушовене",
"35981465", "Батин",
"3598695", "Ножарево",
"35941118", "Остра\ могила\,\ Ст\.\ Загора",
"3595121", "Тутраканци",
"35941117", "Казанка",
"3595724", "Дропла\,\ Добр\.",
"35958", "Добрич",
"35937701", "Сладун",
"3594725", "Лесово",
"3594357", "Горно\ Сахране",
"35967393", "Душево",
"3597914", "Ваксево",
"3597164", "Реброво",
"35931706", "Сухозем",
"3598640", "Правда\,\ Силистра",
"359339", "Стамболийски\,\ Пловдив",
"3598150", "Семерджиево",
"3594123", "Богомилово",
"3593344", "Новаково\,\ Пловдив",
"3594712", "Кабиле",
"35969241", "Йоглав",
"35963202", "Драгомирово\,\ В\.\ Търново",
"35959409", "Череша",
"3596737", "Крушево\,\ Габр\.",
"3593138", "Ведраре",
"359676", "Дряново\,\ Габр\.",
"35960376", "Люблен",
"3599724", "Станево",
"3599121", "Царевец\,\ Враца",
"3594749", "Ружица\,\ Ямбол",
"35966", "Габрово",
"35968", "Ловеч",
"3595361", "Каолиново",
"3596724", "Янтра\,\ Габр\.",
"3596121", "Никюп",
"35996", "Монтана",
"3595554", "Момина\ църква",
"3594792", "Ботево\,\ Ямбол",
"35931258", "Главатар",
"3596941", "Летница",
"3596586", "Белене",
"35984266", "Просторно",
"359331", "Асеновград",
"3597430", "Дамяница",
"359750", "Боровец\,\ София",
"3598131", "Борисово\,\ Русе",
"3594146", "Диня",
"3593633", "Рогозче",
"3595775", "Полковник\ Дяково",
"3598116", "Иваново\,\ Русе",
"3597182", "Мирково",
"3595573", "Везенково",
"3597733", "Филиповци",
"35935258", "Цар\ Асен\,\ Пазарджик",
"3595751", "Тервел\,\ Добр\.",
"35935257", "Сарая",
"35984710", "Осенец",
"3596521", "Садовец",
"35971502", "Елешница\,\ София",
"35969613", "Чифлик\,\ Ловеч",
"3598668", "Попина",
"3597135", "Трудовец",
"3597939", "Църварица",
"35984779", "Здравец\,\ Разград",
"35941171", "Дълбоки",
"3596983", "Дерманци",
"3599186", "Згориград",
"3595333", "Хан\ Крум",
"35984394", "Духовец",
"3599521", "Замфирово",
"3594103", "Бял\ извор\,\ Ст\.\ Загора",
"3598163", "Бъзън",
"3593661", "Ивайловград",
"3593538", "Елшица",
"35930413", "Девин",
"3598196", "Нисово",
"35941359", "Изворово\,\ Ст\.\ Загора",
"3594523", "Стоил\ войвода",
"3597435", "Склаве",
"3593585", "Аканджиево",
"35969616", "Старо\ село\,\ Ловеч",
"3593937", "Ябълково\,\ Хаск\.",
"35971227", "Бели\ Искър",
"35971228", "Марица",
"3594346", "Голямо\ Дряново",
"3596321", "Горна\ Студена",
"3595161", "Ветрино",
"35991202", "Кунино",
"3595764", "Владимирово\,\ Добр\.",
"3593532", "Стрелча",
"35930416", "Гьоврен",
"3597175", "Габер",
"3593073", "Старцево",
"3594323", "Тулово",
"3593741", "Мандра",
"3598629", "Смилец\,\ Силистра",
"35951104", "Долище\,\ Варна",
"35984768", "Синя\ вода",
"3597188", "Петрич\,\ София",
"35957305", "Росица\,\ Добр\.",
"3593924", "Крепост",
"3595533", "Пирне",
"3594157", "Разделна\,\ Ст\.\ Загора",
"3597041", "Шатрово",
"3598645", "Межден",
"3598662", "Добротица\,\ Силистра",
"3594798", "Савино",
"35960373", "Посабина",
"3593054", "Подвис\,\ Смол\.",
"359570", "Каварна",
"3593673", "Тихомир",
"3593544", "Костандово",
"3595735", "Красен\,\ Добр\.",
"35931703", "Житница\,\ Пловдив",
"35991182", "Осен\,\ Враца",
"359359", "Велинград",
"3597754", "Кошарево",
"3594557", "Биково",
"35974386", "Пирин",
"35967396", "Бериево",
"3595782", "Бенковски\,\ Добр\.",
"3595133", "Генерал\ Колево\,\ Варна",
"3596039", "Опака",
"35981266", "Стърмен\,\ Русе",
"3593178", "Красново",
"3598431", "Исперих",
"35974323", "Лозеница",
"3598697", "Сокол\,\ Силистра",
"3595354", "Риш",
"359915", "Бяла\ Слатина",
"3593783", "Свирково",
"3593132", "Баня\,\ Пловдив",
"3594718", "Роза",
"35941352", "Винарово\,\ Ст\.\ Загора",
"3596133", "Михалци",
"3597104", "Лъга",
"3594727", "Малък\ манастир",
"3594355", "Бузовград",
"3597524", "Абланица\,\ Благ\.",
"3599354", "Антимово\,\ Видин",
"359670", "Троян\,\ Ловеч",
"35951539", "Левски\,\ Варна",
"3599561", "Сумер",
"3598123", "Босилковци",
"35960380", "Дриново",
"3594516", "Кермен",
"35984465", "Савин",
"3597932", "Шипочано",
"35930528", "Манастир\,\ Пловдив",
"3596561", "Гулянци",
"35961391", "Сломер",
"3594734", "Срем",
"3597189", "Чавдар\,\ София",
"3599782", "Буковец\,\ Монт\.",
"3599133", "Комарево\,\ Враца",
"3598628", "Цар\ Асен\,\ Силистра",
"359723", "Ботевград",
"3598690", "Силистра",
"3596911", "Лисец\,\ Ловеч",
"3596161", "Стражица\,\ В\.\ Търново",
"3595321", "Правенци",
"3594116", "Ракитница\,\ Ст\.\ Загора",
"35931395", "Иганово",
"3594799", "Голям\ манастир",
"3596072", "Добротица\,\ Търг\.",
"3593776", "Райкова\ могила",
"35937424", "Козлец",
"3597137", "Скравена",
"3596770", "Плачковци",
"3594742", "Стефан\ Караджово",
"3597124", "Белчински\ бани",
"35967305", "Стоките",
"3596533", "Стежерово",
"3599161", "Мизия",
"35961104", "Водолей",
"35931997", "Златосел",
"35931998", "Чоба",
"3596991", "Ябланица",
"3595132", "Михалич\,\ Варна",
"3595783", "Котленци",
"35947354", "Каменна\ река",
"3593638", "Звездел",
"3593561", "Септември",
"3594510", "Желю\ войвода",
"3596930", "Славщица",
"35941358", "Опълченец",
"35941357", "Зетьово\,\ Ст\.\ Загора",
"35941334", "Съединение\,\ Ст\.\ Загора",
"3594347", "Розово\,\ Ст\.\ Загора",
"3593936", "Горски\ извор\,\ Хаск\.",
"3593672", "Чорбаджийско",
"3598140", "Борово\,\ Русе",
"359559", "Карнобат",
"35967301", "Идилево",
"3599339", "Макреш",
"3593133", "Калофер",
"3598631", "Силистра",
"3593782", "Калугерово\,\ Хаск\.",
"3597035", "Червен\ брег",
"3594156", "Априлово\,\ Ст\.\ Загора",
"35984778", "Богданци\,\ Разград",
"3596579", "Рупци\,\ Плевен",
"35974204", "Гега",
"3596001", "Черковна\,\ Търг\.",
"3594108", "Васил\ Левски\,\ Ст\.\ Загора",
"3594556", "Сотиря",
"3593533", "Бъта",
"359702", "Бобов\ дол",
"359519", "Девня",
"3594528", "Любенова\ махала",
"3596988", "Пещерна",
"35930257", "Вишнево",
"3595144", "Камчия",
"3596179", "Крушето",
"3595338", "Троица",
"3596021", "Буховци",
"35995277", "Черкаски",
"3593764", "Поляново\,\ Хаск\.",
"3593038", "Чокманово",
"3598663", "Ситово\,\ Силистра",
"35961395", "Паскалевец",
"35942", "Стара\ Загора",
"35931992", "Пъдарско",
"3598696", "Суходол\,\ Силистра",
"35935391", "Блатница",
"35953234", "Златна\ нива",
"3595532", "Тополица",
"3594369", "Александрово\,\ Ст\.\ Загора",
"3598445", "Юпер",
"3595578", "Терзийско\,\ Бургас",
"35959407", "Сини\ рид",
"3599314", "Дунавци\,\ Видин",
"35959408", "Ръжица",
"3594322", "Ягода",
"359596", "Поморие",
"35967194", "Гръблевци",
"3593072", "Неделино",
"3594597", "Боров\ дол",
"3594584", "Тича",
"3596144", "Долна\ Липница",
"359619", "Лясковец\,\ В\.\ Търново",
"3594726", "Маломирово",
"3595314", "Белокопитово",
"35941119", "Елхово\,\ Ст\.\ Загора",
"35984711", "Мортагоново",
"3593639", "Нановица\,\ Кърдж\.",
"3596585", "Белене",
"3594340", "Паничерево",
"3596937", "Соколово\,\ Ловеч",
"35955504", "Богданово\,\ Бургас",
"3594145", "Знаменосец",
"3595394", "Бяла\ река\,\ Шумен",
"3596578", "Реселец",
"3595776", "Черна\,\ Добр\.",
"3598147", "Баниска",
"3596532", "Българене\,\ Плевен",
"3599144", "Нивянин",
"3594129", "Маджерито",
"3599741", "Долни\ Цибър",
"35951428", "Господиново\,\ Варна",
"3594743", "Мамарчево",
"3597714", "Мещица",
"3593321", "Тополово\,\ Пловдив",
"3594517", "Ичера",
"3599338", "Шишенци",
"3597136", "Новачене\,\ София",
"3598122", "Ценово\,\ Русе",
"3593777", "Мезек",
"3596178", "Стрелец\,\ В\.\ Търново",
"3596989", "Торос",
"35991188", "Галатин",
"3594562", "Крива\ круша",
"35969240", "Хлевене",
"35961306", "Патреш",
"3598115", "Червена\ вода",
"3594109", "Тракия",
"3594529", "Съдиево\,\ Сливен",
"3599544", "Студено\ буче",
"3596132", "Караисен",
"35969032", "Български\ извор",
"3596544", "Новачене\,\ Плевен",
"3595579", "Ведрово",
"3599132", "Кнежа",
"3599783", "Брусарци",
"35974409", "Места",
"3593039", "Полковник\ Серафимово",
"3599185", "Бели\ Извор",
"3594368", "Търничени",
"35961703", "Върбица\,\ В\.\ Търново",
"35951314", "Войводино",
"3597933", "Грамаждано",
"359659", "Червен\ бряг",
"3599344", "Връв",
"3594329", "Долно\ Сахране",
"3593079", "Козарка",
"35954", "Шумен",
"35938", "Хасково",
"35961303", "Горна\ Липница",
"3599138", "Алтимир",
"3593724", "Сусам",
"3598623", "Голеш\,\ Силистра",
"3593121", "Рогош",
"3594362", "Манолово",
"3595539", "Черноград",
"3594140", "Полски\ Градец",
"35941175", "Колена",
"3597436", "Левуново",
"3599172", "Селановци",
"35963574", "Тодорово\,\ Плевен",
"3593586", "Боримечково",
"3596580", "Татари",
"3594345", "Радунци",
"359631", "Свищов",
"35961706", "Писарево\,\ В\.\ Търново",
"3598156", "Червен\,\ Русе",
"3595711", "Овчарово\,\ Добр\.",
"3598646", "Вокил",
"3595114", "Езерово\,\ Варна",
"3598128", "Полско\ Косово",
"3597176", "Храбърско",
"3596138", "Недан",
"3596061", "Голямо\ Соколово",
"35947201", "Изгрев\,\ Ямбол",
"35984734", "Тодорово\,\ Разград",
"3596572", "Сухаче",
"3599180", "Голямо\ Пещене",
"3599332", "Раковица",
"35935252", "Тополи\ дол",
"359335", "Карлово",
"35969245", "Деветаки",
"3596538", "Обнова",
"3595736", "Василево",
"359848", "Кубрат",
"3593521", "Звъничево",
"35982", "Русе",
"3593679", "Кирково",
"3593704", "Брягово\,\ Хаск\.",
"3593101", "Войводиново",
"359554", "Слънчев\ бряг",
"3594752", "Първенец\,\ Ямбол",
"35951538", "Изгрев\,\ Варна",
"35951537", "Чернево",
"359590", "Царево",
"35941276", "Могила\,\ Ст\.\ Загора",
"3595139", "Оборище\,\ Варна",
"3596033", "Медовина",
"3596736", "Градница\,\ Габр\.",
"3595538", "Караново\,\ Бургас",
"3594595", "Сборище",
"3593032", "Средногорци",
"359361", "Кърджали",
"35974402", "Годлево",
"3596514", "Долни\ Дъбник",
"3597030", "Ресилово",
"3594356", "Хаджидимитрово\,\ Ст\.\ Загора",
"3599139", "Търнава\,\ Враца",
"3597732", "Вукан",
"3595572", "Бероново",
"3597183", "Душанци",
"3594147", "Любеново\,\ Ст\.\ Загора",
"3597541", "Сатовча",
"3594522", "Кортен",
"3598145", "Тръстеник\,\ Русе",
"3596587", "Петокладенци",
"3594102", "Ястребово\,\ Ст\.\ Загора",
"3596935", "Сопот\,\ Ловеч",
"3599514", "Владимирово\,\ Монт\.",
"3593154", "Чалъкови",
"3594515", "Мокрен",
"3593751", "Любимец",
"359605", "Омуртаг",
"3593644", "Егрек",
"35937705", "Пъстрогор",
"3595332", "Драгоево",
"3598129", "Лом\ Черковна",
"359418", "Гълъбово\,\ Ст\.\ Загора",
"35984743", "Брестовене",
"35981461", "Каран\ Върбовка",
"3596982", "Ъглен",
"359309", "Пампорово",
"3595580", "Трояново\,\ Бургас",
"35960454", "Змейно",
"35984769", "Гороцвет",
"3593775", "Генералово",
"3596539", "Градище\,\ Плевен",
"3597744", "Еловдол\,\ Перник",
"3594713", "Стара\ река\,\ Ямбол",
"3594122", "Еленино",
"35951127", "Разделна\,\ Варна",
"35961607", "Балканци\,\ В\.\ Търново",
"35961608", "Горски\ Сеновец",
"35964", "Плевен",
"3597921", "Жиленци",
"3598117", "Мартен",
"3598671", "Силистра",
"3593173", "Паничери",
"3594115", "Кирилово\,\ Ст\.\ Загора",
"3593044", "Лясково\,\ Смол\.",
"3593554", "Козарско",
"35994", "Видин",
"3598184", "Глоджево",
"3593632", "Джебел",
"3595344", "Велино",
"35931602", "Татарево\,\ Пловдив",
"35941112", "Старозагорски\ бани",
"3595138", "Добротич",
"35931791", "Бегово",
"3594793", "Бояджик",
"3596964", "Велчево\,\ Ловеч",
"3596114", "Килифарево",
"3596711", "Кози\ рог",
"359301", "Смолян",
"3593678", "Чакаларово",
"3599187", "Лютаджик",
"359650", "Левски\,\ Плевен",
"3596987", "Карлуково",
"3594763", "Иречеково",
"3596535", "Козар\ Белене",
"3593779", "Сива\ река",
"3596994", "Брестница\,\ Ловеч",
"3595337", "Кочово",
"3599164", "Крушовица\,\ Враца",
"35941173", "Братя\ Кунчеви",
"3593024", "Търън",
"3594796", "Генерал\ Тошево\,\ Ямбол",
"3598167", "Церовец",
"3594107", "Средец\,\ Ст\.\ Загора",
"35963579", "Ралево",
"35961305", "Лесичери",
"3596582", "Белене",
"35961108", "Плаково",
"35978", "Кюстендил",
"35961107", "Момин\ сбор",
"3594527", "Загорци\,\ Сливен",
"3597724", "Извор\,\ Перник",
"3594142", "Трояново\,\ Ст\.\ Загора",
"3595577", "Подвис\,\ Бургас",
"3593176", "Старосел",
"35976", "Перник",
"359745", "Петрич\,\ Благ\.",
"35941270", "Малка\ Верея",
"35930411", "Девин",
"3593037", "Сивино",
"359306", "Рудозем",
"3596164", "Бряговица",
"3595324", "Хърсово\,\ Шумен",
"3594716", "Веселиново\,\ Ямбол",
"3596914", "Сливек",
"35974202", "Ключ",
"3599182", "Девене",
"35969243", "Казачево",
"3594599", "Червенаково",
"3594348", "Дунавци\,\ Ст\.\ Загора",
"3596570", "Девенци",
"3594134", "Братя\ Даскалови",
"3599135", "Бърдарски\ геран",
"35941019", "Венец\,\ Ст\.\ Загора",
"359910", "Мездра",
"35967391", "Столът",
"3599330", "Раброво",
"3593637", "Груево",
"3596564", "Загражден\,\ Плевен",
"3598192", "Хотанца",
"3596939", "Драгана",
"3594353", "Средногорово",
"3599564", "Стубел",
"3593624", "Чифлик\,\ Кърдж\.",
"3597186", "Антон",
"3596135", "Върбовка",
"35941332", "Найденово",
"3598149", "Кацелово",
"35961502", "Горско\ Ново\ Село",
"359610", "Павликени\,\ В\.\ Търново",
"3599351", "Извор\,\ Видин",
"3597521", "Копривлен",
"3598125", "Копривец",
"3596733", "Кормянско",
"3594519", "Самуилово\,\ Сливен",
"359457", "Нова\ Загора",
"3596036", "Садина",
"3593030", "Широка\ лъка",
"3594118", "Памукчии\,\ Ст\.\ Загора",
"3595351", "Смядово",
"3596177", "Янтра\,\ В\.\ Търново",
"3593778", "Студена\,\ Хаск\.",
"3595570", "Манолич",
"3593785", "Дряново\,\ Хаск\.",
"3597032", "Яхиново",
"3597751", "Брезник",
"3593675", "Фотиново\,\ Кърдж\.",
"3597154", "Столник",
"35984745", "Владимировци",
"3594100", "Столетово\,\ Ст\.\ Загора",
"3595733", "Кардам\,\ Добр\.",
"35937703", "Димитровче",
"3594520", "Коньово",
"3594367", "Тъжа",
"359675", "Севлиево",
"3593051", "Чепеларе",
"3595135", "Стефан\ Караджа\,\ Варна",
"3596980", "Беленци",
"3595330", "Златар",
"359379", "Свиленград",
"35984764", "Сейдол",
"3598442", "Завет\,\ Разград",
"35951108", "Изворско",
"3593075", "Долен\,\ Смол\.",
"3593921", "Меричлери",
"3594325", "Кънчево",
"3597044", "Бабино",
"3594757", "Недялско",
"3599324", "Ружинци",
"3595535", "Лясково\,\ Бургас",
"3593651", "Ардино",
"35955502", "Суходол\,\ Бургас",
"3598643", "Златоклас",
"359550", "Созопол",
"3593744", "Сърница\,\ Хаск\.",
"35971224", "Шипочане",
"3593583", "Габровица",
"3595914", "Атия",
"3594518", "Тополчане",
"359701", "Дупница",
"3596324", "Вардим",
"359936", "Белоградчик",
"3599337", "Грамада",
"3595164", "Неофит\ Рилски",
"3595761", "Батово",
"3597433", "Кресна",
"359417", "Раднево",
"3596938", "Каленик\,\ Ловеч",
"3598626", "Средище\,\ Силистра",
"3598148", "Горно\ Абланово",
"3596577", "Бресте",
"3595335", "Миланово\,\ Шумен",
"3594512", "Блатец\,\ Сливен",
"3597936", "Слокощица",
"3599524", "Ягодово\,\ Монт\.",
"3595130", "Генерал\ Киселово",
"3596985", "Румянцево",
"3593664", "Плевун",
"3596537", "Асеновци",
"3598142", "Бъзовец\,\ Русе",
"3594525", "Омарчево\,\ Сливен",
"35941339", "Димитриево",
"3598165", "Смирненски\,\ Русе",
"3596932", "Микре",
"3594105", "Бяло\ поле",
"3597735", "Лева\ река",
"3595575", "Прилеп\,\ Бургас",
"3598448", "Тертер",
"35935254", "Добровница",
"3596524", "Петърница",
"35984740", "Бисерци",
"3597133", "Правец",
"3593035", "Върбина",
"3599189", "Паволче",
"3595754", "Зърнево",
"3594592", "Бяла\ паланка",
"3594746", "Попово\,\ Ямбол",
"35984732", "Йонково",
"3598134", "Малко\ Враново",
"3596944", "Крушуна",
"35936700", "Шопци",
"3595551", "Средец\,\ Бургас",
"3597533", "Осиково\,\ Благ\.",
"35931402", "Скобелево\,\ Пловдив",
"3595773", "Лозенец\,\ Добр\.",
"3599137", "Попица",
"3596124", "Леденик",
"3596137", "Бутово",
"3595530", "Пещерско",
"3594149", "Трънково\,\ Ст\.\ Загора",
"3599721", "Долно\ Церовене",
"3599124", "Типченица",
"3593341", "Конуш\,\ Пловдив",
"35963572", "Ясен\,\ Плевен",
"3594112", "Бъдеще",
"3594723", "Бояново\,\ Ямбол",
"3596589", "Кулина\ вода",
"359453", "Котел",
"3594567", "Баня\,\ Сливен",
"35937706", "Чернодъб",
"3596076", "Таймище",
"3594125", "Михайлово\,\ Ст\.\ Загора",
"35961393", "Горско\ Косово",
"3593772", "Момково",
"3598127", "Караманово",
"3597911", "Граница",
"3595124", "Комарево\,\ Варна",
"35930458", "Любча",
"35930457", "Късак",
"35931701", "Кръстевич",
"3598118", "Николово\,\ Русе",
"35984727", "Каменово\,\ Разград",
"3596551", "Тръстеник\,\ Плевен",
"35984728", "Раковски\,\ Разград",
"3593191", "Брезово\,\ Пловдив",
"3598693", "Звенимир",
"3593787", "Тянево\,\ Хаск\.",
"35931604", "Драгойново",
"35941114", "Лозен\,\ Ст\.\ Загора",
"3595944", "Руен\,\ Бургас",
"3596175", "Първомайци",
"3598666", "Тутракан",
"3599175", "Остров",
"35941480", "Коларово\,\ Ст\.\ Загора",
"35971587", "Голема\ Раковица",
"3593677", "Дрангово\,\ Кърдж\.",
"3593111", "Първенец\,\ Пловдив",
"3594342", "Овощник",
"3599188", "Горно\ Пещене",
"35975215", "Тешово",
"35941275", "Лясково\,\ Ст\.\ Загора",
"3595589", "Винарско",
"3599551", "Георги\ Дамяново",
"3594553", "Раково\,\ Сливен",
"3596530", "Трънчовица",
"35974321", "Хърсово\,\ Благ\.",
"3593536", "Баня\,\ Пазарджик",
"35953434", "Ясенково",
"3595137", "Калоян",
"3594771", "Маломир\,\ Ямбол",
"3593077", "Средец\,\ Смол\.",
"3594755", "Тамарино",
"3594327", "Шейново",
"3593511", "Огняново\,\ Пазарджик",
"359556", "Обзор",
"3595537", "Съдиево\,\ Бургас",
"3593136", "Розино\,\ Пловдив",
"3594153", "Мъдрец\,\ Ст\.\ Загора",
"359817", "Бяла\,\ Русе",
"35963567", "Градина\,\ Плевен",
"3596151", "Елена\,\ В\.\ Търново",
"35963568", "Буковлък",
"3599335", "Цар\ Петрово",
"3597039", "Самораново",
"35961705", "Горски\ долен\ Тръмбеш",
"3599130", "Тлачене",
"3595524", "Екзарх\ Антимово",
"3593933", "Странско",
"35974404", "Бабяк",
"3596575", "Телиш",
"3594334", "Елхово\,\ Ст\.\ Загора\,\ общ\.\ Николаево",
"3596588", "Деков",
"3596111", "Къпиново\,\ В\.\ Търново",
"3596714", "Поповци",
"3599787", "Смирненски\,\ Монт\.",
"3595772", "Телериг",
"35967390", "Шумата",
"3597532", "Буково\,\ Благ\.",
"35937602", "Черна\ могила\,\ Хаск\.",
"3593530", "Поибрене",
"3596536", "Аспарухово\,\ Плевен",
"3595738", "Спасово\,\ Добр\.",
"35977229", "Гълъбник",
"35984722", "Ясеновец",
"3594795", "Скалица",
"3595341", "Хитрино",
"3597937", "Ръждавица",
"3593773", "Капитан\ Андреево",
"3597924", "Шишковци",
"3598674", "Професор\ Иширково",
"3594715", "Калчево",
"35960458", "Веренци",
"3593175", "Дълго\ поле\,\ Пловдив",
"3598660", "Тутракан",
"3597741", "Земен",
"3594722", "Гранитово\,\ Ямбол",
"3597144", "Костенец",
"3594113", "Преславен",
"3599111", "Челопек",
"35961604", "Мирово\,\ В\.\ Търново",
"359478", "Елхово\,\ Ямбол",
"3599136", "Галиче",
"35984713", "Благоево\,\ Разград",
"3594359", "Асен\,\ Ст\.\ Загора",
"3596933", "Голец",
"3593151", "Раковски\,\ Пловдив",
"3593754", "Лозен\,\ Хаск\.",
"3593641", "Крумовград",
"3598143", "Обретеник",
"35931705", "Горна\ махала",
"3593588", "Мененкьово",
"3596591", "Горник",
"3597544", "Осина",
"3594513", "Гавраилово",
"35960375", "Гърчиново",
"3597054", "Рила",
"3594747", "Денница\,\ Ямбол",
"3597438", "Катунци",
"3594593", "Шивачево",
"3597132", "Радотина",
"3598158", "Мечка\,\ Русе",
"3596077", "Стеврек",
"3594566", "Питово",
"35971306", "Рашково",
"3598648", "Секулово",
"3596511", "Победа\,\ Плевен",
"35974325", "Лиляново",
"35930410", "Брезе\,\ Смол\.",
"35963562", "Комарево\,\ Плевен",
"3597185", "Челопеч",
"3597178", "Пролеша",
"3596136", "Сухиндол",
"3593130", "Каравелово\,\ Пловдив",
"359751", "Гоце\ Делчев",
"3595739", "Пчеларово\,\ Добр\.",
"3598667", "Белица\,\ Силистра",
"3594152", "Обручище",
"3593786", "Навъсен",
"3596035", "Паламарца",
"3593701", "Елена\,\ Хаск\.",
"3593104", "Ягодово\,\ Пловдив",
"35984392", "Белинци",
"3593524", "Априлци\,\ Пазарджик",
"3595136", "Брестак",
"3593537", "Панагюрски\ колонии",
"3597930", "Еремия",
"35971504", "Белопопци",
"35981466", "Помен",
"3595511", "Лукойл\ Нефтохим",
"3593932", "Бодрово",
"3593676", "Бенковски\,\ Кърдж\.",
"3594768", "Зимница\,\ Ямбол",
"35935393", "Смилец\,\ Пазарджик",
"35984463", "Прелез",
"35941018", "Княжевско",
"3593589", "Церово\,\ Пазарджик",
"359391", "Димитровград",
"3593137", "Клисура\,\ Пловдив",
"3597439", "Плоски",
"3596738", "Добромирка",
"3595536", "Мъглен",
"3596064", "Голямо\ Ново",
"3598692", "Стефан\ Караджа\,\ Силистра",
"35960386", "Водица\,\ Търг\.",
"35984737", "Райнино",
"35931393", "Войнягово",
"35984738", "Китанчево",
"3594358", "Скобелево\,\ Ст\.\ Загора",
"3593076", "Цацаровци",
"3595714", "Карапелит",
"3594326", "Енина",
"35963204", "Деляновци",
"3598625", "Овен",
"3594552", "Стара\ река\,\ Сливен",
"3597179", "Големо\ Малово",
"35967303", "Батошево",
"3593721", "Стамболово\,\ Хаск\.",
"35961109", "Въглевци",
"3594343", "Конаре\,\ Ст\.\ Загора",
"3593124", "Калековец",
"3599341", "Димово\,\ Видин",
"35963578", "Опанец\,\ Плевен",
"3598649", "Яребица",
"35963577", "Пелишат",
"35961402", "Стефан\ Стамболово",
"3598159", "Кошов",
"35973", "Благоевград",
"3596901", "Гложене\,\ Ловеч",
"3593691", "Черноочeне",
"3594526", "Млекарево",
"3594106", "Пъстрен",
"35931396", "Домлян",
"3598166", "Сваленик",
"3599785", "Василовци\,\ Монт\.",
"35963569", "Каменец\,\ Плевен",
"3595336", "Имренчево",
"35960383", "Берковски",
"3594797", "Гълъбинци",
"3597935", "Долно\ село",
"3596986", "Дъбен",
"3596541", "Никопол",
"35930472", "Михалково",
"3599183", "Лиляче",
"3597139", "Джурово",
"3598698", "Шуменци",
"3599541", "Доктор\ Йосифово",
"3596732", "Сенник",
"35991184", "Ракево",
"35967306", "Градище\,\ Габр\.",
"3593036", "Могилица",
"3596030", "Светлен\,\ Търг\.",
"3594717", "Чарган",
"35947193", "Могила\,\ Ямбол",
"3598113", "Ново\ село\,\ Русе",
"3593177", "Ново\ Железаре",
"3595576", "Лозарево",
"3594352", "Горно\ Черковище",
"3597711", "Кладница",
"3594143", "Сърнево\,\ Ст\.\ Загора",
"3593636", "Равен",
"3593324", "Избеглии",
"3596583", "Белене",
"3599141", "Малорад",
"3594729", "Кирилово\,\ Ямбол",
"35953222", "Марково\,\ Шумен",
"3599744", "Вълчедръм",
"3595391", "Върбица\,\ Шумен",
"3594745", "Шарково",
"35959694", "Габерово",
"35974348", "Игралище",
"3598620", "Силистра",
"3594762", "Воденичане",
"35974347", "Раздол",
"3596921", "Абланица\,\ Ловеч",
"35984729", "Езерче",
"359728", "Златица",
"35984466", "Звънарци",
"35977222", "Горна\ Диканя",
"3594158", "Искрица",
"3594126", "Хрищени",
"359971", "Лом",
"35981463", "Могилино",
"3595311", "Градище\,\ Шумен",
"35941149", "Ловец\,\ Ст\.\ Загора",
"35930459", "Бръщен",
"35931627", "Крушево\,\ Пловдив",
"3596141", "Полски\ Тръмбеш",
"359336", "Първомай\,\ Пловдив",
"3597187", "Буново\,\ София",
"3598642", "Дулово",
"3598152", "Красен\,\ Русе",
"3598665", "Искра\,\ Силистра",
"3597138", "Литаково",
"35961102", "Пчелище",
"3596176", "Поликраище",
"3599311", "Кутово",
"3597172", "Драгоман",
"35959404", "Ясеново\,\ Бургас",
"3593164", "Дълбок\ извор",
"3594710", "Болярско",
"35967395", "Горна\ Росица",
"3596024", "Руец",
"35937422", "Долни\ Главанак",
"3595141", "Старо\ Оряхово",
"359350", "Пещера\,\ Пазарджик",
"35935502", "Фотиново\,\ Пазарджик",
"3593535", "Левски\,\ Пазарджик",
"35931108", "Богданица",
"3599176", "Лесковец\,\ Враца",
"359579", "Албена",
"3598699", "Търновци\,\ Силистра",
"3593582", "Момина\ клисура",
"3597033", "Крайници",
"3593135", "Кърнаре",
"3596004", "Маково",
"35936402", "Горна\ кула",
"35960370", "Голямо\ градище",
"35969615", "Балабанско",
"35974207", "Генерал\ Тодоров",
"3598634", "Нова\ Черна",
"3594756", "Поляна\,\ Ямбол",
"35931700", "Беловица",
"3594728", "Мелница",
"3596954", "Врабево",
"35961301", "Бяла\ река\,\ В\.\ Търново",
"35984774", "Голям\ извор\,\ Разград",
"3597444", "Белица\,\ Благ\.",
"35947203", "Трънково\,\ Ямбол",
"3596576", "Радомирци",
"35930415", "Девин",
"3598627", "Бабук",
"35957306", "Изворово\,\ Добр\.",
"3593564", "Семчиново",
"3599336", "Старопатица",
"35941337", "Сърневец",
"35941338", "Целина",
"3595732", "Петлешково",
"359749", "Банско",
"35941354", "Малко\ Тръново",
"35941333", "Средно\ градище",
"3595313", "Мадара",
"35961503", "Чакали",
"3599126", "Камено\ поле",
"3596060", "Овчарово\,\ Търг\.",
"3596923", "Горан",
"3594583", "Кипилово",
"35947353", "Българска\ поляна",
"3597428", "Габрене",
"3593518", "Драгор",
"3595559", "Кубадин",
"3596143", "Масларево",
"3595710", "Победа\,\ Добр\.",
"3596074", "Любичево",
"3593349", "Боянци",
"35943616", "Турия",
"3599143", "Еница",
"3596581", "Бяла\ вода\,\ Плевен",
"3596946", "Чавдарци",
"35935255", "Росен\,\ Пазарджик",
"35969242", "Пресяка",
"3599729", "Расово",
"3598136", "Стамболово\,\ Русе",
"3597547", "Вълкосел",
"35974203", "Рупите",
"3597057", "Мало\ село",
"3597713", "Рударци",
"3594744", "Голямо\ Крушево",
"3596126", "Церова\ кория",
"3599745", "Златия\,\ Монт\.",
"3595366", "Браничево",
"3593120", "Храбрино",
"3597169", "Томпсън",
"3596158", "Средни\ колиби",
"3595393", "Иваново\,\ Шумен",
"3593757", "Георги\ Добрево",
"3593325", "Червен\,\ Пловдив",
"3597522", "Дъбница",
"3597147", "Пчелин\,\ София",
"3593198", "Чехларе",
"3597102", "Лопян",
"3596558", "Славовица\,\ Плевен",
"3596048", "Изворово\,\ Търг\.",
"3595756", "Божан",
"3597927", "Трекляно",
"35974496", "Филипово\,\ Благ\.",
"3593100", "Белащица",
"3598111", "Щръклево",
"3598677", "Сребърна",
"3593520", "Мирянци",
"359724", "Ихтиман",
"3599352", "Дружба",
"35984760", "Трапище",
"3596526", "Върбица\,\ Плевен",
"3594778", "Победа\,\ Ямбол",
"3593666", "Попско",
"35941172", "Горно\ Ботево",
"3599526", "Слатина\,\ Монт\.",
"3596352", "Долни\ Луковит",
"3599558", "Гаврил\ Геново",
"3597934", "Буново\,\ Кюст\.",
"3593693", "Лясково\,\ Кърдж\.",
"35967193", "Кметовци",
"3599784", "Киселево",
"359357", "Панагюрище",
"3599181", "Краводер",
"3596543", "Муселиево",
"3593118", "Садово\,\ Пловдив",
"3596717", "Лесичарка",
"35971220", "Гуцал",
"3594732", "Устрем",
"3595526", "Кликач",
"3593542", "Ракитово",
"3593127", "Царацово",
"3596728", "Буря",
"3593052", "Лъки\,\ Пловдив",
"35965617", "Искър\,\ Плевен",
"3595558", "Дебелт",
"3595106", "Аврен\,\ Варна",
"3593519", "Величково\,\ Пазарджик",
"3597752", "Режанци",
"3595784", "Врачанци",
"3594336", "Долно\ Изворово",
"35931605", "Буково\,\ Пловдив",
"35941115", "Борилово",
"3597445", "Баня\,\ Благ\.",
"3596955", "Дълбок\ дол",
"3597918", "Ябълково\,\ Кюст\.",
"3595717", "Ведрина",
"3596159", "Златарица",
"359860", "Силистра",
"3597168", "Бов",
"3598635", "Цар\ Самуил",
"3597031", "Горна\ Козница",
"35953435", "Изгрев\,\ Шумен",
"3593348", "Добралък",
"3595352", "Янково",
"3599728", "Сливата",
"35941274", "Самуилово\,\ Ст\.\ Загора",
"35975214", "Гайтаниново",
"3593134", "Сопот\,\ Пловдив",
"3596067", "Кралево\,\ Търг\.",
"3596710", "Донино",
"35937702", "Мустрак",
"3596049", "Камбурово",
"3595143", "Бяла\,\ Варна",
"3596559", "Гостиля",
"3593534", "Попинци",
"3595745", "Вранино",
"3596025", "Алваново",
"3595762", "Стефан\ Караджа\,\ Добр\.",
"35963576", "Тученица",
"3593119", "Гълъбово\,\ Пловдив",
"3597920", "Скриняно",
"3599313", "Капитановци",
"35974405", "Краище\,\ Благ\.",
"3598670", "Силистра",
"3593107", "Граф\ Игнатиево",
"3593165", "Караджалово",
"35960387", "Глогинка",
"35960388", "Горица\,\ Търг\.",
"3593652", "Бял\ извор\,\ Кърдж\.",
"35961704", "Правда\,\ В\.\ Търново",
"3593527", "Алеко\ Константиново",
"3595126", "Черковна\,\ Варна",
"3593142", "Брестовица\,\ Пловдив",
"3598664", "Поляна\,\ Силистра",
"3593763", "Българин",
"3594779", "Ханово",
"35984736", "Подайва",
"3595946", "Трънак",
"3593922", "Брод",
"3599559", "Горна\ Ковачица",
"3596513", "Пордим",
"3593148", "Йоаким\ Груево",
"3593658", "Падина\,\ Кърдж\.",
"35963573", "Дисевица",
"3594739", "Радовец",
"3597184", "Копривщица",
"3593626", "Перперек",
"35967307", "Млечево",
"35941110", "Старозагорски\ бани",
"35967308", "Ловнидол",
"3598630", "Силистра",
"359729", "Годеч",
"3593928", "Долно\ Белево",
"35931995", "Стрелци\,\ Пловдив",
"35941179", "Хан\ Аспарухово",
"35961304", "Димча",
"359678", "Тетевен",
"3596950", "Гумощник",
"3596359", "Глава",
"3598141", "Две\ могили",
"3594136", "Черна\ гора\,\ Ст\.\ Загора",
"3593643", "Голяма\ Чинка",
"3597545", "Кочан",
"3593153", "Стряма",
"3596931", "Угърчин",
"35984733", "Лудогорци",
"35931398", "Слатина\,\ Пловдив",
"35931397", "Христо\ Даново",
"359721", "Костинброд",
"3595768", "Одринци\,\ Добр\.",
"3596566", "Долни\ Вит",
"3593755", "Белица\,\ Хаск\.",
"3593327", "Бачково",
"3594511", "Сливенски\ минерални\ бани",
"3597117", "Градец\,\ София",
"3599513", "Бойчиновци",
"35941351", "Партизанин",
"3599747", "Мокреш\,\ Монт\.",
"3597529", "Брезница",
"35931403", "Триводици",
"35941484", "Землен",
"35984467", "Сеслав",
"3597162", "Лакатник",
"3593553", "Батак\,\ Пазарджик",
"3593043", "Змеица",
"3597145", "Мирово\,\ София",
"3597912", "Горна\ Гращица",
"3593174", "Старо\ Железаре",
"3596916", "Брестово\,\ Ловеч",
"3597129", "Радуил",
"35969249", "Дойренци",
"3599113", "Мраморен",
"3599722", "Сталийска\ махала",
"3595326", "Върбяне",
"3594714", "Дражево",
"3597743", "Дивля",
"3593342", "Нареченски\ бани",
"3596166", "Виноград",
"3597925", "Гюешево",
"3598675", "Айдемир",
"3596963", "Балканец",
"3594794", "Овчи\ кладенец",
"3593026", "Смилян",
"3595552", "Дюлево\,\ Бургас",
"3599166", "Хайредин",
"3596020", "Лиляк",
"3595740", "Горичане",
"3593548", "Пашово",
"3596113", "Балван",
"3596722", "Соколово\,\ Габр\.",
"3593058", "Мугла",
"3597726", "Дрен",
"3595343", "Венец\,\ Шумен",
"35974346", "Цапарево",
"3593567", "Ковачево\,\ Пазарджик",
"3597110", "Опицвет",
"3593929", "Голямо\ Асеново",
"3595166", "Доброплодно",
"3593320", "Орешец\,\ Пловдив",
"3599552", "Белимел",
"3596326", "Морава",
"3593125", "Ръжево\ Конаре",
"359748", "Симитли",
"3594772", "Симеоново\,\ Ямбол",
"3595916", "Росен\,\ Бургас",
"3599740", "Септемврийци\,\ Монт\.",
"3594738", "Хлябово",
"3593149", "Цалапица",
"3597447", "Добринище",
"3599343", "Гомотарци",
"3594341", "Черганово",
"3598624", "Калипетрово",
"3593112", "Марково\,\ Пловдив",
"3595715", "Попгригорово",
"3593192", "Бабек",
"3597046", "Бобошево",
"3598637", "Малък\ Преславец",
"3595769", "Хитово",
"3596957", "Голяма\ Желязна",
"35984744", "Беловец",
"359337", "Хисаря",
"3597528", "Хаджидимово",
"35991201", "Люти\ брод",
"3593746", "Сираково\,\ Хаск\.",
"3596007", "Ралица",
"3596065", "Бистра\,\ Търг\.",
"35931387", "Пролом",
"35931388", "Бегунци",
"3596552", "Долна\ Митрополия",
"3599326", "Горни\ Лом",
"35984718", "Дряновец\,\ Разград",
"3596042", "Илийно",
"35984717", "Побит\ камък\,\ Разград",
"35984765", "Веселина",
"3597156", "Равно\ поле",
"35947356", "Мрамор\,\ Ямбол",
"35957308", "Чернооково\,\ Добр\.",
"3596152", "Беброво",
"3596027", "Дралфа",
"35957307", "Житен\,\ Добр\.",
"35960453", "Моравка",
"3595747", "Ваклино",
"3595513", "Габър",
"35941336", "Яздач",
"3597415", "Селище\,\ Благ\.",
"3593105", "Манолско\ Конаре",
"3596034", "Славяново\,\ Търг\.",
"35971225", "Ново\ село\,\ София",
"3593167", "Брягово\,\ Пловдив",
"3593512", "Хаджиево",
"3593059", "Кутела",
"3597422", "Тополница\,\ Благ\.",
"3593703", "Жълти\ бряг",
"3593549", "Грашево",
"35984761", "Градина\,\ Разград",
"3599149", "Буковец\,\ Враца",
"3597742", "Калище",
"35960389", "Кардам\,\ Търг\.",
"3593343", "Козаново",
"3594124", "Змейово",
"3597719", "Ярджиловци",
"3599723", "Трайково",
"3599112", "Баница",
"3599567", "Долна\ Вереница",
"359953", "Берковица",
"3597913", "Рашка\ Гращица",
"3599320", "Стакевци",
"3593552", "Брацигово",
"3593042", "Борино",
"3598475", "Лозница\,\ Разград",
"3593019", "Писаница",
"3599125", "Горна\ Бешовица",
"35963563", "Борислав",
"3593740", "Пчелари",
"3597163", "Искрец",
"3599746", "Разград\,\ Монт\.",
"3595319", "Друмево",
"3596125", "Пушево",
"3595910", "Черни\ връх\,\ Бургас",
"35991185", "Пудрия",
"3595365", "Лятно",
"35971221", "Ярлово",
"3596567", "Сомовит",
"3596929", "Радювене",
"3597116", "Петърч",
"3593634", "Припек\,\ Кърдж\.",
"3595342", "Капитан\ Петко",
"3593326", "Патриарх\ Евтимово",
"35984712", "Костанденец",
"3596723", "Царева\ ливада",
"3596112", "Самоводене",
"3595771", "Крушари",
"3594137", "Верен",
"3597531", "Долно\ Дряново",
"359416", "Чирпан",
"35961106", "Ново\ село\,\ В\.\ Търново",
"3596149", "Куцина",
"3596962", "Черни\ Осъм",
"3598135", "Бабово",
"3595553", "Орлинци",
"3595755", "Коларци",
"3595327", "Каспичан\,\ Шумен",
"3593034", "Левочево",
"3596167", "Кесарево",
"3593768", "Доситеево",
"3596917", "Българене\,\ Ловеч",
"35971471", "Очуша",
"3593699", "Габрово\,\ Кърдж\.",
"3596909", "Малка\ Желязна",
"3596525", "Бъркач",
"3595153", "Суворово",
"3596549", "Санадиново",
"3599318", "Буковец\,\ Видин",
"3597734", "Главановци\,\ Перник",
"3595574", "Съединение\,\ Бургас",
"3596512", "Горни\ Дъбник",
"35969031", "Галата",
"3599512", "Бели\ брег",
"3598164", "Писанец",
"3594104", "Кравино",
"3594524", "Каменово\,\ Сливен",
"3599549", "Долна\ Рикса",
"3597727", "Ковачевци\,\ Перник",
"35984723", "Дянково",
"3596997", "Добревци\,\ Ловеч",
"3599525", "Долно\ Озирово",
"3595148", "Рудник\,\ Варна",
"3596984", "Бежаново\,\ Ловеч",
"3593665", "Свирачи",
"3593027", "Славейно",
"3595334", "Осмар",
"3599167", "Липница\,\ Враца",
"3593642", "Поточница",
"35937603", "Рогозиново",
"3593931", "Каснаково",
"3594335", "Ръжена",
"35961397", "Мусина",
"3596574", "Чомаковци",
"3594130", "Спасово\,\ Ст\.\ Загора",
"3596153", "Златарица",
"3597446", "Елешница\,\ Благ\.",
"35967394", "Богатово",
"3599148", "Бъркачево",
"35961403", "Орловец",
"3595525", "Деветак",
"35959405", "Зайчар",
"3595917", "Извор\,\ Бургас",
"3595167", "Венчан",
"35930200", "Загражден\,\ Смол\.",
"3593566", "Бошуля",
"35967302", "Кръвеник",
"3596560", "Крета\,\ Плевен",
"3595105", "Приселци\,\ Варна",
"3597718", "Драгичево",
"3596327", "Овча\ могила",
"3594588", "Филаретово",
"3597423", "Коларово\,\ Благ\.",
"3599560", "Безденица",
"3593702", "Царева\ поляна",
"3599327", "Чупрене",
"35981264", "Пиперково",
"3596006", "Пресиян",
"3593513", "Мало\ Конаре",
"3596148", "Павел",
"3593747", "Татарево\,\ Хаск\.",
"35930476", "Селча",
"3596956", "Ломец\,\ Ловеч",
"3595318", "Средня",
"3594754", "Каменец\,\ Ямбол",
"3597047", "Усойка",
"3596928", "Къкрина",
"3598636", "Главиница\,\ Силистра",
"35931392", "Дъбене",
"35969614", "Горно\ трапе",
"3599319", "Гъмзово",
"3596548", "Дебово",
"3593722", "Минерални\ бани\,\ Хаск\.",
"3596990", "Малък\ извор\,\ Ловеч",
"3593113", "Браниполе",
"3595746", "Белгун",
"3596026", "Макариополско",
"3599342", "Иново",
"3599160", "Гложене\,\ Враца",
"3593020", "Давидково",
"359725", "Елин\ Пелин",
"3593769", "Орешец\,\ Хаск\.",
"3594773", "Окоп",
"35977226", "Дебели\ лаг",
"35984462", "Острово",
"35935392", "Дюлево\,\ Пазарджик",
"3597157", "Саранци",
"3594551", "Бяла\,\ Сливен",
"3599553", "Превала",
"359537", "Нови\ пазар\,\ Шумен",
"3596908", "Глогово",
"3599174", "Горни\ Вадин",
"3597720", "Прибой",
"3598424", "Цар\ Калоян\,\ Разград",
"3594364", "Осетеново",
"3596553", "Оряховица\,\ Плевен",
"35951106", "Осеново\,\ Варна",
"3596043", "Долно\ Новково",
"3595149", "Голица",
"3596174", "Драганово\,\ В\.\ Търново",
"3595945", "Добромир",
"35930414", "Девин",
"3595723", "Гурково\,\ Добр\.",
"3595112", "Белослав",
"35941355", "Яворово",
"3595320", "Пет\ могили\,\ Шумен",
"3593166", "Бяла\ река\,\ Пловдив",
"359777", "Радомир",
"35984393", "Вазово",
"3599548", "Крапчене",
"3595125", "Градинарово",
"3598691", "Силистра",
"3593193", "Борец",
"3596910", "Малиново",
"3593159", "Белозем",
"3595118", "Водица\,\ Варна",
"3599353", "Кошава",
"35959400", "Дъскотна",
"3594564", "Новоселец",
"35981462", "Волово",
"3598124", "Новград",
"35930205", "Стърница",
"3594351", "Копринка",
"3595968", "Каблешково\,\ Бургас",
"3598477", "Самуил",
"3599542", "Смоляновци",
"3597103", "Брусен\,\ София",
"3599127", "Лютидол",
"3596134", "Бяла\ черква\,\ В\.\ Търново",
"3593625", "Широко\ поле",
"3597523", "Гърмен",
"35953223", "Църквица",
"3595100", "Синдел",
"3596565", "Милковица",
"3594733", "Орлов\ дол",
"3593756", "Вълче\ поле",
"3596519", "Беглеж",
"3599348", "Неговановци",
"3596542", "Въбел\,\ Плевен",
"35974401", "Горно\ Драглище",
"3593728", "Славяново\,\ Хаск\.",
"3595367", "Тодор\ Икономово",
"3599134", "Търнак",
"3595520", "Черково",
"35951125", "Константиново\,\ Варна",
"35961605", "Ново\ градище",
"3596902", "Рибарица\,\ Ловеч",
"3597056", "Мурсалево",
"3598137", "Голямо\ Враново",
"3597546", "Слащен",
"35951103", "Любен\ Каравелово",
"3594330", "Николаево\,\ Ст\.\ Загора",
"3595120", "Бозвелийско",
"3596915", "Смочан",
"35931704", "Иван\ Вазово",
"3596527", "Одърне",
"3596969", "Беклемето",
"3596142", "Обединение",
"3595325", "Войвода",
"3596119", "Дичин",
"3595757", "Безмер\,\ Добр\.",
"35961406", "Каранци",
"3593708", "Орлово\,\ Хаск\.",
"3598676", "Ветрен\,\ Силистра",
"3594582", "Градец\,\ Сливен",
"35931792", "Черничево\,\ Пловдив",
"3596165", "Асеново\,\ В\.\ Търново",
"3597926", "Коняво",
"3596922", "Лешница\,\ Ловеч",
"35941111", "Старозагорски\ бани",
"35984719", "Балкански",
"35937707", "Щит",
"3595349", "Студеница",
"35960374", "Горско\ Абланово",
"3597146", "Черньово",
"35947192", "Завой",
"3595312", "Дибич",
"3597725", "Кленовик",
"3595392", "Менгишево",
"35941350", "Мирово\,\ Ст\.\ Загора",
"359517", "Дългопол",
"3594761", "Стралджа",
"3593710", "Узунджово",
"3593049", "Беден",
"3596716", "Жълтеш",
"3593559", "Капитан\ Димитриево",
"3595518", "Рудник\,\ Бургас",
"3599119", "Тишевица",
"3597123", "Ковачевци\,\ София",
"3597712", "Батановци",
"3593025", "Баните",
"3599165", "Софрониево",
"35960382", "Ковачевец",
"3596534", "Малчика",
"35974324", "Струма",
"3599527", "Вършец",
"3593667", "Покрован",
"3599142", "Лазарово",
"3595763", "Плачидол",
"3599518", "Мърчево",
"3593581", "Белово",
"3594337", "Ясеново\,\ Ст\.\ Загора",
"35947202", "Жребино",
"3595165", "Невша",
"3593648", "Голямо\ Каменяне",
"3595119", "Игнатиево",
"3596325", "Козловец",
"3595142", "Долни\ чифлик",
"3595969", "Гълъбец\,\ Бургас",
"35993212", "Карбинци",
"3593126", "Труд",
"3595527", "Соколово\,\ Бургас",
"3595915", "Българово",
"35971505", "Чурек",
"3593745", "Малък\ извор\,\ Хаск\.",
"35937606", "Шишманово",
"3595534", "Карагеоргиево",
"35930456", "Чавдар\,\ Смол\.",
"3593923", "Радиево",
"35941146", "Християново",
"3596066", "Буйново\,\ Търг\.",
"35984726", "Ушинци",
"3593762", "Изворово\,\ Хаск\.",
"35984469", "Божурово\,\ Разград",
"3599325", "Бело\ поле\,\ Видин",
"3596518", "Рибен",
"3599349", "Сланотрън",
"3593143", "Перущица",
"35991180", "Лесура",
"3595716", "Паскалево",
"3598641", "Окорш",
"3594324", "Шипка",
"3597045", "Голем\ Върбовник",
"3593074", "Ерма\ река",
"3598151", "Просена",
"3593653", "Млечино",
"35969247", "Гостиня",
"35969248", "Скобелево\,\ Ловеч",
"3593729", "Криво\ поле",
"3599312", "Брегово\,\ Видин",
"3595348", "Трем",
"3595599", "Хаджиите",
"35963566", "Бръшляница",
"3599520", "Горно\ Озирово",
"3595731", "Генерал\ Тошево\,\ Добр\.",
"3595134", "Червенци",
"35937423", "Големанци",
"3597753", "Ноевци",
"3596968", "Добродан",
"3593543", "Дорково",
"35971302", "Боженица",
"3593709", "Караманци",
"3593674", "Самодива",
"3593053", "Хвойна",
"3593717", "Конуш\,\ Хаск\.",
"3596118", "Вонеща\ вода",
"3597155", "Лесново",
"3593784", "Константиново\,\ Хаск\.",
"35967309", "Агатово",
"3595947", "Просеник",
"3595353", "Веселиново\,\ Шумен",
"35961103", "Русаля",
"35963205", "Червена",
"35935251", "Братаница",
"3596520", "Николаево\,\ Плевен",
"3595127", "Манастир\,\ Варна",
"35941178", "Оряховица\,\ Ст\.\ Загора",
"3593526", "Динката",
"3593106", "Строево",
"3595519", "Зидарово",
"3593558", "Исперихово",
"3595750", "Каблешково\,\ Добр\.",};
$areanames{en} = {"3595726", "Tsarichino",
"3596528", "Valchitran",
"3593707", "Nikolovo\,\ Hask\.",
"3599322", "Oreshets\,\ Vidin",
"3596556", "Gorna\ Mitropolia",
"3595758", "Kladentsi",
"3596046", "Vrani\ kon",
"3593719", "Knizhovnik",
"3593040", "Trigrad",
"3593765", "Ivanovo\,\ Hask\.",
"35963565", "Mechka\,\ Pleven",
"3599110", "Virovsko",
"35974322", "Petrovo\,\ Blag\.",
"35960451", "Obitel",
"3597042", "Korkina",
"35960384", "Gagovo",
"3593196", "Drangovo\,\ Plovdiv",
"35992", "Vratsa",
"3599315", "Gradets\,\ Vidin",
"3593163", "Iskra\,\ Plovdiv",
"3598661", "Tutrakan",
"35962", "Veliko\ Tarnovo",
"3595129", "Blaskovo",
"3596023", "Podgoritsa",
"3596960", "Belish",
"35991183", "Furen",
"3595517", "Ravnets\,\ Burgas",
"35931702", "Dolna\ mahala\,\ Plovdiv",
"3595743", "Shabla",
"3593116", "Krumovo\,\ Plovdiv",
"3596322", "Alekovo\,\ V\.\ Tarnovo",
"3599556", "Govezhda",
"3595162", "Belogradets",
"3595949", "Planinitsa\,\ Burgas",
"3595340", "Visoka\ polyana\,\ Shumen",
"3595912", "Polski\ izvor",
"35960372", "Krepcha",
"3599528", "Gaganitsa",
"3595145", "Grozdyovo",
"35941277", "Zagore",
"3596003", "Preselets",
"3593516", "Tsrancha\,\ Pazardzhik",
"3595117", "Botevo\,\ Varna",
"35951536", "Nikolaevka",
"3597034", "Dzherman",
"3596510", "Totleben",
"3597426", "Marikostinovo",
"3595967", "Bata",
"3595529", "Krushovo\,\ Burgas",
"35937420", "Podkrepa",
"3599128", "Eliseyna",
"35961203", "Emen",
"3598633", "Staro\ selo\,\ Silistra",
"3594339", "Yulievo",
"3596953", "Borima",
"3599347", "Bela\ Rada",
"3596156", "Rodina",
"3593727", "Nova\ Nadezhda",
"35991203", "Lik",
"3596128", "Hotnitsa",
"35981464", "Ostritsa\,\ Ruse",
"3595368", "Takach",
"3593563", "Varvara\,\ Pazardzhik",
"35941145", "Arnautito",
"3598138", "Brashlen",
"35971506", "Gabra",
"3597152", "Gorna\ Malina",
"3596590", "Rakita\,\ Pleven",
"359938", "Kula",
"35984725", "Kichenitsa",
"3595781", "Svoboda\,\ Dobr\.",
"3596948", "Karpachevo",
"3598187", "Tetovo",
"35935418", "Krastava",
"3595347", "Zhivkovo\,\ Shumen",
"35930517", "Zabardo",
"35967399", "Malki\ Varshets",
"3598194", "Sandrovo",
"3596562", "Gigen",
"3596545", "Lyubenovo\,\ Pleven",
"3596529", "Koilovtsi",
"3596967", "Kaleytsa",
"3593695", "Komuniga",
"3596905", "Divchovoto",
"3594132", "Orizovo",
"35959403", "Rechitsa",
"3599184", "Ohoden",
"359538", "Veliki\ Preslav",
"3593718", "Voyvodovo\,\ Hask\.",
"3595759", "Kochmar",
"359865", "Silistra",
"3596117", "Debelets\,\ V\.\ Tarnovo",
"35961405", "Petko\ Karavelovo",
"35984", "Razgrad",
"359308", "Madan\,\ Smol\.",
"35931309", "Kliment\,\ Plovdiv",
"3595948", "Snyagovo\,\ Burgas",
"3595590", "Zhitosvyat",
"3599117", "Krivodol",
"3599529", "Borovtsi",
"35931324", "Mrachenik",
"35971304", "Lipnitsa\,\ Sofia",
"35967774", "Belitsa\,\ Gabr\.",
"3595128", "Zhitnitsa\,\ Varna",
"3599545", "Gabrovnitsa",
"35953220", "Pamukchii\,\ Shumen",
"3593557", "Byaga",
"3593700", "Trakiets",
"3593622", "Stremtsi",
"3598114", "Pirgovo",
"35963571", "Brestovets",
"3594144", "Kovachevo\,\ St\.\ Zagora",
"3595395", "Chernookovo\,\ Shumen",
"3593323", "Bolyartsi\,\ Plovdiv",
"3599129", "Sinyo\ bardo",
"3594741", "Bolyarovo",
"3599517", "Kobilyak",
"3596584", "Belene",
"3594338", "Kran",
"3593647", "Chernichevo\,\ Kardzh\.",
"3599162", "Mihaylovo\,\ Vratsa",
"3599340", "Septemvriytsi\,\ Vidin",
"3597715", "Studena\,\ Pernik",
"3593022", "Vievo",
"3593157", "Bolyarino",
"3595108", "Sadovo\,\ Varna",
"3595556", "Golyamo\ Bukovo",
"3595528", "Nevestino\,\ Burgas",
"3599145", "Brenitsa\,\ Vratsa",
"3596726", "Skalsko",
"3596992", "Zlatna\ Panega",
"3593720", "Madzharovo",
"3596145", "Strahilovo",
"3599726", "Zamfir",
"35947204", "Pchela",
"359707", "Sapareva\ banya",
"3596912", "Bahovitsa",
"35961606", "Vladislav",
"3594585", "Zheravna",
"3593346", "Muldava",
"3596517", "Podem",
"3596071", "Antonovo",
"3596925", "Vladinya",
"3597166", "Vlado\ Trichkov",
"35930419", "Yagodina",
"3597916", "Bagrentsi",
"35931401", "Kadievo",
"3597193", "Golesh\,\ Sofia",
"3596129", "Gabrovtsi",
"35941353", "Plodovitovo",
"3595315", "Tsarev\ brod",
"35952", "Varna",
"3593705", "Vaglarovo",
"3595328", "Nikola\ Kozlevo",
"3597159", "Aprilovo\,\ Sofia",
"359373", "Harmanli",
"35984776", "Harsovo\,\ Razgrad",
"3596168", "Sushitsa\,\ V\.\ Tarnovo",
"3593767", "Branitsa",
"35971338", "Osikovska\ Lakavitsa",
"3596918", "Drenov",
"3599540", "Belotintsi",
"35971337", "Kalugerovo\,\ Sofia",
"3593103", "Milevo",
"3599317", "Archar",
"3593523", "Sinitevo",
"3594332", "Vetren\,\ St\.\ Zagora",
"3595515", "Kameno",
"35941356", "Rupkite",
"3597728", "Drugan",
"3596900", "Vasilyovo",
"35957304", "Dabovik",
"359518", "Provadia",
"3596998", "Golyam\ izvor\,\ Lovech",
"3596540", "Asenovo\,\ Pleven",
"3595522", "Iskra\,\ Burgas",
"3593056", "Chepintsi\,\ Smol\.",
"3595147", "Pchelnik\,\ Varna",
"3593028", "Arda",
"3595102", "Padina\,\ Varna",
"35961603", "Lozen\,\ V\.\ Tarnovo",
"3599168", "Butan",
"359558", "Aytos",
"3595310", "Radko\ Dimitrievo",
"35959406", "Razboyna\,\ Burgas",
"3595919", "Marinka",
"3596329", "Tsarevets\,\ V\.\ Tarnovo",
"3595115", "General\ Kantardzhievo",
"3596920", "Lesidren",
"3593926", "Dobrich\,\ Hask\.",
"3596063", "Bayachevo",
"3595942", "Lyulyakovo\,\ Burgas",
"3595169", "Momchilovo",
"35931709", "Mihiltsi",
"3593628", "Miladinovo",
"3599568", "Blagovo\,\ Mont\.",
"3594580", "Borintsi",
"359431", "Kazanlak",
"3593146", "Kurtovo\ Konare",
"3595713", "Stefanovo\,\ Dobr\.",
"3595122", "Slaveykovo\,\ Varna",
"3593725", "Stamboliyski\,\ Hask\.",
"359697", "Lukovit",
"3599140", "Gabare",
"35930256", "Galabovo\,\ Smol\.",
"3595766", "Metodievo\,\ Dobr\.",
"35995276", "Draganitsa",
"3596568", "Dabovan",
"35984269", "Nedoklan",
"3599345", "Vinarovo\,\ Vidin",
"3593712", "Malevo\,\ Hask\.",
"3598621", "Silistra",
"3594344", "Shanovo",
"3593123", "Kaloyanovo\,\ Plovdiv",
"3599329", "Rabisha",
"35930475", "Stomanevo",
"3594138", "Gita",
"3593749", "Garvanovo",
"3595362", "Kliment\,\ Shumen",
"3595140", "Shkorpilovtsi",
"3596713", "Vranilovtsi",
"3596122", "Belyakovets",
"3596547", "Dragash\ voyvoda",
"35963560", "Radishevo",
"35930412", "Devin",
"3598185", "Senovo",
"3595345", "Razvigorovo",
"35944", "Sliven",
"3596942", "Aleksandrovo\,\ Lovech",
"3596169", "Blagoevo\,\ V\.\ Tarnovo",
"3597158", "Doganovo",
"3596115", "Resen",
"3595329", "Mirovtsi",
"3598132", "Yudelnik",
"3596965", "Beli\ Osam",
"3597126", "Gorni\ Okol",
"35991888", "Veslets\,\ Vratsa",
"3596919", "Slatina\,\ Lovech",
"3596907", "Gradezhnitsa",
"3597745", "Egalnitsa",
"3598673", "Alfatar",
"3593774", "Levka",
"3597923", "Vrattsa",
"3599169", "Rogozen",
"35971503", "Dolno\ Kamartsi",
"3599115", "Chiren",
"35969612", "Terziysko\,\ Lovech",
"3593029", "Petkovo\,\ Smol\.",
"3593045", "Dospat",
"3597143", "Vakarel",
"3593555", "Nova\ mahala\,\ Pazardzhik",
"3594711", "Bezmer\,\ Yambol",
"3599122", "Zverino",
"35984464", "Veselets\,\ Razgrad",
"35935394", "Oborishte\,\ Pazardzhik",
"3599547", "Vinishte",
"3597729", "Dolna\ Dikanya",
"3596934", "Katunets",
"3599515", "Madan\,\ Mont\.",
"35941331", "Granit",
"35981262", "Bistrentsi",
"3599569", "Lipen",
"3593629", "Most",
"3594736", "Svetlina",
"3598144", "Batishnitsa",
"3593753", "Oryahovo\,\ Hask\.",
"3595397", "Metodievo\,\ Shumen",
"3599147", "Borovan",
"3593662", "Zhelezino",
"35931394", "Vasil\ Levski\,\ Plovdiv",
"3599522", "Kotenovtsi",
"3595918", "Rusokastro",
"35981886", "Chereshovo\,\ Ruse",
"3593645", "Avren\,\ Kardzh\.",
"3595168", "Petrov\ dol\,\ Varna",
"3593155", "Momino\ selo",
"3597053", "Kocherinovo",
"3597717", "Divotino",
"3596328", "Oresh",
"3594514", "Krushare",
"3594587", "Yablanovo",
"3597181", "Pirdop",
"3599328", "Dolni\ Lom",
"35963203", "Hadzhidimitrovo\,\ V\.\ Tarnovo",
"35961308", "Vishovgrad",
"3595752", "Nova\ Kamena",
"35961307", "Stambolovo\,\ V\.\ Tarnovo",
"3596147", "Ivancha\,\ V\.\ Tarnovo",
"3593748", "Lyaskovets\,\ Hask\.",
"35974201", "Kapatovo",
"35961105", "Prisovo",
"3599356", "Kalenik\,\ Vidin",
"35984720", "Topchii",
"3596522", "Zgalevo",
"3594139", "Svoboda\,\ St\.\ Zagora",
"35967304", "Kramolin",
"359618", "Gorna\ Oryahovitsa",
"35991186", "Baurene",
"3597526", "Ribnovo",
"3595317", "Ivanski",
"3597048", "Blazhievo",
"359454", "Tvarditsa\,\ Sliven",
"3596515", "Slavyanovo\,\ Pleven",
"3597106", "Yamna",
"35967392", "Yavorets",
"3596569", "Lenkovo",
"3596927", "Umarevtsi",
"35935501", "Ravnogor",
"3595123", "Ravna\,\ Varna",
"3596029", "Nadarevo",
"3595712", "Stozher",
"3593195", "Rozovets",
"35941335", "Mogilovo",
"3595749", "Krapets\,\ Dobr\.",
"3599316", "Novo\ selo\,\ Vidin",
"35937421", "Dolno\ pole",
"3595943", "Vresovo",
"3596062", "Strazha\,\ Targ\.",
"35930418", "Buynovo\,\ Smol\.",
"3598694", "Zebil",
"35930417", "Grohotno",
"3596555", "Baykal",
"3593766", "Biser",
"35984766", "Kamenar\,\ Razgrad",
"35961101", "Velchevo\,\ V\.\ Tarnovo",
"3599555", "Kopilovtsi\,\ Mont\.",
"3594775", "Karavelovo\,\ Yambol",
"35965165", "Pisarovo\,\ Pleven",
"3593122", "Manole",
"3595146", "Goren\ chiflik",
"3593057", "Plovdivtsi",
"3593713", "Dinevo",
"3593547", "Sarnitsa\,\ Pazardzhik",
"3599171", "Oryahovo\,\ Vratsa",
"3597120", "Dolna\ banya",
"3595958", "Gramatikovo",
"3594361", "Pavel\ banya",
"3593115", "Kuklen",
"3594554", "Trapoklovo",
"3593147", "Novo\ selo\,\ Plovdiv",
"3593522", "Gelemenovo",
"3593657", "Zhaltusha",
"35931308", "Bogdan\,\ Plovdiv",
"35960450", "Dolna\ Hubavka",
"3593102", "Karadzhovo",
"3594154", "Mednikarovo",
"3594751", "Voynika",
"3593515", "Kalugerovo\,\ Pazardzhik",
"3593569", "Karabunar",
"35981268", "Krivina\,\ Ruse",
"3593927", "Chernogorovo\,\ Hask\.",
"359318", "Saedinenie\,\ Plovdiv",
"3597520", "Kornitsa",
"3597425", "Kulata",
"3596571", "Lepitsa",
"3594730", "Knyazhevo",
"3595523", "Krumovo\ gradishte",
"3593934", "Skobelevo\,\ Hask\.",
"35967397", "Ryahovtsite",
"35936401", "Strandzhevo",
"35974388", "Gorno\ Spanchevo",
"35935419", "Sveta\ Petka",
"35967398", "Damyanovo",
"3595767", "Zhitnitsa\,\ Dobr\.",
"3598639", "Kolarovo\,\ Silistra",
"3593328", "Dolnoslav",
"3597118", "Dragovishtitsa\,\ Sofia",
"3596155", "Konstantin",
"35961302", "Batak\,\ V\.\ Tarnovo",
"3599748", "Dalgodeltsi",
"35961394", "Daskot",
"3596959", "Debnevo",
"3594333", "Dabovo\,\ St\.\ Zagora",
"3597052", "Pastra",
"3597127", "Shiroki\ dol",
"3596906", "Cherni\ Vit",
"3593696", "Pchelarovo\,\ Kardzh\.",
"3598161", "Vetovo",
"3599523", "Barzia",
"3594101", "Opan",
"3593752", "Malko\ gradishte",
"3596028", "Vardun",
"35931603", "Vinitsa",
"359973", "Kozloduy",
"35941113", "Pryaporets\,\ St\.\ Zagora",
"359722", "Samokov",
"3593050", "Bukova\ polyana",
"3596546", "Lozitsa\,\ Pleven",
"35963570", "Staroseltsi",
"3595748", "Durankulak",
"3596981", "Petrevene",
"3595959", "Zvezdets",
"3599546", "Slavotin",
"3593168", "Ezerovo\,\ Plovdiv",
"35941279", "Strelets\,\ St\.\ Zagora",
"3596523", "Krushovitsa\,\ Pleven",
"35984730", "Golyam\ Porovets",
"35955505", "Drachevo",
"3595753", "Orlyak",
"3595571", "Sungurlare",
"3597731", "Tran",
"3597134", "Vrachesh",
"35936702", "Gorski\ izvor\,\ Kardzh\.",
"3593568", "Vinogradets",
"3598133", "Ryahovo",
"3593631", "Momchilgrad",
"3595555", "Fakia",
"3595760", "Bozhurovo\,\ Dobr\.",
"3596725", "Gostilitsa",
"3599146", "Sokolare",
"35977221", "Kondofrey",
"3596943", "Gorsko\ Slivovo",
"35931996", "Svezhen",
"3595774", "Koriten",
"3594737", "Sinapovo",
"3595396", "Lovets\,\ Shumen",
"3597448", "Bachevo",
"35946", "Yambol",
"3596123", "Bukovets\,\ V\.\ Tarnovo",
"3596712", "Gabene",
"35971798", "Vasilovtsi\,Sof\.",
"3595363", "Gusla",
"3599123", "Roman",
"3593920", "Zlatopole",
"3597119", "Dramsha",
"3598638", "Bogdantsi\,\ Silistra",
"3597165", "Milanovo\,\ Sofia",
"3596926", "Gorno\ Pavlikene",
"35953221", "Stoyan\ Mihaylovski",
"3597915", "Nevestino\,\ Kyust\.",
"3596958", "Apriltsi\,\ Lovech",
"3597142", "Kostenets",
"3595316", "Salmanovo",
"3594724", "Razdel\,\ Yambol",
"3594121", "Lyulyak",
"35974403", "Dolno\ Draglishte",
"3599749", "Cherni\ vrah\,\ Mont\.",
"3597527", "Gorno\ Dryanovo",
"3599725", "Komoshtitsa",
"3596146", "Polski\ Senovets",
"359720", "Etropole",
"3598672", "Bradvari",
"3597922", "Dragovishtitsa\,\ Kyust\.",
"3594586", "Neykovo\,\ Sliven",
"3593345", "Lyaskovo\,\ Plovdiv",
"3597148", "Muhovo",
"3596952", "Oreshak\,\ Lovech",
"3593781", "Simeonovgrad",
"3598632", "Zafirovo",
"359608", "Popovo\,\ Targ\.",
"35961309", "Gorsko\ Kalugerovo",
"35941174", "Podslon\,\ St\.\ Zagora",
"35963575", "Bohot",
"3593197", "Tyurkmen",
"3596047", "Zelena\ morava",
"3593706", "Tankovo\,\ Hask\.",
"3596557", "Bregare",
"35931993", "Sarnegor",
"35931620", "Dobri\ dol\,\ Plovdiv",
"3598678", "Sratsimir\,\ Silistra",
"3597928", "Garlyano",
"3596002", "Saedinenie\,\ Targ\.",
"3595727", "Senokos\,\ Dobr\.",
"35984735", "Sveshtari",
"3595734", "Preselentsi",
"3595131", "Valchi\ dol",
"3594777", "Tenevo",
"3593055", "Elhovets",
"3593545", "Draginovo",
"3599557", "Gorno\ Tserovene",
"35941489", "Bozduganovo",
"35971398", "Osikovitsa",
"3593562", "Slavovitsa\,\ Pazardzhik",
"3593671", "Podkova",
"3593117", "Katunitsa",
"3597755", "Velkovtsi\,\ Pernik",
"3596718", "Draganovtsi",
"35974406", "Dobarsko",
"3595516", "Indzhe\ voyvoda",
"3593109", "Lilkovo",
"3593529", "Mokrishte",
"3597442", "Yakoruda",
"3593340", "Novi\ izvor",
"3593162", "Gradina\,\ Plovdiv",
"35969244", "Tepava",
"3593145", "Krichim",
"3597043", "Golemo\ selo",
"3599720", "Kovachitsa",
"35941116", "Sladak\ Kladenets",
"35931606", "Voden\,\ Plovdiv",
"3597174", "Kalotina",
"3599323", "Drenovets",
"3593129", "Skutare",
"3597910", "Bersin",
"3597427", "Parvomay\,\ Blag\.",
"3595116", "Krumovo\,\ Varna",
"3593743", "Silen",
"3598644", "Chernolik",
"3594321", "Maglizh",
"3593517", "Lesichovo",
"359677", "Tryavna",
"3593071", "Zlatograd",
"3593925", "Krum",
"35953436", "Chernoglavtsi",
"3593584", "Vetren\,\ Pazardzhik",
"3595913", "Krushevets",
"3597434", "Strumyani",
"3596069", "Vasil\ Levski\,\ Targ\.",
"3595163", "Mlada\ gvardia",
"3596323", "Balgarsko\ slivovo",
"3597058", "Stob",
"35991401", "Vranyak",
"3597548", "Godeshevo",
"3595742", "Rakovski\,\ Dobr\.",
"3593726", "Klokotnitsa",
"3596720", "Kereka",
"3595765", "Lovchantsi",
"3595719", "Donchevo",
"359861", "Silistra",
"3596157", "Slivovitsa",
"3596022", "Probuda\,\ Targ\.",
"3593758", "Yerusalimovo",
"3599346", "Sinagovtsi",
"3594764", "Malenovo",
"35974327", "Novo\ Delchevo",
"3593110", "Popovitsa",
"3597929", "Sovolyano",
"35974495", "Yurukovo",
"3598679", "Kaynardzha",
"3596116", "Golemanite",
"3596966", "Shipkovo",
"3597125", "Govedartsi",
"35932", "Plovdiv",
"3593023", "Momchilovtsi",
"3599163", "Harlets",
"3596531", "Izgrev\,\ Pleven",
"3599742", "Yakimovo",
"3594770", "General\ Inzovo",
"3597149", "Zhivkovo\,\ Sofia",
"3597723", "Dolni\ Rakovets",
"3593322", "Zlatovrah",
"3595346", "Kamenyak\,\ Shumen",
"3599719", "Asparuhovo\,\ Mont\.",
"35941330", "Tsenovo\,\ St\.\ Zagora",
"3599550", "Mitrovtsi",
"3593556", "Radilovo",
"3593108", "Boykovo",
"3593046", "Barutin",
"3597192", "Gintsi",
"3596550", "Stavertsi",
"35937704", "Mladinovo",
"35960378", "Tsar\ Asen\,\ Targ\.",
"35960377", "Aprilovo\,\ Targ\.",
"3593528", "Govedare",
"3595323", "Pliska",
"3596163", "Kamen\,\ V\.\ Tarnovo",
"35984721", "Lipnik",
"35984749", "Sevar",
"3596913", "Slavyani",
"3593190", "Varben\,\ Plovdiv",
"35931708", "Pesnopoy\,\ Plovdiv",
"3599116", "Kostelevo",
"35931707", "Chernozemen",
"3593128", "Zlatitrap",
"3596727", "Ganchovets",
"35984763", "Beli\ Lom",
"3599131", "Dobrolevo",
"3596150", "Zlataritsa",
"359747", "Razlog",
"3593646", "Tokachka",
"3595557", "Bistrets\,\ Burgas",
"3593156", "Shishmantsi",
"3599516", "Lehchevo",
"3595952", "Malko\ Tarnovo",
"3596563", "Brest\,\ Pleven",
"35963561", "Grivitsa",
"359470", "Topolovgrad",
"3593623", "Boyno",
"3597917", "Tavalichevo",
"3594354", "Zimnitsa\,\ St\.\ Zagora",
"3597525", "Banichan",
"3596516", "Iskar\,\ Pleven",
"3597105", "Malki\ Iskar",
"3593759", "Borislavtsi",
"3595718", "Smolnitsa",
"3597167", "Tserovo\,\ Sofia",
"3593510", "Ovchepoltsi",
"35935256", "Sbor\,\ Pazardzhik",
"3593347", "Lenovo",
"359726", "Svoge",
"3599727", "Medkovets",
"3597549", "Dolen\,\ Blag\.",
"3599355", "Kosovo\,\ Vidin",
"3596068", "Bozhurka",
"3596734", "Petko\ Slaveykov",
"3596321", "Gorna\ Studena",
"35991202", "Kunino",
"3595161", "Vetrino",
"3595764", "Vladimirovo\,\ Dobr\.",
"3593532", "Strelcha",
"3597435", "Sklave",
"3593585", "Akandzhievo",
"35969616", "Staro\ selo\,\ Lovech",
"35971227", "Beli\ Iskar",
"3593937", "Yabalkovo\,\ Hask\.",
"3594346", "Golyamo\ Dryanovo",
"35971228", "Maritsa",
"3595533", "Pirne",
"3593924", "Krepost",
"35957305", "Rositsa\,\ Dobr\.",
"3594157", "Razdelna\,\ St\.\ Zagora",
"3598645", "Mezhden",
"3597041", "Shatrovo",
"3598662", "Dobrotitsa\,\ Silistra",
"35930416", "Gyovren",
"3593073", "Startsevo",
"3597175", "Gaber",
"3594323", "Tulovo",
"3593741", "Mandra",
"35951104", "Dolishte\,\ Varna",
"3598629", "Smilets\,\ Silistra",
"35984768", "Sinya\ voda",
"3597188", "Petrich\,\ Sofia",
"35931703", "Zhitnitsa\,\ Plovdiv",
"35991182", "Osen\,\ Vratsa",
"359359", "Velingrad",
"3597754", "Kosharevo",
"35967396", "Berievo",
"35974386", "Pirin",
"3594557", "Bikovo",
"3595133", "General\ Kolevo\,\ Varna",
"3596039", "Opaka",
"3595782", "Benkovski\,\ Dobr\.",
"35960373", "Posabina",
"3594798", "Savino",
"359570", "Kavarna",
"3593054", "Podvis\,\ Smol\.",
"3593544", "Kostandovo",
"3593673", "Tihomir",
"3595735", "Krasen\,\ Dobr\.",
"3598697", "Sokol\,\ Silistra",
"359915", "Byala\ Slatina",
"3595354", "Rish",
"3593132", "Banya\,\ Plovdiv",
"3593783", "Svirkovo",
"3594718", "Roza",
"35981266", "Starmen\,\ Ruse",
"3593178", "Krasnovo",
"35974323", "Lozenitsa",
"3598431", "Isperih",
"3599354", "Antimovo\,\ Vidin",
"359670", "Troyan\,\ Lovech",
"3599561", "Sumer",
"35951539", "Levski\,\ Varna",
"3598123", "Bosilkovtsi",
"35960380", "Drinovo",
"3596133", "Mihaltsi",
"35941352", "Vinarovo\,\ St\.\ Zagora",
"3597104", "Laga",
"3594727", "Malak\ manastir",
"3594355", "Buzovgrad",
"3597524", "Ablanitsa\,\ Blag\.",
"3594734", "Srem",
"3597189", "Chavdar\,\ Sofia",
"3599133", "Komarevo\,\ Vratsa",
"3599782", "Bukovets\,\ Mont\.",
"3598628", "Tsar\ Asen\,\ Silistra",
"3597932", "Shipochano",
"35984465", "Savin",
"3594516", "Kermen",
"35930528", "Manastir\,\ Plovdiv",
"3596561", "Gulyantsi",
"35961391", "Slomer",
"3594799", "Golyam\ manastir",
"3596072", "Dobrotitsa\,\ Targ\.",
"3593776", "Raykova\ mogila",
"3597137", "Skravena",
"35937424", "Kozlets",
"3596770", "Plachkovtsi",
"359723", "Botevgrad",
"3596911", "Lisets\,\ Lovech",
"3598690", "Silistra",
"3596161", "Strazhitsa\,\ V\.\ Tarnovo",
"3595321", "Praventsi",
"35931395", "Iganovo",
"3594116", "Rakitnitsa\,\ St\.\ Zagora",
"3599161", "Mizia",
"35961104", "Vodoley",
"35931997", "Zlatosel",
"35931998", "Choba",
"3596991", "Yablanitsa",
"3597124", "Belchinski\ bani",
"3594742", "Stefan\ Karadzhovo",
"3596533", "Stezherovo",
"35967305", "Stokite",
"3595521", "Venets\,\ Burgas",
"3595101", "Dabravino",
"3596154", "Buynovtsi",
"3596573", "Koynare",
"35974408", "Obidim",
"3594331", "Gurkovo\,\ St\.\ Zagora",
"3593587", "Sestrimo",
"35974407", "Kremen\,\ Blag\.",
"3592", "Sofia",
"3593935", "Varbitsa\,\ Hask\.",
"35960385", "Lomtsi",
"3594748", "Voden\,\ Yambol",
"359746", "Sandanski",
"35963564", "Bivolare",
"3597437", "Melnik",
"3599333", "Boynitsa",
"3597424", "Karnalovo",
"359727", "Slivnitsa\,\ Sofia",
"3594350", "Gorno\ Izvorovo",
"3597036", "Balanovo",
"3594155", "Glavan\,\ St\.\ Zagora",
"3593514", "Chernogorovo\,\ Pazardzhik",
"3598647", "Paisievo",
"359868", "Silistra",
"3596032", "Zaraevo",
"35991189", "Tri\ kladentsi",
"35993342", "Kireevo",
"3597177", "Aldomirovtsi",
"3594753", "Zornitsa\,\ Yambol",
"3593114", "Brestnik",
"3593711", "Dolno\ Botevo",
"3598622", "Alekovo\,\ Silistra",
"35953437", "Gabritsa\,\ Shumen",
"359601", "Targovishte",
"35951429", "Solnik",
"35931390", "Moskovets",
"35956", "Burgas",
"35961602", "Tsarski\ izvor",
"3598669", "Garvan\,\ Silistra",
"35991668", "Manastirishte",
"3595737", "Lyulyakovo\,\ Dobr\.",
"3594774", "Krumovo\,\ Yambol",
"3594363", "Gabarevo",
"3599173", "Galovo",
"3597938", "Dolno\ Uyno",
"3599554", "Chiprovtsi",
"35934", "Pazardzhik",
"3596173", "Dolna\ Oryahovitsa",
"3596044", "Dolno\ Kozarevo",
"35981465", "Batin",
"3596554", "Krushovene",
"35941118", "Ostra\ mogila\,\ St\.\ Zagora",
"3598695", "Nozharevo",
"3595121", "Tutrakantsi",
"3595724", "Dropla\,\ Dobr\.",
"35941117", "Kazanka",
"35937701", "Sladun",
"35958", "Dobrich",
"3593194", "Zelenikovo\,\ Plovdiv",
"35937604", "Varbovo\,\ Hask\.",
"3595941", "Skalak\,\ Burgas",
"35941144", "Kaloyanovets",
"3594712", "Kabile",
"3593344", "Novakovo\,\ Plovdiv",
"3594123", "Bogomilovo",
"35969241", "Yoglav",
"35963202", "Dragomirovo\,\ V\.\ Tarnovo",
"359676", "Dryanovo\,\ Gabr\.",
"3593138", "Vedrare",
"35959409", "Cheresha",
"3596737", "Krushevo\,\ Gabr\.",
"3599724", "Stanevo",
"35960376", "Lyublen",
"3594749", "Ruzhitsa\,\ Yambol",
"35966", "Gabrovo",
"3599121", "Tsarevets\,\ Vratsa",
"3594725", "Lesovo",
"3594357", "Gorno\ Sahrane",
"35967393", "Dushevo",
"3597914", "Vaksevo",
"35931706", "Suhozem",
"3597164", "Rebrovo",
"3598640", "Pravda\,\ Silistra",
"359339", "Stamboliyski\,\ Plovdiv",
"3598150", "Semerdzhievo",
"3596941", "Letnitsa",
"3596586", "Belene",
"35984266", "Prostorno",
"359331", "Asenovgrad",
"3597430", "Damyanitsa",
"359750", "Borovets\,\ Sofia",
"3593633", "Rogozche",
"3594146", "Dinya",
"3598131", "Borisovo\,\ Ruse",
"3595775", "Polkovnik\ Dyakovo",
"3595361", "Kaolinovo",
"35968", "Lovech",
"3596724", "Yantra\,\ Gabr\.",
"35996", "Montana",
"3596121", "Nikyup",
"3595554", "Momina\ tsarkva",
"35931258", "Glavatar",
"3594792", "Botevo\,\ Yambol",
"35969613", "Chiflik\,\ Lovech",
"35971502", "Eleshnitsa\,\ Sofia",
"3597135", "Trudovets",
"3598668", "Popina",
"3597939", "Tsarvaritsa",
"35941171", "Dalboki",
"35984779", "Zdravets\,\ Razgrad",
"3598116", "Ivanovo\,\ Ruse",
"3597733", "Filipovtsi",
"3595573", "Vezenkovo",
"3597182", "Mirkovo",
"3595751", "Tervel\,\ Dobr\.",
"35935258", "Tsar\ Asen\,\ Pazardzhik",
"35935257", "Saraya",
"3596521", "Sadovets",
"35984710", "Osenets",
"3594103", "Byal\ izvor\,\ St\.\ Zagora",
"3599521", "Zamfirovo",
"3593661", "Ivaylovgrad",
"3598163", "Bazan",
"3593538", "Elshitsa",
"35930413", "Devin",
"3598196", "Nisovo",
"35941359", "Izvorovo\,\ St\.\ Zagora",
"3594523", "Stoil\ voyvoda",
"3596983", "Dermantsi",
"3599186", "Zgorigrad",
"3595333", "Han\ Krum",
"35984394", "Duhovets",
"3595539", "Chernograd",
"3594140", "Polski\ Gradets",
"3594362", "Manolovo",
"3599172", "Selanovtsi",
"35963574", "Todorovo\,\ Pleven",
"3597436", "Levunovo",
"35941175", "Kolena",
"3593586", "Borimechkovo",
"3596580", "Tatari",
"3594345", "Raduntsi",
"359631", "Svishtov",
"3599344", "Vrav",
"3594329", "Dolno\ Sahrane",
"3593079", "Kozarka",
"35954", "Shumen",
"35938", "Haskovo",
"3599138", "Altimir",
"35961303", "Gorna\ Lipnitsa",
"3593724", "Susam",
"3593121", "Rogosh",
"3598623", "Golesh\,\ Silistra",
"3597176", "Hrabarsko",
"3596061", "Golyamo\ Sokolovo",
"3596138", "Nedan",
"35947201", "Izgrev\,\ Yambol",
"35984734", "Todorovo\,\ Razgrad",
"35961706", "Pisarevo\,\ V\.\ Tarnovo",
"3598156", "Cherven\,\ Ruse",
"3598646", "Vokil",
"3595711", "Ovcharovo\,\ Dobr\.",
"3595114", "Ezerovo\,\ Varna",
"3598128", "Polsko\ Kosovo",
"3599332", "Rakovitsa",
"359335", "Karlovo",
"35935252", "Topoli\ dol",
"35969245", "Devetaki",
"3596538", "Obnova",
"3595736", "Vasilevo",
"3596572", "Suhache",
"3599180", "Golyamo\ Peshtene",
"35951538", "Izgrev\,\ Varna",
"3594752", "Parvenets\,\ Yambol",
"35951537", "Chernevo",
"35941276", "Mogila\,\ St\.\ Zagora",
"359590", "Tsarevo",
"3596033", "Medovina",
"3595139", "Oborishte\,\ Varna",
"3593521", "Zvanichevo",
"359848", "Kubrat",
"35982", "Ruse",
"3593704", "Bryagovo\,\ Hask\.",
"3593679", "Kirkovo",
"359554", "Sunny\ Beach",
"3593101", "Voyvodinovo",
"359361", "Kardzhali",
"35974402", "Godlevo",
"3597030", "Resilovo",
"3596514", "Dolni\ Dabnik",
"3594356", "Hadzhidimitrovo\,\ St\.\ Zagora",
"3599139", "Tarnava\,\ Vratsa",
"3595572", "Beronovo",
"3597183", "Dushantsi",
"3597732", "Vukan",
"3596736", "Gradnitsa\,\ Gabr\.",
"3595538", "Karanovo\,\ Burgas",
"3594595", "Sborishte",
"3593032", "Srednogortsi",
"3593154", "Chalakovi",
"359605", "Omurtag",
"3594515", "Mokren",
"3593751", "Lyubimets",
"35937705", "Pastrogor",
"3593644", "Egrek",
"3595332", "Dragoevo",
"3598129", "Lom\ Cherkovna",
"359418", "Galabovo\,\ St\.\ Zagora",
"35984743", "Brestovene",
"3596982", "aglen",
"35981461", "Karan\ Varbovka",
"3597541", "Satovcha",
"3594147", "Lyubenovo\,\ St\.\ Zagora",
"3594522", "Korten",
"3598145", "Trastenik\,\ Ruse",
"3596587", "Petokladentsi",
"3596935", "Sopot\,\ Lovech",
"3594102", "Yastrebovo\,\ St\.\ Zagora",
"3599514", "Vladimirovo\,\ Mont\.",
"35961607", "Balkantsi\,\ V\.\ Tarnovo",
"35961608", "Gorski\ Senovets",
"3597921", "Zhilentsi",
"35964", "Pleven",
"3593173", "Panicheri",
"3598671", "Silistra",
"3598117", "Marten",
"3593044", "Lyaskovo\,\ Smol\.",
"3594115", "Kirilovo\,\ St\.\ Zagora",
"3593554", "Kozarsko",
"359309", "Pamporovo",
"3595580", "Troyanovo\,\ Burgas",
"35984769", "Gorotsvet",
"35960454", "Zmeyno",
"3593775", "Generalovo",
"3596539", "Gradishte\,\ Pleven",
"3594122", "Elenino",
"3594713", "Stara\ reka\,\ Yambol",
"3597744", "Elovdol\,\ Pernik",
"35951127", "Razdelna\,\ Varna",
"35931791", "Begovo",
"3596964", "Velchevo\,\ Lovech",
"3594793", "Boyadzhik",
"3596114", "Kilifarevo",
"3593678", "Chakalarovo",
"359301", "Smolyan",
"3596711", "Kozi\ rog",
"3599187", "Lyutadzhik",
"35994", "Vidin",
"3598184", "Glodzhevo",
"3593632", "Dzhebel",
"3595344", "Velino",
"35931602", "Tatarevo\,\ Plovdiv",
"35941112", "Starozagorski\ bani",
"3595138", "Dobrotich",
"35941358", "Opalchenets",
"3596930", "Slavshtitsa",
"35941357", "Zetyovo\,\ St\.\ Zagora",
"3594347", "Rozovo\,\ St\.\ Zagora",
"35941334", "Saedinenie\,\ St\.\ Zagora",
"3593936", "Gorski\ izvor\,\ Hask\.",
"3593672", "Chorbadzhiysko",
"3598140", "Borovo\,\ Ruse",
"3595783", "Kotlentsi",
"3595132", "Mihalich\,\ Varna",
"35947354", "Kamenna\ reka",
"3593638", "Zvezdel",
"3593561", "Septemvri",
"3594510", "Zhelyu\ voyvoda",
"35984778", "Bogdantsi\,\ Razgrad",
"3596579", "Ruptsi\,\ Pleven",
"35974204", "Gega",
"3596001", "Cherkovna\,\ Targ\.",
"359559", "Karnobat",
"35967301", "Idilevo",
"3599339", "Makresh",
"3598631", "Silistra",
"3597035", "Cherven\ breg",
"3593782", "Kalugerovo\,\ Hask\.",
"3593133", "Kalofer",
"3594156", "Aprilovo\,\ St\.\ Zagora",
"3596988", "Peshterna",
"35930257", "Vishnevo",
"3595144", "Kamchia",
"3596179", "Krusheto",
"3595338", "Troitsa",
"35995277", "Cherkaski",
"3596021", "Buhovtsi",
"3594556", "Sotirya",
"3594108", "Vasil\ Levski\,\ St\.\ Zagora",
"3593533", "Bata",
"3594528", "Lyubenova\ mahala",
"359702", "Bobov\ dol",
"359519", "Devnya",
"3598445", "Yuper",
"3595578", "Terziysko\,\ Burgas",
"3599314", "Dunavtsi\,\ Vidin",
"35959407", "Sini\ rid",
"35959408", "Razhitsa",
"3594322", "Yagoda",
"359596", "Pomorie",
"35967194", "Grablevtsi",
"3593072", "Nedelino",
"3593764", "Polyanovo\,\ Hask\.",
"3593038", "Chokmanovo",
"3598663", "Sitovo\,\ Silistra",
"35961395", "Paskalevets",
"35942", "Stara\ Zagora",
"35931992", "Padarsko",
"35935391", "Blatnitsa",
"3598696", "Suhodol\,\ Silistra",
"35953234", "Zlatna\ niva",
"3594369", "Aleksandrovo\,\ St\.\ Zagora",
"3595532", "Topolitsa",
"359619", "Lyaskovets\,\ V\.\ Tarnovo",
"3595314", "Belokopitovo",
"3594726", "Malomirovo",
"35984711", "Mortagonovo",
"35941119", "Elhovo\,\ St\.\ Zagora",
"3593639", "Nanovitsa\,\ Kardzh\.",
"3594597", "Borov\ dol",
"3594584", "Ticha",
"3596144", "Dolna\ Lipnitsa",
"3596532", "Balgarene\,\ Pleven",
"3599144", "Nivyanin",
"3599741", "Dolni\ Tsibar",
"3594129", "Madzherito",
"3597714", "Meshtitsa",
"3594743", "Mamarchevo",
"35951428", "Gospodinovo\,\ Varna",
"3593321", "Topolovo\,\ Plovdiv",
"3594517", "Ichera",
"3599338", "Shishentsi",
"3596585", "Belene",
"3594340", "Panicherevo",
"3596937", "Sokolovo\,\ Lovech",
"35955504", "Bogdanovo\,\ Burgas",
"3594145", "Znamenosets",
"3595394", "Byala\ reka\,\ Shumen",
"3596578", "Reselets",
"3598147", "Baniska",
"3595776", "Cherna\,\ Dobr\.",
"35961306", "Patresh",
"3598115", "Chervena\ voda",
"3594109", "Trakia",
"3594529", "Sadievo\,\ Sliven",
"3599544", "Studeno\ buche",
"35969032", "Balgarski\ izvor",
"3596132", "Karaisen",
"3597136", "Novachene\,\ Sofia",
"3596178", "Strelets\,\ V\.\ Tarnovo",
"3593777", "Mezek",
"3598122", "Tsenovo\,\ Ruse",
"35991188", "Galatin",
"3596989", "Toros",
"35969240", "Hlevene",
"3594562", "Kriva\ krusha",
"3593039", "Polkovnik\ Serafimovo",
"3599185", "Beli\ Izvor",
"3594368", "Tarnicheni",
"35961703", "Varbitsa\,\ V\.\ Tarnovo",
"3597933", "Gramazhdano",
"35951314", "Voyvodino",
"359659", "Cherven\ bryag",
"3596544", "Novachene\,\ Pleven",
"3595579", "Vedrovo",
"3599783", "Brusartsi",
"3599132", "Knezha",
"35974409", "Mesta",
"3598142", "Bazovets\,\ Ruse",
"3594525", "Omarchevo\,\ Sliven",
"35941339", "Dimitrievo",
"3598165", "Smirnenski\,\ Ruse",
"3594105", "Byalo\ pole",
"3596932", "Mikre",
"3595335", "Milanovo\,\ Shumen",
"3597936", "Slokoshtitsa",
"3594512", "Blatets\,\ Sliven",
"3599524", "Yagodovo\,\ Mont\.",
"3593664", "Plevun",
"3596985", "Rumyantsevo",
"3595130", "General\ Kiselovo",
"3596537", "Asenovtsi",
"35984740", "Bisertsi",
"3596524", "Petarnitsa",
"3593035", "Varbina",
"3597133", "Pravets",
"3599189", "Pavolche",
"3595754", "Zarnevo",
"3594592", "Byala\ palanka",
"3595575", "Prilep\,\ Burgas",
"3597735", "Leva\ reka",
"35935254", "Dobrovnitsa",
"3598448", "Terter",
"3595551", "Sredets\,\ Burgas",
"3595773", "Lozenets\,\ Dobr\.",
"35931402", "Skobelevo\,\ Plovdiv",
"3597533", "Osikovo\,\ Blag\.",
"3599137", "Popitsa",
"3596124", "Ledenik",
"35984732", "Yonkovo",
"3594746", "Popovo\,\ Yambol",
"3598134", "Malko\ Vranovo",
"3596944", "Krushuna",
"35936700", "Shoptsi",
"3594567", "Banya\,\ Sliven",
"359453", "Kotel",
"3596076", "Taymishte",
"35937706", "Chernodab",
"35961393", "Gorsko\ Kosovo",
"3594125", "Mihaylovo\,\ St\.\ Zagora",
"3593772", "Momkovo",
"3598127", "Karamanovo",
"3597911", "Granitsa",
"3596137", "Butovo",
"3599721", "Dolno\ Tserovene",
"3594149", "Trankovo\,\ St\.\ Zagora",
"3595530", "Peshtersko",
"3599124", "Tipchenitsa",
"3593341", "Konush\,\ Plovdiv",
"3594723", "Boyanovo\,\ Yambol",
"35963572", "Yasen\,\ Pleven",
"3594112", "Badeshte",
"3596589", "Kulina\ voda",
"3598693", "Zvenimir",
"3593191", "Brezovo\,\ Plovdiv",
"35931604", "Dragoynovo",
"3593787", "Tyanevo\,\ Hask\.",
"35941114", "Lozen\,\ St\.\ Zagora",
"3595944", "Ruen\,\ Burgas",
"3596175", "Parvomaytsi",
"3598666", "Tutrakan",
"35930458", "Lyubcha",
"3595124", "Komarevo\,\ Varna",
"35930457", "Kasak",
"35931701", "Krastevich",
"3598118", "Nikolovo\,\ Ruse",
"35984727", "Kamenovo\,\ Razgrad",
"35984728", "Rakovski\,\ Razgrad",
"3596551", "Trastenik\,\ Pleven",
"35941275", "Lyaskovo\,\ St\.\ Zagora",
"35975215", "Teshovo",
"3595589", "Vinarsko",
"3599551", "Georgi\ Damyanovo",
"3594553", "Rakovo\,\ Sliven",
"35974321", "Harsovo\,\ Blag\.",
"3596530", "Tranchovitsa",
"3593536", "Banya\,\ Pazardzhik",
"35953434", "Yasenkovo",
"3594771", "Malomir\,\ Yambol",
"3595137", "Kaloyan",
"3599175", "Ostrov",
"35971587", "Golema\ Rakovitsa",
"35941480", "Kolarovo\,\ St\.\ Zagora",
"3593677", "Drangovo\,\ Kardzh\.",
"3593111", "Parvenets\,\ Plovdiv",
"3594342", "Ovoshtnik",
"3599188", "Gorno\ Peshtene",
"3595537", "Sadievo\,\ Burgas",
"359556", "Obzor",
"3593136", "Rozino\,\ Plovdiv",
"3594153", "Madrets\,\ St\.\ Zagora",
"3593077", "Sredets\,\ Smol\.",
"3594327", "Sheynovo",
"3594755", "Tamarino",
"3593511", "Ognyanovo\,\ Pazardzhik",
"3596575", "Telish",
"3594334", "Elhovo\,\ St\.\ Zagora\,\ mun\.\ Nikolaevo",
"3596588", "Dekov",
"359817", "Byala\,\ Ruse",
"35963567", "Gradina\,\ Pleven",
"3596151", "Elena\,\ V\.\ Tarnovo",
"35963568", "Bukovlak",
"3599335", "Tsar\ Petrovo",
"35961705", "Gorski\ dolen\ Trambesh",
"3597039", "Samoranovo",
"3599130", "Tlachene",
"35974404", "Babyak",
"3593933", "Stransko",
"3595524", "Ekzarh\ Antimovo",
"3598167", "Tserovets",
"3594107", "Sredets\,\ St\.\ Zagora",
"35963579", "Ralevo",
"35961305", "Lesicheri",
"3596582", "Belene",
"35961108", "Plakovo",
"35978", "Kyustendil",
"35961107", "Momin\ sbor",
"3594527", "Zagortsi\,\ Sliven",
"3594142", "Troyanovo\,\ St\.\ Zagora",
"3597724", "Izvor\,\ Pernik",
"359650", "Levski\,\ Pleven",
"3596987", "Karlukovo",
"3596994", "Brestnitsa\,\ Lovech",
"3596535", "Kozar\ Belene",
"3593779", "Siva\ reka",
"3594763", "Irechekovo",
"35941173", "Bratya\ Kunchevi",
"3599164", "Krushovitsa\,\ Vratsa",
"3595337", "Kochovo",
"3593024", "Taran",
"3594796", "General\ Toshevo\,\ Yambol",
"359306", "Rudozem",
"3593037", "Sivino",
"3596164", "Bryagovitsa",
"3594716", "Veselinovo\,\ Yambol",
"3595324", "Harsovo\,\ Shumen",
"3596914", "Slivek",
"3595577", "Podvis\,\ Burgas",
"3593176", "Starosel",
"35976", "Pernik",
"35941270", "Malka\ Vereya",
"359745", "Petrich\,\ Blag\.",
"35930411", "Devin",
"3599135", "Bardarski\ geran",
"35941019", "Venets\,\ St\.\ Zagora",
"359910", "Mezdra",
"35967391", "Stolat",
"3593637", "Gruevo",
"3599330", "Rabrovo",
"3596564", "Zagrazhden\,\ Pleven",
"3598192", "Hotantsa",
"3599182", "Devene",
"35974202", "Klyuch",
"3594599", "Chervenakovo",
"35969243", "Kazachevo",
"3594348", "Dunavtsi\,\ St\.\ Zagora",
"3596570", "Deventsi",
"3594134", "Bratya\ Daskalovi",
"3597521", "Koprivlen",
"3598125", "Koprivets",
"3596733", "Kormyansko",
"3594519", "Samuilovo\,\ Sliven",
"3596939", "Dragana",
"3594353", "Srednogorovo",
"3599564", "Stubel",
"3597186", "Anton",
"3593624", "Chiflik\,\ Kardzh\.",
"35941332", "Naydenovo",
"3596135", "Varbovka",
"35961502", "Gorsko\ Novo\ Selo",
"3598149", "Katselovo",
"359610", "Pavlikeni\,\ V\.\ Tarnovo",
"3599351", "Izvor\,\ Vidin",
"3593778", "Studena\,\ Hask\.",
"3596177", "Yantra\,\ V\.\ Tarnovo",
"3595570", "Manolich",
"3593785", "Dryanovo\,\ Hask\.",
"3597032", "Yahinovo",
"359457", "Nova\ Zagora",
"3596036", "Sadina",
"3593030", "Shiroka\ laka",
"3594118", "Pamukchii\,\ St\.\ Zagora",
"3595351", "Smyadovo",
"3593051", "Chepelare",
"359675", "Sevlievo",
"3596980", "Belentsi",
"3595135", "Stefan\ Karadzha\,\ Varna",
"3595330", "Zlatar",
"3593675", "Fotinovo\,\ Kardzh\.",
"3597751", "Breznik",
"3597154", "Stolnik",
"3594100", "Stoletovo\,\ St\.\ Zagora",
"35984745", "Vladimirovtsi",
"3595733", "Kardam\,\ Dobr\.",
"35937703", "Dimitrovche",
"3594520", "Konyovo",
"3594367", "Tazha",
"3599324", "Ruzhintsi",
"3593651", "Ardino",
"3595535", "Lyaskovo\,\ Burgas",
"35955502", "Suhodol\,\ Burgas",
"359550", "Sozopol",
"3598643", "Zlatoklas",
"3593744", "Sarnitsa\,\ Hask\.",
"359379", "Svilengrad",
"35984764", "Seydol",
"35951108", "Izvorsko",
"3598442", "Zavet\,\ Razgrad",
"3593075", "Dolen\,\ Smol\.",
"3593921", "Merichleri",
"3594325", "Kanchevo",
"3597044", "Babino",
"3594757", "Nedyalsko",
"3598626", "Sredishte\,\ Silistra",
"3596938", "Kalenik\,\ Lovech",
"3598148", "Gorno\ Ablanovo",
"3596577", "Breste",
"35971224", "Shipochane",
"3595914", "Atia",
"3593583", "Gabrovitsa",
"359701", "Dupnitsa",
"3594518", "Topolchane",
"3596324", "Vardim",
"3595164", "Neofit\ Rilski",
"3599337", "Gramada",
"359936", "Belogradchik",
"359417", "Radnevo",
"3597433", "Kresna",
"3595761", "Batovo",
"3595336", "Imrenchevo",
"35960383", "Berkovski",
"3594797", "Galabintsi",
"3597935", "Dolno\ selo",
"3596986", "Daben",
"35930472", "Mihalkovo",
"3596541", "Nikopol",
"3599183", "Lilyache",
"3597139", "Dzhurovo",
"35973", "Blagoevgrad",
"3596901", "Glozhene\,\ Lovech",
"3593691", "Chernoochene",
"3594526", "Mlekarevo",
"35931396", "Domlyan",
"3594106", "Pastren",
"3598166", "Svalenik",
"3599785", "Vasilovtsi\,\ Mont\.",
"35963569", "Kamenets\,\ Pleven",
"35947193", "Mogila\,\ Yambol",
"3593177", "Novo\ Zhelezare",
"3598113", "Novo\ selo\,\ Ruse",
"3595576", "Lozarevo",
"3594352", "Gorno\ Cherkovishte",
"3599541", "Doktor\ Yosifovo",
"3598698", "Shumentsi",
"3596732", "Sennik",
"35991184", "Rakevo",
"3593036", "Mogilitsa",
"35967306", "Gradishte\,\ Gabr\.",
"3596030", "Svetlen\,\ Targ\.",
"3594717", "Chargan",
"3595391", "Varbitsa\,\ Shumen",
"3594745", "Sharkovo",
"35959694", "Gaberovo",
"35974348", "Igralishte",
"3598620", "Silistra",
"35974347", "Razdol",
"3594762", "Vodenichane",
"3597711", "Kladnitsa",
"3593324", "Izbeglii",
"3594143", "Sarnevo\,\ St\.\ Zagora",
"3593636", "Raven",
"3596583", "Belene",
"35953222", "Markovo\,\ Shumen",
"3594729", "Kirilovo\,\ Yambol",
"3599141", "Malorad",
"3599744", "Valchedram",
"35931627", "Krushevo\,\ Plovdiv",
"3596141", "Polski\ Trambesh",
"3597187", "Bunovo\,\ Sofia",
"359336", "Parvomay\,\ Plovdiv",
"35984729", "Ezerche",
"3596921", "Ablanitsa\,\ Lovech",
"359728", "Zlatitsa",
"3594158", "Iskritsa",
"35984466", "Zvanartsi",
"35977222", "Gorna\ Dikanya",
"3594126", "Hrishteni",
"359971", "Lom",
"3595311", "Gradishte\,\ Shumen",
"35981463", "Mogilino",
"35930459", "Brashten",
"35941149", "Lovets\,\ St\.\ Zagora",
"3597172", "Dragoman",
"35959404", "Yasenovo\,\ Burgas",
"3594710", "Bolyarsko",
"3593164", "Dalbok\ izvor",
"35967395", "Gorna\ Rositsa",
"3598642", "Dulovo",
"3598152", "Krasen\,\ Ruse",
"3597138", "Litakovo",
"3598665", "Iskra\,\ Silistra",
"3596176", "Polikraishte",
"35961102", "Pchelishte",
"3599311", "Kutovo",
"35931108", "Bogdanitsa",
"3599176", "Leskovets\,\ Vratsa",
"359579", "Albena",
"3598699", "Tarnovtsi\,\ Silistra",
"3593582", "Momina\ klisura",
"35937422", "Dolni\ Glavanak",
"3596024", "Ruets",
"359350", "Peshtera\,\ Pazardzhik",
"3595141", "Staro\ Oryahovo",
"35935502", "Fotinovo\,\ Pazardzhik",
"3593535", "Levski\,\ Pazardzhik",
"35974207", "General\ Todorov",
"3598634", "Nova\ Cherna",
"3594756", "Polyana\,\ Yambol",
"35931700", "Belovitsa",
"3594728", "Melnitsa",
"3596954", "Vrabevo",
"35961301", "Byala\ reka\,\ V\.\ Tarnovo",
"35984774", "Golyam\ izvor\,\ Razgrad",
"3593135", "Karnare",
"3597033", "Kraynitsi",
"3596004", "Makovo",
"35936402", "Gorna\ kula",
"35969615", "Balabansko",
"35960370", "Golyamo\ gradishte",
"35957306", "Izvorovo\,\ Dobr\.",
"3593564", "Semchinovo",
"3599336", "Staropatitsa",
"35941337", "Sarnevets",
"3595732", "Petleshkovo",
"35941338", "Tselina",
"359749", "Bansko",
"35941354", "Malko\ Tranovo",
"3597444", "Belitsa\,\ Blag\.",
"35947203", "Trankovo\,\ Yambol",
"3596576", "Radomirtsi",
"35930415", "Devin",
"3598627", "Babuk",
"3593530", "Poibrene",
"35937602", "Cherna\ mogila\,\ Hask\.",
"3596536", "Asparuhovo\,\ Pleven",
"3595738", "Spasovo\,\ Dobr\.",
"35977229", "Galabnik",
"3594795", "Skalitsa",
"35984722", "Yasenovets",
"3595341", "Hitrino",
"3597937", "Razhdavitsa",
"3596111", "Kapinovo\,\ V\.\ Tarnovo",
"3596714", "Popovtsi",
"3599787", "Smirnenski\,\ Mont\.",
"3597532", "Bukovo\,\ Blag\.",
"35967390", "Shumata",
"3595772", "Telerig",
"3593175", "Dalgo\ pole\,\ Plovdiv",
"3597741", "Zemen",
"3598660", "Tutrakan",
"3594113", "Preslaven",
"3597144", "Kostenets",
"3594722", "Granitovo\,\ Yambol",
"3599111", "Chelopek",
"35961604", "Mirovo\,\ V\.\ Tarnovo",
"3597924", "Shishkovtsi",
"3593773", "Kapitan\ Andreevo",
"3598674", "Profesor\ Ishirkovo",
"3594715", "Kalchevo",
"35960458", "Verentsi",
"3593588", "Menenkyovo",
"3596591", "Gornik",
"3594513", "Gavrailovoc",
"3597544", "Osina",
"3597054", "Rila",
"3594747", "Dennitsa\,\ Yambol",
"35960375", "Garchinovo",
"3597438", "Katuntsi",
"35984713", "Blagoevo\,\ Razgrad",
"359478", "Elhovo\,\ Yambol",
"3599136", "Galiche",
"3594359", "Asen\,\ St\.\ Zagora",
"3596933", "Golets",
"3593151", "Rakovski\,\ Plovdiv",
"3593754", "Lozen\,\ Hask\.",
"3598143", "Obretenik",
"3593641", "Krumovgrad",
"35931705", "Gorna\ mahala",
"35963562", "Komarevo\,\ Pleven",
"35974325", "Lilyanovo",
"35930410", "Breze\,\ Smol\.",
"3597185", "Chelopech",
"3597178", "Prolesha",
"3596136", "Suhindol",
"3593130", "Karavelovo\,\ Plovdiv",
"359751", "Gotse\ Delchev",
"3594593", "Shivachevo",
"3597132", "Radotina",
"3596077", "Stevrek",
"3598158", "Mechka\,\ Ruse",
"3594566", "Pitovo",
"35971306", "Rashkovo",
"3598648", "Sekulovo",
"3596511", "Pobeda\,\ Pleven",
"3596035", "Palamartsa",
"3593701", "Elena\,\ Hask\.",
"35984392", "Belintsi",
"3593104", "Yagodovo\,\ Plovdiv",
"3593524", "Apriltsi\,\ Pazardzhik",
"3598667", "Belitsa\,\ Silistra",
"3595739", "Pchelarovo\,\ Dobr\.",
"3594152", "Obruchishte",
"3593786", "Navasen",
"35981466", "Pomen",
"3595511", "Lukoil\ Neftochim",
"3593932", "Bodrovo",
"3593676", "Benkovski\,\ Kardzh\.",
"3594768", "Zimnitsa\,\ Yambol",
"35984463", "Prelez",
"35935393", "Smilets\,\ Pazardzhik",
"35941018", "Knyazhevsko",
"3595136", "Brestak",
"3593537", "Panagyurski\ kolonii",
"3597930", "Eremia",
"35971504", "Belopoptsi",
"35984737", "Raynino",
"3594358", "Skobelevo\,\ St\.\ Zagora",
"35931393", "Voynyagovo",
"35984738", "Kitanchevo",
"3593076", "Tsatsarovtsi",
"3594326", "Enina",
"3595714", "Karapelit",
"3593589", "Tserovo\,\ Pazardzhik",
"359391", "Dimitrovgrad",
"3596738", "Dobromirka",
"3597439", "Ploski",
"3593137", "Klisura\,\ Plovdiv",
"3596064", "Golyamo\ Novo",
"3595536", "Maglen",
"35960386", "Voditsa\,\ Targ\.",
"3598692", "Stefan\ Karadzha\,\ Silistra",
"35967303", "Batoshevo",
"35961109", "Vaglevtsi",
"3593721", "Stambolovo\,\ Hask\.",
"3593124", "Kalekovets",
"3594343", "Konare\,\ St\.\ Zagora",
"35963578", "Opanets\,\ Pleven",
"3599341", "Dimovo\,\ Vidin",
"35963577", "Pelishat",
"3598649", "Yarebitsa",
"3598159", "Koshov",
"35961402", "Stefan\ Stambolovo",
"3594552", "Stara\ reka\,\ Sliven",
"3598625", "Oven",
"35963204", "Delyanovtsi",
"3597179", "Golemo\ Malovo",
"3598630", "Silistra",
"3593928", "Dolno\ Belevo",
"359729", "Godech",
"35941179", "Han\ Asparuhovo",
"35931995", "Streltsi\,\ Plovdiv",
"359678", "Teteven",
"35961304", "Dimcha",
"3596359", "Glava",
"3596950", "Gumoshtnik",
"3596513", "Pordim",
"3593148", "Yoakim\ Gruevo",
"35963573", "Disevitsa",
"3594739", "Radovets",
"3593658", "Padina\,\ Kardzh\.",
"3593626", "Perperek",
"3597184", "Koprivshtitsa",
"35941110", "Starozagorski\ bani",
"35967307", "Mlechevo",
"35967308", "Lovnidol",
"3595768", "Odrintsi\,\ Dobr\.",
"3596566", "Dolni\ Vit",
"3597117", "Gradets\,\ Sofia",
"3594511", "Slivenski\ mineralni\ bani",
"3593327", "Bachkovo",
"3593755", "Belitsa\,\ Hask\.",
"35941351", "Partizanin",
"3599513", "Boychinovtsi",
"35931403", "Trivoditsi",
"3599747", "Mokresh\,\ Mont\.",
"3597529", "Breznitsa",
"35941484", "Zemlen",
"3593643", "Golyama\ Chinka",
"3594136", "Cherna\ gora\,\ St\.\ Zagora",
"3598141", "Dve\ mogili",
"3597545", "Kochan",
"3593153", "Stryama",
"3596931", "Ugarchin",
"35931398", "Slatina\,\ Plovdiv",
"35984733", "Ludogortsi",
"359721", "Kostinbrod",
"35931397", "Hristo\ Danovo",
"3596916", "Brestovo\,\ Lovech",
"3597129", "Raduil",
"3599722", "Staliyska\ mahala",
"3599113", "Mramoren",
"35969249", "Doyrentsi",
"3593342", "Narechenski\ bani",
"3597743", "Divlya",
"3594714", "Drazhevo",
"3595326", "Varbyane",
"3596166", "Vinograd",
"3597925", "Gyueshevo",
"3598675", "Aydemir",
"35984467", "Seslav",
"3597162", "Lakatnik",
"3593553", "Batak\,\ Pazardzhik",
"3597145", "Mirovo\,\ Sofia",
"3593043", "Zmeitsa",
"3593174", "Staro\ Zhelezare",
"3597912", "Gorna\ Grashtitsa",
"3595343", "Venets\,\ Shumen",
"3597726", "Dren",
"35974346", "Tsaparevo",
"3593026", "Smilyan",
"3594794", "Ovchi\ kladenets",
"3596963", "Balkanets",
"3595552", "Dyulevo\,\ Burgas",
"3599166", "Hayredin",
"3596020", "Lilyak",
"3595740", "Gorichane",
"3593548", "Pashovo",
"3596722", "Sokolovo\,\ Gabr\.",
"3593058", "Mugla",
"3596113", "Balvan",
"3594738", "Hlyabovo",
"3597447", "Dobrinishte",
"3593149", "Tsalapitsa",
"3599343", "Gomotartsi",
"3598624", "Kalipetrovo",
"3594341", "Cherganovo",
"3593112", "Markovo\,\ Plovdiv",
"3593567", "Kovachevo\,\ Pazardzhik",
"3593320", "Oreshets\,\ Plovdiv",
"3595166", "Dobroplodno",
"3597110", "Opitsvet",
"3593929", "Golyamo\ Asenovo",
"3596326", "Morava",
"3599552", "Belimel",
"3593125", "Razhevo\ Konare",
"359748", "Simitli",
"3595916", "Rosen\,\ Burgas",
"3594772", "Simeonovo\,\ Yambol",
"3599740", "Septemvriytsi\,\ Mont\.",
"3593746", "Sirakovo\,\ Hask\.",
"3596007", "Ralitsa",
"3596065", "Bistra\,\ Targ\.",
"35931387", "Prolom",
"35931388", "Beguntsi",
"35984718", "Dryanovets\,\ Razgrad",
"3596552", "Dolna\ Mitropolia",
"3599326", "Gorni\ Lom",
"35984717", "Pobit\ kamak\,\ Razgrad",
"3596042", "Iliyno",
"3597046", "Boboshevo",
"3593192", "Babek",
"3595715", "Popgrigorovo",
"3595769", "Hitovo",
"3598637", "Malak\ Preslavets",
"3596957", "Golyama\ Zhelyazna",
"359337", "Hisarya",
"35984744", "Belovets",
"3597528", "Hadzhidimovo",
"35991201", "Lyuti\ brod",
"35957308", "Chernookovo\,\ Dobr\.",
"35957307", "Zhiten\,\ Dobr\.",
"3596027", "Dralfa",
"3596152", "Bebrovo",
"35960453", "Moravka",
"3595747", "Vaklino",
"35941336", "Yazdach",
"3595513", "Gabar",
"35984765", "Veselina",
"3597156", "Ravno\ pole",
"35947356", "Mramor\,\ Yambol",
"3593512", "Hadzhievo",
"3597422", "Topolnitsa\,\ Blag\.",
"3593059", "Kutela",
"3593703", "Zhalti\ bryag",
"3593549", "Grashevo",
"3597415", "Selishte\,\ Blag\.",
"3593105", "Manolsko\ Konare",
"3596034", "Slavyanovo\,\ Targ\.",
"35971225", "Novo\ selo\,\ Sofia",
"3593167", "Bryagovo\,\ Plovdiv",
"3594583", "Kipilovo",
"3597428", "Gabrene",
"35947353", "Balgarska\ polyana",
"3595559", "Kubadin",
"3593518", "Dragor",
"3596143", "Maslarevo",
"3596074", "Lyubichevo",
"3595710", "Pobeda\,\ Dobr\.",
"3595313", "Madara",
"35941333", "Sredno\ gradishte",
"35961503", "Chakali",
"3599126", "Kameno\ pole",
"3596060", "Ovcharovo\,\ Targ\.",
"3596923", "Goran",
"3596126", "Tserova\ koria",
"3599745", "Zlatia\,\ Mont\.",
"3593120", "Hrabrino",
"3595366", "Branichevo",
"3597169", "Tompsan",
"3593325", "Cherven\,\ Plovdiv",
"3593757", "Georgi\ Dobrevo",
"3596158", "Sredni\ kolibi",
"3595393", "Ivanovo\,\ Shumen",
"3593349", "Boyantsi",
"35943616", "Turia",
"3599143", "Enitsa",
"3596581", "Byala\ voda\,\ Pleven",
"3596946", "Chavdartsi",
"35935255", "Rosen\,\ Pazardzhik",
"35969242", "Presyaka",
"35974203", "Rupite",
"3599729", "Rasovo",
"3598136", "Stambolovo\,\ Ruse",
"3597547", "Valkosel",
"3594744", "Golyamo\ Krushevo",
"3597713", "Rudartsi",
"3597057", "Malo\ selo",
"3596558", "Slavovitsa\,\ Pleven",
"3595756", "Bozhan",
"3596048", "Izvorovo\,\ Targ\.",
"35974496", "Filipovo\,\ Blag\.",
"3597927", "Treklyano",
"3598111", "Shtraklevo",
"3598677", "Srebarna",
"3593100", "Belashtitsa",
"3593520", "Miryantsi",
"359724", "Ihtiman",
"3596526", "Varbitsa\,\ Pleven",
"3599352", "Druzhba",
"35984760", "Trapishte",
"3597522", "Dabnitsa",
"3597147", "Pchelin\,\ Sofia",
"3593198", "Chehlare",
"3597102", "Lopyan",
"359357", "Panagyurishte",
"3599784", "Kiselevo",
"3599181", "Kravoder",
"3596543", "Muselievo",
"3596717", "Lesicharka",
"3593118", "Sadovo\,\ Plovdiv",
"35971220", "Gutsal",
"3594732", "Ustrem",
"3594778", "Pobeda\,\ Yambol",
"3593666", "Popsko",
"3599526", "Slatina\,\ Mont\.",
"35941172", "Gorno\ Botevo",
"3596352", "Dolni\ Lukovit",
"3599558", "Gavril\ Genovo",
"3597934", "Bunovo\,\ Kyust\.",
"35967193", "Kmetovtsi",
"3593693", "Lyaskovo\,\ Kardzh\.",
"3597752", "Rezhantsi",
"3594336", "Dolno\ Izvorovo",
"3595784", "Vrachantsi",
"35931605", "Bukovo\,\ Plovdiv",
"35941115", "Borilovo",
"3597445", "Banya\,\ Blag\.",
"3593542", "Rakitovo",
"3595526", "Klikach",
"3593052", "Laki\,\ Plovdiv",
"3596728", "Burya",
"3593127", "Tsaratsovo",
"35965617", "Iskar\,\ Pleven",
"3593519", "Velichkovo\,\ Pazardzhik",
"3595106", "Avren\,\ Varna",
"3595558", "Debelt",
"35953435", "Izgrev\,\ Shumen",
"3593348", "Dobralak",
"3595352", "Yankovo",
"3599728", "Slivata",
"3593134", "Sopot\,\ Plovdiv",
"35975214", "Gaytaninovo",
"35941274", "Samuilovo\,\ St\.\ Zagora",
"3596067", "Kralevo\,\ Targ\.",
"3596955", "Dalbok\ dol",
"3597918", "Yabalkovo\,\ Kyust\.",
"3595717", "Vedrina",
"3596159", "Zlataritsa",
"359860", "Silistra",
"3597031", "Gorna\ Koznitsa",
"3598635", "Tsar\ Samuil",
"3597168", "Bov",
"3593534", "Popintsi",
"3595745", "Vranino",
"3596025", "Alvanovo",
"3595762", "Stefan\ Karadzha\,\ Dobr\.",
"35963576", "Tuchenitsa",
"3596710", "Donino",
"3595143", "Byala\,\ Varna",
"3596049", "Kamburovo",
"35937702", "Mustrak",
"3596559", "Gostilya",
"3598664", "Polyana\,\ Silistra",
"35984736", "Podayva",
"3594779", "Hanovo",
"3593763", "Balgarin",
"3593922", "Brod",
"3595946", "Tranak",
"3599559", "Gorna\ Kovachitsa",
"3597920", "Skrinyano",
"3593119", "Galabovo\,\ Plovdiv",
"3593107", "Graf\ Ignatievo",
"3599313", "Kapitanovtsi",
"35974405", "Kraishte\,\ Blag\.",
"3598670", "Silistra",
"3593165", "Karadzhalovo",
"35960387", "Gloginka",
"35961704", "Pravda\,\ V\.\ Tarnovo",
"3593652", "Byal\ izvor\,\ Kardzh\.",
"35960388", "Goritsa\,\ Targ\.",
"3593527", "Aleko\ Konstantinovo",
"3593142", "Brestovitsa\,\ Plovdiv",
"3595126", "Cherkovna\,\ Varna",
"3598477", "Samuil",
"3599542", "Smolyanovtsi",
"3597103", "Brusen\,\ Sofia",
"3599127", "Lyutidol",
"3596134", "Byala\ cherkva\,\ V\.\ Tarnovo",
"3593625", "Shiroko\ pole",
"3597523", "Garmen",
"3595118", "Voditsa\,\ Varna",
"3593159", "Belozem",
"3599353", "Koshava",
"35959400", "Daskotna",
"3594564", "Novoselets",
"35981462", "Volovo",
"3598124", "Novgrad",
"3594351", "Koprinka",
"35930205", "Starnitsa",
"3595968", "Kableshkovo\,\ Burgas",
"3596902", "Ribaritsa\,\ Lovech",
"35961605", "Novo\ gradishte",
"3597056", "Mursalevo",
"3598137", "Golyamo\ Vranovo",
"3597546", "Slashten",
"35951103", "Lyuben\ Karavelovo",
"3594330", "Nikolaevo\,\ St\.\ Zagora",
"3594733", "Orlov\ dol",
"3596565", "Milkovitsa",
"3595100", "Sindel",
"35953223", "Tsarkvitsa",
"3593756", "Valche\ pole",
"3596519", "Beglezh",
"3599348", "Negovanovtsi",
"35974401", "Gorno\ Draglishte",
"3596542", "Vabel\,\ Pleven",
"3593728", "Slavyanovo\,\ Hask\.",
"3595367", "Todor\ Ikonomovo",
"3599134", "Tarnak",
"3595520", "Cherkovo",
"35951125", "Konstantinovo\,\ Varna",
"35984719", "Balkanski",
"35941111", "Starozagorski\ bani",
"3596922", "Leshnitsa\,\ Lovech",
"35937707", "Shtit",
"3595349", "Studenitsa",
"35960374", "Gorsko\ Ablanovo",
"3595312", "Dibich",
"3597146", "Chernyovo",
"35947192", "Zavoy",
"3596915", "Smochan",
"3595120", "Bozveliysko",
"35931704", "Ivan\ Vazovo",
"3596527", "Odarne",
"3596142", "Obedinenie",
"3596969", "Beklemeto",
"35961406", "Karantsi",
"3595325", "Voyvoda",
"3596119", "Dichin",
"3595757", "Bezmer\,\ Dobr\.",
"3593708", "Orlovo\,\ Hask\.",
"3598676", "Vetren\,\ Silistra",
"3596165", "Asenovo\,\ V\.\ Tarnovo",
"3597926", "Konyavo",
"35931792", "Chernichevo\,\ Plovdiv",
"3594582", "Gradets\,\ Sliven",
"3599119", "Tishevitsa",
"3597712", "Batanovtsi",
"3593025", "Banite",
"3597123", "Kovachevtsi\,\ Sofia",
"3599165", "Sofronievo",
"35960382", "Kovachevets",
"3596534", "Malchika",
"3599527", "Varshets",
"35974324", "Struma",
"3593667", "Pokrovan",
"3599142", "Lazarovo",
"3595392", "Mengishevo",
"3597725", "Klenovik",
"35941350", "Mirovo\,\ St\.\ Zagora",
"3594761", "Straldzha",
"359517", "Dalgopol",
"3593710", "Uzundzhovo",
"3596716", "Zhaltesh",
"3593049", "Beden",
"3595518", "Rudnik\,\ Burgas",
"3593559", "Kapitan\ Dimitrievo",
"3595165", "Nevsha",
"3593648", "Golyamo\ Kamenyane",
"3595119", "Ignatievo",
"3596325", "Kozlovets",
"35993212", "Karbintsi",
"3593126", "Trud",
"3595142", "Dolni\ chiflik",
"3595969", "Galabets\,\ Burgas",
"3595527", "Sokolovo\,\ Burgas",
"3595915", "Balgarovo",
"3595763", "Plachidol",
"3599518", "Marchevo",
"3593581", "Belovo",
"3594337", "Yasenovo\,\ St\.\ Zagora",
"35947202", "Zhrebino",
"3599349", "Slanotran",
"3596518", "Riben",
"3594324", "Shipka",
"3598641", "Okorsh",
"3597045", "Golem\ Varbovnik",
"35991180", "Lesura",
"3595716", "Paskalevo",
"3593143", "Perushtitsa",
"3593074", "Erma\ reka",
"3593653", "Mlechino",
"3598151", "Prosena",
"35969247", "Gostinya",
"35969248", "Skobelevo\,\ Lovech",
"3593729", "Krivo\ pole",
"3599312", "Bregovo\,\ Vidin",
"35971505", "Churek",
"3593745", "Malak\ izvor\,\ Hask\.",
"35941146", "Hristianovo",
"3596066", "Buynovo\,\ Targ\.",
"35937606", "Shishmanovo",
"3595534", "Karageorgievo",
"35930456", "Chavdar\,\ Smol\.",
"3593923", "Radievo",
"3593762", "Izvorovo\,\ Hask\.",
"35984726", "Ushintsi",
"3599325", "Belo\ pole\,\ Vidin",
"35984469", "Bozhurovo\,\ Razgrad",
"3596968", "Dobrodan",
"3593674", "Samodiva",
"35971302", "Bozhenitsa",
"3593709", "Karamantsi",
"3593543", "Dorkovo",
"3596118", "Voneshta\ voda",
"3597155", "Lesnovo",
"3593717", "Konush\,\ Hask\.",
"3593053", "Hvoyna",
"3595348", "Trem",
"3595599", "Hadzhiite",
"35963566", "Brashlyanitsa",
"3595731", "General\ Toshevo\,\ Dobr\.",
"3599520", "Gorno\ Ozirovo",
"3595134", "Cherventsi",
"35937423", "Golemantsi",
"3597753", "Noevtsi",
"3596520", "Nikolaevo\,\ Pleven",
"3595127", "Manastir\,\ Varna",
"35941178", "Oryahovitsa\,\ St\.\ Zagora",
"3593526", "Dinkata",
"3593558", "Isperihovo",
"3595519", "Zidarovo",
"3593106", "Stroevo",
"3595750", "Kableshkovo\,\ Dobr\.",
"3593784", "Konstantinovo\,\ Hask\.",
"3595947", "Prosenik",
"35967309", "Agatovo",
"3595353", "Veselinovo\,\ Shumen",
"35961103", "Rusalya",
"35963205", "Chervena",
"35935251", "Bratanitsa",
"3597913", "Rashka\ Grashtitsa",
"359953", "Berkovitsa",
"3599567", "Dolna\ Verenitsa",
"3599320", "Stakevtsi",
"3593552", "Bratsigovo",
"3593042", "Borino",
"3598475", "Loznitsa\,\ Razgrad",
"3593019", "Pisanitsa",
"3599125", "Gorna\ Beshovitsa",
"35963563", "Borislav",
"3597163", "Iskrets",
"3593740", "Pchelari",
"35984761", "Gradina\,\ Razgrad",
"3599149", "Bukovets\,\ Vratsa",
"3594124", "Zmeyovo",
"3593343", "Kozanovo",
"3597742", "Kalishte",
"35960389", "Kardam\,\ Targ\.",
"3597719", "Yardzhilovtsi",
"3599112", "Banitsa",
"3599723", "Traykovo",
"3596112", "Samovodene",
"3596723", "Tsareva\ livada",
"3597531", "Dolno\ Dryanovo",
"359416", "Chirpan",
"3595771", "Krushari",
"3594137", "Veren",
"3596149", "Kutsina",
"3596962", "Cherni\ Osam",
"35961106", "Novo\ selo\,\ V\.\ Tarnovo",
"3595553", "Orlintsi",
"3598135", "Babovo",
"3599746", "Razgrad\,\ Mont\.",
"3595910", "Cherni\ vrah\,\ Burgas",
"3596125", "Pushevo",
"3595319", "Drumevo",
"3595365", "Lyatno",
"35991185", "Pudria",
"35971221", "Yarlovo",
"3596567", "Somovit",
"3596929", "Radyuvene",
"3593326", "Patriarh\ Evtimovo",
"3597116", "Petarch",
"3593634", "Pripek\,\ Kardzh\.",
"3595342", "Kapitan\ Petko",
"35984712", "Kostandenets",
"3595153", "Suvorovo",
"3599318", "Bukovets\,\ Vidin",
"3596549", "Sanadinovo",
"3595574", "Saedinenie\,\ Burgas",
"3597734", "Glavanovtsi\,\ Pernik",
"3596512", "Gorni\ Dabnik",
"3595755", "Kolartsi",
"3595327", "Kaspichan\,\ Shumen",
"3593034", "Levochevo",
"3593768", "Dositeevo",
"3596167", "Kesarevo",
"3596917", "Balgarene\,\ Lovech",
"35971471", "Ochusha",
"3593699", "Gabrovo\,\ Kardzh\.",
"3596909", "Malka\ Zhelyazna",
"3596525", "Barkach",
"35984723", "Dyankovo",
"3596997", "Dobrevtsi\,\ Lovech",
"3595148", "Rudnik\,\ Varna",
"3599525", "Dolno\ Ozirovo",
"3596984", "Bezhanovo\,\ Lovech",
"3593665", "Svirachi",
"3593027", "Slaveyno",
"35937603", "Rogozinovo",
"3599167", "Lipnitsa\,\ Vratsa",
"3593642", "Potochnitsa",
"3595334", "Osmar",
"3598164", "Pisanets",
"3599512", "Beli\ breg",
"35969031", "Galata",
"3594104", "Kravino",
"3594524", "Kamenovo\,\ Sliven",
"3599549", "Dolna\ Riksa",
"3597727", "Kovachevtsi\,\ Pernik",
"35967394", "Bogatovo",
"3599148", "Barkachevo",
"35961403", "Orlovets",
"3595525", "Devetak",
"35959405", "Zaychar",
"3595917", "Izvor\,\ Burgas",
"3595167", "Venchan",
"3593566", "Boshulya",
"35930200", "Zagrazhden\,\ Smol\.",
"3596560", "Kreta\,\ Pleven",
"3595105", "Priseltsi\,\ Varna",
"35967302", "Kravenik",
"3597718", "Dragichevo",
"3596327", "Ovcha\ mogila",
"3593931", "Kasnakovo",
"3594335", "Razhena",
"35961397", "Musina",
"3596574", "Chomakovtsi",
"3594130", "Spasovo\,\ St\.\ Zagora",
"3597446", "Eleshnitsa\,\ Blag\.",
"3596153", "Zlataritsa",
"3596956", "Lomets\,\ Lovech",
"3595318", "Srednya",
"3597047", "Usoyka",
"3594754", "Kamenets\,\ Yambol",
"3598636", "Glavinitsa\,\ Silistra",
"3596928", "Kakrina",
"35931392", "Dabene",
"3594588", "Filaretovo",
"3599560", "Bezdenitsa",
"3597423", "Kolarovo\,\ Blag\.",
"3599327", "Chuprene",
"3593702", "Tsareva\ polyana",
"3596006", "Presian",
"3593513", "Malo\ Konare",
"35981264", "Piperkovo",
"3593747", "Tatarevo\,\ Hask\.",
"3596148", "Pavel",
"35930476", "Selcha",
"35984462", "Ostrovo",
"35935392", "Dyulevo\,\ Pazardzhik",
"35977226", "Debeli\ lag",
"3593769", "Oreshets\,\ Hask\.",
"3594773", "Okop",
"3594551", "Byala\,\ Sliven",
"3597157", "Sarantsi",
"3599553", "Prevala",
"3596908", "Glogovo",
"3599174", "Gorni\ Vadin",
"359537", "Novi\ pazar\,\ Shumen",
"3598424", "Tsar\ Kaloyan\,\ Razgrad",
"3597720", "Priboy",
"3594364", "Osetenovo",
"35969614", "Gorno\ trape",
"3596548", "Debovo",
"3599319", "Gamzovo",
"3595746", "Belgun",
"3596990", "Malak\ izvor\,\ Lovech",
"3593113", "Branipole",
"3593722", "Mineralni\ bani\,\ Hask\.",
"3596026", "Makariopolsko",
"3599160", "Glozhene\,\ Vratsa",
"3599342", "Inovo",
"3593020", "Davidkovo",
"359725", "Elin\ Pelin",
"35941355", "Yavorovo",
"3595320", "Pet\ mogili\,\ Shumen",
"3593166", "Byala\ reka\,\ Plovdiv",
"359777", "Radomir",
"35984393", "Vazovo",
"3593193", "Borets",
"3596910", "Malinovo",
"3599548", "Krapchene",
"3598691", "Silistra",
"3595125", "Gradinarovo",
"3596553", "Oryahovitsa\,\ Pleven",
"3595149", "Golitsa",
"3596043", "Dolno\ Novkovo",
"35951106", "Osenovo\,\ Varna",
"3596174", "Draganovo\,\ V\.\ Tarnovo",
"35930414", "Devin",
"3595945", "Dobromir",
"3595112", "Beloslav",
"3595723", "Gurkovo\,\ Dobr\.",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+359|\D)//g;
      my $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;