#ifndef RSP_H
#define RSP_H

#include "Types.h"

typedef struct
{
	u32 PC[18], PCi, busy, halt, close, uc_start, uc_dstart, cmd, nextCmd;
	s32 count;
	bool bLLE;
	char romname[21];
	wchar_t pluginpath[PLUGIN_PATH_SIZE];
} RSPInfo;

extern RSPInfo __RSP;

extern u32 DepthClearColor;

#define RSP_SegmentToPhysical( segaddr ) ((gSP.segment[(segaddr >> 24) & 0x0F] + (segaddr & RDRAMSize)) & RDRAMSize)

void RSP_Init(void);
void RSP_ProcessDList(void);
void RSP_LoadMatrix( f32 mtx[4][4], u32 address );
void RSP_CheckDLCounter(void);

#endif
