# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.reader_algorithm import ReaderAlgorithm


class ParallelReader(ReaderAlgorithm):
    r"""
    ParallelReader - Superclass for algorithms that are parallel aware
    
    Superclass: ReaderAlgorithm
    
    ParallelReader is a ReaderAlgorithm subclass that provides a
    specialized API to develop readers that are parallel aware (i.e. can
    handle piece requests) but do not natively support time series. This
    reader adds support for file series in order to support time series.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkParallelReader, obj, update, **traits)
    
    def _get_current_file_name(self):
        return self._vtk_obj.GetCurrentFileName()
    current_file_name = traits.Property(_get_current_file_name, desc=\
        r"""
        Returns the filename that was last loaded by the reader. This is
        set internally in read_mesh()
        """
    )

    def get_file_name(self, *args):
        """
        get_file_name(self, i:int) -> str
        C++: const char *get_file_name(int i)
        Returns a particular filename stored by the reader.
        """
        ret = self._wrap_call(self._vtk_obj.GetFileName, *args)
        return ret

    def _get_number_of_file_names(self):
        return self._vtk_obj.GetNumberOfFileNames()
    number_of_file_names = traits.Property(_get_number_of_file_names, desc=\
        r"""
        Returns the number of filenames stored by the reader.
        """
    )

    def add_file_name(self, *args):
        """
        add_file_name(self, fname:str) -> None
        C++: void add_file_name(const char *fname)
        Add a filename to be read. Since this superclass handles file
        series to support time, multiple filenames can be added. Note
        that the time values are either integers growing sequentially, or
        are obtained from individual files as supported by the subclass.
        """
        ret = self._wrap_call(self._vtk_obj.AddFileName, *args)
        return ret

    def clear_file_names(self):
        """
        clear_file_names(self) -> None
        C++: void clear_file_names()
        Removes all filenames stored by the reader.
        """
        ret = self._vtk_obj.ClearFileNames()
        return ret
        

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ParallelReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ParallelReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit ParallelReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ParallelReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

