/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File EditorButton.h
// Baudouin Raoult - ECMWF Oct 99

#ifndef EditorButton_H
#define EditorButton_H

#ifndef EditorTool_H
#include "EditorTool.h"
#endif

#ifndef EditorToolFactory_H
#include "EditorToolFactory.h"
#endif


template<class E>
class EditorButton : public EditorTool {
public:

	typedef void (E::*Proc)();

// -- Exceptions
	// None

// -- Contructors

	EditorButton(E&,const string&,Proc);

// -- Destructor

	virtual ~EditorButton(); 

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	EditorButton(const EditorButton<E>&);
	EditorButton<E>& operator=(const EditorButton<E>&);

// -- Members


	E&   editor_;
	Proc proc_;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static void activateCB(Widget,XtPointer,XtPointer);

// -- Friends

	//friend ostream& operator<<(ostream& s,const EditorButton& p)
	//	{ p.print(s); return s; }

};


template<class E>
class EditorButtonMaker : public EditorToolFactory {

	typedef void (E::*Proc)();
	Proc proc_;
	
	EditorTool* make(Editor* e,const string& name)
    {
        E* a = dynamic_cast<E*>(e);
        return a ? new EditorButton<E>(*a,name,proc_) : 0;
    }

public:
    EditorButtonMaker(const string& name,Proc p,int n) : 
		EditorToolFactory(name,n),
		proc_(p) {}
};

#ifdef H_INCLUDES_CC
#include "EditorButton.cc"
#endif

#endif
