;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; index2int.scm
;;
;; conversions from index to int
;;
;; $Id: index2int.scm 2156 2008-01-25 13:25:12Z schimans $
;;
;; Markus Sauermann
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(exload "train/index.scm")
(exload "train/int.scm")



(add-program-constant
 "IndexToInt" (py "index=>int") 1 'const 1)

(add-computation-rule (pt "IndexToInt Begin") (pt "IZero"))
(add-computation-rule (pt "IndexToInt (Next i)") (pt "(IndexToInt i)/+(Ipos One)"))

(set-goal (pf "all i1,i2. IndexToInt (i1$+i2) = IndexToInt i1/+IndexToInt i2"))
(assume "i")
(ind)
(prop)
(assume "i1" 1)
(ng)
(simp 1)
(simp "<-" "intPlusAssoc")
(prop)
(save "indexintPlus")

(set-goal (pf "all p ex i. (Ipos p) = (IndexToInt i)"))
(ind)
(ex-intro (pt "Next Begin"))
(use "Truth-Axiom")
(assume "p" 1)
(by-assume-with 1 "i2" 2)
(ex-intro (pt "i2$+i2"))
(simp "indexintPlus")
(simp "<-" 2)
(ng)
(simp "posConstructors")
(use "Truth-Axiom")
(assume "p" 1)
(by-assume-with 1 "i2" 2)
(ex-intro (pt "Next(i2$+i2)"))
(ng)
(simp "indexintPlus")
(simp "<-" 2)
(ng)
(simp "posConstructors")
(use "Truth-Axiom")
(save "intPosExIndex")

(set-goal (pf "all z1,z2. intLeq z1 z2 -> ex i. z2/-z1= IndexToInt i"))
(assume "z1" "z2" 1)
(cases (pt "z1=z2"))
(assume 2)
(ex-intro (pt "Begin"))
(simp 2)
(use "Truth-Axiom")
(assume 2)
(inst-with "intExPosDiff" (pt "z1") (pt "z2") "?")
(by-assume-with 3 "p" 4)
(simp 4)
(use "intPosExIndex")
(use "intLeqNotEqual")
(use 1)
(use 2)
(save "intLeqExIndex")
;(pp(nt (proof-to-extracted-term (current-proof))))


(set-goal (pf "all i. intLeq IZero (IndexToInt i)"))
(ind)
(use "Truth-Axiom")
(assume "i" 1)
(use "intLeqTrans" (pt "IndexToInt i"))
(use 1)
(ng)
(use "intPlusLessLeq")
(save "indexIntLeqZero")


(set-goal (pf "all i1,i2. intLess (IndexToInt i1) (IndexToInt i2) = indexLess i1 i2 &
                          intLeq  (IndexToInt i1) (IndexToInt i2) = indexLeq  i1 i2"))
(ind)
(cases)
(search)
(assume "i2")
(ng)
(split)
(simp "<-" "intIdLessLeqPred" (pt "Ineg One"))
(ng)
(simp "<-" "intHelper2")
(simp "intPlusMinus")
(simp (pf "intLess(Ineg One)(IndexToInt i2)"))
(use "Truth-Axiom")
(use "intLessLeqTrans" (pt "IZero"))
(use "Truth-Axiom")
(use "indexIntLeqZero")
(simp (pf "intLeq IZero(IndexToInt i2/+Ipos One)"))
(use "Truth-Axiom")
(simp "<-" "intIdLessLeqPred" (pt "Ineg One"))
(ng)
(simp "<-" "intHelper2")
(simp "intPlusMinus")
(use "intLeqTrans" (pt "IZero"))
(use "Truth-Axiom")
(use "indexIntLeqZero")
(assume "i1" "IV")
(cases)
(split)
(ng)
(simp (pf "intLess(IndexToInt i1/+Ipos One)IZero -> F"))
(use "Truth-Axiom")
(assume 2)
(use (pf "intLess IZero IZero"))
(use "intLessTrans" (pt "(IndexToInt i1/+Ipos One)"))
(simp "<-" "intIdLessLeqPred" (pt "Ineg One"))
(ng)
(simp "<-" "intHelper2")
(simp "intPlusMinus")
(simp (pf "intLess(Ineg One)(IndexToInt i1)"))
(use "Truth-Axiom")
(use "intLessLeqTrans" (pt "IZero"))
(use "Truth-Axiom")
(use "indexIntLeqZero")
(use 2)
(ng)
(simp (pf "intLeq(IndexToInt i1/+Ipos One)IZero -> F"))
(use "Truth-Axiom")
(assume 2)
(use (pf "intLess IZero IZero"))
(use "intLessLeqTrans" (pt "(IndexToInt i1/+Ipos One)"))
(simp "<-" "intIdLessLeqPred" (pt "Ineg One"))
(ng)
(simp "<-" "intHelper2")
(simp "intPlusMinus")
(use "intLessLeqTrans" (pt "IZero"))
(use "Truth-Axiom")
(use "indexIntLeqZero")
(use 2)
(assume "i2")
(ng)
(simp "intIdLessLeqPred")
(simp "intIdLessLeqPred")
(use "IV")
(save "indexIntLessLeqBijection")


