/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import sharpen.core.Annotations;
import sharpen.core.Bindings;
import sharpen.core.CRefBuilder;
import sharpen.core.CSAnonymousClassBuilder;
import sharpen.core.Configuration;
import sharpen.core.DocumentationOverlay;
import sharpen.core.Mappings;
import sharpen.core.MemberKind;
import sharpen.core.NameScope;
import sharpen.core.NamingStrategy;
import sharpen.core.NonStaticNestedClassBuilder;
import sharpen.core.PreserveFullyQualifiedNamesState;
import sharpen.core.SharpenAnnotations;
import sharpen.core.WarningHandler;
import sharpen.core.csharp.ast.CSArrayCreationExpression;
import sharpen.core.csharp.ast.CSArrayInitializerExpression;
import sharpen.core.csharp.ast.CSArrayTypeReference;
import sharpen.core.csharp.ast.CSAttribute;
import sharpen.core.csharp.ast.CSBaseExpression;
import sharpen.core.csharp.ast.CSBlock;
import sharpen.core.csharp.ast.CSBoolLiteralExpression;
import sharpen.core.csharp.ast.CSBreakStatement;
import sharpen.core.csharp.ast.CSCaseClause;
import sharpen.core.csharp.ast.CSCastExpression;
import sharpen.core.csharp.ast.CSCatchClause;
import sharpen.core.csharp.ast.CSCharLiteralExpression;
import sharpen.core.csharp.ast.CSClass;
import sharpen.core.csharp.ast.CSClassModifier;
import sharpen.core.csharp.ast.CSCompilationUnit;
import sharpen.core.csharp.ast.CSConditionalExpression;
import sharpen.core.csharp.ast.CSConstructor;
import sharpen.core.csharp.ast.CSConstructorInvocationExpression;
import sharpen.core.csharp.ast.CSConstructorModifier;
import sharpen.core.csharp.ast.CSContinueStatement;
import sharpen.core.csharp.ast.CSDeclarationExpression;
import sharpen.core.csharp.ast.CSDeclarationStatement;
import sharpen.core.csharp.ast.CSDestructor;
import sharpen.core.csharp.ast.CSDoStatement;
import sharpen.core.csharp.ast.CSDocNode;
import sharpen.core.csharp.ast.CSDocTagNode;
import sharpen.core.csharp.ast.CSDocTextNode;
import sharpen.core.csharp.ast.CSDocTextOverlay;
import sharpen.core.csharp.ast.CSEnum;
import sharpen.core.csharp.ast.CSEvent;
import sharpen.core.csharp.ast.CSExpression;
import sharpen.core.csharp.ast.CSExpressionStatement;
import sharpen.core.csharp.ast.CSExpressionVisitor;
import sharpen.core.csharp.ast.CSField;
import sharpen.core.csharp.ast.CSFieldModifier;
import sharpen.core.csharp.ast.CSForEachStatement;
import sharpen.core.csharp.ast.CSForStatement;
import sharpen.core.csharp.ast.CSGotoStatement;
import sharpen.core.csharp.ast.CSIfStatement;
import sharpen.core.csharp.ast.CSIndexedExpression;
import sharpen.core.csharp.ast.CSInfixExpression;
import sharpen.core.csharp.ast.CSInterface;
import sharpen.core.csharp.ast.CSLabelStatement;
import sharpen.core.csharp.ast.CSLineComment;
import sharpen.core.csharp.ast.CSLockStatement;
import sharpen.core.csharp.ast.CSMacro;
import sharpen.core.csharp.ast.CSMacroExpression;
import sharpen.core.csharp.ast.CSMacroTypeReference;
import sharpen.core.csharp.ast.CSMember;
import sharpen.core.csharp.ast.CSMemberReferenceExpression;
import sharpen.core.csharp.ast.CSMetaMember;
import sharpen.core.csharp.ast.CSMethod;
import sharpen.core.csharp.ast.CSMethodBase;
import sharpen.core.csharp.ast.CSMethodInvocationExpression;
import sharpen.core.csharp.ast.CSMethodModifier;
import sharpen.core.csharp.ast.CSNode;
import sharpen.core.csharp.ast.CSNullLiteralExpression;
import sharpen.core.csharp.ast.CSNumberLiteralExpression;
import sharpen.core.csharp.ast.CSParameterized;
import sharpen.core.csharp.ast.CSParenthesizedExpression;
import sharpen.core.csharp.ast.CSPostfixExpression;
import sharpen.core.csharp.ast.CSPrefixExpression;
import sharpen.core.csharp.ast.CSProperty;
import sharpen.core.csharp.ast.CSReferenceExpression;
import sharpen.core.csharp.ast.CSRemovedExpression;
import sharpen.core.csharp.ast.CSReturnStatement;
import sharpen.core.csharp.ast.CSStatement;
import sharpen.core.csharp.ast.CSStringLiteralExpression;
import sharpen.core.csharp.ast.CSStruct;
import sharpen.core.csharp.ast.CSSwitchStatement;
import sharpen.core.csharp.ast.CSThisExpression;
import sharpen.core.csharp.ast.CSThrowStatement;
import sharpen.core.csharp.ast.CSTryStatement;
import sharpen.core.csharp.ast.CSType;
import sharpen.core.csharp.ast.CSTypeDeclaration;
import sharpen.core.csharp.ast.CSTypeParameter;
import sharpen.core.csharp.ast.CSTypeParameterProvider;
import sharpen.core.csharp.ast.CSTypeReference;
import sharpen.core.csharp.ast.CSTypeReferenceExpression;
import sharpen.core.csharp.ast.CSTypeofExpression;
import sharpen.core.csharp.ast.CSUncheckedExpression;
import sharpen.core.csharp.ast.CSUsing;
import sharpen.core.csharp.ast.CSVariableDeclaration;
import sharpen.core.csharp.ast.CSVisibility;
import sharpen.core.csharp.ast.CSWhileStatement;
import sharpen.core.csharp.ast.CSharpCode;
import sharpen.core.framework.ASTResolver;
import sharpen.core.framework.ASTUtility;
import sharpen.core.framework.BindingUtils;
import sharpen.core.framework.ByRef;
import sharpen.core.framework.DynamicVariable;
import sharpen.core.framework.Environments;
import sharpen.core.framework.Function;
import sharpen.core.framework.JavadocUtility;
import sharpen.core.framework.StaticImports;
import sharpen.core.framework.Types;

public class CSharpBuilder
extends ASTVisitor {
    private static final String JAVA_LANG_VOID_TYPE = "java.lang.Void.TYPE";
    private static final String JAVA_LANG_BOOLEAN_TYPE = "java.lang.Boolean.TYPE";
    private static final String JAVA_LANG_CHARACTER_TYPE = "java.lang.Character.TYPE";
    private static final String JAVA_LANG_INTEGER_TYPE = "java.lang.Integer.TYPE";
    private static final String JAVA_LANG_LONG_TYPE = "java.lang.Long.TYPE";
    private static final String JAVA_LANG_BYTE_TYPE = "java.lang.Byte.TYPE";
    private static final String JAVA_LANG_SHORT_TYPE = "java.lang.Short.TYPE";
    private static final String JAVA_LANG_FLOAT_TYPE = "java.lang.Float.TYPE";
    private static final String JAVA_LANG_DOUBLE_TYPE = "java.lang.Double.TYPE";
    private static final CSTypeReference OBJECT_TYPE_REFERENCE = new CSTypeReference("object");
    private final CSCompilationUnit _compilationUnit;
    protected CSTypeDeclaration _currentType;
    private CSBlock _currentBlock;
    private CSExpression _currentExpression;
    protected CSMethodBase _currentMethod;
    protected BodyDeclaration _currentBodyDeclaration;
    private CSLabelStatement _currentContinueLabel;
    private static final Pattern SUMMARY_CLOSURE_PATTERN = Pattern.compile("\\.(\\s|$)");
    private static final Pattern HTML_ANCHOR_PATTERN = Pattern.compile("<([aA])\\s+.+>");
    protected CompilationUnit _ast;
    protected Configuration _configuration;
    private ASTResolver _resolver;
    private IVariableBinding _currentExceptionVariable;
    private final DynamicVariable<Boolean> _ignoreExtends = new DynamicVariable<Boolean>(Boolean.FALSE);
    private List<Initializer> _instanceInitializers = new ArrayList<Initializer>();
    private Stack<Set<String>> _blockVariables = new Stack();
    private Stack<Set<String>> _localBlockVariables = new Stack();
    private Stack<HashMap<String, String>> _renamedVariables = new Stack();
    private ITypeBinding _currentExpectedType;

    protected NamingStrategy namingStrategy() {
        return this._configuration.getNamingStrategy();
    }

    protected WarningHandler warningHandler() {
        return this._configuration.getWarningHandler();
    }

    public CSharpBuilder() {
        this._configuration = Environments.my(Configuration.class);
        this._ast = Environments.my(CompilationUnit.class);
        this._resolver = Environments.my(ASTResolver.class);
        this._compilationUnit = Environments.my(CSCompilationUnit.class);
        this._compilationUnit.addUsing(new CSUsing("Sharpen"));
    }

    protected CSharpBuilder(CSharpBuilder other) {
        this._configuration = other._configuration;
        this._ast = other._ast;
        this._resolver = other._resolver;
        this._compilationUnit = other._compilationUnit;
        this._currentType = other._currentType;
        this._currentBlock = other._currentBlock;
        this._currentExpression = other._currentExpression;
        this._currentMethod = other._currentMethod;
        this._currentBodyDeclaration = other._currentBodyDeclaration;
    }

    public void setSourceCompilationUnit(CompilationUnit ast) {
        this._ast = ast;
    }

    public void run() {
        if (this.warningHandler() == null || this._ast == null) {
            throw new IllegalStateException();
        }
        this._ast.accept((ASTVisitor)this);
        this.visit(this._ast.getCommentList());
    }

    public boolean visit(LineComment node) {
        this._compilationUnit.addComment(new CSLineComment(node.getStartPosition(), this.getText(node.getStartPosition(), node.getLength())));
        return false;
    }

    private String getText(int startPosition, int length) {
        try {
            return ((ICompilationUnit)this._ast.getJavaElement()).getBuffer().getText(startPosition, length);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    public CSCompilationUnit compilationUnit() {
        return this._compilationUnit;
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        if (!SharpenAnnotations.hasIgnoreAnnotation((BodyDeclaration)node)) {
            final CSEnum theEnum = new CSEnum(this.typeName((AbstractTypeDeclaration)node));
            this.mapVisibility((BodyDeclaration)node, theEnum);
            this.mapJavadoc((BodyDeclaration)node, theEnum);
            this.addType(node.resolveBinding(), theEnum);
            node.accept(new ASTVisitor(){

                public boolean visit(EnumConstantDeclaration node) {
                    theEnum.addValue(CSharpBuilder.this.identifier(node.getName()));
                    return false;
                }

                public boolean visit(MethodDeclaration node) {
                    if (node.isConstructor() && CSharpBuilder.this.isPrivate(node)) {
                        return false;
                    }
                    CSharpBuilder.this.unsupportedConstruct((ASTNode)node, "Enum can contain only fields and a private constructor.");
                    return false;
                }
            });
            return false;
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        return false;
    }

    public boolean visit(LabeledStatement node) {
        String identifier = node.getLabel().getIdentifier();
        this._currentContinueLabel = new CSLabelStatement(this.continueLabel(identifier));
        try {
            node.getBody().accept((ASTVisitor)this);
        }
        finally {
            this._currentContinueLabel = null;
        }
        this.addStatement(new CSLabelStatement(this.breakLabel(identifier)));
        return false;
    }

    private String breakLabel(String identifier) {
        return String.valueOf(identifier) + "_break";
    }

    private String continueLabel(String identifier) {
        return String.valueOf(identifier) + "_continue";
    }

    public boolean visit(SuperFieldAccess node) {
        this.notImplemented((ASTNode)node);
        return false;
    }

    public boolean visit(MemberRef node) {
        this.notImplemented((ASTNode)node);
        return false;
    }

    public boolean visit(WildcardType node) {
        this.notImplemented((ASTNode)node);
        return false;
    }

    private void notImplemented(ASTNode node) {
        throw new IllegalArgumentException(String.valueOf(this.sourceInformation(node)) + ": " + node.toString());
    }

    public boolean visit(PackageDeclaration node) {
        String namespace = node.getName().toString();
        this._compilationUnit.namespace(this.mappedNamespace(namespace));
        this.processDisableTags(node, (CSNode)this._compilationUnit);
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        CSAnonymousClassBuilder builder = this.mapAnonymousClass(node);
        this.pushExpression(builder.createConstructorInvocation());
        return false;
    }

    private CSAnonymousClassBuilder mapAnonymousClass(AnonymousClassDeclaration node) {
        CSAnonymousClassBuilder builder = new CSAnonymousClassBuilder(this, node);
        this._currentType.addMember(builder.type());
        return builder;
    }

    public boolean visit(final TypeDeclaration node) {
        if (this.processIgnoredType(node)) {
            return false;
        }
        if (this.processEnumType(node)) {
            return false;
        }
        try {
            Environments.my(NameScope.class).enterTypeDeclaration(node);
            this._ignoreExtends.using((Boolean)this.ignoreExtends(node), new Runnable(){

                @Override
                public void run() {
                    ITypeBinding binding = node.resolveBinding();
                    if (!binding.isNested()) {
                        CSharpBuilder.this.processTypeDeclaration(node);
                        return;
                    }
                    if (CSharpBuilder.this.isNonStaticNestedType(binding)) {
                        CSharpBuilder.this.processNonStaticNestedTypeDeclaration(node);
                        return;
                    }
                    new CSharpBuilder(CSharpBuilder.this).processTypeDeclaration(node);
                }
            });
        }
        finally {
            Environments.my(NameScope.class).leaveTypeDeclaration(node);
        }
        return false;
    }

    private boolean processEnumType(TypeDeclaration node) {
        if (!this.isEnum(node)) {
            return false;
        }
        final CSEnum theEnum = new CSEnum(this.typeName((AbstractTypeDeclaration)node));
        this.mapVisibility((BodyDeclaration)node, theEnum);
        this.mapJavadoc((BodyDeclaration)node, theEnum);
        this.addType(node.resolveBinding(), theEnum);
        node.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationFragment node) {
                theEnum.addValue(CSharpBuilder.this.identifier(node.getName()));
                return false;
            }

            public boolean visit(MethodDeclaration node) {
                if (node.isConstructor() && CSharpBuilder.this.isPrivate(node)) {
                    return false;
                }
                CSharpBuilder.this.unsupportedConstruct((ASTNode)node, "Enum can contain only fields and a private constructor.");
                return false;
            }
        });
        return true;
    }

    protected boolean isPrivate(MethodDeclaration node) {
        return Modifier.isPrivate((int)node.getModifiers());
    }

    private boolean isEnum(TypeDeclaration node) {
        return CSharpBuilder.containsJavadoc((BodyDeclaration)node, "@sharpen.enum");
    }

    private boolean processIgnoredType(TypeDeclaration node) {
        if (!this.hasIgnoreOrRemoveAnnotation(node)) {
            return false;
        }
        if (this.isMainType(node)) {
            this.compilationUnit().ignore(true);
        }
        return true;
    }

    private boolean hasIgnoreOrRemoveAnnotation(TypeDeclaration node) {
        return SharpenAnnotations.hasIgnoreAnnotation((BodyDeclaration)node) || this.hasRemoveAnnotation((BodyDeclaration)node);
    }

    private void processNonStaticNestedTypeDeclaration(TypeDeclaration node) {
        new NonStaticNestedClassBuilder(this, node);
    }

    protected CSTypeDeclaration processTypeDeclaration(TypeDeclaration node) {
        CSTypeDeclaration type = this.mapTypeDeclaration(node);
        this.processDisabledType(node, this.isMainType(node) ? this._compilationUnit : type);
        if (this._configuration.shouldMakePartial(node.getName().getFullyQualifiedName())) {
            type.partial(true);
        }
        ITypeBinding typeBinding = node.resolveBinding();
        this.addType(typeBinding, type);
        this.mapSuperTypes(node, type);
        this.mapVisibility((BodyDeclaration)node, type);
        this.adjustVisibility(typeBinding.getSuperclass(), type);
        this.mapDocumentation((BodyDeclaration)node, type);
        this.processConversionJavadocTags(node, type);
        this.mapMembers(node, type);
        this.autoImplementCloneable(node, type);
        this.moveInitializersDependingOnThisReferenceToConstructor(type);
        if (this._configuration.junitConversion() && this.isTestFixture(typeBinding)) {
            type.addAttribute(new CSAttribute("NUnit.Framework.TestFixture"));
            type.visibility(CSVisibility.Public);
        }
        return type;
    }

    private void processDisabledType(TypeDeclaration node, CSNode type) {
        String expression = this._configuration.conditionalCompilationExpressionFor(this.packageNameFor(node));
        if (expression != null) {
            this.compilationUnit().addEnclosingIfDef(expression);
        }
        this.processDisableTags((BodyDeclaration)node, type);
    }

    private String packageNameFor(TypeDeclaration node) {
        ITypeBinding type = node.resolveBinding();
        return type.getPackage().getName();
    }

    protected void flushInstanceInitializers(CSTypeDeclaration type, int startStatementIndex) {
        if (this._instanceInitializers.isEmpty()) {
            return;
        }
        this.ensureConstructorsFor(type);
        int initializerIndex = startStatementIndex;
        for (Initializer node : this._instanceInitializers) {
            CSBlock body = this.mapInitializer(node);
            for (CSConstructor ctor : type.constructors()) {
                if (ctor.isStatic() || this.hasChainedThisInvocation(ctor)) continue;
                ctor.body().addStatement(initializerIndex, body);
            }
            ++initializerIndex;
        }
        this._instanceInitializers.clear();
    }

    private CSBlock mapInitializer(Initializer node) {
        CSConstructor template = new CSConstructor();
        this.visitBodyDeclarationBlock((BodyDeclaration)node, node.getBody(), template);
        CSBlock body = template.body();
        return body;
    }

    private boolean hasChainedThisInvocation(CSConstructor ctor) {
        CSConstructorInvocationExpression chained = ctor.chainedConstructorInvocation();
        return chained != null && chained.expression() instanceof CSThisExpression;
    }

    private void moveInitializersDependingOnThisReferenceToConstructor(CSTypeDeclaration type) {
        HashSet<String> memberNames = this.memberNameSetFor(type);
        int index = 0;
        CSMember[] cSMemberArray = this.copy(type.members());
        int n = cSMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            CSField field;
            CSMember member = cSMemberArray[n2];
            if (member instanceof CSField && this.isDependentOnThisOrMember(field = (CSField)member, memberNames)) {
                this.moveFieldInitializerToConstructors(field, type, index++);
            }
            ++n2;
        }
    }

    private HashSet<String> memberNameSetFor(CSTypeDeclaration type) {
        HashSet<String> members = new HashSet<String>();
        for (CSMember member : type.members()) {
            if (member instanceof CSType || this.isStatic(member)) continue;
            members.add(member.name());
        }
        return members;
    }

    private boolean isStatic(CSMember member) {
        if (member instanceof CSField) {
            return this.isStatic((CSField)member);
        }
        if (member instanceof CSMethod) {
            return this.isStatic((CSMethod)member);
        }
        return false;
    }

    private boolean isStatic(CSMethod method) {
        return method.modifier() == CSMethodModifier.Static;
    }

    private boolean isStatic(CSField member) {
        Set<CSFieldModifier> fieldModifiers = member.modifiers();
        return fieldModifiers.contains((Object)CSFieldModifier.Static) || fieldModifiers.contains((Object)CSFieldModifier.Const);
    }

    private CSMember[] copy(List<CSMember> list) {
        return list.toArray(new CSMember[0]);
    }

    private boolean isDependentOnThisOrMember(CSField field, final Set<String> fields) {
        if (field.initializer() == null) {
            return false;
        }
        final ByRef<Boolean> foundThisReference = new ByRef<Boolean>(false);
        field.initializer().accept(new CSExpressionVisitor(){

            @Override
            public void visit(CSThisExpression node) {
                foundThisReference.value = true;
            }

            @Override
            public void visit(CSReferenceExpression node) {
                if (fields.contains(node.name())) {
                    foundThisReference.value = true;
                }
            }
        });
        return (Boolean)foundThisReference.value;
    }

    private void moveFieldInitializerToConstructors(CSField field, CSTypeDeclaration type, int index) {
        CSExpression initializer = field.initializer();
        for (CSConstructor ctor : this.ensureConstructorsFor(type)) {
            ctor.body().addStatement(index, this.newAssignment(field, initializer));
        }
        field.initializer(null);
    }

    private CSExpression newAssignment(CSField field, CSExpression initializer) {
        return CSharpCode.newAssignment(CSharpCode.newReference(field), initializer);
    }

    private Iterable<CSConstructor> ensureConstructorsFor(CSTypeDeclaration type) {
        List<CSConstructor> ctors = type.constructors();
        if (!ctors.isEmpty()) {
            return ctors;
        }
        return Collections.singletonList(this.addDefaultConstructor(type));
    }

    private CSConstructor addDefaultConstructor(CSTypeDeclaration type) {
        CSConstructor ctor = CSharpCode.newPublicConstructor();
        type.addMember(ctor);
        return ctor;
    }

    private void autoImplementCloneable(TypeDeclaration node, CSTypeDeclaration type) {
        if (!this.implementsCloneable(type)) {
            return;
        }
        CSMethod clone = new CSMethod("System.ICloneable.Clone");
        clone.returnType(OBJECT_TYPE_REFERENCE);
        clone.body().addStatement(new CSReturnStatement(-1, new CSMethodInvocationExpression(new CSReferenceExpression("MemberwiseClone"), new CSExpression[0])));
        type.addMember(clone);
    }

    private boolean implementsCloneable(CSTypeDeclaration node) {
        for (CSTypeReferenceExpression typeRef : node.baseTypes()) {
            if (!typeRef.toString().equals("System.ICloneable")) continue;
            return true;
        }
        return false;
    }

    private void mapSuperTypes(TypeDeclaration node, CSTypeDeclaration type) {
        if (!this._ignoreExtends.value().booleanValue()) {
            this.mapSuperClass(node, type);
        }
        if (!this.ignoreImplements(node)) {
            this.mapSuperInterfaces(node, type);
        }
    }

    private boolean ignoreImplements(TypeDeclaration node) {
        return CSharpBuilder.containsJavadoc((BodyDeclaration)node, "@sharpen.ignore.implements");
    }

    private boolean ignoreExtends(TypeDeclaration node) {
        return CSharpBuilder.containsJavadoc((BodyDeclaration)node, "@sharpen.ignore.extends");
    }

    private void processConversionJavadocTags(TypeDeclaration node, CSTypeDeclaration type) {
        this.processPartialTagElement(node, type);
    }

    private CSTypeDeclaration mapTypeDeclaration(TypeDeclaration node) {
        CSTypeDeclaration type = this.typeDeclarationFor(node);
        type.startPosition(node.getStartPosition());
        type.sourceLength(node.getLength());
        this.mapTypeParameters(node.typeParameters(), type);
        return this.checkForMainType(node, type);
    }

    private void mapTypeParameters(List typeParameters, CSTypeParameterProvider type) {
        for (Object item : typeParameters) {
            type.addTypeParameter(this.mapTypeParameter((TypeParameter)item));
        }
    }

    private CSTypeParameter mapTypeParameter(TypeParameter item) {
        ITypeBinding superc;
        CSTypeParameter tp = new CSTypeParameter(this.identifier(item.getName()));
        ITypeBinding tb = item.resolveBinding();
        if (tb != null && (superc = this.mapTypeParameterExtendedType(tb)) != null) {
            tp.superClass(this.mappedTypeReference(superc));
        }
        return tp;
    }

    private CSTypeDeclaration typeDeclarationFor(TypeDeclaration node) {
        String typeName = this.typeName((AbstractTypeDeclaration)node);
        if (node.isInterface()) {
            if (this.isValidCSInterface(node.resolveBinding())) {
                return new CSInterface(this.processInterfaceName(node));
            }
            return new CSClass(typeName, CSClassModifier.Abstract);
        }
        if (this.isStruct(node)) {
            return new CSStruct(typeName);
        }
        return new CSClass(typeName, this.mapClassModifier(node.getModifiers()));
    }

    private String typeName(AbstractTypeDeclaration node) {
        String renamed = this.annotatedRenaming((BodyDeclaration)node);
        if (renamed != null) {
            return renamed;
        }
        renamed = this.mappedTypeName(node.resolveBinding());
        if (renamed != null) {
            int i = renamed.lastIndexOf(46);
            if (i != -1) {
                return renamed.substring(i + 1);
            }
            return renamed;
        }
        return node.getName().toString();
    }

    private boolean isStruct(TypeDeclaration node) {
        return CSharpBuilder.containsJavadoc((BodyDeclaration)node, "@sharpen.struct");
    }

    private CSTypeDeclaration checkForMainType(TypeDeclaration node, CSTypeDeclaration type) {
        if (this.isMainType(node)) {
            this.setCompilationUnitElementName(type.name());
        }
        return type;
    }

    private void setCompilationUnitElementName(String name) {
        this._compilationUnit.elementName(String.valueOf(name) + ".cs");
    }

    private String processInterfaceName(TypeDeclaration node) {
        String name = node.getName().getFullyQualifiedName();
        return this.interfaceName(name);
    }

    private boolean isMainType(TypeDeclaration node) {
        return node.isPackageMemberTypeDeclaration() && Modifier.isPublic((int)node.getModifiers());
    }

    private void mapSuperClass(TypeDeclaration node, CSTypeDeclaration type) {
        if (this.handledExtends(node, type)) {
            return;
        }
        if (node.getSuperclassType() == null) {
            return;
        }
        ITypeBinding superClassBinding = node.getSuperclassType().resolveBinding();
        if (superClassBinding == null) {
            this.unresolvedTypeBinding((ASTNode)node.getSuperclassType());
        }
        if (!this.isLegacyTestFixtureClass(superClassBinding)) {
            type.addBaseType(this.mappedTypeReference(superClassBinding));
        } else {
            type.addAttribute(new CSAttribute("NUnit.Framework.TestFixture"));
        }
    }

    private boolean isLegacyTestFixtureClass(ITypeBinding type) {
        return this._configuration.junitConversion() && type.getQualifiedName().equals("junit.framework.TestCase");
    }

    private boolean isLegacyTestFixture(ITypeBinding type) {
        if (!this._configuration.junitConversion()) {
            return false;
        }
        if (this.isLegacyTestFixtureClass(type)) {
            return true;
        }
        ITypeBinding base = type.getSuperclass();
        return base != null && this.isLegacyTestFixture(base);
    }

    private boolean isTestFixture(ITypeBinding type) {
        if (Modifier.isAbstract((int)type.getModifiers())) {
            return false;
        }
        return this.hasTests(type);
    }

    private boolean hasTests(ITypeBinding type) {
        boolean legacy = this.isLegacyTestFixture(type);
        IMethodBinding[] iMethodBindingArray = type.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding m = iMethodBindingArray[n2];
            if (this.isTestMethod(m, legacy)) {
                return true;
            }
            ++n2;
        }
        ITypeBinding bt = type.getSuperclass();
        if (bt != null) {
            return this.hasTests(bt);
        }
        return false;
    }

    private boolean isTestMethod(IMethodBinding m, boolean legacy) {
        if (legacy) {
            if (m.getName().startsWith("test") && Modifier.isAbstract((int)m.getModifiers())) {
                return true;
            }
        } else {
            IAnnotationBinding[] iAnnotationBindingArray = m.getAnnotations();
            int n = iAnnotationBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding tag = iAnnotationBindingArray[n2];
                String tagName = tag.getName();
                if (tagName != null && tagName.equals("Test")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean handledExtends(TypeDeclaration node, CSTypeDeclaration type) {
        TagElement replaceExtendsTag = this.javadocTagFor((BodyDeclaration)node, "@sharpen.extends");
        if (replaceExtendsTag == null) {
            return false;
        }
        String baseType = JavadocUtility.singleTextFragmentFrom(replaceExtendsTag);
        type.addBaseType(new CSTypeReference(baseType));
        return true;
    }

    private void mapSuperInterfaces(TypeDeclaration node, CSTypeDeclaration type) {
        ITypeBinding serializable = this.resolveWellKnownType("java.io.Serializable");
        for (Object itf : node.superInterfaceTypes()) {
            Type iface = (Type)itf;
            if (iface.resolveBinding() == serializable) continue;
            type.addBaseType(this.mappedTypeReference(iface));
        }
        if (!type.isInterface() && node.resolveBinding().isSubTypeCompatible(serializable)) {
            type.addAttribute(new CSAttribute("System.Serializable"));
        }
    }

    private ITypeBinding resolveWellKnownType(String typeName) {
        return this._ast.getAST().resolveWellKnownType(typeName);
    }

    private void mapMembers(TypeDeclaration node, CSTypeDeclaration type) {
        CSTypeDeclaration saved = this._currentType;
        this._currentType = type;
        try {
            this.visit(node.bodyDeclarations());
            this.createInheritedAbstractMemberStubs(node);
            this.flushInstanceInitializers(type, 0);
        }
        finally {
            this._currentType = saved;
        }
    }

    private void mapVisibility(BodyDeclaration node, CSMember member) {
        member.visibility(this.mapVisibility(node));
    }

    protected boolean isNonStaticNestedType(ITypeBinding binding) {
        if (binding.isInterface()) {
            return false;
        }
        if (!binding.isNested()) {
            return false;
        }
        return !this.isStatic(binding);
    }

    private boolean isStatic(ITypeBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    private void addType(ITypeBinding binding, CSType type) {
        if (this._currentType != null && !this.isExtractedNestedType(binding)) {
            this._currentType.addMember(type);
        } else {
            this._compilationUnit.addType(type);
        }
    }

    private void mapDocumentation(final BodyDeclaration bodyDecl, final CSMember member) {
        Environments.my(PreserveFullyQualifiedNamesState.class).using(true, new Runnable(){

            @Override
            public void run() {
                if (CSharpBuilder.this.processDocumentationOverlay(member)) {
                    return;
                }
                CSharpBuilder.this.mapJavadoc(bodyDecl, member);
                CSharpBuilder.this.mapDeclaredExceptions(bodyDecl, member);
            }
        });
    }

    private void mapDeclaredExceptions(BodyDeclaration bodyDecl, CSMember member) {
        if (!(bodyDecl instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration method = (MethodDeclaration)bodyDecl;
        this.mapThrownExceptions(method.thrownExceptions(), member);
    }

    private void mapThrownExceptions(List thrownExceptions, CSMember member) {
        for (Object exception : thrownExceptions) {
            this.mapThrownException((Name)exception, member);
        }
    }

    private void mapThrownException(Name exception, CSMember member) {
        String typeName = this.mappedTypeName(exception.resolveTypeBinding());
        if (this.containsExceptionTagWithCRef(member, typeName)) {
            return;
        }
        member.addDoc(this.newTagWithCRef("exception", typeName));
    }

    private boolean containsExceptionTagWithCRef(CSMember member, String cref) {
        for (CSDocNode node : member.docs()) {
            if (!(node instanceof CSDocTagNode) || !cref.equals(((CSDocTagNode)node).getAttribute("cref"))) continue;
            return true;
        }
        return false;
    }

    private void mapJavadoc(BodyDeclaration bodyDecl, CSMember member) {
        Javadoc javadoc = bodyDecl.getJavadoc();
        if (javadoc == null) {
            return;
        }
        this.mapJavadocTags(javadoc, member);
    }

    private boolean processDocumentationOverlay(CSMember node) {
        if (node instanceof CSTypeDeclaration) {
            return this.processTypeDocumentationOverlay((CSTypeDeclaration)node);
        }
        return this.processMemberDocumentationOverlay(node);
    }

    private boolean processMemberDocumentationOverlay(CSMember node) {
        String overlay = this.documentationOverlay().forMember(this.currentTypeQName(), node.signature());
        return this.processDocumentationOverlay(node, overlay);
    }

    private String currentTypeQName() {
        return this.qualifiedName(this._currentType);
    }

    private boolean processTypeDocumentationOverlay(CSTypeDeclaration node) {
        String overlay = this.documentationOverlay().forType(this.qualifiedName(node));
        return this.processDocumentationOverlay(node, overlay);
    }

    private boolean processDocumentationOverlay(CSMember node, String overlay) {
        if (overlay == null) {
            return false;
        }
        node.addDoc(new CSDocTextOverlay(overlay.trim()));
        return true;
    }

    private DocumentationOverlay documentationOverlay() {
        return this._configuration.documentationOverlay();
    }

    private String qualifiedName(CSTypeDeclaration node) {
        if (this.currentNamespace() == null) {
            return node.name();
        }
        return String.valueOf(this.currentNamespace()) + "." + node.name();
    }

    private String currentNamespace() {
        return this._compilationUnit.namespace();
    }

    private void mapJavadocTags(Javadoc javadoc, CSMember member) {
        for (Object tag : javadoc.tags()) {
            try {
                TagElement element = (TagElement)tag;
                String tagName = element.getTagName();
                if (tagName == null) {
                    this.mapJavadocSummary(member, element);
                    continue;
                }
                this.processTagElement(member, element);
            }
            catch (Exception x) {
                this.warning((ASTNode)tag, x.getMessage());
                x.printStackTrace();
            }
        }
    }

    private void processTagElement(CSMember member, TagElement element) {
        if (this.processSemanticallySignificantTagElement(member, element)) {
            return;
        }
        if (!this.isConversionTag(element.getTagName())) {
            member.addDoc(this.mapTagElement(element));
        } else if (this.isAttributeAnnotation(element)) {
            this.processAttribute(member, element);
        } else if (this.isNewAnnotation(element)) {
            member.setNewModifier(true);
        }
    }

    private boolean isAttributeAnnotation(TagElement element) {
        return element.getTagName().equals("@sharpen.attribute");
    }

    private boolean isNewAnnotation(TagElement element) {
        return element.getTagName().equals("@sharpen.new");
    }

    private void processAttribute(CSMember member, TagElement element) {
        String attrType = this.mappedTypeName(JavadocUtility.singleTextFragmentFrom(element));
        CSAttribute attribute = new CSAttribute(attrType);
        member.addAttribute(attribute);
    }

    private boolean processSemanticallySignificantTagElement(CSMember member, TagElement element) {
        if (element.getTagName().equals("@deprecated")) {
            member.removeAttribute("System.Obsolete");
            member.removeAttribute("System.ObsoleteAttribute");
            member.addAttribute(this.obsoleteAttributeFromDeprecatedTagElement(element));
            return true;
        }
        return false;
    }

    private CSAttribute obsoleteAttributeFromDeprecatedTagElement(TagElement element) {
        CSAttribute attribute = new CSAttribute(this.mappedTypeName("System.ObsoleteAttribute"));
        if (element.fragments().isEmpty()) {
            return attribute;
        }
        attribute.addArgument(new CSStringLiteralExpression(this.toLiteralStringForm(this.getWholeText(element))));
        return attribute;
    }

    private String getWholeText(TagElement element) {
        StringBuilder builder = new StringBuilder();
        for (ASTNode fragment : element.fragments()) {
            if (fragment instanceof TextElement) {
                TextElement textElement = (TextElement)fragment;
                String text = textElement.getText();
                this.appendWithSpaceIfRequired(builder, text);
                continue;
            }
            if (fragment instanceof TagElement) {
                builder.append(this.getWholeText((TagElement)fragment));
                continue;
            }
            if (fragment instanceof MethodRef) {
                builder.append(this.mapCRefTarget(fragment));
                continue;
            }
            if (fragment instanceof MemberRef) {
                builder.append(this.mapCRefTarget(fragment));
                continue;
            }
            if (!(fragment instanceof Name)) break;
            builder.append(this.mapCRefTarget(fragment));
        }
        return builder.toString().trim();
    }

    private void appendWithSpaceIfRequired(StringBuilder builder, String text) {
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) != ' ' && !text.startsWith(" ")) {
            builder.append(" ");
        }
        builder.append(text);
    }

    private String toLiteralStringForm(String s) {
        return "@\"" + s.replace("\"", "\"\"") + "\"";
    }

    private boolean isConversionTag(String tagName) {
        return tagName.startsWith("@sharpen.");
    }

    private void processPartialTagElement(TypeDeclaration node, CSTypeDeclaration member) {
        TagElement element = this.javadocTagFor((BodyDeclaration)node, "@sharpen.partial");
        if (element == null) {
            return;
        }
        member.partial(true);
    }

    private TagElement javadocTagFor(PackageDeclaration node, String withName) {
        return JavadocUtility.getJavadocTag(node, withName);
    }

    private TagElement javadocTagFor(BodyDeclaration node, String withName) {
        return JavadocUtility.getJavadocTag(node, withName);
    }

    private void mapJavadocSummary(CSMember member, TagElement element) {
        List<String> summary = this.getFirstSentence(element);
        if (summary != null) {
            CSDocTagNode summaryNode = new CSDocTagNode("summary");
            for (String fragment : summary) {
                summaryNode.addFragment(new CSDocTextNode(fragment));
            }
            member.addDoc(summaryNode);
            member.addDoc(this.createTagNode("remarks", element));
        } else {
            member.addDoc(this.createTagNode("summary", element));
        }
    }

    private List<String> getFirstSentence(TagElement element) {
        LinkedList<String> fragments = new LinkedList<String>();
        for (Object fragment : element.fragments()) {
            if (!(fragment instanceof TextElement)) break;
            TextElement textElement = (TextElement)fragment;
            String text = textElement.getText();
            int index = this.findSentenceClosure(text);
            if (index > -1) {
                fragments.add(text.substring(0, index + 1));
                return fragments;
            }
            fragments.add(text);
        }
        return null;
    }

    private int findSentenceClosure(String text) {
        Matcher matcher = SUMMARY_CLOSURE_PATTERN.matcher(text);
        return matcher.find() ? matcher.start() : -1;
    }

    private CSDocNode mapTagElement(TagElement element) {
        String tagName = element.getTagName();
        if ("@param".equals(tagName)) {
            return this.mapTagParam(element);
        }
        if ("@return".equals(tagName)) {
            return this.createTagNode("returns", element);
        }
        if ("@link".equals(tagName)) {
            return this.mapTagLink(element);
        }
        if ("@throws".equals(tagName)) {
            return this.mapTagThrows(element);
        }
        if ("@see".equals(tagName)) {
            return this.mapTagWithCRef("seealso", element);
        }
        return this.createTagNode(tagName.substring(1), element);
    }

    private CSDocNode mapTagThrows(TagElement element) {
        return this.mapTagWithCRef("exception", element);
    }

    private CSDocNode mapTagLink(TagElement element) {
        return this.mapTagWithCRef("see", element);
    }

    private CSDocNode mapTagWithCRef(String tagName, TagElement element) {
        List fragments = element.fragments();
        if (fragments.isEmpty()) {
            return this.invalidTagWithCRef((ASTNode)element, tagName, element);
        }
        ASTNode linkTarget = (ASTNode)fragments.get(0);
        String cref = this.mapCRefTarget(linkTarget);
        if (cref == null) {
            return this.invalidTagWithCRef(linkTarget, tagName, element);
        }
        CSDocTagNode node = this.newTagWithCRef(tagName, cref);
        if (fragments.size() > 1) {
            if (this.isLinkWithSimpleLabel(fragments, linkTarget)) {
                node.addTextFragment(this.unqualifiedName(cref));
            } else {
                this.collectFragments(node, fragments, 1);
            }
        } else {
            node.addTextFragment(cref.replace("{", "&lt;").replace("}", "&gt;"));
        }
        return node;
    }

    private ASTNode documentedNodeAttachedTo(TagElement element) {
        TagElement attachedToNode = element;
        while (attachedToNode instanceof TagElement || attachedToNode instanceof Javadoc) {
            attachedToNode = attachedToNode.getParent();
        }
        return attachedToNode;
    }

    private CSDocNode invalidTagWithCRef(ASTNode linkTarget, String tagName, TagElement element) {
        this.warning(linkTarget, "Tag '" + element.getTagName() + "' demands a valid cref target.");
        CSDocNode newTag = this.createTagNode(tagName, element);
        return newTag;
    }

    private CSDocTagNode newTagWithCRef(String tagName, String cref) {
        CSDocTagNode node = new CSDocTagNode(tagName);
        node.addAttribute("cref", cref);
        return node;
    }

    private boolean isLinkWithSimpleLabel(List<ASTNode> fragments, ASTNode linkTarget) {
        if (fragments.size() != 2) {
            return false;
        }
        if (!JavadocUtility.isTextFragment(fragments, 1)) {
            return false;
        }
        String link = linkTarget.toString();
        String label = JavadocUtility.textFragment(fragments, 1);
        return label.equals(link) || label.equals(this.unqualifiedName(link));
    }

    private String mapCRefTarget(ASTNode crefTarget) {
        return new CRefBuilder(crefTarget).build();
    }

    private CSDocNode mapTagParam(TagElement element) {
        List fragments = element.fragments();
        if (!(fragments.get(0) instanceof SimpleName)) {
            return new CSDocTagNode("?");
        }
        SimpleName name = (SimpleName)fragments.get(0);
        if (name.resolveBinding() == null) {
            this.warning((ASTNode)name, "Parameter '" + name + "' not found.");
        }
        CSDocTagNode param = this.isPropertyNode(this.documentedNodeAttachedTo(element)) ? new CSDocTagNode("value") : this.newCSDocTag(this.fixIdentifierNameFor(this.identifier(name), element));
        this.collectFragments(param, fragments, 1);
        return param;
    }

    private CSDocTagNode newCSDocTag(String paramName) {
        CSDocTagNode param = new CSDocTagNode("param");
        param.addAttribute("name", paramName);
        return param;
    }

    private boolean isPropertyNode(ASTNode node) {
        if (node.getNodeType() != 31) {
            return false;
        }
        return this.isProperty((MethodDeclaration)node);
    }

    private String fixIdentifierNameFor(String identifier, TagElement element) {
        return this.removeAtSign(identifier);
    }

    private String removeAtSign(String identifier) {
        return identifier.startsWith("@") ? identifier.substring(1) : identifier;
    }

    private void collectFragments(CSDocTagNode node, List fragments, int index) {
        int i = index;
        while (i < fragments.size()) {
            node.addFragment(this.mapTagElementFragment((ASTNode)fragments.get(i)));
            ++i;
        }
    }

    private CSDocNode mapTextElement(TextElement element) {
        String text = element.getText();
        if (HTML_ANCHOR_PATTERN.matcher(text).find()) {
            this.warning((ASTNode)element, "Caution: HTML anchors can result in broken links. Consider using @link instead.");
        }
        return new CSDocTextNode(text);
    }

    private CSDocNode createTagNode(String tagName, TagElement element) {
        CSDocTagNode summary = new CSDocTagNode(tagName);
        for (Object f : element.fragments()) {
            summary.addFragment(this.mapTagElementFragment((ASTNode)f));
        }
        return summary;
    }

    private CSDocNode mapTagElementFragment(ASTNode node) {
        switch (node.getNodeType()) {
            case 65: {
                return this.mapTagElement((TagElement)node);
            }
            case 66: {
                return this.mapTextElement((TextElement)node);
            }
        }
        this.warning(node, "Documentation node not supported: " + node.getClass() + ": " + node);
        return new CSDocTextNode(node.toString());
    }

    public boolean visit(FieldDeclaration node) {
        if (SharpenAnnotations.hasIgnoreAnnotation((BodyDeclaration)node)) {
            return false;
        }
        ITypeBinding fieldType = node.getType().resolveBinding();
        CSTypeReferenceExpression typeName = this.mappedTypeReference(fieldType);
        CSVisibility visibility = this.mapVisibility((BodyDeclaration)node);
        if (((VariableDeclarationFragment)node.fragments().get(0)).resolveBinding().getDeclaringClass().isInterface()) {
            visibility = CSVisibility.Public;
        }
        for (Object item : node.fragments()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)item;
            ITypeBinding saved = this.pushExpectedType(fieldType);
            CSField field = this.mapFieldDeclarationFragment(node, fragment, typeName, visibility);
            this.popExpectedType(saved);
            this.adjustVisibility(fieldType, field);
            this._currentType.addMember(field);
        }
        return false;
    }

    private CSField mapFieldDeclarationFragment(FieldDeclaration node, VariableDeclarationFragment fragment, CSTypeReferenceExpression fieldType, CSVisibility fieldVisibility) {
        CSField field = new CSField(this.fieldName(fragment), fieldType, fieldVisibility, this.mapFieldInitializer(fragment));
        if (this.isConstField(node, fragment)) {
            field.addModifier(CSFieldModifier.Const);
        } else {
            this.processFieldModifiers(field, node.getModifiers());
        }
        this.mapDocumentation((BodyDeclaration)node, field);
        this.mapAnnotations((BodyDeclaration)node, field);
        return field;
    }

    private void mapAnnotations(BodyDeclaration node, CSMember member) {
        for (Object m : node.modifiers()) {
            if (!(m instanceof Annotation) || this.isIgnoredAnnotation((Annotation)m) || !(m instanceof MarkerAnnotation)) continue;
            this.mapMarkerAnnotation((MarkerAnnotation)m, member);
        }
    }

    private boolean isIgnoredAnnotation(Annotation m) {
        return this._configuration.isIgnoredAnnotation(CSharpBuilder.qualifiedName(m.resolveAnnotationBinding().getAnnotationType()));
    }

    private void mapMarkerAnnotation(MarkerAnnotation annotation, CSMember member) {
        IAnnotationBinding binding = annotation.resolveAnnotationBinding();
        CSAttribute attribute = new CSAttribute(this.mappedTypeName(binding.getAnnotationType()));
        member.addAttribute(attribute);
    }

    protected String fieldName(VariableDeclarationFragment fragment) {
        return this.identifier(fragment.getName());
    }

    protected CSExpression mapFieldInitializer(VariableDeclarationFragment fragment) {
        return this.mapExpression(fragment.getInitializer());
    }

    private boolean isConstField(FieldDeclaration node, VariableDeclarationFragment fragment) {
        if (fragment.resolveBinding().getDeclaringClass().isInterface()) {
            return true;
        }
        return Modifier.isFinal((int)node.getModifiers()) && node.getType().isPrimitiveType() && this.hasConstValue(fragment) && Modifier.isStatic((int)node.getModifiers());
    }

    private boolean hasConstValue(VariableDeclarationFragment fragment) {
        return fragment.resolveBinding().getConstantValue() != null;
    }

    private void processFieldModifiers(CSField field, int modifiers) {
        if (Modifier.isStatic((int)modifiers)) {
            field.addModifier(CSFieldModifier.Static);
        }
        if (Modifier.isFinal((int)modifiers)) {
            field.addModifier(CSFieldModifier.Readonly);
        }
        if (Modifier.isTransient((int)modifiers)) {
            field.addAttribute(new CSAttribute(this.mappedTypeName("System.NonSerialized")));
        }
        if (Modifier.isVolatile((int)modifiers)) {
            field.addModifier(CSFieldModifier.Volatile);
        }
    }

    private boolean isDestructor(MethodDeclaration node) {
        return node.getName().toString().equals("finalize");
    }

    public boolean visit(Initializer node) {
        if (Modifier.isStatic((int)node.getModifiers())) {
            CSConstructor ctor = new CSConstructor(CSConstructorModifier.Static);
            this._currentType.addMember(ctor);
            this.visitBodyDeclarationBlock((BodyDeclaration)node, node.getBody(), ctor);
        } else {
            this._instanceInitializers.add(node);
        }
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        if (SharpenAnnotations.hasIgnoreAnnotation((BodyDeclaration)node) || this.isRemoved(node)) {
            return false;
        }
        if (this.isEvent(node)) {
            this.processEventDeclaration(node);
            return false;
        }
        if (this.isMappedToProperty(node)) {
            this.processMappedPropertyDeclaration(node);
            return false;
        }
        if (this.isTaggedAsProperty(node)) {
            this.processPropertyDeclaration(node);
            return false;
        }
        if (this.isIndexer(node)) {
            this.processIndexerDeclaration(node);
            return false;
        }
        this.processMethodDeclaration(node);
        return false;
    }

    private void processIndexerDeclaration(MethodDeclaration node) {
        this.processPropertyDeclaration(node, "this");
    }

    private boolean isIndexer(MethodDeclaration node) {
        return this.isTaggedDeclaration(node, "@sharpen.indexer");
    }

    private boolean isRemoved(MethodDeclaration node) {
        return this.hasRemoveAnnotation((BodyDeclaration)node) || this.isRemoved(node.resolveBinding());
    }

    private boolean hasRemoveAnnotation(BodyDeclaration node) {
        return CSharpBuilder.containsJavadoc(node, "@sharpen.remove");
    }

    private boolean isRemoved(IMethodBinding binding) {
        return this._configuration.isRemoved(this.qualifiedName(binding));
    }

    public static boolean containsJavadoc(BodyDeclaration node, String tag) {
        return JavadocUtility.containsJavadoc(node, tag);
    }

    private void processPropertyDeclaration(MethodDeclaration node) {
        this.processPropertyDeclaration(node, this.propertyName(node));
    }

    private void processMappedPropertyDeclaration(MethodDeclaration node) {
        this.processPropertyDeclaration(node, this.mappedMethodName(node));
    }

    private void processPropertyDeclaration(MethodDeclaration node, String name) {
        this.mapPropertyDeclaration(node, this.producePropertyFor(node, name));
    }

    private CSProperty producePropertyFor(MethodDeclaration node, String name) {
        CSProperty existingProperty = this.findProperty(node, name);
        if (existingProperty != null) {
            return existingProperty;
        }
        CSProperty property = this.newPropertyFor(node, name);
        this._currentType.addMember(property);
        return property;
    }

    private CSProperty findProperty(MethodDeclaration node, String name) {
        CSMember existingProperty = this._currentType.getMember(name);
        if (existingProperty != null && !(existingProperty instanceof CSProperty)) {
            throw new IllegalArgumentException(String.valueOf(this.sourceInformation((ASTNode)node)) + ": Previously declared member redeclared as property.");
        }
        return (CSProperty)existingProperty;
    }

    private CSProperty mapPropertyDeclaration(MethodDeclaration node, CSProperty property) {
        CSBlock block = this.mapBody(node);
        if (this.isGetter(node)) {
            property.getter(block);
        } else {
            property.setter(block);
            this.mapImplicitSetterParameter(node, property);
        }
        this.mapMetaMemberAttributes(node, property);
        this.mapParameters(node, property);
        return property;
    }

    private void mapImplicitSetterParameter(MethodDeclaration node, CSProperty property) {
        String parameterName = this.parameter(node, 0).getName().toString();
        if (parameterName.equals("value")) {
            return;
        }
        property.setter().addStatement(0, this.newVariableDeclarationExpression(parameterName, property.type(), new CSReferenceExpression("value")));
    }

    private CSDeclarationExpression newVariableDeclarationExpression(String name, CSTypeReferenceExpression type, CSReferenceExpression initializer) {
        return new CSDeclarationExpression(new CSVariableDeclaration(name, type, initializer));
    }

    private CSProperty newPropertyFor(MethodDeclaration node, String propName) {
        CSTypeReferenceExpression propertyType = this.isGetter(node) ? this.mappedReturnType(node) : this.mappedTypeReference(this.lastParameter(node).getType());
        CSProperty p = new CSProperty(propName, propertyType);
        return p;
    }

    private CSBlock mapBody(MethodDeclaration node) {
        CSBlock block = new CSBlock();
        this.processBlock((BodyDeclaration)node, node.getBody(), block);
        return block;
    }

    private boolean isGetter(MethodDeclaration node) {
        return !"void".equals(node.getReturnType2().toString());
    }

    private SingleVariableDeclaration lastParameter(MethodDeclaration node) {
        return this.parameter(node, node.parameters().size() - 1);
    }

    private String propertyName(MethodDeclaration node) {
        return Environments.my(Annotations.class).annotatedPropertyName(node);
    }

    private String propertyName(IMethodBinding binding) {
        return this.propertyName(this.declaringNode(binding));
    }

    private boolean isProperty(MethodDeclaration node) {
        return this.isTaggedAsProperty(node) || this.isMappedToProperty(node);
    }

    private boolean isTaggedAsProperty(MethodDeclaration node) {
        return this.isTaggedDeclaration(node, "@sharpen.property");
    }

    private boolean isTaggedDeclaration(MethodDeclaration node, String tag) {
        return this.effectiveAnnotationFor(node, tag) != null;
    }

    private void processMethodDeclaration(MethodDeclaration node) {
        if (this.isDestructor(node)) {
            this.mapMethodParts(node, new CSDestructor());
            return;
        }
        if (node.isConstructor()) {
            this.mapMethodParts(node, new CSConstructor());
            return;
        }
        CSMethod method = new CSMethod(this.mappedMethodDeclarationName(node));
        method.returnType(this.mappedReturnType(node));
        method.modifier(this.mapMethodModifier(node));
        this.mapTypeParameters(node.typeParameters(), method);
        this.mapMethodParts(node, method);
        if (this._configuration.junitConversion() && this.isLegacyTestFixture(node.resolveBinding().getDeclaringClass())) {
            if (method.name().startsWith("Test") && method.visibility() == CSVisibility.Public) {
                method.addAttribute(new CSAttribute("NUnit.Framework.Test"));
            }
            if (this.isLegacyTestFixtureClass(node.resolveBinding().getDeclaringClass().getSuperclass())) {
                if (method.name().equals("SetUp")) {
                    method.addAttribute(new CSAttribute("NUnit.Framework.SetUp"));
                    method.modifier(CSMethodModifier.Virtual);
                    this.cleanBaseSetupCalls(method);
                } else if (method.name().equals("TearDown")) {
                    method.addAttribute(new CSAttribute("NUnit.Framework.TearDown"));
                }
            }
        }
    }

    private void cleanBaseSetupCalls(CSMethod method) {
        ArrayList<CSStatement> toDelete = new ArrayList<CSStatement>();
        for (CSStatement st : method.body().statements()) {
            CSMemberReferenceExpression mr;
            CSMethodInvocationExpression mie;
            CSExpressionStatement es;
            if (!(st instanceof CSExpressionStatement) || !((es = (CSExpressionStatement)st).expression() instanceof CSMethodInvocationExpression) || !((mie = (CSMethodInvocationExpression)es.expression()).expression() instanceof CSMemberReferenceExpression) || !((mr = (CSMemberReferenceExpression)mie.expression()).expression() instanceof CSBaseExpression) || !mr.name().equals("SetUp") && !mr.name().equals("TearDown")) continue;
            toDelete.add(st);
        }
        for (CSStatement st : toDelete) {
            method.body().removeStatement(st);
        }
    }

    private void mapMethodParts(MethodDeclaration node, CSMethodBase method) {
        this._currentType.addMember(method);
        method.startPosition(node.getStartPosition());
        method.isVarArgs(node.isVarargs());
        this.mapParameters(node, method);
        this.mapAnnotations((BodyDeclaration)node, method);
        this.mapDocumentation((BodyDeclaration)node, method);
        this.visitBodyDeclarationBlock((BodyDeclaration)node, node.getBody(), method);
        IMethodBinding overriden = this.getOverridedMethod(node);
        if (overriden != null) {
            CSVisibility vis = this.mapVisibility(overriden.getModifiers());
            if (vis == CSVisibility.ProtectedInternal && !overriden.getDeclaringClass().isFromSource()) {
                vis = CSVisibility.Protected;
            }
            method.visibility(vis);
        } else if (node.resolveBinding().getDeclaringClass().isInterface()) {
            method.visibility(CSVisibility.Public);
        } else {
            this.mapVisibility((BodyDeclaration)node, method);
        }
    }

    private String mappedMethodDeclarationName(MethodDeclaration node) {
        String mappedName = this.mappedMethodName(node);
        if (mappedName == null || mappedName.length() == 0 || mappedName.contains(".")) {
            return this.methodName(node.getName().toString());
        }
        return mappedName;
    }

    private void mapParameters(MethodDeclaration node, CSParameterized method) {
        if (method instanceof CSMethod) {
            this.mapMethodParameters(node, (CSMethod)method);
            return;
        }
        for (Object p : node.parameters()) {
            this.mapParameter((SingleVariableDeclaration)p, method);
        }
    }

    private void mapParameter(SingleVariableDeclaration parameter, CSParameterized method) {
        IVariableBinding vb;
        ITypeBinding[] ta;
        if (method instanceof CSMethod && (ta = (vb = parameter.resolveBinding()).getType().getTypeArguments()).length > 0 && ta[0].getName().startsWith("?")) {
            ITypeBinding extended = this.mapTypeParameterExtendedType(ta[0]);
            CSMethod met = (CSMethod)method;
            String genericArg = "_T" + met.typeParameters().size();
            CSTypeParameter tp = new CSTypeParameter(genericArg);
            if (extended != null) {
                tp.superClass(this.mappedTypeReference(extended));
            }
            met.addTypeParameter(tp);
            CSTypeReference tr = new CSTypeReference(this.mappedTypeName(vb.getType()));
            tr.addTypeArgument(new CSTypeReference(genericArg));
            method.addParameter(new CSVariableDeclaration(this.identifier(vb.getName()), tr));
            return;
        }
        method.addParameter(this.createParameter(parameter));
    }

    ITypeBinding mapTypeParameterExtendedType(ITypeBinding tb) {
        ITypeBinding superc = tb.getSuperclass();
        if (superc != null && !superc.getQualifiedName().equals("java.lang.Object") && !superc.getQualifiedName().equals("java.lang.Enum<?>")) {
            return superc;
        }
        ITypeBinding[] ints = tb.getInterfaces();
        if (ints.length > 0) {
            return ints[0];
        }
        return null;
    }

    private void mapMethodParameters(MethodDeclaration node, CSMethod method) {
        for (Object o : node.parameters()) {
            SingleVariableDeclaration p = (SingleVariableDeclaration)o;
            ITypeBinding parameterType = p.getType().resolveBinding();
            if (this.isGenericRuntimeParameterIdiom(node.resolveBinding(), parameterType)) {
                method.body().addStatement(new CSDeclarationStatement(p.getStartPosition(), new CSVariableDeclaration(this.identifier(p.getName()), new CSTypeReference("System.Type"), new CSTypeofExpression(this.genericRuntimeTypeIdiomType(parameterType)))));
                continue;
            }
            this.mapParameter(p, method);
        }
    }

    private CSTypeReferenceExpression genericRuntimeTypeIdiomType(ITypeBinding parameterType) {
        return this.mappedTypeReference(parameterType.getTypeArguments()[0]);
    }

    private boolean isGenericRuntimeParameterIdiom(IMethodBinding method, ITypeBinding parameterType) {
        if (!parameterType.isParameterizedType()) {
            return false;
        }
        if (!"java.lang.Class".equals(CSharpBuilder.qualifiedName(parameterType))) {
            return false;
        }
        ITypeBinding classTypeArgument = parameterType.getTypeArguments()[0];
        return classTypeArgument.getDeclaringMethod() == method;
    }

    private CSTypeReferenceExpression mappedReturnType(MethodDeclaration node) {
        IMethodBinding overriden = this.getOverridedMethod(node);
        if (overriden != null) {
            return this.mappedTypeReference(overriden.getReturnType());
        }
        return this.mappedTypeReference(node.getReturnType2());
    }

    private void processEventDeclaration(MethodDeclaration node) {
        CSTypeReference eventHandlerType = new CSTypeReference(this.getEventHandlerTypeName(node));
        CSEvent event = this.createEventFromMethod(node, eventHandlerType);
        this.mapMetaMemberAttributes(node, event);
        if (this._currentType.isInterface()) {
            return;
        }
        VariableDeclarationFragment field = this.getEventBackingField(node);
        CSField backingField = (CSField)this._currentType.getMember(field.getName().toString());
        backingField.type(eventHandlerType);
        backingField.initializer(null);
        backingField.removeModifier(CSFieldModifier.Readonly);
        CSBlock addBlock = this.createEventBlock(backingField, "System.Delegate.Combine");
        String onAddMethod = this.getEventOnAddMethod(node);
        if (onAddMethod != null) {
            addBlock.addStatement(new CSMethodInvocationExpression(new CSReferenceExpression(onAddMethod), new CSExpression[0]));
        }
        event.setAddBlock(addBlock);
        event.setRemoveBlock(this.createEventBlock(backingField, "System.Delegate.Remove"));
    }

    private String getEventOnAddMethod(MethodDeclaration node) {
        TagElement onAddTag = this.javadocTagFor((BodyDeclaration)node, "@sharpen.event.onAdd");
        if (onAddTag == null) {
            return null;
        }
        return this.methodName(JavadocUtility.singleTextFragmentFrom(onAddTag));
    }

    private String getEventHandlerTypeName(MethodDeclaration node) {
        String eventArgsType = this.getEventArgsType(node);
        return this.buildEventHandlerTypeName((ASTNode)node, eventArgsType);
    }

    private void mapMetaMemberAttributes(MethodDeclaration node, CSMetaMember metaMember) {
        this.mapVisibility((BodyDeclaration)node, metaMember);
        metaMember.modifier(this.mapMethodModifier(node));
        this.mapDocumentation((BodyDeclaration)node, metaMember);
    }

    private CSBlock createEventBlock(CSField backingField, String delegateMethod) {
        CSBlock block = new CSBlock();
        block.addStatement(new CSInfixExpression("=", new CSReferenceExpression(backingField.name()), new CSCastExpression(backingField.type(), new CSMethodInvocationExpression(new CSReferenceExpression(delegateMethod), new CSReferenceExpression(backingField.name()), new CSReferenceExpression("value")))));
        return block;
    }

    private VariableDeclarationFragment getEventBackingField(MethodDeclaration node) {
        FieldAccessFinder finder = new FieldAccessFinder();
        node.accept((ASTVisitor)finder);
        return (VariableDeclarationFragment)this.findDeclaringNode(finder.field);
    }

    private CSEvent createEventFromMethod(MethodDeclaration node, CSTypeReference eventHandlerType) {
        String eventName = this.methodName(node);
        CSEvent event = new CSEvent(eventName, eventHandlerType);
        this._currentType.addMember(event);
        return event;
    }

    private String methodName(MethodDeclaration node) {
        return this.methodName(node.getName().toString());
    }

    private String unqualifiedName(String typeName) {
        int index = typeName.lastIndexOf(46);
        if (index < 0) {
            return typeName;
        }
        return typeName.substring(index + 1);
    }

    private String buildEventHandlerTypeName(ASTNode node, String eventArgsTypeName) {
        if (!eventArgsTypeName.endsWith("EventArgs")) {
            this.warning(node, "@sharpen.event type name must end with 'EventArgs'");
            return String.valueOf(eventArgsTypeName) + "EventHandler";
        }
        return "System.EventHandler<" + eventArgsTypeName + ">";
    }

    private String getEventArgsType(MethodDeclaration node) {
        TagElement tag = this.eventTagFor(node);
        if (tag == null) {
            return null;
        }
        return this.mappedTypeName(JavadocUtility.singleTextFragmentFrom(tag));
    }

    private TagElement eventTagFor(MethodDeclaration node) {
        return this.effectiveAnnotationFor(node, "@sharpen.event");
    }

    private TagElement effectiveAnnotationFor(MethodDeclaration node, String annotation) {
        return Environments.my(Annotations.class).effectiveAnnotationFor(node, annotation);
    }

    private <T extends ASTNode> T findDeclaringNode(IBinding binding) {
        return Environments.my(Bindings.class).findDeclaringNode(binding);
    }

    private void visitBodyDeclarationBlock(BodyDeclaration node, Block block, CSMethodBase method) {
        CSMethodBase saved = this._currentMethod;
        this._currentMethod = method;
        this.processDisableTags(node, (CSNode)method);
        this.processBlock(node, block, method.body());
        this._currentMethod = saved;
    }

    private void processDisableTags(PackageDeclaration packageDeclaration, CSNode csNode) {
        TagElement tag = this.javadocTagFor(packageDeclaration, "@sharpen.if");
        if (tag == null) {
            return;
        }
        csNode.addEnclosingIfDef(JavadocUtility.singleTextFragmentFrom(tag));
    }

    private void processDisableTags(BodyDeclaration node, CSNode csNode) {
        TagElement tag = this.javadocTagFor(node, "@sharpen.if");
        if (tag == null) {
            return;
        }
        csNode.addEnclosingIfDef(JavadocUtility.singleTextFragmentFrom(tag));
    }

    private void processBlock(BodyDeclaration node, Block block, CSBlock targetBlock) {
        if (CSharpBuilder.containsJavadoc(node, "@sharpen.remove.first")) {
            block.statements().remove(0);
        }
        BodyDeclaration savedDeclaration = this._currentBodyDeclaration;
        this._currentBodyDeclaration = node;
        if (Modifier.isSynchronized((int)node.getModifiers())) {
            CSLockStatement lock = new CSLockStatement(node.getStartPosition(), this.getLockTarget(node));
            targetBlock.addStatement(lock);
            this.visitBlock(lock.body(), block);
        } else {
            this.visitBlock(targetBlock, block);
        }
        this._currentBodyDeclaration = savedDeclaration;
    }

    private CSExpression getLockTarget(BodyDeclaration node) {
        return Modifier.isStatic((int)node.getModifiers()) ? new CSTypeofExpression(new CSTypeReference(this._currentType.name())) : new CSThisExpression();
    }

    public boolean visit(ConstructorInvocation node) {
        this.addChainedConstructorInvocation(new CSThisExpression(), node.arguments());
        return false;
    }

    private void addChainedConstructorInvocation(CSExpression target, List arguments) {
        CSConstructorInvocationExpression cie = new CSConstructorInvocationExpression(target);
        this.mapArguments(cie, arguments);
        ((CSConstructor)this._currentMethod).chainedConstructorInvocation(cie);
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (node.getExpression() != null) {
            this.notImplemented((ASTNode)node);
        }
        this.addChainedConstructorInvocation(new CSBaseExpression(), node.arguments());
        return false;
    }

    private <T extends ASTNode> void visitBlock(CSBlock block, T node) {
        if (node == null) {
            return;
        }
        CSBlock saved = this._currentBlock;
        this._currentBlock = block;
        this._currentContinueLabel = null;
        node.accept((ASTVisitor)this);
        this._currentBlock = saved;
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.pushExpression(new CSDeclarationExpression(this.createVariableDeclaration((VariableDeclarationFragment)node.fragments().get(0))));
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        for (Object f : node.fragments()) {
            VariableDeclarationFragment variable = (VariableDeclarationFragment)f;
            this.addStatement(new CSDeclarationStatement(node.getStartPosition(), this.createVariableDeclaration(variable)));
        }
        return false;
    }

    private CSVariableDeclaration createVariableDeclaration(VariableDeclarationFragment variable) {
        IVariableBinding binding = variable.resolveBinding();
        ITypeBinding saved = this.pushExpectedType(binding.getType());
        CSExpression initializer = this.mapExpression(variable.getInitializer());
        this.popExpectedType(saved);
        return this.createVariableDeclaration(binding, initializer);
    }

    /*
     * WARNING - void declaration
     */
    private CSVariableDeclaration createVariableDeclaration(IVariableBinding binding, CSExpression initializer) {
        String name = binding.getName();
        if (this._blockVariables.size() > 0) {
            if (this._blockVariables.peek().contains(name)) {
                void var4_5;
                boolean bl = true;
                while (this._blockVariables.peek().contains(String.valueOf(name) + "_" + (int)var4_5)) {
                    ++var4_5;
                }
                this._renamedVariables.peek().put(name, String.valueOf(name) + "_" + (int)var4_5);
                name = String.valueOf(name) + "_" + (int)var4_5;
            }
            this._localBlockVariables.peek().add(name);
            for (Set set : this._blockVariables) {
                set.add(name);
            }
        }
        return new CSVariableDeclaration(this.identifier(name), this.mappedTypeReference(binding.getType()), initializer);
    }

    public boolean visit(ExpressionStatement node) {
        if (this.isRemovedMethodInvocation(node.getExpression())) {
            return false;
        }
        this.addStatement(new CSExpressionStatement(node.getStartPosition(), this.mapExpression(node.getExpression())));
        return false;
    }

    private boolean isRemovedMethodInvocation(Expression expression) {
        if (!(expression instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation invocation = (MethodInvocation)expression;
        return this.isTaggedMethodInvocation(invocation, "@sharpen.remove") || this.isRemoved(invocation.resolveMethodBinding());
    }

    public boolean isEnumOrdinalMethodInvocation(MethodInvocation node) {
        return node.getName().getIdentifier().equals("ordinal") && node.getExpression() != null && node.getExpression().resolveTypeBinding().isEnum();
    }

    public boolean isEnumNameMethodInvocation(MethodInvocation node) {
        return node.getName().getIdentifier().equals("name") && node.getExpression() != null && node.getExpression().resolveTypeBinding().isEnum();
    }

    public boolean visit(IfStatement node) {
        Expression expression = node.getExpression();
        Object constValue = this.constValue(expression);
        if (constValue != null) {
            if (this.isTrue(constValue)) {
                node.getThenStatement().accept((ASTVisitor)this);
            } else if (node.getElseStatement() != null) {
                node.getElseStatement().accept((ASTVisitor)this);
            }
        } else {
            CSIfStatement stmt = new CSIfStatement(node.getStartPosition(), this.mapExpression(expression));
            this.visitBlock(stmt.trueBlock(), node.getThenStatement());
            this.visitBlock(stmt.falseBlock(), node.getElseStatement());
            this.addStatement(stmt);
        }
        return false;
    }

    private boolean isTrue(Object constValue) {
        return (Boolean)constValue;
    }

    private Object constValue(Expression expression) {
        switch (expression.getNodeType()) {
            case 38: {
                return this.constValue((PrefixExpression)expression);
            }
            case 40: 
            case 42: {
                return this.constValue((Name)expression);
            }
        }
        return null;
    }

    public Object constValue(PrefixExpression expression) {
        Object value;
        if (PrefixExpression.Operator.NOT == expression.getOperator() && (value = this.constValue(expression.getOperand())) != null) {
            return this.isTrue(value) ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    public Object constValue(Name expression) {
        IBinding binding = expression.resolveBinding();
        if (3 == binding.getKind()) {
            return ((IVariableBinding)binding).getConstantValue();
        }
        return null;
    }

    public boolean visit(final WhileStatement node) {
        this.consumeContinueLabel(new Function<CSBlock>(){

            @Override
            public CSBlock apply() {
                CSWhileStatement stmt = new CSWhileStatement(node.getStartPosition(), CSharpBuilder.this.mapExpression(node.getExpression()));
                CSharpBuilder.this.visitBlock(stmt.body(), (ASTNode)node.getBody());
                CSharpBuilder.this.addStatement(stmt);
                return stmt.body();
            }
        });
        return false;
    }

    public boolean visit(final DoStatement node) {
        this.consumeContinueLabel(new Function<CSBlock>(){

            @Override
            public CSBlock apply() {
                CSDoStatement stmt = new CSDoStatement(node.getStartPosition(), CSharpBuilder.this.mapExpression(node.getExpression()));
                CSharpBuilder.this.visitBlock(stmt.body(), (ASTNode)node.getBody());
                CSharpBuilder.this.addStatement(stmt);
                return stmt.body();
            }
        });
        return false;
    }

    public boolean visit(TryStatement node) {
        CSTryStatement stmt = new CSTryStatement(node.getStartPosition());
        this.visitBlock(stmt.body(), node.getBody());
        for (Object o : node.catchClauses()) {
            CatchClause clause = (CatchClause)o;
            if (this._configuration.isIgnoredExceptionType(CSharpBuilder.qualifiedName(clause.getException().getType().resolveBinding()))) continue;
            stmt.addCatchClause(this.mapCatchClause(clause));
        }
        if (node.getFinally() != null) {
            CSBlock finallyBlock = new CSBlock();
            this.visitBlock(finallyBlock, node.getFinally());
            stmt.finallyBlock(finallyBlock);
        }
        if (stmt.finallyBlock() != null || !stmt.catchClauses().isEmpty()) {
            this.addStatement(stmt);
        } else {
            this._currentBlock.addAll(stmt.body());
        }
        return false;
    }

    private CSCatchClause mapCatchClause(CatchClause node) {
        IVariableBinding oldExceptionVariable = this._currentExceptionVariable;
        this._currentExceptionVariable = node.getException().resolveBinding();
        try {
            CheckVariableUseVisitor check = new CheckVariableUseVisitor(this._currentExceptionVariable);
            node.getBody().accept((ASTVisitor)check);
            this.pushScope();
            CSCatchClause clause = this.isEmptyCatch(node, check) ? new CSCatchClause() : new CSCatchClause(this.createVariableDeclaration(this._currentExceptionVariable, null));
            clause.anonymous(!check.used());
            this.visitBlock(clause.body(), node.getBody());
            CSCatchClause cSCatchClause = clause;
            return cSCatchClause;
        }
        finally {
            this._currentExceptionVariable = oldExceptionVariable;
            this.popScope();
        }
    }

    private boolean isEmptyCatch(CatchClause clause, CheckVariableUseVisitor check) {
        if (check.used()) {
            return false;
        }
        return this.isThrowable(clause.getException().resolveBinding().getType());
    }

    private boolean isThrowable(ITypeBinding declaringClass) {
        return "java.lang.Throwable".equals(CSharpBuilder.qualifiedName(declaringClass));
    }

    public boolean visit(ThrowStatement node) {
        this.addStatement(this.mapThrowStatement(node));
        return false;
    }

    private CSThrowStatement mapThrowStatement(ThrowStatement node) {
        Expression exception = node.getExpression();
        if (this.isCurrentExceptionVariable(exception)) {
            return new CSThrowStatement(node.getStartPosition(), null);
        }
        return new CSThrowStatement(node.getStartPosition(), this.mapExpression(exception));
    }

    private boolean isCurrentExceptionVariable(Expression exception) {
        if (!(exception instanceof SimpleName)) {
            return false;
        }
        return ((SimpleName)exception).resolveBinding() == this._currentExceptionVariable;
    }

    public boolean visit(BreakStatement node) {
        SimpleName labelName = node.getLabel();
        if (labelName != null) {
            this.addStatement(new CSGotoStatement(node.getStartPosition(), this.breakLabel(labelName.getIdentifier())));
            return false;
        }
        this.addStatement(new CSBreakStatement(node.getStartPosition()));
        return false;
    }

    public boolean visit(ContinueStatement node) {
        SimpleName labelName = node.getLabel();
        if (labelName != null) {
            this.addStatement(new CSGotoStatement(node.getStartPosition(), this.continueLabel(labelName.getIdentifier())));
            return false;
        }
        this.addStatement(new CSContinueStatement(node.getStartPosition()));
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        CSLockStatement stmt = new CSLockStatement(node.getStartPosition(), this.mapExpression(node.getExpression()));
        this.visitBlock(stmt.body(), node.getBody());
        this.addStatement(stmt);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.addStatement(new CSReturnStatement(node.getStartPosition(), this.mapExpression(node.getExpression())));
        return false;
    }

    public boolean visit(NumberLiteral node) {
        String token = node.getToken();
        CSExpression literal = new CSNumberLiteralExpression(token);
        if (this.expectingType("byte") && token.startsWith("-")) {
            literal = this.uncheckedCast("byte", literal);
        } else if (token.startsWith("0x")) {
            literal = token.endsWith("l") || token.endsWith("L") ? this.uncheckedCast("long", literal) : this.uncheckedCast("int", literal);
        } else if (token.startsWith("0") && token.indexOf(46) == -1 && Character.isDigit(token.charAt(token.length() - 1))) {
            try {
                int n = Integer.parseInt(token, 8);
                if (n != 0) {
                    literal = new CSNumberLiteralExpression("0x" + Integer.toHexString(n));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.pushExpression(literal);
        return false;
    }

    private CSUncheckedExpression uncheckedCast(String type, CSExpression expression) {
        return new CSUncheckedExpression(new CSCastExpression(new CSTypeReference(type), new CSParenthesizedExpression(expression)));
    }

    public boolean visit(StringLiteral node) {
        String value = node.getLiteralValue();
        if (value != null && value.length() == 0) {
            this.pushExpression(new CSReferenceExpression("string.Empty"));
        } else {
            this.pushExpression(new CSStringLiteralExpression(this.fixEscapedNumbers(node.getEscapedValue())));
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    String fixEscapedNumbers(String literal) {
        s = new StringBuffer();
        n = 0;
        while (n < literal.length()) {
            block4: {
                if (literal.charAt(n) != '\\') ** GOTO lbl-1000
                i = n + 1;
                if (i >= literal.length() || literal.charAt(i) != '\\') ** GOTO lbl12
                s.append("\\\\");
                n = i;
                break block4;
lbl-1000:
                // 1 sources

                {
                    ++i;
lbl12:
                    // 2 sources

                    ** while (i < literal.length() && Character.isDigit((char)literal.charAt((int)i)))
                }
lbl13:
                // 1 sources

                if (i != n + 1) {
                    num = Integer.parseInt(literal.substring(n + 1, i));
                    s.append("\\x" + Integer.toHexString(num));
                    n = i - 1;
                } else lbl-1000:
                // 2 sources

                {
                    s.append(literal.charAt(n));
                }
            }
            ++n;
        }
        return s.toString();
    }

    public boolean visit(CharacterLiteral node) {
        CSExpression expr = new CSCharLiteralExpression(node.getEscapedValue());
        if (this.expectingType("byte")) {
            expr = new CSCastExpression(new CSTypeReference("byte"), new CSParenthesizedExpression(expr));
        }
        this.pushExpression(expr);
        return false;
    }

    private boolean expectingType(String name) {
        return this._currentExpectedType != null && this._currentExpectedType.getName().equals(name);
    }

    public boolean visit(NullLiteral node) {
        this.pushExpression(new CSNullLiteralExpression());
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        this.pushExpression(new CSBoolLiteralExpression(node.booleanValue()));
        return false;
    }

    public boolean visit(ThisExpression node) {
        this.pushExpression(new CSThisExpression());
        return false;
    }

    public boolean visit(ArrayAccess node) {
        this.pushExpression(new CSIndexedExpression(this.mapExpression(node.getArray()), this.mapExpression(node.getIndex())));
        return false;
    }

    public boolean visit(ArrayCreation node) {
        ITypeBinding saved = this.pushExpectedType(node.getType().getElementType().resolveBinding());
        if (node.dimensions().size() > 1) {
            if (node.getInitializer() != null) {
                this.notImplemented((ASTNode)node);
            }
            this.pushExpression(this.unfoldMultiArrayCreation(node));
        } else {
            this.pushExpression(this.mapSingleArrayCreation(node));
        }
        this.popExpectedType(saved);
        return false;
    }

    private CSArrayCreationExpression unfoldMultiArrayCreation(ArrayCreation node) {
        return this.unfoldMultiArray((ArrayType)node.getType().getComponentType(), node.dimensions(), 0);
    }

    private CSArrayCreationExpression unfoldMultiArray(ArrayType type, List dimensions, int dimensionIndex) {
        CSArrayCreationExpression expression = new CSArrayCreationExpression(this.mappedTypeReference((Type)type));
        expression.initializer(new CSArrayInitializerExpression());
        int length = this.resolveIntValue(dimensions.get(dimensionIndex));
        if (dimensionIndex < this.lastIndex(dimensions) - 1) {
            int i = 0;
            while (i < length) {
                expression.initializer().addExpression(this.unfoldMultiArray((ArrayType)type.getComponentType(), dimensions, dimensionIndex + 1));
                ++i;
            }
        } else {
            Expression innerLength = (Expression)dimensions.get(dimensionIndex + 1);
            CSTypeReferenceExpression innerType = this.mappedTypeReference(type.getComponentType());
            int i = 0;
            while (i < length) {
                expression.initializer().addExpression(new CSArrayCreationExpression(innerType, this.mapExpression(innerLength)));
                ++i;
            }
        }
        return expression;
    }

    private int lastIndex(List<?> dimensions) {
        return dimensions.size() - 1;
    }

    private int resolveIntValue(Object expression) {
        return ((Number)((Expression)expression).resolveConstantExpressionValue()).intValue();
    }

    private CSArrayCreationExpression mapSingleArrayCreation(ArrayCreation node) {
        CSArrayCreationExpression expression = new CSArrayCreationExpression(this.mappedTypeReference(this.componentType(node.getType())));
        if (!node.dimensions().isEmpty()) {
            expression.length(this.mapExpression((Expression)node.dimensions().get(0)));
        }
        expression.initializer(this.mapArrayInitializer(node));
        return expression;
    }

    private CSArrayInitializerExpression mapArrayInitializer(ArrayCreation node) {
        return (CSArrayInitializerExpression)this.mapExpression((Expression)node.getInitializer());
    }

    public boolean visit(ArrayInitializer node) {
        if (this.isImplicitelyTypedArrayInitializer(node)) {
            CSArrayCreationExpression ace = new CSArrayCreationExpression(this.mappedTypeReference(node.resolveTypeBinding().getComponentType()));
            ITypeBinding saved = this.pushExpectedType(node.resolveTypeBinding().getElementType());
            ace.initializer(this.mapArrayInitializer(node));
            this.popExpectedType(saved);
            this.pushExpression(ace);
            return false;
        }
        this.pushExpression(this.mapArrayInitializer(node));
        return false;
    }

    private CSArrayInitializerExpression mapArrayInitializer(ArrayInitializer node) {
        CSArrayInitializerExpression initializer = new CSArrayInitializerExpression();
        for (Object e : node.expressions()) {
            initializer.addExpression(this.mapExpression((Expression)e));
        }
        return initializer;
    }

    private boolean isImplicitelyTypedArrayInitializer(ArrayInitializer node) {
        return !(node.getParent() instanceof ArrayCreation);
    }

    public ITypeBinding componentType(ArrayType type) {
        return type.getComponentType().resolveBinding();
    }

    public boolean visit(EnhancedForStatement node) {
        CSForEachStatement stmt = new CSForEachStatement(node.getStartPosition(), this.mapExpression(node.getExpression()));
        stmt.variable(this.createParameter(node.getParameter()));
        this.visitBlock(stmt.body(), node.getBody());
        this.addStatement(stmt);
        return false;
    }

    public boolean visit(final ForStatement node) {
        this.consumeContinueLabel(new Function<CSBlock>(){

            @Override
            public CSBlock apply() {
                ArrayList<CSExpression> initializers = new ArrayList<CSExpression>();
                for (Object i : node.initializers()) {
                    initializers.add(CSharpBuilder.this.mapExpression((Expression)i));
                }
                CSForStatement stmt = new CSForStatement(node.getStartPosition(), CSharpBuilder.this.mapExpression(node.getExpression()));
                for (CSExpression i : initializers) {
                    stmt.addInitializer(i);
                }
                for (Object u : node.updaters()) {
                    stmt.addUpdater(CSharpBuilder.this.mapExpression((Expression)u));
                }
                CSharpBuilder.this.visitBlock(stmt.body(), (ASTNode)node.getBody());
                CSharpBuilder.this.addStatement(stmt);
                return stmt.body();
            }
        });
        return false;
    }

    private void consumeContinueLabel(Function<CSBlock> func) {
        CSLabelStatement label = this._currentContinueLabel;
        this._currentContinueLabel = null;
        CSBlock body = func.apply();
        if (label != null) {
            body.addStatement(label);
        }
    }

    public boolean visit(SwitchStatement node) {
        this._currentContinueLabel = null;
        CSBlock saved = this._currentBlock;
        ITypeBinding switchType = node.getExpression().resolveTypeBinding();
        CSSwitchStatement mappedNode = new CSSwitchStatement(node.getStartPosition(), this.mapExpression(node.getExpression()));
        this.addStatement(mappedNode);
        CSCaseClause defaultClause = null;
        CSCaseClause current = null;
        CSBlock openCaseBlock = null;
        this._currentBlock = null;
        for (ASTNode element : (Iterable)Types.cast(node.statements())) {
            if (49 == element.getNodeType()) {
                SwitchCase sc;
                if (current == null) {
                    if (this._currentBlock != null) {
                        CSStatement lastStmt;
                        List<CSStatement> stats = this._currentBlock.statements();
                        CSStatement cSStatement = lastStmt = stats.size() > 0 ? stats.get(stats.size() - 1) : null;
                        if (!(lastStmt instanceof CSThrowStatement || lastStmt instanceof CSReturnStatement || lastStmt instanceof CSBreakStatement || lastStmt instanceof CSGotoStatement)) {
                            openCaseBlock = this._currentBlock;
                        }
                    }
                    current = new CSCaseClause();
                    mappedNode.addCase(current);
                    this._currentBlock = current.body();
                }
                if ((sc = (SwitchCase)element).isDefault()) {
                    defaultClause = current;
                    current.isDefault(true);
                    if (openCaseBlock != null) {
                        openCaseBlock.addStatement(new CSGotoStatement(Integer.MIN_VALUE, "default"));
                    }
                } else {
                    ITypeBinding stype = this.pushExpectedType(switchType);
                    CSExpression caseExpression = this.mapExpression(sc.getExpression());
                    current.addExpression(caseExpression);
                    this.popExpectedType(stype);
                    if (openCaseBlock != null) {
                        openCaseBlock.addStatement(new CSGotoStatement(Integer.MIN_VALUE, caseExpression));
                    }
                }
                openCaseBlock = null;
                continue;
            }
            element.accept((ASTVisitor)this);
            current = null;
        }
        if (openCaseBlock != null) {
            openCaseBlock.addStatement(new CSBreakStatement(Integer.MIN_VALUE));
        }
        if (defaultClause != null) {
            CSStatement lastStmt;
            List<CSStatement> stats = defaultClause.body().statements();
            CSStatement cSStatement = lastStmt = stats.size() > 0 ? stats.get(stats.size() - 1) : null;
            if (!(lastStmt instanceof CSThrowStatement)) {
                defaultClause.body().addStatement(new CSBreakStatement(Integer.MIN_VALUE));
            }
        }
        this._currentBlock = saved;
        return false;
    }

    public boolean visit(CastExpression node) {
        this.pushExpression(new CSCastExpression(this.mappedTypeReference(node.getType()), this.mapExpression(node.getExpression())));
        if (node.getType().resolveBinding().getName().equals("byte")) {
            this.pushExpression(new CSUncheckedExpression(this.popExpression()));
        }
        return false;
    }

    public boolean visit(PrefixExpression node) {
        CSExpression expr = new CSPrefixExpression(node.getOperator().toString(), this.mapExpression(node.getOperand()));
        if (this.expectingType("byte") && node.getOperator() == PrefixExpression.Operator.MINUS) {
            expr = this.uncheckedCast("byte", expr);
        }
        this.pushExpression(expr);
        return false;
    }

    public boolean visit(PostfixExpression node) {
        this.pushExpression(new CSPostfixExpression(node.getOperator().toString(), this.mapExpression(node.getOperand())));
        return false;
    }

    public boolean visit(InfixExpression node) {
        CSExpression left = this.mapExpression(node.getLeftOperand());
        CSExpression right = this.mapExpression(node.getRightOperand());
        String type = node.getLeftOperand().resolveTypeBinding().getQualifiedName();
        if (node.getOperator() == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
            if (type.equals("byte")) {
                this.pushExpression(new CSInfixExpression(">>", left, right));
            } else {
                CSExpression cast = new CSCastExpression(new CSTypeReference("u" + type), left);
                cast = new CSParenthesizedExpression(cast);
                CSExpression shiftResult = new CSInfixExpression(">>", cast, right);
                shiftResult = new CSParenthesizedExpression(shiftResult);
                this.pushExpression(new CSCastExpression(new CSTypeReference(type), shiftResult));
            }
            return false;
        }
        if (type.equals("byte") && (node.getOperator() == InfixExpression.Operator.LESS || node.getOperator() == InfixExpression.Operator.LESS_EQUALS)) {
            left = new CSCastExpression(new CSTypeReference("sbyte"), left);
            left = new CSParenthesizedExpression(left);
        }
        String operator = node.getOperator().toString();
        this.pushExpression(new CSInfixExpression(operator, left, right));
        this.pushExtendedOperands(operator, node);
        return false;
    }

    private void pushExtendedOperands(String operator, InfixExpression node) {
        for (Object x : node.extendedOperands()) {
            this.pushExpression(new CSInfixExpression(operator, this.popExpression(), this.mapExpression((Expression)x)));
        }
    }

    public boolean visit(ParenthesizedExpression node) {
        this.pushExpression(new CSParenthesizedExpression(this.mapExpression(node.getExpression())));
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        this.pushExpression(new CSConditionalExpression(this.mapExpression(node.getExpression()), this.mapExpression(node.getThenExpression()), this.mapExpression(node.getElseExpression())));
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        this.pushExpression(new CSInfixExpression("is", this.mapExpression(node.getLeftOperand()), this.mappedTypeReference(node.getRightOperand().resolveBinding())));
        return false;
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        Expression rhs = node.getRightHandSide();
        ITypeBinding lhsType = lhs.resolveTypeBinding();
        ITypeBinding saved = this.pushExpectedType(lhsType);
        if (node.getOperator() == Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN) {
            String type = lhsType.getQualifiedName();
            if (type == "byte") {
                this.pushExpression(new CSInfixExpression(">>", this.mapExpression(lhs), this.mapExpression(lhs.resolveTypeBinding(), rhs)));
            } else {
                CSExpression mappedLhs = this.mapExpression(lhs);
                CSExpression cast = new CSCastExpression(new CSTypeReference("u" + type), mappedLhs);
                cast = new CSParenthesizedExpression(cast);
                CSExpression shiftResult = new CSInfixExpression(">>", cast, this.mapExpression(rhs));
                shiftResult = new CSParenthesizedExpression(shiftResult);
                shiftResult = new CSCastExpression(new CSTypeReference(type), shiftResult);
                this.pushExpression(new CSInfixExpression("=", mappedLhs, shiftResult));
            }
        } else {
            this.pushExpression(new CSInfixExpression(node.getOperator().toString(), this.mapExpression(lhs), this.mapExpression(lhs.resolveTypeBinding(), rhs)));
        }
        this.popExpectedType(saved);
        return false;
    }

    private CSExpression mapExpression(ITypeBinding expectedType, Expression expression) {
        if (expectedType != null) {
            return this.castIfNeeded(expectedType, expression.resolveTypeBinding(), this.mapExpression(expression));
        }
        return this.mapExpression(expression);
    }

    private CSExpression castIfNeeded(ITypeBinding expectedType, ITypeBinding actualType, CSExpression expression) {
        if (!this._configuration.mapIteratorToEnumerator() && expectedType.getName().startsWith("Iterable<") && this.isGenericCollection(actualType)) {
            return new CSMethodInvocationExpression(new CSMemberReferenceExpression(expression, "AsIterable"), new CSExpression[0]);
        }
        if (expectedType != actualType && this.isSubclassOf(expectedType, actualType)) {
            return new CSCastExpression(this.mappedTypeReference(expectedType), expression);
        }
        ITypeBinding charType = this.resolveWellKnownType("char");
        if (expectedType != charType) {
            return expression;
        }
        if (actualType == expectedType) {
            return expression;
        }
        return new CSCastExpression(this.mappedTypeReference(expectedType), expression);
    }

    private boolean isGenericCollection(ITypeBinding t) {
        return t.getName().startsWith("List<") || t.getName().startsWith("Set<");
    }

    private boolean isSubclassOf(ITypeBinding t, ITypeBinding tbase) {
        while (t != null) {
            if (t.isEqualTo((IBinding)tbase)) {
                return true;
            }
            t = t.getSuperclass();
        }
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
            return false;
        }
        CSMethodInvocationExpression expression = this.mapConstructorInvocation(node);
        if (expression == null) {
            return false;
        }
        if (this.isNonStaticNestedTypeCreation(node)) {
            expression.addArgument(new CSThisExpression());
        }
        this.mapArguments(expression, node.arguments());
        this.pushExpression(expression);
        return false;
    }

    private boolean isNonStaticNestedTypeCreation(ClassInstanceCreation node) {
        return this.isNonStaticNestedType(node.resolveTypeBinding());
    }

    private CSMethodInvocationExpression mapConstructorInvocation(ClassInstanceCreation node) {
        Configuration.MemberMapping mappedConstructor = this.effectiveMappingFor(node.resolveConstructorBinding());
        if (mappedConstructor == null) {
            return new CSConstructorInvocationExpression(this.mappedTypeReference(node.resolveTypeBinding()));
        }
        String mappedName = mappedConstructor.name;
        if (mappedName.length() == 0) {
            this.pushExpression(this.mapExpression((Expression)node.arguments().get(0)));
            return null;
        }
        if (mappedName.startsWith("System.Convert.To") && this.optimizeSystemConvert(mappedName, node)) {
            return null;
        }
        return new CSMethodInvocationExpression(new CSReferenceExpression(this.methodName(mappedName)), new CSExpression[0]);
    }

    private boolean optimizeSystemConvert(String mappedConstructor, ClassInstanceCreation node) {
        String typeName = this._configuration.getConvertRelatedWellKnownTypeName(mappedConstructor);
        if (typeName != null) {
            assert (1 == node.arguments().size());
            Expression arg = (Expression)node.arguments().get(0);
            if (arg.resolveTypeBinding() == this.resolveWellKnownType(typeName)) {
                arg.accept((ASTVisitor)this);
                return true;
            }
        }
        return false;
    }

    public boolean visit(TypeLiteral node) {
        if (this.isReferenceToRemovedType(node.getType())) {
            this.pushExpression(new CSRemovedExpression(node.toString()));
            return false;
        }
        this.pushTypeOfExpression(this.mappedTypeReference(node.getType()));
        return false;
    }

    private boolean isReferenceToRemovedType(Type node) {
        BodyDeclaration typeDeclaration = (BodyDeclaration)this.findDeclaringNode((IBinding)node.resolveBinding());
        if (typeDeclaration == null) {
            return false;
        }
        return this.hasRemoveAnnotation(typeDeclaration);
    }

    private void pushTypeOfExpression(CSTypeReferenceExpression type) {
        if (this._configuration.nativeTypeSystem()) {
            this.pushExpression(new CSTypeofExpression(type));
        } else {
            this.pushGetClassForTypeExpression(type);
        }
    }

    private void pushGetClassForTypeExpression(CSTypeReferenceExpression typeName) {
        CSMethodInvocationExpression mie = new CSMethodInvocationExpression(new CSReferenceExpression(this.methodName(String.valueOf(this._configuration.getRuntimeTypeName()) + ".getClassForType")), new CSExpression[0]);
        mie.addArgument(new CSTypeofExpression(typeName));
        this.pushExpression(mie);
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding binding = this.originalMethodBinding(node.resolveMethodBinding());
        Configuration.MemberMapping mapping = this.mappingForInvocation((ASTNode)node, binding);
        if (mapping != null) {
            this.processMappedMethodInvocation(node, binding, mapping);
        } else {
            this.processUnmappedMethodInvocation(node);
        }
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (node.getQualifier() != null) {
            this.notImplemented((ASTNode)node);
        }
        IMethodBinding binding = this.originalMethodBinding(node.resolveMethodBinding());
        Configuration.MemberMapping mapping = this.mappingForInvocation((ASTNode)node, binding);
        CSMemberReferenceExpression target = new CSMemberReferenceExpression(new CSBaseExpression(), this.mappedMethodName(binding));
        if (mapping != null && mapping.kind != MemberKind.Method) {
            this.pushExpression(target);
            return false;
        }
        CSMethodInvocationExpression mie = new CSMethodInvocationExpression(target, new CSExpression[0]);
        this.mapArguments(mie, node.arguments());
        this.pushExpression(mie);
        return false;
    }

    private Configuration.MemberMapping mappingForInvocation(ASTNode node, IMethodBinding binding) {
        Configuration.MemberMapping mapping = this.effectiveMappingFor(binding);
        if (mapping == null) {
            if (this.isIndexer(binding)) {
                mapping = new Configuration.MemberMapping(null, MemberKind.Indexer);
            } else if (this.isTaggedMethodInvocation(binding, "@sharpen.event")) {
                mapping = new Configuration.MemberMapping(binding.getName(), MemberKind.Property);
            } else if (this.isTaggedMethodInvocation(binding, "@sharpen.property")) {
                mapping = new Configuration.MemberMapping(this.propertyName(binding), MemberKind.Property);
            }
        }
        return mapping;
    }

    private boolean isIndexer(IMethodBinding binding) {
        return this.isTaggedMethod(binding, "@sharpen.indexer");
    }

    private boolean isTaggedMethod(IMethodBinding binding, String tag) {
        MethodDeclaration declaration = this.declaringNode(binding);
        if (declaration == null) {
            return false;
        }
        return this.isTaggedDeclaration(declaration, tag);
    }

    private IMethodBinding originalMethodBinding(IMethodBinding binding) {
        IMethodBinding original = BindingUtils.findMethodDefininition(binding, Environments.my(CompilationUnit.class).getAST());
        if (original != null) {
            return original;
        }
        return binding;
    }

    private void processUnmappedMethodInvocation(MethodInvocation node) {
        if (this.isMappedEventSubscription(node)) {
            this.processMappedEventSubscription(node);
            return;
        }
        if (this.isEventSubscription(node)) {
            this.processEventSubscription(node);
            return;
        }
        if (this.isRemovedMethodInvocation((Expression)node)) {
            this.processRemovedInvocation(node);
            return;
        }
        if (this.isUnwrapInvocation(node)) {
            this.processUnwrapInvocation(node);
            return;
        }
        if (this.isMacro(node)) {
            this.processMacroInvocation(node);
            return;
        }
        if (this.isEnumOrdinalMethodInvocation(node)) {
            this.processEnumOrdinalMethodInvocation(node);
            return;
        }
        if (this.isEnumNameMethodInvocation(node)) {
            this.processEnumNameMethodInvocation(node);
            return;
        }
        this.processOrdinaryMethodInvocation(node);
    }

    private boolean isMacro(MethodInvocation node) {
        return this.isTaggedMethodInvocation(node, "@sharpen.macro");
    }

    private void processMacroInvocation(MethodInvocation node) {
        MethodDeclaration declaration = this.declaringNode(node.resolveMethodBinding());
        TagElement macro = this.effectiveAnnotationFor(declaration, "@sharpen.macro");
        CSMacro code = new CSMacro(JavadocUtility.singleTextFragmentFrom(macro));
        code.addVariable("expression", this.mapExpression(node.getExpression()));
        code.addVariable("arguments", this.mapExpressions(node.arguments()));
        this.pushExpression(new CSMacroExpression(code));
    }

    private List<CSExpression> mapExpressions(List expressions) {
        ArrayList<CSExpression> result = new ArrayList<CSExpression>(expressions.size());
        for (Object expression : expressions) {
            result.add(this.mapExpression((Expression)expression));
        }
        return result;
    }

    private boolean isUnwrapInvocation(MethodInvocation node) {
        return this.isTaggedMethodInvocation(node, "@sharpen.unwrap");
    }

    private void processUnwrapInvocation(MethodInvocation node) {
        List arguments = node.arguments();
        if (arguments.size() != 1) {
            this.unsupportedConstruct((ASTNode)node, "@sharpen.unwrap only works against single argument methods.");
        }
        this.pushExpression(this.mapExpression((Expression)arguments.get(0)));
    }

    private void processOrdinaryMethodInvocation(MethodInvocation node) {
        IMethodBinding method = node.resolveMethodBinding();
        CSExpression targetExpression = this.mapMethodTargetExpression(node);
        if ((method.getModifiers() & 8) != 0 && !(targetExpression instanceof CSTypeReferenceExpression) && node.getExpression() != null) {
            targetExpression = this.mappedTypeReference(node.getExpression().resolveTypeBinding());
        }
        String name = this.resolveTargetMethodName(targetExpression, node);
        CSReferenceExpression target = targetExpression == null ? new CSReferenceExpression(name) : new CSMemberReferenceExpression(targetExpression, name);
        CSMethodInvocationExpression mie = new CSMethodInvocationExpression(target, new CSExpression[0]);
        this.mapMethodInvocationArguments(mie, node);
        this.mapTypeArguments(mie, node);
        IMethodBinding base = this.getOverridedMethod(method);
        if (base != null && base.getReturnType() != method.getReturnType() && !(node.getParent() instanceof ExpressionStatement)) {
            this.pushExpression(new CSParenthesizedExpression(new CSCastExpression(this.mappedTypeReference(method.getReturnType()), mie)));
        } else {
            this.pushExpression(mie);
        }
    }

    private String resolveTargetMethodName(CSExpression targetExpression, MethodInvocation node) {
        IMethodBinding method = StaticImports.staticImportMethodBinding(node.getName(), this._ast.imports());
        if (method != null && targetExpression == null) {
            return String.valueOf(this.mappedTypeName(method.getDeclaringClass())) + "." + this.mappedMethodName(node.resolveMethodBinding());
        }
        return this.mappedMethodName(node.resolveMethodBinding());
    }

    private void mapTypeArguments(CSMethodInvocationExpression mie, MethodInvocation node) {
        for (Object o : node.typeArguments()) {
            mie.addTypeArgument(this.mappedTypeReference((Type)o));
        }
    }

    private void processMappedEventSubscription(MethodInvocation node) {
        MethodInvocation event = (MethodInvocation)node.getExpression();
        String eventArgsType = this._configuration.mappedEvent(this.qualifiedName(event));
        String eventHandlerType = this.buildEventHandlerTypeName((ASTNode)node, eventArgsType);
        this.mapEventSubscription(node, eventArgsType, eventHandlerType);
    }

    private void processRemovedInvocation(MethodInvocation node) {
        TagElement element = this.javadocTagFor((BodyDeclaration)this.declaringNode(node.resolveMethodBinding()), "@sharpen.remove");
        String exchangeValue = JavadocUtility.singleTextFragmentFrom(element);
        this.pushExpression(new CSReferenceExpression(exchangeValue));
    }

    private void processEnumOrdinalMethodInvocation(MethodInvocation node) {
        CSExpression exp = this.mapExpression(node.getExpression());
        this.pushExpression(new CSCastExpression(new CSTypeReference("int"), new CSParenthesizedExpression(exp)));
    }

    private void processEnumNameMethodInvocation(MethodInvocation node) {
        CSExpression exp = this.mapExpression(node.getExpression());
        this.pushExpression(new CSMethodInvocationExpression(new CSMemberReferenceExpression(exp, "ToString"), new CSExpression[0]));
    }

    private void mapMethodInvocationArguments(CSMethodInvocationExpression mie, MethodInvocation node) {
        List arguments = node.arguments();
        IMethodBinding actualMethod = node.resolveMethodBinding();
        ITypeBinding[] actualTypes = actualMethod.getParameterTypes();
        IMethodBinding originalMethod = actualMethod.getMethodDeclaration();
        ITypeBinding[] originalTypes = originalMethod.getParameterTypes();
        int i = 0;
        while (i < arguments.size()) {
            Expression arg = (Expression)arguments.get(i);
            if (i < originalTypes.length && this.isGenericRuntimeParameterIdiom(originalMethod, originalTypes[i]) && this.isClassLiteral(arg)) {
                mie.addTypeArgument(this.genericRuntimeTypeIdiomType(actualTypes[i]));
            } else {
                this.addArgument(mie, arg, i < actualTypes.length ? actualTypes[i] : null);
            }
            ++i;
        }
        this.adjustJUnitArguments(mie, node);
    }

    private void adjustJUnitArguments(CSMethodInvocationExpression mie, MethodInvocation node) {
        if (!this._configuration.junitConversion()) {
            return;
        }
        ITypeBinding t = node.resolveMethodBinding().getDeclaringClass();
        if (t.getQualifiedName().equals("junit.framework.Assert") || t.getQualifiedName().equals("org.junit.Assert")) {
            String method = node.getName().getIdentifier();
            int np = -1;
            if (method.equals("assertTrue") || method.equals("assertFalse") || method.equals("assertNull") || method.equals("assertNotNull")) {
                np = 1;
            } else if (method.equals("fail")) {
                np = 0;
            } else if (method.startsWith("assert")) {
                np = 2;
            }
            if (np == -1) {
                return;
            }
            if (mie.arguments().size() == np + 1) {
                mie.addArgument(mie.arguments().get(0));
                mie.removeArgument(0);
            }
            if (method.equals("assertSame")) {
                boolean useEquals = false;
                List arguments = node.arguments();
                int i = 0;
                while (i < arguments.size()) {
                    Expression arg = (Expression)arguments.get(i);
                    ITypeBinding b = arg.resolveTypeBinding();
                    if (b.isEnum()) {
                        useEquals = true;
                        break;
                    }
                    ++i;
                }
                if (useEquals) {
                    CSReferenceExpression mref = (CSReferenceExpression)mie.expression();
                    mref.name("NUnit.Framework.Assert.AreEqual");
                }
            }
        }
    }

    private boolean isClassLiteral(Expression arg) {
        return arg.getNodeType() == 57;
    }

    private void processEventSubscription(MethodInvocation node) {
        MethodDeclaration addListener = this.declaringNode(node.resolveMethodBinding());
        this.assertValidEventAddListener((ASTNode)node, addListener);
        MethodInvocation eventInvocation = (MethodInvocation)node.getExpression();
        MethodDeclaration eventDeclaration = this.declaringNode(eventInvocation.resolveMethodBinding());
        this.mapEventSubscription(node, this.getEventArgsType(eventDeclaration), this.getEventHandlerTypeName(eventDeclaration));
    }

    private void mapEventSubscription(MethodInvocation node, String eventArgsType, String eventHandlerType) {
        CSAnonymousClassBuilder listenerBuilder = this.mapAnonymousEventListener(node);
        CSMemberReferenceExpression handlerMethodRef = new CSMemberReferenceExpression(listenerBuilder.createConstructorInvocation(), this.eventListenerMethodName(listenerBuilder));
        CSReferenceExpression delegateType = new CSReferenceExpression(eventHandlerType);
        this.patchEventListener(listenerBuilder, eventArgsType);
        CSConstructorInvocationExpression delegateConstruction = new CSConstructorInvocationExpression(delegateType);
        delegateConstruction.addArgument(handlerMethodRef);
        this.pushExpression(new CSInfixExpression("+=", this.mapMethodTargetExpression(node), delegateConstruction));
    }

    private CSAnonymousClassBuilder mapAnonymousEventListener(MethodInvocation node) {
        ClassInstanceCreation creation = (ClassInstanceCreation)node.arguments().get(0);
        return this.mapAnonymousClass(creation.getAnonymousClassDeclaration());
    }

    private String eventListenerMethodName(CSAnonymousClassBuilder listenerBuilder) {
        return this.mappedMethodName(this.getFirstMethod(listenerBuilder.anonymousBaseType()));
    }

    private void patchEventListener(CSAnonymousClassBuilder listenerBuilder, String eventArgsType) {
        CSClass type = listenerBuilder.type();
        type.clearBaseTypes();
        CSMethod handlerMethod = (CSMethod)type.getMember(this.eventListenerMethodName(listenerBuilder));
        handlerMethod.parameters().get(0).type(OBJECT_TYPE_REFERENCE);
        handlerMethod.parameters().get(0).name("sender");
        handlerMethod.parameters().get(1).type(new CSTypeReference(eventArgsType));
    }

    private IMethodBinding getFirstMethod(ITypeBinding listenerType) {
        return listenerType.getDeclaredMethods()[0];
    }

    private void assertValidEventAddListener(ASTNode source, MethodDeclaration addListener) {
        if (this.isValidEventAddListener(addListener)) {
            return;
        }
        this.unsupportedConstruct(source, "@sharpen.event.add must take lone single method interface argument");
    }

    private boolean isValidEventAddListener(MethodDeclaration addListener) {
        if (1 != addListener.parameters().size()) {
            return false;
        }
        ITypeBinding type = this.getFirstParameterType(addListener);
        if (!type.isInterface()) {
            return false;
        }
        return type.getDeclaredMethods().length == 1;
    }

    private ITypeBinding getFirstParameterType(MethodDeclaration addListener) {
        return this.parameter(addListener, 0).getType().resolveBinding();
    }

    private SingleVariableDeclaration parameter(MethodDeclaration method, int index) {
        return (SingleVariableDeclaration)method.parameters().get(index);
    }

    private boolean isEventSubscription(MethodInvocation node) {
        return this.isTaggedMethodInvocation(node, "@sharpen.event.add");
    }

    private boolean isMappedEventSubscription(MethodInvocation node) {
        return this._configuration.isMappedEventAdd(this.qualifiedName(node));
    }

    private String qualifiedName(MethodInvocation node) {
        return this.qualifiedName(node.resolveMethodBinding());
    }

    private boolean isTaggedMethodInvocation(MethodInvocation node, String tag) {
        return this.isTaggedMethodInvocation(node.resolveMethodBinding(), tag);
    }

    private boolean isTaggedMethodInvocation(IMethodBinding binding, String tag) {
        MethodDeclaration method = this.declaringNode(this.originalMethodBinding(binding));
        if (method == null) {
            return false;
        }
        return CSharpBuilder.containsJavadoc((BodyDeclaration)method, tag);
    }

    private void processMappedMethodInvocation(MethodInvocation node, IMethodBinding binding, Configuration.MemberMapping mapping) {
        if (mapping.kind == MemberKind.Indexer) {
            this.processIndexerInvocation(node, binding, mapping);
            return;
        }
        String name = this.mappedMethodName(binding);
        if (name.length() == 0) {
            Expression expression = node.getExpression();
            CSExpression target = expression != null ? this.mapExpression(expression) : new CSThisExpression();
            this.pushExpression(target);
            return;
        }
        boolean isMappingToStaticMethod = this.isMappingToStaticMember(name);
        List arguments = node.arguments();
        CSExpression expression = this.mapMethodTargetExpression(node);
        CSExpression target = null;
        if (expression == null || isMappingToStaticMethod) {
            target = new CSReferenceExpression(name);
        } else if (BindingUtils.isStatic(binding) && arguments.size() > 0) {
            target = new CSMemberReferenceExpression(this.parensIfNeeded(this.mapExpression((Expression)arguments.get(0))), name);
            arguments = arguments.subList(1, arguments.size());
        } else {
            target = new CSMemberReferenceExpression(expression, name);
        }
        if (mapping.kind != MemberKind.Method) {
            IMethodBinding originalBinding = node.resolveMethodBinding();
            if (binding != originalBinding && originalBinding.getReturnType() != binding.getReturnType() && !(node.getParent() instanceof ExpressionStatement)) {
                target = new CSParenthesizedExpression(new CSCastExpression(this.mappedTypeReference(originalBinding.getReturnType()), target));
            }
            switch (arguments.size()) {
                case 0: {
                    this.pushExpression(target);
                    break;
                }
                case 1: {
                    this.pushExpression(new CSInfixExpression("=", target, this.mapExpression((Expression)arguments.get(0))));
                    break;
                }
                default: {
                    this.unsupportedConstruct((ASTNode)node, "Method invocation with more than 1 argument mapped to property");
                }
            }
            return;
        }
        CSMethodInvocationExpression mie = new CSMethodInvocationExpression(target, new CSExpression[0]);
        if (isMappingToStaticMethod && this.isInstanceMethod(binding)) {
            if (expression == null) {
                mie.addArgument(new CSThisExpression());
            } else {
                mie.addArgument(expression);
            }
        }
        this.mapArguments(mie, arguments);
        this.adjustJUnitArguments(mie, node);
        this.pushExpression(mie);
    }

    private void processIndexerInvocation(MethodInvocation node, IMethodBinding binding, Configuration.MemberMapping mapping) {
        if (node.arguments().size() == 1) {
            this.processIndexerGetter(node);
        } else {
            this.processIndexerSetter(node);
        }
    }

    private void processIndexerSetter(MethodInvocation node) {
        CSIndexedExpression indexer = new CSIndexedExpression(this.mapIndexerTarget(node));
        List arguments = node.arguments();
        Expression lastArgument = (Expression)arguments.get(arguments.size() - 1);
        int i = 0;
        while (i < arguments.size() - 1) {
            indexer.addIndex(this.mapExpression((Expression)arguments.get(i)));
            ++i;
        }
        this.pushExpression(CSharpCode.newAssignment(indexer, this.mapExpression(lastArgument)));
    }

    private void processIndexerGetter(MethodInvocation node) {
        Expression singleArgument = (Expression)node.arguments().get(0);
        this.pushExpression(new CSIndexedExpression(this.mapIndexerTarget(node), this.mapExpression(singleArgument)));
    }

    private CSExpression mapIndexerTarget(MethodInvocation node) {
        if (node.getExpression() == null) {
            return new CSThisExpression();
        }
        return this.mapMethodTargetExpression(node);
    }

    private CSExpression parensIfNeeded(CSExpression expression) {
        if (expression instanceof CSInfixExpression || expression instanceof CSPrefixExpression || expression instanceof CSPostfixExpression) {
            return new CSParenthesizedExpression(expression);
        }
        return expression;
    }

    protected CSExpression mapMethodTargetExpression(MethodInvocation node) {
        return this.mapExpression(node.getExpression());
    }

    private boolean isInstanceMethod(IMethodBinding binding) {
        return !BindingUtils.isStatic(binding);
    }

    private boolean isMappingToStaticMember(String name) {
        return -1 != name.indexOf(46);
    }

    protected void mapArguments(CSMethodInvocationExpression mie, List arguments) {
        for (Object arg : arguments) {
            this.addArgument(mie, (Expression)arg, null);
        }
    }

    private void addArgument(CSMethodInvocationExpression mie, Expression arg, ITypeBinding expectedType) {
        mie.addArgument(this.mapExpression(expectedType, arg));
    }

    public boolean visit(FieldAccess node) {
        String name = this.identifier(this.mappedFieldName(node));
        if (node.getExpression() == null) {
            this.pushExpression(new CSReferenceExpression(name));
        } else {
            this.pushExpression(new CSMemberReferenceExpression(this.mapExpression(node.getExpression()), name));
        }
        return false;
    }

    String mapVariableName(String name) {
        if (this._renamedVariables.size() > 0) {
            String newName;
            String vname = name;
            if (vname.startsWith("@")) {
                vname = vname.substring(1);
            }
            if ((newName = this._renamedVariables.peek().get(vname)) != null) {
                return newName;
            }
        }
        return name;
    }

    private boolean isBoolLiteral(String name) {
        return name.equals("true") || name.equals("false");
    }

    private String mappedFieldName(FieldAccess node) {
        String name = this.mappedFieldName((Name)node.getName());
        if (name != null) {
            return name;
        }
        return this.identifier(node.getName());
    }

    public boolean visit(SimpleName node) {
        if (this.isTypeReference((Name)node)) {
            this.pushTypeReference(node.resolveTypeBinding());
        } else if (this._currentExpression == null) {
            ITypeBinding cls;
            IVariableBinding vb;
            String ident = this.mapVariableName(this.identifier(node));
            IBinding b = node.resolveBinding();
            IVariableBinding iVariableBinding = vb = b instanceof IVariableBinding ? (IVariableBinding)b : null;
            if (vb != null && (cls = vb.getDeclaringClass()) != null) {
                if (StaticImports.isStaticImport(vb, this._ast.imports())) {
                    if (cls != null) {
                        this.pushExpression(new CSMemberReferenceExpression(this.mappedTypeReference(cls), ident));
                        return false;
                    }
                } else if (cls.isEnum() && ident.indexOf(46) == -1) {
                    this.pushExpression(new CSMemberReferenceExpression(this.mappedTypeReference(cls), ident));
                    return false;
                }
            }
            this.pushExpression(new CSReferenceExpression(ident));
        }
        return false;
    }

    private void addStatement(CSStatement statement) {
        this._currentBlock.addStatement(statement);
    }

    private void pushTypeReference(ITypeBinding typeBinding) {
        this.pushExpression(this.mappedTypeReference(typeBinding));
    }

    protected CSReferenceExpression createTypeReference(ITypeBinding typeBinding) {
        return new CSReferenceExpression(this.mappedTypeName(typeBinding));
    }

    private boolean isTypeReference(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding == null) {
            this.unresolvedTypeBinding((ASTNode)node);
            return false;
        }
        return 2 == binding.getKind();
    }

    public boolean visit(QualifiedName node) {
        if (this.isTypeReference((Name)node)) {
            this.pushTypeReference(node.resolveTypeBinding());
        } else {
            String primitiveTypeRef = this.checkForPrimitiveTypeReference(node);
            if (primitiveTypeRef != null) {
                this.pushTypeOfExpression(new CSTypeReference(primitiveTypeRef));
            } else {
                this.handleRegularQualifiedName(node);
            }
        }
        return false;
    }

    private void handleRegularQualifiedName(QualifiedName node) {
        String mapped = this.mappedFieldName((Name)node);
        if (mapped != null) {
            if (this.isBoolLiteral(mapped)) {
                this.pushExpression(new CSBoolLiteralExpression(Boolean.parseBoolean(mapped)));
                return;
            }
            if (this.isMappingToStaticMember(mapped)) {
                this.pushExpression(new CSReferenceExpression(mapped));
            } else {
                this.pushMemberReferenceExpression(node.getQualifier(), mapped);
            }
        } else {
            Name qualifier = node.getQualifier();
            String name = this.identifier(node.getName().getIdentifier());
            this.pushMemberReferenceExpression(qualifier, name);
        }
    }

    private String checkForPrimitiveTypeReference(QualifiedName node) {
        String name = this.qualifiedName(node);
        if (name.equals(JAVA_LANG_VOID_TYPE)) {
            return "void";
        }
        if (name.equals(JAVA_LANG_BOOLEAN_TYPE)) {
            return "bool";
        }
        if (name.equals(JAVA_LANG_BYTE_TYPE)) {
            return this._configuration.mapByteToSbyte() ? "sbyte" : "byte";
        }
        if (name.equals(JAVA_LANG_CHARACTER_TYPE)) {
            return "char";
        }
        if (name.equals(JAVA_LANG_SHORT_TYPE)) {
            return "short";
        }
        if (name.equals(JAVA_LANG_INTEGER_TYPE)) {
            return "int";
        }
        if (name.equals(JAVA_LANG_LONG_TYPE)) {
            return "long";
        }
        if (name.equals(JAVA_LANG_FLOAT_TYPE)) {
            return "float";
        }
        if (name.equals(JAVA_LANG_DOUBLE_TYPE)) {
            return "double";
        }
        return null;
    }

    private String qualifiedName(QualifiedName node) {
        IVariableBinding binding = this.variableBinding((Name)node);
        if (binding == null) {
            return node.toString();
        }
        return BindingUtils.qualifiedName(binding);
    }

    private void pushMemberReferenceExpression(Name qualifier, String name) {
        this.pushExpression(new CSMemberReferenceExpression(this.mapExpression((Expression)qualifier), name));
    }

    private IVariableBinding variableBinding(Name node) {
        if (node.resolveBinding() instanceof IVariableBinding) {
            return (IVariableBinding)node.resolveBinding();
        }
        return null;
    }

    private String mappedFieldName(Name node) {
        IVariableBinding binding = this.variableBinding(node);
        return binding == null ? null : Environments.my(Mappings.class).mappedFieldName(binding);
    }

    protected CSExpression mapExpression(Expression expression) {
        if (expression == null) {
            return null;
        }
        try {
            expression.accept((ASTVisitor)this);
            return this.popExpression();
        }
        catch (Exception e) {
            this.unsupportedConstruct((ASTNode)expression, e);
            return null;
        }
    }

    private void unsupportedConstruct(ASTNode node, Exception cause) {
        this.unsupportedConstruct(node, "failed to map: '" + node + "'", cause);
    }

    private void unsupportedConstruct(ASTNode node, String message) {
        this.unsupportedConstruct(node, message, null);
    }

    private void unsupportedConstruct(ASTNode node, String message, Exception cause) {
        throw new IllegalArgumentException(String.valueOf(this.sourceInformation(node)) + ": " + message, cause);
    }

    private ITypeBinding pushExpectedType(ITypeBinding type) {
        ITypeBinding old = this._currentExpectedType;
        this._currentExpectedType = type;
        return old;
    }

    private void popExpectedType(ITypeBinding saved) {
        this._currentExpectedType = saved;
    }

    protected void pushExpression(CSExpression expression) {
        if (this._currentExpression != null) {
            throw new IllegalStateException();
        }
        this._currentExpression = expression;
    }

    private CSExpression popExpression() {
        if (this._currentExpression == null) {
            throw new IllegalStateException();
        }
        CSExpression found = this._currentExpression;
        this._currentExpression = null;
        return found;
    }

    private CSVariableDeclaration createParameter(SingleVariableDeclaration declaration) {
        return this.createVariableDeclaration(declaration.resolveBinding(), null);
    }

    protected void visit(List nodes) {
        for (Object node : nodes) {
            ((ASTNode)node).accept((ASTVisitor)this);
        }
    }

    private void createInheritedAbstractMemberStubs(TypeDeclaration node) {
        if (node.isInterface()) {
            return;
        }
        ITypeBinding binding = node.resolveBinding();
        if (!Modifier.isAbstract((int)node.getModifiers())) {
            return;
        }
        LinkedHashSet<ITypeBinding> interfaces = new LinkedHashSet<ITypeBinding>();
        this.collectInterfaces(interfaces, binding);
        for (ITypeBinding baseType : interfaces) {
            this.createInheritedAbstractMemberStubs(binding, baseType);
        }
    }

    private void collectInterfaces(Set<ITypeBinding> interfaceList, ITypeBinding binding) {
        ITypeBinding[] interfaces = binding.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            ITypeBinding interfaceBinding = interfaces[i];
            if (!interfaceList.contains(interfaceBinding)) {
                this.collectInterfaces(interfaceList, interfaceBinding);
                interfaceList.add(interfaceBinding);
            }
            ++i;
        }
    }

    private void createInheritedAbstractMemberStubs(ITypeBinding type, ITypeBinding baseType) {
        IMethodBinding[] methods = baseType.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            if (Modifier.isAbstract((int)method.getModifiers()) && BindingUtils.findOverriddenMethodInTypeOrSuperclasses(type, method) == null && !this.isIgnored(this.originalMethodBinding(method))) {
                if (this.stubIsProperty(method)) {
                    this._currentType.addMember(this.createAbstractPropertyStub(method));
                } else {
                    CSMethod newMethod = this.createAbstractMethodStub(method);
                    if (!this._currentType.members().contains(newMethod)) {
                        this._currentType.addMember(newMethod);
                    }
                }
            }
            ++i;
        }
    }

    private boolean isIgnored(IMethodBinding binding) {
        MethodDeclaration dec = this.declaringNode(binding);
        return dec != null && SharpenAnnotations.hasIgnoreAnnotation((BodyDeclaration)dec);
    }

    private boolean stubIsProperty(IMethodBinding method) {
        MethodDeclaration dec = this.declaringNode(method);
        return dec != null && this.isProperty(dec);
    }

    private MethodDeclaration declaringNode(IMethodBinding method) {
        return (MethodDeclaration)this.findDeclaringNode((IBinding)method);
    }

    private CSProperty createAbstractPropertyStub(IMethodBinding method) {
        CSProperty stub = this.newAbstractPropertyStubFor(method);
        this.safeProcessDisableTags(method, stub);
        return stub;
    }

    private CSProperty newAbstractPropertyStubFor(IMethodBinding method) {
        CSProperty stub = new CSProperty(this.mappedMethodName(method), this.mappedTypeReference(method.getReturnType()));
        stub.modifier(CSMethodModifier.Abstract);
        stub.visibility(this.mapVisibility(method.getModifiers()));
        stub.getter(new CSBlock());
        return stub;
    }

    private CSMethod createAbstractMethodStub(IMethodBinding method) {
        CSMethod stub = this.newAbstractMethodStubFor(method);
        this.safeProcessDisableTags(method, stub);
        return stub;
    }

    private CSMethod newAbstractMethodStubFor(IMethodBinding method) {
        CSMethod stub = new CSMethod(this.mappedMethodName(method));
        stub.modifier(CSMethodModifier.Abstract);
        stub.visibility(this.mapVisibility(method.getModifiers()));
        stub.returnType(this.mappedTypeReference(method.getReturnType()));
        ITypeBinding[] parameters = method.getParameterTypes();
        int i = 0;
        while (i < parameters.length) {
            stub.addParameter(new CSVariableDeclaration("arg" + (i + 1), this.mappedTypeReference(parameters[i])));
            ++i;
        }
        return stub;
    }

    private void safeProcessDisableTags(IMethodBinding method, CSMember member) {
        MethodDeclaration node = this.declaringNode(method);
        if (node == null) {
            return;
        }
        this.processDisableTags((BodyDeclaration)node, (CSNode)member);
    }

    CSMethodModifier mapMethodModifier(MethodDeclaration method) {
        if (this._currentType.isInterface() || method.resolveBinding().getDeclaringClass().isInterface()) {
            return CSMethodModifier.Abstract;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic((int)modifiers)) {
            return CSMethodModifier.Static;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return CSMethodModifier.None;
        }
        boolean override = this.isOverride(method);
        if (Modifier.isAbstract((int)modifiers)) {
            return override ? CSMethodModifier.AbstractOverride : CSMethodModifier.Abstract;
        }
        boolean isFinal = Modifier.isFinal((int)modifiers);
        if (override) {
            return isFinal ? CSMethodModifier.Sealed : this.modifierIfNewAnnotationNotApplied(method, CSMethodModifier.Override);
        }
        return isFinal || this._currentType.isSealed() ? CSMethodModifier.None : CSMethodModifier.Virtual;
    }

    private CSMethodModifier modifierIfNewAnnotationNotApplied(MethodDeclaration method, CSMethodModifier modifier) {
        return CSharpBuilder.containsJavadoc((BodyDeclaration)method, "@sharpen.new") ? CSMethodModifier.None : modifier;
    }

    private boolean isExtractedNestedType(ITypeBinding type) {
        return this._configuration.typeHasMapping(BindingUtils.typeMappingKey(type));
    }

    private boolean isOverride(MethodDeclaration method) {
        return this.getOverridedMethod(method) != null;
    }

    private IMethodBinding getOverridedMethod(MethodDeclaration method) {
        return this.getOverridedMethod(method.resolveBinding());
    }

    private IMethodBinding getOverridedMethod(IMethodBinding methodBinding) {
        IMethodBinding result;
        ITypeBinding superclass;
        ITypeBinding iTypeBinding = superclass = this._ignoreExtends.value() != false ? this.resolveWellKnownType("java.lang.Object") : methodBinding.getDeclaringClass().getSuperclass();
        if (superclass != null && (result = BindingUtils.findOverriddenMethodInHierarchy(superclass, methodBinding)) != null) {
            return result;
        }
        ITypeBinding[] baseInterfaces = methodBinding.getDeclaringClass().getInterfaces();
        if (baseInterfaces.length == 1 && !this.isValidCSInterface(baseInterfaces[0])) {
            return BindingUtils.findOverriddenMethodInType(baseInterfaces[0], methodBinding);
        }
        return null;
    }

    private boolean isValidCSInterface(ITypeBinding type) {
        if (type.getTypeDeclaration().getQualifiedName().equals("java.util.Iterator") || type.getTypeDeclaration().getQualifiedName().equals("java.lang.Iterable")) {
            return false;
        }
        if (type.getDeclaredFields().length != 0) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray = type.getDeclaredTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding ntype = iTypeBindingArray[n2];
            if (!this.isExtractedNestedType(ntype)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    CSClassModifier mapClassModifier(int modifiers) {
        if (Modifier.isAbstract((int)modifiers)) {
            return CSClassModifier.Abstract;
        }
        if (Modifier.isFinal((int)modifiers)) {
            return CSClassModifier.Sealed;
        }
        return CSClassModifier.None;
    }

    void adjustVisibility(ITypeBinding memberType, CSMember member) {
        if (memberType == null) {
            return;
        }
        CSVisibility typeVisibility = this.mapVisibility(memberType.getModifiers());
        if (typeVisibility == CSVisibility.Protected && member.visibility() == CSVisibility.Internal) {
            member.visibility(CSVisibility.Protected);
        }
    }

    CSVisibility mapVisibility(BodyDeclaration node) {
        if (CSharpBuilder.containsJavadoc(node, "@sharpen.internal")) {
            return CSVisibility.Internal;
        }
        if (CSharpBuilder.containsJavadoc(node, "@sharpen.private")) {
            return CSVisibility.Private;
        }
        if (CSharpBuilder.containsJavadoc(node, "@sharpen.protected")) {
            return CSVisibility.Protected;
        }
        if (CSharpBuilder.containsJavadoc(node, "@sharpen.public")) {
            return CSVisibility.Public;
        }
        return this.mapVisibility(node.getModifiers());
    }

    CSVisibility mapVisibility(int modifiers) {
        if (Modifier.isPublic((int)modifiers)) {
            return CSVisibility.Public;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return this._configuration.mapProtectedToProtectedInternal() ? CSVisibility.ProtectedInternal : CSVisibility.Protected;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return CSVisibility.Private;
        }
        return CSVisibility.Internal;
    }

    protected CSTypeReferenceExpression mappedTypeReference(Type type) {
        return this.mappedTypeReference(type.resolveBinding());
    }

    private CSTypeReferenceExpression mappedMacroTypeReference(ITypeBinding typeUsage, TypeDeclaration typeDeclaration) {
        CSMacro macro = new CSMacro(JavadocUtility.singleTextFragmentFrom(this.javadocTagFor((BodyDeclaration)typeDeclaration, "@sharpen.macro")));
        ITypeBinding[] typeArguments = typeUsage.getTypeArguments();
        if (typeArguments.length > 0) {
            ITypeBinding[] typeParameters = typeUsage.getTypeDeclaration().getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                macro.addVariable(typeParameters[i].getName(), this.mappedTypeReference(typeArguments[i]));
                ++i;
            }
        }
        return new CSMacroTypeReference(macro);
    }

    private boolean isMacroType(ASTNode declaration) {
        return declaration instanceof TypeDeclaration && CSharpBuilder.containsJavadoc((BodyDeclaration)((TypeDeclaration)declaration), "@sharpen.macro");
    }

    protected CSTypeReferenceExpression mappedTypeReference(ITypeBinding type) {
        Object declaration = this.findDeclaringNode((IBinding)type);
        if (this.isMacroType((ASTNode)declaration)) {
            return this.mappedMacroTypeReference(type, (TypeDeclaration)declaration);
        }
        if (type.isArray()) {
            return this.mappedArrayTypeReference(type);
        }
        if (type.isWildcardType()) {
            return this.mappedWildcardTypeReference(type);
        }
        CSTypeReference typeRef = new CSTypeReference(this.mappedTypeName(type));
        if (this.isJavaLangClass(type)) {
            return typeRef;
        }
        ITypeBinding[] iTypeBindingArray = type.getTypeArguments();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding arg = iTypeBindingArray[n2];
            typeRef.addTypeArgument(this.mappedTypeReference(arg));
            ++n2;
        }
        return typeRef;
    }

    private boolean isJavaLangClass(ITypeBinding type) {
        return type.getErasure() == this.javaLangClassBinding();
    }

    private ITypeBinding javaLangClassBinding() {
        return this.resolveWellKnownType("java.lang.Class");
    }

    private CSTypeReferenceExpression mappedWildcardTypeReference(ITypeBinding type) {
        ITypeBinding bound = type.getBound();
        return bound != null ? this.mappedTypeReference(bound) : OBJECT_TYPE_REFERENCE;
    }

    private CSTypeReferenceExpression mappedArrayTypeReference(ITypeBinding type) {
        return new CSArrayTypeReference(this.mappedTypeReference(type.getElementType()), type.getDimensions());
    }

    protected final String mappedTypeName(ITypeBinding type) {
        return Environments.my(Mappings.class).mappedTypeName(type);
    }

    private static String qualifiedName(ITypeBinding type) {
        return BindingUtils.qualifiedName(type);
    }

    private String interfaceName(String name) {
        return Environments.my(Configuration.class).toInterfaceName(name);
    }

    private String mappedTypeName(String typeName) {
        return this.mappedTypeName(typeName, typeName);
    }

    private String mappedTypeName(String typeName, String defaultValue) {
        return this._configuration.mappedTypeName(typeName, defaultValue);
    }

    private String annotatedRenaming(BodyDeclaration node) {
        return Environments.my(Annotations.class).annotatedRenaming(node);
    }

    protected String mappedMethodName(MethodDeclaration node) {
        return this.mappedMethodName(node.resolveBinding());
    }

    protected final String mappedMethodName(IMethodBinding binding) {
        return Environments.my(Mappings.class).mappedMethodName(binding);
    }

    private String qualifiedName(IMethodBinding actual) {
        return BindingUtils.qualifiedName(actual);
    }

    private boolean isEvent(MethodDeclaration declaring) {
        return this.eventTagFor(declaring) != null;
    }

    private boolean isMappedToProperty(MethodDeclaration original) {
        Configuration.MemberMapping mapping = this.effectiveMappingFor(original.resolveBinding());
        if (mapping == null) {
            return false;
        }
        return mapping.kind == MemberKind.Property;
    }

    private Configuration.MemberMapping effectiveMappingFor(IMethodBinding binding) {
        return Environments.my(Mappings.class).effectiveMappingFor(binding);
    }

    private String methodName(String name) {
        return this.namingStrategy().methodName(name);
    }

    protected String identifier(SimpleName name) {
        return this.identifier(name.toString());
    }

    protected String identifier(String name) {
        return this.namingStrategy().identifier(name);
    }

    private void unresolvedTypeBinding(ASTNode node) {
        this.warning(node, "unresolved type binding for node: " + node);
    }

    public boolean visit(CompilationUnit node) {
        return true;
    }

    private void warning(ASTNode node, String message) {
        this.warningHandler().warning(node, message);
    }

    protected final String sourceInformation(ASTNode node) {
        return ASTUtility.sourceInformation(this._ast, node);
    }

    protected int lineNumber(ASTNode node) {
        return this._ast.lineNumber(node.getStartPosition());
    }

    public void setASTResolver(ASTResolver resolver) {
        this._resolver = resolver;
    }

    private String mappedNamespace(String namespace) {
        return this._configuration.mappedNamespace(namespace);
    }

    public boolean visit(Block node) {
        if (this.isBlockInsideBlock(node)) {
            CSBlock parent = this._currentBlock;
            this._currentBlock = new CSBlock();
            this._currentBlock.parent(parent);
            parent.addStatement(this._currentBlock);
        }
        this._currentContinueLabel = null;
        this.pushScope();
        return super.visit(node);
    }

    public void endVisit(Block node) {
        if (this.isBlockInsideBlock(node)) {
            this._currentBlock = (CSBlock)this._currentBlock.parent();
        }
        this.popScope();
        super.endVisit(node);
    }

    boolean isBlockInsideBlock(Block node) {
        return node.getParent() instanceof Block;
    }

    void pushScope() {
        HashSet newLocalVars = new HashSet();
        if (this._localBlockVariables.size() > 0) {
            newLocalVars.addAll(this._localBlockVariables.peek());
        }
        this._localBlockVariables.push(newLocalVars);
        HashSet newBlockVars = new HashSet();
        newBlockVars.addAll(newLocalVars);
        this._blockVariables.push(newBlockVars);
        HashMap newRenamed = new HashMap();
        if (this._renamedVariables.size() > 0) {
            newRenamed.putAll(this._renamedVariables.peek());
        }
        this._renamedVariables.push(newRenamed);
    }

    void popScope() {
        this._blockVariables.pop();
        this._localBlockVariables.pop();
        this._renamedVariables.pop();
    }

    private static final class CheckVariableUseVisitor
    extends ASTVisitor {
        private final IVariableBinding _var;
        private boolean _used;

        private CheckVariableUseVisitor(IVariableBinding var) {
            this._var = var;
        }

        public boolean visit(SimpleName name) {
            IBinding binding = name.resolveBinding();
            if (binding == null) {
                return false;
            }
            if (binding.equals((Object)this._var)) {
                this._used = true;
            }
            return false;
        }

        public boolean used() {
            return this._used;
        }
    }

    private static final class FieldAccessFinder
    extends ASTVisitor {
        public IBinding field;

        private FieldAccessFinder() {
        }

        public boolean visit(SimpleName node) {
            this.field = node.resolveBinding();
            return false;
        }
    }
}

