/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.languages.dataobject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/**
 *
 * @author  hanz
 */
public class GLFFilesCustomEditor extends javax.swing.JPanel {
    
    /** Creates new form GLFFilesCustomEditor */
    public GLFFilesCustomEditor () {
        initComponents ();
        List<String> mimeTypes = getSupportedMimeTypes ();
        Collections.sort (mimeTypes);
        DefaultListModel model = new DefaultListModel ();
        Iterator<String> it = mimeTypes.iterator ();
        while (it.hasNext ()) {
            String name = (String) it.next ();
            model.addElement (name);
        }
        lFiles.setModel (model);    
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings ("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        spFiles = new javax.swing.JScrollPane();
        lFiles = new javax.swing.JList();
        bEdit = new javax.swing.JButton();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(GLFFilesCustomEditor.class, "GLFFilesCustomEditor.jLabel1.text")); // NOI18N

        spFiles.setViewportView(lFiles);

        bEdit.setText(org.openide.util.NbBundle.getMessage(GLFFilesCustomEditor.class, "GLFFilesCustomEditor.bEdit.text")); // NOI18N
        bEdit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bEditActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabel1)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(spFiles, javax.swing.GroupLayout.DEFAULT_SIZE, 75, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(bEdit))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(bEdit)
                        .addContainerGap())
                    .addComponent(spFiles, javax.swing.GroupLayout.DEFAULT_SIZE, 139, Short.MAX_VALUE)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private static List<String> getSupportedMimeTypes () {
        List<String> result = new ArrayList<String> ();
        FileSystem fs = Repository.getDefault ().getDefaultFileSystem ();
        FileObject root = fs.findResource ("Editors");
        Enumeration e1 = root.getChildren (false);
        while (e1.hasMoreElements ()) {
            FileObject f1 = (FileObject) e1.nextElement ();
            if (f1.isData ()) continue;
            Enumeration e2 = f1.getChildren (false);
            while (e2.hasMoreElements ()) {
                FileObject f2 = (FileObject) e2.nextElement ();
                if (f2.isData ()) continue;
                FileObject fo = f2.getFileObject ("language.nbs");
                if (fo == null) continue;
                result.add (f1.getName () + '/' + f2.getName ());
            }
        }
        return result;
    }
    
    private void bEditActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bEditActionPerformed
        String mimeType = (String) lFiles.getSelectedValue ();
        if (mimeType == null) return;
        FileObject fileObject = Repository.getDefault ().getDefaultFileSystem ().findResource ("Editors/" + mimeType + "/language.nbs");
        try {
            DataObject dataObject = DataObject.find (fileObject);
            OpenCookie openCookie = dataObject.getCookie (OpenCookie.class);
            openCookie.open ();
        } catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace (ex);
        }
}//GEN-LAST:event_bEditActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bEdit;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList lFiles;
    private javax.swing.JScrollPane spFiles;
    // End of variables declaration//GEN-END:variables
    
}
