// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _RWStl_HeaderFile
#define _RWStl_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <Handle_StlMesh_Mesh.hxx>
#include <Handle_Message_ProgressIndicator.hxx>
class StlMesh_Mesh;
class OSD_Path;
class Message_ProgressIndicator;


//! This package contains the methods to be used in
//! the Stereo Lithograpy Application. The main
//! features of this application are ,starting from a
//! Shape :
//! - mesh this shape with a maximun tolerance,
//! - display the meshing,
//! - write the meshing in a file (binary or ascii),
//! - read of file (binary or ascii) and display it,
//! - translate a binary file to an ascii file,
//! - translate an ascii file to an binary file.
class RWStl 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! write the meshing in a file following the
  //! binary format of an STL file.
  //! Returns false if the cannot be opened;
  Standard_EXPORT static   Standard_Boolean WriteBinary (const Handle(StlMesh_Mesh)& aMesh, const OSD_Path& aPath, const Handle(Message_ProgressIndicator)& aProgInd = NULL) ;
  
  //! write the meshing in a file following the
  //! Ascii  format of an STL file.
  //! Returns false if the cannot be opened;
  Standard_EXPORT static   Standard_Boolean WriteAscii (const Handle(StlMesh_Mesh)& aMesh, const OSD_Path& aPath, const Handle(Message_ProgressIndicator)& aProgInd = NULL) ;
  
  //! This method will chwck if the file is a binary
  //! file or an AsciiFile testing  the 5 first
  //! characters of the file wich are :"solid" in an
  //! ascii file. If we do not find that word we assume
  //! that it is a binary file.
  Standard_EXPORT static   Handle(StlMesh_Mesh) ReadFile (const OSD_Path& aPath, const Handle(Message_ProgressIndicator)& aProgInd = NULL) ;
  
  //! Read a meshing from a binary file
  //! Raises NoMoreObject from Standard if a statement
  //! does not contain the right number of tokens
  //! Raises TypeMisMatch if a token has not the good
  //! type (often real)
  Standard_EXPORT static   Handle(StlMesh_Mesh) ReadBinary (const OSD_Path& aPath, const Handle(Message_ProgressIndicator)& aProgInd = NULL) ;
  
  //! Read a meshing from a binary file
  //! Raises NoMoreObject from Standard if a statement
  //! does not contain the right number of tokens
  //! Raises TypeMisMatch if a token has not the good
  //! type (often real)
  //! Raises MoMoreObject if a file is finished before
  //! having found the word endsolid;
  Standard_EXPORT static   Handle(StlMesh_Mesh) ReadAscii (const OSD_Path& aPath, const Handle(Message_ProgressIndicator)& aProgInd = NULL) ;




protected:





private:





};







#endif // _RWStl_HeaderFile
