/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.util.FileUtil;

public final class ChecksumHelper {
    private static Map algorithms = new HashMap<String, String>();
    private static final char[] CHARS;

    public static void check(File file2, File file3, String string) {
        String string2;
        int n;
        String string3 = FileUtil.readEntirely(new BufferedReader(new FileReader(file3))).trim().toLowerCase(Locale.US);
        if (string3.indexOf(32) >= 0 && (string3.startsWith("md") || string3.startsWith("sha"))) {
            n = string3.lastIndexOf(32);
            string2 = string3.substring(n + 1);
        } else {
            n = string3.indexOf(32);
            if (n != -1) {
                string2 = string3.substring(0, n);
                if (string2.endsWith(":")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = string3.substring(n + 1).toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        if (Character.isWhitespace(cArray[i])) continue;
                        stringBuffer.append(cArray[i]);
                    }
                    string2 = stringBuffer.toString();
                }
            } else {
                string2 = string3;
            }
        }
        String string4 = string;
        String string5 = ChecksumHelper.byteArrayToHexString(ChecksumHelper.compute(file2, string4)).trim().toLowerCase(Locale.US);
        if (!string2.equals(string5)) {
            throw new IOException("invalid " + string + ": expected=" + string2 + " computed=" + string5);
        }
    }

    private static byte[] compute(File file2, String string) {
        FileInputStream fileInputStream = new FileInputStream(file2);
        try {
            int n;
            MessageDigest messageDigest = ChecksumHelper.getMessageDigest(string);
            messageDigest.reset();
            byte[] byArray = new byte[2048];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static boolean isKnownAlgorithm(String string) {
        return algorithms.containsKey(string);
    }

    private static MessageDigest getMessageDigest(String string) {
        String string2 = (String)algorithms.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("unknown algorithm " + string);
        }
        try {
            return MessageDigest.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("unknown algorithm " + string);
        }
    }

    private static String byteArrayToHexString(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length << 1);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)((byte)((byte)(byArray[i] & 0xF0) >>> 4) & 0xF);
            stringBuffer.append(CHARS[by]);
            by = (byte)(byArray[i] & 0xF);
            stringBuffer.append(CHARS[by]);
        }
        return stringBuffer.toString();
    }

    private ChecksumHelper() {
    }

    static {
        algorithms.put("md5", "MD5");
        algorithms.put("sha1", "SHA-1");
        CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

