/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLFRAGMENT_ABSTRACT_LIBRARY_MANAGER_H_
#define _GTLFRAGMENT_ABSTRACT_LIBRARY_MANAGER_H_

#include <GTLFragment/Library.h>

namespace GTLFragment {
  class Library;
  class GTLFRAGMENT_EXPORT AbstractLibrariesManager {
      GTL_NO_COPY(AbstractLibrariesManager)
    protected:
      AbstractLibrariesManager();
      virtual ~AbstractLibrariesManager();
    public:
      /**
       * @return a library if it's already loaded or return 0
       */
      virtual Library* library(const GTLCore::String& name, int _channelsNb) = 0;
      /**
       * Add a directory to the list of directory that get searched for library.
       */
      virtual void addDirectory(const GTLCore::String& directory) = 0;
      /**
       * Load a library with the given name.
       */
      virtual Library* loadLibrary( const GTLCore::String& filename, int _channelsNb) = 0;
      /**
       * @return the type of libraries produced by this LibrariesManager
       */
      virtual Library::Type libraryType() const = 0;
  };
}

#endif
