# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 020-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53783);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 020-1 (php4)";
 script_name(name);

 desc = "The remote host is missing an update to php4
announced via advisory DSA 020-1.

The Zend people have found a vulnerability in older versions of PHP4
(the original advisory speaks of 4.0.4 while the bugs are present in
4.0.3 as well).  It is possible to specify PHP directives on a
per-directory basis which leads to a remote attacker crafting an HTTP
request that would cause the next page to be served with the wrong
values for these directives.  Also even if PHP is installed, it can be
activated and deactivated on a per-directory or per-virtual host basis
using the 'engine=on' or 'engine=off' directive.  This setting can be
leaked to other virtual hosts on the same machine, effectively
disabling PHP for those hosts and resulting in PHP source code being
sent to the client instead of being executed on the server.

We recommend you upgrade your php4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20020-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 020-1 (php4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php4-cgi-gd", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-imap", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-ldap", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-mhash", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-mysql", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-pgsql", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-snmp", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-xml", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pgsql", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xml", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-dev", ver:"4.0.3pl1-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
