# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1808-1 (drupal6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64110);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1808-1 (drupal6)";
 script_name(name);

 desc = "The remote host is missing an update to drupal6
announced via advisory DSA 1808-1.


Markus Petrux discovered a cross-site scripting vulnerability in the
taxonomy module of drupal6, a fully-featured content management
framework. It is also possible that certain browsers using the UTF-7
encoding are vulnerable to a different cross-site scripting
vulnerability.

For the stable distribution (lenny), these problems have been fixed in
version 6.6-3lenny2.

The oldstable distribution (etch) does not contain drupal6.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 6.11-1.1.


We recommend that you upgrade your drupal6 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201808-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1808-1 (drupal6)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"drupal6", ver:"6.6-3lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
