# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 619-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53458);
 script_cve_id("CVE-2004-1125");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 619-1 (xpdf)";
 script_name(name);

 desc = "The remote host is missing an update to xpdf
announced via advisory DSA 619-1.

An iDEFENSE security researcher discovered a buffer overflow in xpdf,
the portable document format (PDF) suite.  A maliciously crafted PDF
file could exploit this problem, resulting in the execution of arbitrary
code.

For the stable distribution (woody) this problem has been fixed in
version 1.00-3.3.

For the unstable distribution (sid) this problem has been fixed in
version 3.00-11.

We recommend that you upgrade your xdpf package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20619-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 619-1 (xpdf)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xpdf-common", ver:"1.00-3.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf", ver:"1.00-3.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf-reader", ver:"1.00-3.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf-utils", ver:"1.00-3.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
