# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-4542 (memcached)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64088);
 script_cve_id("CVE-2009-1255");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Fedora Core 11 FEDORA-2009-4542 (memcached)";
 script_name(name);

 desc = "The remote host is missing an update to memcached
announced via advisory FEDORA-2009-4542.

ChangeLog:

* Wed Apr 29 2009 Paul Lindner  - 1.2.8-1
- Upgrade to memcached-1.2.8
- Addresses CVE-2009-1255

References:

[ 1 ] Bug #498271 - CVE-2009-1255 memcached: ASLR bypass weakness
https://bugzilla.redhat.com/show_bug.cgi?id=498271

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update memcached' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-4542

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-4542 (memcached)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"memcached", rpm:"memcached~1.2.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"memcached-selinux", rpm:"memcached-selinux~1.2.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"memcached-debuginfo", rpm:"memcached-debuginfo~1.2.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
