###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for thunderbird CESA-2007:1083 centos4 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880328);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "CESA", value: "2007:1083");
  script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");
  script_name( "CentOS Update for thunderbird CESA-2007:1083 centos4 x86_64");
  desc = "

  Vulnerability Insight:
  Mozilla Thunderbird is a standalone mail and newsgroup client.
  
  A cross-site scripting flaw was found in the way Thunderbird handled the
  jar: URI scheme. It may be possible for a malicious HTML mail message to
  leverage this flaw, and conduct a cross-site scripting attack against a
  user running Thunderbird. (CVE-2007-5947)
  
  Several flaws were found in the way Thunderbird processed certain malformed
  HTML mail content. A HTML mail message containing malicious content could
  cause Thunderbird to crash, or potentially execute arbitrary code as the
  user running Thunderbird. (CVE-2007-5959)
  
  A race condition existed when Thunderbird set the &quot;window.location&quot;
  property when displaying HTML mail content. This flaw could allow a HTML
  mail message to set an arbitrary Referer header, which may lead to a
  Cross-site Request Forgery (CSRF) attack against websites that rely only on
  the Referer header for protection. (CVE-2007-5960) 
  
  All users of thunderbird are advised to upgrade to these updated packages,
  which contain backported patches to resolve these issues.


  Affected Software/OS:
  thunderbird on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2007-December/014548.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS4")
{

  if(isrpmvuln(pkg:"thunderbird", rpm:"thunderbird~1.5.0.12~7.el4.centos", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
