###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openssl_dos_vuln_lin_jun09.nasl 2694 2009-06-08 12:03:24Z june $
#
# Denial Of Service Vulnerability in OpenSSL June-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

desc1 = "
  Overview: This host has OpenSSL installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  A NULL pointer dereference error in ssl/s3_pkt.c file which does not properly
  check the input packets value via a DTLS ChangeCipherSpec packet that occurs
  before ClientHello.

  Impact:
  Successful exploitation will let the attacker to cause DTLS server crash.

  Impact Level: Application

  Affected Software/OS:
  OpenSSL version prior to 0.9.8i on Linux.

  Fix:
  Upgrade to OpenSSL version 0.9.8i or later
  http://www.openssl.org/source

  *****
  Note: Vulnerability is related to CVE-2009-1386
  *****

  *****
  This might be a False Positive
  Only version check is being done depending on the publicly available OpenSSL packages. 
  Each vendor might have backported versions of the packages.
  *****

  References:
  http://cvs.openssl.org/chngview?cn=17369
  http://www.openwall.com/lists/oss-security/2009/06/02/1
  http://rt.openssl.org/Ticket/Display.html?id=1679&user=guest&pass=guest

  CVSS Score Report:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

desc2 = "
  Overview: This host has OpenSSL installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  A NULL pointer dereference error in dtls1_retrieve_buffered_fragment function
  in ssl/d1_both.c file which does not properly check the input packets value
  via an out-of-sequence DTLS handshake message, related to a 'fragment bug.'.

  Impact:
  Successful exploitation will let the attacker to casue DTLS server crash.

  Impact Level: Application

  Affected Software/OS:
  OpenSSL version prior to 1.0.0 Beta 2 on Linux.

  Fix:
  Upgrade to OpenSSL version 1.0.0 Beta 2
  http://www.openssl.org/source

  *****
  Note: Vulnerability is related to CVE-2009-1387
  *****

  *****
  This might be a False Positive
  Only version check is being done depending on the publicly available OpenSSL packages. 
  Each vendor might have backported versions of the packages.
  *****

  References:
  http://cvs.openssl.org/chngview?cn=17958
  http://www.openwall.com/lists/oss-security/2009/06/02/1
  http://rt.openssl.org/Ticket/Display.html?id=1838&user=guest&pass=guest

  CVSS Score Report:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

if(description)
{
  script_id(800809);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1386");
 script_bugtraq_id(35174);
  script_name("Denial Of Service Vulnerability in OpenSSL June-09 (Linux)");
  script_description(desc1);
  script_summary("Check for the version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_openssl_detect_lin.nasl");
  script_require_keys("OpenSSL/Linux/Ver");
  exit(0);
}


include("version_func.inc");

sslVer = get_kb_item("OpenSSL/Linux/Ver");
if(!sslVer){
  exit(0);
}

sslVer = ereg_replace(pattern:"-", replace:".", string:sslVer);
if(sslVer != NULL)
{
   #Grep for OpenSSL version < 0 0.9.8i
   if(version_is_less(version:sslVer, test_version:"0.9.8i"))
   {
    security_warning(data:string(desc1));
    exit(0);
   }
 
  # Grep for OpenSSL version 0.9.8i < 1.0.0-beta2
  if(version_in_range(version:sslVer, test_version:"0.9.8i",
                      test_version2:"1.0.0.beta1")){
    security_warning(data:string(desc2));
  }
}
