###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_winftp_serv_detect.nasl 928 2009-02-03 16:26:24Z feb $
#
# WinFTP Server Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800345);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("WinFTP Server Version Detection");
  desc = "
  Overview : This script detects the installed version of WinFTP Server and
  sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of WinFTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl", "find_service.nes");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports("Services/ftp", 21);
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("ftp_func.inc");
include("secpod_smb_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)){
  exit(0);
}

if("WinFtp Server" >!< get_ftp_banner(port:ftpPort)){
  exit(0);
}

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

regPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                         item:"ProgramFilesDir");
if(!regPath){
  exit(0);
}

exePath = regPath + "\WinFTP Server\WFTPSRV.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

winFtpVer = GetVer(share:share, file:file);
if(winFtpVer){
  set_kb_item(name:"WinFTP/Server/Ver", value:winFtpVer);
  security_note(data:"WinFTP Server version " + winFtpVer +
            " running at location " + exePath +  " was detected on the host");
}
