#
# This script was written by Noam Rathaus and upgraded by Alexei Chicheev for mod_rootme v.0.3 detection 
#
# GPLv2
#

if(description)
{
  script_id(13644);
  script_version("$Revision: 7517 $");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CAN-1999-0660");
  name = "Apache mod_rootme Backdoor";
  script_name(name);
 
  desc = "
The remote system appears to be running the mod_rootme module,
this module silently allows a user to gain a root shell access
to the machine via HTTP requests.

Solution:
- Remove the mod_rootme module from httpd.conf/modules.conf
- Consider reinstalling the computer, as it is likely to have been 
compromised by an intruder 

Risk factor : High";

  script_description(desc);
 
  summary = "Detect mod_rootme Backdoor";
  script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright("This script is Copyright (C) 2004 Noam Rathaus and upgraded (15.03.2005) by Alexei Chicheev for mod_rootme v.0.3 detection");

  family = "Malware";
  script_family(family);
  script_dependencie("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);
if (! port) exit(0);

if ( report_paranoia < 2 )
{
 banner = get_http_banner(port:port);
 if ( ! banner || "Apache" >!< banner ) exit(0);
}

if(!get_port_state(port))exit(0);
if ( get_kb_item("Services/www/" + port + "/embedded" ) ) exit(0);

soc = open_sock_tcp(port);
if (soc)
{
 # Syntax for this Trojan is essential... normal requests won't work...
 # We need to emulate a netcat, slow sending, single line each time, unlike HTTP that can
 # receive everything as a block
 send(socket:soc, data:string("GET root HTTP/1.0\n",
                              "Host: ", get_host_name(),"\r\n"));
 sleep(1);
 send(socket:soc, data:string("\n"));
 sleep(1);
 res_vx = recv(socket:soc, length:1024);
 if ( ! res_vx ) exit(0);
 send(socket:soc, data:string("id\r\n",
                              "Host: ", get_host_name(), "\r\n"));
 res = recv(socket:soc, length:1024);
 if (res == NULL) exit(0);
 if (ereg(pattern:"^uid=[0-9]+\(root\)", string:res) && ereg(pattern:"^rootme-[0-9].[0-9] ready", string:res_vx))
 {
  send(socket:soc, data:string("exit\r\n",
                               "Host: ", get_host_name(), "\r\n")); # If we don't exit we can cause Apache to crash
  security_hole(port:port);
 }
 close(soc);
}

