#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  This script is released under the GNU GPL v2
#
# kst-depend-misc

if(description)
{
 script_id(80020);
 script_version("$Revision: 1.4 $");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");

 script_cve_id("CVE-2007-0563","CVE-2007-0564");
 script_bugtraq_id(22184);
 script_xref(name:"OSVDB", value:"32959");
 script_xref(name:"OSVDB", value:"32960");
 script_xref(name:"OSVDB", value:"32961");

 name = "Symantec Web Security flaws";

 script_name(name);
 
 desc = "
Synopsis :

The remote service is affected by multiple vulnerabilities. 

Description :

According to its banner, the version of Symantec Web Security on the
remote host is vulnerable to denial of service and cross-site
scripting attacks. 

Solution :

Upgrade at least to version 3.0.1.85. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";

 script_description(desc);
 
 summary = "Checks for SWS flaws";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2007 David Maciejak");
 
 family = "Web application abuses";
 script_family(family);
 script_dependencie("symantec_ws_detection.nasl");
 script_require_ports("Services/www", 8002);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if ( ! port ) port = 8002;
if(!get_port_state(port)) exit(0);

version=get_kb_item(string("www/", port, "/SWS"));
if (version) {
	if (ereg(pattern:"^(2\.|3\.0\.(0|1\.([0-9]|[1-7][0-9]|8[0-4])$))", string:version))
	{
		security_warning(port);
		set_kb_item(name: 'www/'+port+'/XSS', value: TRUE);
	}
}
