#
# This script was written by Patrick Naubert
# This is version 2.0 of this script.
#
# Modified by Georges Dagousset <georges.dagousset@alert4web.com> :
#	- warning with the version
#	- detection of other version
#	- default port for single test
#
# See the Nessus Scripts License for details
#

 desc = "
Synopsis :

The remote host is running a remote display software (VNC)

Description :

The remote server is running VNC, a software which ermits a 
console to be displayed remotely.

This allows authenticated users of the remote host to take its 
control remotely.

Solution : 

Make sure the use of this software is done in accordance with your
corporate security policy, filter incoming traffic to this port.

Risk factor : 

None";

if(description)
{
 script_id(10342);
 script_version ("$Revision: 7591 $");
 script_tag(name:"risk_factor", value:"None");
 name = "Check for VNC";
 script_name(name);
 





 script_description(desc);
 
 summary = "Checks for VNC";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2000 Patrick Naubert");
 script_family( "Service detection");
 script_dependencie("find_service1.nasl");
 script_require_ports("Services/vnc", 5900, 5901, 5902);
 exit(0);
}

#
# The script code starts here
#

function probe(port)
{
 # if (! get_port_state(port)) return 0;
 r = get_kb_item("FindService/tcp/" + port + "/spontaneous");
 if ( ! r ) return 0;
 version = egrep(pattern:"^RFB 00[0-9]\.00[0-9]",string:r);
 if(version)
   {
      report = desc + '\n\nPlugin output :\nThe version of the VNC protocol is : ' + version;
      security_note(port:port, data:report);
   }
}

port = get_kb_item("Services/vnc");
if(port)probe(port:port);
else
{
 for (port=5900; port <= 5902; port = port+1) {
  probe(port:port);
 }
}
