//*******************************************************************
// Copyright (C) 2000 ImageLinks Inc.
//
// License:  LGPL
// 
// See LICENSE.txt file in the top level directory for more details.
//
// Author:  Garrett Potts
//
//*******************************************************************
//  $Id: orthoigen.cpp 13025 2008-06-13 17:06:30Z sbortman $

#include <time.h>
#include <iostream>
#include <cstdlib>
#include <list>
#include <fstream>
using namespace std;
#include <ossim/parallel/ossimOrthoIgen.h>
#include <ossim/parallel/ossimMpi.h>
#include <ossim/init/ossimInit.h>
#include <ossim/base/ossimNotifyContext.h>
#include <ossim/base/ossimArgumentParser.h>
#include <ossim/base/ossimApplicationUsage.h>
#include <ossim/base/ossimTrace.h>
#include <ossim/base/ossimRefPtr.h>
static ossimTrace traceDebug("orthoigen:debug");

int main(int argc, char* argv[])
{
   ossimMpi::instance()->initialize(&argc, &argv);
   ossimRefPtr<ossimOrthoIgen> orthoIgen = new ossimOrthoIgen;
   ossimArgumentParser argumentParser(&argc, argv);
   ossimInit::instance()->addOptions(argumentParser);
   ossimInit::instance()->initialize(argumentParser);
   argumentParser.getApplicationUsage()->setApplicationName(argumentParser.getApplicationName());
   
   argumentParser.getApplicationUsage()->setDescription(argumentParser.getApplicationName() +" takes a spec file as input and produces a product");

   orthoIgen->addArguments(argumentParser);
   argumentParser.getApplicationUsage()->addCommandLineOption("-h or --help","Display this information");
   argumentParser.getApplicationUsage()->addCommandLineOption("--enable-entry-decoding","A filename can be separated by a | and a number (NO space).  "
                                                              "Example: a.toc|0 will do entry 0 of a.toc file and on unix you might want to use a \\ since "
                                                              "the separator is a pipe sign.  Example: ./a.toc\\|0 will do entry 0 of a.toc");
   
   if (argumentParser.read("-h") || argumentParser.read("--help") || (argumentParser.argc() == 1))
   {
      argumentParser.getApplicationUsage()->write(ossimNotify(ossimNotifyLevel_INFO));
      ossimMpi::instance()->finalize();
      ossimInit::instance()->finalize();
      exit(0);
   }
   bool enableEntryDecoding = false;
   if(argumentParser.read("--enable-entry-decoding"))
   {
      enableEntryDecoding = true;
   }
   orthoIgen->initialize(argumentParser);
   argumentParser.reportRemainingOptionsAsUnrecognized();
   if (argumentParser.errors())
   {
      argumentParser.writeErrorMessages(ossimNotify(ossimNotifyLevel_WARN));
      ossimMpi::instance()->finalize();
      exit(0);
   }
   double start=ossimMpi::instance()->getTime(), stop=0;
   
   orthoIgen->clearFilenameList();
   orthoIgen->addFiles(argumentParser, enableEntryDecoding);
   orthoIgen->execute();
   if(ossimMpi::instance()->getRank() == 0)
   {
      stop = ossimMpi::instance()->getTime();
      ossimNotify(ossimNotifyLevel_NOTICE)
         << "Time elapsed: " << (stop-start)
         << std::endl;
   }
   ossimMpi::instance()->finalize();

   return 0;
}
