/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.Maths;
import weka.core.matrix.Matrix;

public class QRDecomposition
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -5013090736132211418L;
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(Matrix A) {
        this.QR = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.Rdiag = new double[this.n];
        for (int k = 0; k < this.n; ++k) {
            int i;
            double nrm = 0.0;
            for (i = k; i < this.m; ++i) {
                nrm = Maths.hypot(nrm, this.QR[i][k]);
            }
            if (nrm != 0.0) {
                if (this.QR[k][k] < 0.0) {
                    nrm = -nrm;
                }
                for (i = k; i < this.m; ++i) {
                    double[] dArray = this.QR[i];
                    int n = k;
                    dArray[n] = dArray[n] / nrm;
                }
                double[] dArray = this.QR[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (int j = k + 1; j < this.n; ++j) {
                    int i2;
                    double s = 0.0;
                    for (i2 = k; i2 < this.m; ++i2) {
                        s += this.QR[i2][k] * this.QR[i2][j];
                    }
                    s = -s / this.QR[k][k];
                    for (i2 = k; i2 < this.m; ++i2) {
                        double[] dArray2 = this.QR[i2];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + s * this.QR[i2][k];
                    }
                }
            }
            this.Rdiag[k] = -nrm;
        }
    }

    public boolean isFullRank() {
        for (int j = 0; j < this.n; ++j) {
            if (this.Rdiag[j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getH() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] H = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                H[i][j] = i >= j ? this.QR[i][j] : 0.0;
            }
        }
        return X;
    }

    public Matrix getR() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] R = X.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                R[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiag[i] : 0.0);
            }
        }
        return X;
    }

    public Matrix getQ() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] Q = X.getArray();
        for (int k = this.n - 1; k >= 0; --k) {
            for (int i = 0; i < this.m; ++i) {
                Q[i][k] = 0.0;
            }
            Q[k][k] = 1.0;
            for (int j = k; j < this.n; ++j) {
                int i;
                if (this.QR[k][k] == 0.0) continue;
                double s = 0.0;
                for (i = k; i < this.m; ++i) {
                    s += this.QR[i][k] * Q[i][j];
                }
                s = -s / this.QR[k][k];
                for (i = k; i < this.m; ++i) {
                    double[] dArray = Q[i];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i][k];
                }
            }
        }
        return X;
    }

    public Matrix solve(Matrix B) {
        int j;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B.getColumnDimension();
        double[][] X = B.getArrayCopy();
        for (k = 0; k < this.n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < this.m; ++i) {
                    s += this.QR[i][k] * X[i][j];
                }
                s = -s / this.QR[k][k];
                for (i = k; i < this.m; ++i) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.Rdiag[k];
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.QR[i][k];
                }
            }
        }
        return new Matrix(X, this.n, nx).getMatrix(0, this.n - 1, 0, nx - 1);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

