/* PSPP - a program for statistical analysis.
   Copyright (C) 2009, 2011 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef OUTPUT_CHARTS_SCREE_H
#define OUTPUT_CHARTS_SCREE_H 1

#include <gsl/gsl_vector.h>
#include "output/chart.h"

/* A scree plot. */
struct scree
  {
    struct chart chart;
    gsl_vector *eval;
    char *xlabel;
  };

/* Create a "Scree Plot" of EIGENVALUES with LABEL on the X Axis */
struct scree *scree_create (const gsl_vector *eigenvalues, const char *label);

/* Return the chart underlying SCREE */
struct chart *scree_get_chart (struct scree *scree);

/* This boilerplate for scree, a subclass of chart, was
   autogenerated by mk-class-boilerplate. */

#include <assert.h>
#include "libpspp/cast.h"

extern const struct chart_class scree_class;

/* Returns true if SUPER is a scree, otherwise false. */
static inline bool
is_scree (const struct chart *super)
{
  return super->class == &scree_class;
}

/* Returns SUPER converted to scree.  SUPER must be a scree, as
   reported by is_scree. */
static inline struct scree *
to_scree (const struct chart *super)
{
  assert (is_scree (super));
  return UP_CAST (super, struct scree, chart);
}

/* Returns INSTANCE converted to chart. */
static inline struct chart *
scree_super (const struct scree *instance)
{
  return CONST_CAST (struct chart *, &instance->chart);
}

/* Increments INSTANCE's reference count and returns INSTANCE. */
static inline struct scree *
scree_ref (const struct scree *instance)
{
  return to_scree (chart_ref (&instance->chart));
}

/* Decrements INSTANCE's reference count, then destroys INSTANCE if
   the reference count is now zero. */
static inline void
scree_unref (struct scree *instance)
{
  chart_unref (&instance->chart);
}

/* Returns true if INSTANCE's reference count is greater than 1,
   false otherwise. */
static inline bool
scree_is_shared (const struct scree *instance)
{
  return chart_is_shared (&instance->chart);
}

static inline void
scree_submit (struct scree *instance)
{
  chart_submit (&instance->chart);
}

#endif /* output/charts/scree.h */
