# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TagResourceContract(Model):
    """TagResource contract properties.

    All required parameters must be populated in order to send to Azure.

    :param tag: Required. Tag associated with the resource.
    :type tag:
     ~azure.mgmt.apimanagement.models.TagTagResourceContractProperties
    :param api: Api associated with the tag.
    :type api:
     ~azure.mgmt.apimanagement.models.ApiTagResourceContractProperties
    :param operation: Operation associated with the tag.
    :type operation:
     ~azure.mgmt.apimanagement.models.OperationTagResourceContractProperties
    :param product: Product associated with the tag.
    :type product:
     ~azure.mgmt.apimanagement.models.ProductTagResourceContractProperties
    """

    _validation = {
        'tag': {'required': True},
    }

    _attribute_map = {
        'tag': {'key': 'tag', 'type': 'TagTagResourceContractProperties'},
        'api': {'key': 'api', 'type': 'ApiTagResourceContractProperties'},
        'operation': {'key': 'operation', 'type': 'OperationTagResourceContractProperties'},
        'product': {'key': 'product', 'type': 'ProductTagResourceContractProperties'},
    }

    def __init__(self, *, tag, api=None, operation=None, product=None, **kwargs) -> None:
        super(TagResourceContract, self).__init__(**kwargs)
        self.tag = tag
        self.api = api
        self.operation = operation
        self.product = product
