# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Project(Model):
    """Represents a project.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Gets the project id.
    :vartype id: str
    :param name: Required. Gets or sets the name of the project.
    :type name: str
    :param description: Required. Gets or sets the description of the project.
    :type description: str
    :param settings: Required. Gets or sets the project settings.
    :type settings:
     ~azure.cognitiveservices.vision.customvision.training.models.ProjectSettings
    :ivar created: Gets the date this project was created.
    :vartype created: datetime
    :ivar last_modified: Gets the date this project was last modified.
    :vartype last_modified: datetime
    :ivar thumbnail_uri: Gets the thumbnail url representing the image.
    :vartype thumbnail_uri: str
    :ivar dr_mode_enabled: Gets if the DR mode is on.
    :vartype dr_mode_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'required': True},
        'description': {'required': True},
        'settings': {'required': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'thumbnail_uri': {'readonly': True},
        'dr_mode_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'settings': {'key': 'settings', 'type': 'ProjectSettings'},
        'created': {'key': 'created', 'type': 'iso-8601'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'thumbnail_uri': {'key': 'thumbnailUri', 'type': 'str'},
        'dr_mode_enabled': {'key': 'drModeEnabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Project, self).__init__(**kwargs)
        self.id = None
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.settings = kwargs.get('settings', None)
        self.created = None
        self.last_modified = None
        self.thumbnail_uri = None
        self.dr_mode_enabled = None
