# Cdn

> see https://aka.ms/autorest

This is the AutoRest configuration file for Cdn.



---
## Getting Started
To build the SDK for Cdn, simply [Install AutoRest](https://github.com/Azure/autorest/blob/master/docs/install/readme.md) and in this folder, run:

> `autorest`

To see additional help and options, run:

> `autorest --help`
---

## Configuration



### Basic Information
These are the global settings for the Cdn API.

``` yaml
title: CdnManagementClient
description: Cdn Management Client
openapi-type: arm
tag: package-2019-06
```

### Tag: package-2019-06

These settings apply only when `--tag=package-2019-06` is specified on the command line.

``` yaml $(tag) == 'package-2019-06'
input-file:
- Microsoft.Cdn/preview/2019-06-15-preview/cdn.json
- Microsoft.Cdn/preview/2019-06-15-preview/cdnwebapplicationfirewall.json
```


---
# Code Generation


## Swagger to SDK

This section describes what SDK should be generated by the automatic system.
This is not used by Autorest itself.

``` yaml $(swagger-to-sdk)
swagger-to-sdk:
  - repo: azure-sdk-for-python-track2
  - repo: azure-sdk-for-java
  - repo: azure-sdk-for-go
  - repo: azure-sdk-for-net
  - repo: azure-sdk-for-js
  - repo: azure-sdk-for-node
  - repo: azure-sdk-for-ruby
    after_scripts:
      - bundle install && rake arm:regen_all_profiles['azure_mgmt_cdn']
```

## Python

See configuration in [readme.python.md](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/mgmt/swagger/single_api/readme.python.md)
