/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATTEXTWGT_H
#define CHATTEXTWGT_H

#include <QWidget>
#include <QLayout>
#include <QHBoxLayout>
#include <QStringList>
#include <QList>
#include <QDomDocument>
#include <QFile>
#include <QKeyEvent>

#include "smileswgt.h"
#include "textbrowser.h"

struct Smile;
class  Message;
struct AnimatedSmile;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class ChatTextWgt : public QWidget
{
  Q_OBJECT
  private:
    QList<AnimatedSmile*> m_animatedSmiles;
    TextBrowser* m_text;

    static QList<Smile> m_smiles;
    QList<Smile>*       m_smilesFromSender;

    int                 m_keepAnimations;

  private:
    static void    addSmile   (const QStringList & smiles, const QString & name);
    void           insertSmile(QTextCursor cursor, const QString & smile);
    void           processLinks(QTextDocument*);
//     void           processSmiles();
    bool insertSmileFromSender(QTextCursor cursor, const QString & smile);
    bool insertSmileFromLocalTheme(QTextCursor cursor, const QString & smile);

  public:
    ChatTextWgt(QWidget *parent = 0);
    ~ChatTextWgt();

    QString nextSmile (const QString &) const;
    static QString nextSmile  (const QString &, Smile**);
    static QList<Smile> smiles(){return m_smiles;}
    static void     initSmiles(const QString &);

    QString toPlainText() const {return m_text->toPlainText();}
    QTextEdit* text()     const {return m_text;}

    void setMsg(const QString & msg);
    void setSmilesFromSender(QList<Smile>*);

    void stopAnimations();
    void setAnimationsPaused(bool);
    void setKeepAnimations(int n){m_keepAnimations = n;}

  public slots:
    void clear(){m_text->clear();}
    void addMsg(const Message* msg);
    void setAnimations();
    void playPauseAnimations(bool);

};

#endif
